/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.core_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core_gui.UI2ElementButtonTouch;
import baltorogames.core_gui.UIAnimatedButtonV;
import baltorogames.core_gui.UIButton;
import baltorogames.core_gui.UIScreen;
import baltorogames.graphic2d.CGTexture;
import baltorogames.system.ObjectsCache;
import java.util.Vector;

public abstract class UIListButtonAnimated
extends UIScreen {
    private final int UP_ARROW_ID;
    private final int DOWN_ARROW_ID;
    public static final int START_ITEM_ID = 1000;
    protected Vector items = new Vector();
    private int wndStartIndex = 0;
    private int wndEndIndex = 0;
    protected boolean enableSelection = true;
    protected int currentItem = 0;
    protected int elementsOnScreen = 0;

    public UIListButtonAnimated() {
        this.UP_ARROW_ID = 100;
        this.DOWN_ARROW_ID = 101;
        this.showScrollbars = false;
        this.clientAreaHeight = this.height;
        this.wndStartIndex = 0;
        this.currentItem = 0;
        this.elementsOnScreen = this.wndEndIndex = this.clientAreaHeight / 31;
        this.AddArrows();
    }

    protected void moveUp() {
        int step = 1;
        if (this.currentItem > 0) {
            int prevItem = this.currentItem;
            this.currentItem -= step;
            this.currentItemChanged(prevItem, this.currentItem);
            if (this.currentItem < this.wndStartIndex) {
                this.wndStartIndex -= step;
                this.wndEndIndex -= step;
                if (this.wndStartIndex < 0) {
                    this.wndEndIndex += -1 * this.wndStartIndex;
                    this.wndStartIndex = 0;
                }
            }
        } else {
            int numElements = this.items.size();
            this.currentItem = numElements - 1;
            this.wndEndIndex = this.currentItem + 1;
            this.wndStartIndex = this.wndEndIndex - this.elementsOnScreen;
            if (this.wndStartIndex < 0) {
                this.wndStartIndex = 0;
                this.wndEndIndex = this.elementsOnScreen;
            }
        }
    }

    public void moveDown() {
        int step = 1;
        int numElements = this.items.size();
        if (this.currentItem < numElements - 1) {
            int prevItem = this.currentItem;
            this.currentItem += step;
            this.currentItemChanged(prevItem, this.currentItem);
            if (this.currentItem >= this.wndEndIndex) {
                this.wndStartIndex += step;
                this.wndEndIndex += step;
            }
        } else {
            this.wndStartIndex = 0;
            this.currentItem = 0;
            this.wndEndIndex = this.elementsOnScreen;
        }
    }

    public void draw() {
    }

    public void onUpdate(int deltaTime) {
        super.onUpdate(deltaTime);
        this.ActualizeList();
        this.UnvisibleAll();
        int fontHeight = 31;
        int offset = this.clientAreaHeight - this.items.size() * fontHeight;
        if (offset < 0) {
            offset = this.clientAreaHeight - (this.wndEndIndex - this.wndStartIndex) * fontHeight;
            offset /= 2;
        } else {
            offset /= 2;
        }
        for (int i = this.wndStartIndex; i < this.wndEndIndex && i < this.items.size(); ++i) {
            int yPosition = offset + (this.positionY + this.clientAreaY) + (i - this.wndStartIndex) * fontHeight;
            UI2ElementButtonTouch item = (UI2ElementButtonTouch)this.items.elementAt(i);
            item.setVisible(true);
            item.setTop(yPosition);
        }
        if (this.wndStartIndex == 0) {
            this.findByID(100).setVisible(false);
        } else {
            this.findByID(100).setVisible(true);
        }
        if (this.wndEndIndex >= this.items.size()) {
            this.findByID(101).setVisible(false);
        } else {
            this.findByID(101).setVisible(true);
        }
    }

    protected void UnvisibleAll() {
        int nS = this.items.size();
        for (int i = 0; i < nS; ++i) {
            ((UI2ElementButtonTouch)this.items.elementAt(i)).setVisible(false);
        }
    }

    public void setInitPos() {
        if (this.findByID(100) != null) {
            this.findByID(100).setVisible(false);
        }
        if (this.findByID(101) != null) {
            this.findByID(101).setVisible(false);
        }
        switch (UI2ElementButtonTouch.typeOfAnimation) {
            case 1: {
                int nFirstInitPosX = 0;
                if (this.findByID(1000) != null) {
                    nFirstInitPosX -= this.findByID((int)1000).textures[0].GetWidth();
                }
                for (int i = 0; i < this.items.size(); ++i) {
                    if (this.findByID(1000 + i) == null) continue;
                    this.findByID(1000 + i).setInitLeft(nFirstInitPosX - i * 2 * ApplicationData.screenWidth / 10);
                }
                break;
            }
            case 0: {
                int nFirstInitPosX = ApplicationData.screenWidth / 2;
                if (this.findByID(1000) != null) {
                    nFirstInitPosX += this.findByID((int)1000).textures[0].GetWidth();
                }
                for (int i = 0; i < this.items.size(); ++i) {
                    if (this.findByID(1000 + i) == null) continue;
                    this.findByID(1000 + i).setInitLeft(nFirstInitPosX + i * 2 * ApplicationData.screenWidth / 10);
                }
                break;
            }
        }
    }

    public void autoSize() {
        this.clientAreaX = 0;
        this.clientAreaWidth = this.width;
        this.clientAreaY = 0;
        this.clientAreaHeight = this.height;
    }

    public boolean leftSoftButton() {
        return false;
    }

    public boolean rightSoftButton() {
        return false;
    }

    public abstract void currentItemChanged(int var1, int var2);

    public abstract void currentItemSelected(int var1);

    public void clearList() {
        this.items.removeAllElements();
        this.removeButtons(1000);
    }

    public void append(String newItem, int BUTTON_LABEL) {
        boolean isOdd = this.items.size() % 2 == 0;
        CGTexture selectionYes = isOdd ? ObjectsCache.menuListItemSelect : ObjectsCache.menuListItemSelect;
        CGTexture selectionNo = isOdd ? ObjectsCache.menuListItem : ObjectsCache.menuListItem;
        this.append(newItem, selectionNo, selectionYes, selectionNo, BUTTON_LABEL, false);
    }

    public void append(String newItem, int BUTTON_LABEL, boolean blink) {
        boolean isOdd = this.items.size() % 2 == 0;
        CGTexture selectionYes = isOdd ? ObjectsCache.menuListItemSelect : ObjectsCache.menuListItemSelect;
        CGTexture selectionNo = isOdd ? ObjectsCache.menuListItem : ObjectsCache.menuListItem;
        this.append(newItem, selectionNo, selectionYes, selectionNo, BUTTON_LABEL, blink);
    }

    public void append(String newItem, CGTexture imgNormal, CGTexture imgSelect, CGTexture imgInactive, int BUTTON_LABEL, boolean blink) {
        int nNewID = this.items.size() + 1000;
        int left = 0;
        if (imgNormal != null) {
            left = ApplicationData.screenWidth - imgNormal.GetWidth() - imgNormal.GetWidth() / 15;
        }
        UI2ElementButtonTouch b = new UI2ElementButtonTouch(left, 0, imgNormal, imgSelect, imgInactive, BUTTON_LABEL, nNewID);
        b.setCaption(newItem);
        b.setFontID(0);
        b.setBlink(blink);
        this.addButton(b);
        this.items.addElement(b);
    }

    public void append(String newItem) {
        boolean isOdd = this.items.size() % 2 == 0;
        CGTexture selectionYes = isOdd ? ObjectsCache.menuListItemSelect : ObjectsCache.menuListItemSelect;
        CGTexture selectionNo = isOdd ? ObjectsCache.menuListItem : ObjectsCache.menuListItem;
        this.append(newItem, selectionNo, selectionYes, selectionNo, false);
    }

    public void append(String newItem, boolean blink) {
        boolean isOdd = this.items.size() % 2 == 0;
        CGTexture selectionYes = isOdd ? ObjectsCache.menuListItemSelect : ObjectsCache.menuListItemSelect;
        CGTexture selectionNo = isOdd ? ObjectsCache.menuListItem : ObjectsCache.menuListItem;
        this.append(newItem, selectionNo, selectionYes, selectionNo, blink);
    }

    public void append(String newItem, CGTexture imgNormal, CGTexture imgSelect, CGTexture imgInactive, boolean blink) {
        int nNewID = this.items.size() + 1000;
        int left = 0;
        if (imgNormal != null) {
            left = ApplicationData.screenWidth - imgNormal.GetWidth() - imgNormal.GetWidth() / 15;
        }
        UI2ElementButtonTouch b = new UI2ElementButtonTouch(left, 0, imgNormal, imgSelect, imgInactive, -1, nNewID);
        b.setCaption(newItem);
        b.setFontID(0);
        b.setBlink(blink);
        this.addButton(b);
        this.items.addElement(b);
    }

    public boolean actionSoftButton(int nID, boolean pressed) {
        if (pressed) {
            UIButton button = this.findByID(nID);
            this.unselectAllButtons();
            button.setSelect(true);
            if (nID >= 1000) {
                this.currentItem = nID - 1000;
            }
            return true;
        }
        if (nID == 100) {
            this.onUpAction();
            return true;
        }
        if (nID == 101) {
            this.onDownAction();
            return true;
        }
        return false;
    }

    public boolean selectUpAction() {
        UIButton b = this.findByID(100);
        if (b != null) {
            b.setSelect(true);
        }
        return true;
    }

    public boolean selectDownAction() {
        UIButton b = this.findByID(101);
        if (b != null) {
            b.setSelect(true);
        }
        return true;
    }

    public boolean onUpAction() {
        if (this.enableSelection) {
            this.moveUp();
        }
        return true;
    }

    public boolean onDownAction() {
        if (this.enableSelection) {
            this.moveDown();
        }
        return true;
    }

    public boolean onFireAction() {
        if (this.enableSelection && this.currentItem != -1) {
            this.currentItemSelected(this.currentItem);
        }
        return true;
    }

    public void ActualizeList() {
        this.uncheckAllButtons();
        UIButton b = this.findByID(1000 + this.currentItem);
        if (b != null) {
            b.setCheck(true);
        }
    }

    protected void AddArrows() {
        boolean isDrawArrows = true;
        int fontHeight = 31;
        int offset = this.clientAreaHeight;
        if (offset < 0) {
            offset = this.clientAreaHeight - (this.wndEndIndex - this.wndStartIndex) * fontHeight;
            offset /= 2;
        } else {
            offset /= 2;
            isDrawArrows = false;
        }
        int nUpArrowY = this.positionY - fontHeight / 2 - fontHeight / 10;
        int nDownArrowY = this.positionY + this.height - fontHeight / 2 + fontHeight / 10;
        int x = ApplicationData.screenWidth / 2 - ObjectsCache.arrowUp.GetWidth() / 2;
        int y = nUpArrowY;
        UIAnimatedButtonV rightB = new UIAnimatedButtonV(x, y, ObjectsCache.arrowUp, ObjectsCache.arrowUp_a, 100);
        rightB.setScreen(this);
        rightB.setAnimDir(1);
        this.addButton(rightB);
        rightB.setVisible(isDrawArrows);
        y = nDownArrowY;
        UIAnimatedButtonV leftB = new UIAnimatedButtonV(x, y, ObjectsCache.arrowDown, ObjectsCache.arrowDown_a, 101);
        leftB.setScreen(this);
        leftB.setAnimDir(-1);
        this.addButton(leftB);
        leftB.setVisible(isDrawArrows);
    }

    public void setSoftButtonImage(CGTexture ok_left_normal, CGTexture ok_left_select, CGTexture cancel_right_normal, CGTexture cancel_right_select) {
        super.setSoftButtonImage(ok_left_normal, ok_left_select, cancel_right_normal, cancel_right_select);
        if (ApplicationData.isTouchScreen) {
            this.removeByID(UIScreen.ID_BUTTON_OK);
        }
    }
}

