/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.core.ApplicationData;
import baltorogames.core.Utils;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.system.ObjectsCache;
import baltorogames.system.Options;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class HUD {
    private static int lightId = 0;
    public static int nitroIconX;
    public static int nitroIconY;
    public static int leftIconX;
    public static int leftIconY;
    public static int rightIconX;
    public static int rightIconY;
    public static int downIconX;
    public static int downIconY;
    public static Image nitroDiod;
    public static CGTexture timerIcon;
    public static CGTexture txtBg;
    public static CGTexture m_BoostIcon;
    public static CGTexture m_LeftIcon;
    public static CGTexture m_RightIcon;
    public static CGTexture m_DownIcon;
    public static Vector tapToStartText;
    public static Vector tapToBoostText;
    private static long nitroLevel;
    private static long _currentTime;
    private static int timeStringMaxW;
    public static long m_Display1SecStartTime;
    private static final int HUD_Y_ICONS_BASELINE = 1;
    private static StringBuffer m_sb;
    public static boolean disableHUD;
    public static boolean disableHUDStrings;
    public static long _lastBestTime;

    public static void setLight(int id) {
        lightId = id;
    }

    public static void reset() {
        nitroLevel = 0L;
        HUD.setCurrentTime(0L);
        HUD.setBestTime(0L);
        m_Display1SecStartTime = 0L;
        nitroIconX = ApplicationData.screenWidth - HUD.m_BoostIcon.m_Image.getWidth();
        nitroIconY = ApplicationData.screenHeight / 2 + 3;
        if (m_LeftIcon != null) {
            leftIconX = HUD.m_LeftIcon.m_Image.getWidth() / 2;
            leftIconY = ApplicationData.screenHeight - 2 * ObjectsCache.menuSbOK.GetHeight() - HUD.m_LeftIcon.m_Image.getHeight();
        }
        if (m_RightIcon != null) {
            rightIconX = ApplicationData.screenWidth - HUD.m_RightIcon.m_Image.getWidth() / 2 - HUD.m_RightIcon.m_Image.getWidth();
            rightIconY = ApplicationData.screenHeight - 2 * ObjectsCache.menuSbOK.GetHeight() - HUD.m_RightIcon.m_Image.getHeight();
        }
        if (m_DownIcon != null) {
            downIconX = ApplicationData.screenWidth / 2 - HUD.m_DownIcon.m_Image.getWidth() / 2;
            downIconY = ApplicationData.screenHeight - HUD.m_DownIcon.m_Image.getHeight();
        }
    }

    public static void Display1Sec() {
        m_Display1SecStartTime = System.currentTimeMillis();
    }

    public static void setNitroLevel(long level) {
        nitroLevel = level;
    }

    public static void update(long deltaTime) {
        if (CGEngine.testApp.GetHumanBolid().GetState() < 2) {
            HUD.setCurrentTime(CGEngine.testApp.GetHumanBolid().GetCurrentLapTime());
        } else {
            HUD.setCurrentTime(CGEngine.testApp.GetHumanBolid().GetLastLapTime());
        }
        HUD.setNitroLevel(CGEngine.testApp.GetHumanBolid().GetCurrentNitroLevel());
    }

    public static void setBestTime(long time) {
        if (_lastBestTime != time) {
            _lastBestTime = time;
        }
    }

    public static void setCurrentTime(long time) {
        _currentTime = time;
    }

    public static void DrawInfoText(Graphics g, Vector textLines, int xPos, int yPos) {
        int fontH = ApplicationData.smallGreyFont.getFontHeight();
        for (int i = 0; i < textLines.size(); ++i) {
            Utils.drawString((String)textLines.elementAt(i), xPos, fontH * i + yPos, 17, 0);
        }
    }

    public static void initStrings() {
        String boostInfoText = ApplicationData.lp.getTranslatedString(Options.languageID, "ID_PRESS_KEY_TO_BOOST");
        tapToBoostText = Utils.splitText(boostInfoText, "+", ApplicationData.screenWidth, 0);
        String startInfoText = ApplicationData.lp.getTranslatedString(Options.languageID, "ID_PRESS_KEY_TO_START");
        tapToStartText = Utils.splitText(startInfoText, "+", ApplicationData.screenWidth, 0);
    }

    public static void initializeSmallResources() {
        timerIcon = TextureManager.AddTexture("/alarmClock.png", 0, 0, null, null);
        txtBg = TextureManager.AddTexture("/bg1.png", 0, 0, null, null);
        m_BoostIcon = TextureManager.AddTexture("/boost.png", 0, 0, null, null);
        if (ApplicationData.isTouchScreen) {
            m_LeftIcon = TextureManager.AddTexture("/Touch_left.png", 0, 0, null, null);
            m_RightIcon = TextureManager.AddTexture("/Touch_right.png", 0, 0, null, null);
            m_DownIcon = TextureManager.AddTexture("/Touch_Brake.png", 0, 0, null, null);
        }
        HUD.initStrings();
    }

    public static void initializeLargeResources() {
        timeStringMaxW = Utils.stringWidth(ApplicationData.defaultFont.encodeDynamicString(" 00:00:00 "), 0);
    }

    private static void drawCheckPointTime(Graphics g, int y) {
        int x = 1 * ApplicationData.screenWidth / 30;
        int w = 1 * ApplicationData.screenWidth / 35;
        int xx = x + w + 4;
        int nFH = ApplicationData.smallGreyFont.getFontHeight();
        if (CGEngine.testApp.GetBolid((int)0).m_fxStartDisplayCheckPointDeltaTime > 0L) {
            int nT = (int)(1000.0f * (float)CGEngine.testApp.GetBolid((int)0).m_fxCheckPointDeltaTime / 4096.0f);
            if (nT > 0) {
                g.setColor(0xFF0000);
            } else {
                g.setColor(65280);
            }
            g.fillRect(xx, y - nFH / 2 - 2, 4 + timeStringMaxW, ApplicationData.smallGreyFont.getFontHeight() + 4);
            Utils.drawTimeString(Math.abs(nT), xx + 2, y - nFH / 2, 20, 0);
        }
    }

    public static void draw(Graphics g) {
        if (!disableHUD) {
            g.setClip(0, 0, ApplicationData.screenWidth, ApplicationData.screenHeight);
            if (!disableHUDStrings) {
                int iconsBaseline = 1;
                Utils.drawTimeString(_currentTime, ApplicationData.screenWidth / 2 - timeStringMaxW / 2 + 2, HUD.timerIcon.m_Image.getHeight() / 2, 20, 0);
                g.drawImage(HUD.timerIcon.m_Image, ApplicationData.screenWidth / 2 - timeStringMaxW / 2 - 2, iconsBaseline, 24);
            }
            Object str = null;
            g.setClip(0, 0, ApplicationData.screenWidth, ApplicationData.screenHeight);
            int CurrentCheckPointPosY = 0;
            if (CGEngine.testApp.GetBolid(0).GetState() == 1) {
                int x = 1 * ApplicationData.screenWidth / 30;
                int y = ApplicationData.screenHeight / 2 - ApplicationData.screenHeight / 3;
                int w = 1 * ApplicationData.screenWidth / 35;
                int h = ApplicationData.screenHeight / 2;
                g.setColor(2886153);
                g.fillRect(x - 2, y - 2, w + 4, h + 4);
                g.setColor(0xFFFFFF);
                g.fillRect(x, y, w, h);
                g.setColor(35857);
                int progress = (int)((long)h * CGEngine.testApp.m_Bolid[0].GetRaceProgress() / 4096L);
                g.fillRect(x, y + h - progress, w, progress);
                if (CGEngine.selectedGameMode == 3) {
                    g.setColor(2886153);
                    for (int i = 1; i < CGEngine.testApp.GetTrack().m_arrCheckPointsDistance.length - 1; ++i) {
                        long fxD = 4096 * CGEngine.testApp.GetTrack().m_arrCheckPointsDistance[i] / CGEngine.testApp.GetTrack().m_arrCheckPointsDistance[CGEngine.testApp.GetTrack().m_arrCheckPointsDistance.length - 1];
                        progress = (int)((long)h * fxD / 4096L) + 1;
                        g.drawLine(x, y + h - progress, x + w, y + h - progress);
                        if (i != CGEngine.testApp.GetBolid((int)0).m_nCheckPointNumber) continue;
                        CurrentCheckPointPosY = y + h - progress;
                    }
                }
            }
            HUD.drawCheckPointTime(g, ApplicationData.screenHeight / 3);
        }
    }

    public static String formatTimeAsc(long time) {
        m_sb.delete(0, m_sb.length());
        long seconds = time / 1000L;
        long m = seconds / 60L;
        long s = seconds % 60L;
        long mm = time % 1000L / 10L;
        if (m < 10L) {
            m_sb.append(0);
        }
        m_sb.append(m);
        m_sb.append(":");
        if (s < 10L) {
            m_sb.append(0);
        }
        m_sb.append(s);
        m_sb.append(":");
        if (mm < 10L) {
            m_sb.append(0);
        }
        m_sb.append(mm);
        return m_sb.toString();
    }

    public static void drawSemaphore(Graphics g) {
        if (lightId <= 0) {
            String str = ApplicationData.defaultFont.encodeDynamicString("3");
            Utils.drawString(str, ApplicationData.screenWidth >> 1, ApplicationData.screenHeight / 3, 17, 0);
        } else if (lightId >= 3) {
            String str = ApplicationData.defaultFont.encodeDynamicString("GO");
            Utils.drawString(str, ApplicationData.screenWidth >> 1, ApplicationData.screenHeight / 3, 17, 0);
        } else if (lightId == 1) {
            String str = ApplicationData.defaultFont.encodeDynamicString("2");
            Utils.drawString(str, ApplicationData.screenWidth >> 1, ApplicationData.screenHeight / 3, 17, 0);
        } else if (lightId == 2) {
            String str = ApplicationData.defaultFont.encodeDynamicString("1");
            Utils.drawString(str, ApplicationData.screenWidth >> 1, ApplicationData.screenHeight / 3, 17, 0);
        }
    }

    static {
        nitroDiod = null;
        timerIcon = null;
        txtBg = null;
        m_BoostIcon = null;
        m_LeftIcon = null;
        m_RightIcon = null;
        m_DownIcon = null;
        tapToStartText = new Vector();
        tapToBoostText = new Vector();
        nitroLevel = 0L;
        _currentTime = 0L;
        timeStringMaxW = 0;
        m_Display1SecStartTime = 0L;
        m_sb = new StringBuffer();
        disableHUD = false;
        disableHUDStrings = false;
        _lastBestTime = 0L;
    }
}

