/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.graphic2d;

import baltorogames.graphic2d.CGTexture;
import java.io.InputStream;
import java.util.Vector;

public class TextureManager {
    private static Vector m_arrTextures = new Vector(3, 2);

    public static CGTexture AddTexture(String szName, int bCreateBuffer, int bCreateMipMaps, int[] arrWidth, int[] arrHeight) {
        CGTexture t = TextureManager.GetTexture(szName);
        if (t != null) {
            return t;
        }
        t = new CGTexture();
        t.m_szName = szName;
        int nRes = 0;
        try {
            nRes = t.Create(szName, bCreateBuffer, bCreateMipMaps, arrWidth, arrHeight);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (nRes == 0) {
            return null;
        }
        m_arrTextures.addElement(t);
        return t;
    }

    public static CGTexture AddTexture(String str) {
        return TextureManager.AddTexture(str, 0, 0, null, null);
    }

    public static CGTexture CreateTexture(String str) {
        return TextureManager.AddTexture(str, 0, 0, null, null);
    }

    public static CGTexture CreateFilteredTexture(String str) {
        return TextureManager.AddTexture(str, 0, 0, null, null);
    }

    public static CGTexture AddTexture(String szName, int bCreateBuffer, int bCreateMipMaps, int[] arrWidth, int[] arrHeight, boolean bNotDelete) {
        CGTexture t = TextureManager.GetTexture(szName);
        if (t != null) {
            return t;
        }
        t = new CGTexture();
        t.m_szName = szName;
        t.m_bLockDelete = true;
        int nRes = 0;
        try {
            nRes = t.Create(szName, bCreateBuffer, bCreateMipMaps, arrWidth, arrHeight);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (nRes == 0) {
            return null;
        }
        m_arrTextures.addElement(t);
        return t;
    }

    public static CGTexture AddTexture(String str, boolean bNotDelete) {
        return TextureManager.AddTexture(str, 0, 0, null, null, bNotDelete);
    }

    public static CGTexture CreateTexture(String str, boolean bNotDelete) {
        return TextureManager.AddTexture(str, 0, 0, null, null, bNotDelete);
    }

    public static CGTexture CreateFilteredTexture(String str, boolean bNotDelete) {
        return TextureManager.AddTexture(str, 0, 0, null, null, bNotDelete);
    }

    public static CGTexture AddTexture(InputStream is, String szName, int bCreateBuffer, int bCreateMipMaps, int[] arrWidth, int[] arrHeight) {
        CGTexture t = TextureManager.GetTexture(szName);
        if (t != null) {
            return t;
        }
        t = new CGTexture();
        t.m_szName = szName;
        int nRes = 0;
        try {
            nRes = t.Create(is, szName, bCreateBuffer, bCreateMipMaps, arrWidth, arrHeight);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (nRes == 0) {
            return null;
        }
        m_arrTextures.addElement(t);
        return t;
    }

    public static void AddTexture(CGTexture t) {
        m_arrTextures.addElement(t);
    }

    public static void AddTexture(CGTexture t, boolean bNotDelete) {
        t.m_bLockDelete = true;
        m_arrTextures.addElement(t);
    }

    public static CGTexture GetTexture(String szName) {
        int nSize = m_arrTextures.size();
        for (int i = 0; i < nSize; ++i) {
            if (!((CGTexture)TextureManager.m_arrTextures.elementAt((int)i)).m_szName.equals(szName)) continue;
            return (CGTexture)m_arrTextures.elementAt(i);
        }
        return null;
    }

    public static void DeleteTexture(CGTexture t) {
        int nSize = m_arrTextures.size();
        for (int i = 0; i < nSize; ++i) {
            if ((CGTexture)m_arrTextures.elementAt(i) != t) continue;
            m_arrTextures.removeElementAt(i);
            return;
        }
    }

    public static void DeleteTexture(String str) {
        int nSize = m_arrTextures.size();
        for (int i = 0; i < nSize; ++i) {
            if (!((CGTexture)TextureManager.m_arrTextures.elementAt((int)i)).m_szName.equals(str)) continue;
            m_arrTextures.removeElementAt(i);
            return;
        }
    }

    public static void ClearAllTextures() {
        int nS = m_arrTextures.size();
        for (int i = nS - 1; i >= 0; --i) {
            ((CGTexture)m_arrTextures.elementAt(i)).Clear();
            m_arrTextures.removeElementAt(i);
        }
        m_arrTextures.removeAllElements();
    }

    public static void ClearTextures() {
        int nS = m_arrTextures.size();
        for (int i = nS - 1; i >= 0; --i) {
            if (!((CGTexture)TextureManager.m_arrTextures.elementAt((int)i)).m_bLockDelete) continue;
            ((CGTexture)m_arrTextures.elementAt(i)).Clear();
            m_arrTextures.removeElementAt(i);
        }
    }

    public static void Destroy() {
        int nS = m_arrTextures.size();
        for (int i = nS - 1; i >= 0; --i) {
            ((CGTexture)m_arrTextures.elementAt(i)).Clear();
            m_arrTextures.removeElementAt(i);
        }
        m_arrTextures.removeAllElements();
    }
}

