/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.core.ApplicationData;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gameplay.CGEngine;
import java.util.Vector;

public class CJAnimation {
    int nTime;
    int nMaxAnimTime = 2000;
    private Vector frames = new Vector();
    int[] arrWidth = new int[CGTexture.m_nNrOfMipMaps == 0 ? 1 : CGTexture.m_nNrOfMipMaps];
    int[] arrHeight;

    public CJAnimation() {
        int i;
        if (CGTexture.m_nNrOfMipMaps == 0) {
            CGTexture.m_nNrOfMipMaps = 1;
        }
        long fxScaleMin = 8L * CGEngine.testApp.GetMaxObjectsDistanceScale() / 10L;
        long fxDeltaScale = (4096L - fxScaleMin) / (long)CGTexture.m_nNrOfMipMaps;
        for (i = 0; i < CGTexture.m_nNrOfMipMaps; ++i) {
            this.arrWidth[i] = (int)(CGEngine.testApp.m_Camera.m_fxCameraScale * 64L * (fxScaleMin + (long)i * fxDeltaScale) / 4096L / 4096L);
        }
        this.arrHeight = new int[CGTexture.m_nNrOfMipMaps == 0 ? 1 : CGTexture.m_nNrOfMipMaps];
        if (CGTexture.m_nNrOfMipMaps == 0) {
            CGTexture.m_nNrOfMipMaps = 1;
        }
        fxScaleMin = 8L * CGEngine.testApp.GetMaxObjectsDistanceScale() / 10L;
        fxDeltaScale = (4096L - fxScaleMin) / (long)CGTexture.m_nNrOfMipMaps;
        for (i = 0; i < CGTexture.m_nNrOfMipMaps; ++i) {
            this.arrHeight[i] = (int)(CGEngine.testApp.m_Camera.m_fxCameraScale * 64L * (fxScaleMin + (long)i * fxDeltaScale) / 4096L / 4096L);
        }
    }

    public void init(int bikeID) {
        int idx = 1;
        String fileToLoad = "/gameplay/fall" + ++bikeID + "/" + idx + ".png";
        while (true) {
            fileToLoad = "/gameplay/fall" + bikeID + "/" + idx + ".png";
            try {
                CGTexture tex = TextureManager.AddTexture(fileToLoad, 0, 1, this.arrWidth, this.arrHeight);
                if (tex == null) break;
                this.frames.addElement(tex);
                System.out.println("Loaded file = " + fileToLoad);
            }
            catch (Exception e) {
                return;
            }
            ++idx;
        }
    }

    public CGTexture getCurrentFrameTexture(int frame) {
        return (CGTexture)this.frames.elementAt(frame);
    }

    public int getNumFrames() {
        return this.frames.size();
    }

    public void startAnim() {
        this.nTime = 0;
    }

    public CGTexture getFrame() {
        int frameID;
        this.nTime += ApplicationData.stepDeltaTime;
        if (this.nTime > this.nMaxAnimTime) {
            this.nTime = this.nMaxAnimTime;
        }
        if ((frameID = (int)((float)this.nTime / (float)this.nMaxAnimTime * (float)(this.frames.size() - 1))) + 1 == this.frames.size() - 1) {
            // empty if block
        }
        return (CGTexture)this.frames.elementAt(frameID);
    }
}

