/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.core_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core.Utils;
import baltorogames.core_gui.UIScreen;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;

public class UIButton {
    protected int top;
    protected int left;
    protected int bottom;
    protected int right;
    protected boolean blinkMode = false;
    protected String caption = null;
    protected int fontID = 0;
    protected String caption2 = null;
    protected String value = null;
    protected int buttonID;
    protected boolean isActive;
    protected boolean isVisible;
    protected boolean isSelected;
    protected boolean isChecked;
    protected boolean isReadyForSelect;
    public int leftstart;
    public int currentleft;
    public int currenttop;
    protected UIScreen ownScreen = null;
    public CGTexture[] textures = null;
    protected CGTexture firstPlaneTexture = null;

    public void setScreen(UIScreen s) {
        this.ownScreen = s;
    }

    public UIButton() {
        this.isSelected = false;
        this.isChecked = false;
        this.isVisible = true;
        this.isActive = true;
    }

    public UIButton(int l, int t, int r, int b, int bID) {
        this.top = t;
        this.left = l;
        this.bottom = b;
        this.right = r;
        this.buttonID = bID;
        this.isSelected = false;
        this.isChecked = false;
        this.isVisible = true;
        this.isActive = true;
    }

    public UIButton(int l, int t, String csNormalTexture, String csSelectTexture, String csInactiveTexture, int bID) {
        this.buttonID = bID;
        this.textures = new CGTexture[3];
        this.textures[0] = TextureManager.AddTexture(csNormalTexture);
        this.textures[1] = TextureManager.AddTexture(csSelectTexture);
        this.textures[2] = TextureManager.AddTexture(csInactiveTexture);
        this.top = t;
        this.left = l;
        this.bottom = this.top + this.textures[0].GetHeight();
        this.right = this.left + this.textures[0].GetWidth();
        this.buttonID = bID;
        this.isSelected = false;
        this.isChecked = false;
        this.isVisible = true;
        this.isActive = true;
    }

    public UIButton(int l, int t, CGTexture NormalTexture, CGTexture SelectTexture, CGTexture InactiveTexture, int bID) {
        this.buttonID = bID;
        this.top = t;
        this.left = l;
        if (NormalTexture != null && SelectTexture != null && InactiveTexture != null) {
            this.textures = new CGTexture[3];
            this.textures[0] = NormalTexture;
            this.textures[1] = SelectTexture;
            this.textures[2] = InactiveTexture;
            this.bottom = this.top + this.textures[0].GetHeight();
            this.right = this.left + this.textures[0].GetWidth();
        } else {
            this.textures = null;
            this.bottom = this.top + 10;
            this.right = this.left + 10;
        }
        this.buttonID = bID;
        this.isSelected = false;
        this.isVisible = true;
        this.isActive = true;
    }

    public void setBlink(boolean b) {
        this.blinkMode = b;
    }

    public void setPosition(int l, int t, int r, int b) {
        this.top = t;
        this.left = l;
        this.bottom = b;
        this.right = r;
    }

    public void setPosition(int l, int t) {
        int w = this.right - this.left;
        int h = this.bottom - this.top;
        this.top = t;
        this.left = l;
        this.bottom = this.top + h;
        this.right = this.left + w;
    }

    public void setLeft(int l) {
        int w = this.right - this.left;
        this.left = l;
        this.right = this.left + w;
    }

    public void setTop(int t) {
        int h = this.bottom - this.top;
        this.top = t;
        this.bottom = this.top + h;
    }

    public void SetFirstPlaneTexture(CGTexture Texture) {
        this.firstPlaneTexture = Texture;
    }

    public void SetFirstPlaneTexture(String csTexture) {
        this.firstPlaneTexture = TextureManager.AddTexture(csTexture);
    }

    public void changeNormalTextures(CGTexture NormalTexture) {
        this.textures[0] = NormalTexture;
        this.bottom = this.top + this.textures[0].GetHeight();
        this.right = this.left + this.textures[0].GetWidth();
    }

    public void setTextures(CGTexture NormalTexture, CGTexture SelectTexture, CGTexture InactiveTexture) {
        this.textures = new CGTexture[3];
        this.textures[0] = NormalTexture;
        this.textures[1] = SelectTexture;
        this.textures[2] = InactiveTexture;
        this.bottom = this.top + this.textures[0].GetHeight();
        this.right = this.left + this.textures[0].GetWidth();
    }

    public void setTextures(String csNormalTexture, String csSelectTexture, String csInactiveTexture) {
        this.textures = new CGTexture[2];
        this.textures[0] = TextureManager.AddTexture(csNormalTexture);
        this.textures[1] = TextureManager.AddTexture(csSelectTexture);
        this.textures[2] = TextureManager.AddTexture(csInactiveTexture);
        this.bottom = this.top + this.textures[0].GetHeight();
        this.right = this.left + this.textures[0].GetWidth();
    }

    public void setCaption(String cs) {
        this.caption = cs;
    }

    public void setCaption2(String cs) {
        this.caption2 = cs;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setFontID(int nID) {
        this.fontID = nID;
    }

    public void setID(int nID) {
        this.buttonID = nID;
    }

    public int getID() {
        return this.buttonID;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setSelect(boolean b) {
        this.isSelected = b;
    }

    public boolean getSelect() {
        return this.isSelected;
    }

    public void setCheck(boolean b) {
        this.isChecked = b;
    }

    public boolean getCheck() {
        return this.isChecked;
    }

    public void setVisible(boolean b) {
        this.isVisible = b;
    }

    public boolean getVisible() {
        return this.isVisible;
    }

    public void setActive(boolean b) {
        this.isActive = b;
    }

    public boolean getActive() {
        return this.isActive;
    }

    public void draw() {
        if (this.isVisible) {
            if (!this.isActive) {
                if (this.textures[2] != null) {
                    Graphic2D.DrawImage(this.textures[2], this.left, this.top, 20);
                }
            } else if (!this.isSelected && this.textures[0] != null) {
                Graphic2D.DrawImage(this.textures[0], this.left, this.top, 20);
            } else if (this.isSelected && this.textures[1] != null) {
                Graphic2D.DrawImage(this.textures[1], this.left, this.top, 20);
            }
            if (this.firstPlaneTexture != null) {
                Graphic2D.DrawImage(this.firstPlaneTexture, this.left, this.top, 20);
            }
            if (this.caption != null && this.caption.length() > 0) {
                if (this.blinkMode) {
                    if (ApplicationData.getAppTime() % 700L < 350L) {
                        int center_x = (this.left + this.right) / 2;
                        Utils.drawString(this.caption, (this.left + this.right) / 2, (this.top + this.bottom) / 2, 3, this.fontID);
                    }
                } else {
                    int center_x = (this.left + this.right) / 2;
                    Utils.drawString(this.caption, (this.left + this.right) / 2, (this.top + this.bottom) / 2, 3, this.fontID);
                }
            }
        }
    }

    public boolean ckeckTouch(int x, int y) {
        return this.isVisible && this.isActive && x >= this.left && x <= this.right && y >= this.top && y <= this.bottom;
    }

    public void drawRemoveButton() {
    }

    public void setInitLeft(int x) {
        this.currentleft = this.leftstart = x;
    }
}

