/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.core_gui;

import baltorogames.core.Utils;
import baltorogames.core_gui.UIButton;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gameplay.FXUtility;

public class UIAnimatedButtonH
extends UIButton {
    private int animRange = 3;
    private int animDir = 1;

    public UIAnimatedButtonH() {
    }

    public void setAnimDir(int f) {
        this.animDir = f;
    }

    public UIAnimatedButtonH(int l, int t, int r, int b, int bID) {
        this.top = t;
        this.left = l - this.animRange;
        this.bottom = b;
        this.right = r + this.animRange;
        this.buttonID = bID;
        this.isSelected = false;
        this.isChecked = false;
        this.isVisible = true;
        this.isActive = true;
    }

    public UIAnimatedButtonH(int l, int t, String csNormalTexture, String csSelectTexture, int bID) {
        this.buttonID = bID;
        this.textures = new CGTexture[2];
        this.textures[0] = TextureManager.AddTexture(csNormalTexture);
        this.textures[1] = TextureManager.AddTexture(csSelectTexture);
        this.top = t;
        this.left = l - this.animRange;
        this.bottom = this.top + this.textures[0].GetHeight();
        this.right = this.left + this.textures[0].GetWidth() + 2 * this.animRange;
        this.buttonID = bID;
        this.isSelected = false;
        this.isChecked = false;
        this.isVisible = true;
        this.isActive = true;
    }

    public UIAnimatedButtonH(int l, int t, CGTexture NormalTexture, CGTexture SelectTexture, int bID) {
        this.buttonID = bID;
        this.top = t;
        this.left = l - this.animRange;
        if (NormalTexture != null && SelectTexture != null) {
            this.textures = new CGTexture[2];
            this.textures[0] = NormalTexture;
            this.textures[1] = SelectTexture;
            this.bottom = this.top + this.textures[0].GetHeight();
            this.right = this.left + this.textures[0].GetWidth() + 2 * this.animRange;
        } else {
            this.textures = null;
            this.bottom = this.top + 10;
            this.right = this.left + 10 + 2 * this.animRange;
        }
        this.buttonID = bID;
        this.isSelected = false;
        this.isVisible = true;
        this.isActive = true;
    }

    public void setPosition(int l, int t, int r, int b) {
        this.top = t;
        this.left = l - this.animRange;
        this.bottom = b;
        this.right = r + this.animRange;
    }

    public void setPosition(int l, int t) {
        int w = this.right - this.left;
        int h = this.bottom - this.top;
        this.top = t;
        this.left = l - this.animRange;
        this.bottom = this.top + h;
        this.right = this.left + w;
    }

    public void setLeft(int l) {
        int w = this.right - this.left;
        this.left = l - this.animRange;
        this.right = this.left + w;
    }

    public void setTop(int t) {
        int h = this.bottom - this.top;
        this.top = t;
        this.bottom = this.top + h;
    }

    public void setTextures(CGTexture NormalTexture, CGTexture SelectTexture) {
        this.textures = new CGTexture[2];
        this.textures[0] = NormalTexture;
        this.textures[1] = SelectTexture;
        this.bottom = this.top + this.textures[0].GetHeight();
        this.right = this.left + this.textures[0].GetWidth() + 2 * this.animRange;
    }

    public void setTextures(String csNormalTexture, String csSelectTexture) {
        this.textures = new CGTexture[2];
        this.textures[0] = TextureManager.AddTexture(csNormalTexture);
        this.textures[1] = TextureManager.AddTexture(csSelectTexture);
        this.bottom = this.top + this.textures[0].GetHeight();
        this.right = this.left + this.textures[0].GetWidth() + 2 * this.animRange;
    }

    public void draw() {
        if (this.isVisible) {
            int xOffset = (int)((long)(this.animDir * this.animRange) * FXUtility.m_SinX[this.ownScreen.getLifeTime() / 2 % 360]) / 4096;
            int curLeft = this.left + this.animRange + xOffset;
            if (!this.isSelected && this.textures[0] != null) {
                Graphic2D.DrawImage(this.textures[0], curLeft, this.top, 20);
            } else if (this.isSelected && this.textures[1] != null) {
                Graphic2D.DrawImage(this.textures[1], curLeft, this.top, 20);
            }
            if (this.caption != null && this.caption.length() > 0) {
                Utils.drawString(this.caption, (curLeft + this.right) / 2, (this.top + this.bottom) / 2, 3, this.fontID);
            }
        }
    }
}

