/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core.Utils;
import baltorogames.core_gui.UIScreen;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.project_gui.BabesSelectionScreen;
import baltorogames.project_gui.MainScreen;
import baltorogames.system.ObjectsCache;
import baltorogames.system.Options;
import java.util.Vector;

public class BabeUnlockScreen
extends MainScreen {
    private CGTexture icon;
    private Vector mainText;
    int textHeight;
    UIScreen combackScreen;
    UIScreen nextScreen;

    public BabeUnlockScreen(UIScreen _nextScreen, int _babeID, int _babeLevel) {
        this.drawLogo = false;
        this.nextScreen = _nextScreen;
        this.updateInfoShown(_babeID, _babeLevel);
    }

    public void draw() {
        Graphic2D.DrawImage(this.icon, ApplicationData.screenWidth / 2, 0, 17);
        int yPos = (ApplicationData.screenHeight - ObjectsCache.menuFooterImage.GetHeight() + this.icon.GetHeight()) / 2;
        this.drawMainText(yPos);
    }

    private void updateInfoShown(int _babeID, int _babeLevel) {
        this.setSoftButtonImage(ObjectsCache.menuSbOK, ObjectsCache.menuSbOK_a, null, null);
        String textToSplit = ApplicationData.lp.getTranslatedString(Options.languageID, "TID_BABE_UNLOCK_" + BabesSelectionScreen.remapBabesOrder[_babeID] + "_" + (_babeLevel - 1));
        this.mainText = Utils.splitText(textToSplit, "+", ApplicationData.screenWidth, 2);
        this.textHeight = (this.mainText.size() + 1) * ApplicationData.smallGreyFont.getFontHeight();
    }

    private void drawMainText(int posY) {
        int fontHeight = ApplicationData.smallGreyFont.getFontHeight();
        Graphic2D.SetClip(0, 0, ApplicationData.screenWidth, ApplicationData.screenHeight);
        for (int i = 0; i < this.mainText.size(); ++i) {
            int yPosition = posY + i * fontHeight - this.mainText.size() * fontHeight / 2;
            Utils.drawString((String)this.mainText.elementAt(i), ApplicationData.screenWidth / 2, yPosition, 17, 2);
        }
    }

    public boolean leftSoftButton() {
        UIScreen.SetCurrentScreen(this.nextScreen);
        return true;
    }

    public boolean rightSoftButton() {
        return false;
    }
}

