/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.project_gameplay.CGEngine;
import javax.microedition.lcdui.Image;

class RoadLineParams {
    public int m_nSize;
    public Image[] m_array;
    public int m_color;

    void Setup(int nRayIndex, int nRaySize, int nSize, int nRoadTextureX, int nRoadTextureY, int[] imageBuff) {
        this.m_nSize = nSize;
        int[] scaleArray = new int[this.m_nSize];
        this.m_array = new Image[nRoadTextureY];
        long fxAlpha = 4096L * (long)nRayIndex / (long)nRaySize;
        fxAlpha = fxAlpha * fxAlpha / 4096L;
        long fxWsp = nRoadTextureX * 4096 / this.m_nSize;
        for (int k = 0; k < nRoadTextureY; ++k) {
            for (int i = 0; i < this.m_nSize; ++i) {
                scaleArray[i] = (int)((long)i * fxWsp) / 4096;
                if (scaleArray[i] >= nRoadTextureX) {
                    scaleArray[i] = nRoadTextureX - 1;
                }
                scaleArray[i] = imageBuff[k * nRoadTextureX + scaleArray[i]];
                int r = (scaleArray[i] & 0xFF0000) >> 16;
                int g = (scaleArray[i] & 0xFF00) >> 8;
                int b = scaleArray[i] & 0xFF;
                r = (int)((fxAlpha * (long)CGEngine.testApp.m_RoadRenderer.m_nColor1_R + (4096L - fxAlpha) * (long)r) / 4096L);
                g = (int)((fxAlpha * (long)CGEngine.testApp.m_RoadRenderer.m_nColor1_G + (4096L - fxAlpha) * (long)g) / 4096L);
                b = (int)((fxAlpha * (long)CGEngine.testApp.m_RoadRenderer.m_nColor1_B + (4096L - fxAlpha) * (long)b) / 4096L);
                scaleArray[i] = r << 16 | g << 8 | b;
            }
            this.m_array[k] = Image.createRGBImage((int[])scaleArray, (int)this.m_nSize, (int)1, (boolean)false);
        }
    }

    void SetupColor(int nRayIndex, int nRaySize, int nSize) {
        this.m_nSize = nSize;
        long fxAlpha = 4096L * (long)nRayIndex / (long)nRaySize;
        fxAlpha = fxAlpha * fxAlpha / 4096L;
        int r1 = CGEngine.testApp.m_RoadRenderer.m_nColor1_R * 90;
        r1 /= 100;
        int g1 = CGEngine.testApp.m_RoadRenderer.m_nColor1_G * 90;
        g1 /= 100;
        int b1 = CGEngine.testApp.m_RoadRenderer.m_nColor1_B * 90;
        b1 /= 100;
        int r2 = CGEngine.testApp.m_RoadRenderer.m_nColor2_R * 90;
        int g2 = CGEngine.testApp.m_RoadRenderer.m_nColor2_G * 90;
        int b2 = CGEngine.testApp.m_RoadRenderer.m_nColor2_B * 90;
        int r = (int)((fxAlpha * (long)r1 + (4096L - fxAlpha) * (long)(r2 /= 100)) / 4096L);
        int g = (int)((fxAlpha * (long)g1 + (4096L - fxAlpha) * (long)(g2 /= 100)) / 4096L);
        int b = (int)((fxAlpha * (long)b1 + (4096L - fxAlpha) * (long)(b2 /= 100)) / 4096L);
        this.m_color = r << 16 | g << 8 | b;
    }
}

