/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.core.ApplicationData;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;

public class DamageSystem {
    public static final int NO_DAMAGES = 0;
    public static final int YELLOW_DAMAGES = 1;
    public static final int RED_DAMAGES = 2;
    public static final int PART_SPOILER = 0;
    public static final int PART_LEFT_WHEEL = 1;
    public static final int PART_RIGHT_WHEEL = 2;
    public static final int PART_REAR_WHEEL = 3;
    private int[] damages = new int[4];
    protected final int YELLOW_TRESHOLD;
    protected final int RED_TRESHOLD;
    protected CGTexture carBody = TextureManager.CreateTexture("/damage/car_body.png");
    protected CGTexture spoilerYellow = TextureManager.CreateTexture("/damage/car_bump_mid.png");
    protected CGTexture spoilerRed = TextureManager.CreateTexture("/damage/car_bump_red.png");
    protected CGTexture leftWheelYellow = TextureManager.CreateTexture("/damage/car_f_l_mid.png");
    protected CGTexture leftWheelRed = TextureManager.CreateTexture("/damage/car_f_l_red.png");
    protected CGTexture rightWheelYellow = TextureManager.CreateTexture("/damage/car_f_r_mid.png");
    protected CGTexture rightWheelRed = TextureManager.CreateTexture("/damage/car_f_r_red.png");
    protected CGTexture rearWheelsYellow = TextureManager.CreateTexture("/damage/car_r_mid.png");
    protected CGTexture rearWheelsRed = TextureManager.CreateTexture("/damage/car_r_red.png");
    protected long origPower;
    protected long origNitro;
    protected long origHandling;

    public DamageSystem() {
        this.YELLOW_TRESHOLD = 4;
        this.RED_TRESHOLD = 8;
    }

    public void addDamage(int part) {
        if (this.damages[part] > 20) {
            return;
        }
        int n = part;
        this.damages[n] = this.damages[n] + 1;
    }

    public int getCurrentDamageState(int part) {
        if (this.damages[part] < 4) {
            return 0;
        }
        if (this.damages[part] >= 4 && this.damages[part] < 8) {
            return 1;
        }
        if (this.damages[part] >= 8) {
            return 2;
        }
        return 0;
    }

    public int getTotalDamage() {
        return this.damages[0] + this.damages[1] + this.damages[2] + this.damages[3];
    }

    public void repairPart(int part) {
        this.damages[part] = 0;
    }

    public void reapairAll() {
        for (int i = 0; i < this.damages.length; ++i) {
            this.damages[i] = 0;
        }
    }

    public int getDamagesSum() {
        int sum = 0;
        for (int i = 0; i < this.damages.length; ++i) {
            sum += this.damages[i];
        }
        return sum;
    }

    public void drawDamageState() {
        int x = ApplicationData.screenWidth * 87 / 100;
        int y = ApplicationData.screenHeight * 69 / 100;
        Graphic2D.DrawImage(this.carBody, x, y, 3);
        if (this.getCurrentDamageState(0) == 1) {
            Graphic2D.DrawImage(this.spoilerYellow, x, y, 3);
        } else if (this.getCurrentDamageState(0) == 2) {
            Graphic2D.DrawImage(this.spoilerRed, x, y, 3);
        }
        if (this.getCurrentDamageState(1) == 1) {
            Graphic2D.DrawImage(this.leftWheelYellow, x, y, 3);
        } else if (this.getCurrentDamageState(1) == 2) {
            Graphic2D.DrawImage(this.leftWheelRed, x, y, 3);
        }
        if (this.getCurrentDamageState(2) == 1) {
            Graphic2D.DrawImage(this.rightWheelYellow, x, y, 3);
        } else if (this.getCurrentDamageState(2) == 2) {
            Graphic2D.DrawImage(this.rightWheelRed, x, y, 3);
        }
        if (this.getCurrentDamageState(3) == 1) {
            Graphic2D.DrawImage(this.rearWheelsRed, x, y, 3);
        } else if (this.getCurrentDamageState(3) == 2) {
            Graphic2D.DrawImage(this.rearWheelsRed, x, y, 3);
        }
    }
}

