/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.core.ApplicationData;
import baltorogames.core.RandSync;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.CGRainDrop;
import java.util.Vector;

public class CGRainSystem {
    public static final int modeNone = 0;
    public static final int modeRain = 1;
    public static final int modeSnow = 2;
    private int[] tabColor = new int[]{0x555566, 0x444455, 0x666677, 0x333344};
    int m_nMaxDropsRain;
    int m_nMaxDropsSnow;
    int[] m_arrDropX = null;
    int[] m_arrDropY = null;
    int[] m_arrDropZ = null;
    int m_nDropIndex;
    int m_nDropX;
    int m_nDropY;
    int m_nTime;
    int m_nMode = 1;
    CGTexture[] rainTextures = null;
    CGTexture[] dropTextures = null;
    private Vector dropsVector = new Vector();
    private long lastDropTime = 0L;
    private long newDropTime = 0L;

    public void Init(int nMaxDropsRain, int nMaxDropsSnow) {
        if (this.rainTextures == null) {
            this.rainTextures = new CGTexture[3];
        }
        this.rainTextures[0] = TextureManager.AddTexture("/gameplay/rain_drop_1.png");
        this.rainTextures[1] = TextureManager.AddTexture("/gameplay/rain_drop_2.png");
        this.rainTextures[2] = TextureManager.AddTexture("/gameplay/rain_drop_3.png");
        if (this.dropTextures == null) {
            this.dropTextures = new CGTexture[3];
        }
        this.dropTextures[0] = TextureManager.AddTexture("/gameplay/scr_rain_1.png");
        this.dropTextures[1] = TextureManager.AddTexture("/gameplay/scr_rain_2.png");
        this.dropTextures[2] = TextureManager.AddTexture("/gameplay/scr_rain_3.png");
        this.m_nMaxDropsRain = nMaxDropsRain;
        this.m_nMaxDropsSnow = nMaxDropsSnow;
        int nD = this.m_nMaxDropsRain;
        if (this.m_nMaxDropsSnow > this.m_nMaxDropsRain) {
            nD = this.m_nMaxDropsSnow;
        }
        this.m_arrDropX = new int[nD];
        this.m_arrDropY = new int[nD];
        this.m_arrDropZ = new int[nD];
        for (int i = 0; i < nD; ++i) {
            this.m_arrDropX[i] = Math.abs(RandSync.nextInt()) % ApplicationData.screenWidth;
            this.m_arrDropY[i] = Math.abs(RandSync.nextInt()) % ApplicationData.screenHeight;
            this.m_arrDropZ[i] = Math.abs(RandSync.nextInt(5)) + 1;
        }
        this.m_nTime = 0;
    }

    public void Step(long deltaTime) {
        int i;
        if (this.m_nMode == 0) {
            return;
        }
        int m_nDeltaX = -5;
        int m_nDeltaY = 8;
        long speed = 3L;
        if (speed >= 4L) {
            m_nDeltaX = -1;
            m_nDeltaY = 8;
        } else if (speed >= 3L) {
            m_nDeltaX = -1;
            m_nDeltaY = 8;
        } else if (speed >= 2L) {
            m_nDeltaX = -2;
            m_nDeltaY = 8;
        } else if (speed >= 1L) {
            m_nDeltaX = -3;
            m_nDeltaY = 8;
        }
        if (this.m_nMode == 2) {
            m_nDeltaX /= 2;
            m_nDeltaY /= 2;
            for (i = 0; i < this.m_nMaxDropsSnow; ++i) {
                int n = i;
                this.m_arrDropX[n] = this.m_arrDropX[n] + m_nDeltaX * this.m_arrDropZ[i];
                if (this.m_arrDropX[i] < 0) {
                    int n2 = i;
                    this.m_arrDropX[n2] = this.m_arrDropX[n2] + ApplicationData.screenWidth;
                }
                int n3 = i;
                this.m_arrDropY[n3] = this.m_arrDropY[n3] + m_nDeltaY * this.m_arrDropZ[i];
                if (this.m_arrDropY[i] <= ApplicationData.screenHeight) continue;
                int n4 = i;
                this.m_arrDropY[n4] = this.m_arrDropY[n4] - ApplicationData.screenHeight;
            }
        } else {
            m_nDeltaX *= 2;
            m_nDeltaY *= 3;
            for (i = 0; i < this.m_nMaxDropsRain; ++i) {
                int n = i;
                this.m_arrDropX[n] = this.m_arrDropX[n] + m_nDeltaX * this.m_arrDropZ[i];
                if (this.m_arrDropX[i] < 0) {
                    int n5 = i;
                    this.m_arrDropX[n5] = this.m_arrDropX[n5] + ApplicationData.screenWidth;
                }
                int n6 = i;
                this.m_arrDropY[n6] = this.m_arrDropY[n6] + m_nDeltaY * this.m_arrDropZ[i];
                if (this.m_arrDropY[i] <= ApplicationData.screenHeight) continue;
                int n7 = i;
                this.m_arrDropY[n7] = this.m_arrDropY[n7] - ApplicationData.screenHeight;
            }
        }
        this.m_nTime = (int)((long)this.m_nTime - deltaTime / 4096L);
        if (this.m_nTime <= 0) {
            this.m_nDropX = Math.abs(RandSync.nextInt()) % ApplicationData.screenWidth;
            this.m_nDropY = Math.abs(RandSync.nextInt()) % ApplicationData.screenHeight;
            this.m_nTime = 3000 + Math.abs(RandSync.nextInt()) % 1000;
            this.m_nDropIndex = Math.abs(RandSync.nextInt()) % 2;
        }
        if (ApplicationData.getAppTime() > this.newDropTime) {
            CGRainDrop dr = new CGRainDrop();
            dr.x = Math.abs(RandSync.nextInt() % ApplicationData.screenWidth);
            dr.y = Math.abs(RandSync.nextInt() % ApplicationData.screenHeight) * 4096;
            dr.startSize = Math.abs(RandSync.nextInt() % 2);
            dr.startTime = 0L;
            this.dropsVector.addElement(dr);
            this.lastDropTime = ApplicationData.getAppTime();
            this.newDropTime = this.lastDropTime + (long)(400 + Math.abs(RandSync.nextInt() % 400));
        }
        int nSize = this.dropsVector.size();
        for (int i2 = nSize - 1; i2 >= 0; --i2) {
            CGRainDrop dr1 = (CGRainDrop)this.dropsVector.elementAt(i2);
            dr1.Step(1000L * CGEngine.testApp.m_fxDeltaTime / 4096L);
            if (dr1.startSize <= 2) continue;
            this.dropsVector.removeElementAt(i2);
        }
    }

    public void Reset() {
        this.dropsVector.removeAllElements();
        this.lastDropTime = ApplicationData.getAppTime();
        this.newDropTime = this.lastDropTime + (long)(300 + RandSync.nextInt() % 2000);
    }

    public void Render() {
        block14: {
            int nAdd;
            block13: {
                if (this.m_nMode == 0) {
                    return;
                }
                int nDropSize = 1;
                int nDX = 4;
                int nDY = 12;
                nAdd = 2;
                long speed = 3L;
                if (speed >= 4L) {
                    nAdd = 1;
                    nDX = 1;
                    nDY = 7;
                } else if (speed >= 3L) {
                    nAdd = 2;
                    nDX = 1;
                    nDY = 9;
                } else if (speed >= 2L) {
                    nAdd = 2;
                    nDX = 2;
                    nDY = 10;
                } else if (speed >= 1L) {
                    nAdd = 2;
                    nDX = 3;
                    nDY = 11;
                }
                if (this.m_nMode != 2) break block13;
                Graphic2D.SetColor(0xFFFFFF);
                nDropSize = 2;
                for (int i = 0; i < this.m_nMaxDropsSnow; i += nAdd) {
                    Graphic2D.FillRect(this.m_arrDropX[i], this.m_arrDropY[i], nDropSize, nDropSize);
                }
                break block14;
            }
            if (this.rainTextures[0] != null) {
                for (int i = 0; i < this.m_nMaxDropsRain; i += nAdd) {
                    int nScale = 1;
                    if (this.m_arrDropZ[i] < 2) {
                        nScale = 2;
                    }
                    int nC = RandSync.nextInt(3);
                    Graphic2D.DrawImage(this.rainTextures[nC], this.m_arrDropX[i], this.m_arrDropY[i], 20);
                }
            }
            if (this.dropTextures[0] == null) break block14;
            int nSize = this.dropsVector.size();
            for (int i = nSize - 1; i >= 0; --i) {
                CGRainDrop dr = (CGRainDrop)this.dropsVector.elementAt(i);
                if (dr.startSize > 2) continue;
                Graphic2D.DrawImage(this.dropTextures[dr.startSize], dr.x, (int)dr.y / 4096, 36);
            }
        }
    }

    public void SetMode(int b) {
        this.m_nMode = b;
    }
}

