/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.core.ApplicationData;
import baltorogames.core.Utils;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.project_gameplay.ListInt;
import baltorogames.system.Options;
import java.util.Vector;

public class AchievementPopup {
    private static Vector infoList = new Vector();
    private static long startTime = 0L;
    private static int m_xpos;
    private static int m_ypos;
    private static int m_width;
    private static int m_height;
    private static CGTexture backTexture;
    private static String text;
    private static String textHeader;

    public static void Init() {
        startTime = 0L;
    }

    public static boolean IsEnabled() {
        return startTime > 0L;
    }

    public static void Step() {
        if (startTime > 0L) {
            long lDeltaTime = ApplicationData.getAppTime() - startTime;
            if (lDeltaTime > 2000L) {
                if (infoList.size() > 0) {
                    int nCurrentID = ((ListInt)AchievementPopup.infoList.elementAt((int)0)).nValue;
                    infoList.removeElementAt(0);
                    AchievementPopup.NewAchievementInfoInternal(nCurrentID);
                } else {
                    startTime = 0L;
                }
            } else {
                AchievementPopup.Render(lDeltaTime);
            }
        }
    }

    public static void NewAchievement(int nIndex) {
        if (startTime > 0L) {
            ListInt obj = new ListInt();
            obj.nValue = nIndex;
            infoList.addElement(obj);
        } else {
            AchievementPopup.NewAchievementInfoInternal(nIndex);
        }
    }

    private static void NewAchievementInfoInternal(int nIndex) {
        startTime = ApplicationData.getAppTime();
        if (nIndex < 100) {
            textHeader = ApplicationData.lp.getTranslatedString(Options.languageID, "TID_NEW_ACHI");
            text = ApplicationData.lp.getTranslatedString(Options.languageID, "TID_ACHIEVEMENT_HEADER_" + nIndex);
        } else {
            textHeader = ApplicationData.lp.getTranslatedString(Options.languageID, "TID_POPUP_NEW_SURVIVAL_MAP");
            text = ApplicationData.lp.getTranslatedString(Options.languageID, "TID_POPUP_NEW_SURVIVAL_MAP_AVAILABLE");
        }
    }

    private static void Render(long lDeltaTime) {
        long lAlpha = 0L;
        if (lDeltaTime <= 300L) {
            lAlpha = 4096L * lDeltaTime / 300L;
        } else if (lDeltaTime <= 1500L) {
            lAlpha = 4096L;
        } else if (lDeltaTime <= 1800L) {
            lAlpha = 4096L - (4096L * lDeltaTime - 1500L) / 300L;
        } else if (lDeltaTime <= 2000L) {
            lAlpha = 0L;
        }
        if (lAlpha == 4096L) {
            int nY = ApplicationData.screenHeight;
            Graphic2D.DrawImage(backTexture, ApplicationData.screenWidth / 2, nY, 33);
            Utils.drawString(textHeader, ApplicationData.screenWidth / 2, nY -= backTexture.GetHeight(), 17, 0);
            Utils.drawString(text, ApplicationData.screenWidth / 2, nY += ApplicationData.defaultFont.getFontHeight(), 17, 0);
        }
    }

    static {
        backTexture = null;
        text = new String();
        textHeader = new String();
    }
}

