/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.core_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core.Utils;
import baltorogames.core_gui.UIAnimatedButtonV;
import baltorogames.core_gui.UIButton;
import baltorogames.core_gui.UIScreen;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.system.ObjectsCache;
import java.util.Vector;

public class UITextBox
extends UIScreen {
    private final int UP_ARROW_ID;
    private final int DOWN_ARROW_ID;
    protected boolean smallHeight = false;
    protected Vector textLines = new Vector();
    protected int textHeight = 0;
    protected int scrollOffset = 0;
    protected boolean scrollable = false;
    private final int SCROLL_SPEED;
    protected int fontID = 0;
    protected boolean hasBackground = false;
    private boolean isUp = false;
    private boolean isDown = false;

    public void setBackground(boolean b) {
        this.hasBackground = b;
    }

    private void AddArrows() {
        int x = ApplicationData.screenWidth / 2 - ObjectsCache.arrowUp.GetWidth() / 2;
        int y = this.positionY - ObjectsCache.arrowUp.GetWidth() - ObjectsCache.arrowUp.GetWidth() / 4;
        UIAnimatedButtonV rightB = new UIAnimatedButtonV(x, y, ObjectsCache.arrowUp, ObjectsCache.arrowUp_a, 100);
        rightB.setScreen(this);
        rightB.setAnimDir(1);
        this.addButton(rightB);
        rightB.setVisible(false);
        y = this.positionY + this.height + ObjectsCache.arrowUp.GetWidth() / 4;
        UIAnimatedButtonV leftB = new UIAnimatedButtonV(x, y, ObjectsCache.arrowDown, ObjectsCache.arrowDown_a, 101);
        leftB.setScreen(this);
        leftB.setAnimDir(-1);
        this.addButton(leftB);
        leftB.setVisible(false);
    }

    public UITextBox(int posX, int posY, int posW, int posH, boolean _scrollable, int _fontID, boolean _hasBackground, UIScreen nextScreen) {
        this.UP_ARROW_ID = 100;
        this.DOWN_ARROW_ID = 101;
        this.SCROLL_SPEED = 1;
        this.scrollable = _scrollable;
        this.showScrollbars(this.scrollable);
        this.fontID = _fontID;
        this.hasBackground = _hasBackground;
        this.userPositionX = posX;
        this.userPositionY = posY;
        this.userWidth = posW;
        this.userHeight = posH;
        this.setupDrawingArea();
        if (this.scrollable) {
            this.AddArrows();
        }
        this.parentScreen = nextScreen;
    }

    public UITextBox(int posX, int posY, int posW, int posH, boolean _scrollable) {
        this.UP_ARROW_ID = 100;
        this.DOWN_ARROW_ID = 101;
        this.SCROLL_SPEED = 1;
        this.scrollable = _scrollable;
        this.showScrollbars(this.scrollable);
        this.userPositionX = posX;
        this.userPositionY = posY;
        this.userWidth = posW;
        this.userHeight = posH;
        this.setupDrawingArea();
        if (this.scrollable) {
            this.AddArrows();
        }
    }

    public UITextBox(int posX, int posY, int posW, int posH, boolean _scrollable, UIScreen nextScreen) {
        this.UP_ARROW_ID = 100;
        this.DOWN_ARROW_ID = 101;
        this.SCROLL_SPEED = 1;
        this.scrollable = _scrollable;
        this.parentScreen = nextScreen;
        this.showScrollbars(this.scrollable);
        this.userPositionX = posX;
        this.userPositionY = posY;
        this.userWidth = posW;
        this.userHeight = posH;
        this.setupDrawingArea();
        if (this.scrollable) {
            this.AddArrows();
        }
    }

    protected void setupDrawingArea() {
        if (!this.hasBackground) {
            this.positionX = this.userPositionX;
            this.positionY = this.userPositionY;
            this.width = this.userWidth;
            this.height = this.userHeight;
        }
    }

    public void onUpdate(int deltaTime) {
        super.onUpdate(deltaTime);
        if (this.scrollable) {
            UIButton b = this.findByID(100);
            if (b != null && !b.isVisible && this.scrollOffset < 0) {
                b.setVisible(true);
            }
            if (b != null && b.isActive && b.isVisible && b.isSelected) {
                if (this.scrollOffset < 0) {
                    this.scrollOffset += deltaTime * 1 / 10;
                    if (this.scrollOffset > 0) {
                        this.scrollOffset = 0;
                    }
                } else {
                    b.setVisible(false);
                    b.setSelect(false);
                }
            }
            int maxScrollValue = -ApplicationData.getFontByID(this.fontID).getFontHeight() * (this.textLines.size() - this.height / ApplicationData.getFontByID(this.fontID).getFontHeight());
            b = this.findByID(101);
            if (b != null && !b.isVisible && this.scrollOffset > maxScrollValue) {
                b.setVisible(true);
            }
            if (b != null && b.isActive && b.isVisible && b.isSelected) {
                if (this.scrollOffset > maxScrollValue) {
                    this.scrollOffset -= deltaTime * 1 / 10;
                    if (this.scrollOffset < maxScrollValue) {
                        this.scrollOffset = maxScrollValue;
                    }
                } else {
                    b.setVisible(false);
                    b.setSelect(false);
                }
            }
        }
    }

    public void setText(String newText, String separator) {
        this.textLines = Utils.splitText(newText, separator, this.width);
        this.textHeight = this.textLines.size() * ApplicationData.getFontByID(this.fontID).getFontHeight() - ApplicationData.getFontByID(this.fontID).getFontSpacing();
        if (this.checkIfScrollsAreNeeded()) {
            this.textLines = Utils.splitText(newText, separator, this.width);
            this.textHeight = this.textLines.size() * ApplicationData.getFontByID(this.fontID).getFontHeight();
        }
    }

    public void setText(String newText) {
        this.setText(newText, "+");
    }

    private boolean checkIfScrollsAreNeeded() {
        this.showScrollbars = this.scrollable = this.textHeight > this.height;
        return this.scrollable;
    }

    public void drawWindowBackground() {
    }

    public void drawWindowForeground() {
    }

    public void draw() {
        int fontHeight = ApplicationData.getFontByID(this.fontID).getFontHeight();
        int yCenterAlign = 0;
        if (!this.scrollable) {
            yCenterAlign = (this.height - fontHeight * this.textLines.size()) / 2;
        }
        if (this.hasBackground) {
            // empty if block
        }
        Graphic2D.SetClip(this.positionX, this.positionY, this.width, this.height);
        for (int i = 0; i < this.textLines.size(); ++i) {
            int yPosition = this.positionY + i * fontHeight + this.scrollOffset + yCenterAlign;
            if (yPosition < 0 || yPosition > ApplicationData.screenHeight) continue;
            if (!this.showScrollbars) {
                Utils.drawString((String)this.textLines.elementAt(i), this.positionX + this.width / 2, yPosition, 17, this.fontID);
                continue;
            }
            Utils.drawString((String)this.textLines.elementAt(i), this.positionX + this.width / 2, yPosition, 17, this.fontID);
        }
        Graphic2D.SetClip(0, 0, ApplicationData.screenWidth, ApplicationData.screenHeight);
    }

    protected void drawTextBoxBackground(int w, int h) {
    }

    public boolean actionSoftButton(int nID) {
        return false;
    }

    public boolean rightSoftButton() {
        if (this.findByID(UIScreen.ID_BUTTON_CANCEL) != null && this.parentScreen != null) {
            this.readyForClose = true;
            return true;
        }
        return false;
    }

    public boolean leftSoftButton() {
        if (this.findByID(UIScreen.ID_BUTTON_OK) != null && this.parentScreen != null) {
            this.readyForClose = true;
            return true;
        }
        return false;
    }

    public boolean onFireAction() {
        return this.leftSoftButton();
    }

    public boolean selectDownAction() {
        if (this.scrollable) {
            UIButton b = this.findByID(101);
            if (b != null) {
                b.setSelect(true);
            }
            this.isUp = false;
            this.isDown = true;
            return true;
        }
        return false;
    }

    public boolean onDownAction() {
        if (this.scrollable) {
            this.isDown = false;
            return true;
        }
        return false;
    }

    public boolean selectUpAction() {
        if (this.scrollable) {
            UIButton b = this.findByID(100);
            if (b != null) {
                b.setSelect(true);
            }
            this.isUp = true;
            this.isDown = false;
            return true;
        }
        return false;
    }

    public boolean onUpAction() {
        if (this.scrollable) {
            this.isUp = false;
            return true;
        }
        return false;
    }

    public void updateSize() {
    }

    public void autoSize() {
    }

    public void onFocusBack() {
        super.onFocusBack();
    }
}

