/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.core_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core.Utils;
import baltorogames.core_gui.UIAnimatedButtonV;
import baltorogames.core_gui.UIButton;
import baltorogames.core_gui.UIListColumn;
import baltorogames.core_gui.UIListItem;
import baltorogames.core_gui.UIListTextItem;
import baltorogames.core_gui.UIScreen;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.system.ObjectsCache;
import baltorogames.system.Platform;
import java.util.Vector;

public abstract class UIList
extends UIScreen {
    private final int UP_ARROW_ID;
    private final int DOWN_ARROW_ID;
    private static int COLUMN_SEPARATOR_WIDTH = 4;
    protected Vector columns = null;
    protected Vector headers = new Vector();
    protected int currentItem = 0;
    protected int centerMode = 1;
    protected int scrollOffset = 0;
    protected boolean scrollable = true;
    private final int SCROLL_SPEED;
    public boolean drawColumnSeparators = false;
    public boolean showHeaders = false;
    protected int fontID = 0;
    private boolean hasBackground = true;
    private int highlightListItem = -1;

    public void setHighLightIndex(int i) {
        this.highlightListItem = i;
    }

    private void AddArrows() {
        int nUpArrowY = this.positionY - ObjectsCache.arrowUp.GetHeight();
        int nDownArrowY = this.positionY + this.height;
        int x = ApplicationData.screenWidth / 2 - ObjectsCache.arrowUp.GetWidth() / 2;
        int y = nUpArrowY;
        UIAnimatedButtonV rightB = new UIAnimatedButtonV(x, y, ObjectsCache.arrowUp, ObjectsCache.arrowUp_a, 100);
        rightB.setScreen(this);
        rightB.setAnimDir(1);
        this.addButton(rightB);
        rightB.setVisible(false);
        y = nDownArrowY;
        UIAnimatedButtonV leftB = new UIAnimatedButtonV(x, y, ObjectsCache.arrowDown, ObjectsCache.arrowDown_a, 101);
        leftB.setScreen(this);
        leftB.setAnimDir(-1);
        this.addButton(leftB);
        leftB.setVisible(false);
    }

    public UIList(Vector _columns, int _fontID, boolean _background) {
        this.UP_ARROW_ID = 100;
        this.DOWN_ARROW_ID = 101;
        this.SCROLL_SPEED = 1;
        this.fontID = _fontID;
        this.hasBackground = _background;
        this.showScrollbars = true;
        this.columns = _columns;
        this.setupDrawingArea();
    }

    public UIList(int _fontID, boolean _background) {
        this.UP_ARROW_ID = 100;
        this.DOWN_ARROW_ID = 101;
        this.SCROLL_SPEED = 1;
        this.fontID = _fontID;
        this.hasBackground = _background;
        this.showScrollbars = true;
        this.columns = new Vector();
        this.columns.addElement(new UIListColumn(100, 33));
        this.setupDrawingArea();
    }

    private void setupDrawingArea() {
        if (!this.hasBackground) {
            this.positionX = ApplicationData.screenWidth / 2 - 120;
            this.positionY = ObjectsCache.menuHeader != null ? 3 * ObjectsCache.menuHeader.GetHeight() / 4 : ApplicationData.screenHeight / 3;
            this.width = 240;
            this.height = ApplicationData.screenHeight - 4 * ObjectsCache.menuSbOK.GetHeight() / 3 - this.positionY;
        }
        this.AddArrows();
    }

    protected UIListColumn getColumn(int id) {
        return (UIListColumn)this.columns.elementAt(id);
    }

    public void onUpdate(int deltaTime) {
        UIButton b;
        super.onUpdate(deltaTime);
        int numItems = this.getColumn((int)0).items.size();
        int maxNumItems = this.height / ApplicationData.getFontByID(this.fontID).getFontHeight();
        int fMaxScroll = (1 + numItems - maxNumItems) * ApplicationData.getFontByID(this.fontID).getFontHeight();
        boolean bl = this.showScrollbars = numItems * ApplicationData.getFontByID(this.fontID).getFontHeight() > this.height;
        if (!this.showScrollbars) {
            this.currentItem = 0;
            b = this.findByID(100);
            if (b != null) {
                b.setVisible(false);
            }
            if ((b = this.findByID(101)) != null) {
                b.setVisible(false);
            }
        } else {
            UIButton bDown;
            int nItem;
            UIButton bUp = this.findByID(100);
            if (bUp != null) {
                bUp.setVisible(true);
            }
            if ((nItem = this.scrollOffset / ApplicationData.getFontByID(this.fontID).getFontHeight()) <= 0) {
                bUp.setVisible(false);
            }
            if ((bDown = this.findByID(101)) != null) {
                bDown.setVisible(true);
            }
            if (nItem + maxNumItems >= numItems) {
                bDown.setVisible(false);
            }
        }
        b = this.findByID(100);
        if (b != null && !b.isVisible && this.scrollOffset > 0) {
            b.setVisible(true);
        }
        if (b != null && b.isActive && b.isVisible && b.isSelected) {
            if (this.scrollOffset > 0) {
                this.scrollOffset -= deltaTime * 1 / 10;
                if (this.scrollOffset < 0) {
                    this.scrollOffset = 0;
                }
            } else {
                b.setVisible(false);
                b.setSelect(false);
            }
        }
        if ((b = this.findByID(101)) != null && !b.isVisible && this.scrollOffset < fMaxScroll) {
            b.setVisible(true);
        }
        if (b != null && b.isActive && b.isVisible && b.isSelected) {
            if (this.scrollOffset < fMaxScroll) {
                this.scrollOffset += deltaTime * 1 / 10;
                if (this.scrollOffset > fMaxScroll) {
                    this.scrollOffset = fMaxScroll;
                }
            } else {
                b.setVisible(false);
                b.setSelect(false);
            }
        }
    }

    public void draw() {
        int fontHeight = ApplicationData.getFontByID(this.fontID).getFontHeight();
        int itemsBaselineY = this.positionY + fontHeight;
        int numItems = this.getColumn((int)0).items.size();
        int maxNumItems = this.height / ApplicationData.getFontByID(this.fontID).getFontHeight();
        boolean bl = this.showScrollbars = numItems * fontHeight > this.height;
        if (!this.showScrollbars) {
            this.currentItem = 0;
            int allItemsHeight = numItems * fontHeight;
            itemsBaselineY = this.positionY + (this.height - allItemsHeight) / 2;
            UIButton b = this.findByID(100);
            if (b != null) {
                b.setVisible(false);
            }
            if ((b = this.findByID(101)) != null) {
                b.setVisible(false);
            }
        } else {
            this.currentItem = this.scrollOffset / ApplicationData.getFontByID(this.fontID).getFontHeight();
        }
        if (this.hasBackground) {
            // empty if block
        }
        if (this.showHeaders) {
            int xx = this.positionX;
            for (int cc = 0; cc < this.columns.size(); ++cc) {
                UIListColumn column = this.getColumn(cc);
                int _width = this.width * column.width / 100;
                if (column.alignment == 1) {
                    Utils.drawString((String)this.headers.elementAt(cc), xx + _width / 2, itemsBaselineY + Platform.TABLE_HEADER_OFFSET, 33, this.fontID);
                } else {
                    Utils.drawString((String)this.headers.elementAt(cc), xx, itemsBaselineY + Platform.TABLE_HEADER_OFFSET, 36, this.fontID);
                }
                xx += _width;
                xx += COLUMN_SEPARATOR_WIDTH;
            }
        }
        Graphic2D.SetClip(this.positionX, itemsBaselineY, this.width, this.height - fontHeight);
        for (int i = 0; i < numItems; ++i) {
            int itemIndex = i;
            int xx = this.positionX;
            int yPosition = itemsBaselineY + i * fontHeight - this.scrollOffset;
            if (i % 2 == 0) {
                Graphic2D.SetColor(-2619833);
                Graphic2D.FillRect(this.positionX, yPosition, this.width, 9 * fontHeight / 10);
            }
            for (int cc = 0; cc < this.columns.size(); ++cc) {
                UIListColumn column = this.getColumn(cc);
                int _width = this.width * column.width / 100;
                UIListItem item = (UIListItem)column.items.elementAt(itemIndex);
                if (item.isVisible()) {
                    item.draw(xx, yPosition, _width, fontHeight, column.alignment);
                }
                xx += _width + COLUMN_SEPARATOR_WIDTH;
            }
        }
        Graphic2D.SetClip(0, 0, ApplicationData.screenWidth, ApplicationData.screenHeight);
    }

    public void autoSize() {
    }

    public boolean leftSoftButton() {
        return false;
    }

    public boolean rightSoftButton() {
        return false;
    }

    public void updateSize() {
    }

    public abstract void currentItemChanged(int var1, int var2);

    public abstract void currentItemSelected(int var1);

    public void clearList() {
        for (int i = 0; i < this.columns.size(); ++i) {
            this.getColumn(i).empty();
        }
    }

    public void append(String newItem) {
        this.append(newItem, null);
    }

    public void append(String newItem, int columnID) {
        this.append(newItem, null, columnID);
    }

    public void append(String newItem, CGTexture img) {
        this.getColumn((int)0).items.addElement(new UIListTextItem(newItem));
    }

    public void append(String newItem, CGTexture img, int columnID) {
        this.getColumn((int)columnID).items.addElement(new UIListTextItem(newItem));
    }

    public boolean selectUpAction() {
        UIButton b = this.findByID(100);
        if (b != null) {
            b.setSelect(true);
        }
        return true;
    }

    public boolean onUpAction() {
        return true;
    }

    public boolean selectDownAction() {
        UIButton b = this.findByID(101);
        if (b != null) {
            b.setSelect(true);
        }
        return true;
    }

    public boolean onDownAction() {
        return true;
    }

    public boolean onFireAction() {
        if (this.currentItem != -1) {
            this.currentItemSelected(this.currentItem);
        }
        return true;
    }

    private void drawTextBoxBackground(int w, int h) {
    }

    public void setCenterMode(int mode) {
        this.centerMode = mode;
    }
}

