/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core.Utils;
import baltorogames.core_gui.UIAnimatedButtonH;
import baltorogames.core_gui.UIButton;
import baltorogames.core_gui.UIScreen;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gui.MainMenu;
import baltorogames.project_gui.MainUSRScreen;
import baltorogames.project_gui.SelectTrack;
import baltorogames.system.ObjectsCache;
import baltorogames.system.Options;

public class SelectWorld
extends MainUSRScreen {
    private int currentElement = 0;
    private final int MAX_ELEMENTS;
    private final int LEFT_ARROW_ID;
    private final int RIGHT_ARROW_ID;
    private CGTexture[] texts = new CGTexture[3];
    public static String[] names = new String[]{"ID_ENV_2", "ID_ENV_1", "ID_ENV_3", "UweS", "PatrikJ"};
    public static int selectedWorld = 0;

    public SelectWorld() {
        this.MAX_ELEMENTS = 3;
        this.LEFT_ARROW_ID = 100;
        this.RIGHT_ARROW_ID = 101;
        this.texts[0] = TextureManager.CreateTexture("/maps/california_map.png");
        this.texts[1] = TextureManager.CreateTexture("/maps/australia_map.png");
        this.texts[2] = TextureManager.CreateTexture("/maps/monaco.png");
        this.setSoftButtonImage(ObjectsCache.menuSbOK, ObjectsCache.menuSbBACK_a, ObjectsCache.menuSbBACK, ObjectsCache.menuSbBACK_a);
        int arrowLeftX = 0;
        int arrowRightX = ApplicationData.screenWidth - ObjectsCache.scrollRightImg.GetWidth();
        UIAnimatedButtonH rightB = new UIAnimatedButtonH(arrowRightX - ObjectsCache.menuWhiteDot.GetHeight(), ApplicationData.screenHeight / 2 - ObjectsCache.scrollLeftImg.GetHeight() / 2, ObjectsCache.scrollRightImg, ObjectsCache.scrollRightWImg, 101);
        rightB.setScreen(this);
        rightB.setAnimDir(1);
        this.addButton(rightB);
        UIAnimatedButtonH leftB = new UIAnimatedButtonH(arrowLeftX + ObjectsCache.menuWhiteDot.GetHeight(), ApplicationData.screenHeight / 2 - ObjectsCache.scrollLeftImg.GetHeight() / 2, ObjectsCache.scrollLeftImg, ObjectsCache.scrollLeftWImg, 100);
        leftB.setScreen(this);
        leftB.setAnimDir(-1);
        this.addButton(leftB);
    }

    public void onUpdate(int deltaTime) {
        this.lifeTime += deltaTime;
    }

    public void draw() {
        Graphic2D.DrawImage(this.texts[this.currentElement], ApplicationData.screenWidth / 2, ApplicationData.screenHeight / 2, 3);
        Utils.drawString(ApplicationData.lp.getTranslatedString(Options.languageID, names[this.currentElement]), ApplicationData.screenWidth / 2, ApplicationData.screenHeight * 85 / 100, 3, 0);
    }

    public boolean rightSoftButton() {
        UIScreen.SetCurrentScreen(new MainMenu());
        return true;
    }

    public boolean leftSoftButton() {
        selectedWorld = this.currentElement;
        UIScreen.SetCurrentScreen(new SelectTrack());
        return true;
    }

    public boolean selectLeftAction() {
        UIButton b = this.findByID(100);
        if (b != null) {
            b.setSelect(true);
            return true;
        }
        return false;
    }

    public boolean selectRightAction() {
        UIButton b = this.findByID(101);
        if (b != null) {
            b.setSelect(true);
            return true;
        }
        return false;
    }

    public boolean actionSoftButton(int nID, boolean pressed) {
        if (super.actionSoftButton(nID, pressed)) {
            return true;
        }
        if (!pressed) {
            this.unselectAllButtons();
            if (nID == 100) {
                this.onLeftAction();
                return true;
            }
            if (nID == 101) {
                this.onRightAction();
                return true;
            }
        }
        return false;
    }

    public boolean onRightAction() {
        ++this.currentElement;
        if (this.currentElement >= 3) {
            this.currentElement = 0;
        }
        return true;
    }

    public boolean onLeftAction() {
        --this.currentElement;
        if (this.currentElement < 0) {
            this.currentElement = 2;
        }
        return true;
    }

    public boolean onFireAction() {
        return this.leftSoftButton();
    }
}

