/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core.Utils;
import baltorogames.core_gui.UIButton;
import baltorogames.core_gui.UICheckButton;
import baltorogames.project_gui.MainScreen;
import baltorogames.system.ObjectsCache;
import baltorogames.system.Platform;

public class EditNickScreen
extends MainScreen {
    private final int START_BUTTON_ID;
    private final int DEFAULT_EDIT_TEXT_LENGTH;
    private int editTextMaxLength = 7;
    public static int cellSize = 20;
    protected String editableText;
    private int currentX = 0;
    private int currentY = 0;
    private boolean firstTime = true;
    private long lastKeyPressedTime = 0L;
    private static boolean qwertyEncoded = false;
    private static String[][] qwerty = new String[][]{{"A", "B", "C", "D", "E", "F", "G"}, {"H", "I", "J", "K", "L", "M", "N"}, {"O", "P", "Q", "R", "S", "T", "U"}, {"V", "W", "X", "Y", "Z", " ", "#"}};
    int lastKeyPressed = -1;
    int numPresses = 0;
    long timeOfLastPress = 0L;
    String previewChar = "";
    boolean flash = true;

    public EditNickScreen(String initialText) {
        this.START_BUTTON_ID = 1000;
        this.DEFAULT_EDIT_TEXT_LENGTH = 7;
        this.editableText = initialText;
        if (!qwertyEncoded) {
            qwertyEncoded = true;
            for (int y = 0; y < 4; ++y) {
                for (int x = 0; x < 7; ++x) {
                    EditNickScreen.qwerty[y][x] = ApplicationData.defaultFont.encodeDynamicString(qwerty[y][x]);
                }
            }
        }
        this.createButtons();
        this.currentX = 0;
        this.currentY = 0;
        this.uncheckAllButtons();
        UIButton b = this.findByID(1000 + this.currentY * 7 + this.currentX);
        if (b != null) {
            b.setCheck(true);
        }
    }

    private void createButtons() {
        int nStartX = ApplicationData.screenWidth / 2 - 120;
        int lineHeight = 3 * ObjectsCache.keyboard_std.GetHeight() / 2;
        int yPos = ObjectsCache.menuHeader.GetHeight() * 3 / 2;
        int nCurrentID = 1000;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 7; ++j) {
                int x = nStartX + j * 34 + ObjectsCache.keyboard_std.GetWidth() / 2;
                int y = yPos + i * lineHeight;
                UICheckButton b = new UICheckButton(x, y, ObjectsCache.keyboard_std, ObjectsCache.keyboard_hgh, ObjectsCache.keyboard_std, nCurrentID);
                b.setCaption(qwerty[i][j]);
                this.addButton(b);
                ++nCurrentID;
            }
        }
    }

    public void autoSize() {
        this.clientAreaX = Platform.WND_MARGIN_LEFT;
        this.clientAreaWidth = this.width - Platform.WND_MARGIN_LEFT - Platform.WND_MARGIN_RIGHT;
        this.clientAreaY = Platform.WND_MARGIN_TOP;
        this.clientAreaHeight = this.height - Platform.WND_MARGIN_TOP - Platform.WND_MARGIN_BOTTOM;
    }

    public void draw() {
        int ticker = this.lifeTime % 2;
        String nickToDraw = this.editableText + ApplicationData.defaultFont.encodeDynamicString(ticker == 0 ? " " : "_");
        int lineHeight = ObjectsCache.keyboard_std.GetHeight();
        int yPos = ApplicationData.screenHeight - 60 - lineHeight;
        Utils.drawString(nickToDraw, ApplicationData.screenWidth / 3, yPos, 36, 0);
    }

    private void addChar(String s) {
        if (this.editableText.length() < this.editTextMaxLength) {
            this.editableText = this.editableText + s;
        }
    }

    public boolean actionSoftButton(int nID, boolean pressed) {
        if (super.actionSoftButton(nID, pressed)) {
            if (nID >= 1000) {
                if (ApplicationData.getAppTime() - this.lastKeyPressedTime < 400L) {
                    return false;
                }
                int nC = nID - 1000;
                this.currentX = nC % 7;
                this.currentY = nC / 7;
                if (this.currentX == 6 && this.currentY == 3) {
                    this.lastKeyPressed = -1;
                    this.numPresses = 0;
                    if (this.firstTime) {
                        this.editableText = "";
                    } else if (this.editableText.length() > 0) {
                        this.editableText = this.editableText.substring(0, this.editableText.length() - 1);
                    }
                    this.lastKeyPressedTime = ApplicationData.getAppTime();
                } else {
                    this.addChar(qwerty[this.currentY][this.currentX]);
                    this.lastKeyPressedTime = ApplicationData.getAppTime();
                }
                this.uncheckAllButtons();
                UIButton b = this.findByID(nID);
                if (b != null) {
                    b.setCheck(true);
                }
                this.firstTime = false;
            }
            return true;
        }
        return false;
    }

    public boolean onLeftAction() {
        --this.currentX;
        if (this.currentX < 0) {
            this.currentX = 6;
        }
        this.uncheckAllButtons();
        UIButton b = this.findByID(1000 + this.currentY * 7 + this.currentX);
        if (b != null) {
            b.setCheck(true);
        }
        return true;
    }

    public boolean onRightAction() {
        ++this.currentX;
        if (this.currentX > 6) {
            this.currentX = 0;
        }
        this.uncheckAllButtons();
        UIButton b = this.findByID(1000 + this.currentY * 7 + this.currentX);
        if (b != null) {
            b.setCheck(true);
        }
        return true;
    }

    public boolean onUpAction() {
        --this.currentY;
        if (this.currentY < 0) {
            this.currentY = 3;
        }
        this.uncheckAllButtons();
        UIButton b = this.findByID(1000 + this.currentY * 7 + this.currentX);
        if (b != null) {
            b.setCheck(true);
        }
        return true;
    }

    public boolean onDownAction() {
        ++this.currentY;
        if (this.currentY > 3) {
            this.currentY = 0;
        }
        this.uncheckAllButtons();
        UIButton b = this.findByID(1000 + this.currentY * 7 + this.currentX);
        if (b != null) {
            b.setCheck(true);
        }
        return true;
    }

    public boolean selectFireAction() {
        return false;
    }

    public boolean onFireAction() {
        if (this.currentX == 6 && this.currentY == 3) {
            this.lastKeyPressed = -1;
            this.numPresses = 0;
            if (this.firstTime) {
                this.editableText = "";
            } else if (this.editableText.length() > 0) {
                this.editableText = this.editableText.substring(0, this.editableText.length() - 1);
            }
        } else {
            this.addChar(qwerty[this.currentY][this.currentX]);
        }
        this.firstTime = false;
        return true;
    }
}

