/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.graphic2d.Graphic2D;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.RoadLineParams;
import javax.microedition.lcdui.Image;

public class RoadRenderer {
    private int[] imageBuff;
    private int imageX = 256;
    private int imageY = 2;
    public RoadLineParams[] arrRoadLineParams;
    public int m_R = 255;
    public int m_G = 128;
    public int m_B = 64;
    public int m_Color1 = 50;
    public int m_Color2 = 65;
    public int m_nColor1_R;
    public int m_nColor1_G;
    public int m_nColor1_B;
    public int m_nColor2_R;
    public int m_nColor2_G;
    public int m_nColor2_B;
    public int m_nEnvironment = -1;
    private int m_InitRoadSize;
    public int m_nLandShaftY;
    public int m_nLandAltitude = 0;
    public int m_nType = 0;

    public void Setup(int nInitRoadSize, long[] scaleArray, int nRaysCount) {
        this.m_InitRoadSize = nInitRoadSize;
        this.arrRoadLineParams = new RoadLineParams[nRaysCount];
        for (int i = 0; i < nRaysCount; ++i) {
            int nRoadSize = (int)((long)nInitRoadSize * scaleArray[i]) / 4096;
            this.arrRoadLineParams[i] = new RoadLineParams();
            if (this.m_nType < 2) {
                this.arrRoadLineParams[i].Setup(i, nRaysCount, nRoadSize, this.imageX, this.imageY, this.imageBuff);
                continue;
            }
            long fxBlend = 0L;
            int nT = 4096 * (3 * nRaysCount) / 4;
            if (i * 4096 > nT) {
                fxBlend = 4096 * (4096 * i - nT) / (4096 * nRaysCount - nT);
            }
            this.arrRoadLineParams[i].SetupColor(i, nRaysCount, nRoadSize);
        }
        this.imageBuff = null;
    }

    public void PrepareBuffer(Image image) {
        if (this.m_nType < 2) {
            int scanline = image.getWidth();
            int srcw = image.getWidth();
            int srch = image.getHeight();
            this.imageBuff = new int[srcw * srch];
            image.getRGB(this.imageBuff, 0, scanline, 0, 0, srcw, srch);
            this.imageX = srcw;
            this.imageY = srch;
        }
    }

    void DrawLand(int nStartY) {
        long r1 = this.m_nColor1_R;
        long g1 = this.m_nColor1_G;
        long b1 = this.m_nColor1_B;
        long r2 = this.m_nColor2_R;
        long g2 = this.m_nColor2_G;
        long b2 = this.m_nColor2_B;
        if (CGEngine.testApp.roadLineParamsSize > this.m_nLandAltitude) {
            this.m_nLandAltitude = CGEngine.testApp.roadLineParamsSize;
        }
        int nY = 0;
        long nIndex = 0L;
        for (nY = nStartY; nY >= nStartY - this.m_nLandAltitude; --nY) {
            long fxF = 4096L * nIndex / (long)this.m_nLandShaftY;
            int r = (int)((fxF * r1 + (4096L - fxF) * r2) / 4096L);
            int g = (int)((fxF * g1 + (4096L - fxF) * g2) / 4096L);
            int b = (int)((fxF * b1 + (4096L - fxF) * b2) / 4096L);
            int color = r << 16 | g << 8 | b;
            Graphic2D.DrawLine(color, 0, nY, CGEngine.testApp.m_Camera.m_nScreenXSize, nY);
            ++nIndex;
        }
    }

    public void RenderRoadLine2Image(Image image, int x, int y) {
        Graphic2D.DrawImage(image, x, y, 20);
    }

    void DrawLine(int nIndex, int nRayIndex, long dist, int nX, int nY, long fxTextureV) {
        int nTextureY = (int)((long)this.imageX * (fxTextureV - 4096L * (fxTextureV / 4096L)) / 4096L);
        long distScale = CGEngine.testApp.m_Camera.GetScaleForDistance(dist);
        int nRetImageSize = (int)(distScale * (long)this.m_InitRoadSize / 4096L);
        if (this.m_nType == 0) {
            this.RenderRoadLine2Image(this.arrRoadLineParams[nRayIndex].m_array[nTextureY % this.imageY], nX - nRetImageSize / 2, nY);
        } else if (this.m_nType == 1) {
            if (fxTextureV % 128L > 64L) {
                this.RenderRoadLine2Image(this.arrRoadLineParams[nRayIndex].m_array[0], nX - nRetImageSize / 2, nY);
            } else {
                this.RenderRoadLine2Image(this.arrRoadLineParams[nRayIndex].m_array[1], nX - nRetImageSize / 2, nY);
            }
        } else {
            Graphic2D.DrawLine(this.arrRoadLineParams[nRayIndex].m_color, nX - nRetImageSize / 2, nY, nX + nRetImageSize / 2, nY);
        }
    }

    public void SetImage(Image im) {
        this.PrepareBuffer(im);
    }
}

