/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.project_gameplay.CGUserCareer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class BestScores {
    public int currentTrackToShowBS = 0;
    public static boolean[] tracksUnlocked = new boolean[9];

    public static void unlockNextLevel(int currID) {
        if (currID + 1 < tracksUnlocked.length) {
            BestScores.tracksUnlocked[currID + 1] = true;
        }
    }

    public static void unlockAllLevelsAndKarts() {
        int i;
        for (i = 0; i < 9; ++i) {
            BestScores.tracksUnlocked[i] = true;
        }
        for (i = 1; i < CGUserCareer.tracksUnlocked.length; ++i) {
            CGUserCareer.tracksUnlocked[i] = true;
        }
        CGUserCareer.UnlockAllCars();
    }

    public void initDefaultBestScores() {
        for (int i = 0; i < 9; ++i) {
            BestScores.tracksUnlocked[i] = i < 1;
        }
    }

    public void readBestResultsFromStore() {
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)"BestResults", (boolean)true);
            if (recordStore != null && recordStore.getNumRecords() != 0) {
                ByteArrayInputStream bais = new ByteArrayInputStream(recordStore.getRecord(1));
                DataInputStream inputStream = new DataInputStream(bais);
                this.readLockUnlockState(inputStream);
            }
            recordStore.closeRecordStore();
        }
        catch (RecordStoreException rse) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void resetBestScores() {
        this.initDefaultBestScores();
        this.writeBestResultsToStore();
    }

    public void writeBestResultsToStore() {
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)"BestResults", (boolean)true);
        }
        catch (RecordStoreException rse) {
            // empty catch block
        }
        if (recordStore != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream outputStream = new DataOutputStream(baos);
            try {
                this.writeLockUnlockState(outputStream);
            }
            catch (IOException ioe) {
                // empty catch block
            }
            byte[] b = baos.toByteArray();
            try {
                if (recordStore.getNumRecords() != 0) {
                    recordStore.setRecord(1, b, 0, b.length);
                } else {
                    recordStore.addRecord(b, 0, b.length);
                }
                recordStore.closeRecordStore();
            }
            catch (RecordStoreException rse) {
                // empty catch block
            }
        }
    }

    private void readLockUnlockState(DataInputStream inputStream) throws IOException {
        for (int i = 0; i < 9; ++i) {
            BestScores.tracksUnlocked[i] = inputStream.readBoolean();
        }
    }

    private void writeLockUnlockState(DataOutputStream outputStream) throws IOException {
        for (int i = 0; i < 9; ++i) {
            outputStream.writeBoolean(tracksUnlocked[i]);
        }
    }
}

