/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core.Utils;
import baltorogames.core_gui.UIAnimatedButtonH;
import baltorogames.core_gui.UIButton;
import baltorogames.core_gui.UIScreen;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.CGUserCareer;
import baltorogames.project_gui.EventScreen;
import baltorogames.project_gui.MainMenu;
import baltorogames.project_gui.MainUSRScreen;
import baltorogames.project_gui.SelectWorld;
import baltorogames.project_gui.SingleRace;
import baltorogames.system.ObjectsCache;
import baltorogames.system.Options;
import java.util.Vector;

public class CarSelectionScreen
extends MainUSRScreen {
    private final int LEFT_ARROW_ID;
    private final int RIGHT_ARROW_ID;
    private int currentMenuElement = 0;
    public static int NUM_MENU_ELEMENTS = 5;
    public String[] carNames = new String[]{"Ranger", "Shadow", "VSpeed200", "Thunder", "16VTurbo", "Supersonic", "Amortene", "Blue Crow", "Zatenno", "UmbertoZ"};
    public String selName;
    private CGTexture carTexture;
    private CGTexture carBg;
    private Vector unlockKartInfo;
    private String unlockKartInfoUnsplit;
    private Vector unlockedKartInfo;
    private String unlockedKartInfoUnsplit;
    private UIScreen ref;
    int carPositioning;
    private CGTexture locked;
    private String carID;
    private String carPrice;
    private static int SCROLL_SPEED = 40;
    int scrollX = 0;
    int scrollXMax = 0;
    private String[] menuElements = new String[]{"ID_KART1_NAME", "ID_KART2_NAME", "ID_KART3_NAME", "ID_KART4_NAME", "ID_KART5_NAME"};
    private float[][] carStats = new float[][]{{0.2f, 0.3f, 0.2f, 0.1f, 0.3f}, {0.3f, 0.4f, 0.2f, 0.2f, 0.4f}, {0.4f, 0.3f, 0.3f, 0.5f, 0.3f}, {0.5f, 0.3f, 0.4f, 0.4f, 0.5f}, {0.6f, 0.5f, 0.3f, 0.2f, 0.4f}, {0.6f, 0.3f, 0.5f, 0.3f, 0.4f}, {0.4f, 0.3f, 0.3f, 0.2f, 0.5f}, {0.7f, 0.5f, 0.4f, 0.3f, 0.6f}, {0.6f, 0.3f, 0.5f, 0.5f, 0.7f}, {0.8f, 0.7f, 0.5f, 0.4f, 0.8f}};
    private static String[] carTextures = new String[]{"/car_1.png", "/car_2.png", "/car_3.png", "/car_4.png", "/car_5.png"};

    public void autoSize() {
    }

    public CarSelectionScreen(UIScreen ref) {
        this.LEFT_ARROW_ID = 100;
        this.RIGHT_ARROW_ID = 101;
        CGUserCareer.unlockCar();
        this.ref = ref;
        this.drawFP = false;
        this.drawCash = false;
        this.drawStrip1 = false;
        this.drawStrip3 = false;
        this.drawLogo = true;
        CGUserCareer.currentKart = this.currentMenuElement;
        this.scrollX = ApplicationData.screenWidth;
        this.updateScreenInfo();
        this.locked = TextureManager.AddTexture("/car_locked.png");
        this.strip1Y = MainUSRScreen.getStrip1Height();
        this.strip3Y = ApplicationData.screenHeight - 2 * ObjectsCache.menuFooterImage.GetHeight() - MainUSRScreen.getStrip3Height() / 2;
        int arrowsY = this.carPositioning = (this.strip1Y + MainUSRScreen.getStrip1Height() / 2 + this.strip3Y - MainUSRScreen.getStrip3Height() / 2) / 2;
        int arrowLeftX = 0;
        int arrowRightX = ApplicationData.screenWidth - ObjectsCache.scrollRightImg.GetWidth();
        UIAnimatedButtonH rightB = new UIAnimatedButtonH(arrowRightX - ObjectsCache.menuWhiteDot.GetHeight(), ApplicationData.screenHeight / 2 - this.carTexture.GetHeight() / 2 - ObjectsCache.scrollLeftImg.GetHeight() / 2, ObjectsCache.scrollRightImg, ObjectsCache.scrollRightWImg, 101);
        rightB.setScreen(this);
        rightB.setAnimDir(1);
        this.addButton(rightB);
        UIAnimatedButtonH leftB = new UIAnimatedButtonH(arrowLeftX + ObjectsCache.menuWhiteDot.GetHeight(), ApplicationData.screenHeight / 2 - this.carTexture.GetHeight() / 2 - ObjectsCache.scrollLeftImg.GetHeight() / 2, ObjectsCache.scrollLeftImg, ObjectsCache.scrollLeftWImg, 100);
        leftB.setScreen(this);
        leftB.setAnimDir(-1);
        this.addButton(leftB);
    }

    public void onUpdate(int deltaTime) {
        this.lifeTime += deltaTime;
        this.scrollX -= SCROLL_SPEED * deltaTime;
        if (this.scrollX < this.scrollXMax) {
            this.scrollX = ApplicationData.screenWidth;
        }
    }

    public void draw() {
        this.carBg = TextureManager.AddTexture("/car_bg.png");
        if (CGUserCareer.isKartAvailable(this.currentMenuElement)) {
            Graphic2D.DrawImage(this.carBg, ApplicationData.screenWidth / 2, ApplicationData.screenHeight / 2 - this.carTexture.GetHeight() / 2, 3);
            Graphic2D.DrawImage(this.carTexture, ApplicationData.screenWidth / 2, ApplicationData.screenHeight / 2 - this.carTexture.GetHeight() / 2, 3);
        } else {
            Graphic2D.DrawImage(this.carBg, ApplicationData.screenWidth / 2, ApplicationData.screenHeight / 2 - this.carTexture.GetHeight() / 2, 3);
            Graphic2D.DrawImage(this.locked, ApplicationData.screenWidth / 2, ApplicationData.screenHeight / 2 - this.carTexture.GetHeight() / 2, 3);
        }
        this.drawStatistics(ApplicationData.screenWidth / 2 + ObjectsCache.upgradeBarEmpty.GetWidth() / 3, ApplicationData.screenHeight / 2 + this.carTexture.GetHeight() * 2 / 3);
        Utils.drawString(this.selName, ApplicationData.screenWidth / 2, ApplicationData.screenHeight / 2 + this.carTexture.GetHeight() / 2, 33, 0);
    }

    public boolean rightSoftButton() {
        if (CGUserCareer.isAnyGameStored()) {
            UIScreen.SetCurrentScreen(new MainMenu());
        } else {
            UIScreen.SetCurrentScreen(new SingleRace());
        }
        return true;
    }

    public boolean leftSoftButton() {
        if (CGUserCareer.isKartAvailable(this.currentMenuElement)) {
            if (CGUserCareer.isKartAvailable(this.currentMenuElement)) {
                CGUserCareer.currentKart = this.currentMenuElement;
            }
            if (CGEngine.selectedGameMode == 2) {
                UIScreen.SetCurrentScreen(new EventScreen());
            } else {
                UIScreen.SetCurrentScreen(new SelectWorld());
            }
            return true;
        }
        return false;
    }

    public boolean selectLeftAction() {
        UIButton b = this.findByID(100);
        if (b != null) {
            b.setSelect(true);
            return true;
        }
        return false;
    }

    public boolean selectRightAction() {
        UIButton b = this.findByID(101);
        if (b != null) {
            b.setSelect(true);
            return true;
        }
        return false;
    }

    public boolean actionSoftButton(int nID, boolean pressed) {
        if (super.actionSoftButton(nID, pressed)) {
            return true;
        }
        if (!pressed) {
            this.unselectAllButtons();
            if (nID == 100) {
                this.onLeftAction();
                return true;
            }
            if (nID == 101) {
                this.onRightAction();
                return true;
            }
        }
        return false;
    }

    public boolean onRightAction() {
        ++this.currentMenuElement;
        if (this.currentMenuElement >= this.menuElements.length) {
            this.currentMenuElement = 0;
        }
        this.updateScreenInfo();
        return true;
    }

    public boolean onLeftAction() {
        --this.currentMenuElement;
        if (this.currentMenuElement < 0) {
            this.currentMenuElement = this.menuElements.length - 1;
        }
        this.updateScreenInfo();
        return true;
    }

    public void updateScreenInfo() {
        CGUserCareer.currentKart = this.currentMenuElement;
        this.carTexture = TextureManager.AddTexture(carTextures[this.currentMenuElement]);
        if (this.carTexture == null) {
            this.carTexture = TextureManager.AddTexture("/car_1.png");
        }
        if (CGUserCareer.isKartAvailable(this.currentMenuElement)) {
            this.setSoftButtonImage(ObjectsCache.menuSbOK, ObjectsCache.menuSbOK_a, ObjectsCache.menuSbBACK, ObjectsCache.menuSbBACK_a);
        } else {
            this.setSoftButtonImage(null, null, ObjectsCache.menuSbBACK, ObjectsCache.menuSbBACK_a);
        }
        this.selName = ApplicationData.defaultFont.encodeDynamicString(this.carNames[this.currentMenuElement]);
        this.carID = ApplicationData.defaultFont.encodeDynamicString(this.currentMenuElement + 1 + "/" + this.menuElements.length);
        this.carPrice = ApplicationData.defaultFont.encodeDynamicString("$50" + this.currentMenuElement);
    }

    public boolean onFireAction() {
        return this.leftSoftButton();
    }

    private void drawDots(int numElements, int current, int xPos, int yPos) {
        if (numElements > 0) {
            int startSquaresX = ApplicationData.screenWidth / 2 - this.carBg.GetWidth() / 2 + ObjectsCache.menuRedDot.GetWidth();
            for (int i = 0; i < numElements; ++i) {
                int xOffset = startSquaresX + i * (int)((float)ObjectsCache.menuRedDot.GetWidth() * 2.4f);
                Graphic2D.DrawImage(i == current ? ObjectsCache.menuWhiteDot : ObjectsCache.menuRedDot, xOffset, yPos, 17);
            }
        }
    }

    private void drawStat(int x, int y, float currValue, float afterTune) {
        int barW = ObjectsCache.upgradeBarFull.GetWidth();
        int barH = ObjectsCache.upgradeBarFull.GetHeight();
        Graphic2D.DrawImage(ObjectsCache.upgradeBarFull, x, y, 20);
        Graphic2D.SetClip(x, y, (int)(afterTune * (float)barW), barH);
        Graphic2D.SetClip(x, y, (int)(currValue * (float)barW), barH);
        Graphic2D.DrawImage(ObjectsCache.upgradeBarEmpty, x, y, 20);
        Graphic2D.SetClip(0, 0, ApplicationData.screenWidth, ApplicationData.screenHeight);
    }

    private void drawStatistics(int xPos, int yPos) {
        int nDY = ObjectsCache.upgradeBarFull.GetHeight() + ObjectsCache.upgradeBarFull.GetHeight() / 5;
        this.drawStat(xPos, yPos, this.carStats[this.currentMenuElement][0], 0.0f);
        this.drawStat(xPos, yPos + nDY, this.carStats[this.currentMenuElement][1], 3.0f);
        this.drawStat(xPos, yPos + 2 * nDY, this.carStats[this.currentMenuElement][2], 1.0f);
        this.drawStat(xPos, yPos + 3 * nDY, this.carStats[this.currentMenuElement][3], 1.0f);
        this.drawStat(xPos, yPos + 4 * nDY, this.carStats[this.currentMenuElement][4], 2.0f);
        int nStartY = yPos + ObjectsCache.upgradeBarFull.GetHeight() / 2;
        Utils.drawString(ApplicationData.lp.getTranslatedString(Options.languageID, "ID_TUNING_POWER"), xPos - ObjectsCache.upgradeBarFull.GetWidth() / 10, nStartY, 10, 0);
        Utils.drawString(ApplicationData.lp.getTranslatedString(Options.languageID, "ID_TUNING_HANDLING"), xPos - ObjectsCache.upgradeBarFull.GetWidth() / 10, nStartY + nDY, 10, 0);
        Utils.drawString(ApplicationData.lp.getTranslatedString(Options.languageID, "ID_TUNING_NITRO"), xPos - ObjectsCache.upgradeBarFull.GetWidth() / 10, nStartY + 2 * nDY, 10, 0);
        Utils.drawString(ApplicationData.lp.getTranslatedString(Options.languageID, "ID_TUNING_BOOST_POWER"), xPos - ObjectsCache.upgradeBarFull.GetWidth() / 10, nStartY + 3 * nDY, 10, 0);
        Utils.drawString(ApplicationData.lp.getTranslatedString(Options.languageID, "ID_TUNING_BOOST_TIME"), xPos - ObjectsCache.upgradeBarFull.GetWidth() / 10, nStartY + 4 * nDY, 10, 0);
    }

    private void drawKartUnlockInfo(int yPos) {
        if (this.unlockKartInfo == null) {
            this.updateKartUnlockInfo();
        }
        try {
            Utils.drawString(this.unlockKartInfo, ApplicationData.screenWidth >> 1, yPos - ApplicationData.defaultFont.getFontHeight() * 3, 3, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void drawKartUnlockedInfo(int yPos) {
        if (this.unlockedKartInfo == null) {
            this.updateKartUnlockedInfo();
        }
        Utils.drawString(this.unlockedKartInfo, ApplicationData.screenWidth >> 1, yPos - ApplicationData.defaultFont.getFontHeight() * 2, 3, 0);
    }

    private void updateKartUnlockInfo() {
        String textToShow = null;
        if (this.currentMenuElement > 0) {
            switch (this.currentMenuElement) {
                case 1: {
                    textToShow = "ID_UNLOCK_KART_1";
                    break;
                }
                case 2: {
                    textToShow = "ID_UNLOCK_KART_2";
                    break;
                }
                case 3: {
                    textToShow = "ID_UNLOCK_KART_3";
                }
            }
            this.unlockKartInfoUnsplit = ApplicationData.lp.getTranslatedString(Options.languageID, textToShow);
            this.unlockKartInfo = Utils.splitText(this.unlockKartInfoUnsplit, "+", ApplicationData.screenWidth, 0);
            this.scrollXMax = -Utils.stringWidth(this.unlockKartInfoUnsplit, 0);
        }
    }

    private void updateKartUnlockedInfo() {
        String textToShow = null;
        switch (this.currentMenuElement) {
            case 0: {
                textToShow = "ID_UNLOCKED_KART_0";
                break;
            }
            case 1: {
                textToShow = "ID_UNLOCKED_KART_1";
                break;
            }
            case 2: {
                textToShow = "ID_UNLOCKED_KART_2";
                break;
            }
            case 3: {
                textToShow = "ID_UNLOCKED_KART_3";
            }
        }
        this.unlockedKartInfoUnsplit = ApplicationData.lp.getTranslatedString(Options.languageID, textToShow);
        this.unlockedKartInfo = Utils.splitText(this.unlockedKartInfoUnsplit, "+", ApplicationData.screenWidth, 0);
        this.scrollXMax = -Utils.stringWidth(this.unlockedKartInfoUnsplit, 0);
    }
}

