/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gameplay.CGEngine;
import java.io.DataInputStream;
import java.io.IOException;

public class CGBillboardObject {
    static final int __OBJECT_START_LEFT__ = 0;
    static final int __OBJECT_START_RIGHT__ = 1;
    static final int __OBJECT_FINISH_LEFT__ = 2;
    static final int __OBJECT_FINISH_RIGHT__ = 3;
    static final int __OBJECT_LAMP_LEFT__ = 4;
    static final int __OBJECT_LAMP_RIGHT__ = 5;
    static final int __OBJECT_SIGN1__ = 6;
    static final int __OBJECT_SIGN2__ = 7;
    static final int __OBJECT_HUT_S1_RIGHT__ = 8;
    static final int __OBJECT_HUT_S1_LEFT__ = 9;
    static final int __OBJECT_TREE2_S1_RIGHT__ = 10;
    static final int __OBJECT_TREE2_S1_LEFT__ = 11;
    static final int __OBJECT_BUILDING3_RIGHT__ = 12;
    static final int __OBJECT_BUILDING3_LEFT__ = 13;
    static final int __OBJECT_TREES2__ = 14;
    static final int __OBJECT_HOUSE_RIGHT__ = 15;
    static final int __OBJECT_HOUSE_LEFT__ = 16;
    static final int __OBJECT_TRYBUNY_RIGHT__ = 17;
    static final int __OBJECT_TRYBUNY_LEFT__ = 18;
    static final int __OBJECT_CONST_RIGHT__ = 19;
    static final int __OBJECT_CONST_LEFT__ = 20;
    static final int __OBJECT_BALT_SIGN_LEFT__ = 21;
    static final int __OBJECT_PALM__ = 22;
    static final int __OBJECT_LIGHTS_RIGHT__ = 23;
    static final int __OBJECT_LIGHTS_LEFT__ = 24;
    static final int __OBJECT_S1_HUNT__ = 25;
    static final int __OBJECT_S1_TREE__ = 26;
    static final int __OBJECT_S2_HUT__ = 27;
    static final int __OBJECT_S2_SCARE__ = 28;
    static final int __OBJECT_S2_TOWER__ = 29;
    static final int __OBJECT_S2_TREE__ = 30;
    static final int __OBJECT_S3_SOME1__ = 31;
    static final int __OBJECT_S3_SOME2__ = 32;
    static final int __OBJECT_S3_TENT__ = 33;
    static final int __OBJECT_S3_TRAILER__ = 34;
    static final int __OBJECT_TREE__ = 35;
    static final int __LVL_2_SOME_2__ = 36;
    static final int __LVL_1_USA_PLANT__ = 37;
    static final int __LVL1_USA_ST2__ = 38;
    static final int __LVL1_USA_ST2A__ = 39;
    static final int __LVL1_USA_ST3__ = 40;
    static final int __LVL1_USA_STONE1__ = 41;
    static final int __LVL2_2_TRAILER = 42;
    static final int __LVL2_S3TENT__ = 43;
    static final int __LVL3_LAMP1__ = 44;
    static String[] bilboardsFilename = new String[]{"/gameplay/common/start.png", "/gameplay/common/start.png", "/gameplay/common/finish.png", "/gameplay/common/finish.png", "/gameplay/lamp1.png", "/gameplay/lamp1.png", "/gameplay/sign1.png", "/gameplay/sign2.png", "/gameplay/s1_hut.png", "/gameplay/s1_hut.png", "/gameplay/s1_tree.png", "/gameplay/s1_tree.png", "/gameplay/building_3.png", "/gameplay/building_3.png", "/gameplay/lvl_1/s3_some1.png", "/gameplay/house.png", "/gameplay/house.png", "/gameplay/trybuny.png", "/gameplay/trybuny.png", "/gameplay/common/baltoro_const.png", "/gameplay/common/baltoro_const.png", "/gameplay/lvl_1/baltoro_sign.png", "/gameplay/lvl_1/s1_hut.png", "/gameplay/common/lights.png", "/gameplay/common/lights.png", "/gameplay/s1_hut.png", "/gameplay/s1_tree.png", "/gameplay/lvl_2/palm.png", "/gameplay/lvl_2/s2_scare.png", "/gameplay/lvl_2/s1_tree.png", "/gameplay/lvl_2/s2_tree.png", "/gameplay/lvl_3/sign1.png", "/gameplay/lvl_3/sign2.png", "/gameplay/s3_tent.png", "/gameplay/s3_trailer.png", "/gameplay/tree.png", "/gameplay/lvl_1/s3_some2.png", "/gameplay/lvl_1/usa_plant.png", "/gameplay/lvl_1/usa_st2.png", "/gameplay/lvl_1/usa_st2a.png", "/gameplay/lvl_1/usa_st3.png", "/gameplay/lvl_1/usa_stone1.png", "/gameplay/lvl_2/s3_trailer.png", "/gameplay/lvl_2/s3_tent.png", "/gameplay/lvl_3/lamp1.png"};
    static int[] bilboardsWidths = new int[]{309, 206, 167, 167, 85, 85, 173, 173, 120, 120, 120, 120, 147, 147, 63, 176, 176, 198, 198, 22, 21, 187, 82, 34, 34, 120, 120, 93, 54, 50, 45, 83, 82, 50, 80, 53, 46, 91, 54, 54, 28, 68, 160, 101, 82};
    static int[] bilboardsHeights = new int[]{134, 89, 67, 67, 150, 150, 150, 150, 102, 102, 85, 85, 250, 250, 120, 133, 133, 132, 132, 14, 13, 107, 102, 28, 28, 102, 85, 120, 50, 120, 120, 50, 50, 60, 41, 122, 120, 64, 57, 108, 48, 64, 76, 120, 150};
    static int[] bilboardsScale = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    static int[] bilboardsIsMirrored = new int[]{0, 1, 0, 1, 1, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1};
    public long m_fxX;
    public long m_fxY;
    public long m_fxZ;
    public long m_fxH;
    public long m_fxW;
    public long m_fxTrX;
    public long m_fxTrY;
    public long m_fxTrZ;
    public int m_nMirrored = 0;
    public int m_nLinearScale;
    public long m_fxDistanceFromStart;
    public int m_nCarIndex = 0;
    public CGTexture m_Texture;

    public void deSerialize(DataInputStream dis) throws IOException {
        int nL = dis.readInt();
        char[] szTextureName = new char[nL];
        for (int i = 0; i < nL; ++i) {
            char b;
            szTextureName[i] = b = (char)dis.readByte();
        }
        String str = new String(szTextureName);
        String szFullName = "/" + str;
        this.m_fxX = dis.readInt() * 4096;
        this.m_fxZ = dis.readInt() * 4096;
        this.m_fxW = dis.readInt() * 4096;
        this.m_fxH = dis.readInt() * 4096;
        this.m_fxY = dis.readInt() * 4096;
        this.m_nLinearScale = dis.readInt();
        this.m_nMirrored = dis.readInt();
        if (this.m_nMirrored > 0) {
            this.m_nMirrored = 2;
        }
        long fxScaleMin = CGEngine.testApp.GetMaxObjectsDistanceScale();
        long fxDeltaScale = (4096L - fxScaleMin) / (long)(CGTexture.m_nNrOfMipMaps - 1);
        int[] arrWidth = new int[CGTexture.m_nNrOfMipMaps];
        int[] arrHeight = new int[CGTexture.m_nNrOfMipMaps];
        for (int i = 0; i < CGTexture.m_nNrOfMipMaps; ++i) {
            arrWidth[i] = (int)(CGEngine.testApp.m_Camera.m_fxCameraScale * (this.m_fxW / 4096L) * (fxScaleMin + (long)i * fxDeltaScale) / 0x1000000L);
            arrHeight[i] = (int)(CGEngine.testApp.m_Camera.m_fxCameraScale * (this.m_fxH / 4096L) * (fxScaleMin + (long)i * fxDeltaScale) / 0x1000000L);
        }
        this.m_Texture = TextureManager.AddTexture(szFullName, 0, 1, arrWidth, arrHeight);
    }

    public static CGBillboardObject CreateBillboardObject(int nType, long x, long y, long z) {
        String szFullName = null;
        CGBillboardObject pO = new CGBillboardObject();
        pO.m_fxX = x;
        pO.m_fxY = y;
        pO.m_fxZ = z;
        pO.m_fxW = bilboardsWidths[nType] << 12;
        pO.m_fxH = bilboardsHeights[nType] << 12;
        pO.m_nLinearScale = bilboardsScale[nType];
        pO.m_nMirrored = bilboardsIsMirrored[nType];
        szFullName = bilboardsFilename[nType];
        if (szFullName != null) {
            if (pO.m_nMirrored > 0) {
                pO.m_nMirrored = 2;
            }
            CGTexture.m_nNrOfMipMaps = CGTexture.m_NrOfMipMapsForObjects;
            long fxScaleMin = 13L * CGEngine.testApp.GetMaxObjectsDistanceScale() / 10L;
            long fxDeltaScale = (4096L - fxScaleMin) / (long)CGTexture.m_nNrOfMipMaps;
            int[] arrWidth = new int[CGTexture.m_nNrOfMipMaps];
            int[] arrHeight = new int[CGTexture.m_nNrOfMipMaps];
            for (int i = 0; i < CGTexture.m_nNrOfMipMaps; ++i) {
                arrWidth[i] = (int)(CGEngine.testApp.m_Camera.m_fxCameraScale * (pO.m_fxW / 4096L) * (fxScaleMin + (long)i * fxDeltaScale) / 0x1000000L);
                arrHeight[i] = (int)(CGEngine.testApp.m_Camera.m_fxCameraScale * (pO.m_fxH / 4096L) * (fxScaleMin + (long)i * fxDeltaScale) / 0x1000000L);
            }
            pO.m_Texture = TextureManager.AddTexture(szFullName, 0, 1, arrWidth, arrHeight);
        }
        return pO;
    }
}

