/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.core;

import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;
import baltorogames.system.FileManager;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CustomFont {
    public static final int STYLE_PLAIN = 0;
    public static final int STYLE_BOLD = 1;
    public static final int STYLE_ITALIC = 2;
    public static final int STYLE_UNDERLINED = 4;
    private int style;
    private int size;
    private int baseline;
    private int height;
    private int width;
    public int alignTopOffset;
    public int alignBottomOffset;
    public int alignVCenterOffset;
    private CGTexture image;
    private int textureSize;
    private int NUM_COLUMNS;
    private int NUM_ROWS;
    private short[] charCodes = null;
    private int[] posXOnBMP = null;
    private int[] posYOnBMP = null;
    private int[] charWidths = null;
    private int fontSpacing = 0;
    char[] characters = new char[8];
    char[] characters2 = new char[10];

    public int getFontHeight() {
        return this.height + this.getFontSpacing();
    }

    public int getFontSpacing() {
        return this.fontSpacing;
    }

    public static CustomFont getFont(String fontDefinitionFile, String bitmapFileName) {
        CustomFont newFont = new CustomFont();
        try {
            InputStream is = FileManager.OpenFile(fontDefinitionFile);
            DataInputStream dis = new DataInputStream(is);
            newFont.createFontFromStream(dis, bitmapFileName);
            dis.close();
        }
        catch (Exception e) {
            return null;
        }
        return newFont;
    }

    public static CustomFont getFont(String fontDefinitionFile, int spacing) {
        CustomFont f = CustomFont.getFont(fontDefinitionFile, "");
        if (f != null) {
            f.fontSpacing = spacing;
        }
        return f;
    }

    public static CustomFont getFont(String fontDefinitionFile, int spacing, String bitmapFileName) {
        CustomFont f = CustomFont.getFont(fontDefinitionFile, bitmapFileName);
        if (f != null) {
            f.fontSpacing = spacing;
        }
        return f;
    }

    public CustomFont createFontFromStream(DataInputStream dis, String bitmapFileName) throws IOException {
        String fontName = this.deSerializeString(dis);
        this.image = bitmapFileName != null && bitmapFileName.length() > 0 ? TextureManager.AddTexture(bitmapFileName) : TextureManager.AddTexture("/" + fontName);
        int defaultTextureSize = dis.readInt();
        int textureSize = this.image.GetWidth();
        long lScale = 4096 * textureSize / defaultTextureSize;
        this.NUM_COLUMNS = this.NUM_ROWS = dis.readInt();
        this.width = this.height = textureSize / this.NUM_ROWS;
        int numLetters = this.NUM_COLUMNS * this.NUM_ROWS;
        this.charCodes = new short[numLetters];
        this.posXOnBMP = new int[numLetters];
        this.posYOnBMP = new int[numLetters];
        this.charWidths = new int[numLetters];
        for (int i = 0; i < numLetters; ++i) {
            this.charCodes[i] = dis.readShort();
            this.posXOnBMP[i] = (int)((long)dis.readInt() * lScale) / 4096;
            this.posYOnBMP[i] = (int)((long)dis.readInt() * lScale) / 4096;
            this.charWidths[i] = (int)((long)dis.readInt() * lScale) / 4096;
            if (this.charCodes[i] <= 0) continue;
            System.out.println("Letter,x,y,w: " + this.charCodes[i] + "," + this.posXOnBMP[i] + "," + this.posYOnBMP[i] + "," + this.charWidths[i]);
        }
        return null;
    }

    public int getBaselinePosition() {
        return this.baseline;
    }

    public int getSize() {
        return this.size;
    }

    public int getStyle() {
        return this.style;
    }

    public boolean isBold() {
        return (this.style & 1) != 0;
    }

    public boolean isItalic() {
        return (this.style & 2) != 0;
    }

    public boolean isPlain() {
        return this.style == 0;
    }

    public boolean isUnderlined() {
        return (this.style & 4) != 0;
    }

    public void encodeDynamicStringBuffer(StringBuffer in) {
        for (int i = 0; i < in.length(); ++i) {
            in.setCharAt(i, (char)this.getDecodedCharIndex((short)in.charAt(i)));
        }
    }

    public String encodeDynamicString(String in) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < in.length(); ++i) {
            sb.append((char)this.getDecodedCharIndex((short)in.charAt(i)));
        }
        return sb.toString();
    }

    public String decodeString(String in) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < in.length(); ++i) {
            sb.append((char)this.getCharFromIndex(in.charAt(i)));
        }
        return sb.toString();
    }

    public int getDecodedCharIndex(short unicodeChar) {
        for (int i = 0; i < this.charCodes.length; ++i) {
            if (unicodeChar != this.charCodes[i]) continue;
            return i;
        }
        return -1;
    }

    public short getCharFromIndex(int index) {
        return this.charCodes[index];
    }

    public int getCharOnBMPIndex(char character) {
        return character;
    }

    public int charsWidth(String str, int offset, int length) {
        int pixelLength = 0;
        for (int i = offset; i < offset + length; ++i) {
            char onBMPIndex = (char)this.getCharOnBMPIndex(str.charAt(i));
            pixelLength += this.charWidth(onBMPIndex);
        }
        return pixelLength;
    }

    public int charsWidth(StringBuffer str, int offset, int length) {
        int pixelLength = 0;
        for (int i = offset; i < offset + length; ++i) {
            char onBMPIndex = (char)this.getCharOnBMPIndex(str.charAt(i));
            pixelLength += this.charWidth(onBMPIndex);
        }
        return pixelLength;
    }

    public int charWidth(char ch) {
        if (ch >= this.charWidths.length) {
            return 0;
        }
        return this.charWidths[ch];
    }

    public int stringWidth(String str) {
        return this.charsWidth(str, 0, str.length());
    }

    public void drawChar(char character, int x, int y, int anchor) {
        this.drawCharInternal(character, x, y, anchor);
    }

    public void drawChars(String data, int offset, int length, int x, int y, int anchor) {
        if ((anchor & 0x10) != 0) {
            y += this.alignTopOffset;
        }
        if ((anchor & 0x20) != 0) {
            y += this.alignBottomOffset;
        }
        if ((anchor & 2) != 0) {
            y += this.alignVCenterOffset;
        }
        if ((anchor & 8) != 0) {
            x -= this.charsWidth(data, offset, length);
        } else if ((anchor & 1) != 0) {
            x -= this.charsWidth(data, offset, length) / 2;
        }
        for (int i = 0; i < length; ++i) {
            char c = data.charAt(offset + i);
            this.drawCharInternal((char)this.getCharOnBMPIndex(c), x, y, 20);
            x += this.charWidth((char)this.getCharOnBMPIndex(c));
        }
    }

    public void drawTimeChars(long _currentTime, int p, int x, int y, int anchor) {
        int index = 0;
        long seconds = _currentTime / 1000L;
        long m = seconds / 60L;
        long s = seconds % 60L;
        long mm = _currentTime % 1000L / 10L;
        this.characters[index++] = (char)(16L + m / 10L);
        this.characters[index++] = (char)(16L + m % 10L);
        this.characters[index++] = 26;
        this.characters[index++] = (char)(16L + s / 10L);
        this.characters[index++] = (char)(16L + s % 10L);
        this.characters[index++] = 26;
        this.characters[index++] = (char)(16L + mm / 10L);
        this.characters[index++] = (char)(16L + mm % 10L);
        int nH = 0;
        for (int i = 0; i < 8; ++i) {
            nH += this.charWidth((char)this.getCharOnBMPIndex(this.characters[i]));
        }
        if ((anchor & 8) != 0) {
            x -= nH;
        } else if ((anchor & 1) != 0) {
            x -= nH / 2;
        }
        for (int i = 0; i < 8; ++i) {
            char c = this.characters[i];
            this.drawCharInternal((char)this.getCharOnBMPIndex(c), x, y, 20);
            x += this.charWidth((char)this.getCharOnBMPIndex(c));
        }
    }

    public void drawTimeChars2(long _currentTime, boolean lessThan0, int p, int x, int y, int anchor) {
        int index = 0;
        long seconds = _currentTime / 1000L;
        long m = seconds / 60L;
        long s = seconds % 60L;
        long mm = _currentTime % 1000L / 10L;
        this.characters2[index++] = '\u0000';
        this.characters2[index++] = lessThan0 ? 13 : 11;
        this.characters2[index++] = (char)(16L + m / 10L);
        this.characters2[index++] = (char)(16L + m % 10L);
        this.characters2[index++] = 26;
        this.characters2[index++] = (char)(16L + s / 10L);
        this.characters2[index++] = (char)(16L + s % 10L);
        this.characters2[index++] = 26;
        this.characters2[index++] = (char)(16L + mm / 10L);
        this.characters2[index++] = (char)(16L + mm % 10L);
        int nH = 0;
        for (int i = 0; i < 10; ++i) {
            nH += this.charWidth((char)this.getCharOnBMPIndex(this.characters2[i]));
        }
        if ((anchor & 8) != 0) {
            x -= nH;
        } else if ((anchor & 1) != 0) {
            x -= nH / 2;
        }
        for (int i = 0; i < 10; ++i) {
            char c = this.characters2[i];
            this.drawCharInternal((char)this.getCharOnBMPIndex(c), x, y, 20);
            x += this.charWidth((char)this.getCharOnBMPIndex(c));
        }
    }

    public void drawSpeedChars(long _speed, int x, int y, int anchor) {
        if (_speed < 0L) {
            _speed = 0L;
        }
        long h = _speed / 100L;
        long d = (_speed - h * 100L) / 10L;
        long u = _speed - h * 100L - d * 10L;
        this.characters[0] = (char)h;
        this.characters[1] = (char)d;
        this.characters[2] = (char)u;
        for (int i = 0; i < 3; ++i) {
            char c = this.characters[i];
            this.drawCharInternal(c, x, y, 20);
            x += this.charWidth((char)this.getCharOnBMPIndex(c));
        }
    }

    public void drawPointsChars(long _speed, int x, int y, int anchor) {
        if (_speed < 0L) {
            _speed = 0L;
        }
        long h = _speed / 1000L;
        long d = (_speed - h * 1000L) / 100L;
        long u = (_speed - h * 1000L - d * 100L) / 10L;
        long v = _speed - h * 1000L - d * 100L - u * 10L;
        this.characters[0] = (char)h;
        this.characters[1] = (char)d;
        this.characters[2] = (char)u;
        this.characters[3] = (char)v;
        for (int i = 0; i < 4; ++i) {
            char c = this.characters[i];
            this.drawCharInternal(c, x, y, 20);
            x += this.charWidth((char)this.getCharOnBMPIndex(c));
        }
    }

    public void drawPosChars(int _speed, int x, int y, int anchor) {
        if (_speed < 0) {
            _speed = 0;
        }
        int h = _speed / 10;
        int d = _speed - h * 10;
        this.characters[0] = (char)h;
        this.characters[1] = (char)d;
        if (h == 0) {
            char c = this.characters[1];
            this.drawCharInternal(c, x, y, 20);
        } else {
            for (int i = 0; i < 2; ++i) {
                char c = this.characters[i];
                this.drawCharInternal(c, x, y, 20);
                x += this.charWidth((char)this.getCharOnBMPIndex(c));
            }
        }
    }

    public void drawComboChars(long _speed, int x, int y, int anchor) {
        if (_speed < 0L) {
            _speed = 0L;
        }
        long h = _speed / 100L;
        long d = (_speed - h * 100L) / 10L;
        long u = _speed - h * 100L - d * 10L;
        this.characters[0] = (char)h;
        this.characters[1] = (char)d;
        this.characters[2] = (char)u;
        for (int i = 0; i < 3; ++i) {
            char c = this.characters[i];
            if (c <= '\u0000' && i != 2) continue;
            this.drawCharInternal(c, x, y, 20);
            x += this.charWidth((char)this.getCharOnBMPIndex(c));
        }
    }

    public void drawValue(long _val, int x, int y, int anchor) {
        this.drawCharInternal((char)_val, x, y, 20);
    }

    public void drawChars(StringBuffer data, int offset, int length, int x, int y, int anchor) {
        if ((anchor & 8) != 0) {
            x -= this.charsWidth(data, offset, length);
        } else if ((anchor & 1) != 0) {
            x -= this.charsWidth(data, offset, length) / 2;
        }
        if ((anchor & 0x20) != 0) {
            y -= this.height;
        } else if ((anchor & 2) != 0) {
            y -= this.height / 2;
        }
        for (int i = 0; i < length; ++i) {
            char c = data.charAt(offset + i);
            this.drawCharInternal((char)this.getCharOnBMPIndex(c), x, y, anchor);
            x += this.charWidth((char)this.getCharOnBMPIndex(c));
        }
    }

    private void drawCharInternal(char character, int x, int y, int anchor) {
        int clipX = Graphic2D.GetClipX();
        int clipY = Graphic2D.GetClipY();
        int clipW = Graphic2D.GetClipWidth();
        int clipH = Graphic2D.GetClipHeight();
        int charY = character / this.NUM_COLUMNS;
        int charX = character - charY * this.NUM_COLUMNS;
        if ((this.style & 2) != 0) {
            Graphic2D.SetClip(x + 1, y, this.width, this.height / 2);
            Graphic2D.DrawImage(this.image, x - this.width * charX + 1, y - this.height * charY, anchor);
            Graphic2D.SetClip(x, y + this.height / 2, this.width, this.height / 2);
            Graphic2D.DrawImage(this.image, x - this.width * charX, y - this.height * charY, anchor);
            if ((this.style & 1) != 0) {
                Graphic2D.SetClip(x, y, this.width, this.height / 2);
                Graphic2D.DrawImage(this.image, x - this.width * charX + 2, y - this.height * charY, anchor);
                Graphic2D.SetClip(x, y + this.height / 2, this.width, this.height / 2);
                Graphic2D.DrawImage(this.image, x - this.width * charX + 1, y - this.height * charY, anchor);
            }
        } else {
            Graphic2D.SetClip(x, y, this.width, this.height);
            Graphic2D.ClipRect(clipX, clipY, clipW, clipH);
            Graphic2D.DrawImage(this.image, x - this.width * charX, y - this.height * charY, anchor);
            if ((this.style & 1) != 0) {
                Graphic2D.DrawImage(this.image, x - this.width * character + 1, y - this.height * charY, anchor);
            }
        }
        if ((this.style & 4) != 0) {
            Graphic2D.DrawLine(x, y + this.baseline + 2, x + this.width, y + this.baseline + 2);
        }
        Graphic2D.SetClip(clipX, clipY, clipW, clipH);
    }

    public void drawString(String str, int x, int y, int anchor) {
        this.drawChars(str, 0, str.length(), x, y, anchor);
    }

    public void drawSpeedString(long speed, int x, int y, int anchor) {
        this.drawSpeedChars(speed, x, y, anchor);
    }

    public void drawPointsString(long speed, int x, int y, int anchor) {
        this.drawPointsChars(speed, x, y, anchor);
    }

    public void drawTimeString(long _currentTime, int x, int y, int anchor) {
        this.drawTimeChars(_currentTime, 0, x, y, anchor);
    }

    public void drawTimeString2(long _currentTime, boolean lessThan0, int x, int y, int anchor) {
        this.drawTimeChars2(_currentTime, lessThan0, 0, x, y, anchor);
    }

    public void drawPosString(int pos, int x, int y, int anchor) {
        this.drawPosChars(pos, x, y, anchor);
    }

    public void drawString(StringBuffer str, int x, int y, int anchor) {
        this.drawChars(str, 0, str.length(), x, y, anchor);
    }

    public String deSerializeString(DataInputStream dis) throws IOException {
        int nameStringLength = dis.readInt();
        byte[] rawName = new byte[nameStringLength];
        dis.read(rawName, 0, nameStringLength);
        return new String(rawName);
    }
}

