/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.core.ApplicationData;
import baltorogames.core.KeyCommand;
import baltorogames.core.Log;
import baltorogames.core.RandSync;
import baltorogames.core.TouchCommand;
import baltorogames.core_gui.UIScreen;
import baltorogames.gameplay.Game;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;
import baltorogames.particles.CGDynamicObj;
import baltorogames.project_gameplay.AchievementPopup;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.CGEngineRenderer;
import baltorogames.project_gameplay.CGUserCareer;
import baltorogames.project_gameplay.PitStop;
import baltorogames.project_gui.InGameMainMenu;
import baltorogames.system.FileManager;
import baltorogames.system.ObjectsCache;
import java.io.DataInputStream;
import java.io.InputStream;

public class MyGame
extends Game {
    protected DataInputStream m_dis = null;
    public int m_nLoadingStepNr = 0;
    public static final int NUM_WAVES = 10;
    public CGTexture[] m_IconTextures = null;
    public int m_TouchLeftX;
    public int m_TouchLeftY;
    public int m_TouchRightX;
    public int m_TouchRightY;
    public int m_TouchUpX;
    public int m_TouchUpY;
    public int m_TouchDownX;
    public int m_TouchDownY;
    public static boolean upTouchKeyPressed = false;
    public static boolean downTouchKeyPressed = false;
    public static boolean leftTouchKeyPressed = false;
    public static boolean rightTouchKeyPressed = false;
    public static boolean pitTouchKeyPressed = false;

    public int init() {
        CGUserCareer.Reset();
        CGUserCareer.Load();
        ApplicationData.achievements.readFromStore();
        CGDynamicObj.Initialize();
        CGDynamicObj.SetGlobalScale(122880L);
        AchievementPopup.Init();
        RandSync.Init();
        RandSync.SetStartValue((int)System.currentTimeMillis() % 1000);
        return CGEngine.Init();
    }

    public void destroy() {
        CGDynamicObj.Uninitialize();
        CGUserCareer.Save();
        ApplicationData.achievements.writeToStore();
        CGEngine.Destroy();
    }

    public int startLoading(String fileName) {
        TextureManager.ClearTextures();
        CGEngineRenderer.Init();
        this.m_dis = null;
        this.m_nLoadingStepNr = 0;
        return 1;
    }

    public int stepLoading(String fileName) {
        try {
            if (this.m_nLoadingStepNr == 0) {
                InputStream is = FileManager.OpenFile(fileName);
                if (is == null) {
                    System.out.println("is = NULL !!!  " + fileName);
                    this.m_nLoadingStepNr = 1;
                    return 0;
                }
                this.m_dis = new DataInputStream(is);
                this.m_nLoadingStepNr = 1;
            } else if (this.m_nLoadingStepNr == 1) {
                if (this.m_dis != null) {
                    // empty if block
                }
                this.m_nLoadingStepNr = 2;
            } else if (this.m_nLoadingStepNr == 2) {
                if (this.m_dis != null) {
                    CGEngine.Load1(this.m_dis);
                }
                this.m_nLoadingStepNr = 3;
            } else if (this.m_nLoadingStepNr == 3) {
                if (this.m_dis != null) {
                    CGEngine.Load2(this.m_dis);
                }
                this.m_nLoadingStepNr = 4;
            }
            return 1;
        }
        catch (Exception e) {
            Log.DEBUG_LOG(16, "Engine " + fileName + " loading error!!!");
            System.out.println("Err message = " + e.getMessage());
            e.printStackTrace();
            return 0;
        }
    }

    public int endLoading(String fileName) {
        ApplicationData.generalGameMode = 4;
        ApplicationData.SetMusic();
        if (ApplicationData.isTouchScreen) {
            this.m_IconTextures = new CGTexture[4];
            this.m_IconTextures[0] = TextureManager.AddTexture("/Touch_left.png");
            this.m_IconTextures[1] = TextureManager.AddTexture("/Touch_right.png");
            this.m_IconTextures[2] = TextureManager.AddTexture("/Touch_accel.png");
            this.m_IconTextures[3] = TextureManager.AddTexture("/Touch_Brake.png");
            this.m_TouchLeftX = 0;
            this.m_TouchLeftY = ApplicationData.screenHeight - ObjectsCache.menuSbPAUSE.GetHeight() - CGEngine.m_TachoMPH_Texture.GetHeight() - this.m_IconTextures[0].GetHeight() - ApplicationData.defaultFont.getFontHeight() * 2;
            this.m_TouchRightX = ApplicationData.screenWidth - this.m_IconTextures[1].GetWidth();
            this.m_TouchRightY = this.m_TouchLeftY;
            this.m_TouchDownX = 0;
            this.m_TouchUpX = ApplicationData.screenWidth - this.m_IconTextures[1].GetWidth();
            this.m_TouchUpY = this.m_TouchLeftY - this.m_IconTextures[1].GetHeight();
            this.m_TouchDownY = ApplicationData.screenHeight - this.m_IconTextures[3].GetHeight();
        } else {
            this.m_IconTextures = null;
        }
        return 1;
    }

    public void updateLogic(long deltaTimeInMs) {
        CGEngine.Update((int)deltaTimeInMs);
    }

    public void drawGamePlay() {
        try {
            CGEngine.Render();
        }
        catch (Exception e) {
            e.getMessage();
        }
        if (Game.pauseTouchKeyPressed) {
            Graphic2D.DrawImage(ObjectsCache.menuSbPAUSE_a, ApplicationData.screenWidth, ApplicationData.screenHeight, 40);
        } else {
            Graphic2D.DrawImage(ObjectsCache.menuSbPAUSE, ApplicationData.screenWidth, ApplicationData.screenHeight, 40);
        }
        if (ApplicationData.isTouchScreen && CGEngine.testApp.m_nGameState == 1 && !PitStop.isDraw) {
            long nitroLevel;
            if (CGEngine.selectedRaceType != 1) {
                Graphic2D.DrawImage(this.m_IconTextures[0], this.m_TouchLeftX, this.m_TouchLeftY, 20);
                Graphic2D.DrawImage(this.m_IconTextures[1], this.m_TouchRightX, this.m_TouchRightY, 20);
            }
            if ((nitroLevel = CGEngine.testApp.GetHumanBolid().GetCurrentNitroLevel()) >= 4096L && ApplicationData.getAppTime() % 400L < 200L) {
                Graphic2D.DrawImage(this.m_IconTextures[2], this.m_TouchUpX, this.m_TouchUpY, 20);
            }
            Graphic2D.DrawImage(this.m_IconTextures[3], this.m_TouchDownX, this.m_TouchDownY, 20);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processTouchCommand(TouchCommand cmd) {
        try {
            if (cmd.onPressed == 1) {
                if (cmd.areaY > ApplicationData.screenHeight - ObjectsCache.menuSbPAUSE.GetHeight() && cmd.areaX > ApplicationData.screenWidth - ObjectsCache.menuSbPAUSE.GetWidth()) {
                    Game.pauseTouchKeyPressed = true;
                    return;
                }
                Game.pauseTouchKeyPressed = false;
                if (CGEngine.selectedRaceType != 1) {
                    if (cmd.areaX >= this.m_TouchLeftX && cmd.areaX <= this.m_TouchLeftX + this.m_IconTextures[0].GetWidth() && cmd.areaY >= this.m_TouchLeftY && cmd.areaY <= this.m_TouchLeftY + this.m_IconTextures[0].GetHeight()) {
                        leftTouchKeyPressed = true;
                    }
                    if (cmd.areaX >= this.m_TouchRightX && cmd.areaX <= this.m_TouchRightX + this.m_IconTextures[0].GetWidth() && cmd.areaY >= this.m_TouchRightY && cmd.areaY <= this.m_TouchRightY + this.m_IconTextures[0].GetHeight()) {
                        rightTouchKeyPressed = true;
                    }
                }
                if (cmd.areaX >= this.m_TouchUpX && cmd.areaX <= this.m_TouchUpX + this.m_IconTextures[2].GetWidth() && cmd.areaY >= this.m_TouchUpY && cmd.areaY <= this.m_TouchUpY + this.m_IconTextures[2].GetHeight()) {
                    upTouchKeyPressed = true;
                    if (CGEngine.testApp.GetGameState() == 1 && CGEngine.testApp.GetBolid(0).GetManualGear()) {
                        CGEngine.testApp.GetBolid(0).ChangeGear();
                    }
                }
                if (cmd.areaX >= this.m_TouchDownX && cmd.areaX <= this.m_TouchDownX + this.m_IconTextures[3].GetWidth() && cmd.areaY >= this.m_TouchDownY && cmd.areaY <= this.m_TouchDownY + this.m_IconTextures[3].GetHeight()) {
                    downTouchKeyPressed = true;
                }
                int xx = PitStop.pitStopButtonPosX - ObjectsCache.pitStopButton.GetWidth() / 2;
                int x2 = PitStop.pitStopButtonPosX + ObjectsCache.pitStopButton.GetWidth() / 2;
                int yy = PitStop.pitStopButtonPosY - ObjectsCache.pitStopButton.GetHeight() / 2;
                int y2 = PitStop.pitStopButtonPosY + ObjectsCache.pitStopButton.GetHeight() / 2;
                if (cmd.areaX < xx || cmd.areaX > x2 || cmd.areaY < yy || cmd.areaY > y2) return;
                System.out.println("=================P:PPPPP::::PPPPP===============================");
                pitTouchKeyPressed = true;
                return;
            }
            if (cmd.onPressed == 0) {
                if (Game.pauseTouchKeyPressed && cmd.areaY > ApplicationData.screenHeight - ObjectsCache.menuSbPAUSE.GetHeight() && cmd.areaX > ApplicationData.screenWidth - ObjectsCache.menuSbPAUSE.GetWidth()) {
                    Game.pauseTouchKeyPressed = false;
                    UIScreen.SetCurrentScreen(new InGameMainMenu());
                    return;
                }
                leftTouchKeyPressed = false;
                rightTouchKeyPressed = false;
                upTouchKeyPressed = false;
                downTouchKeyPressed = false;
                pitTouchKeyPressed = false;
                return;
            }
            if (cmd.onPressed != 2) return;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void processKeyCommand(KeyCommand cmd) {
        if (cmd.pressed) {
            if (cmd.keyCode == 1 && CGEngine.testApp.GetGameState() == 1 && CGEngine.testApp.GetBolid(0).GetManualGear()) {
                CGEngine.testApp.GetBolid(0).ChangeGear();
            }
            if (UIScreen.GetCurrentScreen() == null && cmd.keyCode == ApplicationData.SoftButton2_Code) {
                Game.pauseTouchKeyPressed = true;
            }
            if (ApplicationData.isTouchScreen || UIScreen.GetCurrentScreen() == null) {
                // empty if block
            }
            if (cmd.keyCode == 56) {
                System.out.println("K 8");
                Game.pitStopKeyPressed = true;
            }
        } else {
            if (UIScreen.GetCurrentScreen() == null && cmd.keyCode == ApplicationData.SoftButton2_Code) {
                Game.pauseTouchKeyPressed = false;
                UIScreen.SetCurrentScreen(new InGameMainMenu());
            }
            if (cmd.keyCode == 56) {
                Game.pitStopKeyPressed = false;
            }
        }
    }
}

