/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core.SortVector;
import baltorogames.core.Utils;
import baltorogames.core_gui.UIListColumn;
import baltorogames.core_gui.UIScreen;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.CGUserCareer;
import baltorogames.project_gui.EditChampionshipsUserName;
import baltorogames.project_gui.GeneralListScreen;
import baltorogames.project_gui.MainList;
import baltorogames.project_gui.TrophyStatistic;
import baltorogames.system.ObjectsCache;
import baltorogames.system.Options;
import java.util.Vector;

public class EndCompetitionScreen
extends MainList {
    private Vector resultsColumnNicks = new Vector();
    private Vector resultsColumnTotal = new Vector();
    public static SortVector players = null;

    public EndCompetitionScreen() {
        super(0, false, 0);
        ApplicationData.achievements.completeAchievment(5);
        this.columns = new Vector();
        this.columns.addElement(new UIListColumn(12, 8));
        this.columns.addElement(new UIListColumn(43, 4));
        this.columns.addElement(new UIListColumn(45, 1));
        this.headers.addElement(ApplicationData.defaultFont.encodeDynamicString(""));
        this.headers.addElement(ApplicationData.lp.getTranslatedString(Options.languageID, "ID_RESULTS_NICK"));
        this.headers.addElement(ApplicationData.lp.getTranslatedString(Options.languageID, "ID_RESULTS_TIME"));
        this.showHeaders = true;
        this.showScrollbars = CGEngine.selectedGameMode == 2 || CGEngine.selectedGameMode == 1;
        this.setSoftButtonImage(ObjectsCache.menuSbOK, ObjectsCache.menuSbOK_a, null, null);
        this.setCaption(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_RACE_RESULTS"));
        ++TrophyStatistic.raceFinished;
        this.Init();
    }

    public void Init() {
        System.out.println("DIALOG INIT");
        try {
            int[] nTimes = new int[6];
            for (int i = 0; i < 6; ++i) {
                nTimes[i] = CGEngine.testApp.m_FinishTimes[i];
            }
            int[] nIndexes = new int[6];
            for (int k = 0; k < 6; ++k) {
                int nMin = 1000000;
                int nI = -1;
                for (int i = 0; i < 6; ++i) {
                    if (nTimes[i] >= nMin) continue;
                    nMin = nTimes[i];
                    nI = i;
                }
                if (nI < 0) continue;
                nTimes[nI] = 1000000;
                nIndexes[k] = nI;
            }
            this.resultsColumnNicks.removeAllElements();
            this.resultsColumnTotal.removeAllElements();
            for (int i = 0; i < 6; ++i) {
                int nIndex = nIndexes[i];
                String str = ApplicationData.lp.getTranslatedString(Options.languageID, "ID_SHORT_NAME_1_" + nIndex);
                if (nIndex == 0) {
                    str = EditChampionshipsUserName.playerNick;
                }
                this.resultsColumnNicks.addElement(str);
                this.resultsColumnTotal.addElement(ApplicationData.defaultFont.encodeDynamicString(Utils.formatTimeAsc(CGEngine.testApp.m_FinishTimes[nIndex])));
                if (this.resultsColumnNicks.elementAt(i).equals(EditChampionshipsUserName.playerNick) && CGEngine.testApp.GetBolid(nIndexes[i]).GetTotalTime() < CGUserCareer.tracksTime[CGEngine.selectedTrack]) {
                    CGUserCareer.tracksTime[CGEngine.selectedTrack] = CGEngine.testApp.GetBolid(nIndexes[i]).GetTotalTime();
                }
                if (CGEngine.selectedGameMode != 2) continue;
                int n = nIndex;
                CGUserCareer.generalClasification[n] = CGUserCareer.generalClasification[n] + CGEngine.RACE_POINTS_FOR_POS[i];
                if (!this.resultsColumnNicks.elementAt(i).equals(EditChampionshipsUserName.playerNick)) continue;
                TrophyStatistic.allPoints = CGUserCareer.generalClasification[nIndexes[i]];
            }
            this.updateList(this.resultsColumnNicks, this.resultsColumnTotal);
            this.upgradeAchivments();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void updateList(Vector nicks, Vector results) {
        this.clearList();
        for (int i = 0; i < nicks.size(); ++i) {
            if (i == 0 && nicks.elementAt(0).equals(EditChampionshipsUserName.playerNick)) {
                CGUserCareer.setRacesWon();
            }
            this.append(ApplicationData.defaultFont.encodeDynamicString(i + 1 + ". "), 0);
            this.append((String)nicks.elementAt(i), 1);
            this.append((String)results.elementAt(i), 2);
        }
    }

    public boolean leftSoftButton() {
        if (CGEngine.selectedGameMode == 2) {
            try {
                UIScreen.SetCurrentScreen(new GeneralListScreen());
            }
            catch (Exception e) {
                System.out.println("Fatal error -> " + e.getMessage());
                e.printStackTrace();
            }
        } else {
            ApplicationData.goToMainMenu();
        }
        return true;
    }

    public boolean rightSoftButton() {
        return false;
    }

    public boolean onFireAction() {
        return this.leftSoftButton();
    }

    public void upgradeAchivments() {
        if (CGUserCareer.generalClasification[0] > 0) {
            ApplicationData.achievements.completeAchievment(2);
        }
        if (CGUserCareer.GetRaceID() == 1) {
            ApplicationData.achievements.completeAchievment(5);
        }
        if (CGUserCareer.getRacesWon() == 1) {
            ApplicationData.achievements.completeAchievment(4);
        }
        if (CGUserCareer.generalClasification[0] >= 25) {
            ApplicationData.achievements.completeAchievment(1);
        }
        if (CGUserCareer.generalClasification[0] >= 50) {
            ApplicationData.achievements.completeAchievment(0);
        }
    }
}

