/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.graphic2d;

import baltorogames.core.ApplicationData;
import baltorogames.core.Utils;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.TextureManager;
import baltorogames.system.Application;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Graphic2D {
    public static final int HCENTER = 1;
    public static final int VCENTER = 2;
    public static final int LEFT = 4;
    public static final int RIGHT = 8;
    public static final int TOP = 16;
    public static final int BOTTOM = 32;
    public static final int TRANS_NONE = 0;
    public static final int TRANS_ROT180 = 3;
    public static final int TRANS_ROT270 = 6;
    public static final int TRANS_MIRROR = 2;
    public static final int TRANS_MIRROR_ROT90 = 7;
    public static final int TRANS_MIRROR_ROT180 = 1;
    public static final int TRANS_MIRROR_ROT270 = 4;
    public static final int VMIRROR = 1;
    public static final int HMIRROR = 2;
    private static Graphics m_drawContext = null;
    private static int m_nClipX;
    private static int m_nClipY;
    private static int m_nClipW;
    private static int m_nClipH;

    public static void SetDrawContext(Graphics g) {
        m_drawContext = g;
    }

    public static Graphics GetDrawContext() {
        return m_drawContext;
    }

    public static void FlushGraphics() {
        Application.gameCanvas.FlushGraphics();
    }

    public static void DrawDebugString(String s, int x, int y, int anchor) {
        m_drawContext.drawString(s, x, y, anchor);
    }

    public static void ClearScreen(int color) {
        m_drawContext.setColor(color);
        m_drawContext.fillRect(0, 0, ApplicationData.screenWidth, ApplicationData.screenHeight);
    }

    public static void SetColor(int color) {
        m_drawContext.setColor(color);
    }

    public static void FillRect(int x, int y, int w, int h) {
        m_drawContext.fillRect(x, y, w, h);
    }

    public static void FillRect(int color, int x, int y, int w, int h) {
        m_drawContext.setColor(color);
        m_drawContext.fillRect(x, y, w, h);
    }

    public static void DrawLine(int x1, int y1, int x2, int y2) {
        m_drawContext.drawLine(x1, y1, x2, y2);
    }

    public static void DrawLine(int color, int x1, int y1, int x2, int y2) {
        m_drawContext.setColor(color);
        m_drawContext.drawLine(x1, y1, x2, y2);
    }

    public static void SetClip(int x, int y, int w, int h) {
        m_nClipX = x;
        m_nClipY = y;
        m_nClipW = w;
        m_nClipH = h;
        m_drawContext.setClip(x, y, w, h);
    }

    public static void ClipRect(int x, int y, int w, int h) {
        m_nClipX = x;
        m_nClipY = y;
        m_nClipW = w;
        m_nClipH = h;
        m_drawContext.clipRect(x, y, w, h);
    }

    public static int GetClipX() {
        return m_nClipX;
    }

    public static int GetClipY() {
        return m_nClipY;
    }

    public static int GetClipWidth() {
        return m_nClipW;
    }

    public static int GetClipHeight() {
        return m_nClipH;
    }

    public static void Draw(CGTexture tex, int x_left, int y_top, int nTransform) {
        if (Utils.isPointInRect(x_left, y_top, 0, 0, ApplicationData.screenWidth, ApplicationData.screenHeight)) {
            m_drawContext.drawRegion(tex.m_Image, 0, 0, tex.m_Image.getWidth(), tex.m_Image.getHeight(), nTransform, x_left, y_top, 0);
        } else if (Utils.isPointInRect(x_left + tex.GetWidth(), y_top, 0, 0, ApplicationData.screenWidth, ApplicationData.screenHeight)) {
            m_drawContext.drawRegion(tex.m_Image, 0, 0, tex.m_Image.getWidth(), tex.m_Image.getHeight(), nTransform, x_left, y_top, 0);
        } else if (Utils.isPointInRect(x_left, y_top + tex.GetHeight(), 0, 0, ApplicationData.screenWidth, ApplicationData.screenHeight)) {
            m_drawContext.drawRegion(tex.m_Image, 0, 0, tex.m_Image.getWidth(), tex.m_Image.getHeight(), nTransform, x_left, y_top, 0);
        } else if (Utils.isPointInRect(x_left + tex.GetWidth(), y_top + tex.GetHeight(), 0, 0, ApplicationData.screenWidth, ApplicationData.screenHeight)) {
            m_drawContext.drawRegion(tex.m_Image, 0, 0, tex.m_Image.getWidth(), tex.m_Image.getHeight(), nTransform, x_left, y_top, 0);
        }
    }

    public static void DrawCenter(CGTexture tex, int x_center, int y_center) {
        m_drawContext.drawImage(tex.m_Image, x_center - tex.m_Image.getWidth() / 2, y_center - tex.m_Image.getHeight() / 2, 0);
    }

    public static void DrawCenterRotate(CGTexture tex, int x_center, int y_center) {
        m_drawContext.drawRegion(tex.m_Image, 0, 0, tex.m_Image.getWidth(), tex.m_Image.getHeight(), 4, x_center, y_center, 3);
    }

    public static void DrawR(CGTexture tex, int x1, int y1, int x2, int y2, int x_left, int y_top, int nTransform) {
        m_drawContext.drawRegion(tex.m_Image, x1, y1, x2 - x1, y2 - y1, nTransform, x_left, y_top, 20);
    }

    public static void DrawImage(CGTexture tex, int x, int y, int anchor) {
        m_drawContext.drawImage(tex.m_Image, x, y, anchor);
    }

    public static void DrawImage(Image tex, int x, int y, int anchor) {
        m_drawContext.drawImage(tex, x, y, anchor);
    }

    public static void DrawRegion(CGTexture tex, int x1, int y1, int w, int h, int transform, int x_dest, int y_dest, int anchor) {
        m_drawContext.drawRegion(tex.m_Image, x1, y1, w, h, transform, x_dest, y_dest, anchor);
    }

    public static void DrawRegion(Image tex, int x1, int y1, int w, int h, int transform, int x_dest, int y_dest, int anchor) {
        m_drawContext.drawRegion(tex, x1, y1, w, h, transform, x_dest, y_dest, anchor);
    }

    public static CGTexture[] splitPanoramaImage(String imageName, int numColumns, int numRows) {
        CGTexture text = TextureManager.AddTexture(imageName);
        try {
            CGTexture[] textures = Graphic2D.splitPanoramaImage(text, numColumns, numRows);
            TextureManager.DeleteTexture(text);
            return textures;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Image ScaleImage(Image src, int width, int height) {
        return Graphic2D.scaleImageNoAlpha(src, width, height, true);
    }

    public static CGTexture[] splitPanoramaImage(CGTexture inImage, int numColumns, int numRows) {
        if (inImage == null) {
            return null;
        }
        CGTexture[] splitImages = new CGTexture[numRows * numColumns];
        int elementWidth = inImage.m_Image.getWidth() / numColumns;
        int elementHeight = inImage.m_Image.getHeight() / numRows;
        for (int y = 0; y < numRows; ++y) {
            for (int x = 0; x < numColumns; ++x) {
                Image im = Image.createImage((Image)inImage.m_Image, (int)(x * elementWidth), (int)(y * elementHeight), (int)elementWidth, (int)elementHeight, (int)0);
                splitImages[x + y * numColumns] = new CGTexture();
                splitImages[x + y * numColumns].SetImage(im);
                splitImages[x + y * numColumns].SetName("");
            }
        }
        return splitImages;
    }

    private static void Bilinear_Interpolate_NoAlpha(int[] inBits, int[] outBits, int w, int h, int outWidth, int outHeight) {
        long ratiox = 4096 * w / outWidth;
        long ratioy = 4096 * h / outHeight;
        for (int i = 0; i < outWidth; ++i) {
            for (int j = 0; j < outHeight; ++j) {
                long x = (long)i * ratiox;
                long y = (long)j * ratioy;
                long x0 = x / 4096L * 4096L;
                long y0 = y / 4096L * 4096L;
                long dx = x - x0;
                long dy = y - y0;
                long _1_dx = 4096L - dx;
                long _1_dy = 4096L - dy;
                long x0_1 = x0 + 4096L >= (long)(4096 * w) ? x0 : x0 + 1L;
                long y0_1 = y0 + 4096L >= (long)(4096 * h) ? y0 : y0 + 1L;
                long r0 = inBits[(int)((x0 + y0 * (long)w) / 4096L)] & 0xFF;
                long g0 = (inBits[(int)((x0 + y0 * (long)w) / 4096L)] & 0xFF00) >> 8;
                long b0 = (inBits[(int)((x0 + y0 * (long)w) / 4096L)] & 0xFF0000) >> 16;
                long a0 = (inBits[(int)((x0 + y0 * (long)w) / 4096L)] & 0xFF000000) >> 24;
                long r1 = inBits[(int)(x0_1 + y0 * (long)w) / 4096] & 0xFF;
                long g1 = (inBits[(int)(x0_1 + y0 * (long)w) / 4096] & 0xFF00) >> 8;
                long b1 = (inBits[(int)(x0_1 + y0 * (long)w) / 4096] & 0xFF0000) >> 16;
                long r2 = inBits[(int)(x0_1 + y0_1 * (long)w) / 4096] & 0xFF;
                long g2 = (inBits[(int)(x0_1 + y0_1 * (long)w) / 4096] & 0xFF00) >> 8;
                long b2 = (inBits[(int)(x0_1 + y0_1 * (long)w) / 4096] & 0xFF0000) >> 16;
                long r3 = inBits[(int)(x0 + y0_1 * (long)w) / 4096] & 0xFF;
                long g3 = (inBits[(int)(x0 + y0_1 * (long)w) / 4096] & 0xFF00) >> 8;
                long b3 = (inBits[(int)(x0 + y0_1 * (long)w) / 4096] & 0xFF0000) >> 16;
                int r = (int)(((r0 * _1_dx + r1 * dx) / 4096L * _1_dy + (r3 * _1_dx + r2 * dx) / 4096L * dy) / 4096L);
                int g = (int)(((g0 * _1_dx + g1 * dx) / 4096L * _1_dy + (g3 * _1_dx + g2 * dx) / 4096L * dy) / 4096L);
                int b = (int)(((b0 * _1_dx + b1 * dx) / 4096L * _1_dy + (b3 * _1_dx + b2 * dx) / 4096L * dy) / 4096L);
                int a = (int)a0;
                outBits[i + j * outWidth] = r + (g << 8) + (b << 16) + (a << 24);
            }
        }
    }

    public static Image scaleImageNoAlpha(Image inImage, int outWidth, int outHeight, boolean alpha) {
        int[] outBits = new int[outWidth * outHeight];
        int[] inBits = new int[inImage.getWidth() * inImage.getHeight()];
        if (inImage.getWidth() == outWidth && inImage.getHeight() == outHeight) {
            return inImage;
        }
        try {
            inImage.getRGB(inBits, 0, inImage.getWidth(), 0, 0, inImage.getWidth(), inImage.getHeight());
        }
        catch (Exception e) {
            return null;
        }
        Graphic2D.Bilinear_Interpolate_NoAlpha(inBits, outBits, inImage.getWidth(), inImage.getHeight(), outWidth, outHeight);
        return Image.createRGBImage((int[])outBits, (int)outWidth, (int)outHeight, (boolean)alpha);
    }
}

