/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core.Utils;
import baltorogames.core_gui.UIScreen;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;
import baltorogames.system.Application;
import baltorogames.system.Options;

public class LoadingScreen
extends UIScreen {
    private static final int SPLASH_TIME_INTERVAL = 3000;
    CGTexture image = TextureManager.AddTexture("/splash.png");
    int time = 0;
    int counterDraw = 0;

    public void drawWindowBackground() {
    }

    public void drawWindowForeground() {
    }

    public void draw() {
        Graphic2D.SetColor(0);
        Graphic2D.FillRect(0, 0, ApplicationData.screenWidth, ApplicationData.screenHeight);
        if (this.image != null) {
            Graphic2D.DrawImage(this.image, ApplicationData.screenWidth / 2, ApplicationData.screenHeight / 2, 3);
        }
        int fontHeight = ApplicationData.defaultFont.getFontHeight();
        Utils.drawString(ApplicationData.lp.getTranslatedString(Options.languageID, "ID_GAME_LOADING"), ApplicationData.screenWidth / 2, ApplicationData.screenHeight, 33, 0);
        ApplicationData.checkGLUReqs();
        if (ApplicationData.demoEnabled) {
            Graphic2D.SetColor(-1);
            Graphic2D.FillRect(0, ApplicationData.screenHeight / 2, ApplicationData.screenWidth, fontHeight);
            Utils.drawString(ApplicationData.lp.getTranslatedString(Options.languageID, "ID_FREE_TRIAL"), ApplicationData.screenWidth / 2, ApplicationData.screenHeight / 2, 17, 0);
        }
        ++this.counterDraw;
        if (this.counterDraw == 2) {
            ApplicationData.loadApp();
        }
    }

    public void onUpdate(int deltaTime) {
        this.time += deltaTime;
        if (this.time > 3000) {
            UIScreen.SetCurrentScreen(null);
            ApplicationData.SetMusic();
            ApplicationData.goToMainMenu();
            if (!Application.gameCanvas.isForeground) {
                ApplicationData.soundEngine.stopMID();
            }
            if (ApplicationData.demoEnabled) {
                if (ApplicationData.demoTimeLeft == -1) {
                    ApplicationData.demoTimeLeft = Application.getApplication().checkIntegerProperty("DemoTimeLimit", -1);
                    if (ApplicationData.demoTimeLeft != -1) {
                        ApplicationData.demoTimeLimited = true;
                        ApplicationData.demoTimeLeft *= 1000;
                    }
                } else {
                    ApplicationData.demoTimeLimited = true;
                }
                if (ApplicationData.demoLevelsLeft == -1) {
                    ApplicationData.demoLevelsLeft = Application.getApplication().checkIntegerProperty("DemoGameLimit", -1);
                    if (ApplicationData.demoLevelsLeft != -1) {
                        ApplicationData.demoLevelLimited = true;
                    }
                } else {
                    ApplicationData.demoLevelLimited = true;
                }
            }
        }
    }
}

