/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core.Utils;
import baltorogames.core_gui.UIAnimatedButtonH;
import baltorogames.core_gui.UIButton;
import baltorogames.core_gui.UIScreen;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gameplay.CGUserCareer;
import baltorogames.project_gui.CarSelectionScreen;
import baltorogames.project_gui.CareerScreen;
import baltorogames.project_gui.MainUSRScreen;
import baltorogames.system.ObjectsCache;

public class EventScreen
extends MainUSRScreen {
    private int currentElement = 0;
    private final int MAX_ELEMENTS;
    private final int LEFT_ARROW_ID;
    private final int RIGHT_ARROW_ID;
    public static final int NO_TROPHY = 0;
    public static final int GOLD = 1;
    public static final int SIVER = 2;
    public static final int BRONZE = 3;
    public CGTexture[] trophyTex = new CGTexture[4];
    public static int[] medalEvents = new int[4];
    public CGTexture locked;
    public int[] event1 = new int[]{0, 1, 2};
    public final int[] event2 = new int[]{3, 2, 1, 0, 4, 5};
    public final int[] event3 = new int[]{6, 5, 4, 2, 0, 1, 2, 3, 4};
    public final int[] event4 = new int[]{0, 1, 2, 3, 4, 5, 6, 5, 5, 6, 3, 0};
    public static int[] currentEventArray;
    public static int selectedWorld;
    public static String[] eventsNames;

    public EventScreen() {
        this.MAX_ELEMENTS = 4;
        this.LEFT_ARROW_ID = 100;
        this.RIGHT_ARROW_ID = 101;
        this.setSoftButtonImage(ObjectsCache.menuSbOK, ObjectsCache.menuSbOK_a, ObjectsCache.menuSbBACK, ObjectsCache.menuSbBACK_a);
        this.trophyTex[0] = TextureManager.CreateTexture("/events/no_trophy.png");
        this.trophyTex[1] = TextureManager.CreateTexture("/events/gold.png");
        this.trophyTex[2] = TextureManager.CreateTexture("/events/silver.png");
        this.trophyTex[3] = TextureManager.CreateTexture("/events/bronze.png");
        this.locked = TextureManager.CreateTexture("/car_locked.png");
        int arrowLeftX = 0;
        int arrowRightX = ApplicationData.screenWidth - ObjectsCache.scrollRightImg.GetWidth();
        UIAnimatedButtonH rightB = new UIAnimatedButtonH(arrowRightX - ObjectsCache.menuWhiteDot.GetHeight(), ApplicationData.screenHeight / 2, ObjectsCache.scrollRightImg, ObjectsCache.scrollRightWImg, 101);
        rightB.setScreen(this);
        rightB.setAnimDir(1);
        this.addButton(rightB);
        UIAnimatedButtonH leftB = new UIAnimatedButtonH(arrowLeftX + ObjectsCache.menuWhiteDot.GetHeight(), ApplicationData.screenHeight / 2, ObjectsCache.scrollLeftImg, ObjectsCache.scrollLeftWImg, 100);
        leftB.setScreen(this);
        leftB.setAnimDir(-1);
        this.addButton(leftB);
    }

    public void onUpdate(int deltaTime) {
        this.lifeTime += deltaTime;
    }

    public void draw() {
        Graphic2D.DrawImage(CGUserCareer.avalaibleEvents[this.currentElement] ? this.trophyTex[medalEvents[this.currentElement]] : this.locked, ApplicationData.screenWidth / 2, ApplicationData.screenHeight / 2, 3);
        Utils.drawString(ApplicationData.defaultFont.encodeDynamicString(eventsNames[this.currentElement]), ApplicationData.screenWidth / 2, ApplicationData.screenHeight * 85 / 100, 3, 0);
    }

    public boolean rightSoftButton() {
        UIScreen.SetCurrentScreen(new CarSelectionScreen(this));
        return true;
    }

    public boolean leftSoftButton() {
        if (!CGUserCareer.avalaibleEvents[this.currentElement]) {
            return true;
        }
        switch (this.currentElement) {
            case 0: {
                currentEventArray = new int[this.event1.length];
                System.arraycopy(this.event1, 0, currentEventArray, 0, this.event1.length);
                break;
            }
            case 1: {
                currentEventArray = new int[this.event2.length];
                System.arraycopy(this.event2, 0, currentEventArray, 0, this.event2.length);
                break;
            }
            case 2: {
                currentEventArray = new int[this.event3.length];
                System.arraycopy(this.event3, 0, currentEventArray, 0, this.event3.length);
                break;
            }
            case 3: {
                currentEventArray = new int[this.event4.length];
                System.arraycopy(this.event4, 0, currentEventArray, 0, this.event4.length);
                break;
            }
            default: {
                currentEventArray = new int[this.event1.length];
                System.arraycopy(this.event1, 0, currentEventArray, 0, this.event1.length);
            }
        }
        selectedWorld = this.currentElement;
        UIScreen.SetCurrentScreen(new CareerScreen());
        return true;
    }

    public boolean selectLeftAction() {
        UIButton b = this.findByID(100);
        if (b != null) {
            b.setSelect(true);
            return true;
        }
        return false;
    }

    public boolean selectRightAction() {
        UIButton b = this.findByID(101);
        if (b != null) {
            b.setSelect(true);
            return true;
        }
        return false;
    }

    public boolean actionSoftButton(int nID, boolean pressed) {
        if (super.actionSoftButton(nID, pressed)) {
            return true;
        }
        if (!pressed) {
            this.unselectAllButtons();
            if (nID == 100) {
                this.onLeftAction();
                return true;
            }
            if (nID == 101) {
                this.onRightAction();
                return true;
            }
        }
        return false;
    }

    public boolean onRightAction() {
        ++this.currentElement;
        if (this.currentElement >= 4) {
            this.currentElement = 0;
        }
        return true;
    }

    public boolean onLeftAction() {
        --this.currentElement;
        if (this.currentElement < 0) {
            this.currentElement = 3;
        }
        return true;
    }

    public boolean onFireAction() {
        return this.leftSoftButton();
    }

    static {
        EventScreen.medalEvents[0] = 0;
        EventScreen.medalEvents[1] = 0;
        EventScreen.medalEvents[2] = 0;
        EventScreen.medalEvents[3] = 0;
        selectedWorld = 0;
        eventsNames = new String[]{"Event 1", "Event 2", "Event 3", "Event 4"};
    }
}

