/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core.Utils;
import baltorogames.core_gui.UIAnimatedButtonH;
import baltorogames.core_gui.UIButton;
import baltorogames.core_gui.UIScreen;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.CGUserCareer;
import baltorogames.project_gui.AchievementCompleted;
import baltorogames.project_gui.ContinueOrNewChampionships;
import baltorogames.project_gui.MainUSRScreen;
import baltorogames.project_gui.UICaptionThick;
import baltorogames.system.BGStore;
import baltorogames.system.ObjectsCache;
import baltorogames.system.Options;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;

public class OtherAchievements
extends MainUSRScreen {
    public static final int NUM_OTHER_ACHIEVEMENTS = 13;
    private final int LEFT_ARROW_ID;
    private final int RIGHT_ARROW_ID;
    public static final int MEDAL_BRONZE = 2;
    public static final int MEDAL_SILVER = 1;
    public static final int MEDAL_GOLD = 0;
    public static final int LAPS_TO_BE_EXPERIENCED_DRIVER = 50;
    private int alignStarY;
    private static String[] achievementFullDesccription = new String[]{"ACHIEVEMENTS_FULL_0", "ACHIEVEMENTS_FULL_1", "ACHIEVEMENTS_FULL_2", "ACHIEVEMENTS_FULL_3", "ACHIEVEMENTS_FULL_4", "ACHIEVEMENTS_FULL_5", "ACHIEVEMENTS_FULL_6", "ACHIEVEMENTS_FULL_7", "ACHIEVEMENTS_FULL_8", "ACHIEVEMENTS_FULL_9"};
    public static String[] achievementHeaderDescription = new String[]{"ACHIEVEMENTS_HEADER_0", "ACHIEVEMENTS_HEADER_1", "ACHIEVEMENTS_HEADER_2", "ACHIEVEMENTS_HEADER_3", "ACHIEVEMENTS_HEADER_4", "ACHIEVEMENTS_HEADER_5", "ACHIEVEMENTS_HEADER_6", "ACHIEVEMENTS_HEADER_7", "ACHIEVEMENTS_HEADER_8", "ACHIEVEMENTS_HEADER_9"};
    public static boolean[] championshipsOnly = new boolean[]{true, true, true, true, true, true, true, true, true, true, true, true, true, true};
    private static boolean[] completedAchievements = new boolean[13];
    private static int[][] numMedals = new int[9][3];
    public static int numWCWon = 0;
    public static final int RACE_CHAMPION = 0;
    public static final int NO_COLLISIONS = 1;
    public static final int REAL_CHAMPION = 2;
    public static final int GOLD_TROPHY = 3;
    public static final int SILVER_TROPHY = 4;
    public static final int BRONZE_TROPHY = 5;
    public static final int UNLOCK_ALL_CARS = 6;
    public static final int WINTER_MASTER = 7;
    public static final int ALL_MEDALS = 8;
    public static final int AFRICA_MASTER = 9;
    public static final int WC_TWICE = 10;
    public static final int WC_3TIMES = 11;
    public static final int RAIN_MASTER = 12;
    public static int selectedAchievement = 0;
    private CGTexture achievementImage;
    private Vector mainText;
    int textHeight;
    private String achievementID;
    private static Vector achievementNoticesToShow = new Vector();
    private static Vector achievementHeadersToShow = new Vector();
    static int numOvertakes = 0;
    static int numLapsTotal = 0;
    public static boolean noCollisions = true;

    public boolean checkAchievementToShowExists(boolean isIngame, UIScreen combackScreen) {
        if (achievementNoticesToShow.size() > 0) {
            UIScreen.SetCurrentScreen(new AchievementCompleted(isIngame, combackScreen, (String)achievementNoticesToShow.elementAt(0), (String)achievementHeadersToShow.elementAt(0)));
            achievementNoticesToShow.removeElementAt(0);
            achievementHeadersToShow.removeElementAt(0);
            return true;
        }
        return false;
    }

    public static int getNumMedals(int trackID, int medal) {
        return numMedals[trackID][medal];
    }

    public static void addMedal(int trackID, int medal) {
        if (medal >= 0 && medal <= 2) {
            int[] nArray = numMedals[trackID];
            int n = medal;
            nArray[n] = nArray[n] + 1;
        }
    }

    public void wonRace() {
        if (!OtherAchievements.isCompleted(0)) {
            OtherAchievements.complete(0);
        }
    }

    public void checkAchievements() {
        boolean allGoldsGathered = true;
        for (int i = 0; i < 9; ++i) {
            if (numMedals[i][0] != 0) continue;
            allGoldsGathered = false;
            break;
        }
        if (allGoldsGathered) {
            OtherAchievements.complete(2);
        }
        boolean allWinterGolds = true;
        for (int i = 8; i < 12; ++i) {
            if (numMedals[i][0] != 0) continue;
            allWinterGolds = false;
        }
        boolean allAmericaGolds = true;
        for (int i = 0; i < 4; ++i) {
            if (numMedals[i][0] != 0) continue;
            allAmericaGolds = false;
        }
        boolean allAfricaGolds = true;
        for (int i = 8; i < 12; ++i) {
            if (numMedals[i][0] != 0) continue;
            allAfricaGolds = false;
        }
        boolean allMedals = true;
        for (int i = 0; i < 12; ++i) {
            if (numMedals[i][0] != 0 && numMedals[i][1] != 0 && numMedals[i][2] != 0) continue;
            allMedals = false;
            break;
        }
        if (allWinterGolds) {
            OtherAchievements.complete(7);
        }
        if (allAfricaGolds) {
            OtherAchievements.complete(9);
        }
        if (allMedals) {
            OtherAchievements.complete(8);
        }
        if (CGUserCareer.isKartAvailable(1) && CGUserCareer.isKartAvailable(2) && CGUserCareer.isKartAvailable(3)) {
            this.completeWithoutNotification(6);
        }
    }

    public OtherAchievements() {
        this.LEFT_ARROW_ID = 100;
        this.RIGHT_ARROW_ID = 101;
        this.drawLogo = false;
        this.drawCash = false;
        this.drawFP = false;
        this.drawStrip1 = true;
        this.drawStrip3 = true;
        this.setSoftButtonImage(null, null, ObjectsCache.menuSbBACK, ObjectsCache.menuSbBACK_a);
        this.setCaptionThick(new UICaptionThick(ApplicationData.lp.getTranslatedString(Options.languageID, "WORLD_CUP_ACHIEVEMENTS")));
        this.updateAchievementShown();
        this.strip3Y = ApplicationData.screenHeight - ObjectsCache.menuFooterImage.GetHeight() * 2 - MainUSRScreen.getStrip3Height() / 2;
        this.strip1Y = MainUSRScreen.getStrip1Height();
        this.alignStarY = (this.strip1Y + MainUSRScreen.getStrip1Height() / 2 + this.strip3Y - MainUSRScreen.getStrip3Height() / 2) / 2;
        int arrowsY = this.alignStarY - ObjectsCache.scrollLeftImg.GetHeight() / 2;
        int arrowLeftX = ApplicationData.screenWidth / 2 - ObjectsCache.achievementBackground.GetWidth();
        int arrowRightX = ApplicationData.screenWidth / 2 + ObjectsCache.achievementBackground.GetWidth() - ObjectsCache.scrollRightImg.GetWidth();
        UIAnimatedButtonH rightB = new UIAnimatedButtonH(arrowRightX, arrowsY, ObjectsCache.scrollRightImg, ObjectsCache.scrollRightWImg, 101);
        rightB.setScreen(this);
        rightB.setAnimDir(1);
        this.addButton(rightB);
        UIAnimatedButtonH leftB = new UIAnimatedButtonH(arrowLeftX, arrowsY, ObjectsCache.scrollLeftImg, ObjectsCache.scrollLeftWImg, 100);
        leftB.setScreen(this);
        leftB.setAnimDir(-1);
        this.addButton(leftB);
    }

    public static boolean isCompleted(int id) {
        return completedAchievements[id];
    }

    public static void complete(int id) {
        if (!completedAchievements[id] && (CGEngine.selectedGameMode != 2 && !championshipsOnly[id] || CGEngine.selectedGameMode == 2)) {
            OtherAchievements.completedAchievements[id] = true;
            achievementNoticesToShow.addElement(ApplicationData.lp.getTranslatedString(Options.languageID, achievementFullDesccription[id]));
            achievementHeadersToShow.addElement(ApplicationData.lp.getTranslatedString(Options.languageID, achievementHeaderDescription[id]));
        }
    }

    public void completeWithoutNotification(int id) {
        OtherAchievements.completedAchievements[id] = true;
    }

    public static void reset() {
        completedAchievements = new boolean[13];
        numMedals = new int[9][3];
        numWCWon = 0;
    }

    public void draw() {
        Utils.drawString(ApplicationData.lp.getTranslatedString(Options.languageID, achievementHeaderDescription[selectedAchievement]), ApplicationData.screenWidth / 2, this.strip1Y, 3, 0);
        Graphic2D.DrawImage(ObjectsCache.achievementBackground, ApplicationData.screenWidth / 2, this.alignStarY, 3);
        if (completedAchievements[selectedAchievement]) {
            Graphic2D.DrawImage(this.achievementImage, ApplicationData.screenWidth / 2, this.alignStarY, 3);
        }
        this.drawMainText(this.strip3Y);
        Utils.drawString(this.achievementID, ApplicationData.screenWidth, this.strip1Y - MainUSRScreen.getStrip1Height() / 2, 40, 0);
        if (!completedAchievements[selectedAchievement]) {
            Utils.drawString(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_LOCKED"), ApplicationData.screenWidth / 2, (ApplicationData.screenHeight - ObjectsCache.menuFooterImage.GetHeight() + this.strip3Y + MainUSRScreen.getStrip3Height() / 2) / 2, 3, 0);
        }
    }

    public boolean rightSoftButton() {
        UIScreen.SetCurrentScreen(new ContinueOrNewChampionships());
        return true;
    }

    public boolean selectLeftAction() {
        UIButton b = this.findByID(100);
        if (b != null) {
            b.setSelect(true);
            return true;
        }
        return false;
    }

    public boolean selectRightAction() {
        UIButton b = this.findByID(101);
        if (b != null) {
            b.setSelect(true);
            return true;
        }
        return false;
    }

    public boolean actionSoftButton(int nID, boolean pressed) {
        if (super.actionSoftButton(nID, pressed)) {
            return true;
        }
        if (!pressed) {
            this.unselectAllButtons();
            if (nID == 100) {
                this.onLeftAction();
                return true;
            }
            if (nID == 101) {
                this.onRightAction();
                return true;
            }
        }
        return false;
    }

    public boolean onLeftAction() {
        if (--selectedAchievement < 0) {
            selectedAchievement = achievementHeaderDescription.length - 1;
        }
        this.updateAchievementShown();
        return true;
    }

    public boolean onRightAction() {
        if (++selectedAchievement >= achievementHeaderDescription.length) {
            selectedAchievement = 0;
        }
        this.updateAchievementShown();
        return true;
    }

    public boolean onFireAction() {
        return this.leftSoftButton();
    }

    private void updateAchievementShown() {
        try {
            this.mainText = Utils.splitText(ApplicationData.lp.getTranslatedString(Options.languageID, achievementFullDesccription[selectedAchievement]), "+", ApplicationData.screenWidth, 2);
            this.textHeight = (this.mainText.size() + 1) * ApplicationData.smallGreyFont.getFontHeight();
            this.achievementID = ApplicationData.defaultFont.encodeDynamicString(selectedAchievement + 1 + "/" + achievementFullDesccription.length);
            this.achievementImage = ObjectsCache.achievementCompleted[completedAchievements[selectedAchievement] ? 0 : 1];
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void drawMainText(int posY) {
        int fontHeight = ApplicationData.smallGreyFont.getFontHeight();
        Graphic2D.SetClip(0, 0, ApplicationData.screenWidth, ApplicationData.screenHeight);
        for (int i = 0; i < this.mainText.size(); ++i) {
            int yPosition = posY + i * fontHeight;
            Utils.drawString((String)this.mainText.elementAt(i), ApplicationData.screenWidth / 2, yPosition, 17, 2);
        }
    }

    public static boolean readFromStore() {
        BGStore store = BGStore.openStoreToRead("Achievements");
        try {
            DataInputStream inputStream = store.getInStream();
            if (inputStream != null && inputStream.available() > 0) {
                OtherAchievements.deSerialize(inputStream);
            }
            store.close();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static void writeToStore() {
        BGStore store = BGStore.openStoreToWrite("Achievements");
        try {
            DataOutputStream outputStream = store.getOutStream();
            OtherAchievements.serialize(outputStream);
            store.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void deSerialize(DataInputStream inputStream) throws IOException {
        for (int i = 0; i < 13; ++i) {
            OtherAchievements.completedAchievements[i] = inputStream.readBoolean();
        }
        for (int j = 0; j < 9; ++j) {
            for (int i = 0; i < 3; ++i) {
                OtherAchievements.numMedals[j][i] = inputStream.readInt();
            }
        }
        numWCWon = inputStream.readInt();
        numOvertakes = inputStream.readInt();
        numLapsTotal = inputStream.readInt();
    }

    private static void serialize(DataOutputStream outputStream) throws IOException {
        for (int i = 0; i < 13; ++i) {
            outputStream.writeBoolean(completedAchievements[i]);
        }
        for (int j = 0; j < 9; ++j) {
            for (int i = 0; i < 3; ++i) {
                outputStream.writeInt(numMedals[j][i]);
            }
        }
        outputStream.writeInt(numWCWon);
        outputStream.writeInt(numOvertakes);
        outputStream.writeInt(numLapsTotal);
    }
}

