/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core.Utils;
import baltorogames.core_gui.UIAnimatedButtonH;
import baltorogames.core_gui.UIButton;
import baltorogames.core_gui.UIScreen;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gameplay.CGUserCareer;
import baltorogames.project_gui.CareerScreen;
import baltorogames.project_gui.MainUSRScreen;
import baltorogames.system.ObjectsCache;
import baltorogames.system.Options;
import java.util.Vector;

public class BabesSelectionScreen
extends MainUSRScreen {
    public static int NUM_MENU_ELEMENTS = 4;
    private final int LEFT_ARROW_ID;
    private final int RIGHT_ARROW_ID;
    private int counterDraw = 25;
    private int emptyBarColor = -16777216;
    private int emptyBarHeight = 0;
    private int fullBarColor = -4827394;
    private int fullBarHeight = 0;
    private int currentMenuElement = 0;
    private CGTexture babeTexture;
    private CGTexture babeName;
    private CGTexture babePowerUpIcon;
    private CGTexture locked;
    private Vector mainText;
    private String babeID;
    private String babePowerUp;
    public static int[] remapBabesOrder = new int[]{0, 2, 1, 3};

    public void autoSize() {
    }

    public BabesSelectionScreen() {
        this.LEFT_ARROW_ID = 100;
        this.RIGHT_ARROW_ID = 101;
        this.drawLogo = false;
        this.drawFP = true;
        this.drawCash = true;
        this.drawStrip1 = true;
        this.drawStrip2 = true;
        this.setSoftButtonImage(null, null, ObjectsCache.menuSbBACK, ObjectsCache.menuSbBACK_a);
        this.locked = TextureManager.AddTexture("/babe_locked.png");
        this.emptyBarHeight = MainUSRScreen.getStrip1Height() / 4;
        this.fullBarHeight = 7 * this.emptyBarHeight / 10;
        this.updateScreenInfo();
        if (this.babeTexture == null) {
            this.babeTexture = this.locked;
        }
        this.strip2Y = (ApplicationData.screenHeight - ObjectsCache.menuFooterImage.GetHeight() + ApplicationData.screenHeight / 2 + this.babeTexture.GetHeight() / 2) / 2;
        this.strip1Y = 27 + MainUSRScreen.getStrip1Height() / 2;
        int arrowsY = this.strip2Y - MainUSRScreen.getStrip2Height() / 2 - ObjectsCache.scrollRightImg.GetHeight() / 2 - this.babeTexture.GetHeight() / 2;
        int arrowLeftX = 0;
        int arrowRightX = ApplicationData.screenWidth - ObjectsCache.scrollRightImg.GetWidth();
        UIAnimatedButtonH rightB = new UIAnimatedButtonH(arrowRightX, arrowsY, ObjectsCache.scrollRightImg, ObjectsCache.scrollRightWImg, 101);
        rightB.setScreen(this);
        rightB.setAnimDir(1);
        this.addButton(rightB);
        UIAnimatedButtonH leftB = new UIAnimatedButtonH(arrowLeftX, arrowsY, ObjectsCache.scrollLeftImg, ObjectsCache.scrollLeftWImg, 100);
        leftB.setScreen(this);
        leftB.setAnimDir(-1);
        this.addButton(leftB);
    }

    public void onUpdate(int deltaTime) {
        this.lifeTime += deltaTime;
    }

    private void drawMainText(int posY) {
        int fontHeight = ApplicationData.smallGreyFont.getFontHeight();
        Graphic2D.SetClip(0, 0, ApplicationData.screenWidth, ApplicationData.screenHeight);
        for (int i = 0; i < this.mainText.size(); ++i) {
            int yPosition = posY + i * fontHeight - this.mainText.size() * fontHeight / 2;
            Utils.drawString((String)this.mainText.elementAt(i), ApplicationData.screenWidth / 2, yPosition, 17, 2);
        }
    }

    public void draw() {
        if (CGUserCareer.babeUnlockState[remapBabesOrder[this.currentMenuElement]] > 0) {
            if (this.babeTexture != null) {
                Graphic2D.DrawImage(this.babeTexture, ApplicationData.screenWidth / 2, this.strip2Y - MainUSRScreen.getStrip2Height() / 2, 33);
            }
        } else if (this.locked != null) {
            Graphic2D.DrawImage(this.locked, ApplicationData.screenWidth / 2, this.strip2Y - MainUSRScreen.getStrip2Height() / 2, 33);
        }
        Graphic2D.DrawImage(this.babeName, ApplicationData.screenWidth / 2, this.strip1Y - MainUSRScreen.getStrip1Height() / 2, 17);
        Utils.drawString(this.babeID, ApplicationData.screenWidth / 2, this.strip1Y - MainUSRScreen.getStrip1Height() / 2 + this.babeName.GetHeight(), 17, 0);
        if (CGUserCareer.babeUnlockState[remapBabesOrder[this.currentMenuElement]] > 0) {
            this.drawMainText(this.strip2Y);
        } else {
            Utils.drawString(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_LOCKED"), ApplicationData.screenWidth / 2, this.strip2Y, 3, 0);
        }
        int nTop = this.strip1Y + MainUSRScreen.getStrip1Height() / 2 - this.emptyBarHeight;
        Graphic2D.SetColor(this.emptyBarColor);
        Graphic2D.FillRect(0, nTop, ApplicationData.screenWidth, (this.emptyBarHeight - this.fullBarHeight) / 2);
        Graphic2D.FillRect(0, nTop + this.emptyBarHeight - (this.emptyBarHeight - this.fullBarHeight) / 2, ApplicationData.screenWidth, (this.emptyBarHeight - this.fullBarHeight) / 2);
        Graphic2D.SetColor(this.fullBarColor);
        Graphic2D.FillRect(0, nTop += (this.emptyBarHeight - this.fullBarHeight) / 2, this.counterDraw * ApplicationData.screenWidth / 100, this.fullBarHeight);
    }

    public boolean rightSoftButton() {
        UIScreen.SetCurrentScreen(new CareerScreen());
        return true;
    }

    public boolean leftSoftButton() {
        return false;
    }

    public boolean selectLeftAction() {
        UIButton b = this.findByID(100);
        if (b != null) {
            b.setSelect(true);
            return true;
        }
        return false;
    }

    public boolean selectRightAction() {
        UIButton b = this.findByID(101);
        if (b != null) {
            b.setSelect(true);
            return true;
        }
        return false;
    }

    public boolean actionSoftButton(int nID, boolean pressed) {
        if (super.actionSoftButton(nID, pressed)) {
            return true;
        }
        if (!pressed) {
            this.unselectAllButtons();
            if (nID == 100) {
                this.onLeftAction();
                return true;
            }
            if (nID == 101) {
                this.onRightAction();
                return true;
            }
        }
        return false;
    }

    public boolean onRightAction() {
        ++this.currentMenuElement;
        if (this.currentMenuElement >= NUM_MENU_ELEMENTS) {
            this.currentMenuElement = 0;
        }
        this.updateScreenInfo();
        return true;
    }

    public boolean onLeftAction() {
        --this.currentMenuElement;
        if (this.currentMenuElement < 0) {
            this.currentMenuElement = NUM_MENU_ELEMENTS - 1;
        }
        this.updateScreenInfo();
        return true;
    }

    private void updateScreenInfo() {
        CGUserCareer.currentBabe = this.currentMenuElement;
        int nakedID = CGUserCareer.babeUnlockState[remapBabesOrder[this.currentMenuElement]];
        if (nakedID > 0) {
            this.babeTexture = TextureManager.AddTexture("/babe_" + (remapBabesOrder[this.currentMenuElement] + 1) + "_" + nakedID + ".png");
        }
        this.babeName = TextureManager.AddTexture("/babe_" + (remapBabesOrder[this.currentMenuElement] + 1) + "_name.png");
        this.babePowerUp = ApplicationData.lp.getTranslatedString(Options.languageID, "TID_BABE_POWERUP_REWARD_" + (remapBabesOrder[this.currentMenuElement] + 1));
        this.babePowerUpIcon = TextureManager.AddTexture("/babe_powerup_" + (remapBabesOrder[this.currentMenuElement] + 1) + ".png");
        this.setSoftButtonImage(null, null, ObjectsCache.menuSbBACK, ObjectsCache.menuSbBACK_a);
        this.babeID = ApplicationData.defaultFont.encodeDynamicString(this.currentMenuElement + 1 + "/4");
        this.counterDraw = 25 * CGUserCareer.babeUnlockState[remapBabesOrder[this.currentMenuElement]];
    }

    public boolean onFireAction() {
        return this.leftSoftButton();
    }
}

