/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gui;

import baltorogames.system.BGStore;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class Achievements {
    public static final int ACHIEVEMENTS_ID_NEWBY = 5;
    public static final int ACHIEVEMENTS_ID_WON_RACE = 4;
    public static final int ACHIEVEMENTS_ID_CAREER_MASTER = 3;
    public static final int ACHIEVEMENTS_ID_GAIN_50_POINTS = 0;
    public static final int ACHIEVEMENTS_ID_GAIN_25_POINTS = 1;
    public static final int ACHIEVEMENTS_ID_GAIN_FIRST_POINTS = 2;
    public static final int ACHIEVEMENTS_ID_AGAINST_ALL_ODDS = 6;
    public static final int ACHIEVEMENTS_ID_CIRCLE_RUNNER = 7;
    public static final int ACHIEVEMENTS_ID_STOP_AND_GO = 8;
    public static final int ACHIEVEMENTS_ID_PODIUM_STAND = 9;
    public static final int ACHIEVEMENTS_ID_TOP_STEP = 10;
    public static final int ACHIEVEMENTS_ID_WORLD_CHAMPION = 11;
    public static final int ACHIEVEMENTS_ID_DOUBLE_WORLD_CHAMPION = 12;
    public static final int ACHIEVEMENTS_ID_TRIPLE_WORLD_CHAMPION = 13;
    public static final int ACHIEVEMENTS_ID_LEGEND_DRIVER = 14;
    public static final int ACHIEVEMENTS_ID_RAIN_MASTER = 15;
    public static final int ACHIEVEMENTS_ID_FAILURE_WHAT_FAILURE = 16;
    public static final int ACHIEVEMENTS_ID_SAND_STORM = 17;
    public static final int ACHIEVEMENTS_ID_TEAM_PLAYER = 18;
    public static final int ACHIEVEMENTS_ID_HOT_CHAMPION = 19;
    public static final int ACHIEVEMENTS_RACE_NEWBY = 20;
    public static final int ACHIEVEMENTS_WAVE_THEM = 21;
    public static final int ACHIEVEMENTS_TIERS_UP = 22;
    public static final int MAX_NUM_OTHER_ACHIEVEMENTS = 6;
    private boolean[] otherAchievements = new boolean[6];
    public static final String[] OpenFeintAchIDs = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22"};
    public static final String[] OpenFeintLBIDs = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22"};

    public boolean isAchievementCompleted(int id) {
        return this.otherAchievements[id];
    }

    public int completeAchievment(int id) {
        System.out.println("==<<>> Achi ID = " + id);
        if (!this.isAchievementCompleted(id)) {
            this.otherAchievements[id] = true;
            return 1;
        }
        return 0;
    }

    public void reset(boolean resetTrophy) {
        this.otherAchievements = new boolean[6];
        for (int i = 0; i < this.otherAchievements.length; ++i) {
            this.otherAchievements[i] = false;
        }
    }

    public boolean readFromStore() {
        BGStore store = BGStore.openStoreToRead("Achievements");
        if (store == null) {
            return false;
        }
        try {
            DataInputStream inputStream = store.getInStream();
            if (inputStream != null && inputStream.available() > 0) {
                this.deSerialize(inputStream);
            }
            store.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public void writeToStore() {
        BGStore store = BGStore.openStoreToWrite("Achievements");
        if (store == null) {
            return;
        }
        try {
            DataOutputStream outputStream = store.getOutStream();
            this.serialize(outputStream);
            store.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void deSerialize(DataInputStream inputStream) throws IOException {
        for (int i = 0; i < 6; ++i) {
            this.otherAchievements[i] = inputStream.readBoolean();
        }
    }

    private void serialize(DataOutputStream outputStream) throws IOException {
        for (int i = 0; i < 6; ++i) {
            outputStream.writeBoolean(this.otherAchievements[i]);
        }
    }
}

