/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.project_gameplay.CareerKart;
import baltorogames.project_gui.CareerScreen;
import baltorogames.project_gui.EventScreen;
import baltorogames.project_gui.TrophyStatistic;
import baltorogames.system.BGStore;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class CGUserCareer {
    public static boolean[] avalaibleEvents = new boolean[]{true, false, false, false};
    public static final int eMaxLevels = 9;
    public static int difficultyLevel = 0;
    public static int availableDifficultyLevel = 0;
    public static final int LEVEL_ROOKIE = 0;
    public static final int LEVEL_SEMIPRO = 1;
    public static final int LEVEL_WORLD_CLASS = 2;
    public static final int NUM_KARTS = 6;
    public static final int NR_OF_TRACKS = 9;
    public static final int eNrOfBolids = 6;
    public static int[] generalClasification = new int[6];
    public static boolean[] tracksUnlocked = new boolean[9];
    public static int[] tracksTime = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE};
    public static int[] babeUnlockState = new int[4];
    private static boolean[] availableKarts = new boolean[]{true, true, false, false, false, false, false, false, false, false};
    public static CareerKart[] playerKarts = new CareerKart[6];
    private static int[] raceIDtoCityID = new int[]{1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5};
    private static int[] eventIDtoCityID = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
    protected static String m_szNick;
    protected static String m_szDevicePlatform;
    public static int m_nRaceID;
    public static int currentBabe;
    public static int currentKart;
    public static int m_nFamePoints;
    protected static int m_nPoints;
    protected static int racesWon;

    public static int FindHumanPosition() {
        int i;
        int first = generalClasification[0];
        int second = generalClasification[0];
        int third = generalClasification[0];
        for (i = 0; i < generalClasification.length; ++i) {
            if (first >= generalClasification[i]) continue;
            first = generalClasification[i];
        }
        for (i = 0; i < generalClasification.length; ++i) {
            if (second >= generalClasification[i] || generalClasification[i] == first) continue;
            second = generalClasification[i];
        }
        for (i = 0; i < generalClasification.length; ++i) {
            if (third >= generalClasification[i] || generalClasification[i] == first || generalClasification[i] == second) continue;
            third = generalClasification[i];
        }
        if (first == generalClasification[0]) {
            return 0;
        }
        if (second == generalClasification[0]) {
            return 1;
        }
        if (third == generalClasification[0]) {
            return 2;
        }
        return 3;
    }

    public static void UnlockAllCars() {
        for (int i = 0; i < availableKarts.length; ++i) {
            CGUserCareer.availableKarts[i] = true;
        }
    }

    public static void unlockCar() {
        switch (availableDifficultyLevel) {
            case 0: {
                CGUserCareer.availableKarts[2] = true;
                CGUserCareer.availableKarts[1] = true;
                CGUserCareer.availableKarts[0] = true;
                break;
            }
            case 1: {
                CGUserCareer.availableKarts[3] = true;
                CGUserCareer.availableKarts[2] = true;
                CGUserCareer.availableKarts[1] = true;
                CGUserCareer.availableKarts[0] = true;
                break;
            }
            case 2: {
                CGUserCareer.availableKarts[4] = true;
                CGUserCareer.availableKarts[3] = true;
                CGUserCareer.availableKarts[2] = true;
                CGUserCareer.availableKarts[1] = true;
                CGUserCareer.availableKarts[0] = true;
                break;
            }
            default: {
                CGUserCareer.availableKarts[2] = true;
                CGUserCareer.availableKarts[1] = true;
                CGUserCareer.availableKarts[0] = true;
            }
        }
    }

    public static void Reset() {
        int i;
        m_nPoints = 0;
        m_nFamePoints = 0;
        if (CGUserCareer.isAnyGameStored()) {
            m_nRaceID = -1;
        }
        if (!CGUserCareer.isAnyGameStored()) {
            for (i = 0; i < 9; ++i) {
                CGUserCareer.tracksUnlocked[i] = false;
            }
            CGUserCareer.tracksUnlocked[0] = true;
            for (i = 1; i < tracksUnlocked.length; ++i) {
                CGUserCareer.tracksUnlocked[i] = false;
            }
            for (i = 0; i < tracksTime.length; ++i) {
                CGUserCareer.tracksTime[i] = Integer.MAX_VALUE;
            }
            currentKart = 0;
            m_szNick = "";
            m_szDevicePlatform = "";
            CGUserCareer.playerKarts[0] = new CareerKart(2048L, 2048L, 0, 0, 1, 2, 3);
            CGUserCareer.playerKarts[1] = new CareerKart(2060L, 2060L, 1, 0, 1, 2, 3);
            CGUserCareer.playerKarts[2] = new CareerKart(2072L, 2072L, 0, 0, 1, 2, 3);
            CGUserCareer.playerKarts[3] = new CareerKart(2084L, 2084L, 0, 0, 1, 2, 3);
            CGUserCareer.playerKarts[4] = new CareerKart(2096L, 2096L, 1, 0, 1, 2, 3);
            CGUserCareer.playerKarts[5] = new CareerKart(2108L, 2108L, 0, 0, 1, 2, 3);
        }
        for (i = 0; i < 6; ++i) {
            CGUserCareer.generalClasification[i] = 0;
        }
    }

    public static void NextEventReset() {
        System.out.println("NextEventReset()");
        m_nPoints = 0;
        m_nFamePoints = 0;
        if (CGUserCareer.isAnyGameStored()) {
            m_nRaceID = -1;
        }
        if (!CGUserCareer.isAnyGameStored()) {
            m_szDevicePlatform = "";
            CGUserCareer.playerKarts[0] = new CareerKart(2048L, 2048L, 0, 0, 1, 2, 3);
            CGUserCareer.playerKarts[1] = new CareerKart(2060L, 2060L, 1, 0, 1, 2, 3);
            CGUserCareer.playerKarts[2] = new CareerKart(2072L, 2072L, 0, 0, 1, 2, 3);
            CGUserCareer.playerKarts[3] = new CareerKart(2084L, 2084L, 0, 0, 1, 2, 3);
            CGUserCareer.playerKarts[4] = new CareerKart(2096L, 2096L, 1, 0, 1, 2, 3);
            CGUserCareer.playerKarts[5] = new CareerKart(2108L, 2108L, 0, 0, 1, 2, 3);
        }
        for (int i = 0; i < 6; ++i) {
            CGUserCareer.generalClasification[i] = 0;
        }
    }

    public static void ResetCareer() {
        int i;
        m_nPoints = 0;
        m_nFamePoints = 0;
        if (CGUserCareer.isAnyGameStored()) {
            m_nRaceID = -1;
        }
        if (!CGUserCareer.isAnyGameStored()) {
            for (i = 0; i < 9; ++i) {
                System.out.println("Unlock, reset to false:" + i);
                CGUserCareer.tracksUnlocked[i] = false;
            }
            CGUserCareer.tracksUnlocked[0] = true;
            for (i = 1; i < tracksUnlocked.length; ++i) {
                CGUserCareer.tracksUnlocked[i] = true;
            }
            m_szNick = "";
            m_szDevicePlatform = "";
            CGUserCareer.playerKarts[0] = new CareerKart(2048L, 2048L, 0, 0, 1, 2, 3);
            CGUserCareer.playerKarts[1] = new CareerKart(2060L, 2060L, 1, 0, 1, 2, 3);
            CGUserCareer.playerKarts[2] = new CareerKart(2072L, 2072L, 0, 0, 1, 2, 3);
            CGUserCareer.playerKarts[3] = new CareerKart(2084L, 2084L, 0, 0, 1, 2, 3);
            CGUserCareer.playerKarts[4] = new CareerKart(2096L, 2096L, 1, 0, 1, 2, 3);
            CGUserCareer.playerKarts[5] = new CareerKart(2108L, 2108L, 0, 0, 1, 2, 3);
        }
        for (i = 0; i < 6; ++i) {
            CGUserCareer.generalClasification[i] = 0;
        }
    }

    public static void ResetAllNewChamp() {
        int i;
        m_nPoints = 0;
        m_nFamePoints = 0;
        m_nRaceID = -1;
        CGUserCareer.babeUnlockState[3] = 0;
        CGUserCareer.babeUnlockState[2] = 0;
        CGUserCareer.babeUnlockState[1] = 0;
        CGUserCareer.babeUnlockState[0] = 0;
        currentBabe = 0;
        m_szNick = "";
        m_szDevicePlatform = "";
        CGUserCareer.playerKarts[0] = new CareerKart(2048L, 2048L, 0, 0, 1, 2, 3);
        CGUserCareer.playerKarts[1] = new CareerKart(2060L, 2060L, 1, 0, 1, 2, 3);
        CGUserCareer.playerKarts[2] = new CareerKart(2072L, 2072L, 0, 0, 1, 2, 3);
        CGUserCareer.playerKarts[3] = new CareerKart(2084L, 2084L, 0, 0, 1, 2, 3);
        CGUserCareer.playerKarts[4] = new CareerKart(2096L, 2096L, 1, 0, 1, 2, 3);
        CGUserCareer.playerKarts[5] = new CareerKart(2108L, 2108L, 0, 0, 1, 2, 3);
        for (i = 0; i < 6; ++i) {
            CGUserCareer.generalClasification[i] = 0;
        }
        for (i = 1; i < avalaibleEvents.length; ++i) {
            CGUserCareer.avalaibleEvents[i] = false;
        }
    }

    public static void ResetAll() {
        int i;
        m_nPoints = 0;
        m_nFamePoints = 0;
        m_nRaceID = -1;
        TrophyStatistic.allPoints = 0;
        TrophyStatistic.raceFinished = 0;
        CGUserCareer.resetRacesWon();
        for (i = 0; i < 9; ++i) {
            CGUserCareer.tracksUnlocked[i] = false;
        }
        CGUserCareer.tracksUnlocked[0] = true;
        CGUserCareer.babeUnlockState[3] = 0;
        CGUserCareer.babeUnlockState[2] = 0;
        CGUserCareer.babeUnlockState[1] = 0;
        CGUserCareer.babeUnlockState[0] = 0;
        currentBabe = 0;
        CGUserCareer.availableKarts[0] = true;
        CGUserCareer.availableKarts[1] = true;
        CGUserCareer.availableKarts[2] = false;
        CGUserCareer.availableKarts[3] = false;
        for (i = 4; i < availableKarts.length; ++i) {
            CGUserCareer.availableKarts[i] = false;
        }
        for (i = 0; i < tracksTime.length; ++i) {
            CGUserCareer.tracksTime[i] = Integer.MAX_VALUE;
        }
        currentKart = 0;
        m_szNick = "";
        m_szDevicePlatform = "";
        CGUserCareer.playerKarts[0] = new CareerKart(2048L, 2048L, 0, 0, 1, 2, 3);
        CGUserCareer.playerKarts[1] = new CareerKart(2060L, 2060L, 1, 0, 1, 2, 3);
        CGUserCareer.playerKarts[2] = new CareerKart(2072L, 2072L, 0, 0, 1, 2, 3);
        CGUserCareer.playerKarts[3] = new CareerKart(2084L, 2084L, 0, 0, 1, 2, 3);
        CGUserCareer.playerKarts[4] = new CareerKart(2096L, 2096L, 1, 0, 1, 2, 3);
        CGUserCareer.playerKarts[5] = new CareerKart(2108L, 2108L, 0, 0, 1, 2, 3);
        for (i = 0; i < 6; ++i) {
            CGUserCareer.generalClasification[i] = 0;
        }
        for (i = 1; i < avalaibleEvents.length; ++i) {
            CGUserCareer.avalaibleEvents[i] = false;
        }
    }

    public static void Load() {
        CGUserCareer.Reset();
        BGStore store = BGStore.openStoreToRead("UserCareer");
        if (store == null) {
            return;
        }
        try {
            DataInputStream inputStream = store.getInStream();
            if (inputStream != null && inputStream.available() > 0) {
                int i;
                for (i = 0; i < EventScreen.eventsNames.length; ++i) {
                    EventScreen.medalEvents[i] = inputStream.readInt();
                }
                for (i = 1; i < avalaibleEvents.length; ++i) {
                    CGUserCareer.avalaibleEvents[i] = inputStream.readBoolean();
                }
                availableDifficultyLevel = inputStream.readInt();
                difficultyLevel = inputStream.readInt();
                m_nRaceID = inputStream.readInt();
                m_nPoints = inputStream.readInt();
                m_nFamePoints = inputStream.readInt();
                for (i = 0; i < 9; ++i) {
                    CGUserCareer.tracksUnlocked[i] = inputStream.readBoolean();
                }
                for (i = 0; i < availableKarts.length; ++i) {
                    CGUserCareer.availableKarts[i] = inputStream.readBoolean();
                }
                for (i = 0; i < tracksTime.length; ++i) {
                    CGUserCareer.tracksTime[i] = inputStream.readInt();
                }
                currentKart = inputStream.readInt();
                CareerScreen.nextEvent = inputStream.readInt();
                m_szNick = inputStream.readUTF();
                m_szDevicePlatform = inputStream.readUTF();
                for (i = 0; i < 3; ++i) {
                    playerKarts[i].deSerialize(inputStream);
                }
                for (i = 0; i < 6; ++i) {
                    CGUserCareer.generalClasification[i] = inputStream.readInt();
                }
                racesWon = inputStream.readInt();
                TrophyStatistic.allPoints = inputStream.readInt();
                TrophyStatistic.raceFinished = inputStream.readInt();
            }
            store.close();
        }
        catch (Exception e) {
            System.out.println("============================================================================================================================Career not loaded");
            CGUserCareer.Reset();
            return;
        }
    }

    public static void Save() {
        BGStore store = BGStore.openStoreToWrite("UserCareer");
        if (store == null) {
            return;
        }
        try {
            int i;
            DataOutputStream outputStream = store.getOutStream();
            for (i = 0; i < EventScreen.medalEvents.length; ++i) {
                outputStream.writeInt(EventScreen.medalEvents[i]);
            }
            for (i = 1; i < avalaibleEvents.length; ++i) {
                outputStream.writeBoolean(avalaibleEvents[i]);
            }
            outputStream.writeInt(availableDifficultyLevel);
            outputStream.writeInt(difficultyLevel);
            outputStream.writeInt(m_nRaceID);
            outputStream.writeInt(m_nPoints);
            outputStream.writeInt(m_nFamePoints);
            for (i = 0; i < 9; ++i) {
                outputStream.writeBoolean(tracksUnlocked[i]);
            }
            for (i = 0; i < availableKarts.length; ++i) {
                outputStream.writeBoolean(availableKarts[i]);
            }
            for (i = 0; i < tracksTime.length; ++i) {
                outputStream.writeInt(tracksTime[i]);
            }
            outputStream.writeInt(currentKart);
            outputStream.writeInt(CareerScreen.nextEvent);
            outputStream.writeUTF(m_szNick);
            outputStream.writeUTF(m_szDevicePlatform);
            for (i = 0; i < 3; ++i) {
                playerKarts[i].serialize(outputStream);
            }
            for (i = 0; i < 6; ++i) {
                outputStream.writeInt(generalClasification[i]);
            }
            outputStream.writeInt(racesWon);
            outputStream.writeInt(TrophyStatistic.allPoints);
            outputStream.writeInt(TrophyStatistic.raceFinished);
            store.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static int getEventFromRaceID(int raceID) {
        return eventIDtoCityID[raceID];
    }

    public static int getCityFromRaceID(int raceID) {
        try {
            return raceIDtoCityID[raceID];
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static void unlockBabe(int babeID, int level) {
        CGUserCareer.babeUnlockState[babeID] = level;
    }

    public static boolean isKartAvailable(int kartID) {
        return availableKarts[kartID];
    }

    public static void unlockKart(int id) {
        CGUserCareer.availableKarts[id] = true;
    }

    public static boolean isAnyGameStored() {
        return m_nRaceID >= 0;
    }

    public static int GetPoints() {
        return m_nPoints;
    }

    public static void AddPoints(int n) {
        m_nPoints += n;
    }

    public static int GetFamePoints() {
        return m_nFamePoints;
    }

    public static void AddFamePoints(int n) {
        if ((m_nFamePoints += n) < 0) {
            m_nFamePoints = 0;
        }
    }

    public static void SetRaceID(int i) {
        m_nRaceID = i;
    }

    public static int GetRaceID() {
        return m_nRaceID;
    }

    public static void SetNick(String s) {
        m_szNick = s;
    }

    public static String GetNick() {
        return m_szNick;
    }

    public static void SetDevicePlatform(String s) {
        m_szDevicePlatform = s;
    }

    public static String GetDevicePlatform() {
        return m_szDevicePlatform;
    }

    public static int getRacesWon() {
        return racesWon;
    }

    public static void resetRacesWon() {
        racesWon = 0;
    }

    public static void setRacesWon() {
        ++racesWon;
    }

    static {
        m_nRaceID = -1;
        currentBabe = 0;
        currentKart = 0;
        m_nFamePoints = 0;
        racesWon = 0;
    }
}

