/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.core_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core.Utils;
import baltorogames.core_gui.UIButton;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.system.ObjectsCache;
import baltorogames.system.Options;

public class UIResultTableButton
extends UIButton {
    public static final int ANIM_FROM_RIGHT = 0;
    public static final int ANIM_FROM_LEFT = 1;
    public static final int ANIM_FROM_BOTTOM = 2;
    public static final int ANIM_FROM_TOP = 3;
    private String position = null;
    private String riderName = null;
    private String time = null;
    private String points = null;
    private String caption = null;
    private String value = null;
    public static final int EMPTY = -1;
    public static int typeOfAnimation = 0;
    protected CGTexture flagueTexture;
    protected boolean isFlagueTexture = false;

    public UIResultTableButton() {
    }

    public UIResultTableButton(int l, int t, int r, int b, int bID) {
        super(l, t, r, b, bID);
    }

    public UIResultTableButton(int l, int t, String csNormalTexture, String csSelectTexture, String csInactiveTexture, int bID) {
        super(l, t, csNormalTexture, csSelectTexture, csInactiveTexture, bID);
    }

    public UIResultTableButton(int l, int t, CGTexture NormalTexture, CGTexture SelectTexture, CGTexture InactiveTexture, CGTexture flagueTexture, int bID) {
        super(l, t, NormalTexture, SelectTexture, InactiveTexture, bID);
        if (flagueTexture != null) {
            this.flagueTexture = flagueTexture;
            this.isFlagueTexture = false;
        }
    }

    public UIResultTableButton(int l, int t, CGTexture NormalTexture, int BUTTON_LABEL, int bID) {
        this.buttonID = bID;
        this.top = t;
        this.left = l;
        this.textures = new CGTexture[3];
        this.textures[0] = NormalTexture;
        if (NormalTexture != null) {
            this.bottom = this.top + this.textures[0].GetHeight();
            this.right = this.left + this.textures[0].GetWidth();
        }
        this.buttonID = bID;
        this.isReadyForSelect = false;
        this.isSelected = false;
        this.isVisible = true;
        this.isActive = true;
        this.currentleft = this.left;
        this.currenttop = this.top;
        if (BUTTON_LABEL != -1) {
            this.flagueTexture = ObjectsCache.labelForButton[BUTTON_LABEL];
            this.isFlagueTexture = false;
        }
    }

    public void draw() {
        if (!this.isReadyForSelect) {
            switch (typeOfAnimation) {
                case 0: {
                    if (this.leftstart > this.left && this.currentleft > this.left) {
                        this.currentleft -= ApplicationData.stepDeltaTime * 3 * ApplicationData.screenWidth / 1000;
                        if (this.currentleft < this.left) {
                            this.currentleft = this.left;
                        }
                    }
                    if (this.leftstart >= this.left || this.currentleft >= this.left) break;
                    this.currentleft += ApplicationData.stepDeltaTime * 3 * ApplicationData.screenWidth / 1000;
                    if (this.currentleft <= this.left) break;
                    this.currentleft = this.left;
                    break;
                }
                case 1: {
                    if (this.leftstart < this.left && this.currentleft < this.left) {
                        this.currentleft += ApplicationData.stepDeltaTime * 3 * ApplicationData.screenWidth / 1000;
                        if (this.currentleft > this.left) {
                            this.currentleft = this.left;
                        }
                    }
                    if (this.leftstart <= this.left || this.currentleft <= this.left) break;
                    this.currentleft -= ApplicationData.stepDeltaTime * 3 * ApplicationData.screenWidth / 1000;
                    if (this.currentleft >= this.left) break;
                    this.currentleft = this.left;
                    break;
                }
                case 3: {
                    break;
                }
            }
            if (this.isVisible) {
                int left_x;
                if (!this.isActive) {
                    if (this.textures[2] != null) {
                        Graphic2D.DrawImage(this.textures[2], this.currentleft, this.top, 20);
                    }
                    if (this.isFlagueTexture) {
                        Graphic2D.DrawImage(this.flagueTexture, this.currentleft, this.top, 20);
                    }
                } else if (ObjectsCache.resultScreenButton != null) {
                    Graphic2D.DrawImage(this.textures[0], this.currentleft, this.top, 20);
                    if (this.isFlagueTexture) {
                        Graphic2D.DrawImage(this.flagueTexture, this.currentleft, this.top, 20);
                    }
                }
                if (this.caption != null) {
                    left_x = this.currentleft + ObjectsCache.resultScreenButton.GetWidth() * 11 / 100;
                    Utils.drawString(this.caption, left_x, (this.top + this.bottom) / 2, 6, 0);
                }
                if (this.value != null) {
                    left_x = this.currentleft + ObjectsCache.resultScreenButton.GetWidth() * 87 / 100;
                    Utils.drawString(this.value, left_x, (this.top + this.bottom) / 2, 3, 0);
                }
            }
        }
    }

    public void drawRemoveButton() {
        super.drawRemoveButton();
        if (this.isReadyForSelect) {
            if (this.currentleft <= ApplicationData.screenWidth) {
                this.currentleft += ApplicationData.stepDeltaTime * 3 * ApplicationData.screenWidth / 1000;
            }
            if (this.textures[1] != null && this.isVisible) {
                Graphic2D.DrawImage(this.textures[0], this.currentleft, this.top, 20);
                if (this.isFlagueTexture) {
                    Graphic2D.DrawImage(this.flagueTexture, this.currentleft, this.top, 20);
                }
            }
            if (this.caption != null && this.caption.length() > 0) {
                int center_x = this.currentleft + (this.right - this.left) / 2;
                Utils.drawString(this.caption, center_x, (this.top + this.bottom) / 2, 3, this.fontID);
            }
        }
    }

    public void setButtonCaption(String caption) {
        this.caption = ApplicationData.lp.getTranslatedString(Options.languageID, caption);
    }

    public void setButtonValue(int value) {
        this.value = ApplicationData.defaultFont.encodeDynamicString(Integer.toString(value));
    }

    public void setDrawClicked(boolean set) {
        this.isFlagueTexture = set;
    }

    public boolean getDrawClicked() {
        return this.isFlagueTexture;
    }

    public void setFlaguelImage(CGTexture image) {
        this.flagueTexture = image;
    }

    public void setSelect(boolean b) {
        this.isSelected = b;
    }

    public boolean getSelect() {
        return this.isSelected;
    }

    public void setReadyForSelected(boolean b) {
        this.isReadyForSelect = b;
    }

    public String getPosition() {
        return this.position;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public String getRiderName() {
        return this.riderName;
    }

    public void setRiderName(String riderName) {
        this.riderName = riderName;
    }

    public String getTime() {
        return this.time;
    }

    public void setTime(String time) {
        this.time = time;
    }

    public String getPoints() {
        return this.points;
    }

    public void setPoints(String points) {
        this.points = points;
    }
}

