/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.MainCanvas;
import sk.inlogic.Profile;
import sk.inlogic.Resources;
import sk.inlogic.Sounds;
import sk.inlogic.X;
import sk.inlogic.game.Bonus;
import sk.inlogic.game.Game;
import sk.inlogic.graphics.GFont;
import sk.inlogic.screen.IScreen;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenMain
implements IScreen {
    public MainCanvas mainCanvas;
    public GFont fontMain;
    public GFont fontSmall;
    private Game game;
    public final byte SCREEN_INTRO;
    public final byte SCREEN_MENU;
    public final byte SCREEN_GAME = (byte)2;
    public final byte INTRO_INIT_GRAPHICS;
    public final byte INTRO_INIT;
    public final byte INTRO_LOGO_INLOGIC = (byte)2;
    public final byte INTRO_LANGUAGE = (byte)3;
    public final byte INTRO_ENABLE_MUSIC = (byte)4;
    public final byte MENU_MAIN;
    public final byte MENU_INSTRUCTIONS;
    public final byte MENU_ABOUT = (byte)2;
    public final byte MENU_QUIT = (byte)3;
    public final byte MENU_SELECT_GAMETYPE = (byte)4;
    public final byte MENU_SHOP = (byte)5;
    public static final byte GAME_MAIN = 0;
    public static final byte GAME_OVER = 1;
    public static final byte GAME_PAUSE = 2;
    public static final byte GAME_RESET_MESSAGE = 3;
    public static final byte GAME_QUIT_MESSAGE = 4;
    public static final byte GAME_TUTORIAL = 5;
    final byte ID_MENU_PLAY;
    final byte ID_MENU_INSTRUCTIONS;
    final byte ID_MENU_ABOUT = (byte)2;
    final byte ID_MENU_SOUND = (byte)3;
    final byte ID_MENU_ITEMS_TOTAL = (byte)4;
    final byte ID_PAUSE_RESTART;
    final byte ID_PAUSE_INSTRUCTIONS;
    final byte ID_PAUSE_SOUND = (byte)2;
    final byte ID_PAUSE_SHOP = (byte)3;
    byte ID_PAUSE_ITEMS_TOTAL = (byte)4;
    final byte ID_SELECT_MOVES;
    final byte ID_SELECT_TIME;
    final byte ID_SELECT_ENDLESS = (byte)2;
    final byte ID_SELECT_SHOP = (byte)3;
    final byte ID_SELECT_TOTAL = (byte)4;
    final byte ID_SHOP_MOVES;
    final byte ID_SHOP_TIME;
    final byte ID_SHOP_DOTS = (byte)2;
    final byte ID_SHOP_COLOR = (byte)3;
    final byte ID_SHOP_TOTAL = (byte)4;
    private int iMenuItemsTotal;
    private int screen;
    public int subScreen;
    public int iSelectedMenuItem;
    public boolean bLoading = false;
    Rectangle[] rectMenuItems;
    Rectangle[] rectSelectGameItems;
    Rectangle[] rectPauseItems;
    int[] menuItemsFrames;
    int[] shopItemsFrames;
    int[] selectGameItemsFrames;
    int[] pauseItemsFrames;
    public boolean bDragInstructions = false;
    private int iTextLines = 1;
    public String strTextBody;
    String[] strTextMenu = new String[4];
    String[] strTextPom = new String[3];
    PreparedText prepText;
    private int updateCounter = 0;
    private int iShiftDirection;
    public int iShiftX;
    private int iShiftStep;
    private int iInstructionsCenterY;
    private int iInstructionsWidth;
    private int iInstructionsHeight;
    private int iTextShiftY = 0;
    private int iInstructionsShiftY = 0;
    private int iInstructionsMaxShiftY = 0;
    private boolean bPaintShopError;
    private boolean bInAnimation;
    private boolean bOutAnimation;
    private static final int DELAY_TIME = 3000;
    private int delay;
    private static String[] langCodes = new String[]{"en", "de", "fr", "es", "pt"};
    private static final int[] LANGUAGES = new int[]{0, 1, 2, 3, 4};
    private static final int MAX_LANGUAGES = 5;
    private Rectangle[] rectLanguages = new Rectangle[5];
    private int iSelectedLanguage;
    private int mScr;
    private int sScr;
    private int pScr;
    private int aGt;
    private boolean bply;
    int acc = 0;
    int acc2 = 0;
    int acc3 = 0;
    int acc4 = 0;
    int goCounter;
    int goStep;
    int iPaintCounter = 0;
    public static Image imgPause;
    public static Image imgTitle;
    public static Image imgInlogic;
    public static Sprite sprFkIcons;
    public static Sprite sprGameIcons;
    public static Sprite sprDots;
    public static Sprite sprBorder;
    public static Sprite sprMenuIcons;
    public static Sprite sprLanguage;
    public static Sprite sprArrows;
    private Rectangle rectTitleCenter;
    Rectangle rectTopBar;
    Rectangle[] rectShopItems;
    int iShopItemCupX;
    int iMenuAnimOffX;
    int iMenuAnimLogoOffY;
    int iFkAnimOffY;
    int iTopBarAnimOffY;
    int iAnimStep;
    int iShopItemOff;
    int iShopPriceOff;
    public static boolean bTutorialMoves;
    public static boolean bTutorialTime;
    public static boolean bTutorialEndless;
    public boolean bStart = false;
    int prevScreen;

    public ScreenMain(MainCanvas mainCanvas) {
        this.SCREEN_INTRO = 0;
        this.SCREEN_MENU = 1;
        this.INTRO_INIT_GRAPHICS = 0;
        this.INTRO_INIT = 1;
        this.MENU_MAIN = 0;
        this.MENU_INSTRUCTIONS = 1;
        this.ID_MENU_PLAY = 0;
        this.ID_MENU_INSTRUCTIONS = 1;
        this.ID_PAUSE_RESTART = 0;
        this.ID_PAUSE_INSTRUCTIONS = 1;
        this.ID_SELECT_MOVES = 0;
        this.ID_SELECT_TIME = 1;
        this.ID_SHOP_MOVES = 0;
        this.ID_SHOP_TIME = 1;
        this.mainCanvas = mainCanvas;
    }

    public void updateShift() {
        ++this.updateCounter;
        if (this.updateCounter > 1) {
            this.updateCounter = 0;
            if (this.iShiftDirection > 0) {
                this.iShiftX += this.iShiftStep;
                if (this.iShiftX >= this.iShiftStep << 1) {
                    this.iShiftDirection = -1;
                }
            } else {
                this.iShiftX -= this.iShiftStep;
                if (this.iShiftX <= -(this.iShiftStep << 1)) {
                    this.iShiftDirection = 1;
                }
            }
        }
    }

    public void update(long lTick) {
        if (this.mainCanvas.isInterrupted()) {
            return;
        }
        if (!this.bLoading) {
            block0 : switch (this.screen) {
                case 0: {
                    switch (this.subScreen) {
                        case 0: {
                            this.initGraphics();
                            break block0;
                        }
                        case 1: {
                            this.initIntro();
                            break block0;
                        }
                        case 2: {
                            if (this.delay > 0) {
                                this.delay = (int)((long)this.delay - lTick);
                                break block0;
                            }
                            this.nextScreen(0, 3, 2);
                            break block0;
                        }
                        case 3: {
                            this.updateShift();
                            break block0;
                        }
                    }
                    break;
                }
                case 1: {
                    switch (this.subScreen) {
                        case 0: {
                            this.updateShift();
                            break block0;
                        }
                        case 5: {
                            this.updateShift();
                            this.updateShopError(lTick);
                            break block0;
                        }
                        case 1: {
                            this.updateInstructions();
                            break block0;
                        }
                        case 4: {
                            this.updateShift();
                            break block0;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (this.subScreen) {
                        case 0: {
                            this.game.update(lTick);
                            break block0;
                        }
                        case 2: {
                            this.updateShift();
                            break block0;
                        }
                        case 1: {
                            break block0;
                        }
                        case 4: {
                            break block0;
                        }
                        case 3: {
                            break block0;
                        }
                        case 5: {
                            break block0;
                        }
                    }
                    break;
                }
            }
            this.updateAnimations(lTick);
            this.mainCanvas.repaint();
        }
    }

    private void updateAnimations(long dt) {
        block46: {
            block45: {
                if (this.screen != 1) break block45;
                switch (this.subScreen) {
                    case 0: {
                        if (this.bInAnimation) {
                            if (!this.animationInMenu(dt)) {
                                boolean a = this.animationInMenuLogo(dt);
                                boolean b = this.animationInFk(dt);
                                if (!a && !b) {
                                    this.bInAnimation = false;
                                }
                            }
                            return;
                        }
                        if (this.bOutAnimation && !this.animationOutMenu(dt)) {
                            boolean a = this.animationOutMenuLogo(dt);
                            boolean b = this.animationOutFk(dt);
                            if (!a && !b) {
                                this.bOutAnimation = false;
                                this.nextScreen(this.mScr, this.sScr, this.pScr);
                                break;
                            }
                        }
                        break block46;
                    }
                    case 4: {
                        if (this.bInAnimation) {
                            if (!this.animationInMenu(dt) && !this.animationInFk(dt)) {
                                this.bInAnimation = false;
                            }
                            return;
                        }
                        if (this.bOutAnimation && !this.animationOutMenu(dt) && !this.animationOutFk(dt)) {
                            this.bOutAnimation = false;
                            if (this.bply) {
                                this.play(this.aGt, 4);
                                break;
                            }
                            this.nextScreen(this.mScr, this.sScr, this.pScr);
                            break;
                        }
                        break block46;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        if (this.bInAnimation) {
                            boolean a = this.animationInFk(dt);
                            boolean b = this.animationInTopBar(dt);
                            if (!a && !b) {
                                this.bInAnimation = false;
                            }
                            return;
                        }
                        if (this.bOutAnimation) {
                            boolean a = this.animationOutFk(dt);
                            boolean b = this.animationOutTopBar(dt);
                            if (!a && !b) {
                                this.bOutAnimation = false;
                                this.nextScreen(this.mScr, this.sScr, this.pScr);
                                break;
                            }
                        }
                        break block46;
                    }
                    case 5: {
                        if (this.bInAnimation) {
                            if (!this.animationInShopItem(dt) && !this.animationInShopPrice(dt)) {
                                boolean a = this.animationInFk(dt);
                                boolean b = this.animationInTopBar(dt);
                                if (!a && !b) {
                                    this.bInAnimation = false;
                                }
                            }
                            return;
                        }
                        if (this.bOutAnimation && !this.animationOutShopItem(dt) && !this.animationOutShopPrice(dt)) {
                            boolean a = this.animationOutFk(dt);
                            boolean b = this.animationOutTopBar(dt);
                            if (!a && !b) {
                                this.bOutAnimation = false;
                                this.nextScreen(this.mScr, this.sScr, this.pScr);
                                break;
                            }
                        }
                        break block46;
                    }
                }
                break block46;
            }
            if (this.screen == 2) {
                switch (this.subScreen) {
                    case 2: {
                        if (this.bInAnimation) {
                            if (!this.animationInMenu(dt) && !this.animationInFk(dt)) {
                                this.bInAnimation = false;
                            }
                            return;
                        }
                        if (!this.bOutAnimation || this.animationOutMenu(dt) || this.animationOutFk(dt)) break;
                        this.bOutAnimation = false;
                        this.nextScreen(this.mScr, this.sScr, this.pScr);
                        break;
                    }
                    case 3: 
                    case 4: {
                        if (this.bInAnimation) {
                            boolean a = this.animationInFk(dt);
                            boolean b = this.animationInTopBar(dt);
                            if (!a && !b) {
                                this.bInAnimation = false;
                            }
                            return;
                        }
                        if (!this.bOutAnimation) break;
                        boolean a = this.animationOutFk(dt);
                        boolean b = this.animationOutTopBar(dt);
                        if (a || b) break;
                        this.bOutAnimation = false;
                        if (this.bply) {
                            this.play(this.aGt, 3);
                            break;
                        }
                        this.nextScreen(this.mScr, this.sScr, this.pScr);
                        break;
                    }
                    case 5: {
                        boolean b;
                        boolean a;
                        if (this.bInAnimation) {
                            boolean a2 = this.animationInFk(dt);
                            boolean b2 = this.animationInTopBar(dt);
                            if (!a2 && !b2) {
                                this.bInAnimation = false;
                            }
                            return;
                        }
                        if (this.bOutAnimation) {
                            a = this.animationOutFk(dt);
                            b = this.animationOutTopBar(dt);
                            if (!a && !b) {
                                this.bOutAnimation = false;
                                if (this.bply) {
                                    this.play(this.aGt, 5);
                                } else {
                                    this.nextScreen(this.mScr, this.sScr, this.pScr);
                                }
                            }
                        }
                    }
                    case 1: {
                        boolean b;
                        boolean a;
                        if (this.bInAnimation) {
                            a = this.animationInFk(dt);
                            b = this.animationInTopBar(dt);
                            if (!(a || b || this.animationGameOver(dt))) {
                                this.bInAnimation = false;
                            }
                            return;
                        }
                        if (!this.bOutAnimation) break;
                        a = this.animationOutFk(dt);
                        b = this.animationOutTopBar(dt);
                        if (a || b) break;
                        this.bOutAnimation = false;
                        if (this.bply) {
                            this.play(this.aGt, 1);
                            break;
                        }
                        this.nextScreen(this.mScr, this.sScr, this.pScr);
                    }
                }
            }
        }
    }

    private void startAnimation(boolean in, int mainscr, int suscr, int prvscr, boolean play, int gametype) {
        this.acc = 0;
        this.acc2 = 0;
        this.acc3 = 0;
        this.acc4 = 0;
        this.mScr = mainscr;
        this.sScr = suscr;
        this.pScr = prvscr;
        this.aGt = gametype;
        this.bply = play;
        this.goStep = 0;
        this.goCounter = 0;
        if (in) {
            this.bInAnimation = true;
        } else {
            this.bOutAnimation = true;
        }
    }

    private boolean animationGameOver(long dt) {
        if (this.goStep < 3) {
            this.goCounter = (int)((long)this.goCounter + dt);
            if (this.goCounter > 150) {
                ++this.goStep;
                this.goCounter = 0;
            }
            return true;
        }
        return false;
    }

    private boolean animationInMenu(long dt) {
        this.acc += this.iAnimStep;
        if (this.bInAnimation) {
            if (this.iMenuAnimOffX > 0) {
                this.iMenuAnimOffX -= 0 + this.acc;
                if (this.iMenuAnimOffX < 0) {
                    this.iMenuAnimOffX = 0;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean animationOutMenu(long dt) {
        this.acc += this.iAnimStep;
        if (this.bOutAnimation) {
            if (this.iMenuAnimOffX < (MainCanvas.WIDTH >> 1) + (sprBorder.getWidth() >> 1)) {
                this.iMenuAnimOffX += 0 + this.acc;
                if (this.iMenuAnimOffX > (MainCanvas.WIDTH >> 1) + (sprBorder.getWidth() >> 1)) {
                    this.iMenuAnimOffX = (MainCanvas.WIDTH >> 1) + (sprBorder.getWidth() >> 1);
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean animationInMenuLogo(long dt) {
        this.acc2 += this.iAnimStep;
        if (this.bInAnimation && this.iMenuAnimLogoOffY > 0) {
            this.iMenuAnimLogoOffY -= this.acc2;
            if (this.iMenuAnimLogoOffY < 0) {
                this.iMenuAnimLogoOffY = 0;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean animationOutMenuLogo(long dt) {
        this.acc2 += this.iAnimStep;
        if (this.bOutAnimation && this.iMenuAnimLogoOffY < imgTitle.getHeight()) {
            this.iMenuAnimLogoOffY += this.acc2;
            if (this.iMenuAnimLogoOffY > imgTitle.getHeight()) {
                this.iMenuAnimLogoOffY = imgTitle.getHeight();
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean animationInFk(long dt) {
        this.acc3 += this.iAnimStep;
        if (this.bInAnimation && this.iFkAnimOffY > 0) {
            this.iFkAnimOffY -= this.acc3;
            if (this.iFkAnimOffY < 0) {
                this.iFkAnimOffY = 0;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean animationOutFk(long dt) {
        this.acc3 += this.iAnimStep;
        if (this.bOutAnimation && this.iFkAnimOffY < sprFkIcons.getHeight()) {
            this.iFkAnimOffY += this.acc3;
            if (this.iFkAnimOffY > sprFkIcons.getHeight()) {
                this.iFkAnimOffY = sprFkIcons.getHeight();
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean animationInTopBar(long dt) {
        this.acc4 += this.iAnimStep;
        if (this.bInAnimation && this.iTopBarAnimOffY > 0) {
            this.iTopBarAnimOffY -= this.acc4;
            if (this.iTopBarAnimOffY < 0) {
                this.iTopBarAnimOffY = 0;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean animationOutTopBar(long dt) {
        this.acc4 += this.iAnimStep;
        if (this.bOutAnimation && this.iTopBarAnimOffY < sprMenuIcons.getHeight()) {
            this.iTopBarAnimOffY += this.acc4;
            if (this.iTopBarAnimOffY > sprMenuIcons.getHeight()) {
                this.iTopBarAnimOffY = sprMenuIcons.getHeight();
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean animationInShopPrice(long dt) {
        this.acc2 += this.iAnimStep;
        if (this.bInAnimation && this.iShopPriceOff > 0) {
            this.iShopPriceOff -= this.acc2;
            if (this.iShopPriceOff < 0) {
                this.iShopPriceOff = 0;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean animationOutShopPrice(long dt) {
        this.acc2 += this.iAnimStep;
        if (this.bOutAnimation && this.iShopPriceOff < (MainCanvas.WIDTH >> 1) - sprMenuIcons.getWidth() - (sprMenuIcons.getWidth() >> 3)) {
            this.iShopPriceOff += this.acc2;
            if (this.iShopPriceOff > (MainCanvas.WIDTH >> 1) - sprMenuIcons.getWidth() - (sprMenuIcons.getWidth() >> 3)) {
                this.iShopPriceOff = (MainCanvas.WIDTH >> 1) - sprMenuIcons.getWidth() - (sprMenuIcons.getWidth() >> 3);
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean animationInShopItem(long dt) {
        this.acc += this.iAnimStep;
        if (this.bInAnimation && this.iShopItemOff > 0) {
            this.iShopItemOff -= this.acc;
            if (this.iShopItemOff < 0) {
                this.iShopItemOff = 0;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean animationOutShopItem(long dt) {
        this.acc += this.iAnimStep;
        if (this.bOutAnimation && this.iShopItemOff < (MainCanvas.WIDTH >> 1) + sprMenuIcons.getWidth()) {
            this.iShopItemOff += this.acc;
            if (this.iShopItemOff > (MainCanvas.WIDTH >> 1) + sprMenuIcons.getWidth()) {
                this.iShopItemOff = (MainCanvas.WIDTH >> 1) + sprMenuIcons.getWidth();
                return false;
            }
            return true;
        }
        return false;
    }

    private void updateShopError(long dt) {
        if (this.bPaintShopError) {
            this.iPaintCounter = (int)((long)this.iPaintCounter + dt);
            if (this.iPaintCounter >= 2000) {
                this.bPaintShopError = false;
                this.iPaintCounter = 0;
            }
        }
    }

    public void paint(Graphics g) {
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        g.setColor(0xFFFFFF);
        g.fillRect(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        block0 : switch (this.screen) {
            case 0: {
                switch (this.subScreen) {
                    case 2: {
                        this.paintLogoInlogic(g);
                        break block0;
                    }
                    case 3: {
                        this.paintLanguages(g);
                        break block0;
                    }
                    case 4: {
                        this.paintEnableMusic(g);
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                switch (this.subScreen) {
                    case 0: {
                        this.paintMainMenu(g);
                        break block0;
                    }
                    case 1: {
                        this.paintInstructions(g);
                        break block0;
                    }
                    case 5: {
                        this.paintShop(g);
                        break block0;
                    }
                    case 2: {
                        this.paintAbout(g);
                        break block0;
                    }
                    case 3: {
                        this.paintQuit(g);
                        break block0;
                    }
                    case 4: {
                        this.paintSelectGame(g);
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                switch (this.subScreen) {
                    case 0: {
                        this.game.paint(g);
                        break block0;
                    }
                    case 2: {
                        this.paintPause(g);
                        break block0;
                    }
                    case 4: {
                        this.paintQuitToMenu(g);
                        break block0;
                    }
                    case 3: {
                        this.paintReset(g);
                        break block0;
                    }
                    case 1: {
                        this.paintGameOver(g);
                        break block0;
                    }
                    case 5: {
                        this.paintTutorial(g);
                        break block0;
                    }
                }
                break;
            }
        }
        this.paintControls(g);
    }

    public void paintControls(Graphics g) {
        block0 : switch (this.screen) {
            case 0: {
                switch (this.subScreen) {
                    case 3: {
                        this.paintLeftButton(g, 0);
                        break block0;
                    }
                    case 4: {
                        this.paintLeftButton(g, 0);
                        this.paintRightButton(g, 1);
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                switch (this.subScreen) {
                    case 0: {
                        this.paintLeftButton(g, 0);
                        this.paintRightButton(g, 4);
                        break block0;
                    }
                    case 5: {
                        this.paintLeftButton(g, 0);
                        this.paintRightButton(g, 2);
                        break block0;
                    }
                    case 4: {
                        this.paintLeftButton(g, 0);
                        this.paintRightButton(g, 2);
                        break block0;
                    }
                    case 1: 
                    case 2: {
                        this.paintRightButton(g, 2);
                        break block0;
                    }
                    case 3: {
                        this.paintLeftButton(g, 0);
                        this.paintRightButton(g, 1);
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                switch (this.subScreen) {
                    case 2: {
                        this.paintLeftButton(g, 3);
                        this.paintRightButton(g, 2);
                        break block0;
                    }
                    case 4: {
                        this.paintLeftButton(g, 0);
                        this.paintRightButton(g, 1);
                        break block0;
                    }
                    case 3: {
                        this.paintLeftButton(g, 0);
                        this.paintRightButton(g, 1);
                        break block0;
                    }
                    case 1: {
                        this.paintLeftButton(g, 0);
                        this.paintRightButton(g, 3);
                        break block0;
                    }
                    case 5: {
                        this.paintLeftButton(g, 0);
                        break block0;
                    }
                }
            }
        }
    }

    public void paintLeftButton(Graphics g, int frame) {
        sprFkIcons.setFrame(frame);
        sprFkIcons.setPosition(0, MainCanvas.HEIGHT - sprFkIcons.getHeight() + this.iFkAnimOffY);
        sprFkIcons.paint(g);
    }

    public void paintLeftButtonWoAnim(Graphics g, int frame) {
        sprFkIcons.setFrame(frame);
        sprFkIcons.setPosition(0, MainCanvas.HEIGHT - sprFkIcons.getHeight());
        sprFkIcons.paint(g);
    }

    public void paintRightButton(Graphics g, int frame) {
        sprFkIcons.setFrame(frame);
        sprFkIcons.setPosition(MainCanvas.WIDTH - sprFkIcons.getWidth(), MainCanvas.HEIGHT - sprFkIcons.getHeight() + this.iFkAnimOffY);
        sprFkIcons.paint(g);
    }

    public void paintLogoInlogic(Graphics g) {
        g.drawImage(imgInlogic, (MainCanvas.WIDTH >> 1) - (imgInlogic.getWidth() >> 1), (MainCanvas.HEIGHT >> 1) - (imgInlogic.getHeight() >> 1), 20);
    }

    public void paintConfirmMessage(Graphics g) {
        this.paintBorders(g, true, true);
    }

    public void paintLanguages(Graphics g) {
        for (int i = 0; i < 5; ++i) {
            int pomShiftX = 0;
            if (i == this.iSelectedLanguage) {
                pomShiftX = this.iShiftX;
            }
            sprLanguage.setFrame(LANGUAGES[i]);
            sprLanguage.setPosition(this.rectLanguages[i].x + pomShiftX, this.rectLanguages[i].y);
            sprLanguage.paint(g);
        }
    }

    public void paintEnableMusic(Graphics g) {
        this.paintBorders(g, true, true);
        this.paintTextInRectangle(g, this.rectTitleCenter);
    }

    public void paintBorders(Graphics g, boolean top, boolean bot) {
        sprBorder.setFrame(0);
        if (top) {
            sprBorder.setTransform(0);
            sprBorder.setPosition((MainCanvas.WIDTH >> 1) - (sprBorder.getWidth() >> 1), sprMenuIcons.getHeight());
            sprBorder.paint(g);
        }
        if (bot) {
            sprBorder.setTransform(3);
            sprBorder.setPosition((MainCanvas.WIDTH >> 1) - (sprBorder.getWidth() >> 1), MainCanvas.HEIGHT - sprMenuIcons.getHeight());
            sprBorder.paint(g);
        }
    }

    public void paintShop(Graphics g) {
        this.paintTopBar(g, 9, this.strTextBody);
        this.paintBorders(g, false, true);
        for (int i = 0; i < 4; ++i) {
            if (i == this.iSelectedMenuItem) {
                this.paintShopItem(g, i, this.rectShopItems[i], this.shopItemsFrames[i], true);
                continue;
            }
            this.paintShopItem(g, i, this.rectShopItems[i], this.shopItemsFrames[i], false);
        }
        int strW = this.fontMain.stringWidth((" " + Profile.iTotalScore).toCharArray());
        sprGameIcons.setFrame(2);
        sprGameIcons.setPosition((MainCanvas.WIDTH >> 1) - sprGameIcons.getWidth() - (strW >> 1), MainCanvas.HEIGHT - (sprFkIcons.getHeight() >> 1) - (sprGameIcons.getHeight() >> 1) + this.iFkAnimOffY);
        sprGameIcons.paint(g);
        this.fontMain.drawString(g, ("" + Profile.iTotalScore).toCharArray(), MainCanvas.WIDTH >> 1, MainCanvas.HEIGHT - (sprFkIcons.getHeight() >> 1) + this.iFkAnimOffY, 3);
        if (this.bPaintShopError) {
            this.fontSmall.drawString(g, Resources.resTexts[0].getHashedString(45).toCharArray(), MainCanvas.WIDTH >> 1, this.rectShopItems[0].y - this.fontSmall.getHeight(), 17);
        }
    }

    public void paintGameOver(Graphics g) {
        int frame = 0;
        if (this.game.gameType == 0) {
            frame = 7;
        } else if (this.game.gameType == 1) {
            frame = 6;
        }
        String score = "" + this.game.iScore;
        int off = sprFkIcons.getHeight() >> 2;
        if (this.goStep > 0) {
            this.paintOverTextLine(g, (MainCanvas.HEIGHT >> 1) - (this.fontMain.getHeight() << 1) - off, "CUPS", score);
        }
        if (this.goStep > 1) {
            this.paintOverTextLine(g, MainCanvas.HEIGHT >> 1, Resources.resTexts[0].getHashedString(49), "" + Profile.iTotalScore);
        }
        if (this.goStep > 2) {
            this.fontMain.drawString(g, Resources.resTexts[0].getHashedString(30).toCharArray(), MainCanvas.WIDTH >> 1, (MainCanvas.HEIGHT >> 1) + (this.fontMain.getHeight() << 1) + (off << 1), 17);
        }
        this.paintTopBar(g, frame, Resources.resTexts[0].getHashedString(21));
        this.paintBorders(g, false, true);
    }

    private void paintOverTextLine(Graphics g, int startY, String text, String score) {
        this.fontMain.drawString(g, text.toCharArray(), MainCanvas.WIDTH >> 1, startY, 17);
        this.fontMain.drawString(g, score.toCharArray(), MainCanvas.WIDTH >> 1, startY + this.fontMain.getHeight(), 17);
    }

    public void paintShopItem(Graphics g, int type, Rectangle bounds, int frame, boolean bselected) {
        int offX = 0;
        if (bselected && !this.bInAnimation && !this.bOutAnimation) {
            offX = this.iShiftX;
        }
        sprMenuIcons.setFrame(frame);
        sprMenuIcons.setPosition((MainCanvas.WIDTH >> 1) - sprMenuIcons.getWidth() + offX + this.iShopItemOff, bounds.y);
        sprMenuIcons.paint(g);
        sprGameIcons.setFrame(2);
        sprGameIcons.setPosition(this.iShopItemCupX - this.iShopPriceOff, bounds.getCenterY() - (sprGameIcons.getHeight() >> 1));
        sprGameIcons.paint(g);
        int iNumberOff = 0;
        iNumberOff = MainCanvas.HEIGHT < 320 ? 0 : this.fontSmall.getHeight() >> 1;
        switch (type) {
            case 0: {
                this.fontSmall.drawString(g, ("" + Bonus.getInstance().getValue(1)).toCharArray(), (MainCanvas.WIDTH >> 1) + offX + this.iShopItemOff, bounds.y + iNumberOff, 24);
                this.fontMain.drawString(g, "500".toCharArray(), (MainCanvas.WIDTH >> 1) - sprMenuIcons.getWidth() - (sprMenuIcons.getWidth() >> 3) - this.iShopPriceOff, bounds.getCenterY(), 10);
                this.fontSmall.drawString(g, this.strTextMenu[0].toCharArray(), (MainCanvas.WIDTH >> 1) + this.iShopItemOff, bounds.getCenterY(), 6);
                break;
            }
            case 1: {
                this.fontSmall.drawString(g, ("" + Bonus.getInstance().getValue(0)).toCharArray(), (MainCanvas.WIDTH >> 1) + offX + this.iShopItemOff, bounds.y + iNumberOff, 24);
                this.fontMain.drawString(g, "500".toCharArray(), (MainCanvas.WIDTH >> 1) - sprMenuIcons.getWidth() - (sprMenuIcons.getWidth() >> 3) - this.iShopPriceOff, bounds.getCenterY(), 10);
                this.fontSmall.drawString(g, this.strTextMenu[1].toCharArray(), (MainCanvas.WIDTH >> 1) + this.iShopItemOff, bounds.getCenterY(), 6);
                break;
            }
            case 2: {
                this.fontSmall.drawString(g, ("" + Bonus.getInstance().getValue(2)).toCharArray(), (MainCanvas.WIDTH >> 1) + offX + this.iShopItemOff, bounds.y + iNumberOff, 24);
                this.fontMain.drawString(g, "250".toCharArray(), (MainCanvas.WIDTH >> 1) - sprMenuIcons.getWidth() - (sprMenuIcons.getWidth() >> 3) - this.iShopPriceOff, bounds.getCenterY(), 10);
                this.fontSmall.drawString(g, this.strTextMenu[2].toCharArray(), (MainCanvas.WIDTH >> 1) + this.iShopItemOff, bounds.getCenterY(), 6);
                break;
            }
            case 3: {
                this.fontSmall.drawString(g, ("" + Bonus.getInstance().getValue(3)).toCharArray(), (MainCanvas.WIDTH >> 1) + offX + this.iShopItemOff, bounds.y + iNumberOff, 24);
                this.fontMain.drawString(g, "1000".toCharArray(), (MainCanvas.WIDTH >> 1) - sprMenuIcons.getWidth() - (sprMenuIcons.getWidth() >> 3) - this.iShopPriceOff, bounds.getCenterY(), 10);
                this.fontSmall.drawString(g, this.strTextMenu[3].toCharArray(), (MainCanvas.WIDTH >> 1) + this.iShopItemOff, bounds.getCenterY(), 6);
                break;
            }
        }
    }

    public void paintTitle(Graphics g) {
        g.drawImage(imgTitle, (MainCanvas.WIDTH >> 1) - (imgTitle.getWidth() >> 1), 0 - this.iMenuAnimLogoOffY, 20);
    }

    public void paintSelectGame(Graphics g) {
        for (int i = 0; i < 4; ++i) {
            if (i == this.iSelectedMenuItem) {
                this.paintMenuButton(g, this.rectSelectGameItems[i], this.strTextMenu[i], this.selectGameItemsFrames[i], i % 2, true);
                continue;
            }
            this.paintMenuButton(g, this.rectSelectGameItems[i], this.strTextMenu[i], this.selectGameItemsFrames[i], i % 2, false);
        }
    }

    public void paintPause(Graphics g) {
        for (int i = 0; i < this.ID_PAUSE_ITEMS_TOTAL; ++i) {
            if (i == this.iSelectedMenuItem) {
                this.paintMenuButton(g, this.rectPauseItems[i], this.strTextMenu[i], this.pauseItemsFrames[i], i % 2, true);
                continue;
            }
            this.paintMenuButton(g, this.rectPauseItems[i], this.strTextMenu[i], this.pauseItemsFrames[i], i % 2, false);
        }
    }

    public void paintMainMenu(Graphics g) {
        this.paintTitle(g);
        for (int i = 0; i < this.iMenuItemsTotal; ++i) {
            if (i == this.iSelectedMenuItem) {
                this.paintMenuButton(g, this.rectMenuItems[i], this.strTextMenu[i], this.menuItemsFrames[i], i % 2, true);
                continue;
            }
            this.paintMenuButton(g, this.rectMenuItems[i], this.strTextMenu[i], this.menuItemsFrames[i], i % 2, false);
        }
    }

    private void paintMenuButton(Graphics g, Rectangle bounds, String text, int iconFrame, int odd, boolean selected) {
        int offsetX = 0;
        int animOff = 0;
        if (odd == 0) {
            offsetX = sprFkIcons.getWidth();
        }
        if (selected && !this.bInAnimation && !this.bOutAnimation) {
            offsetX += this.iShiftX;
        }
        if (this.bInAnimation || this.bOutAnimation) {
            animOff = odd == 0 ? (animOff += this.iMenuAnimOffX) : (animOff -= this.iMenuAnimOffX);
        }
        sprBorder.setFrame(0);
        sprBorder.setTransform(0);
        sprBorder.setPosition((MainCanvas.WIDTH >> 1) - (sprBorder.getWidth() >> 1) + animOff, bounds.getBottom() - sprBorder.getHeight());
        sprBorder.paint(g);
        sprMenuIcons.setFrame(iconFrame);
        sprMenuIcons.setPosition((MainCanvas.WIDTH >> 1) - (sprBorder.getWidth() >> 1) - (sprMenuIcons.getWidth() >> 2) + offsetX + animOff, bounds.y);
        sprMenuIcons.paint(g);
        this.fontMain.drawString(g, text.toCharArray(), (MainCanvas.WIDTH >> 1) - (sprBorder.getWidth() >> 1) - (sprMenuIcons.getWidth() >> 2) + sprMenuIcons.getWidth() + offsetX + animOff, bounds.getCenterY(), 6);
    }

    public void paintInstructions(Graphics g) {
        this.paintBorders(g, false, true);
        this.paintTopBar(g, 1, this.strTextBody);
        if (!this.bLoading) {
            this.paintInstructionsText(g);
        }
    }

    public void updateInstructions() {
        if ((Keys.isActionPressed(1) || Keys.isKeyPressed(50)) && this.iInstructionsShiftY > 0) {
            this.iInstructionsShiftY -= this.fontMain.getHeight();
            if (this.iInstructionsShiftY < 0) {
                this.iInstructionsShiftY = 0;
            }
        }
        if ((Keys.isActionPressed(2) || Keys.isKeyPressed(56)) && this.iInstructionsShiftY < this.iInstructionsMaxShiftY) {
            this.iInstructionsShiftY += this.fontMain.getHeight();
            if (this.iInstructionsShiftY > this.iInstructionsMaxShiftY) {
                this.iInstructionsShiftY = this.iInstructionsMaxShiftY;
            }
        }
    }

    public boolean isPressedInstructionsText(int x, int y) {
        return x > (MainCanvas.WIDTH >> 1) - (this.iInstructionsWidth >> 1) && x < (MainCanvas.WIDTH >> 1) + (this.iInstructionsWidth >> 1) && y > this.iInstructionsCenterY - (this.iInstructionsHeight >> 1) && y < this.iInstructionsCenterY + (this.iInstructionsHeight >> 1);
    }

    public void paintInstructionsText(Graphics g) {
        int iTextYUp = this.iInstructionsCenterY - (this.iInstructionsHeight >> 1);
        int iTextYDown = this.iInstructionsCenterY + (this.iInstructionsHeight >> 1);
        if (this.iInstructionsShiftY > 0) {
            sprArrows.setFrame(0);
            sprArrows.setPosition((MainCanvas.WIDTH >> 1) - (sprArrows.getWidth() >> 1), iTextYUp - sprArrows.getHeight());
            sprArrows.paint(g);
        }
        if (this.iInstructionsShiftY < this.iInstructionsMaxShiftY) {
            sprArrows.setFrame(1);
            sprArrows.setPosition((MainCanvas.WIDTH >> 1) - (sprArrows.getWidth() >> 1), iTextYDown);
            sprArrows.paint(g);
        }
        g.setClip(0, iTextYUp, MainCanvas.WIDTH, iTextYDown - iTextYUp);
        int lineY = 0;
        for (int i = 0; i < this.iTextLines; ++i) {
            lineY = iTextYUp + (i + 1) * this.fontMain.getHeight() - this.iInstructionsShiftY;
            if (lineY <= this.iInstructionsCenterY - (this.iInstructionsHeight >> 1) || lineY + this.fontMain.getHeight() >= this.iInstructionsCenterY + (this.iInstructionsHeight >> 1)) continue;
            this.fontMain.drawString(g, this.prepText.getText(i).toCharArray(), MainCanvas.WIDTH >> 1, lineY, 17);
        }
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
    }

    public void paintAbout(Graphics g) {
        this.paintBorders(g, false, true);
        this.paintTopBar(g, 2, this.strTextBody);
        int pomHeight = imgInlogic.getHeight() + (this.fontMain.getHeight() << 1) + (this.fontMain.getHeight() >> 1);
        int pomY = (MainCanvas.HEIGHT - (sprMenuIcons.getHeight() + sprFkIcons.getHeight()) >> 1) + sprMenuIcons.getHeight();
        g.drawImage(imgInlogic, (MainCanvas.WIDTH >> 1) - (imgInlogic.getWidth() >> 1), pomY - (pomHeight >> 1), 20);
        this.fontMain.drawString(g, this.strTextPom[0].toCharArray(), (MainCanvas.WIDTH >> 1) - (this.fontMain.stringWidth(this.strTextPom[0].toCharArray()) >> 1), (pomY += imgInlogic.getHeight() + (this.fontMain.getHeight() >> 1)) - (pomHeight >> 1), 20);
        this.fontSmall.drawString(g, this.strTextPom[1].toCharArray(), (MainCanvas.WIDTH >> 1) - (this.fontSmall.stringWidth(this.strTextPom[1].toCharArray()) >> 1), (pomY += this.fontMain.getHeight()) - (pomHeight >> 1), 20);
    }

    public void paintTopBar(Graphics g, int icon, String text) {
        sprBorder.setFrame(0);
        sprBorder.setTransform(0);
        sprBorder.setPosition((MainCanvas.WIDTH >> 1) - (sprBorder.getWidth() >> 1), this.rectTopBar.getBottom() - sprBorder.getHeight() - this.iTopBarAnimOffY);
        sprBorder.paint(g);
        sprMenuIcons.setFrame(icon);
        sprMenuIcons.setPosition(this.rectTopBar.x, this.rectTopBar.y - this.iTopBarAnimOffY);
        sprMenuIcons.paint(g);
        this.fontMain.drawString(g, text.toCharArray(), this.rectTopBar.x + sprMenuIcons.getWidth(), this.rectTopBar.getCenterY() - this.iTopBarAnimOffY, 6);
    }

    public void paintTopBarWoAnim(Graphics g, int icon, String text) {
        sprBorder.setFrame(0);
        sprBorder.setTransform(0);
        sprBorder.setPosition((MainCanvas.WIDTH >> 1) - (sprBorder.getWidth() >> 1), this.rectTopBar.getBottom() - sprBorder.getHeight());
        sprBorder.paint(g);
        sprMenuIcons.setFrame(icon);
        sprMenuIcons.setPosition(this.rectTopBar.x, this.rectTopBar.y);
        sprMenuIcons.paint(g);
        this.fontMain.drawString(g, text.toCharArray(), this.rectTopBar.x + sprMenuIcons.getWidth(), this.rectTopBar.getCenterY(), 6);
    }

    public void paintQuit(Graphics g) {
        this.paintTopBar(g, 11, Resources.resTexts[0].getHashedString(50));
        this.paintBorders(g, false, true);
        this.paintTextInRectangle(g, this.rectTitleCenter);
    }

    public void paintReset(Graphics g) {
        this.paintTopBar(g, 3, Resources.resTexts[0].getHashedString(51));
        this.paintBorders(g, false, true);
        this.paintTextInRectangle(g, this.rectTitleCenter);
    }

    public void paintTutorial(Graphics g) {
        this.paintTopBar(g, 1, Resources.resTexts[0].getHashedString(55));
        this.paintBorders(g, false, true);
        this.paintTextInRectangle(g, this.rectTitleCenter);
    }

    public void paintQuitToMenu(Graphics g) {
        this.paintTopBar(g, 11, Resources.resTexts[0].getHashedString(14));
        this.paintBorders(g, false, true);
        this.paintTextInRectangle(g, this.rectTitleCenter);
    }

    public void paintTextInRectangle(Graphics g, Rectangle rect) {
        int iCenterY = MainCanvas.HEIGHT >> 1;
        int textHeight = this.fontMain.getHeight() * this.iTextLines;
        int pomY = iCenterY - (textHeight >> 1) - 1;
        for (int i = 0; i < this.iTextLines; ++i) {
            this.fontMain.drawString(g, this.prepText.getText(i).toCharArray(), rect.getCenterX(), pomY, 17);
            pomY += this.fontMain.getHeight();
        }
    }

    public void setTitleCenter(String s) {
        this.rectTitleCenter.height = this.fontMain.getHeight() + (this.fontMain.getHeight() >> 1);
        int textMaxWidth = this.rectTitleCenter.width - (this.rectTitleCenter.width >> 3);
        this.prepText = new PreparedText(this.fontMain);
        this.prepText.prepareText(s, textMaxWidth);
        this.iTextLines = this.prepText.getTextHeight() / this.fontMain.getHeight();
        if (this.iTextLines > 1) {
            this.rectTitleCenter.height += (this.iTextLines - 1) * this.fontMain.getHeight() + 1;
        }
    }

    public void keyPressed(int keyCode) {
    }

    public void soundOn() {
        Profile.bMusic = true;
        MainCanvas.soundManager.SetSoundOn(true);
        MainCanvas.soundManager.SetMusicOn(true);
    }

    public void soundOff() {
        Profile.bMusic = false;
        MainCanvas.soundManager.SetSoundOn(false);
        MainCanvas.soundManager.SetMusicOn(false);
    }

    public void changeLanguage(int iType) {
        switch (iType) {
            case 0: {
                if (this.iSelectedLanguage > 1) {
                    this.iSelectedLanguage -= 2;
                    break;
                }
                this.iSelectedLanguage = 4;
                break;
            }
            case 1: {
                if (this.iSelectedLanguage == 3) {
                    ++this.iSelectedLanguage;
                    break;
                }
                if (this.iSelectedLanguage == 4) {
                    this.iSelectedLanguage = 0;
                    break;
                }
                this.iSelectedLanguage += 2;
                break;
            }
            case 2: {
                if (this.iSelectedLanguage > 0) {
                    --this.iSelectedLanguage;
                    break;
                }
                this.iSelectedLanguage = 4;
                break;
            }
            case 3: {
                if (this.iSelectedLanguage < 4) {
                    ++this.iSelectedLanguage;
                    break;
                }
                this.iSelectedLanguage = 0;
                break;
            }
        }
    }

    public void changeSound() {
        Profile.bMusic = !Profile.bMusic;
        Profile.save();
        if (Profile.bMusic) {
            this.soundOn();
            this.playMusic(Sounds.MUSIC_MENU, -1);
        } else {
            this.soundOff();
        }
        this.setTexts();
    }

    public void changeSelectedMenuItem(int iShift) {
        int pom = 0;
        switch (this.screen) {
            case 1: {
                if (this.subScreen == 0) {
                    pom = this.iMenuItemsTotal;
                    break;
                }
                if (this.subScreen == 4) {
                    pom = 4;
                    break;
                }
                if (this.subScreen != 5) break;
                pom = 4;
                break;
            }
            case 2: {
                pom = this.ID_PAUSE_ITEMS_TOTAL;
                break;
            }
        }
        this.iSelectedMenuItem = iShift > 0 ? (this.iSelectedMenuItem + 1) % pom : (this.iSelectedMenuItem > 0 ? --this.iSelectedMenuItem : pom - 1);
    }

    public void keyReleased(int keyCode) {
        if (this.bInAnimation || this.bOutAnimation) {
            return;
        }
        block0 : switch (this.screen) {
            case 0: {
                switch (this.subScreen) {
                    case 2: {
                        if (this.delay <= 100) break block0;
                        this.delay = 100;
                        break block0;
                    }
                    case 3: {
                        if (Keys.isActionPressed(1) || Keys.isKeyPressed(50)) {
                            this.changeLanguage(0);
                            return;
                        }
                        if (Keys.isActionPressed(2) || Keys.isKeyPressed(56)) {
                            this.changeLanguage(1);
                            return;
                        }
                        if (Keys.isActionPressed(3) || Keys.isKeyPressed(52)) {
                            this.changeLanguage(2);
                            return;
                        }
                        if (Keys.isActionPressed(4) || Keys.isKeyPressed(54)) {
                            this.changeLanguage(3);
                            return;
                        }
                        if (!Keys.isFKLeftCode(keyCode) && !Keys.isActionPressed(5) && !Keys.isKeyPressed(53)) break block0;
                        this.nextScreen(0, 4, 3);
                        return;
                    }
                    case 4: {
                        if (Keys.isFKLeftCode(keyCode)) {
                            this.soundOn();
                            this.init();
                            return;
                        }
                        if (!Keys.isFKRightCode(keyCode)) break block0;
                        this.soundOff();
                        this.init();
                        return;
                    }
                }
                break;
            }
            case 1: {
                switch (this.subScreen) {
                    case 0: {
                        if (Keys.isActionPressed(2) || Keys.isKeyPressed(56)) {
                            this.changeSelectedMenuItem(1);
                            return;
                        }
                        if (Keys.isActionPressed(1) || Keys.isKeyPressed(50)) {
                            this.changeSelectedMenuItem(-1);
                            return;
                        }
                        if (Keys.isFKRightCode(keyCode)) {
                            this.startAnimation(false, 1, 3, 0, false, 0);
                            return;
                        }
                        if (!Keys.isFKLeftCode(keyCode) && !Keys.isActionPressed(5) && !Keys.isKeyPressed(53)) break block0;
                        switch (this.iSelectedMenuItem) {
                            case 0: {
                                this.startAnimation(false, 1, 4, 0, false, 0);
                                break;
                            }
                            case 1: {
                                this.startAnimation(false, 1, 1, 0, false, 0);
                                break;
                            }
                            case 2: {
                                this.startAnimation(false, 1, 2, 0, false, 0);
                                break;
                            }
                            case 3: {
                                this.changeSound();
                                break;
                            }
                        }
                        return;
                    }
                    case 1: {
                        if (!Keys.isFKRightCode(keyCode)) break block0;
                        if (this.prevScreen == 2) {
                            this.startAnimation(false, 2, 2, 1, false, 0);
                        } else {
                            this.startAnimation(false, 1, 0, 1, false, 0);
                        }
                        return;
                    }
                    case 2: {
                        if (!Keys.isFKRightCode(keyCode)) break block0;
                        this.startAnimation(false, 1, 0, 2, false, 0);
                        return;
                    }
                    case 3: {
                        if (Keys.isFKLeftCode(keyCode)) {
                            this.quit();
                            return;
                        }
                        if (!Keys.isFKRightCode(keyCode)) break block0;
                        this.startAnimation(false, 1, 0, 3, false, 0);
                        return;
                    }
                    case 4: {
                        if (Keys.isActionPressed(2) || Keys.isKeyPressed(56)) {
                            this.changeSelectedMenuItem(1);
                            return;
                        }
                        if (Keys.isActionPressed(1) || Keys.isKeyPressed(50)) {
                            this.changeSelectedMenuItem(-1);
                            return;
                        }
                        if (Keys.isFKRightCode(keyCode)) {
                            this.startAnimation(false, 1, 0, 4, false, 0);
                            return;
                        }
                        if (!Keys.isFKLeftCode(keyCode) && !Keys.isActionPressed(5) && !Keys.isKeyPressed(53)) break block0;
                        switch (this.iSelectedMenuItem) {
                            case 0: {
                                if (bTutorialMoves) {
                                    bTutorialMoves = false;
                                    this.startAnimation(false, 2, 5, 4, false, 0);
                                    break block0;
                                }
                                this.startAnimation(false, 2, 0, 4, true, 0);
                                break block0;
                            }
                            case 1: {
                                if (bTutorialTime) {
                                    bTutorialTime = false;
                                    this.startAnimation(false, 2, 5, 4, false, 1);
                                    break block0;
                                }
                                this.startAnimation(false, 2, 0, 4, true, 1);
                                break block0;
                            }
                            case 2: {
                                if (bTutorialEndless) {
                                    bTutorialEndless = false;
                                    this.startAnimation(false, 2, 5, 4, false, 2);
                                    break block0;
                                }
                                this.startAnimation(false, 2, 0, 4, true, 2);
                                break block0;
                            }
                            case 3: {
                                this.startAnimation(false, 1, 5, 4, false, 0);
                                break block0;
                            }
                        }
                        break block0;
                    }
                    case 5: {
                        if (Keys.isActionPressed(2) || Keys.isKeyPressed(56)) {
                            this.changeSelectedMenuItem(1);
                            return;
                        }
                        if (Keys.isActionPressed(1) || Keys.isKeyPressed(50)) {
                            this.changeSelectedMenuItem(-1);
                            return;
                        }
                        if (Keys.isFKLeftCode(keyCode) || Keys.isActionPressed(5) || Keys.isKeyPressed(53)) {
                            switch (this.iSelectedMenuItem) {
                                case 0: {
                                    if (Profile.iTotalScore < Integer.parseInt("500")) {
                                        this.bPaintShopError = true;
                                        break;
                                    }
                                    Bonus.getInstance().addBonus(1, 5);
                                    this.game.changeTotalScoreAndSave(-Integer.parseInt("500"));
                                    break;
                                }
                                case 1: {
                                    if (Profile.iTotalScore < Integer.parseInt("500")) {
                                        this.bPaintShopError = true;
                                        break;
                                    }
                                    Bonus.getInstance().addBonus(0, 5);
                                    this.game.changeTotalScoreAndSave(-Integer.parseInt("500"));
                                    break;
                                }
                                case 2: {
                                    if (Profile.iTotalScore < Integer.parseInt("250")) {
                                        this.bPaintShopError = true;
                                        break;
                                    }
                                    Bonus.getInstance().addBonus(2, 5);
                                    this.game.changeTotalScoreAndSave(-Integer.parseInt("250"));
                                    break;
                                }
                                case 3: {
                                    if (Profile.iTotalScore < Integer.parseInt("1000")) {
                                        this.bPaintShopError = true;
                                        break;
                                    }
                                    Bonus.getInstance().addBonus(3, 5);
                                    this.game.changeTotalScoreAndSave(-Integer.parseInt("1000"));
                                    break;
                                }
                            }
                            return;
                        }
                        if (!Keys.isFKRightCode(keyCode)) break block0;
                        if (this.prevScreen == 2) {
                            this.startAnimation(false, 2, 2, 5, false, 0);
                        } else if (this.prevScreen == 0) {
                            this.startAnimation(false, 2, 2, 5, false, 0);
                        } else {
                            this.startAnimation(false, 1, 4, 5, false, 0);
                        }
                        return;
                    }
                }
                break;
            }
            case 2: {
                switch (this.subScreen) {
                    case 0: {
                        this.game.keyReleased(keyCode);
                        if (!Keys.isFKRightCode(keyCode)) break block0;
                        this.nextScreen(2, 2, 0);
                        return;
                    }
                    case 2: {
                        if (Keys.isActionPressed(2) || Keys.isKeyPressed(56)) {
                            this.changeSelectedMenuItem(1);
                            return;
                        }
                        if (Keys.isActionPressed(1) || Keys.isKeyPressed(50)) {
                            this.changeSelectedMenuItem(-1);
                            return;
                        }
                        if (Keys.isActionPressed(5) || Keys.isKeyPressed(53)) {
                            switch (this.iSelectedMenuItem) {
                                case 0: {
                                    this.startAnimation(false, 2, 3, 2, false, 0);
                                    break;
                                }
                                case 1: {
                                    this.startAnimation(false, 1, 1, 2, false, 0);
                                    break;
                                }
                                case 2: {
                                    this.changeSound();
                                    break;
                                }
                                case 3: {
                                    this.startAnimation(false, 1, 5, 2, false, 0);
                                    break;
                                }
                            }
                            return;
                        }
                        if (Keys.isFKLeftCode(keyCode)) {
                            this.startAnimation(false, 2, 4, 2, false, 0);
                            return;
                        }
                        if (!Keys.isFKRightCode(keyCode)) break block0;
                        this.startAnimation(false, 2, 0, 2, false, 0);
                        return;
                    }
                    case 3: {
                        if (Keys.isFKLeftCode(keyCode)) {
                            if (this.game.gameType == 2) {
                                this.game.changeTotalScoreAndSave(this.game.iScore);
                            }
                            this.startAnimation(false, 2, 0, 3, true, this.game.gameType);
                            return;
                        }
                        if (!Keys.isFKRightCode(keyCode)) break block0;
                        this.startAnimation(false, 2, 2, 3, false, 0);
                        return;
                    }
                    case 4: {
                        if (Keys.isFKLeftCode(keyCode)) {
                            if (this.game.gameType == 2) {
                                this.game.changeTotalScoreAndSave(this.game.iScore);
                            }
                            this.startAnimation(false, 1, 0, 4, false, 0);
                            return;
                        }
                        if (!Keys.isFKRightCode(keyCode)) break block0;
                        this.startAnimation(false, 2, 2, 4, false, 0);
                        return;
                    }
                    case 1: {
                        if (Keys.isFKLeftCode(keyCode)) {
                            this.startAnimation(false, 2, 0, 1, true, this.game.gameType);
                            return;
                        }
                        if (!Keys.isFKRightCode(keyCode)) break block0;
                        this.startAnimation(false, 1, 0, 1, false, 0);
                        return;
                    }
                    case 5: {
                        if (!Keys.isFKLeftCode(keyCode)) break block0;
                        this.startAnimation(false, 2, 0, 5, true, this.aGt);
                        return;
                    }
                }
                break;
            }
        }
    }

    public void pointerPressed(int x, int y) {
        if (this.screen == 1 && this.subScreen == 1) {
            if (this.isPressedInstructionsText(x, y)) {
                this.bDragInstructions = true;
            }
        } else if (this.screen == 2 && this.subScreen == 0) {
            this.game.pointerPressed(x, y);
        }
    }

    public void quit() {
        X.quitApp();
    }

    public boolean isLeftButtonPressed(int x, int y) {
        return x <= sprFkIcons.getWidth() && y >= MainCanvas.HEIGHT - sprFkIcons.getHeight();
    }

    public boolean isRightButtonPressed(int x, int y) {
        return x >= MainCanvas.WIDTH - sprFkIcons.getWidth() && y >= MainCanvas.HEIGHT - sprFkIcons.getHeight();
    }

    public boolean isMenuPausePressed(int x, int y) {
        return x >= MainCanvas.WIDTH - imgPause.getWidth() && y >= MainCanvas.HEIGHT - imgPause.getHeight();
    }

    public void pointerDragged(int x, int y) {
        if (this.screen == 1 && this.subScreen == 1) {
            if (this.bDragInstructions) {
                if (!this.isPressedInstructionsText(x, y)) {
                    this.bDragInstructions = false;
                }
                this.iTextShiftY += MainCanvas.lastPointerPressedY - y;
                MainCanvas.lastPointerPressedY = y;
            }
        } else if (this.screen == 2 && this.subScreen == 0) {
            this.game.pointerDragged(x, y);
        }
    }

    public void pointerReleased(int x, int y) {
        if (this.bInAnimation || this.bOutAnimation) {
            return;
        }
        if ((this.screen == 1 && this.subScreen == 1 || this.screen == 2 || this.screen == 2 && this.subScreen == 0 && this.bStart) && this.bDragInstructions) {
            this.bDragInstructions = false;
        }
        block0 : switch (this.screen) {
            case 0: {
                switch (this.subScreen) {
                    case 2: {
                        if (this.delay <= 100) break;
                        this.delay = 100;
                        break;
                    }
                    case 3: {
                        for (int i = 0; i < 5; ++i) {
                            if (!this.rectLanguages[i].contains(x, y)) continue;
                            this.iSelectedLanguage = i;
                            this.nextScreen(0, 4, 3);
                            return;
                        }
                        break block0;
                    }
                    case 4: {
                        if (this.isLeftButtonPressed(x, y)) {
                            this.soundOn();
                            this.init();
                            return;
                        }
                        if (!this.isRightButtonPressed(x, y)) break;
                        this.soundOff();
                        this.init();
                        return;
                    }
                }
                break;
            }
            case 1: {
                switch (this.subScreen) {
                    case 0: {
                        if (this.isRightButtonPressed(x, y)) {
                            this.startAnimation(false, 1, 3, 0, false, 0);
                            return;
                        }
                        for (int i = 0; i < this.iMenuItemsTotal; ++i) {
                            if (!this.rectMenuItems[i].contains(x, y)) continue;
                            this.iSelectedMenuItem = i;
                            switch (this.iSelectedMenuItem) {
                                case 0: {
                                    this.startAnimation(false, 1, 4, 0, false, 0);
                                    break;
                                }
                                case 1: {
                                    this.startAnimation(false, 1, 1, 0, false, 0);
                                    break;
                                }
                                case 2: {
                                    this.startAnimation(false, 1, 2, 0, false, 0);
                                    break;
                                }
                                case 3: {
                                    this.changeSound();
                                    break;
                                }
                            }
                            return;
                        }
                        break block0;
                    }
                    case 1: {
                        if (!this.isRightButtonPressed(x, y)) break;
                        if (this.prevScreen == 2) {
                            this.startAnimation(false, 2, 2, 1, false, 0);
                        } else {
                            this.startAnimation(false, 1, 0, 1, false, 0);
                        }
                        return;
                    }
                    case 2: {
                        if (!this.isRightButtonPressed(x, y)) break;
                        this.startAnimation(false, 1, 0, 2, false, 0);
                        return;
                    }
                    case 3: {
                        if (this.isLeftButtonPressed(x, y)) {
                            this.quit();
                            return;
                        }
                        if (!this.isRightButtonPressed(x, y)) break;
                        this.startAnimation(false, 1, 0, 3, false, 0);
                        return;
                    }
                    case 5: {
                        if (this.isRightButtonPressed(x, y)) {
                            if (this.prevScreen == 2) {
                                this.startAnimation(false, 2, 2, 5, false, 0);
                            } else if (this.prevScreen == 0) {
                                this.startAnimation(false, 2, 2, 5, false, 0);
                            } else {
                                this.startAnimation(false, 1, 4, 5, false, 0);
                            }
                            return;
                        }
                        block44: for (int i = 0; i < 4; ++i) {
                            if (!this.rectShopItems[i].contains(x, y)) continue;
                            this.iSelectedMenuItem = i;
                            switch (this.iSelectedMenuItem) {
                                case 0: {
                                    if (Profile.iTotalScore < Integer.parseInt("500")) {
                                        this.bPaintShopError = true;
                                        continue block44;
                                    }
                                    Bonus.getInstance().addBonus(1, 5);
                                    this.game.changeTotalScoreAndSave(-Integer.parseInt("500"));
                                    continue block44;
                                }
                                case 1: {
                                    if (Profile.iTotalScore < Integer.parseInt("500")) {
                                        this.bPaintShopError = true;
                                        continue block44;
                                    }
                                    Bonus.getInstance().addBonus(0, 5);
                                    this.game.changeTotalScoreAndSave(-Integer.parseInt("500"));
                                    continue block44;
                                }
                                case 2: {
                                    if (Profile.iTotalScore < Integer.parseInt("250")) {
                                        this.bPaintShopError = true;
                                        continue block44;
                                    }
                                    Bonus.getInstance().addBonus(2, 5);
                                    this.game.changeTotalScoreAndSave(-Integer.parseInt("250"));
                                    continue block44;
                                }
                                case 3: {
                                    if (Profile.iTotalScore < Integer.parseInt("1000")) {
                                        this.bPaintShopError = true;
                                        continue block44;
                                    }
                                    Bonus.getInstance().addBonus(3, 5);
                                    this.game.changeTotalScoreAndSave(-Integer.parseInt("1000"));
                                    continue block44;
                                }
                            }
                        }
                        break block0;
                    }
                    case 4: {
                        if (this.isRightButtonPressed(x, y)) {
                            this.startAnimation(false, 1, 0, 4, false, 0);
                            return;
                        }
                        for (int i = 0; i < 4; ++i) {
                            if (!this.rectSelectGameItems[i].contains(x, y)) continue;
                            this.iSelectedMenuItem = i;
                            switch (this.iSelectedMenuItem) {
                                case 0: {
                                    if (bTutorialMoves) {
                                        bTutorialMoves = false;
                                        this.startAnimation(false, 2, 5, 4, false, 0);
                                        break;
                                    }
                                    this.startAnimation(false, 2, 0, 4, true, 0);
                                    break;
                                }
                                case 1: {
                                    if (bTutorialTime) {
                                        bTutorialTime = false;
                                        this.startAnimation(false, 2, 5, 4, false, 1);
                                        break;
                                    }
                                    this.startAnimation(false, 2, 0, 4, true, 1);
                                    break;
                                }
                                case 2: {
                                    if (bTutorialEndless) {
                                        bTutorialEndless = false;
                                        this.startAnimation(false, 2, 5, 4, false, 2);
                                        break;
                                    }
                                    this.startAnimation(false, 2, 0, 4, true, 2);
                                    break;
                                }
                                case 3: {
                                    this.startAnimation(false, 1, 5, 4, false, 0);
                                    break;
                                }
                            }
                            return;
                        }
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                if (this.subScreen == 0) {
                    this.game.pointerReleased(x, y);
                    if (!this.isMenuPausePressed(x, y)) break;
                    this.nextScreen(2, 2, 0);
                    this.playMusic(Sounds.MUSIC_MENU, -1);
                    return;
                }
                if (this.subScreen == 2) {
                    if (this.isLeftButtonPressed(x, y)) {
                        this.startAnimation(false, 2, 4, 2, false, 0);
                        return;
                    }
                    if (this.isRightButtonPressed(x, y)) {
                        this.startAnimation(false, 2, 0, 2, false, 0);
                        return;
                    }
                    block46: for (int i = 0; i < this.ID_PAUSE_ITEMS_TOTAL; ++i) {
                        if (!this.rectPauseItems[i].contains(x, y)) continue;
                        switch (i) {
                            case 0: {
                                this.startAnimation(false, 2, 3, 2, false, 0);
                                continue block46;
                            }
                            case 1: {
                                this.startAnimation(false, 1, 1, 2, false, 0);
                                continue block46;
                            }
                            case 2: {
                                this.changeSound();
                                continue block46;
                            }
                            case 3: {
                                this.startAnimation(false, 1, 5, 2, false, 0);
                                continue block46;
                            }
                        }
                    }
                    break;
                }
                if (this.subScreen == 3) {
                    if (this.isRightButtonPressed(x, y)) {
                        this.startAnimation(false, 2, 2, 3, false, 0);
                        return;
                    }
                    if (!this.isLeftButtonPressed(x, y)) break;
                    if (this.game.gameType == 2) {
                        this.game.changeTotalScoreAndSave(this.game.iScore);
                    }
                    this.startAnimation(false, 2, 0, 3, true, this.game.gameType);
                    return;
                }
                if (this.subScreen == 4) {
                    if (this.isRightButtonPressed(x, y)) {
                        this.startAnimation(false, 2, 2, 4, false, 0);
                        return;
                    }
                    if (!this.isLeftButtonPressed(x, y)) break;
                    if (this.game.gameType == 2) {
                        this.game.changeTotalScoreAndSave(this.game.iScore);
                    }
                    this.startAnimation(false, 1, 0, 4, false, 0);
                    return;
                }
                if (this.subScreen == 1) {
                    if (this.isRightButtonPressed(x, y)) {
                        this.startAnimation(false, 1, 0, 1, false, 0);
                        return;
                    }
                    if (!this.isLeftButtonPressed(x, y)) break;
                    this.startAnimation(false, 2, 0, 1, true, this.game.gameType);
                    return;
                }
                if (this.subScreen != 5 || !this.isLeftButtonPressed(x, y)) break;
                this.startAnimation(false, 2, 0, 5, true, this.aGt);
                return;
            }
        }
    }

    public void afterHide() {
    }

    public void beforeShow() {
        Profile.load();
        this.screen = 0;
        this.subScreen = 0;
    }

    public void beforeInteruption() {
        if (this.screen != 0) {
            MainCanvas.soundManager.Stop();
        }
        if (this.screen != 0) {
            MainCanvas.soundManager.Stop();
            if (this.screen == 2) {
                // empty if block
            }
        }
    }

    public void afterInteruption() {
        if (this.screen != 0) {
            if (this.screen == 2 && this.subScreen == 0) {
                this.playMusic(Sounds.MUSIC_GAME, -1);
            } else {
                this.playMusic(Sounds.MUSIC_MENU, -1);
            }
        }
    }

    public void initGraphics() {
        this.bLoading = true;
        Resources.loadGFonts(new int[]{0, 1});
        this.fontMain = Resources.resGFonts[0];
        this.fontSmall = Resources.resGFonts[1];
        Resources.loadImages(new int[]{1, 2, 3});
        imgPause = Resources.resImgs[1];
        imgTitle = Resources.resImgs[2];
        imgInlogic = Resources.resImgs[3];
        Resources.loadSprites(new int[]{0, 1, 2, 4, 3, 5, 6});
        sprArrows = Resources.resSprs[6];
        sprLanguage = Resources.resSprs[0];
        sprBorder = Resources.resSprs[1];
        sprDots = Resources.resSprs[2];
        sprFkIcons = Resources.resSprs[4];
        sprGameIcons = Resources.resSprs[3];
        sprMenuIcons = Resources.resSprs[5];
        this.nextScreen(0, 1, 0);
        this.bLoading = false;
    }

    public void initIntro() {
        this.bLoading = true;
        this.iSelectedLanguage = 0;
        this.rectLanguages[0] = new Rectangle((MainCanvas.WIDTH >> 1) - sprLanguage.getWidth() - (sprLanguage.getWidth() >> 2), (MainCanvas.HEIGHT >> 1) - (sprLanguage.getHeight() >> 1) - (sprLanguage.getHeight() >> 2) - sprLanguage.getHeight(), sprLanguage.getWidth(), sprLanguage.getHeight());
        this.rectLanguages[1] = new Rectangle((MainCanvas.WIDTH >> 1) + (sprLanguage.getWidth() >> 2), (MainCanvas.HEIGHT >> 1) - (sprLanguage.getHeight() >> 1) - (sprLanguage.getHeight() >> 2) - sprLanguage.getHeight(), sprLanguage.getWidth(), sprLanguage.getHeight());
        this.rectLanguages[2] = new Rectangle((MainCanvas.WIDTH >> 1) - sprLanguage.getWidth() - (sprLanguage.getWidth() >> 2), (MainCanvas.HEIGHT >> 1) - (sprLanguage.getHeight() >> 1), sprLanguage.getWidth(), sprLanguage.getHeight());
        this.rectLanguages[3] = new Rectangle((MainCanvas.WIDTH >> 1) + (sprLanguage.getWidth() >> 2), (MainCanvas.HEIGHT >> 1) - (sprLanguage.getHeight() >> 1), sprLanguage.getWidth(), sprLanguage.getHeight());
        this.rectLanguages[4] = new Rectangle((MainCanvas.WIDTH >> 1) - (sprLanguage.getWidth() >> 1), (MainCanvas.HEIGHT >> 1) + (sprLanguage.getHeight() >> 1) + (sprLanguage.getHeight() >> 2), sprLanguage.getWidth(), sprLanguage.getHeight());
        int pomMenuButtonHeight = (this.fontMain.getHeight() << 2) + (this.fontMain.getHeight() >> 1);
        int pomMenuButtonWidth = MainCanvas.WIDTH - (MainCanvas.WIDTH >> 2);
        this.rectTitleCenter = new Rectangle((MainCanvas.WIDTH >> 1) - (pomMenuButtonWidth >> 1), (MainCanvas.HEIGHT >> 1) - (pomMenuButtonHeight >> 1), pomMenuButtonWidth, pomMenuButtonHeight);
        this.iShiftDirection = 1;
        this.iShiftX = 0;
        this.iShiftStep = MainCanvas.WIDTH / 120;
        if (MainCanvas.WIDTH > MainCanvas.HEIGHT) {
            this.iShiftStep = MainCanvas.HEIGHT / 160;
        }
        this.nextScreen(0, 2, 0);
        this.bLoading = false;
    }

    public void init() {
        int i;
        this.bLoading = true;
        this.game = new Game(this);
        this.game.initGameGraphics();
        this.game.initGameVarsOnFirstStart();
        this.bInAnimation = false;
        this.bOutAnimation = false;
        this.iMenuAnimOffX = (MainCanvas.WIDTH >> 1) + (sprBorder.getWidth() >> 1);
        this.iMenuAnimLogoOffY = imgTitle.getHeight();
        this.iFkAnimOffY = sprFkIcons.getHeight();
        this.iTopBarAnimOffY = sprMenuIcons.getHeight();
        this.iShopItemOff = (MainCanvas.WIDTH >> 1) + sprMenuIcons.getWidth();
        this.iShopPriceOff = (MainCanvas.WIDTH >> 1) - sprMenuIcons.getWidth() - (sprMenuIcons.getWidth() >> 3);
        bTutorialEndless = true;
        bTutorialTime = true;
        bTutorialMoves = true;
        this.iAnimStep = MainCanvas.WIDTH / 128;
        this.nextScreen(1, 0, 0);
        Resources.freeSprites(new int[]{0});
        sprLanguage = null;
        System.gc();
        this.rectTopBar = new Rectangle((MainCanvas.WIDTH >> 1) - (sprBorder.getWidth() >> 1), 0, sprBorder.getWidth(), sprMenuIcons.getHeight());
        this.rectMenuItems = new Rectangle[this.iMenuItemsTotal];
        int iTitleH = imgTitle.getHeight();
        int iControlH = sprFkIcons.getHeight();
        int iMnuItemsH = MainCanvas.HEIGHT - iTitleH - iControlH;
        int iMnuH = (sprMenuIcons.getHeight() - (sprMenuIcons.getHeight() >> 2)) * this.iMenuItemsTotal;
        int offY = iMnuItemsH - iMnuH >> 1;
        for (i = 0; i < this.iMenuItemsTotal; ++i) {
            this.rectMenuItems[i] = new Rectangle(sprFkIcons.getWidth() >> 1, iTitleH + offY + i * (sprMenuIcons.getHeight() - (sprMenuIcons.getHeight() >> 2)), MainCanvas.WIDTH - sprFkIcons.getWidth(), sprMenuIcons.getHeight());
        }
        this.menuItemsFrames = new int[this.iMenuItemsTotal];
        this.menuItemsFrames[0] = 0;
        this.menuItemsFrames[1] = 1;
        this.menuItemsFrames[2] = 2;
        this.menuItemsFrames[3] = 4;
        this.rectSelectGameItems = new Rectangle[4];
        iMnuItemsH = MainCanvas.HEIGHT - iControlH;
        iMnuH = (sprMenuIcons.getHeight() - (sprMenuIcons.getHeight() >> 2)) * 4;
        offY = iMnuItemsH - iMnuH >> 1;
        for (i = 0; i < 4; ++i) {
            this.rectSelectGameItems[i] = new Rectangle(sprFkIcons.getWidth() >> 1, offY + i * (sprMenuIcons.getHeight() - (sprMenuIcons.getHeight() >> 2)), MainCanvas.WIDTH - sprFkIcons.getWidth(), sprMenuIcons.getHeight());
        }
        this.selectGameItemsFrames = new int[4];
        this.selectGameItemsFrames[0] = 7;
        this.selectGameItemsFrames[1] = 6;
        this.selectGameItemsFrames[2] = 10;
        this.selectGameItemsFrames[3] = 9;
        this.rectPauseItems = new Rectangle[this.ID_PAUSE_ITEMS_TOTAL];
        iMnuItemsH = MainCanvas.HEIGHT - iControlH - iTitleH;
        iMnuH = (sprMenuIcons.getHeight() - (sprMenuIcons.getHeight() >> 2)) * this.ID_PAUSE_ITEMS_TOTAL;
        offY = iMnuItemsH - iMnuH >> 1;
        for (i = 0; i < this.ID_PAUSE_ITEMS_TOTAL; ++i) {
            this.rectPauseItems[i] = new Rectangle(sprFkIcons.getWidth() >> 1, iTitleH + offY + i * (sprMenuIcons.getHeight() - (sprMenuIcons.getHeight() >> 2)), MainCanvas.WIDTH - sprFkIcons.getWidth(), sprMenuIcons.getHeight());
        }
        this.pauseItemsFrames = new int[this.ID_PAUSE_ITEMS_TOTAL];
        this.pauseItemsFrames[0] = 3;
        this.pauseItemsFrames[1] = 1;
        this.pauseItemsFrames[2] = 4;
        this.pauseItemsFrames[3] = 9;
        this.iInstructionsCenterY = (MainCanvas.HEIGHT >> 1) + (sprMenuIcons.getHeight() - sprFkIcons.getHeight() >> 1);
        this.iInstructionsWidth = MainCanvas.WIDTH - sprMenuIcons.getWidth();
        this.iInstructionsHeight = MainCanvas.HEIGHT - sprFkIcons.getHeight() - sprMenuIcons.getHeight() - (sprBorder.getHeight() << 1) - (sprArrows.getHeight() << 1);
        iMnuItemsH = MainCanvas.HEIGHT - iControlH - sprMenuIcons.getHeight();
        iMnuH = (sprMenuIcons.getHeight() - (sprMenuIcons.getHeight() >> 3)) * 4;
        offY = iMnuItemsH - iMnuH >> 1;
        this.rectShopItems = new Rectangle[4];
        for (i = 0; i < 4; ++i) {
            this.rectShopItems[i] = new Rectangle(sprFkIcons.getWidth() >> 1, sprMenuIcons.getHeight() + offY + i * (sprMenuIcons.getHeight() - (sprMenuIcons.getHeight() >> 3)), MainCanvas.WIDTH - sprFkIcons.getWidth(), sprMenuIcons.getHeight());
        }
        this.shopItemsFrames = new int[4];
        this.shopItemsFrames[0] = 7;
        this.shopItemsFrames[1] = 6;
        this.shopItemsFrames[2] = 8;
        this.shopItemsFrames[3] = 5;
        this.iShopItemCupX = (MainCanvas.WIDTH >> 1) - (sprMenuIcons.getWidth() >> 3) - sprMenuIcons.getWidth() - this.fontMain.stringWidth("000".toCharArray()) - sprGameIcons.getWidth();
        if (Profile.bMusic) {
            this.soundOn();
            MainCanvas.soundManager.Stop();
            MainCanvas.soundManager.Play(Sounds.MUSIC_MENU, -1);
        } else {
            this.soundOff();
        }
        this.bLoading = false;
    }

    public void initTexts() {
        Resources.initLangDirs(langCodes[this.iSelectedLanguage]);
        Resources.loadText(0);
        this.iSelectedMenuItem = 0;
        this.iMenuItemsTotal = 4;
    }

    public void setTexts() {
        block0 : switch (this.screen) {
            case 0: {
                this.iTextLines = 1;
                switch (this.subScreen) {
                    case 4: {
                        this.strTextBody = Resources.resTexts[0].getHashedString(2);
                        this.setTitleCenter(this.strTextBody);
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                this.iTextLines = 1;
                switch (this.subScreen) {
                    case 0: {
                        this.strTextMenu[0] = Resources.resTexts[0].getHashedString(7);
                        this.strTextMenu[1] = Resources.resTexts[0].getHashedString(36);
                        this.strTextMenu[2] = Resources.resTexts[0].getHashedString(10);
                        this.strTextMenu[3] = Resources.resTexts[0].getHashedString(9);
                        if (Profile.bMusic) {
                            this.strTextMenu[3] = this.strTextMenu[3] + " " + Resources.resTexts[0].getHashedString(15);
                            break block0;
                        }
                        this.strTextMenu[3] = this.strTextMenu[3] + " " + Resources.resTexts[0].getHashedString(16);
                        break block0;
                    }
                    case 5: {
                        this.strTextBody = Resources.resTexts[0].getHashedString(40);
                        this.strTextMenu[0] = Resources.resTexts[0].getHashedString(41);
                        this.strTextMenu[1] = Resources.resTexts[0].getHashedString(42);
                        this.strTextMenu[2] = Resources.resTexts[0].getHashedString(43);
                        this.strTextMenu[3] = Resources.resTexts[0].getHashedString(44);
                        break block0;
                    }
                    case 4: {
                        this.strTextMenu[0] = Resources.resTexts[0].getHashedString(37);
                        this.strTextMenu[1] = Resources.resTexts[0].getHashedString(38);
                        this.strTextMenu[2] = Resources.resTexts[0].getHashedString(39);
                        this.strTextMenu[3] = Resources.resTexts[0].getHashedString(40);
                        break block0;
                    }
                    case 1: {
                        this.strTextBody = Resources.resTexts[0].getHashedString(36);
                        this.bLoading = true;
                        this.strTextPom[0] = Resources.resTexts[0].getHashedString(8) + "\n\n" + Resources.resTexts[0].getHashedString(27);
                        int textMaxWidth = this.iInstructionsWidth;
                        this.prepText = new PreparedText(this.fontMain);
                        this.prepText.prepareText(this.strTextPom[0], textMaxWidth);
                        this.iTextLines = this.prepText.getTextHeight() / this.fontMain.getHeight();
                        int iTextYUp = this.iInstructionsCenterY - (this.iInstructionsHeight >> 1) + sprArrows.getHeight() * 3;
                        int iTextYDown = this.iInstructionsCenterY + (this.iInstructionsHeight >> 1) - sprArrows.getHeight() * 3;
                        int iTextHeight = iTextYDown - iTextYUp;
                        this.iTextShiftY = 0;
                        this.iInstructionsShiftY = 0;
                        this.iInstructionsMaxShiftY = this.prepText.getTextHeight() - iTextHeight;
                        this.bDragInstructions = false;
                        this.bLoading = false;
                        break block0;
                    }
                    case 2: {
                        this.strTextBody = Resources.resTexts[0].getHashedString(10);
                        this.strTextPom[0] = X.singleton.getAppProperty("MIDlet-Name").toUpperCase();
                        this.strTextPom[1] = Resources.resTexts[0].getHashedString(17) + " " + X.singleton.getAppProperty("MIDlet-Version").toUpperCase();
                        break block0;
                    }
                    case 3: {
                        this.strTextBody = Resources.resTexts[0].getHashedString(12);
                        this.setTitleCenter(this.strTextBody);
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                switch (this.subScreen) {
                    case 2: {
                        this.strTextMenu[0] = Resources.resTexts[0].getHashedString(51);
                        this.strTextMenu[1] = Resources.resTexts[0].getHashedString(36);
                        this.strTextMenu[2] = Resources.resTexts[0].getHashedString(9);
                        this.strTextMenu[2] = Profile.bMusic ? this.strTextMenu[2] + " " + Resources.resTexts[0].getHashedString(15) : this.strTextMenu[2] + " " + Resources.resTexts[0].getHashedString(16);
                        this.strTextMenu[3] = Resources.resTexts[0].getHashedString(40);
                        break block0;
                    }
                    case 3: {
                        this.strTextBody = Resources.resTexts[0].getHashedString(31);
                        this.setTitleCenter(this.strTextBody);
                        break block0;
                    }
                    case 5: {
                        switch (this.aGt) {
                            case 0: {
                                this.strTextBody = Resources.resTexts[0].getHashedString(52);
                                this.strTextBody = this.replace(this.strTextBody, "[XX]", "30");
                                break;
                            }
                            case 1: {
                                this.strTextBody = Resources.resTexts[0].getHashedString(53);
                                this.strTextBody = this.replace(this.strTextBody, "[XX]", "60");
                                break;
                            }
                            case 2: {
                                this.strTextBody = Resources.resTexts[0].getHashedString(54);
                                break;
                            }
                        }
                        this.setTitleCenter(this.strTextBody);
                        break block0;
                    }
                    case 4: {
                        this.strTextBody = Resources.resTexts[0].getHashedString(31);
                        this.setTitleCenter(this.strTextBody);
                        break block0;
                    }
                }
                break;
            }
        }
    }

    private String replace(String str, String pattern, String replace) {
        int s = 0;
        int e = 0;
        StringBuffer result = new StringBuffer();
        while ((e = str.indexOf(pattern, s)) >= 0) {
            result.append(str.substring(s, e));
            result.append(replace);
            s = e + pattern.length();
        }
        result.append(str.substring(s));
        return result.toString();
    }

    public void play(int selectedGameType, int previScreen) {
        this.bLoading = true;
        this.game.start(selectedGameType);
        this.nextScreen(2, 0, previScreen);
        this.bLoading = false;
    }

    public void nextScreen(int nextScreen, int nextSubScreen, int previousScreen) {
        this.screen = nextScreen;
        this.subScreen = nextSubScreen;
        this.prevScreen = previousScreen;
        if (previousScreen == 5) {
            this.bPaintShopError = false;
            this.iPaintCounter = 0;
        }
        block0 : switch (this.screen) {
            case 0: {
                switch (this.subScreen) {
                    case 4: {
                        this.initTexts();
                        break block0;
                    }
                    case 2: {
                        this.delay = 3000;
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                if (this.subScreen == 0) {
                    this.iSelectedMenuItem = 0;
                    this.startAnimation(true, -1, -1, -1, false, 0);
                    break;
                }
                if (this.subScreen == 4) {
                    this.iSelectedMenuItem = 0;
                    this.startAnimation(true, -1, -1, -1, false, 0);
                    break;
                }
                if (this.subScreen == 5) {
                    this.iSelectedMenuItem = 0;
                    this.startAnimation(true, -1, -1, -1, false, 0);
                    break;
                }
                if (this.subScreen != 1 && this.subScreen != 2 && this.subScreen != 3) break;
                this.startAnimation(true, -1, -1, -1, false, 0);
                break;
            }
            case 2: {
                if (this.subScreen == 2) {
                    this.iSelectedMenuItem = 0;
                    this.startAnimation(true, -1, -1, -1, false, 0);
                    break;
                }
                if (this.subScreen == 4 || this.subScreen == 3) {
                    this.startAnimation(true, -1, -1, -1, false, 0);
                    break;
                }
                if (this.subScreen == 1) {
                    this.startAnimation(true, -1, -1, -1, false, 0);
                    break;
                }
                if (this.subScreen == 5) {
                    this.startAnimation(true, -1, -1, -1, false, this.aGt);
                    break;
                }
                if (this.subScreen != 0) break;
                this.playMusic(Sounds.MUSIC_GAME, -1);
                break;
            }
        }
        this.setTexts();
    }

    public void playMusic(int type, int times) {
        MainCanvas.soundManager.Stop();
        MainCanvas.soundManager.Play(type, times);
    }
}

