/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.game;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import sk.inlogic.MainCanvas;
import sk.inlogic.Profile;
import sk.inlogic.Resources;
import sk.inlogic.Sounds;
import sk.inlogic.game.Defs;
import sk.inlogic.game.Logger;
import sk.inlogic.screen.ScreenMain;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.RandomNum;
import sk.inlogic.util.Rectangle;

public class MainGame {
    private ScreenMain gameScreen;
    public byte gameType;
    private static final byte BYTE_NULL = -100;
    private static final byte BYTE_STACKEND = -99;
    public static final byte MAX_COLUMN_SIZE = 25;
    public static final byte MAX_ENDSTACK_SIZE = 13;
    private byte[] deck;
    private byte deckCardPointer;
    private byte[] gPos;
    private byte[][] gColumns;
    private byte[][] gEndStacks;
    private byte[] gFreecells;
    private byte[] gStackSolitaire;
    private byte[] gStackSpider;
    private byte[] handPositionCurrent;
    private byte[] handPositionOld;
    private byte[] selectedCards;
    private boolean selected;
    private int endStackPositionPosuv;
    private int spiderStackStep;
    private int iBottomPanelY;
    private byte solitaireStackPointer;
    private boolean bLastCardInStackSolitaire = false;
    private int handPositionX;
    private int handPositionY;
    private int score;
    public boolean bContinueSavedGame = false;
    public int iPauseItemsTotal;
    public Image[] imagesPauseItems;
    public static Rectangle[] rectPauseItems;
    public static final byte ID_PAUSE_INSTRUCTIONS = 0;
    public static final byte ID_PAUSE_RESTART = 1;
    public static final byte ID_PAUSE_QUIT_TO_MENU = 2;
    private byte[][] history;
    public static final byte HIST_SIZE_TOTAL = 3;
    private static final byte HIST_TYPE_COLUMN = 0;
    private static final byte HIST_TYPE_ENDSTACK = 1;
    private static final byte HIST_TYPE_FREECELL = 2;
    private static final byte HIST_TYPE_STACKSPIDER = 3;
    private int iGameOverStep = 0;
    private int iGameOverStepTime = 0;
    private int iGameOverStepTick = 400;
    int iTutorialW;
    int iTutorialH;
    int iTutorialCenterY;
    int iGameOverW;
    int iGameOverH;
    int iCenterGameOverY;
    PreparedText prepText;
    int iTextLines = 0;
    public int iTextShiftY = 0;
    int iTutorialShiftY = 0;
    int iTutorialMaxShiftY = 0;
    boolean bDragTutorial;
    String[] sTextPom = new String[3];
    private int cardsOffsetY;
    private int firstRowY;
    private int secondRowY;
    private int cardsOffW;
    private int cardsOffH;
    private int stackOffX;
    public boolean bInstructionFromPause = false;
    public boolean bRestart = false;
    boolean bRemove = false;
    private Rectangle[] rectFirstRow;
    private Rectangle[][] rectSecondRow;
    private int iScoreTextW;
    private byte lastIdx;
    private int iBottomTextY;
    private int iBottomImageY;
    private int iBottomTextRightX;
    private int iBottomTextLeftX;
    private long playedSec;
    private int sec;
    private String time;
    private int iImgOY;
    private int iImgOX;
    private int iCardCenterX;
    private int iCardCenterY;
    private int iCardQuaterOffX;
    private int iCardQuaterOffY;
    private boolean bTurend = false;
    boolean bBack;

    public MainGame(ScreenMain gameScreen) {
        this.gameScreen = gameScreen;
    }

    public void initGameVarsOnlyFirst() {
        this.iBottomPanelY = MainCanvas.HEIGHT - this.gameScreen.imgScoreBar.getHeight();
        this.iBottomImageY = this.iBottomPanelY + (this.gameScreen.imgScoreBar.getHeight() >> 1) - (this.gameScreen.imgSmallTime.getHeight() >> 1);
        this.iBottomTextY = this.iBottomPanelY + (this.gameScreen.imgScoreBar.getHeight() >> 1) - (this.gameScreen.fontNumbers.getHeight() >> 1);
        this.iBottomTextRightX = (MainCanvas.WIDTH >> 1) + (this.gameScreen.imgSmallScore.getWidth() >> 1) + this.gameScreen.imgSmallTime.getWidth();
        this.iTutorialW = MainCanvas.WIDTH - (this.gameScreen.imgArrows[0].getWidth() << 1);
        this.iTutorialH = MainCanvas.HEIGHT - (this.gameScreen.imgScoreBar.getHeight() << 1);
        this.iTutorialCenterY = MainCanvas.HEIGHT - this.gameScreen.imgScoreBar.getHeight() >> 1;
        this.iGameOverW = this.iTutorialW;
        this.iGameOverH = (this.iTutorialH >> 1) + (this.iTutorialH >> 2);
        this.iCenterGameOverY = MainCanvas.HEIGHT - this.gameScreen.imgScoreBar.getHeight() >> 1;
        this.gPos = new byte[16];
        this.iCardCenterX = this.gameScreen.sprCards.getWidth() >> 1;
        this.iCardCenterY = this.gameScreen.sprCards.getHeight() >> 1;
        this.iCardQuaterOffX = this.gameScreen.sprCards.getWidth() >> 2;
        this.iCardQuaterOffY = this.gameScreen.sprCards.getHeight() >> 2;
    }

    public void initGame(byte gameType) {
        this.gameScreen.bLoading = true;
        this.gameType = gameType;
        this.shuffleCards();
        this.initTutorialTexts();
        if (gameType == 0) {
            this.initSolitaire();
        } else if (gameType == 1) {
            this.initFreeCell();
        } else if (gameType == 2) {
            this.initSpider();
        }
        this.calculatePositions();
        this.resetGameBeforePlay();
        this.gameScreen.bLoading = false;
    }

    public void initTutorialTexts() {
        switch (this.gameType) {
            case 0: {
                this.sTextPom[0] = Resources.resTexts[0].getHashedString(32);
                break;
            }
            case 1: {
                this.sTextPom[0] = Resources.resTexts[0].getHashedString(33);
                break;
            }
            case 2: {
                this.sTextPom[0] = Resources.resTexts[0].getHashedString(34);
                break;
            }
        }
        this.sTextPom[0] = this.sTextPom[0] + "\n\n" + Resources.resTexts[0].getHashedString(26);
        int textMaxWidth = this.iTutorialW - (this.iTutorialW >> 3);
        this.prepText = new PreparedText(this.gameScreen.fontMain);
        this.prepText.prepareText(this.sTextPom[0], textMaxWidth);
        this.iTextLines = this.prepText.getTextHeight() / this.gameScreen.fontMain.getHeight();
        int iTextYUp = this.iTutorialCenterY - (this.iTutorialH >> 1) + this.gameScreen.imgArrows[0].getHeight() * 3;
        int iTextYDown = this.iTutorialCenterY + (this.iTutorialH >> 1) - this.gameScreen.imgArrows[0].getHeight() * 3;
        int iTextHeight = iTextYDown - iTextYUp;
        this.iTextShiftY = 0;
        this.iTutorialShiftY = 0;
        this.iTutorialMaxShiftY = this.prepText.getTextHeight() - iTextHeight;
        this.bDragTutorial = false;
    }

    private void calculatePositions() {
        this.cardsOffsetY = this.iCardQuaterOffY;
        int cardsW = this.gColumns.length * this.gameScreen.sprCards.getWidth();
        this.firstRowY = this.cardsOffsetY;
        this.secondRowY = this.gameScreen.sprCards.getHeight() + (this.cardsOffsetY << 1);
        this.cardsOffW = (MainCanvas.WIDTH - cardsW) / (this.gColumns.length + 1);
        this.cardsOffH = this.iCardCenterY - this.iCardQuaterOffY;
        switch (this.gameType) {
            case 0: {
                this.rectFirstRow = new Rectangle[6];
                this.rectSecondRow = new Rectangle[this.gColumns.length][25];
                this.rectFirstRow[0] = new Rectangle(this.cardsOffW, this.firstRowY, this.gameScreen.sprCards.getWidth(), this.gameScreen.sprCards.getHeight());
                this.rectFirstRow[1] = new Rectangle((this.cardsOffW << 1) + this.gameScreen.sprCards.getWidth(), this.firstRowY, this.gameScreen.sprCards.getWidth(), this.gameScreen.sprCards.getHeight());
                int hlpX = this.gameScreen.sprCards.getWidth() * 3 + (this.cardsOffW << 2);
                for (int i = 2; i < this.rectFirstRow.length; ++i) {
                    this.rectFirstRow[i] = new Rectangle(hlpX, this.firstRowY, this.gameScreen.sprCards.getWidth(), this.gameScreen.sprCards.getHeight());
                    hlpX += this.gameScreen.sprCards.getWidth() + this.cardsOffW;
                }
                break;
            }
            case 2: {
                this.rectFirstRow = new Rectangle[1];
                this.rectSecondRow = new Rectangle[this.gColumns.length][25];
                this.rectFirstRow[0] = new Rectangle(this.cardsOffW, this.firstRowY, this.gameScreen.sprCards.getWidth(), this.gameScreen.sprCards.getHeight());
                this.stackOffX = this.iCardQuaterOffX;
                break;
            }
            case 1: {
                this.rectFirstRow = new Rectangle[8];
                this.rectSecondRow = new Rectangle[this.gColumns.length][25];
                int hlpXx = this.cardsOffW;
                for (int i = 0; i < this.rectFirstRow.length; ++i) {
                    this.rectFirstRow[i] = new Rectangle(hlpXx, this.firstRowY, this.gameScreen.sprCards.getWidth(), this.gameScreen.sprCards.getHeight());
                    hlpXx += this.gameScreen.sprCards.getWidth() + this.cardsOffW;
                }
                break;
            }
        }
        for (int i = 0; i < this.rectSecondRow.length; ++i) {
            for (int j = 0; j < this.rectSecondRow[0].length; ++j) {
                this.rectSecondRow[i][j] = new Rectangle(this.cardsOffW + i * (this.gameScreen.sprCards.getWidth() + this.cardsOffW), this.secondRowY + j * this.cardsOffH, this.gameScreen.sprCards.getWidth(), this.gameScreen.sprCards.getHeight());
            }
        }
        this.iImgOX = this.rectFirstRow[0].x + (this.rectFirstRow[0].width >> 1) - (this.gameScreen.imgO.getWidth() >> 1);
        this.iImgOY = this.rectFirstRow[0].y + (this.rectFirstRow[0].height >> 1) - (this.gameScreen.imgO.getHeight() >> 1);
    }

    private void initSolitaire() {
        int j;
        int i;
        this.gPos[0] = 3;
        this.gPos[1] = 3;
        this.gPos[2] = 3;
        this.gPos[3] = 3;
        this.gPos[4] = 3;
        this.gPos[5] = 3;
        this.gPos[6] = 3;
        this.gPos[7] = 5;
        this.gPos[8] = 0;
        this.gPos[9] = 0;
        this.gPos[10] = 5;
        this.gPos[11] = 2;
        this.gPos[12] = 2;
        this.gPos[13] = 2;
        this.gPos[14] = 2;
        this.gPos[15] = 5;
        this.gColumns = new byte[7][25];
        this.gEndStacks = new byte[4][13];
        this.gStackSolitaire = new byte[25];
        this.endStackPositionPosuv = 11;
        for (i = 0; i <= this.gColumns.length - 1; ++i) {
            for (j = 0; j < 25; ++j) {
                if (j <= i) {
                    this.gColumns[i][j] = this.getNextCardFromDeck();
                    if (j == i) continue;
                    this.gColumns[i][j] = this.turnCard(false, this.gColumns[i][j]);
                    continue;
                }
                this.gColumns[i][j] = -100;
            }
        }
        this.gStackSolitaire[0] = -99;
        for (i = 1; i < this.gStackSolitaire.length; ++i) {
            this.gStackSolitaire[i] = this.getNextCardFromDeck();
        }
        for (i = 0; i < this.gEndStacks.length; ++i) {
            for (j = 0; j < this.gEndStacks[0].length; ++j) {
                this.gEndStacks[i][j] = -100;
            }
        }
    }

    private void initFreeCell() {
        int j;
        int i;
        this.gPos[0] = 3;
        this.gPos[1] = 3;
        this.gPos[2] = 3;
        this.gPos[3] = 3;
        this.gPos[4] = 3;
        this.gPos[5] = 3;
        this.gPos[6] = 3;
        this.gPos[7] = 3;
        this.gPos[8] = 4;
        this.gPos[9] = 4;
        this.gPos[10] = 4;
        this.gPos[11] = 4;
        this.gPos[12] = 2;
        this.gPos[13] = 2;
        this.gPos[14] = 2;
        this.gPos[15] = 2;
        this.gColumns = new byte[8][25];
        this.gEndStacks = new byte[4][13];
        this.gFreecells = new byte[4];
        this.endStackPositionPosuv = 12;
        for (i = 0; i <= this.gColumns.length - 1; ++i) {
            for (j = 0; j < 25; ++j) {
                if (i < 4) {
                    if (j < 7) {
                        this.gColumns[i][j] = this.getNextCardFromDeck();
                        continue;
                    }
                    this.gColumns[i][j] = -100;
                    continue;
                }
                this.gColumns[i][j] = j < 6 ? this.getNextCardFromDeck() : (byte)-100;
            }
        }
        for (i = 0; i < this.gEndStacks.length; ++i) {
            for (j = 0; j < this.gEndStacks[0].length; ++j) {
                this.gEndStacks[i][j] = -100;
            }
        }
        this.gFreecells[0] = -100;
        this.gFreecells[1] = -100;
        this.gFreecells[2] = -100;
        this.gFreecells[3] = -100;
    }

    private void initSpider() {
        int i;
        this.gPos[0] = 3;
        this.gPos[1] = 3;
        this.gPos[2] = 3;
        this.gPos[3] = 3;
        this.gPos[4] = 3;
        this.gPos[5] = 3;
        this.gPos[6] = 3;
        this.gPos[7] = 5;
        this.gPos[8] = 1;
        this.gPos[9] = 5;
        this.gPos[10] = 5;
        this.gPos[11] = 5;
        this.gPos[12] = 5;
        this.gPos[13] = 5;
        this.gPos[14] = 5;
        this.gPos[15] = 5;
        this.gColumns = new byte[7][25];
        this.gStackSpider = new byte[24];
        this.endStackPositionPosuv = 0;
        for (i = 0; i <= this.gColumns.length - 1; ++i) {
            for (int j = 0; j < 25; ++j) {
                if (j <= i) {
                    this.gColumns[i][j] = this.getNextCardFromDeck();
                    if (j == i) continue;
                    this.gColumns[i][j] = this.turnCard(false, this.gColumns[i][j]);
                    continue;
                }
                this.gColumns[i][j] = -100;
            }
        }
        for (i = 0; i < this.gStackSpider.length; ++i) {
            this.gStackSpider[i] = this.getNextCardFromDeck();
        }
        this.spiderStackStep = 0;
    }

    public void resetGameBeforePlay() {
        this.bInstructionFromPause = false;
        this.iGameOverStep = 0;
        this.handPositionCurrent = this.gameType == 1 ? new byte[]{0, this.getLastIndexInArray(0, this.gColumns)} : new byte[]{0, 0};
        this.handPositionOld = new byte[2];
        this.setHandPosition();
        this.selectedCards = new byte[13];
        this.solitaireStackPointer = 0;
        this.setSelectedCards(null);
        this.playedSec = 0L;
        this.bTurend = false;
        this.history = new byte[3][6];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 6; ++j) {
                this.history[i][j] = -100;
            }
        }
        this.score = this.gameType == 2 ? 500 : 0;
    }

    public void resetLoadedGameBeforePlay() {
        this.bInstructionFromPause = false;
        this.iGameOverStep = 0;
        this.handPositionCurrent = new byte[]{0, 0};
        this.handPositionCurrent[0] = Profile.handPositionCurrent[0];
        this.handPositionCurrent[1] = Profile.handPositionCurrent[1];
        this.handPositionOld = new byte[2];
        this.handPositionOld[0] = Profile.handPositionOld[0];
        this.handPositionOld[1] = Profile.handPositionOld[1];
        this.setHandPosition();
        this.selectedCards = new byte[13];
        this.solitaireStackPointer = 0;
        this.solitaireStackPointer = (byte)Profile.solitaireStackPointer;
        this.setSelectedCards(null);
        this.playedSec = Profile.playedSec * 1000;
        this.history = new byte[3][6];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 6; ++j) {
                this.history[i][j] = Profile.history[i][j];
            }
        }
        this.score = Profile.score;
    }

    private void undo() {
        if (this.history[0][0] != -100) {
            int i;
            this.addScore(-50);
            switch (this.history[0][4]) {
                case 0: {
                    if (this.history[0][0] < 8) {
                        byte[] cards;
                        if (this.gColumns[this.history[0][2]][this.history[0][3] + 1] == -100) {
                            cards = new byte[]{this.gColumns[this.history[0][2]][this.history[0][3]]};
                        } else {
                            int poc = 0;
                            while (this.gColumns[this.history[0][2]][this.history[0][3] + poc] != -100) {
                                ++poc;
                            }
                            cards = new byte[poc];
                            poc = 0;
                            while (this.gColumns[this.history[0][2]][this.history[0][3] + poc] != -100) {
                                cards[poc] = this.gColumns[this.history[0][2]][this.history[0][3] + poc];
                                ++poc;
                            }
                        }
                        if (cards.length == 1) {
                            this.gColumns[this.history[0][0]][this.history[0][1]] = cards[0];
                            this.gColumns[this.history[0][2]][this.history[0][3]] = -100;
                        } else {
                            for (int i2 = 0; i2 < cards.length; ++i2) {
                                this.gColumns[this.history[0][0]][this.history[0][1] + i2] = cards[i2];
                                this.gColumns[this.history[0][2]][this.history[0][3] + i2] = -100;
                            }
                        }
                        if (this.gameType != 0 && this.gameType != 2 || this.history[0][1] <= 0) break;
                        if (this.history[0][1] > 1) {
                            if (this.gColumns[this.history[0][0]][this.history[0][1] - 1] >= 0 && this.gColumns[this.history[0][0]][this.history[0][1] - 2] >= 0 || this.history[0][5] != 1) break;
                            this.gColumns[this.history[0][0]][this.history[0][1] - 1] = this.turnCard(false, this.gColumns[this.history[0][0]][this.history[0][1] - 1]);
                            break;
                        }
                        if (this.history[0][5] != 1) break;
                        this.gColumns[this.history[0][0]][this.history[0][1] - 1] = this.turnCard(false, this.gColumns[this.history[0][0]][this.history[0][1] - 1]);
                        break;
                    }
                    byte card = this.gColumns[this.history[0][2]][this.history[0][3]];
                    if (this.gameType == 0) {
                        if (this.history[0][0] == 9) {
                            byte c;
                            this.gStackSolitaire[this.history[0][1]] = c = this.gColumns[this.history[0][2]][this.history[0][3]];
                            this.gColumns[this.history[0][2]][this.history[0][3]] = -100;
                            this.solitaireStackPointer = this.history[0][1];
                            break;
                        }
                        this.gEndStacks[this.history[0][0] - this.endStackPositionPosuv][this.history[0][1]] = card;
                        this.gColumns[this.history[0][2]][this.history[0][3]] = -100;
                        break;
                    }
                    if (this.gameType != 1) break;
                    if (this.history[0][0] < 12) {
                        this.gFreecells[this.history[0][0] - 8] = card;
                        this.gColumns[this.history[0][2]][this.history[0][3]] = -100;
                        break;
                    }
                    this.gEndStacks[this.history[0][0] - this.endStackPositionPosuv][this.history[0][1]] = card;
                    this.gColumns[this.history[0][2]][this.history[0][3]] = -100;
                    break;
                }
                case 1: {
                    byte crd;
                    if (this.history[0][0] < 8) {
                        byte crd2 = this.gEndStacks[this.history[0][2] - this.endStackPositionPosuv][this.history[0][3]];
                        Logger.l("crd : " + this.history[0][3]);
                        Logger.l("crd : " + this.history[0][0]);
                        Logger.l("crd : " + this.history[0][1]);
                        this.gColumns[this.history[0][0]][this.history[0][1]] = crd2;
                        this.gEndStacks[this.history[0][2] - this.endStackPositionPosuv][this.history[0][3]] = -100;
                        if (this.gameType != 0 && this.gameType != 2 || this.history[0][1] <= 0) break;
                        this.gColumns[this.history[0][0]][this.history[0][1] - 1] = this.turnCard(false, this.gColumns[this.history[0][0]][this.history[0][1] - 1]);
                        break;
                    }
                    if (this.gameType == 1) {
                        byte crd3;
                        if (this.history[0][0] >= 12) break;
                        this.gFreecells[this.history[0][0] - 8] = crd3 = this.gEndStacks[this.history[0][2]][this.history[0][3]];
                        this.gEndStacks[this.history[0][2] - this.endStackPositionPosuv][this.history[0][3]] = -100;
                        break;
                    }
                    if (this.gameType != 0) break;
                    if (this.history[0][0] == 9) {
                        this.gStackSolitaire[this.history[0][1]] = this.gEndStacks[this.history[0][2] - this.endStackPositionPosuv][this.history[0][3]];
                        this.gEndStacks[this.history[0][2] - this.endStackPositionPosuv][this.history[0][3]] = -100;
                        this.solitaireStackPointer = this.history[0][1];
                        break;
                    }
                    this.gEndStacks[this.history[0][0] - this.endStackPositionPosuv][this.history[0][1]] = crd = this.gEndStacks[this.history[0][2] - this.endStackPositionPosuv][this.history[0][3]];
                    this.gEndStacks[this.history[0][2] - this.endStackPositionPosuv][this.history[0][3]] = -100;
                    break;
                }
                case 2: {
                    byte c;
                    if (this.history[0][0] < 8) {
                        byte c2;
                        this.gColumns[this.history[0][0]][this.history[0][1]] = c2 = this.gFreecells[this.history[0][2] - 8];
                        this.gFreecells[this.history[0][2] - 8] = -100;
                        break;
                    }
                    if (this.history[0][0] < 12) {
                        byte c3;
                        this.gFreecells[this.history[0][0] - 8] = c3 = this.gFreecells[this.history[0][2] - 8];
                        this.gFreecells[this.history[0][2] - 8] = -100;
                        break;
                    }
                    this.gEndStacks[this.history[0][0] - this.endStackPositionPosuv][this.history[0][1]] = c = this.gFreecells[this.history[0][2] - 8];
                    this.gFreecells[this.history[0][2] - 8] = -100;
                    break;
                }
                case 3: {
                    this.insertCardsBackToSpiderStack();
                    break;
                }
            }
            for (i = 0; i < 2; ++i) {
                for (int j = 0; j < 6; ++j) {
                    this.history[i][j] = this.history[i + 1][j];
                }
            }
            for (i = 0; i < 6; ++i) {
                this.history[2][i] = -100;
            }
        }
    }

    private void addMoveToHistory(byte type, boolean solitaireStack) {
        for (int i = 2; i > 0; --i) {
            for (int j = 0; j < 6; ++j) {
                this.history[i][j] = this.history[i - 1][j];
            }
        }
        this.history[0][0] = this.handPositionOld[0];
        if (solitaireStack) {
            this.history[0][1] = this.solitaireStackPointer;
        } else {
            this.history[0][1] = this.handPositionOld[1];
            if (this.history[0][0] < 8 && this.gameType != 1) {
                if (this.handPositionOld[1] > 0) {
                    this.history[0][5] = !this.bTurend ? (byte)0 : 1;
                }
            } else {
                this.history[0][5] = 0;
            }
        }
        this.history[0][2] = this.handPositionCurrent[0];
        if (this.gameType == 0 && this.handPositionCurrent[0] > 10) {
            this.handPositionCurrent[1] = this.getLastIndexInArray(this.handPositionCurrent[0] - this.endStackPositionPosuv, this.gEndStacks);
        }
        if (this.gameType == 1 && this.handPositionCurrent[0] > 11) {
            this.handPositionCurrent[1] = this.getLastIndexInArray(this.handPositionCurrent[0] - this.endStackPositionPosuv, this.gEndStacks);
        }
        this.history[0][3] = this.handPositionCurrent[1];
        this.history[0][4] = type;
        Logger.l("CARD AFTER HISTORY");
        Logger.a(this.history);
    }

    private void shuffleCards() {
        int i;
        this.deck = new byte[52];
        if (this.gameType == 2) {
            int cnt = 0;
            for (int i2 = 0; i2 < 4; i2 = (int)((byte)(i2 + 1))) {
                for (int j = 13; j < 26; j = (int)((byte)(j + 1))) {
                    this.deck[cnt] = j;
                    ++cnt;
                }
            }
        } else {
            for (i = 0; i < 52; i = (int)((byte)(i + 1))) {
                this.deck[i] = i;
            }
        }
        for (i = 51; i > 0; --i) {
            int index = RandomNum.getRandomUInt(i + 1);
            byte helper = this.deck[index];
            this.deck[index] = this.deck[i];
            this.deck[i] = helper;
        }
        this.deckCardPointer = 0;
    }

    private byte getNextCardFromDeck() {
        try {
            byte by = this.deckCardPointer;
            this.deckCardPointer = (byte)(by + 1);
            return this.deck[by];
        }
        catch (Exception exception) {
            return -100;
        }
    }

    private byte turnCard(boolean up, byte card) {
        if (up) {
            if (card <= 0) {
                if (this.gameType == 0) {
                    this.addScore(5);
                }
                if (card == -60) {
                    card = 0;
                    return card;
                }
                this.bTurend = true;
                card = (byte)(card * -1);
                return card;
            }
        } else if (card >= 0) {
            if (card == 0) {
                card = (byte)-60;
                return card;
            }
            this.bTurend = true;
            card = (byte)(card * -1);
            return card;
        }
        return card;
    }

    private byte getLastIndexInArray(int rowNum, byte[][] arr) {
        int hlp = 0;
        while (arr[rowNum][hlp] != -100 && (hlp = (int)((byte)(hlp + 1))) < arr[rowNum].length) {
        }
        if (hlp == 0) {
            return (byte)(hlp - 1);
        }
        return (byte)(hlp - 1);
    }

    private void nextCardInStackSolitaire() {
        this.solitaireStackPointer = (byte)(this.solitaireStackPointer + 1);
        if (this.solitaireStackPointer == this.gStackSolitaire.length) {
            this.solitaireStackPointer = 0;
            this.addScore(-100);
        }
        if (this.gStackSolitaire[this.solitaireStackPointer] == -100) {
            this.nextCardInStackSolitaire();
        }
        this.checkLastCardInStackSolitaire();
    }

    private void checkLastCardInStackSolitaire() {
        this.bLastCardInStackSolitaire = false;
        for (int i = this.solitaireStackPointer + 1; i < this.gStackSolitaire.length; ++i) {
            if (this.gStackSolitaire[i] == -100) continue;
            this.bLastCardInStackSolitaire = false;
            return;
        }
        this.bLastCardInStackSolitaire = true;
    }

    private void moveHand(byte direction) {
        if (this.selected) {
            this.handPositionCurrent[1] = (byte)(this.handPositionCurrent[1] - 1);
        }
        switch (direction) {
            case 0: {
                this.moveHandLeft();
                break;
            }
            case 1: {
                this.moveHandRight();
                break;
            }
            case 2: {
                this.moveHandUp();
                break;
            }
            case 3: {
                this.moveHandDown();
                break;
            }
        }
        if (this.selected) {
            this.handPositionCurrent[1] = (byte)(this.handPositionCurrent[1] + 1);
        }
        this.setHandPosition();
    }

    private void setHandYPos() {
        switch (this.gPos[this.handPositionCurrent[0]]) {
            case 3: {
                this.handPositionCurrent[1] = this.getLastIndexInArray(this.handPositionCurrent[0], this.gColumns);
                break;
            }
            case 2: {
                int pom = this.handPositionCurrent[0] - this.endStackPositionPosuv;
                this.handPositionCurrent[1] = this.getLastIndexInArray(pom, this.gEndStacks);
                break;
            }
            case 4: {
                this.handPositionCurrent[1] = 0;
                break;
            }
            case 0: {
                this.handPositionCurrent[1] = 0;
                break;
            }
            case 1: {
                this.handPositionCurrent[1] = 0;
                break;
            }
        }
    }

    private void moveHandLeft() {
        if (this.handPositionCurrent[0] > 0) {
            this.handPositionCurrent[0] = this.gPos[this.handPositionCurrent[0] - 1] == 5 ? (byte)(this.handPositionCurrent[0] - 2) : (byte)(this.handPositionCurrent[0] - 1);
            this.setHandYPos();
        } else if (this.gameType == 1) {
            this.handPositionCurrent[0] = 15;
        } else if (this.gameType == 0) {
            this.handPositionCurrent[0] = 14;
        } else if (this.gameType == 2) {
            this.handPositionCurrent[0] = 8;
        }
    }

    private void moveHandRight() {
        if (this.handPositionCurrent[0] == 8 && this.gameType == 2 || this.handPositionCurrent[0] == 15 && this.gameType == 1 || this.handPositionCurrent[0] == 14 && this.gameType == 0) {
            this.handPositionCurrent[0] = 0;
            this.setHandYPos();
            return;
        }
        if (this.handPositionCurrent[0] < this.gPos.length - 1) {
            if (this.gPos[this.handPositionCurrent[0] + 1] == 5) {
                if (this.gameType == 0 && this.handPositionCurrent[0] == 14) {
                    return;
                }
                this.handPositionCurrent[0] = (byte)(this.handPositionCurrent[0] + 2);
            } else {
                this.handPositionCurrent[0] = (byte)(this.handPositionCurrent[0] + 1);
            }
            this.setHandYPos();
        }
    }

    private void moveHandUp() {
        if (this.handPositionCurrent[0] < 8) {
            if (this.canMoveInColumn()) {
                this.handPositionCurrent[1] = (byte)(this.handPositionCurrent[1] - 1);
            } else {
                if (this.getSelectedCardsSize() > 1) {
                    return;
                }
                if (this.gameType == 0) {
                    this.handPositionCurrent[0] = this.handPositionCurrent[0] < 3 ? (this.gStackSolitaire[this.solitaireStackPointer] != -99 ? (this.handPositionCurrent[0] > 0 ? 9 : 8) : 8) : (byte)(this.handPositionCurrent[0] + 8);
                } else if (this.gameType == 1) {
                    this.handPositionCurrent[0] = (byte)(this.handPositionCurrent[0] + 8);
                } else if (this.gameType == 2 && !this.selected && this.spiderStackStep < 4) {
                    this.handPositionCurrent[0] = 8;
                }
                this.setHandYPos();
            }
        }
    }

    private void moveHandDown() {
        if (this.handPositionCurrent[0] > 7) {
            this.handPositionCurrent[0] = (byte)(this.handPositionCurrent[0] - 8);
            this.setHandYPos();
        } else if (this.handPositionCurrent[1] < this.getLastIndexInArray(this.handPositionCurrent[0], this.gColumns)) {
            this.handPositionCurrent[1] = (byte)(this.handPositionCurrent[1] + 1);
        }
    }

    private boolean canMoveInColumn() {
        if (this.selected) {
            return false;
        }
        if (this.gameType == 1) {
            if (this.handPositionCurrent[1] > 0) {
                return this.isCardLowerBy1(this.gColumns[this.handPositionCurrent[0]][this.handPositionCurrent[1] - 1], this.gColumns[this.handPositionCurrent[0]][this.handPositionCurrent[1]]) && this.isNextCardOppositeColor(this.gColumns[this.handPositionCurrent[0]][this.handPositionCurrent[1] - 1], this.gColumns[this.handPositionCurrent[0]][this.handPositionCurrent[1]]);
            }
        } else if (this.gameType == 2) {
            if (this.handPositionCurrent[1] > 0) {
                return this.isCardLowerBy1(this.gColumns[this.handPositionCurrent[0]][this.handPositionCurrent[1] - 1], this.gColumns[this.handPositionCurrent[0]][this.handPositionCurrent[1]]) && this.gColumns[this.handPositionCurrent[0]][this.handPositionCurrent[1] - 1] >= 0;
            }
        } else if (this.gameType == 0) {
            if (this.handPositionCurrent[1] > 0) {
                return this.gColumns[this.handPositionCurrent[0]][this.handPositionCurrent[1] - 1] >= 0;
            }
            return false;
        }
        return false;
    }

    private int getNumOfFreeCells() {
        int cnt = 0;
        for (int i = 0; i < this.gFreecells.length; ++i) {
            if (this.gFreecells[i] != -100) continue;
            ++cnt;
        }
        return cnt;
    }

    private boolean isRestrictedFreecellMoreCardsSelection(int cardsSelected) {
        if (this.gameType == 1) {
            switch (this.getNumOfFreeCells()) {
                case 3: {
                    if (cardsSelected <= 4) break;
                    return true;
                }
                case 2: {
                    if (cardsSelected <= 3) break;
                    return true;
                }
                case 1: {
                    if (cardsSelected <= 2) break;
                    return true;
                }
                case 0: {
                    if (cardsSelected <= 1) break;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean canSelectMoreCards() {
        int count = this.getLastIndexInArray(this.handPositionCurrent[0], this.gColumns) - this.handPositionCurrent[1];
        if (this.isRestrictedFreecellMoreCardsSelection(count + 1)) {
            return false;
        }
        for (int i = 0; i < count; ++i) {
            byte first = this.gColumns[this.handPositionCurrent[0]][this.handPositionCurrent[1] + i];
            byte next = this.gColumns[this.handPositionCurrent[0]][this.handPositionCurrent[1] + i + 1];
            if (this.gameType != 2 && !this.isNextCardOppositeColor(first, next)) {
                return false;
            }
            if (this.isCardLowerBy1(first, next)) continue;
            return false;
        }
        return true;
    }

    private boolean canPlaceCardEndStack(byte lstIdx) {
        if (lstIdx == -1) {
            for (int i = 0; i < Defs.CARD_A.length; ++i) {
                if (this.selectedCards[0] != Defs.CARD_A[i]) continue;
                return true;
            }
        } else if (this.gEndStacks[this.handPositionCurrent[0] - this.endStackPositionPosuv][lstIdx] + 1 == this.selectedCards[0]) {
            return true;
        }
        return false;
    }

    private boolean canPlaceCardColumn() {
        switch (this.gameType) {
            case 0: 
            case 1: {
                if (this.handPositionCurrent[1] == 0) {
                    for (int i = 0; i < Defs.CARD_K.length; ++i) {
                        if (this.selectedCards[0] != Defs.CARD_K[i]) continue;
                        return true;
                    }
                    return false;
                }
                if (!this.isCardLowerBy1(this.gColumns[this.handPositionCurrent[0]][this.handPositionCurrent[1] - 1], this.selectedCards[0]) || !this.isNextCardOppositeColor(this.gColumns[this.handPositionCurrent[0]][this.handPositionCurrent[1] - 1], this.selectedCards[0])) break;
                return true;
            }
            case 2: {
                if (this.handPositionCurrent[1] > 0) {
                    if (!this.isCardLowerBy1(this.gColumns[this.handPositionCurrent[0]][this.handPositionCurrent[1] - 1], this.selectedCards[0])) break;
                    return true;
                }
                return true;
            }
        }
        return false;
    }

    private boolean isRedCard(byte card) {
        return card >= 0 && card <= 12 || card >= 26 && card <= 38;
    }

    private boolean isBlackCard(byte card) {
        return !this.isRedCard(card);
    }

    private boolean isNextCardOppositeColor(byte start, byte next) {
        return this.isRedCard(start) != this.isRedCard(next);
    }

    private byte getCardSuit(byte card) {
        if (card <= 12) {
            return 0;
        }
        if (card <= 25) {
            return 1;
        }
        if (card <= 38) {
            return 2;
        }
        if (card <= 51) {
            return 3;
        }
        return -1;
    }

    private void turnCardInColumn() {
        if (this.handPositionOld[0] < 8 && this.handPositionOld[1] > 0) {
            this.gColumns[this.handPositionOld[0]][this.handPositionOld[1] - 1] = this.turnCard(true, this.gColumns[this.handPositionOld[0]][this.handPositionOld[1] - 1]);
        }
    }

    private boolean isCardLowerBy1(byte start, byte next) {
        int i;
        for (i = 0; i < 4; ++i) {
            if (Defs.CARD_A[i] != start) continue;
            return false;
        }
        if (next == start - 1) {
            return true;
        }
        switch (this.getCardSuit(start)) {
            case 0: {
                for (i = 1; i <= 3; ++i) {
                    if (next != start + i * 13 - 1) continue;
                    return true;
                }
                break;
            }
            case 1: {
                if (next == start - 14) {
                    return true;
                }
                if (next == start + 12) {
                    return true;
                }
                if (next != start + 25) break;
                return true;
            }
            case 2: {
                if (next == start + 12) {
                    return true;
                }
                if (next == start - 14) {
                    return true;
                }
                if (next != start - 27) break;
                return true;
            }
            case 3: {
                for (i = 1; i <= 3; ++i) {
                    if (next != start - i * 13 - 1) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    private void repairHandCoords() {
        if (this.handPositionCurrent[0] < 8) {
            this.handPositionCurrent[1] = this.getLastIndexInArray(this.handPositionCurrent[0], this.gColumns);
        }
    }

    private void setHandPosition() {
        if (this.handPositionCurrent[0] < 8) {
            if (this.handPositionCurrent[1] == -1) {
                this.handPositionX = this.rectSecondRow[this.handPositionCurrent[0]][0].x;
                this.handPositionY = this.rectSecondRow[this.handPositionCurrent[0]][0].y;
            } else {
                this.handPositionX = this.rectSecondRow[this.handPositionCurrent[0]][this.handPositionCurrent[1]].x;
                this.handPositionY = this.rectSecondRow[this.handPositionCurrent[0]][this.handPositionCurrent[1]].y;
            }
        } else {
            if (this.gameType == 0) {
                if (this.handPositionCurrent[0] == 8) {
                    this.handPositionX = this.rectFirstRow[0].x;
                } else if (this.handPositionCurrent[0] == 9) {
                    this.handPositionX = this.rectFirstRow[1].x;
                } else if (this.handPositionCurrent[0] == 11) {
                    this.handPositionX = this.rectFirstRow[2].x;
                } else if (this.handPositionCurrent[0] == 12) {
                    this.handPositionX = this.rectFirstRow[3].x;
                } else if (this.handPositionCurrent[0] == 13) {
                    this.handPositionX = this.rectFirstRow[4].x;
                } else if (this.handPositionCurrent[0] == 14) {
                    this.handPositionX = this.rectFirstRow[5].x;
                }
            } else if (this.gameType == 1) {
                this.handPositionX = this.rectFirstRow[this.handPositionCurrent[0] - 8].x;
            } else if (this.gameType == 2) {
                this.handPositionX = this.spiderStackStep < 4 ? this.rectFirstRow[0].x + (3 - this.spiderStackStep) * this.stackOffX : this.rectFirstRow[0].x;
            }
            this.handPositionY = this.firstRowY;
        }
    }

    public void keyReleased(int keyCode) {
        block0 : switch (this.gameScreen.subScreen) {
            case 0: {
                if (this.bInstructionFromPause) {
                    if (!Keys.isFKRightCode(keyCode)) break;
                    this.gameScreen.getClass();
                    this.gameScreen.nextScreen(2, 3);
                    this.gameScreen.bAnimationIn = true;
                    this.iTutorialShiftY = 0;
                    this.bInstructionFromPause = false;
                    break;
                }
                if (!Keys.isFKLeftCode(keyCode)) break;
                this.iTutorialShiftY = 0;
                this.gameScreen.getClass();
                this.gameScreen.nextScreen(2, 1);
                break;
            }
            case 1: {
                if (!this.gameScreen.bStart) {
                    if (Keys.isActionGeneratedByKey(3, keyCode)) {
                        this.moveHand((byte)0);
                        break;
                    }
                    if (Keys.isActionGeneratedByKey(4, keyCode)) {
                        this.moveHand((byte)1);
                        break;
                    }
                    if (Keys.isActionGeneratedByKey(1, keyCode)) {
                        this.moveHand((byte)2);
                        break;
                    }
                    if (Keys.isActionGeneratedByKey(2, keyCode)) {
                        this.moveHand((byte)3);
                        break;
                    }
                    if (Keys.isActionGeneratedByKey(5, keyCode)) {
                        this.doActionFire();
                        break;
                    }
                    if (Keys.isFKLeftCode(keyCode)) {
                        this.undo();
                        break;
                    }
                    if (!Keys.isFKRightCode(keyCode)) break;
                    this.gameScreen.bAnimationIn = true;
                    this.gameScreen.playMusic(Sounds.MUSIC_MENU, -1);
                    this.gameScreen.getClass();
                    this.gameScreen.nextScreen(2, 3);
                    this.saveGame();
                    break;
                }
                if (!Keys.isFKLeftCode(keyCode)) break;
                this.iTutorialShiftY = 0;
                this.gameScreen.bStart = false;
                this.gameScreen.playMusic(Sounds.MUSIC_GAME, -1);
                break;
            }
            case 3: {
                if (Keys.isActionGeneratedByKey(1, keyCode)) {
                    this.gameScreen.changeSelectedMenuItem(-1);
                    break;
                }
                if (Keys.isActionGeneratedByKey(2, keyCode)) {
                    this.gameScreen.changeSelectedMenuItem(1);
                    break;
                }
                if (Keys.isFKRightCode(keyCode)) {
                    this.gameScreen.getClass();
                    this.gameScreen.nextScreen(2, 1);
                    this.gameScreen.playMusic(Sounds.MUSIC_GAME, -1);
                    break;
                }
                if (Keys.isFKLeftCode(keyCode)) {
                    this.gameScreen.changeSound();
                    break;
                }
                if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                switch (this.gameScreen.iSelectedMenuItem) {
                    case 0: {
                        this.bInstructionFromPause = true;
                        this.gameScreen.getClass();
                        this.gameScreen.nextScreen(2, 0);
                        break block0;
                    }
                    case 1: {
                        this.bRestart = true;
                        this.gameScreen.bStart = true;
                        this.gameScreen.sTextTitle = Resources.resTexts[0].getHashedString(35);
                        this.gameScreen.setTitleCenter(this.gameScreen.sTextTitle);
                        this.gameScreen.getClass();
                        this.gameScreen.nextScreen(2, 4);
                        break block0;
                    }
                    case 2: {
                        this.gameScreen.sTextTitle = Resources.resTexts[0].getHashedString(14);
                        this.gameScreen.setTitleCenter(this.gameScreen.sTextTitle);
                        this.gameScreen.getClass();
                        this.gameScreen.nextScreen(2, 4);
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                if (Keys.isFKRightCode(keyCode)) {
                    this.gameScreen.playMusic(Sounds.MUSIC_MENU, -1);
                    this.gameScreen.getClass();
                    this.gameScreen.getClass();
                    this.gameScreen.nextScreen(1, 0);
                    break;
                }
                if (!Keys.isFKLeftCode(keyCode)) break;
                this.initGame(this.gameType);
                this.gameScreen.playMusic(Sounds.MUSIC_GAME, -1);
                this.gameScreen.getClass();
                this.gameScreen.nextScreen(2, 1);
                this.bRestart = false;
                break;
            }
            case 4: {
                if (Keys.isFKLeftCode(keyCode)) {
                    if (this.bRestart) {
                        this.initGame(this.gameType);
                        this.gameScreen.getClass();
                        this.gameScreen.nextScreen(2, 1);
                        this.bRestart = false;
                        break;
                    }
                    if (this.bContinueSavedGame) {
                        this.bContinueSavedGame = false;
                        this.loadGame(this.getSavedGameType());
                        this.gameScreen.playMusic(Sounds.MUSIC_GAME, -1);
                        this.gameScreen.getClass();
                        this.gameScreen.nextScreen(2, 1);
                        break;
                    }
                    this.gameScreen.getClass();
                    this.gameScreen.getClass();
                    this.gameScreen.nextScreen(1, 0);
                    break;
                }
                if (!Keys.isFKRightCode(keyCode)) break;
                if (!this.bContinueSavedGame) {
                    this.gameScreen.bAnimationIn = true;
                    this.gameScreen.getClass();
                    this.gameScreen.nextScreen(2, 3);
                    this.bRestart = false;
                    break;
                }
                this.bContinueSavedGame = false;
                this.initGame(this.gameType);
                this.gameScreen.bStart = true;
                this.gameScreen.getClass();
                this.gameScreen.nextScreen(2, 1);
                this.bRestart = false;
                break;
            }
        }
    }

    public void pointerPressed(int x, int y) {
        if (!this.gameScreen.bStart) {
            this.handPositionX = x - this.iCardCenterX;
            this.handPositionY = y - this.iCardCenterY;
            this.selected = false;
            this.bBack = false;
            if (x >= 0 && x <= this.rectFirstRow[0].x + this.rectFirstRow[0].width + (this.cardsOffW >> 1) && y >= 0 && y <= this.rectFirstRow[0].y + this.rectFirstRow[0].height + (this.cardsOffsetY >> 1)) {
                this.selected = false;
                this.handPositionCurrent[0] = 8;
                this.doActionFire();
                return;
            }
            for (int i = 1; i < this.rectFirstRow.length; ++i) {
                if (x < this.rectFirstRow[i].x - (this.cardsOffW >> 1) || x > this.rectFirstRow[i].x + this.rectFirstRow[i].width + (this.cardsOffW >> 1) || y < this.rectFirstRow[i].y - (this.cardsOffsetY >> 1) || y > this.rectFirstRow[i].y + this.rectFirstRow[i].height + (this.cardsOffsetY >> 1)) continue;
                this.selected = false;
                int off = 0;
                if (this.gameType == 0 && i > 1) {
                    ++off;
                }
                this.handPositionCurrent[0] = (byte)(i + 8 + off);
                if (i > 1 && this.gameType == 0) {
                    this.handPositionCurrent[1] = this.getLastIndexInArray(i - 2, this.gEndStacks);
                }
                if (i > 3 && this.gameType == 1) {
                    this.handPositionCurrent[1] = this.getLastIndexInArray(i - 4, this.gEndStacks);
                }
                this.doActionFire();
                return;
            }
            boolean bFound = false;
            for (int i = 0; i < this.rectSecondRow.length; ++i) {
                for (int j = 0; j < this.rectSecondRow[i].length; ++j) {
                    if (!this.rectSecondRow[i][j].contains(x, y) || this.gColumns[i][j] == -100) continue;
                    this.handPositionCurrent[0] = (byte)i;
                    this.handPositionCurrent[1] = (byte)j;
                    bFound = true;
                }
            }
            if (bFound) {
                this.doActionFire();
            }
        }
    }

    public void pointerDragged(int x, int y) {
        if (!this.gameScreen.bStart) {
            this.handPositionX = x - this.iCardCenterX;
            this.handPositionY = y - this.iCardCenterY;
            if (!(y > this.cardsOffsetY && x > this.cardsOffW && y < MainCanvas.HEIGHT - this.cardsOffsetY && x < MainCanvas.WIDTH - this.cardsOffW || this.bBack)) {
                this.selected = false;
                this.bBack = true;
                this.addCardBackToOldPosition();
            }
        }
    }

    public void pointerReleased(int x, int y) {
        Logger.l("released x: " + x + " y: " + y);
        switch (this.gameScreen.subScreen) {
            case 0: {
                if (this.bInstructionFromPause) {
                    if (!this.gameScreen.isRightButtonPressed(x, y)) break;
                    this.gameScreen.getClass();
                    this.gameScreen.nextScreen(2, 3);
                    this.gameScreen.bAnimationIn = true;
                    this.iTutorialShiftY = 0;
                    this.bInstructionFromPause = false;
                    break;
                }
                if (!this.gameScreen.isLeftButtonPressed(x, y)) break;
                this.iTutorialShiftY = 0;
                this.gameScreen.getClass();
                this.gameScreen.nextScreen(2, 1);
                break;
            }
            case 1: {
                if (!this.gameScreen.bStart) {
                    int i;
                    if (!this.selected) {
                        if (this.gameScreen.isLeftButtonPressed(x, y)) {
                            this.undo();
                            return;
                        }
                        if (this.gameScreen.isRightButtonPressed(x, y)) {
                            this.gameScreen.bAnimationIn = true;
                            this.gameScreen.playMusic(Sounds.MUSIC_MENU, -1);
                            this.gameScreen.getClass();
                            this.gameScreen.nextScreen(2, 3);
                            this.saveGame();
                            return;
                        }
                    }
                    if (!this.selected) break;
                    this.bBack = false;
                    this.handPositionX = x - this.iCardCenterX;
                    this.handPositionY = y - this.iCardCenterY;
                    for (i = 0; i < this.rectFirstRow.length; ++i) {
                        if (!this.rectFirstRow[i].contains(x, y)) continue;
                        int off = 0;
                        if (i > 1 && this.gameType == 0) {
                            ++off;
                        }
                        this.handPositionCurrent[0] = (byte)(i + 8 + off);
                        if (i > 1 && this.gameType == 0) {
                            this.handPositionCurrent[1] = this.getLastIndexInArray(i - 2, this.gEndStacks);
                        }
                        if (i > 3 && this.gameType == 1) {
                            this.handPositionCurrent[1] = this.getLastIndexInArray(i - 4, this.gEndStacks);
                        }
                        if (this.handPositionCurrent[0] == 8 && (this.gameType == 0 || this.gameType == 2)) continue;
                        this.doActionFire();
                        return;
                    }
                    for (i = 0; i < this.rectSecondRow.length; ++i) {
                        for (int j = 0; j < this.rectSecondRow[i].length; ++j) {
                            if (!this.rectSecondRow[i][j].contains(x, y)) continue;
                            this.handPositionCurrent[0] = (byte)i;
                            this.handPositionCurrent[1] = (byte)(this.getLastIndexInArray(i, this.gColumns) + 1);
                            this.doActionFire();
                            return;
                        }
                    }
                    Logger.l("volam back");
                    this.addCardBackToOldPosition();
                    this.selected = false;
                    break;
                }
                if (!this.gameScreen.isLeftButtonPressed(x, y)) break;
                this.iTutorialShiftY = 0;
                this.gameScreen.bStart = false;
                this.gameScreen.playMusic(Sounds.MUSIC_GAME, -1);
                break;
            }
            case 3: {
                if (this.gameScreen.isRightButtonPressed(x, y)) {
                    this.gameScreen.getClass();
                    this.gameScreen.nextScreen(2, 1);
                    this.gameScreen.playMusic(Sounds.MUSIC_GAME, -1);
                } else if (this.gameScreen.isLeftButtonPressed(x, y)) {
                    this.gameScreen.changeSound();
                }
                block15: for (int i = 0; i < rectPauseItems.length; ++i) {
                    if (!rectPauseItems[i].contains(x, y)) continue;
                    this.gameScreen.iSelectedMenuItem = i;
                    switch (this.gameScreen.iSelectedMenuItem) {
                        case 0: {
                            this.bInstructionFromPause = true;
                            this.gameScreen.getClass();
                            this.gameScreen.nextScreen(2, 0);
                            continue block15;
                        }
                        case 1: {
                            this.bRestart = true;
                            this.gameScreen.bStart = true;
                            this.gameScreen.sTextTitle = Resources.resTexts[0].getHashedString(35);
                            this.gameScreen.setTitleCenter(this.gameScreen.sTextTitle);
                            this.gameScreen.getClass();
                            this.gameScreen.nextScreen(2, 4);
                            continue block15;
                        }
                        case 2: {
                            this.gameScreen.sTextTitle = Resources.resTexts[0].getHashedString(14);
                            this.gameScreen.setTitleCenter(this.gameScreen.sTextTitle);
                            this.gameScreen.getClass();
                            this.gameScreen.nextScreen(2, 4);
                            continue block15;
                        }
                    }
                }
                break;
            }
            case 2: {
                if (this.gameScreen.isRightButtonPressed(x, y)) {
                    this.gameScreen.playMusic(Sounds.MUSIC_MENU, -1);
                    this.gameScreen.getClass();
                    this.gameScreen.getClass();
                    this.gameScreen.nextScreen(1, 0);
                    break;
                }
                if (!this.gameScreen.isLeftButtonPressed(x, y)) break;
                this.initGame(this.gameType);
                this.gameScreen.playMusic(Sounds.MUSIC_GAME, -1);
                this.gameScreen.getClass();
                this.gameScreen.nextScreen(2, 1);
                this.bRestart = false;
                break;
            }
            case 4: {
                if (this.gameScreen.isLeftButtonPressed(x, y)) {
                    if (this.bRestart) {
                        this.initGame(this.gameType);
                        this.gameScreen.getClass();
                        this.gameScreen.nextScreen(2, 1);
                        this.bRestart = false;
                        break;
                    }
                    if (this.bContinueSavedGame) {
                        this.bContinueSavedGame = false;
                        this.gameScreen.playMusic(Sounds.MUSIC_GAME, -1);
                        this.gameScreen.getClass();
                        this.gameScreen.nextScreen(2, 1);
                        break;
                    }
                    this.gameScreen.getClass();
                    this.gameScreen.getClass();
                    this.gameScreen.nextScreen(1, 0);
                    break;
                }
                if (!this.gameScreen.isRightButtonPressed(x, y)) break;
                if (!this.bContinueSavedGame) {
                    this.gameScreen.bAnimationIn = true;
                    this.gameScreen.getClass();
                    this.gameScreen.nextScreen(2, 3);
                    this.bRestart = false;
                    break;
                }
                this.bContinueSavedGame = false;
                this.initGame(this.gameType);
                this.gameScreen.bStart = true;
                this.gameScreen.getClass();
                this.gameScreen.nextScreen(2, 1);
                this.bRestart = false;
                break;
            }
        }
    }

    private void doActionFire() {
        Logger.l("HPC: " + this.handPositionCurrent[0] + " " + this.handPositionCurrent[1]);
        Logger.l("HPO: " + this.handPositionOld[0] + " " + this.handPositionOld[1]);
        this.bTurend = false;
        if (this.selected) {
            if (this.gameType == 0) {
                this.actionEndSolitaire();
            } else if (this.gameType == 2) {
                this.actionEndSpider();
                this.checkRemoveCards();
            } else if (this.gameType == 1) {
                this.actionEndFreecell();
            }
            this.selected = false;
            this.repairHandCoords();
            this.setHandPosition();
            this.checkGameOver();
        } else if (this.gameType == 0) {
            this.actionSolitaire();
        } else if (this.gameType == 2) {
            this.actionSpider();
        } else if (this.gameType == 1) {
            this.actionFreecell();
        }
    }

    private void checkGameOver() {
        for (int i = 0; i < this.gColumns.length; ++i) {
            if (this.gColumns[i][0] == -100) continue;
            return;
        }
        this.gameOver();
    }

    private void gameOver() {
        this.gameScreen.playMusic(Sounds.MUSIC_GAMEOVER, 1);
        this.gameScreen.getClass();
        this.gameScreen.nextScreen(2, 2);
    }

    private void checkRemoveCards() {
        this.bRemove = false;
        for (int i = 0; i < this.gColumns.length; ++i) {
            for (int j = 0; j < this.gColumns[i].length; ++j) {
                int k;
                if (this.gColumns[i][j] != 25) continue;
                boolean pom = true;
                for (k = 1; k < 13; ++k) {
                    if (this.gColumns[i][j + k] == 25 - k) continue;
                    pom = false;
                }
                if (!pom) continue;
                this.addScore(100);
                for (k = 0; k < 13; ++k) {
                    this.gColumns[i][j + k] = -100;
                }
                if (j <= 0) continue;
                this.gColumns[i][j - 1] = this.turnCard(true, this.gColumns[i][j - 1]);
            }
        }
    }

    private void selectCardFromColumns() {
        byte topIdx = this.getLastIndexInArray(this.handPositionCurrent[0], this.gColumns);
        if (topIdx != -1) {
            if (this.handPositionCurrent[1] == topIdx) {
                this.setSelectedCards(new byte[]{this.gColumns[this.handPositionCurrent[0]][topIdx]});
                this.gColumns[this.handPositionCurrent[0]][topIdx] = -100;
                this.setSelectedCardOldPosition();
            } else if (this.handPositionCurrent[1] < topIdx && this.canSelectMoreCards()) {
                int cout = topIdx - this.handPositionCurrent[1] + 1;
                byte[] tmp = new byte[cout];
                for (int i = 0; i < cout; ++i) {
                    tmp[i] = this.gColumns[this.handPositionCurrent[0]][this.handPositionCurrent[1] + i];
                    this.gColumns[this.handPositionCurrent[0]][this.handPositionCurrent[1] + i] = -100;
                }
                this.setSelectedCards(tmp);
                this.setSelectedCardOldPosition();
            }
        }
    }

    private void selectCardFromEndStack() {
        byte topIdx = this.getLastIndexInArray(this.handPositionCurrent[0] - this.endStackPositionPosuv, this.gEndStacks);
        if (topIdx != -1) {
            this.setSelectedCards(new byte[]{this.gEndStacks[this.handPositionCurrent[0] - this.endStackPositionPosuv][topIdx]});
            this.gEndStacks[this.handPositionCurrent[0] - this.endStackPositionPosuv][topIdx] = -100;
            this.setSelectedCardOldPosition();
        }
    }

    private void insertCardToEndStack() {
        if (this.getSelectedCardsSize() > 1) {
            this.addCardBackToOldPosition();
        } else {
            byte lstIdx = this.getLastIndexInArray(this.handPositionCurrent[0] - this.endStackPositionPosuv, this.gEndStacks);
            if (this.canPlaceCardEndStack(lstIdx)) {
                if ((this.gameType == 1 || this.gameType == 0) && this.handPositionCurrent[0] != this.handPositionOld[0]) {
                    this.addScore(10);
                }
                if (lstIdx == -1) {
                    lstIdx = 0;
                    this.gEndStacks[this.handPositionCurrent[0] - this.endStackPositionPosuv][lstIdx] = this.selectedCards[0];
                } else {
                    this.gEndStacks[this.handPositionCurrent[0] - this.endStackPositionPosuv][lstIdx + 1] = this.selectedCards[0];
                }
                this.turnCardInColumn();
                if (this.gameType == 0 && (this.handPositionOld[0] == 8 || this.handPositionOld[0] == 9)) {
                    if (this.handPositionCurrent[0] != this.handPositionOld[0]) {
                        this.addMoveToHistory((byte)1, true);
                    }
                    if (this.solitaireStackPointer > 0) {
                        this.solitaireStackPointer = (byte)(this.solitaireStackPointer - 1);
                    }
                    return;
                }
                if (this.handPositionCurrent[0] != this.handPositionOld[0]) {
                    this.addMoveToHistory((byte)1, false);
                }
            } else {
                this.addCardBackToOldPosition();
            }
        }
    }

    private void insertCardsToColumn() {
        if (this.canPlaceCardColumn()) {
            if (this.gameType == 2) {
                this.addScore(-1);
            }
            if (this.gameType == 0 && this.handPositionOld[0] > 10) {
                this.addScore(-15);
            }
            for (int i = 0; i < this.getSelectedCardsSize(); ++i) {
                this.gColumns[this.handPositionCurrent[0]][this.handPositionCurrent[1] + i] = this.selectedCards[i];
            }
            if (this.gameType == 0 || this.gameType == 2) {
                this.turnCardInColumn();
            }
            if (this.gameType == 0 && (this.handPositionOld[0] == 8 || this.handPositionOld[0] == 9)) {
                this.addMoveToHistory((byte)0, true);
                if (this.solitaireStackPointer > 0) {
                    this.solitaireStackPointer = (byte)(this.solitaireStackPointer - 1);
                }
                this.addScore(5);
                return;
            }
            if (this.handPositionCurrent[0] != this.handPositionOld[0]) {
                this.addMoveToHistory((byte)0, false);
            }
        } else {
            this.addCardBackToOldPosition();
        }
    }

    private void actionSolitaire() {
        Logger.mS("actionSolitaire");
        if (this.handPositionCurrent[0] == 8) {
            this.nextCardInStackSolitaire();
            this.handPositionOld[0] = 8;
        } else if (this.handPositionCurrent[0] == 9) {
            if (this.gStackSolitaire[this.solitaireStackPointer] != -99) {
                this.setSelectedCards(new byte[]{this.gStackSolitaire[this.solitaireStackPointer]});
                this.gStackSolitaire[this.solitaireStackPointer] = -100;
                this.setSelectedCardOldPosition();
            }
        } else if (this.handPositionCurrent[0] > 10) {
            this.selectCardFromEndStack();
        } else if (this.handPositionCurrent[0] < 8) {
            this.selectCardFromColumns();
        }
    }

    private void actionEndSolitaire() {
        if (this.handPositionCurrent[0] == 8 || this.handPositionCurrent[0] == 9) {
            this.addCardBackToOldPosition();
        } else if (this.handPositionCurrent[0] > 10) {
            this.insertCardToEndStack();
        } else if (this.handPositionCurrent[0] < 8) {
            this.insertCardsToColumn();
        }
        this.setSelectedCards(null);
    }

    private void actionFreecell() {
        if (this.handPositionCurrent[0] > 7 && this.handPositionCurrent[0] < 12) {
            if (this.gFreecells[this.handPositionCurrent[0] - 8] != -100) {
                this.setSelectedCards(new byte[]{this.gFreecells[this.handPositionCurrent[0] - 8]});
                this.gFreecells[this.handPositionCurrent[0] - 8] = -100;
                this.setSelectedCardOldPosition();
            }
        } else if (this.handPositionCurrent[0] > 11) {
            this.selectCardFromEndStack();
        } else if (this.handPositionCurrent[0] < 8) {
            this.selectCardFromColumns();
        }
    }

    private void actionEndFreecell() {
        if (this.handPositionCurrent[0] > 11) {
            this.insertCardToEndStack();
        } else if (this.handPositionCurrent[0] < 8) {
            this.insertCardsToColumn();
        } else if (this.gFreecells[this.handPositionCurrent[0] - 8] == -100) {
            this.gFreecells[this.handPositionCurrent[0] - 8] = this.selectedCards[0];
            this.addMoveToHistory((byte)2, false);
        } else {
            this.addCardBackToOldPosition();
        }
        this.setSelectedCards(null);
    }

    private void actionSpider() {
        if (this.handPositionCurrent[0] == 8) {
            if (this.canInsertFromSpiderStack()) {
                this.insertCardsFromSpiderStack();
                this.setHandPosition();
            }
        } else {
            this.selectCardFromColumns();
        }
    }

    private boolean canInsertFromSpiderStack() {
        for (int i = 0; i < this.gColumns.length; ++i) {
            if (this.gColumns[i][0] != -100) continue;
            return false;
        }
        return true;
    }

    private void actionEndSpider() {
        if (this.handPositionCurrent[0] < 8) {
            this.insertCardsToColumn();
        }
        this.setSelectedCards(null);
    }

    private void insertCardsFromSpiderStack() {
        if (this.spiderStackStep > 3) {
            return;
        }
        for (int i = 0; i < this.gColumns.length; ++i) {
            int pointer = i + this.spiderStackStep * this.gColumns.length;
            if (pointer >= this.gStackSpider.length) {
                ++this.spiderStackStep;
                this.addMoveToHistory((byte)3, false);
                return;
            }
            this.gColumns[i][this.getLastIndexInArray((int)i, (byte[][])this.gColumns) + 1] = this.gStackSpider[pointer];
            this.gStackSpider[pointer] = -100;
        }
        ++this.spiderStackStep;
        this.addMoveToHistory((byte)3, false);
    }

    private void insertCardsBackToSpiderStack() {
        --this.spiderStackStep;
        if (this.spiderStackStep < 0) {
            this.spiderStackStep = 0;
        }
        if (this.spiderStackStep == 3) {
            for (int i = 0; i < 3; ++i) {
                int pointer = i + this.spiderStackStep * this.gColumns.length;
                this.gStackSpider[pointer] = this.gColumns[i][this.getLastIndexInArray(i, this.gColumns)];
                this.gColumns[i][this.getLastIndexInArray((int)i, (byte[][])this.gColumns)] = -100;
            }
        } else {
            for (int i = 0; i < this.gColumns.length; ++i) {
                int pointer = i + this.spiderStackStep * this.gColumns.length;
                this.gStackSpider[pointer] = this.gColumns[i][this.getLastIndexInArray(i, this.gColumns)];
                this.gColumns[i][this.getLastIndexInArray((int)i, (byte[][])this.gColumns)] = -100;
            }
        }
    }

    private void addCardBackToOldPosition() {
        switch (this.gameType) {
            case 0: {
                if (this.handPositionOld[0] == 9) {
                    this.gStackSolitaire[this.solitaireStackPointer] = this.selectedCards[0];
                    break;
                }
                if (this.handPositionOld[0] > 10) {
                    Logger.l("tu idem vlozit");
                    Logger.l("HPO0 " + this.handPositionOld[0]);
                    Logger.l("HPO1 " + this.handPositionOld[1]);
                    this.gEndStacks[this.handPositionOld[0] - this.endStackPositionPosuv][this.getLastIndexInArray((int)(this.handPositionOld[0] - this.endStackPositionPosuv), (byte[][])this.gEndStacks) + 1] = this.selectedCards[0];
                    break;
                }
                if (this.handPositionOld[0] >= 8) break;
                for (int i = 0; i < this.getSelectedCardsSize(); ++i) {
                    this.gColumns[this.handPositionOld[0]][this.handPositionOld[1] + i] = this.selectedCards[i];
                }
                break;
            }
            case 1: {
                if (this.handPositionOld[0] < 8) {
                    for (int i = 0; i < this.getSelectedCardsSize(); ++i) {
                        this.gColumns[this.handPositionOld[0]][this.handPositionOld[1] + i] = this.selectedCards[i];
                    }
                    break;
                }
                if (this.handPositionOld[0] < 12) {
                    this.gFreecells[this.handPositionOld[0] - 8] = this.selectedCards[0];
                    break;
                }
                this.gEndStacks[this.handPositionOld[0] - this.endStackPositionPosuv][this.getLastIndexInArray((int)(this.handPositionOld[0] - this.endStackPositionPosuv), (byte[][])this.gEndStacks) + 1] = this.selectedCards[0];
                break;
            }
            case 2: {
                if (this.handPositionOld[0] >= 8) break;
                for (int i = 0; i < this.getSelectedCardsSize(); ++i) {
                    this.gColumns[this.handPositionOld[0]][this.handPositionOld[1] + i] = this.selectedCards[i];
                }
                break;
            }
        }
    }

    private void setSelectedCards(byte[] cards) {
        if (cards != null) {
            int i;
            for (i = 0; i < cards.length; ++i) {
                this.selectedCards[i] = cards[i];
            }
            for (i = cards.length; i < this.selectedCards.length; ++i) {
                this.selectedCards[i] = -100;
            }
            this.selected = true;
        } else {
            for (int i = 0; i < this.selectedCards.length; ++i) {
                this.selectedCards[i] = -100;
            }
        }
    }

    private int getSelectedCardsSize() {
        int i = 0;
        while (this.selectedCards[i] != -100 && i <= this.selectedCards.length) {
            if (++i < this.selectedCards.length) continue;
            return i;
        }
        return i;
    }

    private void setSelectedCardOldPosition() {
        System.arraycopy(this.handPositionCurrent, 0, this.handPositionOld, 0, this.handPositionCurrent.length);
    }

    private void addScore(int add) {
        this.score += add;
        if (this.score < 0) {
            this.score = 0;
        }
    }

    public void update(long dt) {
        switch (this.gameScreen.subScreen) {
            case 1: {
                if (this.gameScreen.bLoading) break;
                if (!this.gameScreen.bStart) {
                    this.updateTimer(dt);
                    break;
                }
                if (this.iTextShiftY < 0) {
                    Logger.l("DACO UPDATE2");
                    if (this.iTutorialShiftY > 0) {
                        this.iTutorialShiftY += this.iTextShiftY;
                        if (this.iTutorialShiftY <= 0) {
                            this.iTutorialShiftY = 0;
                            this.iTextShiftY = 0;
                        } else if (this.gameScreen.bDragInstructions) {
                            this.iTextShiftY = 0;
                        } else {
                            this.iTextShiftY += MainCanvas.HEIGHT >> 6;
                            if (this.iTextShiftY > 0) {
                                this.iTextShiftY = 0;
                            }
                        }
                    } else {
                        this.iTextShiftY = 0;
                    }
                }
                if (this.iTextShiftY <= 0) break;
                if (this.iTutorialShiftY < this.iTutorialMaxShiftY) {
                    this.iTutorialShiftY += this.iTextShiftY;
                    if (this.iTutorialShiftY >= this.iTutorialMaxShiftY) {
                        this.iTutorialShiftY = this.iTutorialMaxShiftY;
                        this.iTextShiftY = 0;
                        break;
                    }
                    if (this.gameScreen.bDragInstructions) {
                        this.iTextShiftY = 0;
                        break;
                    }
                    this.iTextShiftY -= MainCanvas.HEIGHT >> 6;
                    if (this.iTextShiftY >= 0) break;
                    this.iTextShiftY = 0;
                    break;
                }
                this.iTextShiftY = 0;
                break;
            }
            case 0: {
                if (this.iTextShiftY < 0) {
                    Logger.l("DACO UPDATE2");
                    if (this.iTutorialShiftY > 0) {
                        this.iTutorialShiftY += this.iTextShiftY;
                        if (this.iTutorialShiftY <= 0) {
                            this.iTutorialShiftY = 0;
                            this.iTextShiftY = 0;
                        } else if (this.gameScreen.bDragInstructions) {
                            this.iTextShiftY = 0;
                        } else {
                            this.iTextShiftY += MainCanvas.HEIGHT >> 6;
                            if (this.iTextShiftY > 0) {
                                this.iTextShiftY = 0;
                            }
                        }
                    } else {
                        this.iTextShiftY = 0;
                    }
                }
                if (this.iTextShiftY <= 0) break;
                Logger.l("DACO UPDATE3");
                if (this.iTutorialShiftY < this.iTutorialMaxShiftY) {
                    this.iTutorialShiftY += this.iTextShiftY;
                    if (this.iTutorialShiftY >= this.iTutorialMaxShiftY) {
                        this.iTutorialShiftY = this.iTutorialMaxShiftY;
                        this.iTextShiftY = 0;
                        break;
                    }
                    if (this.gameScreen.bDragInstructions) {
                        this.iTextShiftY = 0;
                        break;
                    }
                    this.iTextShiftY -= MainCanvas.HEIGHT >> 6;
                    if (this.iTextShiftY >= 0) break;
                    this.iTextShiftY = 0;
                    break;
                }
                this.iTextShiftY = 0;
                break;
            }
            case 3: {
                this.gameScreen.updateAnimIn();
                this.gameScreen.updateAnimOut();
                this.gameScreen.updateShift();
                break;
            }
            case 2: {
                if (this.iGameOverStep >= 4) break;
                this.iGameOverStepTime = (int)((long)this.iGameOverStepTime + dt);
                if (this.iGameOverStepTime <= this.iGameOverStepTick) break;
                this.iGameOverStepTime = 0;
                ++this.iGameOverStep;
                break;
            }
        }
        this.iScoreTextW = this.gameScreen.fontNumbers.stringWidth(Integer.toString(this.score).toCharArray());
        this.iBottomTextLeftX = (MainCanvas.WIDTH >> 1) - this.iScoreTextW - (this.gameScreen.imgSmallScore.getWidth() >> 1);
    }

    public boolean isPressedTutorialText(int x, int y) {
        return x > (MainCanvas.WIDTH >> 1) - (this.iTutorialW >> 1) && x < (MainCanvas.WIDTH >> 1) + (this.iTutorialW >> 1) && y > this.iTutorialCenterY - (this.iTutorialH >> 1) && y < this.iTutorialCenterY + (this.iTutorialH >> 1);
    }

    private void updateTimer(long dt) {
        this.playedSec += dt;
        this.calculateTime();
    }

    private void calculateTime() {
        this.sec = (int)(this.playedSec / 1000L);
        this.time = "" + this.sec;
    }

    private void paintBg(Graphics g) {
        g.drawImage(this.gameScreen.imgBackgrounds[this.gameType], 0, 0, 20);
    }

    public void paint(Graphics g) {
        this.paintBg(g);
        switch (this.gameScreen.subScreen) {
            case 1: {
                if (this.gameScreen.bLoading) break;
                if (!this.gameScreen.bStart) {
                    this.paintCards(g);
                    this.paintHand(g);
                    this.paintBottomPanel(g);
                    break;
                }
                this.paintTutorial(g);
                this.gameScreen.paintControls(g);
                break;
            }
            case 0: {
                this.paintTutorial(g);
                this.gameScreen.paintControls(g);
                break;
            }
            case 2: {
                this.paintGameOver(g);
                this.gameScreen.paintControls(g);
                break;
            }
            case 3: {
                this.gameScreen.paintControls(g);
                this.paintPause(g);
                break;
            }
            case 4: {
                this.gameScreen.paintButton2(g, this.gameScreen.rectTitleCenter);
                break;
            }
        }
    }

    private void paintGameOver(Graphics g) {
        this.gameScreen.paintTable(g, this.gameScreen.sprSkin, MainCanvas.WIDTH >> 1, this.iCenterGameOverY, this.iGameOverW, this.iGameOverH);
        if (this.iGameOverStep > 0) {
            this.gameScreen.fontMain.drawString(g, Resources.resTexts[0].getHashedString(21).toCharArray(), MainCanvas.WIDTH >> 1, this.iCenterGameOverY - (this.iGameOverH >> 1) + (this.gameScreen.fontMain.getHeight() << 1), 17);
        }
        if (this.iGameOverStep > 1) {
            g.drawImage(this.gameScreen.imgSmallTime, (MainCanvas.WIDTH >> 1) - (this.gameScreen.imgSmallTime.getWidth() >> 1) - this.gameScreen.imgSmallTime.getWidth() - (this.gameScreen.fontNumbers.stringWidth(this.time.toCharArray()) >> 1), this.iCenterGameOverY - this.gameScreen.imgSmallScore.getHeight(), 20);
            this.gameScreen.fontNumbers.drawString(g, this.time.toCharArray(), (MainCanvas.WIDTH >> 1) - (this.gameScreen.fontNumbers.stringWidth(this.time.toCharArray()) >> 1), this.iCenterGameOverY - this.gameScreen.imgSmallScore.getHeight(), 20);
            g.drawImage(this.gameScreen.imgSmallScore, (MainCanvas.WIDTH >> 1) - (this.gameScreen.imgSmallTime.getWidth() >> 1) - this.gameScreen.imgSmallTime.getWidth() - (this.gameScreen.fontNumbers.stringWidth(this.time.toCharArray()) >> 1), this.iCenterGameOverY + this.gameScreen.imgSmallScore.getHeight(), 20);
            this.gameScreen.fontNumbers.drawString(g, ("" + this.score).toCharArray(), (MainCanvas.WIDTH >> 1) - (this.gameScreen.fontNumbers.stringWidth(this.time.toCharArray()) >> 1), this.iCenterGameOverY + this.gameScreen.imgSmallScore.getHeight(), 20);
        }
        if (this.iGameOverStep > 2) {
            this.gameScreen.fontMain.drawString(g, Resources.resTexts[0].getHashedString(30).toCharArray(), MainCanvas.WIDTH >> 1, this.iCenterGameOverY + (this.iGameOverH >> 1) - (this.gameScreen.fontMain.getHeight() << 1), 33);
        }
    }

    private void paintPause(Graphics g) {
        this.gameScreen.paintTitle(g);
        for (int i = 0; i < this.iPauseItemsTotal; ++i) {
            if (i == this.gameScreen.iSelectedMenuItem) {
                g.drawImage(this.imagesPauseItems[i], MainGame.rectPauseItems[i].x + this.gameScreen.iShiftX, MainGame.rectPauseItems[i].y, 20);
                continue;
            }
            g.drawImage(this.imagesPauseItems[i], MainGame.rectPauseItems[i].x, MainGame.rectPauseItems[i].y, 20);
        }
    }

    private void paintTutorial(Graphics g) {
        this.gameScreen.paintTable(g, this.gameScreen.sprSkin, MainCanvas.WIDTH >> 1, this.iTutorialCenterY, this.iTutorialW, this.iTutorialH);
        this.paintTutorialText(g);
    }

    public void paintTutorialText(Graphics g) {
        int iTextYUp = this.iTutorialCenterY - (this.iTutorialH >> 1) + (this.gameScreen.imgArrows[0].getHeight() << 1);
        int iTextYDown = this.iTutorialCenterY + (this.iTutorialH >> 1) - (this.gameScreen.imgArrows[0].getHeight() << 1);
        if (this.iTutorialShiftY > 0) {
            g.drawImage(this.gameScreen.imgArrows[1], (MainCanvas.WIDTH >> 1) - (this.gameScreen.imgArrows[1].getWidth() >> 1), iTextYUp - this.gameScreen.imgArrows[1].getHeight() - (this.gameScreen.imgArrows[1].getHeight() >> 1), 20);
        }
        if (this.iTutorialShiftY < this.iTutorialMaxShiftY) {
            g.drawImage(this.gameScreen.imgArrows[0], (MainCanvas.WIDTH >> 1) - (this.gameScreen.imgArrows[1].getWidth() >> 1), iTextYDown + (this.gameScreen.imgArrows[1].getHeight() >> 1), 20);
        }
        g.setClip(0, iTextYUp, MainCanvas.WIDTH, iTextYDown - iTextYUp);
        int lineY = 0;
        for (int i = 0; i < this.iTextLines; ++i) {
            lineY = iTextYUp + i * this.gameScreen.fontMain.getHeight() - this.iTutorialShiftY;
            if (lineY <= this.iTutorialCenterY - (this.iTutorialH >> 1) || lineY + this.gameScreen.fontMain.getHeight() >= this.iTutorialCenterY + (this.iTutorialH >> 1)) continue;
            this.gameScreen.fontMain.drawString(g, this.prepText.getText(i).toCharArray(), MainCanvas.WIDTH >> 1, lineY, 17);
        }
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
    }

    private void paintBottomPanel(Graphics g) {
        if (this.gameScreen.imgScoreBar != null && this.gameScreen.sprUndo != null) {
            g.drawImage(this.gameScreen.imgScoreBar, 0, this.iBottomPanelY, 20);
            this.gameScreen.sprUndo.setPosition(this.gameScreen.iControlBtnLeftX, this.gameScreen.iControlBtnY);
            if (this.history[0][0] != -100) {
                this.gameScreen.sprUndo.setFrame(0);
            } else {
                this.gameScreen.sprUndo.setFrame(1);
            }
            this.gameScreen.sprUndo.paint(g);
            this.gameScreen.paintRightButton(g, this.gameScreen.imgM_menu);
        }
        this.paintTimerAndScore(g);
    }

    private void paintTimerAndScore(Graphics g) {
        if (this.gameScreen.imgSmallTime != null && this.gameScreen.imgSmallScore != null && this.gameScreen.fontNumbers != null) {
            g.drawImage(this.gameScreen.imgSmallTime, MainCanvas.WIDTH >> 1, this.iBottomImageY, 20);
            this.gameScreen.fontNumbers.drawString(g, this.time.toCharArray(), this.iBottomTextRightX, this.iBottomTextY, 20);
            this.gameScreen.fontNumbers.drawString(g, ("" + this.score).toCharArray(), this.iBottomTextLeftX, this.iBottomTextY, 20);
            g.drawImage(this.gameScreen.imgSmallScore, (MainCanvas.WIDTH >> 1) - this.iScoreTextW - (this.gameScreen.imgSmallTime.getWidth() << 1), this.iBottomImageY, 20);
        }
    }

    private void paintCards(Graphics g) {
        switch (this.gameType) {
            case 0: {
                if (this.gameScreen.imgCardBack == null || this.gameScreen.imgO == null || this.gameScreen.sprCards == null || this.gameScreen.imgCardHolder == null) break;
                if (!this.bLastCardInStackSolitaire) {
                    g.drawImage(this.gameScreen.imgCardBack, this.rectFirstRow[0].x, this.rectFirstRow[0].y, 20);
                } else {
                    g.drawImage(this.gameScreen.imgO, this.iImgOX, this.iImgOY, 20);
                }
                if (this.gStackSolitaire[this.solitaireStackPointer] != -99 && this.gStackSolitaire[this.solitaireStackPointer] != -100) {
                    this.gameScreen.sprCards.setPosition(this.rectFirstRow[1].x, this.rectFirstRow[1].y);
                    this.gameScreen.sprCards.setFrame((int)this.gStackSolitaire[this.solitaireStackPointer]);
                    this.gameScreen.sprCards.paint(g);
                }
                for (int i = 2; i < this.rectFirstRow.length; ++i) {
                    byte lastIdx = this.getLastIndexInArray(i - 2, this.gEndStacks);
                    if (lastIdx != -1) {
                        this.gameScreen.sprCards.setPosition(this.rectFirstRow[i].x, this.rectFirstRow[i].y);
                        this.gameScreen.sprCards.setFrame((int)this.gEndStacks[i - 2][lastIdx]);
                        this.gameScreen.sprCards.paint(g);
                        continue;
                    }
                    g.drawImage(this.gameScreen.imgCardHolder, this.rectFirstRow[i].x, this.rectFirstRow[i].y, 20);
                }
                this.paintCardsSecondRow(g);
                break;
            }
            case 1: {
                for (int i = 0; i < this.rectFirstRow.length; ++i) {
                    if (i < this.rectFirstRow.length >> 1) {
                        if (this.gFreecells[i] != -100) {
                            this.gameScreen.sprCards.setPosition(this.rectFirstRow[i].x, this.rectFirstRow[i].y);
                            this.gameScreen.sprCards.setFrame((int)this.gFreecells[i]);
                            this.gameScreen.sprCards.paint(g);
                            continue;
                        }
                        g.drawImage(this.gameScreen.imgCardHolder2, this.rectFirstRow[i].x, this.rectFirstRow[i].y, 20);
                        continue;
                    }
                    this.lastIdx = this.getLastIndexInArray(i - (this.rectFirstRow.length >> 1), this.gEndStacks);
                    if (this.lastIdx != -1) {
                        this.gameScreen.sprCards.setPosition(this.rectFirstRow[i].x, this.rectFirstRow[i].y);
                        this.gameScreen.sprCards.setFrame((int)this.gEndStacks[i - (this.rectFirstRow.length >> 1)][this.lastIdx]);
                        this.gameScreen.sprCards.paint(g);
                        continue;
                    }
                    g.drawImage(this.gameScreen.imgCardHolder, this.rectFirstRow[i].x, this.rectFirstRow[i].y, 20);
                }
                this.paintCardsSecondRow(g);
                break;
            }
            case 2: {
                if (this.spiderStackStep < 4) {
                    for (int i = 0; i < 4 - this.spiderStackStep; ++i) {
                        g.drawImage(this.gameScreen.imgCardBack, this.rectFirstRow[0].x + i * this.stackOffX, this.rectFirstRow[0].y, 20);
                    }
                } else {
                    g.drawImage(this.gameScreen.imgO, this.rectFirstRow[0].x + (this.rectFirstRow[0].width >> 1) - (this.gameScreen.imgO.getWidth() >> 1), this.rectFirstRow[0].y + (this.rectFirstRow[0].height >> 1) - (this.gameScreen.imgO.getHeight() >> 1), 20);
                }
                this.paintCardsSecondRow(g);
                break;
            }
        }
    }

    private void paintCardsSecondRow(Graphics g) {
        for (int i = 0; i < this.rectSecondRow.length; ++i) {
            for (int j = 0; j < this.rectSecondRow[0].length; ++j) {
                if (this.gColumns[i][j] == -100) continue;
                if (this.gColumns[i][j] >= 0) {
                    this.gameScreen.sprCards.setPosition(this.rectSecondRow[i][j].x, this.rectSecondRow[i][j].y);
                    this.gameScreen.sprCards.setFrame((int)this.gColumns[i][j]);
                    this.gameScreen.sprCards.paint(g);
                    continue;
                }
                g.drawImage(this.gameScreen.imgCardBack, this.rectSecondRow[i][j].x, this.rectSecondRow[i][j].y, 20);
            }
        }
    }

    private void paintHand(Graphics g) {
        if (this.gameScreen.sprHand != null && this.selected) {
            this.paintSelectedCards(g);
        }
    }

    private void paintSelectedCards(Graphics g) {
        for (int i = 0; i < this.selectedCards.length; ++i) {
            if (this.selectedCards[i] == -100) continue;
            this.gameScreen.sprCards.setPosition(this.handPositionX, this.handPositionY + i * this.cardsOffH);
            this.gameScreen.sprCards.setFrame((int)this.selectedCards[i]);
            this.gameScreen.sprCards.paint(g);
        }
    }

    public int getSavedGameType() {
        Profile.loadGame();
        return Profile.gameType;
    }

    public void loadGame(int gameType) {
        switch (gameType) {
            case 0: {
                this.loadSolitaire();
                break;
            }
            case 1: {
                this.loadFreecell();
                break;
            }
            case 2: {
                this.loadSpider();
                break;
            }
        }
        this.initTutorialTexts();
        this.calculatePositions();
        this.resetLoadedGameBeforePlay();
    }

    private void loadFreecell() {
        int j;
        int i;
        this.gameType = this.gameType;
        this.gPos[0] = 3;
        this.gPos[1] = 3;
        this.gPos[2] = 3;
        this.gPos[3] = 3;
        this.gPos[4] = 3;
        this.gPos[5] = 3;
        this.gPos[6] = 3;
        this.gPos[7] = 3;
        this.gPos[8] = 4;
        this.gPos[9] = 4;
        this.gPos[10] = 4;
        this.gPos[11] = 4;
        this.gPos[12] = 2;
        this.gPos[13] = 2;
        this.gPos[14] = 2;
        this.gPos[15] = 2;
        this.gColumns = new byte[8][25];
        this.gEndStacks = new byte[4][13];
        this.gFreecells = new byte[4];
        this.endStackPositionPosuv = 12;
        for (i = 0; i <= this.gColumns.length - 1; ++i) {
            for (j = 0; j < 25; ++j) {
                this.gColumns[i][j] = Profile.gColumns[i][j];
            }
        }
        for (i = 0; i < this.gEndStacks.length; ++i) {
            for (j = 0; j < this.gEndStacks[0].length; ++j) {
                this.gEndStacks[i][j] = Profile.gEndStack[i][j];
            }
        }
        for (i = 0; i < 4; ++i) {
            this.gFreecells[i] = Profile.gFreecells[i];
        }
    }

    private void loadSpider() {
        int i;
        this.gameType = this.gameType;
        this.gPos[0] = 3;
        this.gPos[1] = 3;
        this.gPos[2] = 3;
        this.gPos[3] = 3;
        this.gPos[4] = 3;
        this.gPos[5] = 3;
        this.gPos[6] = 3;
        this.gPos[7] = 5;
        this.gPos[8] = 1;
        this.gPos[9] = 5;
        this.gPos[10] = 5;
        this.gPos[11] = 5;
        this.gPos[12] = 5;
        this.gPos[13] = 5;
        this.gPos[14] = 5;
        this.gPos[15] = 5;
        this.gColumns = new byte[7][25];
        this.gStackSpider = new byte[24];
        this.endStackPositionPosuv = 0;
        for (i = 0; i <= this.gColumns.length - 1; ++i) {
            for (int j = 0; j < 25; ++j) {
                this.gColumns[i][j] = Profile.gColumns[i][j];
            }
        }
        for (i = 0; i < this.gStackSpider.length; ++i) {
            this.gStackSpider[i] = Profile.gStackSpider[i];
        }
        this.spiderStackStep = Profile.spiderStackPointer;
    }

    private void loadSolitaire() {
        int j;
        int i;
        this.gameType = this.gameType;
        this.gPos = new byte[16];
        this.gPos[0] = 3;
        this.gPos[1] = 3;
        this.gPos[2] = 3;
        this.gPos[3] = 3;
        this.gPos[4] = 3;
        this.gPos[5] = 3;
        this.gPos[6] = 3;
        this.gPos[7] = 5;
        this.gPos[8] = 0;
        this.gPos[9] = 0;
        this.gPos[10] = 5;
        this.gPos[11] = 2;
        this.gPos[12] = 2;
        this.gPos[13] = 2;
        this.gPos[14] = 2;
        this.gPos[15] = 5;
        this.gColumns = new byte[7][25];
        this.gEndStacks = new byte[4][13];
        this.gStackSolitaire = new byte[25];
        this.endStackPositionPosuv = 11;
        for (i = 0; i <= this.gColumns.length - 1; ++i) {
            for (j = 0; j < 25; ++j) {
                this.gColumns[i][j] = Profile.gColumns[i][j];
            }
        }
        for (i = 0; i < this.gStackSolitaire.length; ++i) {
            this.gStackSolitaire[i] = Profile.gStackSolitaire[i];
        }
        for (i = 0; i < this.gEndStacks.length; ++i) {
            for (j = 0; j < this.gEndStacks[0].length; ++j) {
                this.gEndStacks[i][j] = Profile.gEndStack[i][j];
            }
        }
    }

    public void saveGame() {
        Profile.gameType = this.gameType;
        switch (this.gameType) {
            case 0: {
                Profile.gColumns = this.gColumns;
                Profile.gEndStack = this.gEndStacks;
                Profile.gStackSolitaire = this.gStackSolitaire;
                Profile.solitaireStackPointer = this.solitaireStackPointer;
                Profile.handPositionCurrent = this.handPositionCurrent;
                Profile.handPositionOld = this.handPositionOld;
                Profile.playedSec = (int)this.playedSec / 1000;
                Profile.score = this.score;
                Profile.history = this.history;
                break;
            }
            case 1: {
                Profile.gColumns = this.gColumns;
                Profile.gEndStack = this.gEndStacks;
                Profile.gFreecells = this.gFreecells;
                Profile.handPositionCurrent = this.handPositionCurrent;
                Profile.handPositionOld = this.handPositionOld;
                Profile.playedSec = (int)this.playedSec / 1000;
                Profile.score = this.score;
                Profile.history = this.history;
                break;
            }
            case 2: {
                Profile.gColumns = this.gColumns;
                Profile.gStackSpider = this.gStackSpider;
                Profile.spiderStackPointer = this.spiderStackStep;
                Profile.handPositionCurrent = this.handPositionCurrent;
                Profile.handPositionOld = this.handPositionOld;
                Profile.playedSec = (int)this.playedSec / 1000;
                Profile.score = this.score;
                Profile.history = this.history;
                break;
            }
        }
        Profile.saveGame();
    }

    public void beforeInterruption() {
        if (this.gameScreen.subScreen == 1) {
            this.gameScreen.getClass();
            this.gameScreen.nextScreen(2, 3);
            this.saveGame();
        }
    }

    public void afterInterruption() {
    }
}

