/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.MainCanvas;
import sk.inlogic.Profile;
import sk.inlogic.Resources;
import sk.inlogic.Sounds;
import sk.inlogic.X;
import sk.inlogic.game.MainGame;
import sk.inlogic.graphics.GFont;
import sk.inlogic.screen.IScreen;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenMain
implements IScreen {
    public MainCanvas mainCanvas;
    public GFont fontMain;
    public GFont fontNumbers;
    public final byte SCREEN_INTRO;
    public final byte SCREEN_MENU;
    public final byte SCREEN_GAME = (byte)2;
    public final byte INTRO_INIT_GRAPHICS;
    public final byte INTRO_INIT;
    public final byte INTRO_LOGO_INLOGIC = (byte)2;
    public final byte INTRO_LANGUAGE = (byte)3;
    public final byte INTRO_ENABLE_MUSIC = (byte)4;
    public final byte INTRO_SPLASH = (byte)5;
    public final byte MENU_MAIN;
    public final byte MENU_INSTRUCTIONS;
    public final byte MENU_ABOUT = (byte)2;
    public final byte MENU_QUIT = (byte)3;
    public final byte MENU_SELECT_GAMETYPE = (byte)4;
    public static final byte GAME_TUTORIAL = 0;
    public static final byte GAME_MAIN = 1;
    public static final byte GAME_OVER = 2;
    public static final byte GAME_PAUSE = 3;
    public static final byte GAME_CONFIRM_MESSAGE = 4;
    final byte ID_MENU_PLAY;
    final byte ID_MENU_INSTRUCTIONS;
    final byte ID_MENU_ABOUT = (byte)2;
    final byte ID_MENU_ITEMS_TOTAL = (byte)3;
    final byte ID_PAUSE_SOUND;
    final byte ID_PAUSE_INSTRUCTIONS;
    final byte ID_PAUSE_QUIT_TO_MENU = (byte)2;
    final byte ID_PAUSE_ITEMS_TOTAL = (byte)3;
    final byte ID_SELECT_SOLITAIRE;
    final byte ID_SELECT_FREECELL;
    final byte ID_SELECT_SPIDER = (byte)2;
    final byte ID_SELECT_TOTAL = (byte)3;
    private int iMenuItemsTotal;
    private int screen;
    public int subScreen;
    public int iSelectedMenuItem;
    public boolean bLoading = false;
    private static final int BG_COLOR = 2766395;
    public Image[] imgArrows = new Image[2];
    public Image[] imgBackgrounds = new Image[3];
    Image[] imgGameTypes = new Image[3];
    Image[] imgM_music = new Image[2];
    Image imgLogo;
    Image imgM_more;
    Image imgM_quit;
    Image imgSplash;
    public Image imgM_menu;
    public Image img_MI_developer;
    public Image img_MI_info;
    public Image img_MI_menu;
    public Image img_MI_play;
    public Image img_MI_restart;
    public Image img_MI_score;
    Image imgX;
    public Image imgO;
    Image imgTitle;
    Image imgNo;
    Image imgYes;
    Image imgStar;
    public Image imgScoreBar;
    public Image imgSmallScore;
    public Image imgSmallTime;
    Sprite sprLanguage;
    public Sprite sprSkin;
    Sprite sprResultSkin;
    public Sprite sprUndo;
    public Sprite sprCards;
    public Sprite sprHand;
    public Image imgCardBack;
    public Image imgCardHolder;
    public Image imgCardHolder2;
    Rectangle[] rectMenuItems;
    Rectangle[] rectSelectGameItems;
    public Rectangle rectTitleCenter;
    Rectangle rectExitGame;
    public boolean bDragInstructions = false;
    private int iTextLines = 1;
    public String sTextTitle;
    String sTextButton;
    public String sTextInfo;
    String[] sTextMenu = new String[5];
    String[] sTextPom = new String[3];
    PreparedText prepText;
    private int updateCounter = 0;
    private int iShiftDirection;
    public int iShiftX;
    private int iShiftStep;
    private int iAboutCenterY;
    private int iAboutWidth;
    private int iAboutHeight;
    private int iInstructionsCenterY;
    private int iInstructionsWidth;
    private int iInstructionsHeight;
    private int iTextShiftY = 0;
    private int iInstructionsShiftY = 0;
    private int iInstructionsMaxShiftY = 0;
    private MainGame game;
    private static final int DELAY_TIME = 3000;
    private int delay;
    private static String[] langCodes = new String[]{"en", "de", "fr", "es", "pt"};
    private static final int[] LANGUAGES = new int[]{0, 2, 1, 3, 4};
    private static final int MAX_LANGUAGES = 5;
    private Rectangle[] rectLanguages = new Rectangle[5];
    private int iSelectedLanguage;
    public boolean bAnimationIn;
    public boolean bAnimationOut;
    int animNextScr;
    int animNextSubScr;
    public int iControlBtnY;
    public int iControlBtnLeftX;
    public int iControlBtnRightX;
    int iTitleX;
    int iTitleY;
    private Image[] imagesMenuItems;
    private Image[] imagesSelectGameItems;
    int iMenuItemX;
    int iAnimStep;
    public boolean bStart = false;

    public ScreenMain(MainCanvas mainCanvas) {
        this.SCREEN_INTRO = 0;
        this.SCREEN_MENU = 1;
        this.INTRO_INIT_GRAPHICS = 0;
        this.INTRO_INIT = 1;
        this.MENU_MAIN = 0;
        this.MENU_INSTRUCTIONS = 1;
        this.ID_MENU_PLAY = 0;
        this.ID_MENU_INSTRUCTIONS = 1;
        this.ID_PAUSE_SOUND = 0;
        this.ID_PAUSE_INSTRUCTIONS = 1;
        this.ID_SELECT_SOLITAIRE = 0;
        this.ID_SELECT_FREECELL = 1;
        this.mainCanvas = mainCanvas;
    }

    public void updateShift() {
    }

    public void update(long lTick) {
        if (this.mainCanvas.isInterrupted()) {
            return;
        }
        if (this.screen == 2) {
            this.game.afterInterruption();
        }
        if (!this.bLoading) {
            block0 : switch (this.screen) {
                case 0: {
                    switch (this.subScreen) {
                        case 0: {
                            this.initGraphics();
                            break block0;
                        }
                        case 1: {
                            this.initIntro();
                            break block0;
                        }
                        case 2: {
                            if (this.delay > 0) {
                                this.delay = (int)((long)this.delay - lTick);
                                break block0;
                            }
                            this.nextScreen(0, 3);
                            break block0;
                        }
                        case 3: {
                            this.updateShift();
                            break block0;
                        }
                        case 5: {
                            if (this.delay > 0) {
                                this.delay = (int)((long)this.delay - lTick);
                                break block0;
                            }
                            if (this.bLoading) break block0;
                            this.nextScreen(1, 0);
                            break block0;
                        }
                    }
                    break;
                }
                case 1: {
                    switch (this.subScreen) {
                        case 0: {
                            this.updateAnimIn();
                            this.updateAnimOut();
                            if (this.bAnimationIn || this.bAnimationOut) break block0;
                            this.updateShift();
                            break block0;
                        }
                        case 1: {
                            this.updateInstructions();
                            break block0;
                        }
                        case 4: {
                            this.updateAnimIn();
                            this.updateAnimOut();
                            if (this.bAnimationIn || this.bAnimationOut) break block0;
                            this.updateShift();
                            break block0;
                        }
                    }
                    break;
                }
                case 2: {
                    this.game.update(lTick);
                    break;
                }
            }
            this.mainCanvas.repaint();
        }
    }

    public void updateAnimIn() {
        block13: {
            block14: {
                block15: {
                    if (!this.bAnimationIn) break block13;
                    if (this.screen != 1) break block14;
                    if (this.subScreen != 0) break block15;
                    if (this.rectMenuItems[0].x < this.iMenuItemX - this.iAnimStep) {
                        for (int i = 0; i < this.iMenuItemsTotal; ++i) {
                            this.rectMenuItems[i].x += this.iAnimStep;
                        }
                    } else {
                        this.bAnimationIn = false;
                        for (int i = 0; i < this.iMenuItemsTotal; ++i) {
                            this.rectMenuItems[i].x = this.iMenuItemX;
                        }
                    }
                    break block13;
                }
                if (this.subScreen != 4) break block13;
                if (this.rectSelectGameItems[0].x < this.iMenuItemX - this.iAnimStep) {
                    for (int i = 0; i < 3; ++i) {
                        this.rectSelectGameItems[i].x += this.iAnimStep;
                    }
                } else {
                    this.bAnimationIn = false;
                    for (int i = 0; i < 3; ++i) {
                        this.rectSelectGameItems[i].x = this.iMenuItemX;
                    }
                }
                break block13;
            }
            if (this.screen == 2 && this.subScreen == 3) {
                if (MainGame.rectPauseItems[0].x < this.iMenuItemX - this.iAnimStep) {
                    for (int i = 0; i < MainGame.rectPauseItems.length; ++i) {
                        MainGame.rectPauseItems[i].x += this.iAnimStep;
                    }
                } else {
                    this.bAnimationIn = false;
                    for (int i = 0; i < MainGame.rectPauseItems.length; ++i) {
                        MainGame.rectPauseItems[i].x = this.iMenuItemX;
                    }
                }
            }
        }
    }

    public void setAnimOutVars(int nextScreen, int nextSubScreen) {
        this.animNextScr = nextScreen;
        this.animNextSubScr = nextSubScreen;
        this.bAnimationOut = true;
    }

    public void updateAnimOut() {
        if (this.bAnimationOut) {
            if (this.screen == 1) {
                if (this.subScreen == 0) {
                    if (this.rectMenuItems[0].x < MainCanvas.WIDTH + this.iMenuItemX) {
                        for (int i = 0; i < this.iMenuItemsTotal; ++i) {
                            this.rectMenuItems[i].x += this.iAnimStep;
                        }
                    } else {
                        this.bAnimationOut = false;
                        this.nextScreen(this.animNextScr, this.animNextSubScr);
                    }
                } else if (this.subScreen == 4) {
                    if (this.rectSelectGameItems[0].x < MainCanvas.WIDTH + this.iMenuItemX) {
                        for (int i = 0; i < 3; ++i) {
                            this.rectSelectGameItems[i].x += this.iAnimStep;
                        }
                    } else {
                        this.bAnimationOut = false;
                        this.nextScreen(this.animNextScr, this.animNextSubScr);
                    }
                }
            } else if (this.screen == 2 && this.subScreen == 3) {
                if (MainGame.rectPauseItems[0].x < MainCanvas.WIDTH + this.iMenuItemX) {
                    for (int i = 0; i < 3; ++i) {
                        MainGame.rectPauseItems[i].x += this.iAnimStep;
                    }
                } else {
                    this.bAnimationOut = false;
                    this.nextScreen(this.animNextScr, this.animNextSubScr);
                }
            }
        }
    }

    public void paint(Graphics g) {
        block0 : switch (this.screen) {
            case 0: {
                this.paintBgIntro(g);
                switch (this.subScreen) {
                    case 2: {
                        this.paintLogoInlogic(g);
                        break block0;
                    }
                    case 5: {
                        this.paintSplash(g);
                        break block0;
                    }
                    case 3: {
                        this.paintLanguages(g);
                        break block0;
                    }
                    case 4: {
                        this.paintEnableMusic(g);
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                this.paintBg(g);
                switch (this.subScreen) {
                    case 0: {
                        this.paintMainMenu(g);
                        break block0;
                    }
                    case 1: {
                        this.paintInstructions(g);
                        break block0;
                    }
                    case 2: {
                        this.paintAbout(g);
                        break block0;
                    }
                    case 3: {
                        this.paintQuit(g);
                        break block0;
                    }
                    case 4: {
                        this.paintSelectGame(g);
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                this.game.paint(g);
                break;
            }
        }
        this.paintControls(g);
    }

    public void paintControls(Graphics g) {
        block0 : switch (this.screen) {
            case 0: {
                switch (this.subScreen) {
                    case 3: {
                        break block0;
                    }
                    case 4: {
                        this.paintLeftButton(g, this.imgYes);
                        this.paintRightButton(g, this.imgNo);
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                switch (this.subScreen) {
                    case 0: {
                        if (Profile.bMusic) {
                            this.paintLeftButton(g, this.imgM_music[1]);
                        } else {
                            this.paintLeftButton(g, this.imgM_music[0]);
                        }
                        this.paintRightButton(g, this.imgM_quit);
                        break block0;
                    }
                    case 4: {
                        this.paintRightButton(g, this.imgM_menu);
                        break block0;
                    }
                    case 1: 
                    case 2: {
                        this.paintRightButton(g, this.imgM_menu);
                        break block0;
                    }
                    case 3: {
                        this.paintLeftButton(g, this.imgYes);
                        this.paintRightButton(g, this.imgNo);
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                switch (this.subScreen) {
                    case 3: {
                        this.paintRightButton(g, this.imgNo);
                        if (Profile.bMusic) {
                            this.paintLeftButton(g, this.imgM_music[1]);
                            break block0;
                        }
                        this.paintLeftButton(g, this.imgM_music[0]);
                        break block0;
                    }
                    case 0: {
                        if (this.game.bInstructionFromPause) {
                            this.paintRightButton(g, this.imgM_menu);
                            break block0;
                        }
                        this.paintLeftButton(g, this.imgYes);
                        break block0;
                    }
                    case 1: {
                        if (!this.bStart) break block0;
                        this.paintLeftButton(g, this.imgYes);
                        break block0;
                    }
                    case 2: {
                        this.paintRightButton(g, this.imgM_menu);
                        this.paintLeftButton(g, this.imgYes);
                        break block0;
                    }
                    case 4: {
                        this.paintLeftButton(g, this.imgYes);
                        this.paintRightButton(g, this.imgNo);
                        break block0;
                    }
                }
                break;
            }
        }
    }

    public void paintLeftButton(Graphics g, Image image) {
        g.drawImage(image, this.iControlBtnLeftX, this.iControlBtnY, 20);
    }

    public void paintRightButton(Graphics g, Image image) {
        g.drawImage(image, this.iControlBtnRightX, this.iControlBtnY, 20);
    }

    public void paintLogoInlogic(Graphics g) {
        g.drawImage(this.imgLogo, (MainCanvas.WIDTH >> 1) - (this.imgLogo.getWidth() >> 1), (MainCanvas.HEIGHT >> 1) - (this.imgLogo.getHeight() >> 1), 20);
    }

    public void paintSplash(Graphics g) {
        g.drawImage(this.imgSplash, 0, 0, 20);
    }

    public void paintLanguages(Graphics g) {
        for (int i = 0; i < 5; ++i) {
            int pomShiftX = 0;
            this.sprLanguage.setFrame(LANGUAGES[i]);
            this.sprLanguage.setPosition(this.rectLanguages[i].x + pomShiftX, this.rectLanguages[i].y);
            this.sprLanguage.paint(g);
        }
    }

    public void paintEnableMusic(Graphics g) {
        this.paintButton2(g, this.rectTitleCenter);
    }

    public void paintBg(Graphics g) {
        g.drawImage(this.imgBackgrounds[0], 0, 0, 20);
    }

    public void paintBgIntro(Graphics g) {
        g.setColor(2766395);
        g.fillRect(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
    }

    public void paintTitle(Graphics g) {
        g.drawImage(this.imgTitle, this.iTitleX, this.iTitleY, 20);
    }

    public void paintSelectGame(Graphics g) {
        this.paintTitle(g);
        for (int i = 0; i < 3; ++i) {
            if (i == this.iSelectedMenuItem) {
                g.drawImage(this.imagesSelectGameItems[i], this.rectSelectGameItems[i].x + this.iShiftX, this.rectSelectGameItems[i].y, 20);
                continue;
            }
            g.drawImage(this.imagesSelectGameItems[i], this.rectSelectGameItems[i].x, this.rectSelectGameItems[i].y, 20);
        }
    }

    public void paintMainMenu(Graphics g) {
        this.paintTitle(g);
        for (int i = 0; i < this.iMenuItemsTotal; ++i) {
            if (i == this.iSelectedMenuItem) {
                g.drawImage(this.imagesMenuItems[i], this.rectMenuItems[i].x + this.iShiftX, this.rectMenuItems[i].y, 20);
                continue;
            }
            g.drawImage(this.imagesMenuItems[i], this.rectMenuItems[i].x, this.rectMenuItems[i].y, 20);
        }
    }

    public void paintInstructions(Graphics g) {
        this.paintTitle(g);
        this.paintTable(g, this.sprSkin, MainCanvas.WIDTH >> 1, this.iInstructionsCenterY, this.iInstructionsWidth, this.iInstructionsHeight);
        if (!this.bLoading) {
            this.paintInstructionsText(g);
        }
    }

    public void updateInstructions() {
        if (this.iTextShiftY < 0) {
            if (this.iInstructionsShiftY > 0) {
                this.iInstructionsShiftY += this.iTextShiftY;
                if (this.iInstructionsShiftY <= 0) {
                    this.iInstructionsShiftY = 0;
                    this.iTextShiftY = 0;
                } else if (this.bDragInstructions) {
                    this.iTextShiftY = 0;
                } else {
                    this.iTextShiftY += MainCanvas.HEIGHT >> 6;
                    if (this.iTextShiftY > 0) {
                        this.iTextShiftY = 0;
                    }
                }
            } else {
                this.iTextShiftY = 0;
            }
        }
        if (this.iTextShiftY > 0) {
            if (this.iInstructionsShiftY < this.iInstructionsMaxShiftY) {
                this.iInstructionsShiftY += this.iTextShiftY;
                if (this.iInstructionsShiftY >= this.iInstructionsMaxShiftY) {
                    this.iInstructionsShiftY = this.iInstructionsMaxShiftY;
                    this.iTextShiftY = 0;
                } else if (this.bDragInstructions) {
                    this.iTextShiftY = 0;
                } else {
                    this.iTextShiftY -= MainCanvas.HEIGHT >> 6;
                    if (this.iTextShiftY < 0) {
                        this.iTextShiftY = 0;
                    }
                }
            } else {
                this.iTextShiftY = 0;
            }
        }
    }

    public boolean isPressedInstructionsText(int x, int y) {
        return x > (MainCanvas.WIDTH >> 1) - (this.iInstructionsWidth >> 1) && x < (MainCanvas.WIDTH >> 1) + (this.iInstructionsWidth >> 1) && y > this.iInstructionsCenterY - (this.iInstructionsHeight >> 1) && y < this.iInstructionsCenterY + (this.iInstructionsHeight >> 1);
    }

    public void paintInstructionsText(Graphics g) {
        int iTextYUp = this.iInstructionsCenterY - (this.iInstructionsHeight >> 1) + (this.imgArrows[0].getHeight() << 1);
        int iTextYDown = this.iInstructionsCenterY + (this.iInstructionsHeight >> 1) - (this.imgArrows[0].getHeight() << 1);
        if (this.iInstructionsShiftY > 0) {
            g.drawImage(this.imgArrows[1], (MainCanvas.WIDTH >> 1) - (this.imgArrows[1].getWidth() >> 1), iTextYUp - this.imgArrows[1].getHeight() - (this.imgArrows[1].getHeight() >> 1), 20);
        }
        if (this.iInstructionsShiftY < this.iInstructionsMaxShiftY) {
            g.drawImage(this.imgArrows[0], (MainCanvas.WIDTH >> 1) - (this.imgArrows[1].getWidth() >> 1), iTextYDown + (this.imgArrows[1].getHeight() >> 1), 20);
        }
        g.setClip(0, iTextYUp, MainCanvas.WIDTH, iTextYDown - iTextYUp);
        int lineY = 0;
        for (int i = 0; i < this.iTextLines; ++i) {
            lineY = iTextYUp + i * this.fontMain.getHeight() - this.iInstructionsShiftY;
            if (lineY <= this.iInstructionsCenterY - (this.iInstructionsHeight >> 1) || lineY + this.fontMain.getHeight() >= this.iInstructionsCenterY + (this.iInstructionsHeight >> 1)) continue;
            this.fontMain.drawString(g, this.prepText.getText(i).toCharArray(), MainCanvas.WIDTH >> 1, lineY, 17);
        }
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
    }

    public void paintAbout(Graphics g) {
        this.paintTitle(g);
        this.paintTable(g, this.sprSkin, MainCanvas.WIDTH >> 1, this.iAboutCenterY, this.iAboutWidth, this.iAboutHeight);
        int pomHeight = this.imgLogo.getHeight() + (this.fontMain.getHeight() << 1) + (this.fontMain.getHeight() >> 1);
        int pomY = this.iAboutCenterY - (pomHeight >> 1);
        g.drawImage(this.imgLogo, (MainCanvas.WIDTH >> 1) - (this.imgLogo.getWidth() >> 1), pomY, 20);
        this.fontMain.drawString(g, this.sTextPom[0].toCharArray(), (MainCanvas.WIDTH >> 1) - (this.fontMain.stringWidth(this.sTextPom[0].toCharArray()) >> 1), pomY += this.imgLogo.getHeight() + (this.fontMain.getHeight() >> 1), 20);
        this.fontMain.drawString(g, this.sTextPom[1].toCharArray(), (MainCanvas.WIDTH >> 1) - (this.fontMain.stringWidth(this.sTextPom[1].toCharArray()) >> 1), pomY += this.fontMain.getHeight(), 20);
    }

    public void paintQuit(Graphics g) {
        this.paintButton2(g, this.rectTitleCenter);
    }

    public void paintButton2(Graphics g, Rectangle rect) {
        int iCenterY = MainCanvas.HEIGHT >> 1;
        this.paintTable(g, this.sprSkin, rect.getCenterX(), iCenterY, rect.width, rect.height);
        int textHeight = this.fontMain.getHeight() * this.iTextLines;
        int pomY = iCenterY - (textHeight >> 1) - 1;
        for (int i = 0; i < this.iTextLines; ++i) {
            this.fontMain.drawString(g, this.prepText.getText(i).toCharArray(), rect.getCenterX(), pomY, 17);
            pomY += this.fontMain.getHeight();
        }
    }

    public void keyPressed(int keyCode) {
    }

    public void soundOn() {
        Profile.bMusic = true;
        MainCanvas.soundManager.SetSoundOn(true);
        MainCanvas.soundManager.SetMusicOn(true);
    }

    public void soundOff() {
        Profile.bMusic = false;
        MainCanvas.soundManager.SetSoundOn(false);
        MainCanvas.soundManager.SetMusicOn(false);
    }

    public void changeLanguage(int iType) {
        switch (iType) {
            case 0: {
                if (this.iSelectedLanguage > 1) {
                    this.iSelectedLanguage -= 2;
                    break;
                }
                this.iSelectedLanguage = 4;
                break;
            }
            case 1: {
                if (this.iSelectedLanguage == 3) {
                    ++this.iSelectedLanguage;
                    break;
                }
                if (this.iSelectedLanguage == 4) {
                    this.iSelectedLanguage = 0;
                    break;
                }
                this.iSelectedLanguage += 2;
                break;
            }
            case 2: {
                if (this.iSelectedLanguage > 0) {
                    --this.iSelectedLanguage;
                    break;
                }
                this.iSelectedLanguage = 4;
                break;
            }
            case 3: {
                if (this.iSelectedLanguage < 4) {
                    ++this.iSelectedLanguage;
                    break;
                }
                this.iSelectedLanguage = 0;
                break;
            }
        }
    }

    public void changeSound() {
        Profile.bMusic = !Profile.bMusic;
        Profile.save();
        if (Profile.bMusic) {
            this.soundOn();
            this.playMusic(Sounds.MUSIC_MENU, -1);
        } else {
            this.soundOff();
        }
    }

    public void changeSelectedMenuItem(int iShift) {
        int pom = 0;
        switch (this.screen) {
            case 1: {
                if (this.subScreen == 0) {
                    pom = this.iMenuItemsTotal;
                    break;
                }
                if (this.subScreen != 4) break;
                pom = 3;
                break;
            }
            case 2: {
                pom = 3;
                break;
            }
        }
        this.iSelectedMenuItem = iShift > 0 ? (this.iSelectedMenuItem + 1) % pom : (this.iSelectedMenuItem > 0 ? --this.iSelectedMenuItem : pom - 1);
    }

    public void keyReleased(int keyCode) {
        block0 : switch (this.screen) {
            case 0: {
                switch (this.subScreen) {
                    case 2: {
                        if (this.delay <= 100) break block0;
                        this.delay = 100;
                        break block0;
                    }
                    case 5: {
                        if (this.delay <= 300) break block0;
                        this.delay = 300;
                        break block0;
                    }
                    case 3: {
                        if (Keys.isActionPressed(1) || Keys.isKeyPressed(50)) {
                            this.changeLanguage(0);
                            return;
                        }
                        if (Keys.isActionPressed(2) || Keys.isKeyPressed(56)) {
                            this.changeLanguage(1);
                            return;
                        }
                        if (Keys.isActionPressed(3) || Keys.isKeyPressed(52)) {
                            this.changeLanguage(2);
                            return;
                        }
                        if (Keys.isActionPressed(4) || Keys.isKeyPressed(54)) {
                            this.changeLanguage(3);
                            return;
                        }
                        if (!Keys.isFKLeftCode(keyCode) && !Keys.isActionPressed(5) && !Keys.isKeyPressed(53)) break block0;
                        this.nextScreen(0, 4);
                        return;
                    }
                    case 4: {
                        if (Keys.isFKLeftCode(keyCode)) {
                            this.soundOn();
                            this.init();
                            return;
                        }
                        if (!Keys.isFKRightCode(keyCode)) break block0;
                        this.soundOff();
                        this.init();
                        return;
                    }
                }
                break;
            }
            case 1: {
                switch (this.subScreen) {
                    case 0: {
                        if (Keys.isActionPressed(2) || Keys.isKeyPressed(56)) {
                            this.changeSelectedMenuItem(1);
                            return;
                        }
                        if (Keys.isActionPressed(1) || Keys.isKeyPressed(50)) {
                            this.changeSelectedMenuItem(-1);
                            return;
                        }
                        if (Keys.isFKRightCode(keyCode)) {
                            this.nextScreen(1, 3);
                            return;
                        }
                        if (Keys.isFKLeftCode(keyCode)) {
                            this.changeSound();
                            return;
                        }
                        if (!Keys.isActionPressed(5) && !Keys.isKeyPressed(53)) break block0;
                        switch (this.iSelectedMenuItem) {
                            case 0: {
                                this.setAnimOutVars(1, 4);
                                break;
                            }
                            case 1: {
                                this.setAnimOutVars(1, 1);
                                break;
                            }
                            case 2: {
                                this.setAnimOutVars(1, 2);
                                break;
                            }
                        }
                        return;
                    }
                    case 1: {
                        if (!Keys.isFKRightCode(keyCode)) break block0;
                        this.nextScreen(1, 0);
                        return;
                    }
                    case 2: {
                        if (!Keys.isFKRightCode(keyCode)) break block0;
                        this.nextScreen(1, 0);
                        return;
                    }
                    case 3: {
                        if (Keys.isFKLeftCode(keyCode)) {
                            this.quit();
                            return;
                        }
                        if (!Keys.isFKRightCode(keyCode)) break block0;
                        this.nextScreen(1, 0);
                        return;
                    }
                    case 4: {
                        if (this.bAnimationIn) break block0;
                        if (Keys.isActionPressed(2) || Keys.isKeyPressed(56)) {
                            this.changeSelectedMenuItem(1);
                            return;
                        }
                        if (Keys.isActionPressed(1) || Keys.isKeyPressed(50)) {
                            this.changeSelectedMenuItem(-1);
                            return;
                        }
                        if (Keys.isFKRightCode(keyCode)) {
                            this.setAnimOutVars(1, 0);
                            return;
                        }
                        if (!Keys.isFKLeftCode(keyCode) && !Keys.isActionPressed(5) && !Keys.isKeyPressed(53)) break block0;
                        this.play(this.iSelectedMenuItem);
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                this.game.keyReleased(keyCode);
            }
        }
    }

    public void pointerPressed(int x, int y) {
        if (this.screen == 1 && this.subScreen == 1) {
            if (this.isPressedInstructionsText(x, y)) {
                this.bDragInstructions = true;
            }
        } else if (this.screen == 2 && this.subScreen == 0) {
            if (this.game.isPressedTutorialText(x, y)) {
                this.bDragInstructions = true;
            }
        } else if (this.screen == 2 && this.subScreen == 1) {
            if (!this.bStart) {
                this.game.pointerPressed(x, y);
            } else if (this.game.isPressedTutorialText(x, y)) {
                this.bDragInstructions = true;
            }
        }
    }

    public void quit() {
        X.quitApp();
    }

    public boolean isLeftButtonPressed(int x, int y) {
        return x <= this.imgYes.getWidth() + (this.imgYes.getWidth() >> 1) && y >= MainCanvas.HEIGHT - this.imgYes.getHeight() - (this.imgYes.getHeight() >> 1);
    }

    public boolean isRightButtonPressed(int x, int y) {
        return x >= MainCanvas.WIDTH - this.imgYes.getWidth() - (this.imgYes.getWidth() >> 1) && y >= MainCanvas.HEIGHT - this.imgYes.getHeight() - (this.imgYes.getHeight() >> 1);
    }

    public void pointerDragged(int x, int y) {
        if (this.screen == 1 && this.subScreen == 1) {
            if (this.bDragInstructions) {
                if (!this.isPressedInstructionsText(x, y)) {
                    this.bDragInstructions = false;
                }
                this.iTextShiftY += MainCanvas.lastPointerPressedY - y;
                MainCanvas.lastPointerPressedY = y;
            }
        } else if (this.screen == 2 && this.subScreen == 0 || this.screen == 2 && this.subScreen == 1 && this.bStart) {
            if (this.bDragInstructions) {
                if (!this.game.isPressedTutorialText(x, y)) {
                    this.bDragInstructions = false;
                }
                this.game.iTextShiftY += MainCanvas.lastPointerPressedY - y;
                MainCanvas.lastPointerPressedY = y;
            }
        } else if (this.screen == 2 && this.subScreen == 1) {
            this.game.pointerDragged(x, y);
        }
    }

    public void pointerReleased(int x, int y) {
        if ((this.screen == 1 && this.subScreen == 1 || this.screen == 2 && this.subScreen == 0 || this.screen == 2 && this.subScreen == 1 && this.bStart) && this.bDragInstructions) {
            this.bDragInstructions = false;
        }
        block0 : switch (this.screen) {
            case 0: {
                switch (this.subScreen) {
                    case 2: 
                    case 5: {
                        if (this.delay <= 100) break;
                        this.delay = 100;
                        break;
                    }
                    case 3: {
                        for (int i = 0; i < 5; ++i) {
                            if (!this.rectLanguages[i].contains(x, y)) continue;
                            this.iSelectedLanguage = i;
                            this.nextScreen(0, 4);
                            return;
                        }
                        break block0;
                    }
                    case 4: {
                        if (this.isLeftButtonPressed(x, y)) {
                            this.soundOn();
                            this.init();
                            return;
                        }
                        if (!this.isRightButtonPressed(x, y)) break;
                        this.soundOff();
                        this.init();
                        return;
                    }
                }
                break;
            }
            case 1: {
                switch (this.subScreen) {
                    case 0: {
                        if (this.isRightButtonPressed(x, y)) {
                            this.nextScreen(1, 3);
                            return;
                        }
                        if (this.isLeftButtonPressed(x, y)) {
                            this.changeSound();
                            return;
                        }
                        for (int i = 0; i < this.iMenuItemsTotal; ++i) {
                            if (!this.rectMenuItems[i].contains(x, y)) continue;
                            this.iSelectedMenuItem = i;
                            switch (this.iSelectedMenuItem) {
                                case 0: {
                                    this.setAnimOutVars(1, 4);
                                    break;
                                }
                                case 1: {
                                    this.setAnimOutVars(1, 1);
                                    break;
                                }
                                case 2: {
                                    this.setAnimOutVars(1, 2);
                                    break;
                                }
                            }
                            return;
                        }
                        break block0;
                    }
                    case 1: {
                        if (!this.isRightButtonPressed(x, y)) break;
                        this.nextScreen(1, 0);
                        return;
                    }
                    case 2: {
                        if (!this.isRightButtonPressed(x, y)) break;
                        this.nextScreen(1, 0);
                        return;
                    }
                    case 3: {
                        if (this.isLeftButtonPressed(x, y)) {
                            this.quit();
                            return;
                        }
                        if (!this.isRightButtonPressed(x, y)) break;
                        this.nextScreen(1, 0);
                        return;
                    }
                    case 4: {
                        if (!this.bAnimationIn) {
                            for (int i = 0; i < 3; ++i) {
                                if (!this.rectSelectGameItems[i].contains(x, y)) continue;
                                this.iSelectedMenuItem = i;
                                this.play(this.iSelectedMenuItem);
                                return;
                            }
                        }
                        if (!this.isRightButtonPressed(x, y)) break;
                        this.iSelectedMenuItem = 0;
                        this.setAnimOutVars(1, 0);
                        break;
                    }
                }
                break;
            }
            case 2: {
                this.game.pointerReleased(x, y);
                break;
            }
        }
    }

    public void afterHide() {
    }

    public void beforeShow() {
        Profile.load();
        this.screen = 0;
        this.subScreen = 0;
    }

    public void beforeInteruption() {
        if (this.screen != 0) {
            MainCanvas.soundManager.Stop();
            if (this.screen == 2 && this.subScreen == 1) {
                this.game.beforeInterruption();
            }
        }
        if (this.screen != 0) {
            MainCanvas.soundManager.Stop();
            if (this.screen == 2) {
                // empty if block
            }
        }
    }

    public void afterInteruption() {
        if (this.screen != 0) {
            if (this.screen == 2 && this.subScreen == 1) {
                this.playMusic(Sounds.MUSIC_GAME, -1);
            } else {
                this.playMusic(Sounds.MUSIC_MENU, -1);
            }
        }
    }

    public void initGraphics() {
        this.bLoading = true;
        this.game = new MainGame(this);
        Resources.loadGFonts(new int[]{0, 1});
        this.fontMain = Resources.resGFonts[0];
        this.fontNumbers = Resources.resGFonts[1];
        Resources.loadImages(new int[]{5, 7, 0, 1, 29, 27, 28, 6, 12, 8, 9, 10, 11, 13, 14, 15, 16, 17, 18, 19, 20, 22, 31, 24, 32, 33, 25, 23, 21, 26});
        Resources.loadImages(new int[]{2, 3, 4});
        this.img_MI_developer = Resources.resImgs[13];
        this.img_MI_info = Resources.resImgs[14];
        this.img_MI_menu = Resources.resImgs[15];
        this.img_MI_play = Resources.resImgs[16];
        this.img_MI_restart = Resources.resImgs[17];
        this.img_MI_score = Resources.resImgs[18];
        this.img_MI_play = Resources.resImgs[16];
        this.imgArrows[0] = Resources.resImgs[0];
        this.imgArrows[1] = Resources.resImgs[1];
        this.imgBackgrounds[0] = Resources.resImgs[2];
        this.imgBackgrounds[1] = Resources.resImgs[3];
        this.imgBackgrounds[2] = Resources.resImgs[4];
        this.imgGameTypes[0] = Resources.resImgs[27];
        this.imgGameTypes[1] = Resources.resImgs[29];
        this.imgGameTypes[2] = Resources.resImgs[28];
        this.imgLogo = Resources.resImgs[6];
        this.imgM_menu = Resources.resImgs[12];
        this.imgM_more = Resources.resImgs[8];
        this.imgM_music[0] = Resources.resImgs[9];
        this.imgM_music[1] = Resources.resImgs[10];
        this.imgM_quit = Resources.resImgs[11];
        this.imgNo = Resources.resImgs[22];
        this.imgO = Resources.resImgs[19];
        this.imgX = Resources.resImgs[20];
        this.imgScoreBar = Resources.resImgs[31];
        this.imgSmallScore = Resources.resImgs[24];
        this.imgSmallTime = Resources.resImgs[25];
        this.imgStar = Resources.resImgs[23];
        this.imgTitle = Resources.resImgs[21];
        this.imgYes = Resources.resImgs[26];
        this.imgSplash = Resources.resImgs[32];
        Resources.loadSprites(new int[]{5, 0, 1, 2, 3, 4});
        this.sprLanguage = Resources.resSprs[5];
        this.sprResultSkin = Resources.resSprs[3];
        this.sprSkin = Resources.resSprs[1];
        this.sprUndo = Resources.resSprs[4];
        this.sprCards = Resources.resSprs[0];
        this.sprHand = Resources.resSprs[2];
        this.imgCardBack = Resources.resImgs[7];
        this.imgCardHolder = Resources.resImgs[5];
        this.imgCardHolder2 = Resources.resImgs[33];
        this.nextScreen(0, 1);
        this.bLoading = false;
    }

    public void initIntro() {
        this.bLoading = true;
        int offsetY = this.imgScoreBar.getHeight() - this.imgM_menu.getHeight() >> 1;
        this.iControlBtnY = MainCanvas.HEIGHT - this.imgM_menu.getHeight() - offsetY;
        this.iControlBtnLeftX = offsetY;
        this.iControlBtnRightX = MainCanvas.WIDTH - this.imgM_menu.getWidth() - offsetY;
        this.iSelectedLanguage = 0;
        int ilangLeftX = (MainCanvas.WIDTH >> 1) - this.sprLanguage.getWidth() - (this.sprLanguage.getHeight() >> 1);
        int ilangRightX = (MainCanvas.WIDTH >> 1) + (this.sprLanguage.getHeight() >> 1);
        this.rectLanguages[0] = new Rectangle(ilangLeftX, (MainCanvas.HEIGHT >> 1) - (this.sprLanguage.getHeight() << 1), this.sprLanguage.getWidth(), this.sprLanguage.getHeight());
        this.rectLanguages[1] = new Rectangle(ilangRightX, (MainCanvas.HEIGHT >> 1) - (this.sprLanguage.getHeight() << 1), this.sprLanguage.getWidth(), this.sprLanguage.getHeight());
        this.rectLanguages[2] = new Rectangle(ilangLeftX, (MainCanvas.HEIGHT >> 1) - (this.sprLanguage.getHeight() >> 1), this.sprLanguage.getWidth(), this.sprLanguage.getHeight());
        this.rectLanguages[3] = new Rectangle(ilangRightX, (MainCanvas.HEIGHT >> 1) - (this.sprLanguage.getHeight() >> 1), this.sprLanguage.getWidth(), this.sprLanguage.getHeight());
        this.rectLanguages[4] = new Rectangle((MainCanvas.WIDTH >> 1) - (this.sprLanguage.getWidth() >> 1), (MainCanvas.HEIGHT >> 1) + this.sprLanguage.getHeight(), this.sprLanguage.getWidth(), this.sprLanguage.getHeight());
        int pomMenuButtonHeight = (this.fontMain.getHeight() << 2) + (this.fontMain.getHeight() >> 1);
        int pomMenuButtonWidth = MainCanvas.WIDTH - (MainCanvas.WIDTH >> 2);
        this.rectTitleCenter = new Rectangle((MainCanvas.WIDTH >> 1) - (pomMenuButtonWidth >> 1), (MainCanvas.HEIGHT >> 1) - (pomMenuButtonHeight >> 1), pomMenuButtonWidth, pomMenuButtonHeight);
        this.iShiftDirection = 1;
        this.iShiftX = 0;
        this.iShiftStep = MainCanvas.WIDTH / 120;
        if (MainCanvas.WIDTH > MainCanvas.HEIGHT) {
            this.iShiftStep = MainCanvas.HEIGHT / 160;
        }
        this.nextScreen(0, 2);
        this.bLoading = false;
    }

    public void init() {
        int i;
        this.bLoading = true;
        this.nextScreen(0, 5);
        Resources.freeSprites(new int[]{5});
        this.sprLanguage = null;
        System.gc();
        this.iAnimStep = this.img_MI_play.getWidth() >> 2;
        this.imagesMenuItems = new Image[3];
        this.imagesMenuItems[0] = this.img_MI_play;
        this.imagesMenuItems[1] = this.img_MI_info;
        this.imagesMenuItems[2] = this.img_MI_score;
        this.iTitleY = this.imgM_menu.getHeight() >> 1;
        this.iTitleX = (MainCanvas.WIDTH >> 1) - (this.imgTitle.getWidth() >> 1);
        int menuItemW = this.img_MI_play.getWidth();
        int menuItemH = this.img_MI_play.getHeight();
        int menuBtnOffset = this.imgM_menu.getHeight() >> 2;
        int menuItemsAreaH = MainCanvas.HEIGHT - this.imgTitle.getHeight() - this.iTitleY - this.imgScoreBar.getHeight();
        int menuItemStartOff = menuItemsAreaH - this.iMenuItemsTotal * this.img_MI_play.getHeight() - (this.iMenuItemsTotal - 1) * menuBtnOffset;
        int menuItemStartY = this.iTitleY + this.imgTitle.getHeight() + menuItemStartOff;
        this.iMenuItemX = (MainCanvas.WIDTH >> 1) - (menuItemW >> 1);
        this.rectMenuItems = new Rectangle[this.iMenuItemsTotal];
        for (i = 0; i < this.iMenuItemsTotal; ++i) {
            this.rectMenuItems[i] = new Rectangle(this.iMenuItemX, menuItemStartY + i * (menuItemH + menuBtnOffset), menuItemW, menuItemH);
        }
        this.rectSelectGameItems = new Rectangle[3];
        this.imagesSelectGameItems = new Image[3];
        for (i = 0; i < 3; ++i) {
            this.imagesSelectGameItems[i] = this.imgGameTypes[i];
        }
        for (i = 0; i < this.iMenuItemsTotal; ++i) {
            this.rectSelectGameItems[i] = new Rectangle((MainCanvas.WIDTH >> 1) - (menuItemW >> 1), menuItemStartY + i * (menuItemH + menuBtnOffset), menuItemW, menuItemH);
        }
        this.game.iPauseItemsTotal = 3;
        MainGame.rectPauseItems = new Rectangle[this.game.iPauseItemsTotal];
        this.game.imagesPauseItems = new Image[this.game.iPauseItemsTotal];
        this.game.imagesPauseItems[0] = this.img_MI_info;
        this.game.imagesPauseItems[2] = this.img_MI_menu;
        this.game.imagesPauseItems[1] = this.img_MI_restart;
        for (i = 0; i < MainGame.rectPauseItems.length; ++i) {
            MainGame.rectPauseItems[i] = new Rectangle((MainCanvas.WIDTH >> 1) - (menuItemW >> 1), menuItemStartY + i * (menuItemH + menuBtnOffset), menuItemW, menuItemH);
        }
        this.iAboutCenterY = this.iTitleY + this.imgTitle.getHeight() + (menuItemsAreaH >> 1);
        this.iAboutWidth = MainCanvas.WIDTH - (this.imgArrows[0].getWidth() << 1);
        this.iAboutHeight = this.imgLogo.getHeight() + (this.fontMain.getHeight() << 2) + this.fontMain.getHeight();
        this.iInstructionsCenterY = this.iAboutCenterY;
        this.iInstructionsWidth = this.iAboutWidth;
        this.iInstructionsHeight = menuItemsAreaH - this.imgArrows[0].getHeight();
        if (Profile.bMusic) {
            this.soundOn();
            MainCanvas.soundManager.Stop();
            MainCanvas.soundManager.Play(Sounds.MUSIC_MENU, -1);
        } else {
            this.soundOff();
        }
        this.game.initGameVarsOnlyFirst();
        this.bLoading = false;
    }

    public void initTexts() {
        Resources.initLangDirs(langCodes[this.iSelectedLanguage]);
        Resources.loadText(0);
        this.iSelectedMenuItem = 0;
        this.iMenuItemsTotal = 3;
    }

    public void setTexts() {
        block0 : switch (this.screen) {
            case 0: {
                this.iTextLines = 1;
                switch (this.subScreen) {
                    case 4: {
                        this.sTextTitle = Resources.resTexts[0].getHashedString(2);
                        this.setTitleCenter(this.sTextTitle);
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                this.iTextLines = 1;
                switch (this.subScreen) {
                    case 0: {
                        this.sTextMenu[0] = Resources.resTexts[0].getHashedString(8);
                        break block0;
                    }
                    case 1: {
                        this.sTextTitle = Resources.resTexts[0].getHashedString(8);
                        this.bLoading = true;
                        this.sTextPom[0] = Resources.resTexts[0].getHashedString(8) + "\n\n" + Resources.resTexts[0].getHashedString(26);
                        int textMaxWidth = this.iInstructionsWidth - (this.iInstructionsWidth >> 3);
                        this.prepText = new PreparedText(this.fontMain);
                        this.prepText.prepareText(this.sTextPom[0], textMaxWidth);
                        this.iTextLines = this.prepText.getTextHeight() / this.fontMain.getHeight();
                        int iTextYUp = this.iInstructionsCenterY - (this.iInstructionsHeight >> 1) + this.imgArrows[0].getHeight() * 3;
                        int iTextYDown = this.iInstructionsCenterY + (this.iInstructionsHeight >> 1) - this.imgArrows[0].getHeight() * 3;
                        int iTextHeight = iTextYDown - iTextYUp;
                        this.iTextShiftY = 0;
                        this.iInstructionsShiftY = 0;
                        this.iInstructionsMaxShiftY = this.prepText.getTextHeight() - iTextHeight;
                        this.bDragInstructions = false;
                        this.bLoading = false;
                        break block0;
                    }
                    case 2: {
                        this.sTextPom[0] = X.singleton.getAppProperty("MIDlet-Name").toUpperCase();
                        this.sTextPom[1] = Resources.resTexts[0].getHashedString(17) + " " + X.singleton.getAppProperty("MIDlet-Version").toUpperCase();
                        break block0;
                    }
                    case 3: {
                        this.sTextTitle = Resources.resTexts[0].getHashedString(12);
                        this.setTitleCenter(this.sTextTitle);
                        break block0;
                    }
                }
                break;
            }
        }
    }

    public void setTitleCenter(String s) {
        this.rectTitleCenter.height = this.fontMain.getHeight() + (this.fontMain.getHeight() >> 1);
        int textMaxWidth = this.rectTitleCenter.width - (this.rectTitleCenter.width >> 3);
        this.prepText = new PreparedText(this.fontMain);
        this.prepText.prepareText(s, textMaxWidth);
        this.iTextLines = this.prepText.getTextHeight() / this.fontMain.getHeight();
        if (this.iTextLines > 1) {
            this.rectTitleCenter.height += (this.iTextLines - 1) * this.fontMain.getHeight() + 1;
        }
    }

    public void play(int selectedGameType) {
        this.bLoading = true;
        System.gc();
        int gt = this.game.getSavedGameType();
        if (selectedGameType == gt) {
            this.game.bContinueSavedGame = true;
            this.game.loadGame(gt);
            this.sTextTitle = Resources.resTexts[0].getHashedString(19);
            this.setTitleCenter(this.sTextTitle);
            this.game.gameType = (byte)selectedGameType;
            this.nextScreen(2, 4);
        } else {
            this.game.bContinueSavedGame = false;
            this.game.initGame((byte)selectedGameType);
            this.game.initTutorialTexts();
            this.bStart = true;
            this.nextScreen(2, 1);
        }
        this.bLoading = false;
    }

    public void nextScreen(int nextScreen, int nextSubScreen) {
        this.screen = nextScreen;
        this.subScreen = nextSubScreen;
        block0 : switch (this.screen) {
            case 0: {
                switch (this.subScreen) {
                    case 4: {
                        this.initTexts();
                        break block0;
                    }
                    case 2: {
                        this.delay = 3000;
                        break block0;
                    }
                    case 5: {
                        this.delay = 3000;
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                if (this.subScreen == 0) {
                    this.iSelectedMenuItem = 0;
                    for (int i = 0; i < this.iMenuItemsTotal; ++i) {
                        this.rectMenuItems[i].x = 0 - this.rectMenuItems[i].width;
                    }
                    this.bAnimationIn = true;
                    break;
                }
                if (this.subScreen == 3) {
                    this.setTexts();
                    break;
                }
                if (this.subScreen != 4) break;
                this.iSelectedMenuItem = 0;
                for (int i = 0; i < 3; ++i) {
                    this.rectSelectGameItems[i].x = 0 - this.rectSelectGameItems[i].width;
                }
                this.bAnimationIn = true;
                break;
            }
            case 2: {
                if (this.subScreen != 3) break;
                this.iSelectedMenuItem = 0;
                for (int i = 0; i < MainGame.rectPauseItems.length; ++i) {
                    MainGame.rectPauseItems[i].x = 0 - MainGame.rectPauseItems[i].width;
                }
                this.bAnimationIn = true;
                break;
            }
        }
        this.setTexts();
    }

    public void paintTable(Graphics g, Sprite spr, int centerX, int centerY, int width, int height) {
        int i;
        if (height < spr.getHeight() << 1) {
            height = spr.getHeight() << 1;
        }
        int left = centerX - (width >> 1);
        int top = centerY - (height >> 1);
        int countX = (width - (spr.getWidth() << 1)) / spr.getWidth() + 1;
        int countY = (height - (spr.getHeight() << 1)) / spr.getHeight() + 1;
        int iHeight2 = height - (spr.getHeight() << 1);
        int iWidth2 = width - (spr.getWidth() << 1);
        int iX = left;
        int iY = top;
        spr.setFrame(0);
        spr.setPosition(iX, iY);
        spr.paint(g);
        g.setClip(iX, iY + spr.getHeight(), MainCanvas.WIDTH, iHeight2);
        for (i = 0; i < countY; ++i) {
            spr.setFrame(3);
            spr.setPosition(iX, iY += spr.getHeight());
            spr.paint(g);
        }
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        iY = top + height - spr.getHeight();
        spr.setFrame(6);
        spr.setPosition(iX, iY);
        spr.paint(g);
        g.setClip(iX + spr.getWidth(), top, iWidth2, MainCanvas.HEIGHT);
        for (i = 0; i < countX; ++i) {
            iY = top;
            spr.setFrame(1);
            spr.setPosition(iX += spr.getWidth(), iY);
            spr.paint(g);
            for (int j = 0; j < countY; ++j) {
                spr.setFrame(4);
                spr.setPosition(iX, iY += spr.getHeight());
                spr.paint(g);
            }
            iY = top + height - spr.getHeight();
            spr.setFrame(7);
            spr.setPosition(iX, iY);
            spr.paint(g);
        }
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        iX = left + width - spr.getWidth();
        iY = top;
        spr.setFrame(2);
        spr.setPosition(iX, iY);
        spr.paint(g);
        g.setClip(iX, iY + spr.getHeight(), MainCanvas.WIDTH, iHeight2);
        for (i = 0; i < countY; ++i) {
            spr.setFrame(5);
            spr.setPosition(iX, iY += spr.getHeight());
            spr.paint(g);
        }
        iY = top + height - spr.getHeight();
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        spr.setFrame(8);
        spr.setPosition(iX, iY);
        spr.paint(g);
    }

    public void playMusic(int type, int times) {
        MainCanvas.soundManager.Stop();
        MainCanvas.soundManager.Play(type, times);
    }
}

