/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;

public class SplitSprite {
    int x;
    int y;
    int[] leftGap;
    int[] topGap;
    int[] rightGap;
    Sprite[] spriteFrames;

    public SplitSprite(int x1, int y1) {
        this.x = x1;
        this.y = y1;
    }

    public void setXandY(int x1, int y1) {
        this.x = x1;
        this.y = y1;
    }

    public void setXandY(int x1, int y1, int frameNo) {
        this.x = x1 - (this.spriteFrames[frameNo].getWidth() >> 1);
        this.y = y1 - (this.spriteFrames[frameNo].getHeight() >> 1) - (frameNo >> 1);
        this.spriteFrames[frameNo].setPosition(this.x, this.y);
    }

    public void setLeftGap(int[] leftGap1) {
        this.leftGap = leftGap1;
    }

    public void setTopGap(int[] topGap1) {
        this.topGap = topGap1;
    }

    public void setRightGap(int[] rightGap1) {
        this.rightGap = rightGap1;
    }

    public void setSpriteFrames(Sprite[] frames1) {
        this.spriteFrames = frames1;
    }

    public void paintTheBatsman(Graphics g, int frameNo) {
        if (this.spriteFrames != null && frameNo < this.spriteFrames.length) {
            if (DisplayableCanvas.isRightHandBatsMan) {
                this.spriteFrames[frameNo].setTransform(0);
                this.spriteFrames[frameNo].setPosition(this.x + this.leftGap[frameNo], this.y + this.topGap[frameNo]);
            } else {
                this.spriteFrames[frameNo].setTransform(2);
                this.spriteFrames[frameNo].setPosition(this.x + this.rightGap[frameNo], this.y + this.topGap[frameNo]);
            }
            this.spriteFrames[frameNo].paint(g);
        }
    }

    public void paintTheBowler(Graphics g, int frameNo) {
        if (this.spriteFrames != null && frameNo < this.spriteFrames.length) {
            if (DisplayableCanvas.isRightHandBowler) {
                this.spriteFrames[frameNo].setTransform(0);
                this.spriteFrames[frameNo].setPosition(this.x + this.leftGap[frameNo], this.y + this.topGap[frameNo]);
            } else {
                this.spriteFrames[frameNo].setTransform(2);
                this.spriteFrames[frameNo].setPosition(this.x + this.rightGap[frameNo], this.y + this.topGap[frameNo]);
            }
            this.spriteFrames[frameNo].paint(g);
        }
    }

    public void paintTheBowlerStumping(Graphics g, int frameNo) {
        if (this.spriteFrames != null && frameNo < this.spriteFrames.length) {
            if (this.x + this.leftGap[frameNo] < (DisplayableCanvas.WORLD_WIDTH >> 1) - 20) {
                this.spriteFrames[frameNo].setTransform(0);
                this.spriteFrames[frameNo].setPosition(this.x + this.leftGap[frameNo], this.y + this.topGap[frameNo]);
            } else {
                this.spriteFrames[frameNo].setTransform(2);
                this.spriteFrames[frameNo].setPosition(this.x + this.rightGap[frameNo], this.y + this.topGap[frameNo]);
            }
            this.spriteFrames[frameNo].paint(g);
        }
    }

    public void paintTheKeeper(Graphics g, int frameNo) {
        if (this.spriteFrames != null && frameNo < this.spriteFrames.length) {
            if (DisplayableCanvas.keeperAction == 0) {
                this.spriteFrames[frameNo].setTransform(0);
                this.spriteFrames[frameNo].setPosition(this.x + this.leftGap[frameNo], this.y + this.topGap[frameNo]);
            } else if (DisplayableCanvas.keeperAction == 1) {
                this.spriteFrames[frameNo].setTransform(0);
                this.spriteFrames[frameNo].setPosition(this.x + this.leftGap[frameNo], this.y + this.topGap[frameNo]);
            } else if (DisplayableCanvas.deviationAngle < -DisplayableCanvas.diveAngle) {
                this.spriteFrames[frameNo].setTransform(2);
                this.spriteFrames[frameNo].setPosition(this.x + this.rightGap[frameNo], this.y + this.topGap[frameNo]);
            } else {
                this.spriteFrames[frameNo].setTransform(0);
                this.spriteFrames[frameNo].setPosition(this.x + this.leftGap[frameNo], this.y + this.topGap[frameNo]);
            }
            this.spriteFrames[frameNo].paint(g);
        }
    }

    public void paintTheRunner(Graphics g, int frameNo, boolean isRightHandBatsMan) {
        if (this.spriteFrames != null && frameNo < this.spriteFrames.length) {
            if (isRightHandBatsMan) {
                this.spriteFrames[frameNo].setTransform(0);
                this.spriteFrames[frameNo].setPosition(this.x + this.leftGap[frameNo], this.y + this.topGap[frameNo]);
            } else {
                this.spriteFrames[frameNo].setTransform(2);
                this.spriteFrames[frameNo].setPosition(this.x + this.rightGap[frameNo], this.y + this.topGap[frameNo]);
            }
            this.spriteFrames[frameNo].paint(g);
        }
    }

    public void paintTheFielders(Graphics g, int frameNo, boolean isFlip) {
        if (this.spriteFrames != null && frameNo < this.spriteFrames.length) {
            if (!isFlip) {
                this.spriteFrames[frameNo].setTransform(0);
            } else {
                this.spriteFrames[frameNo].setTransform(2);
            }
            this.spriteFrames[frameNo].setPosition(this.x + this.leftGap[frameNo], this.y + this.topGap[frameNo]);
            this.spriteFrames[frameNo].paint(g);
        }
    }

    public void paint(Graphics g, int frameNo) {
        if (this.spriteFrames != null && frameNo < this.spriteFrames.length) {
            this.spriteFrames[frameNo].setPosition(this.x + this.leftGap[frameNo], this.y + this.topGap[frameNo]);
            this.spriteFrames[frameNo].paint(g);
        }
    }
}

