/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotOpenException;

public class CricketTeam {
    int totalRuns;
    int runballNo;
    int bowlingBallNo;
    String teamName;
    byte teamIndex;
    byte captainIndex;
    byte keeperIndex;
    byte wickets;
    int extras;
    String[] playersNames = new String[11];
    byte[] isOut = new byte[this.playersNames.length];
    int[] takenRuns = new int[this.playersNames.length];
    int[] takenBalls = new int[this.playersNames.length];
    int[] strikeRate = new int[this.playersNames.length];
    int[] takenFours = new int[this.playersNames.length];
    int[] takenSix = new int[this.playersNames.length];
    int[] fallOfWickets = new int[this.playersNames.length];
    boolean[] isRightHandBatsman = new boolean[this.playersNames.length];
    int[] givenBalls = new int[this.playersNames.length];
    byte[] maidenOvers = new byte[this.playersNames.length];
    int[] givenRuns = new int[this.playersNames.length];
    int[] givenWideBalls = new int[this.playersNames.length];
    byte[] takenWickets = new byte[this.playersNames.length];
    int[] economy = new int[this.playersNames.length];
    boolean[] isRightHandBowler = new boolean[this.playersNames.length];
    byte[] isBowlerType = new byte[this.playersNames.length];
    byte isPlaying;
    RecordStore rs;

    public CricketTeam(String teamName, byte teamIndex) {
        this.teamName = teamName;
        this.teamIndex = teamIndex;
        this.reset();
    }

    public void reset() {
        int i;
        this.runballNo = 0;
        this.bowlingBallNo = 0;
        this.extras = 0;
        this.captainIndex = 0;
        this.wickets = 0;
        this.isPlaying = 0;
        for (i = 0; i < this.playersNames.length; i = (int)((byte)(i + 1))) {
            this.playersNames[i] = Constants.playerNames[this.teamIndex][i];
            this.isOut[i] = 0;
            this.takenRuns[i] = 0;
            this.takenBalls[i] = 0;
            this.strikeRate[i] = 0;
            this.takenFours[i] = 0;
            this.takenSix[i] = 0;
            this.fallOfWickets[i] = 0;
            this.isRightHandBatsman[i] = true;
            this.givenBalls[i] = 0;
            this.maidenOvers[i] = 0;
            this.givenRuns[i] = 0;
            this.givenWideBalls[i] = 0;
            this.takenWickets[i] = 0;
            this.economy[i] = 0;
            this.isRightHandBowler[i] = true;
            this.isBowlerType[i] = 3;
        }
        this.isBowlerType[Math.abs((int)(DisplayableCanvas.rand.nextInt() % 2))] = 0;
        this.isBowlerType[2 + Math.abs((int)(DisplayableCanvas.rand.nextInt() % 2))] = 1;
        this.isBowlerType[4 + Math.abs((int)(DisplayableCanvas.rand.nextInt() % 2))] = 0;
        this.isBowlerType[6 + Math.abs((int)(DisplayableCanvas.rand.nextInt() % 2))] = 2;
        this.isBowlerType[8 + Math.abs((int)(DisplayableCanvas.rand.nextInt() % 2))] = 0;
        this.isBowlerType[10] = 0;
        this.keeperIndex = (byte)Math.abs(DisplayableCanvas.rand.nextInt() % this.playersNames.length);
        this.isBowlerType[this.keeperIndex] = 3;
        for (i = 0; i < 3; i = (int)((byte)(i + 1))) {
            this.isRightHandBatsman[Math.abs((int)(DisplayableCanvas.rand.nextInt() % this.playersNames.length))] = false;
        }
        this.totalRuns = 0;
    }

    public void resetTheRuns() {
        this.totalRuns = 0;
        for (int i = 0; i < this.playersNames.length; i = (int)((byte)(i + 1))) {
            this.takenRuns[i] = 0;
            this.isOut[i] = 0;
            this.takenBalls[i] = 0;
            this.strikeRate[i] = 0;
            this.takenFours[i] = 0;
            this.takenSix[i] = 0;
            this.fallOfWickets[i] = 0;
            this.economy[i] = 0;
        }
        this.extras = 0;
        this.runballNo = 0;
    }

    public void resetTheRunsAndBowls() {
        this.totalRuns = 0;
        for (int i = 0; i < this.playersNames.length; i = (int)((byte)(i + 1))) {
            this.takenRuns[i] = 0;
            this.isOut[i] = 0;
            this.strikeRate[i] = 0;
            this.fallOfWickets[i] = 0;
            this.givenBalls[i] = 0;
            this.givenRuns[i] = 0;
            this.givenWideBalls[i] = 0;
            this.takenBalls[i] = 0;
            this.takenFours[i] = 0;
            this.takenSix[i] = 0;
            this.takenWickets[i] = 0;
        }
        this.extras = 0;
        this.runballNo = 0;
        this.bowlingBallNo = 0;
        this.wickets = 0;
    }

    public void clear() {
        for (int i = 0; i < this.playersNames.length; i = (int)((byte)(i + 1))) {
            this.playersNames[i] = null;
        }
        this.isOut = null;
        this.takenRuns = null;
        this.takenBalls = null;
        this.strikeRate = null;
        this.takenFours = null;
        this.takenWickets = null;
        this.takenSix = null;
        this.fallOfWickets = null;
        this.isRightHandBatsman = null;
        this.givenBalls = null;
        this.maidenOvers = null;
        this.givenRuns = null;
        this.givenWideBalls = null;
        this.economy = null;
        this.isRightHandBowler = null;
        this.isBowlerType = null;
    }

    public void calculateTheTotalRuns() {
        this.totalRuns = 0;
        for (int i = 0; i < this.playersNames.length; i = (int)((byte)(i + 1))) {
            this.totalRuns += this.takenRuns[i];
        }
        this.totalRuns += this.extras;
    }

    public void readFromRMS(int rmsIndex) {
        try {
            switch (rmsIndex) {
                case 0: {
                    this.rs = RecordStore.openRecordStore((String)"QplayerRMS", (boolean)true);
                    break;
                }
                case 1: {
                    this.rs = RecordStore.openRecordStore((String)"QopponentRMS", (boolean)true);
                    break;
                }
                case 2: {
                    this.rs = RecordStore.openRecordStore((String)"TplayerRMS", (boolean)true);
                    break;
                }
                case 3: {
                    this.rs = RecordStore.openRecordStore((String)"TopponentRMS", (boolean)true);
                }
            }
            if (this.rs.getNumRecords() > 0) {
                byte[] rec = this.rs.getRecord(1);
                DataInputStream DIN = new DataInputStream(new ByteArrayInputStream(rec, 0, rec.length));
                this.runballNo = DIN.readInt();
                this.bowlingBallNo = DIN.readInt();
                this.extras = DIN.readInt();
                this.totalRuns = DIN.readInt();
                this.teamName = DIN.readUTF();
                this.teamIndex = DIN.readByte();
                this.captainIndex = DIN.readByte();
                this.keeperIndex = DIN.readByte();
                this.wickets = DIN.readByte();
                this.isPlaying = DIN.readByte();
                DisplayableCanvas.totalOvers = DIN.readInt();
                for (int i = 0; i < this.playersNames.length; i = (int)((byte)(i + 1))) {
                    rec = this.rs.getRecord(i + 2);
                    DIN = new DataInputStream(new ByteArrayInputStream(rec, 0, rec.length));
                    this.playersNames[i] = DIN.readUTF();
                    this.isOut[i] = DIN.readByte();
                    this.takenRuns[i] = DIN.readInt();
                    this.takenBalls[i] = DIN.readInt();
                    this.strikeRate[i] = DIN.readInt();
                    this.takenFours[i] = DIN.readInt();
                    this.takenSix[i] = DIN.readInt();
                    this.fallOfWickets[i] = DIN.readInt();
                    this.isRightHandBatsman[i] = DIN.readBoolean();
                    this.givenBalls[i] = DIN.readInt();
                    this.maidenOvers[i] = DIN.readByte();
                    this.givenRuns[i] = DIN.readInt();
                    this.givenWideBalls[i] = DIN.readInt();
                    this.takenWickets[i] = DIN.readByte();
                    this.economy[i] = DIN.readInt();
                    this.isRightHandBowler[i] = DIN.readBoolean();
                    this.isBowlerType[i] = DIN.readByte();
                }
                DIN.close();
            } else {
                System.out.println("No records found");
            }
            this.rs.closeRecordStore();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveInToRMS(int rmsIndex) {
        this.calculateTheTotalRuns();
        String recordStoreName = "";
        try {
            switch (rmsIndex) {
                case 0: {
                    recordStoreName = "QplayerRMS";
                    break;
                }
                case 1: {
                    recordStoreName = "QopponentRMS";
                    break;
                }
                case 2: {
                    recordStoreName = "TplayerRMS";
                    break;
                }
                case 3: {
                    recordStoreName = "TopponentRMS";
                }
            }
            System.out.println("recordStoreName:" + recordStoreName);
            try {
                RecordStore.deleteRecordStore((String)recordStoreName);
                System.out.println("Successfully Deleted The Record");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.rs = RecordStore.openRecordStore((String)recordStoreName, (boolean)true);
            byte[] rec = null;
            ByteArrayOutputStream BA = new ByteArrayOutputStream();
            DataOutputStream DOS = new DataOutputStream(BA);
            DOS.writeInt(this.runballNo);
            DOS.writeInt(this.bowlingBallNo);
            DOS.writeInt(this.extras);
            DOS.writeInt(this.totalRuns);
            DOS.writeUTF(this.teamName);
            DOS.writeByte(this.teamIndex);
            DOS.writeByte(this.captainIndex);
            DOS.writeByte(this.keeperIndex);
            DOS.writeByte(this.wickets);
            DOS.writeByte(this.isPlaying);
            DOS.writeInt(DisplayableCanvas.totalOvers);
            DOS.flush();
            rec = BA.toByteArray();
            this.rs.addRecord(rec, 0, rec.length);
            BA.reset();
            for (int i = 0; i < this.playersNames.length; i = (int)((byte)(i + 1))) {
                BA = new ByteArrayOutputStream();
                DOS = new DataOutputStream(BA);
                DOS.writeUTF(this.playersNames[i]);
                DOS.writeByte(this.isOut[i]);
                DOS.writeInt(this.takenRuns[i]);
                DOS.writeInt(this.takenBalls[i]);
                DOS.writeInt(this.strikeRate[i]);
                DOS.writeInt(this.takenFours[i]);
                DOS.writeInt(this.takenSix[i]);
                DOS.writeInt(this.fallOfWickets[i]);
                DOS.writeBoolean(this.isRightHandBatsman[i]);
                DOS.writeInt(this.givenBalls[i]);
                DOS.writeByte(this.maidenOvers[i]);
                DOS.writeInt(this.givenRuns[i]);
                DOS.writeInt(this.givenWideBalls[i]);
                DOS.writeByte(this.takenWickets[i]);
                DOS.writeInt(this.economy[i]);
                DOS.writeBoolean(this.isRightHandBowler[i]);
                DOS.writeByte(this.isBowlerType[i]);
                DOS.flush();
                rec = BA.toByteArray();
                this.rs.addRecord(rec, 0, rec.length);
                BA.reset();
            }
            BA.close();
            DOS.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.rs.closeRecordStore();
            }
            catch (RecordStoreNotOpenException ex) {
                ex.printStackTrace();
            }
            catch (RecordStoreException ex) {
                ex.printStackTrace();
            }
        }
    }
}

