/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class DrawString {
    public Image[] imgFont;
    public static final byte[][] fontWidth = new byte[][]{{3, 4, 9, 6, 10, 8, 2, 4, 4, 6, 6, 3, 4, 3, 5, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 3, 3, 6, 6, 6, 6, 8, 7, 7, 6, 8, 6, 6, 7, 8, 5, 5, 7, 6, 8, 8, 8, 7, 8, 7, 6, 7, 8, 7, 11, 7, 7, 7, 4, 5, 4, 6, 4, 4, 7, 7, 6, 7, 7, 4, 7, 7, 3, 4, 7, 3, 11, 7, 7, 7, 7, 5, 6, 5, 7, 7, 11, 7, 7, 7, 6, 3, 6, 6, 0, 0}, {13, 11, 12, 11, 10, 10, 13, 12, 4, 9, 12, 10, 14, 11, 13, 10, 13, 11, 11, 11, 11, 12, 17, 12, 12, 11}, {14, 12, 12, 13, 11, 11, 13, 12, 5, 10, 12, 11, 16, 12, 13, 12, 13, 13, 12, 13, 12, 13, 19, 13, 13, 11}};
    public final byte[] size = new byte[]{13, 14, 17, 14, 20, 21};

    public DrawString() {
        try {
            this.imgFont = new Image[3];
            this.imgFont[0] = Image.createImage((String)"/res/drawstring/datafont.png");
            this.imgFont[1] = Image.createImage((String)"/res/drawstring/headingfont.png");
            this.imgFont[2] = Image.createImage((String)"/res/drawstring/menufont.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void drawString(String str, Graphics g, int xpos, int ypos, int fontType, int width, int align) {
        char[] cr = str.toCharArray();
        int lastWordIndex = 0;
        int x = 0;
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipW = g.getClipWidth();
        int clipH = g.getClipHeight();
        int imageOffset = fontType == 0 ? 33 : 65;
        boolean longline = false;
        for (int i = 0; i < cr.length; ++i) {
            int line = 0;
            int word = 0;
            int index = i;
            int lineStartIndex = i;
            while (line + word <= width) {
                if (index == cr.length || cr[index] == '\n') {
                    line += word;
                    lastWordIndex = index;
                    break;
                }
                if (cr[index] == ' ' || cr[index] == '\u00a0') {
                    line += word;
                    lastWordIndex = index;
                    word = 5;
                } else if (cr[index] > ' ' && cr[index] <= '\u007f') {
                    if (line == 0 && (word += fontWidth[fontType][cr[index] - imageOffset]) > width) {
                        line += word;
                        lastWordIndex = index;
                        longline = true;
                        break;
                    }
                } else {
                    line += word;
                    lastWordIndex = index;
                    word = 3;
                }
                ++index;
            }
            int n = align == 0 ? xpos : (x = align == 1 ? xpos + (width - line >> 1) : xpos + width - line);
            if (ypos >= clipY - this.size[1]) {
                for (int j = lineStartIndex; j < lastWordIndex; ++j) {
                    index = cr[j] - imageOffset;
                    if (cr[j] <= ' ' || cr[j] == '\u00a0') {
                        x += 5;
                    } else if (cr[j] <= '\u007f') {
                        g.clipRect(x, ypos, fontWidth[fontType][index] + 1, (int)this.size[fontType * 2 + 1]);
                        g.drawImage(this.imgFont[fontType], x - (index >> 4) * this.size[fontType * 2], ypos - (index & 0xF) * this.size[fontType * 2 + 1], 20);
                        x += fontWidth[fontType][index];
                    } else if (cr[j] == '\u2019' || cr[j] == '\u2018' || cr[j] == '\u201b') {
                        cr[j] = 39;
                        index = cr[j] - imageOffset;
                        g.clipRect(x, ypos, fontWidth[fontType][index] + 1, (int)this.size[fontType * 2 + 1]);
                        g.drawImage(this.imgFont[fontType], x - (index >> 4) * this.size[fontType * 2], ypos - (index & 0xF) * this.size[fontType * 2 + 1], 20);
                        x += fontWidth[fontType][index];
                    } else {
                        x += 3;
                    }
                    g.setClip(clipX, clipY, clipW, clipH);
                }
            }
            g.setClip(clipX, clipY, clipW, clipH);
            ypos += this.size[fontType * 2 + 1];
            if (fontType > 0) {
                ypos += 2;
            }
            i = lastWordIndex - (longline ? 1 : 0);
            longline = false;
            if (ypos > clipY + clipH) break;
        }
    }

    public static int findWidth(String str, int fontType) {
        int width = 0;
        char[] cr = str.toCharArray();
        int imageOffset = 33;
        for (int i = 0; i < cr.length; ++i) {
            if (cr[i] == ' ' || cr[i] == '\u00a0') {
                width += 5;
                continue;
            }
            width += fontWidth[fontType][cr[i] - imageOffset];
        }
        return width;
    }

    public static int findLines(String str, int fontType, int width) {
        int lines = 0;
        char[] cr = str.toCharArray();
        int imageOffset = 33;
        int lastWordIndex = 0;
        boolean x = false;
        boolean longline = false;
        for (int i = 0; i < cr.length; ++i) {
            int line = 0;
            int word = 0;
            int index = i;
            int lineStartIndex = i;
            while (line + word <= width) {
                if (index == cr.length || cr[index] == '\n') {
                    line += word;
                    lastWordIndex = index;
                    break;
                }
                if (cr[index] == ' ' || cr[index] == '\u00a0') {
                    line += word;
                    lastWordIndex = index;
                    word = 5;
                } else if (cr[index] > ' ' && cr[index] <= '\u007f') {
                    try {
                        word += fontWidth[fontType][cr[index] - imageOffset];
                    }
                    catch (Exception e) {
                        System.out.println("cr[index]1:" + cr[index]);
                    }
                    if (line == 0 && word > width) {
                        line += word;
                        lastWordIndex = index;
                        longline = true;
                        break;
                    }
                } else {
                    line += word;
                    lastWordIndex = index;
                    word = 3;
                }
                ++index;
            }
            ++lines;
            i = lastWordIndex - (longline ? 1 : 0);
            longline = false;
        }
        return lines;
    }
}

