/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;

public class ScrollView {
    int x;
    int y;
    int width;
    int height;
    int totalHeight;
    int totalWidth;
    int remainingHeight = 400;
    int remainingWidth = 400;
    String data = "scroll data";
    Object[] datas;
    int dataColor = 0;
    int dataX;
    int dataY;
    private int touchX;
    private int touchY;
    protected byte scrollState = 0;
    protected int scrollRatio = 1;
    protected int clickedItemIndex = -1;
    private boolean canScroll;
    protected static final byte VERTICAL = 0;
    protected static final byte HORIZONTAL = 1;
    byte scrollType = 0;
    private int scrollBarY;
    private int scrollBarHeight;
    protected int scrollBarX;
    private int scrollBarWidth;
    private int leftSpace;
    private int rightSpace;
    private int topSpace;
    private int bottomSpace;
    protected int speed;
    private byte counter;
    protected byte lastItemIndex;
    protected int paintStartIndex = 0;
    protected int paintEndIndex = -1;
    GameCanvas context;
    Thread thread;
    protected boolean isEqualSized;
    protected boolean startThread;
    int equalHeight = 0;
    byte[] tempIndex;

    protected ScrollView(int x, int y, int width, int height, int noofitem, byte scrollType, GameCanvas context) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.dataX = x;
        this.dataY = y;
        this.scrollType = scrollType;
        this.context = context;
        this.datas = new Object[noofitem];
        if (scrollType == 0) {
            this.scrollBarY = y;
        } else if (scrollType == 1) {
            this.scrollBarX = x;
        }
        this.isEqualSized = false;
    }

    protected void setXYAndWH(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.dataX = x;
        this.dataY = y;
        if (this.scrollType == 0) {
            this.scrollBarY = y;
        } else if (this.scrollType == 1) {
            this.scrollBarX = x;
        }
    }

    protected void setMarginSpace(int left, int right, int top, int bottom) {
        this.leftSpace = left;
        this.rightSpace = right;
        this.topSpace = top;
        this.bottomSpace = bottom;
    }

    protected void addItem(Object obj) {
        boolean isCorrectItem = false;
        if (this.lastItemIndex < this.datas.length) {
            if (obj instanceof Button) {
                isCorrectItem = true;
                Button buttonItem = (Button)obj;
                if (this.scrollType == 0) {
                    buttonItem.x = this.x + buttonItem.x;
                    buttonItem.y = this.getItemYAt(this.lastItemIndex - 1) + this.getItemHeightAt(this.lastItemIndex - 1);
                } else if (this.scrollType == 1) {
                    buttonItem.y = this.y + buttonItem.y;
                    buttonItem.x = this.getItemXAt(this.lastItemIndex - 1) + this.getItemWidthAt(this.lastItemIndex - 1);
                }
                buttonItem.height += this.topSpace + this.bottomSpace;
                buttonItem.width += this.leftSpace + this.rightSpace;
                this.totalHeight += buttonItem.height;
                this.totalWidth += buttonItem.width;
            } else if (obj instanceof StringItem) {
                isCorrectItem = true;
                StringItem strItem = (StringItem)obj;
                if (this.scrollType == 0) {
                    strItem.x = this.x + strItem.x;
                    strItem.y = this.getItemYAt(this.lastItemIndex - 1) + this.getItemHeightAt(this.lastItemIndex - 1);
                } else if (this.scrollType == 1) {
                    strItem.y = this.y + strItem.y;
                    strItem.x = this.getItemXAt(this.lastItemIndex - 1) + this.getItemWidthAt(this.lastItemIndex - 1);
                }
                strItem.height += this.topSpace + this.bottomSpace;
                strItem.width += this.leftSpace + this.rightSpace;
                this.totalHeight += strItem.height;
                this.totalWidth += strItem.width;
            } else if (obj instanceof Image) {
                isCorrectItem = true;
                ImageItem imgItem = null;
                if (this.scrollType == 0) {
                    imgItem = new ImageItem((Image)obj, this.x, this.getItemYAt(this.lastItemIndex - 1) + this.getItemHeightAt(this.lastItemIndex - 1), 3, this);
                } else if (this.scrollType == 1) {
                    imgItem = new ImageItem((Image)obj, this.getItemXAt(this.lastItemIndex - 1) + this.getItemWidthAt(this.lastItemIndex - 1), this.y, 3, this);
                }
                imgItem.height += this.topSpace + this.bottomSpace;
                imgItem.width += this.leftSpace + this.rightSpace;
                this.totalHeight += imgItem.height;
                this.totalWidth += imgItem.width;
                obj = imgItem;
            } else if (obj instanceof String) {
                isCorrectItem = true;
                StringItem strItem = null;
                if (this.scrollType == 0) {
                    strItem = new StringItem(String.valueOf(obj), this.getItemXAt(this.lastItemIndex - 1), this.getItemYAt(this.lastItemIndex - 1) + this.getItemHeightAt(this.lastItemIndex - 1), this.width, SystemFont.font1);
                } else if (this.scrollType == 1) {
                    strItem = new StringItem(String.valueOf(obj), this.getItemXAt(this.lastItemIndex - 1) + this.getItemWidthAt(this.lastItemIndex - 1), this.getItemYAt(this.lastItemIndex - 1), this.width, SystemFont.font1);
                }
                this.totalHeight += strItem.height;
                this.totalWidth += strItem.width;
                obj = strItem;
            }
            if (isCorrectItem) {
                this.datas[this.lastItemIndex] = obj;
                this.remainingWidth = this.totalWidth - this.width;
                if (this.remainingWidth < 0) {
                    this.remainingWidth = 0;
                }
                this.remainingHeight = this.totalHeight - this.height;
                if (this.remainingHeight < 0) {
                    this.remainingHeight = 0;
                }
                this.lastItemIndex = (byte)(this.lastItemIndex + 1);
                this.paintEndIndex = this.lastItemIndex;
                this.refreshTheScrollBar();
            }
        }
    }

    protected void addItemByEqualSize(Object obj, int equalWidth, int equalHeight) {
        boolean isCorrectItem = false;
        this.equalHeight = equalHeight;
        if (this.lastItemIndex < this.datas.length) {
            if (obj instanceof Button) {
                isCorrectItem = true;
                Button buttonItem = (Button)obj;
                if (this.scrollType == 0) {
                    buttonItem.x = this.x + buttonItem.x;
                    buttonItem.y = this.getItemYAt(this.lastItemIndex - 1) + this.getItemHeightAt(this.lastItemIndex - 1);
                } else if (this.scrollType == 1) {
                    buttonItem.y = this.y + buttonItem.y;
                    buttonItem.x = this.getItemXAt(this.lastItemIndex - 1) + this.getItemWidthAt(this.lastItemIndex - 1);
                }
                buttonItem.height += this.topSpace + this.bottomSpace;
                buttonItem.width += this.leftSpace + this.rightSpace;
                if (buttonItem.width < equalWidth) {
                    buttonItem.width = equalWidth;
                }
                if (buttonItem.height < equalHeight) {
                    buttonItem.height = equalHeight;
                }
                this.totalHeight += buttonItem.height;
                this.totalWidth += buttonItem.width;
            } else if (obj instanceof StringItem) {
                isCorrectItem = true;
                StringItem strItem = (StringItem)obj;
                if (this.scrollType == 0) {
                    strItem.x = this.x + strItem.x;
                    strItem.y = this.getItemYAt(this.lastItemIndex - 1) + this.getItemHeightAt(this.lastItemIndex - 1);
                } else if (this.scrollType == 1) {
                    strItem.y = this.y + strItem.y;
                    strItem.x = this.getItemXAt(this.lastItemIndex - 1) + this.getItemWidthAt(this.lastItemIndex - 1);
                }
                strItem.height += this.topSpace + this.bottomSpace;
                strItem.width += this.leftSpace + this.rightSpace;
                if (strItem.width < equalWidth) {
                    strItem.width = equalWidth;
                }
                if (strItem.height < equalHeight) {
                    strItem.height = equalHeight;
                }
                this.totalHeight += strItem.height;
                this.totalWidth += strItem.width;
            } else if (obj instanceof Image) {
                isCorrectItem = true;
                ImageItem imgItem = null;
                if (this.scrollType == 0) {
                    imgItem = new ImageItem((Image)obj, this.x, this.getItemYAt(this.lastItemIndex - 1) + this.getItemHeightAt(this.lastItemIndex - 1), 3, this);
                } else if (this.scrollType == 1) {
                    imgItem = new ImageItem((Image)obj, this.getItemXAt(this.lastItemIndex - 1) + this.getItemWidthAt(this.lastItemIndex - 1), this.y, 3, this);
                }
                imgItem.height += this.topSpace + this.bottomSpace;
                imgItem.width += this.leftSpace + this.rightSpace;
                if (imgItem.width < equalWidth) {
                    imgItem.width = equalWidth;
                }
                if (imgItem.height < equalHeight) {
                    imgItem.height = equalHeight;
                }
                this.totalHeight += imgItem.height;
                this.totalWidth += imgItem.width;
                obj = imgItem;
            } else if (obj instanceof String) {
                isCorrectItem = true;
                StringItem strItem = null;
                if (this.scrollType == 0) {
                    strItem = new StringItem(String.valueOf(obj), this.getItemXAt(this.lastItemIndex - 1), this.getItemYAt(this.lastItemIndex - 1) + this.getItemHeightAt(this.lastItemIndex - 1), this.width, SystemFont.font1);
                } else if (this.scrollType == 1) {
                    strItem = new StringItem(String.valueOf(obj), this.getItemXAt(this.lastItemIndex - 1) + this.getItemWidthAt(this.lastItemIndex - 1), this.getItemYAt(this.lastItemIndex - 1), this.width, SystemFont.font1);
                }
                strItem.height += this.topSpace + this.bottomSpace;
                strItem.width += this.leftSpace + this.rightSpace;
                if (strItem.width < equalWidth) {
                    strItem.width = equalWidth;
                }
                if (strItem.height < equalHeight) {
                    strItem.height = equalHeight;
                }
                this.totalHeight += strItem.height;
                this.totalWidth += strItem.width;
                obj = strItem;
            }
            if (isCorrectItem) {
                this.datas[this.lastItemIndex] = obj;
                this.remainingWidth = this.totalWidth - this.width;
                if (this.remainingWidth < 0) {
                    this.remainingWidth = 0;
                }
                this.remainingHeight = this.totalHeight - this.height;
                if (this.remainingHeight < 0) {
                    this.remainingHeight = 0;
                }
                this.lastItemIndex = (byte)(this.lastItemIndex + 1);
                this.paintEndIndex = this.lastItemIndex;
                this.refreshTheScrollBar();
            }
        }
    }

    private void refreshTheScrollBar() {
        this.canScroll = false;
        if (this.scrollType == 0) {
            if (this.remainingHeight > 0) {
                this.canScroll = true;
            }
        } else if (this.scrollType == 1 && this.remainingWidth > 0) {
            this.canScroll = true;
        }
        if (this.canScroll) {
            if (this.scrollType == 0) {
                this.scrollBarHeight = this.height;
                this.scrollBarY = this.y;
                if (this.remainingHeight < this.scrollBarHeight - 20) {
                    this.scrollRatio = 1;
                    this.scrollBarHeight -= this.remainingHeight;
                } else {
                    this.scrollRatio = this.remainingHeight / (this.scrollBarHeight - 20) + 1;
                    this.scrollBarHeight -= this.remainingHeight / this.scrollRatio;
                    this.scrollBarHeight += this.remainingHeight % this.scrollRatio;
                }
            } else if (this.scrollType == 1) {
                this.scrollBarWidth = this.width;
                this.scrollBarX = this.x;
                if (this.remainingWidth < this.scrollBarWidth - 20) {
                    this.scrollRatio = 1;
                    this.scrollBarWidth -= this.remainingWidth;
                } else {
                    this.scrollRatio = this.remainingWidth / (this.scrollBarWidth - 20) + 1;
                    this.scrollBarWidth -= this.remainingWidth / this.scrollRatio;
                }
            }
        }
    }

    protected void moveTheContentInX(int diffX) {
        Button buttonItem = null;
        StringItem strItem = null;
        ImageItem imgItem = null;
        this.paintStartIndex = -1;
        this.paintEndIndex = -1;
        for (byte i = 0; i < this.lastItemIndex; i = (byte)(i + 1)) {
            if (this.datas[i] instanceof Button) {
                buttonItem = (Button)this.datas[i];
                buttonItem.buttonState = 0;
                buttonItem.x += diffX;
                if (this.paintStartIndex == -1) {
                    if (buttonItem.x + buttonItem.width <= this.x) continue;
                    this.paintStartIndex = i;
                    continue;
                }
                if (this.paintEndIndex != -1 || buttonItem.x <= this.x + this.width) continue;
                this.paintEndIndex = i + 1;
                continue;
            }
            if (this.datas[i] instanceof StringItem) {
                strItem = (StringItem)this.datas[i];
                strItem.x += diffX;
                if (this.paintStartIndex == -1) {
                    if (strItem.x + strItem.width <= this.x) continue;
                    this.paintStartIndex = i;
                    continue;
                }
                if (this.paintEndIndex != -1 || strItem.x <= this.x + this.width) continue;
                this.paintEndIndex = i + 1;
                continue;
            }
            if (!(this.datas[i] instanceof ImageItem)) continue;
            imgItem = (ImageItem)this.datas[i];
            imgItem.x += diffX;
            if (this.paintStartIndex == -1) {
                if (imgItem.x + imgItem.width <= this.x) continue;
                this.paintStartIndex = i;
                continue;
            }
            if (this.paintEndIndex != -1 || imgItem.x <= this.x + this.width) continue;
            this.paintEndIndex = i + 1;
        }
        if (this.paintStartIndex == -1) {
            this.paintStartIndex = 0;
        }
        if (this.paintEndIndex == -1) {
            this.paintEndIndex = this.lastItemIndex;
        }
    }

    public void moveTheContentInY(int diffY) {
        Button buttonItem = null;
        StringItem strItem = null;
        ImageItem imgItem = null;
        this.paintStartIndex = -1;
        this.paintEndIndex = -1;
        for (byte i = 0; i < this.lastItemIndex; i = (byte)(i + 1)) {
            if (this.datas[i] instanceof Button) {
                buttonItem = (Button)this.datas[i];
                buttonItem.buttonState = 0;
                buttonItem.y += diffY;
                if (this.paintStartIndex == -1) {
                    if (buttonItem.y + buttonItem.height <= this.y) continue;
                    this.paintStartIndex = i;
                    continue;
                }
                if (this.paintEndIndex != -1 || buttonItem.y <= this.y + this.height) continue;
                this.paintEndIndex = i + 1;
                continue;
            }
            if (this.datas[i] instanceof StringItem) {
                strItem = (StringItem)this.datas[i];
                strItem.y += diffY;
                if (this.paintStartIndex == -1) {
                    if (strItem.y + strItem.height <= this.y) continue;
                    this.paintStartIndex = i;
                    continue;
                }
                if (this.paintEndIndex != -1 || strItem.y <= this.y + this.height) continue;
                this.paintEndIndex = i + 1;
                continue;
            }
            if (!(this.datas[i] instanceof ImageItem)) continue;
            imgItem = (ImageItem)this.datas[i];
            imgItem.y += diffY;
            if (this.paintStartIndex == -1) {
                if (imgItem.y + imgItem.height <= this.y) continue;
                this.paintStartIndex = i;
                continue;
            }
            if (this.paintEndIndex != -1 || imgItem.y <= this.y + this.height) continue;
            this.paintEndIndex = i + 1;
        }
        if (this.paintStartIndex == -1) {
            this.paintStartIndex = 0;
        }
        if (this.paintEndIndex == -1) {
            this.paintEndIndex = this.lastItemIndex;
        }
    }

    protected void deleteTheItem(byte index) {
        if (index < this.datas.length && index < this.lastItemIndex) {
            this.datas[index] = null;
            this.refreshTheItems();
            this.refreshTheScrollBar();
        }
    }

    protected void deleteTheAllItem() {
        int n = this.datas.length;
        for (int i = 0; i < n; i = (int)((byte)(i + 1))) {
            this.datas[i] = null;
        }
        this.clickedItemIndex = -1;
        this.lastItemIndex = 0;
        this.dataX = this.x;
        this.dataY = this.y;
        this.paintStartIndex = -1;
        this.paintEndIndex = -1;
        this.refreshTheItems();
        this.refreshTheScrollBar();
    }

    protected void clear() {
        int n = this.datas.length;
        for (int i = 0; i < n; i = (int)((byte)(i + 1))) {
            this.datas[i] = null;
        }
        this.datas = null;
    }

    private void refreshTheItems() {
        Image imgItem;
        StringItem strItem;
        Button buttonItem;
        byte i;
        this.isEqualSized = false;
        for (i = 0; i < this.lastItemIndex; i = (byte)(i + 1)) {
            if (this.datas[i] != null) continue;
            if (i + 1 < this.lastItemIndex && this.datas[i + 1] != null) {
                this.datas[i] = this.datas[i + 1];
                this.datas[i + 1] = null;
            }
            this.lastItemIndex = (byte)(this.lastItemIndex - 1);
        }
        this.totalHeight = 0;
        this.totalWidth = 0;
        for (i = 0; i < this.lastItemIndex; i = (byte)(i + 1)) {
            if (this.datas[i] instanceof Button) {
                buttonItem = (Button)this.datas[i];
                this.totalHeight += buttonItem.height;
                this.totalWidth += buttonItem.width;
                continue;
            }
            if (this.datas[i] instanceof StringItem) {
                strItem = (StringItem)this.datas[i];
                this.totalHeight += strItem.height;
                this.totalWidth += strItem.width;
                continue;
            }
            if (!(this.datas[i] instanceof Image)) continue;
            imgItem = (Image)this.datas[i];
            this.totalHeight += imgItem.getHeight();
            this.totalWidth += imgItem.getWidth();
        }
        this.remainingWidth = this.totalWidth - this.width;
        if (this.remainingWidth < 0) {
            this.remainingWidth = 0;
        }
        this.remainingHeight = this.totalHeight - this.height;
        if (this.remainingHeight < 0) {
            this.remainingHeight = 0;
        }
        buttonItem = null;
        strItem = null;
        imgItem = null;
    }

    private int getItemXAt(int index) {
        if (index == -1) {
            return this.x;
        }
        if (this.datas[index] instanceof Button) {
            return ((Button)this.datas[index]).x;
        }
        if (this.datas[index] instanceof StringItem) {
            return ((StringItem)this.datas[index]).x;
        }
        if (this.datas[index] instanceof ImageItem) {
            return ((ImageItem)this.datas[index]).x;
        }
        return 0;
    }

    private int getItemYAt(int index) {
        if (index == -1) {
            return this.y;
        }
        if (this.datas[index] instanceof Button) {
            return ((Button)this.datas[index]).y;
        }
        if (this.datas[index] instanceof StringItem) {
            return ((StringItem)this.datas[index]).y;
        }
        if (this.datas[index] instanceof ImageItem) {
            return ((ImageItem)this.datas[index]).y;
        }
        return 0;
    }

    private int getItemWidthAt(int index) {
        if (index == -1) {
            return 0;
        }
        if (this.datas[index] instanceof Button) {
            return ((Button)this.datas[index]).width;
        }
        if (this.datas[index] instanceof StringItem) {
            return ((StringItem)this.datas[index]).width;
        }
        if (this.datas[index] instanceof ImageItem) {
            return ((ImageItem)this.datas[index]).width;
        }
        return 0;
    }

    private int getItemHeightAt(int index) {
        if (index == -1) {
            return 0;
        }
        if (this.datas[index] instanceof Button) {
            return ((Button)this.datas[index]).height;
        }
        if (this.datas[index] instanceof StringItem) {
            return ((StringItem)this.datas[index]).height;
        }
        if (this.datas[index] instanceof ImageItem) {
            return ((ImageItem)this.datas[index]).height;
        }
        return 0;
    }

    public boolean isPressed(int x1, int y1) {
        boolean result = false;
        this.startThread = false;
        this.scrollState = 0;
        this.speed = 0;
        if (this.scrollState == 0) {
            boolean bl = result = x1 > this.x && x1 < this.x + this.width && y1 > this.y && y1 < this.y + this.height;
            if (result) {
                this.scrollState = 1;
                this.touchX = x1;
                this.touchY = y1;
                Button buttonItem = null;
                StringItem strItem = null;
                ImageItem imgItem = null;
                this.clickedItemIndex = -1;
                for (int index = this.paintStartIndex; index < this.lastItemIndex; ++index) {
                    if (this.datas == null || index >= this.datas.length || this.datas[index] == null) continue;
                    if (this.datas[index] instanceof Button) {
                        buttonItem = (Button)this.datas[index];
                        if (!buttonItem.isPressed(x1, y1)) continue;
                        this.clickedItemIndex = index;
                        break;
                    }
                    if (this.datas[index] instanceof StringItem) {
                        strItem = (StringItem)this.datas[index];
                        if (this.scrollType == 0) {
                            if (x1 <= strItem.x || x1 >= strItem.x + this.width || y1 <= strItem.y || y1 >= strItem.y + strItem.height) continue;
                            this.clickedItemIndex = index;
                            break;
                        }
                        if (x1 <= strItem.x || x1 >= strItem.x + strItem.width || y1 <= strItem.y || y1 >= strItem.y + this.height) continue;
                        this.clickedItemIndex = index;
                        break;
                    }
                    if (!(this.datas[index] instanceof ImageItem)) continue;
                    imgItem = (ImageItem)this.datas[index];
                    if (this.scrollType == 0) {
                        if (x1 <= imgItem.x || x1 >= imgItem.x + this.width || y1 <= imgItem.y || y1 >= imgItem.y + imgItem.height) continue;
                        this.clickedItemIndex = index;
                        break;
                    }
                    if (x1 <= imgItem.x || x1 >= imgItem.x + imgItem.width || y1 <= imgItem.y || y1 >= imgItem.y + this.height) continue;
                    this.clickedItemIndex = index;
                    break;
                }
            }
        }
        return result;
    }

    public int isReleased(int x1, int y1) {
        if (!this.startThread) {
            if (this.scrollState == 1 && this.clickedItemIndex > -1) {
                this.scrollState = 0;
                Button buttonItem = null;
                StringItem strItem = null;
                ImageItem imgItem = null;
                if (x1 > this.x && x1 < this.x + this.width && y1 > this.y && y1 < this.y + this.height) {
                    this.scrollState = 1;
                    this.touchX = x1;
                    this.touchY = y1;
                } else {
                    this.clickedItemIndex = -1;
                }
                if (this.scrollState == 1) {
                    boolean result = false;
                    for (int index = this.paintStartIndex; index < this.paintEndIndex; ++index) {
                        if (this.datas[index] == null) continue;
                        if (this.datas[index] instanceof Button) {
                            buttonItem = (Button)this.datas[index];
                            if (!buttonItem.isReleased(x1, y1)) continue;
                            if (this.clickedItemIndex != index) break;
                            result = true;
                            break;
                        }
                        if (this.datas[index] instanceof StringItem) {
                            strItem = (StringItem)this.datas[index];
                            if (this.scrollType == 0) {
                                if (x1 <= strItem.x || x1 >= strItem.x + this.width || y1 <= strItem.y || y1 >= strItem.y + strItem.height || this.clickedItemIndex != index) continue;
                                result = true;
                                continue;
                            }
                            if (x1 <= strItem.x || x1 >= strItem.x + strItem.width || y1 <= strItem.y || y1 >= strItem.y + this.height || this.clickedItemIndex != index) continue;
                            result = true;
                            continue;
                        }
                        if (!(this.datas[index] instanceof ImageItem)) continue;
                        imgItem = (ImageItem)this.datas[index];
                        if (this.scrollType == 0) {
                            if (x1 <= imgItem.x || x1 >= imgItem.x + this.width || y1 <= imgItem.y || y1 >= imgItem.y + imgItem.height || this.clickedItemIndex != index) continue;
                            result = true;
                            continue;
                        }
                        if (x1 <= imgItem.x || x1 >= imgItem.x + imgItem.width || y1 <= imgItem.y || y1 >= imgItem.y + this.height || this.clickedItemIndex != index) continue;
                        result = true;
                    }
                    this.scrollState = 0;
                    if (!result) {
                        this.clickedItemIndex = -1;
                    }
                }
                for (byte i = 0; i < this.lastItemIndex; i = (byte)(i + 1)) {
                    if (!(this.datas[i] instanceof Button)) continue;
                    buttonItem = (Button)this.datas[i];
                    buttonItem.buttonState = 0;
                }
            } else {
                this.scrollState = 0;
                this.clickedItemIndex = -1;
            }
            if (Math.abs(this.speed) > 0) {
                if (this.dataX > this.x) {
                    this.speed = 0;
                } else if (this.dataX < this.x - this.remainingWidth) {
                    this.speed = 0;
                }
                if (this.speed > 40) {
                    this.speed = 40;
                } else if (this.speed < -40) {
                    this.speed = -40;
                }
                this.startThread();
            } else if (this.dataX > this.x) {
                this.startThread();
            } else if (this.dataX < this.x - this.remainingWidth) {
                this.startThread();
            }
        } else {
            this.clickedItemIndex = -1;
        }
        return this.clickedItemIndex;
    }

    protected void startThread() {
        if (this.canScroll) {
            this.startThread = true;
            this.thread = new Thread(){

                public void run() {
                    while (ScrollView.this.startThread) {
                        if (ScrollView.this.speed != 0) {
                            ScrollView.access$008(ScrollView.this);
                            if (ScrollView.this.counter <= 80) continue;
                            if (ScrollView.this.scrollType == 0) {
                                int beforeDataY = ScrollView.this.dataY;
                                ScrollView.this.dataY += ScrollView.this.speed;
                                ScrollView.this.moveTheContentInY(ScrollView.this.dataY - beforeDataY);
                                ScrollView.this.scrollBarY = ScrollView.this.y + (ScrollView.this.y - ScrollView.this.dataY) / ScrollView.this.scrollRatio;
                            } else if (ScrollView.this.scrollType == 1) {
                                int beforeDataX = ScrollView.this.dataX;
                                ScrollView.this.dataX += ScrollView.this.speed;
                                if (ScrollView.this.dataX > ScrollView.this.x + (ScrollView.this.width >> 1 >> 1)) {
                                    ScrollView.this.dataX = ScrollView.this.x + (ScrollView.this.width >> 1 >> 1);
                                } else if (ScrollView.this.dataX < ScrollView.this.x - ScrollView.this.remainingWidth - (ScrollView.this.width >> 1 >> 1)) {
                                    ScrollView.this.dataX = ScrollView.this.x - ScrollView.this.remainingWidth - (ScrollView.this.width >> 1 >> 1);
                                }
                                ScrollView.this.moveTheContentInX(ScrollView.this.dataX - beforeDataX);
                                ScrollView.this.scrollBarX = ScrollView.this.x + (ScrollView.this.x - ScrollView.this.dataX) / ScrollView.this.scrollRatio;
                            }
                            ScrollView.this.counter = (byte)0;
                            if (ScrollView.this.speed > 0) {
                                ScrollView.this.speed -= 2;
                                if (ScrollView.this.speed < 0) {
                                    ScrollView.this.speed = 0;
                                }
                            } else if (ScrollView.this.speed < 0) {
                                ScrollView.this.speed += 2;
                                if (ScrollView.this.speed > 0) {
                                    ScrollView.this.speed = 0;
                                }
                            }
                            if (ScrollView.this.speed == 0) continue;
                            try {
                                Thread.sleep(20L);
                            }
                            catch (Exception e) {}
                            continue;
                        }
                        ScrollView.access$008(ScrollView.this);
                        if (ScrollView.this.counter <= 80) continue;
                        if (ScrollView.this.scrollType == 0) {
                            ScrollView.this.startThread = true;
                            if (ScrollView.this.dataY > ScrollView.this.y) {
                                int beforeDataY = ScrollView.this.dataY;
                                ScrollView.this.dataY -= 20;
                                if (ScrollView.this.dataY < ScrollView.this.y) {
                                    ScrollView.this.dataY = ScrollView.this.y;
                                }
                                ScrollView.this.moveTheContentInY(ScrollView.this.dataY - beforeDataY);
                                try {
                                    Thread.sleep(20L);
                                }
                                catch (Exception e) {}
                            } else if (ScrollView.this.dataY < ScrollView.this.y - ScrollView.this.remainingHeight) {
                                int beforeDataY = ScrollView.this.dataY;
                                ScrollView.this.dataY += 20;
                                if (ScrollView.this.dataY > ScrollView.this.y - ScrollView.this.remainingHeight) {
                                    ScrollView.this.dataY = ScrollView.this.y - ScrollView.this.remainingHeight;
                                }
                                ScrollView.this.moveTheContentInY(ScrollView.this.dataY - beforeDataY);
                                try {
                                    Thread.sleep(20L);
                                }
                                catch (Exception e) {}
                            } else {
                                ScrollView.this.startThread = false;
                            }
                            ScrollView.this.scrollBarY = ScrollView.this.y + (ScrollView.this.y - ScrollView.this.dataY) / ScrollView.this.scrollRatio;
                            continue;
                        }
                        if (ScrollView.this.scrollType != 1) continue;
                        ScrollView.this.startThread = true;
                        if (ScrollView.this.dataX > ScrollView.this.x) {
                            int beforeDataX = ScrollView.this.dataX;
                            ScrollView.this.dataX -= 20;
                            if (ScrollView.this.dataX < ScrollView.this.x) {
                                ScrollView.this.dataX = ScrollView.this.x;
                            }
                            ScrollView.this.moveTheContentInX(ScrollView.this.dataX - beforeDataX);
                            try {
                                Thread.sleep(20L);
                            }
                            catch (Exception e) {}
                        } else if (ScrollView.this.dataX < ScrollView.this.x - ScrollView.this.remainingWidth) {
                            int beforeDataX = ScrollView.this.dataX;
                            ScrollView.this.dataX += 20;
                            if (ScrollView.this.dataX > ScrollView.this.x - ScrollView.this.remainingWidth) {
                                ScrollView.this.dataX = ScrollView.this.x - ScrollView.this.remainingWidth;
                            }
                            ScrollView.this.moveTheContentInX(ScrollView.this.dataX - beforeDataX);
                            try {
                                Thread.sleep(20L);
                            }
                            catch (Exception exception) {}
                        } else {
                            ScrollView.this.startThread = false;
                        }
                        ScrollView.this.scrollBarX = ScrollView.this.x + (ScrollView.this.x - ScrollView.this.dataX) / ScrollView.this.scrollRatio;
                    }
                }
            };
            this.thread.start();
        }
    }

    public boolean isScrolled(int x1, int y1) {
        boolean result = false;
        if (this.canScroll && this.scrollState == 1 && x1 > this.x && x1 < this.x + this.width && y1 > this.y && y1 < this.y + this.height) {
            if (this.scrollType == 0) {
                int beforeDataY = this.dataY;
                if (this.scrollState == 1) {
                    this.dataY += y1 - this.touchY;
                    this.touchY = y1;
                }
                if (this.dataY > this.y) {
                    this.dataY = this.y;
                } else if (this.dataY < this.y - this.remainingHeight) {
                    this.dataY = this.y - this.remainingHeight;
                }
                this.moveTheContentInY(this.dataY - beforeDataY);
                this.speed = this.dataY - beforeDataY;
            } else if (this.scrollType == 1) {
                int beforeDataX = this.dataX;
                if (this.scrollState == 1) {
                    this.dataX += x1 - this.touchX;
                    this.touchX = x1;
                    if (this.dataX > this.x + (this.width >> 1 >> 1)) {
                        this.dataX = this.x + (this.width >> 1 >> 1);
                    } else if (this.dataX < this.x - this.remainingWidth - (this.width >> 1 >> 1)) {
                        this.dataX = this.x - this.remainingWidth - (this.width >> 1 >> 1);
                    }
                }
                this.moveTheContentInX(this.dataX - beforeDataX);
                this.speed = this.dataX - beforeDataX;
            }
            this.clickedItemIndex = -1;
            if (this.scrollType == 0) {
                this.scrollBarY = this.y + (this.y - this.dataY) / this.scrollRatio;
            } else if (this.scrollType == 1) {
                this.scrollBarX = this.x + (this.x - this.dataX) / this.scrollRatio;
            }
            result = true;
        }
        return result;
    }

    public void isScrolled1(int x1, int y1) {
        if (this.canScroll && this.scrollState == 1 && x1 > this.x && x1 < this.x + this.width && y1 > this.y && y1 < this.y + this.height) {
            if (this.scrollType == 0) {
                int beforeDataY = this.dataY;
                if (this.scrollState == 1) {
                    this.dataY += y1 - this.touchY;
                    this.touchY = y1;
                }
                this.moveTheContentInY(this.dataY - beforeDataY);
                this.speed = this.dataY - beforeDataY;
            } else if (this.scrollType == 1) {
                int beforeDataX = this.dataX;
                if (this.scrollState == 1) {
                    this.dataX += x1 - this.touchX;
                    this.touchX = x1;
                }
                this.moveTheContentInX(this.dataX - beforeDataX);
                this.speed = this.dataX - beforeDataX;
            }
            this.clickedItemIndex = -1;
            if (this.scrollType == 0) {
                this.scrollBarY = this.y + (this.y - this.dataY) / this.scrollRatio;
            } else if (this.scrollType == 1) {
                this.scrollBarX = this.x + (this.x - this.dataX) / this.scrollRatio;
            }
        }
    }

    protected void destroy() {
        this.startThread = false;
        int n = this.datas.length;
        for (int i = 0; i < n; i = (int)((byte)(i + 1))) {
            this.datas[i] = null;
        }
    }

    public void paint(Graphics g) {
        Button buttonItem = null;
        StringItem strItem = null;
        ImageItem imgItem = null;
        g.setClip(this.x - 2, this.y - 2, this.width + 4, this.height + 4);
        if (this.paintStartIndex == -1) {
            this.paintStartIndex = 0;
        }
        if (this.paintEndIndex == -1) {
            this.paintStartIndex = this.lastItemIndex;
        }
        for (int i = this.paintStartIndex; i < this.paintEndIndex; ++i) {
            if (this.datas[i] == null) continue;
            if (this.datas[i] instanceof Button) {
                buttonItem = (Button)this.datas[i];
                if (this.x >= buttonItem.x + buttonItem.width || buttonItem.x >= this.x + this.width || this.y >= buttonItem.y + buttonItem.height || buttonItem.y >= this.y + this.height) continue;
                buttonItem.paint(g);
                continue;
            }
            if (this.datas[i] instanceof StringItem) {
                strItem = (StringItem)this.datas[i];
                if (this.x >= strItem.x + strItem.width || strItem.x >= this.x + this.width || this.y >= strItem.y + strItem.height || strItem.y >= this.y + this.height) continue;
                g.setColor(0);
                strItem.paint(g);
                if (i != this.clickedItemIndex) continue;
                g.setColor(0xFF0000);
                g.drawRect(strItem.x, strItem.y, strItem.width, strItem.height);
                continue;
            }
            if (!(this.datas[i] instanceof ImageItem)) continue;
            imgItem = (ImageItem)this.datas[i];
            if (this.x >= imgItem.x + imgItem.width || imgItem.x >= this.x + this.width || this.y >= imgItem.y + imgItem.height || imgItem.y >= this.y + this.height) continue;
            imgItem.paint(g);
            if (i != this.clickedItemIndex) continue;
            if (this.isEqualSized) {
                g.setColor(0xFF0000);
                if (this.scrollType == 0) {
                    g.drawRoundRect(imgItem.x + 5, imgItem.y + 5, this.width - 10, imgItem.height - 10, 10, 10);
                    continue;
                }
                g.drawRoundRect(imgItem.x + 5, imgItem.y + 15, imgItem.width - 10, this.height - 30, 10, 10);
                continue;
            }
            g.setColor(0xFF0000);
            if (this.scrollType == 0) {
                g.drawRect(imgItem.x, imgItem.y, this.width, imgItem.height);
                continue;
            }
            g.drawRect(imgItem.x, imgItem.y, imgItem.width, this.height);
        }
        g.setClip(0, 0, this.context.getWidth(), this.context.getHeight());
        buttonItem = null;
        strItem = null;
        imgItem = null;
    }

    public void paintTheOperatorsList(Graphics g) {
        Button buttonItem = null;
        g.setClip(this.x - 2, this.y - 2, this.width + 4, this.height + 4);
        if (this.paintStartIndex == -1) {
            this.paintStartIndex = 0;
        }
        if (this.paintEndIndex == -1) {
            this.paintStartIndex = this.lastItemIndex;
        }
        for (int i = this.paintStartIndex; i < this.paintEndIndex; ++i) {
            if (this.datas[i] == null || !(this.datas[i] instanceof Button)) continue;
            buttonItem = (Button)this.datas[i];
            if (this.x >= buttonItem.x + buttonItem.width || buttonItem.x >= this.x + this.width || this.y >= buttonItem.y + buttonItem.height || buttonItem.y >= this.y + this.height) continue;
            buttonItem.paint(g);
            if (i != this.clickedItemIndex && i != MainMenu.selectedOperatorIndex) continue;
            System.out.println("i:" + i);
            System.out.println("selectedOperatorIndex:" + MainMenu.selectedOperatorIndex);
            if (buttonItem.buttonState != 0) continue;
            buttonItem.buttonState = 1;
            buttonItem.paint(g);
            buttonItem.buttonState = 0;
        }
        if (this.canScroll) {
            g.setColor(0xB8ABAB);
            if (this.scrollType == 0) {
                g.fillRoundRect(this.x + this.width - 2, this.scrollBarY, 2, this.scrollBarHeight, 2, 2);
            } else if (this.scrollType == 1) {
                g.fillRoundRect(this.scrollBarX, this.y + this.height - 12, this.scrollBarWidth, 8, 5, 5);
            }
        }
        g.setClip(0, 0, this.context.getWidth(), this.context.getHeight());
        buttonItem = null;
    }

    public void paintTheTeamList(Graphics g) {
        Button buttonItem = null;
        StringItem strItem = null;
        ImageItem imgItem = null;
        g.setClip(this.x - 2, this.y - 2, this.width + 4, this.height + 4);
        if (this.paintStartIndex == -1) {
            this.paintStartIndex = 0;
        }
        if (this.paintEndIndex == -1) {
            this.paintStartIndex = this.lastItemIndex;
        }
        for (int i = this.paintStartIndex; i < this.paintEndIndex; ++i) {
            if (this.datas[i] == null) continue;
            if (this.datas[i] instanceof Button) {
                buttonItem = (Button)this.datas[i];
                if (this.x >= buttonItem.x + buttonItem.width || buttonItem.x >= this.x + this.width || this.y >= buttonItem.y + buttonItem.height || buttonItem.y >= this.y + this.height) continue;
                buttonItem.paint(g);
                continue;
            }
            if (this.datas[i] instanceof StringItem) {
                strItem = (StringItem)this.datas[i];
                if (this.x >= strItem.x + strItem.width || strItem.x >= this.x + this.width || this.y >= strItem.y + strItem.height || strItem.y >= this.y + this.height) continue;
                g.setColor(0);
                strItem.paintInCenter(g, this.equalHeight);
                if (i != this.clickedItemIndex) continue;
                g.setColor(0xFF0000);
                g.drawRect(strItem.x, strItem.y, strItem.width, strItem.height);
                continue;
            }
            if (!(this.datas[i] instanceof ImageItem)) continue;
            imgItem = (ImageItem)this.datas[i];
            if (this.x >= imgItem.x + imgItem.width || imgItem.x >= this.x + this.width || this.y >= imgItem.y + imgItem.height || imgItem.y >= this.y + this.height) continue;
            imgItem.paint(g);
            if (i != this.clickedItemIndex) continue;
            if (this.isEqualSized) {
                g.setColor(0xFF0000);
                if (this.scrollType == 0) {
                    g.drawRoundRect(imgItem.x + 5, imgItem.y + 5, this.width - 10, imgItem.height - 10, 10, 10);
                    continue;
                }
                g.drawRoundRect(imgItem.x + 5, imgItem.y + 15, imgItem.width - 10, this.height - 30, 10, 10);
                continue;
            }
            g.setColor(0xFF0000);
            if (this.scrollType == 0) {
                g.drawRect(imgItem.x, imgItem.y, this.width, imgItem.height);
                continue;
            }
            g.drawRect(imgItem.x, imgItem.y, imgItem.width, this.height);
        }
        if (this.canScroll) {
            g.setColor(0xB8ABAB);
            if (this.scrollType == 0) {
                g.fillRoundRect(this.x + this.width - 5, this.scrollBarY - (this.equalHeight - 2), 4, this.scrollBarHeight, 5, 5);
            } else if (this.scrollType == 1) {
                g.fillRoundRect(this.scrollBarX, this.y + this.height - 12, this.scrollBarWidth, 8, 5, 5);
            }
        }
        g.setClip(0, 0, this.context.getWidth(), this.context.getHeight());
        buttonItem = null;
        strItem = null;
        imgItem = null;
    }

    public void paintThePlayersList(Graphics g) {
        Button buttonItem = null;
        StringItem strItem = null;
        ImageItem imgItem = null;
        g.setClip(this.x, this.y - 2, this.width, this.height + 4);
        if (this.paintStartIndex == -1) {
            this.paintStartIndex = 0;
        }
        if (this.paintEndIndex == -1) {
            this.paintStartIndex = this.lastItemIndex;
        }
        for (int i = this.paintStartIndex; i < this.paintEndIndex; ++i) {
            if (this.datas[i] == null) continue;
            if (this.datas[i] instanceof Button) {
                buttonItem = (Button)this.datas[i];
                if (this.x >= buttonItem.x + buttonItem.width || buttonItem.x >= this.x + this.width || this.y >= buttonItem.y + buttonItem.height || buttonItem.y >= this.y + this.height) continue;
                buttonItem.paint(g);
                continue;
            }
            if (this.datas[i] instanceof StringItem) {
                int j;
                int n;
                strItem = (StringItem)this.datas[i];
                if (this.x >= strItem.x + strItem.width || strItem.x >= this.x + this.width || this.y >= strItem.y + strItem.height || strItem.y >= this.y + this.height) continue;
                if (DisplayableCanvas.inningsCount == 1 && (i == this.clickedItemIndex || MainMenu.selectIndex == 0 && MainMenu.playerListSelectIndex == i || MainMenu.selectIndex == 1 && MainMenu.opponentListSelectIndex == i)) {
                    n = this.width / MainMenu.imgRow1.getWidth() + 1;
                    for (j = 0; j < n; j = (int)((byte)(j + 1))) {
                        g.drawImage(MainMenu.imgRow1, strItem.x + j * MainMenu.imgRow1.getWidth(), strItem.y + 4, 0x10 | 4);
                    }
                } else {
                    n = this.width / MainMenu.imgRow0.getWidth() + 1;
                    for (j = 0; j < n; j = (int)((byte)(j + 1))) {
                        g.drawImage(MainMenu.imgRow0, strItem.x + j * MainMenu.imgRow0.getWidth(), strItem.y + 4, 0x10 | 4);
                    }
                }
                strItem.paintInLeft(g, this.equalHeight);
                g.drawImage(MainMenu.imgRow1, strItem.x + strItem.width - MainMenu.imgRow1.getWidth(), strItem.y + 4, 0x10 | 4);
                if (MainMenu.selectIndex == 0) {
                    if (DisplayableCanvas.playerTeam.keeperIndex == i) {
                        g.drawImage(MainMenu.imgSkills[2], strItem.x + strItem.width - MainMenu.imgSkills[2].getWidth() - 1, strItem.y + 4 + 1, 0x10 | 4);
                        continue;
                    }
                    if (DisplayableCanvas.playerTeam.isBowlerType[i] == 4) {
                        g.drawImage(MainMenu.imgSkills[3], strItem.x + strItem.width - MainMenu.imgSkills[3].getWidth() - 1, strItem.y + 4 + 1, 0x10 | 4);
                        continue;
                    }
                    if (DisplayableCanvas.playerTeam.isBowlerType[i] != 3) {
                        g.drawImage(MainMenu.imgSkills[1], strItem.x + strItem.width - MainMenu.imgSkills[1].getWidth() - 1, strItem.y + 4 + 1, 0x10 | 4);
                        continue;
                    }
                    if (DisplayableCanvas.playerTeam.isBowlerType[i] != 3) continue;
                    g.drawImage(MainMenu.imgSkills[0], strItem.x + strItem.width - MainMenu.imgSkills[0].getWidth() - 1, strItem.y + 4 + 1, 0x10 | 4);
                    continue;
                }
                if (DisplayableCanvas.opponentTeam.keeperIndex == i) {
                    g.drawImage(MainMenu.imgSkills[2], strItem.x + strItem.width - MainMenu.imgSkills[2].getWidth() - 1, strItem.y + 4 + 1, 0x10 | 4);
                    continue;
                }
                if (DisplayableCanvas.opponentTeam.isBowlerType[i] == 4) {
                    g.drawImage(MainMenu.imgSkills[3], strItem.x + strItem.width - MainMenu.imgSkills[3].getWidth() - 1, strItem.y + 4 + 1, 0x10 | 4);
                    continue;
                }
                if (DisplayableCanvas.opponentTeam.isBowlerType[i] != 3) {
                    g.drawImage(MainMenu.imgSkills[1], strItem.x + strItem.width - MainMenu.imgSkills[1].getWidth() - 1, strItem.y + 4 + 1, 0x10 | 4);
                    continue;
                }
                if (DisplayableCanvas.opponentTeam.isBowlerType[i] != 3) continue;
                g.drawImage(MainMenu.imgSkills[0], strItem.x + strItem.width - MainMenu.imgSkills[0].getWidth() - 1, strItem.y + 4 + 1, 0x10 | 4);
                continue;
            }
            if (!(this.datas[i] instanceof ImageItem)) continue;
            imgItem = (ImageItem)this.datas[i];
            if (this.x >= imgItem.x + imgItem.width || imgItem.x >= this.x + this.width || this.y >= imgItem.y + imgItem.height || imgItem.y >= this.y + this.height) continue;
            imgItem.paint(g);
            if (i != this.clickedItemIndex) continue;
            if (this.isEqualSized) {
                g.setColor(0xFF0000);
                if (this.scrollType == 0) {
                    g.drawRoundRect(imgItem.x + 5, imgItem.y + 5, this.width - 10, imgItem.height - 10, 10, 10);
                    continue;
                }
                g.drawRoundRect(imgItem.x + 5, imgItem.y + 15, imgItem.width - 10, this.height - 30, 10, 10);
                continue;
            }
            g.setColor(0xFF0000);
            if (this.scrollType == 0) {
                g.drawRect(imgItem.x, imgItem.y, this.width, imgItem.height);
                continue;
            }
            g.drawRect(imgItem.x, imgItem.y, imgItem.width, this.height);
        }
        if (this.canScroll) {
            g.setClip(this.x, this.y - 2, this.width + 10, this.height + 4);
            g.setColor(0xB8ABAB);
            if (this.scrollType == 0) {
                g.fillRoundRect(this.x + this.width + 1, this.scrollBarY, 2, this.scrollBarHeight, 2, 2);
            } else if (this.scrollType == 1) {
                g.fillRoundRect(this.scrollBarX, this.y + this.height - 12, this.scrollBarWidth, 8, 5, 5);
            }
        }
        g.setClip(0, 0, this.context.getWidth(), this.context.getHeight());
        buttonItem = null;
        strItem = null;
        imgItem = null;
    }

    public void paintTheBattingCard(Graphics g, CricketTeam team) {
        Button buttonItem = null;
        StringItem strItem = null;
        ImageItem imgItem = null;
        g.setClip(this.x, this.y, this.width, this.height + 2);
        if (this.paintStartIndex == -1) {
            this.paintStartIndex = 0;
        }
        if (this.paintEndIndex == -1) {
            this.paintStartIndex = this.lastItemIndex;
        }
        for (int i = this.paintStartIndex; i < this.paintEndIndex; ++i) {
            if (this.datas[i] == null) continue;
            if (this.datas[i] instanceof Button) {
                buttonItem = (Button)this.datas[i];
                if (this.x >= buttonItem.x + buttonItem.width || buttonItem.x >= this.x + this.width || this.y >= buttonItem.y + buttonItem.height || buttonItem.y >= this.y + this.height) continue;
                buttonItem.paint(g);
                continue;
            }
            if (this.datas[i] instanceof StringItem) {
                int j;
                int n;
                strItem = (StringItem)this.datas[i];
                if (this.x >= strItem.x + strItem.width || strItem.x >= this.x + this.width || this.y >= strItem.y + strItem.height || strItem.y >= this.y + this.height) continue;
                if (MainMenu.selectIndex == 0) {
                    if (i == DisplayableCanvas.batsMan1Index || i == DisplayableCanvas.batsMan2Index) {
                        n = this.width / MainMenu.imgRow1.getWidth() + 1;
                        for (j = 0; j < n; j = (int)((byte)(j + 1))) {
                            g.drawImage(MainMenu.imgRow1, strItem.x + j * MainMenu.imgRow1.getWidth(), strItem.y + 4, 0x10 | 4);
                        }
                    } else {
                        n = this.width / MainMenu.imgRow0.getWidth() + 1;
                        for (j = 0; j < n; j = (int)((byte)(j + 1))) {
                            g.drawImage(MainMenu.imgRow0, strItem.x + j * MainMenu.imgRow0.getWidth(), strItem.y + 4, 0x10 | 4);
                        }
                    }
                } else {
                    n = this.width / MainMenu.imgRow0.getWidth() + 1;
                    for (j = 0; j < n; j = (int)((byte)(j + 1))) {
                        g.drawImage(MainMenu.imgRow0, strItem.x + j * MainMenu.imgRow0.getWidth(), strItem.y + 4, 0x10 | 4);
                    }
                }
                g.setColor(0);
                strItem.paintInLeft(g, this.equalHeight);
                int startX = strItem.x + 50;
                int startY = strItem.y + 5 + (strItem.height - 5 - DisplayableCanvas.ds.size[3] >> 1);
                int tempWidth = 15;
                if (team.isOut[i] == 0) {
                    DisplayableCanvas.ds.drawString("", g, startX, startY, 0, tempWidth, 1);
                } else if (team.isOut[i] == 1) {
                    DisplayableCanvas.ds.drawString("NO", g, startX, startY, 0, tempWidth, 1);
                } else if (team.isOut[i] == 2) {
                    DisplayableCanvas.ds.drawString("O", g, startX, startY, 0, tempWidth, 1);
                }
                startX += tempWidth;
                tempWidth = 15;
                DisplayableCanvas.ds.drawString("" + team.takenRuns[i], g, startX, startY, 0, tempWidth, 1);
                startX += tempWidth;
                tempWidth = 15;
                DisplayableCanvas.ds.drawString("" + team.takenBalls[i], g, startX, startY, 0, tempWidth, 1);
                startX += tempWidth;
                tempWidth = 15;
                DisplayableCanvas.ds.drawString("" + team.takenFours[i], g, startX, startY, 0, tempWidth, 1);
                startX += tempWidth;
                tempWidth = 15;
                DisplayableCanvas.ds.drawString("" + team.takenSix[i], g, startX, startY, 0, tempWidth, 1);
                continue;
            }
            if (!(this.datas[i] instanceof ImageItem)) continue;
            imgItem = (ImageItem)this.datas[i];
            if (this.x >= imgItem.x + imgItem.width || imgItem.x >= this.x + this.width || this.y >= imgItem.y + imgItem.height || imgItem.y >= this.y + this.height) continue;
            imgItem.paint(g);
            if (i != this.clickedItemIndex) continue;
            if (this.isEqualSized) {
                g.setColor(0xFF0000);
                if (this.scrollType == 0) {
                    g.drawRoundRect(imgItem.x + 5, imgItem.y + 5, this.width - 10, imgItem.height - 10, 10, 10);
                    continue;
                }
                g.drawRoundRect(imgItem.x + 5, imgItem.y + 15, imgItem.width - 10, this.height - 30, 10, 10);
                continue;
            }
            g.setColor(0xFF0000);
            if (this.scrollType == 0) {
                g.drawRect(imgItem.x, imgItem.y, this.width, imgItem.height);
                continue;
            }
            g.drawRect(imgItem.x, imgItem.y, imgItem.width, this.height);
        }
        if (this.canScroll) {
            g.setClip(this.x, this.y, this.width + 10, this.height + 2);
            g.setColor(0xB8ABAB);
            if (this.scrollType == 0) {
                g.fillRoundRect(this.x + this.width + 1, this.scrollBarY, 2, this.scrollBarHeight, 2, 2);
            } else if (this.scrollType == 1) {
                g.fillRoundRect(this.scrollBarX, this.y + this.height - 12, this.scrollBarWidth, 8, 5, 5);
            }
        }
        g.setClip(0, 0, this.context.getWidth(), this.context.getHeight());
        buttonItem = null;
        strItem = null;
        imgItem = null;
    }

    protected void setTempIndex(byte[] tempIndex1) {
        this.tempIndex = tempIndex1;
    }

    public void paintTheBowlingCard(Graphics g, CricketTeam team) {
        Button buttonItem = null;
        StringItem strItem = null;
        ImageItem imgItem = null;
        g.setClip(this.x, this.y, this.width, this.height);
        if (this.paintStartIndex == -1) {
            this.paintStartIndex = 0;
        }
        if (this.paintEndIndex == -1) {
            this.paintStartIndex = this.lastItemIndex;
        }
        for (int i = this.paintStartIndex; i < this.paintEndIndex; ++i) {
            if (this.datas[i] == null) continue;
            if (this.datas[i] instanceof Button) {
                buttonItem = (Button)this.datas[i];
                if (this.x >= buttonItem.x + buttonItem.width || buttonItem.x >= this.x + this.width || this.y >= buttonItem.y + buttonItem.height || buttonItem.y >= this.y + this.height) continue;
                buttonItem.paint(g);
                continue;
            }
            if (this.datas[i] instanceof StringItem) {
                int j;
                int n;
                strItem = (StringItem)this.datas[i];
                if (this.x >= strItem.x + strItem.width || strItem.x >= this.x + this.width || this.y >= strItem.y + strItem.height || strItem.y >= this.y + this.height) continue;
                if (MainMenu.selectIndex == 1) {
                    if (this.tempIndex[i] == DisplayableCanvas.bowlerIndex) {
                        n = this.width / MainMenu.imgRow1.getWidth() + 1;
                        for (j = 0; j < n; j = (int)((byte)(j + 1))) {
                            g.drawImage(MainMenu.imgRow1, strItem.x + j * MainMenu.imgRow1.getWidth(), strItem.y + 4, 0x10 | 4);
                        }
                    } else {
                        n = this.width / MainMenu.imgRow0.getWidth() + 1;
                        for (j = 0; j < n; j = (int)((byte)(j + 1))) {
                            g.drawImage(MainMenu.imgRow0, strItem.x + j * MainMenu.imgRow0.getWidth(), strItem.y + 4, 0x10 | 4);
                        }
                    }
                } else {
                    n = this.width / MainMenu.imgRow0.getWidth() + 1;
                    for (j = 0; j < n; j = (int)((byte)(j + 1))) {
                        g.drawImage(MainMenu.imgRow0, strItem.x + j * MainMenu.imgRow0.getWidth(), strItem.y + 4, 0x10 | 4);
                    }
                }
                g.setColor(0);
                strItem.paintInLeft(g, this.equalHeight);
                int startX = strItem.x + 62;
                int startY = strItem.y + 5 + (strItem.height - 5 - DisplayableCanvas.ds.size[3] >> 1);
                int tempWidth = 18;
                DisplayableCanvas.ds.drawString("" + team.givenBalls[this.tempIndex[i]] / 6 + "." + team.givenBalls[this.tempIndex[i]] % 6, g, startX, startY, 0, tempWidth, 1);
                startX += tempWidth;
                tempWidth = 15;
                DisplayableCanvas.ds.drawString("" + team.maidenOvers[this.tempIndex[i]], g, startX, startY, 0, tempWidth, 1);
                startX += tempWidth;
                tempWidth = 15;
                DisplayableCanvas.ds.drawString("" + team.givenRuns[this.tempIndex[i]], g, startX, startY, 0, tempWidth, 1);
                startX += tempWidth;
                tempWidth = 15;
                DisplayableCanvas.ds.drawString("" + team.takenWickets[this.tempIndex[i]], g, startX, startY, 0, tempWidth, 1);
                continue;
            }
            if (!(this.datas[i] instanceof ImageItem)) continue;
            imgItem = (ImageItem)this.datas[i];
            if (this.x >= imgItem.x + imgItem.width || imgItem.x >= this.x + this.width || this.y >= imgItem.y + imgItem.height || imgItem.y >= this.y + this.height) continue;
            imgItem.paint(g);
            if (i != this.clickedItemIndex) continue;
            if (this.isEqualSized) {
                g.setColor(0xFF0000);
                if (this.scrollType == 0) {
                    g.drawRoundRect(imgItem.x + 5, imgItem.y + 5, this.width - 10, imgItem.height - 10, 10, 10);
                    continue;
                }
                g.drawRoundRect(imgItem.x + 5, imgItem.y + 15, imgItem.width - 10, this.height - 30, 10, 10);
                continue;
            }
            g.setColor(0xFF0000);
            if (this.scrollType == 0) {
                g.drawRect(imgItem.x, imgItem.y, this.width, imgItem.height);
                continue;
            }
            g.drawRect(imgItem.x, imgItem.y, imgItem.width, this.height);
        }
        if (this.canScroll) {
            g.setClip(this.x, this.y, this.width + 10, this.height);
            g.setColor(0xB8ABAB);
            if (this.scrollType == 0) {
                g.fillRoundRect(this.x + this.width + 2, this.scrollBarY, 4, this.scrollBarHeight, 4, 4);
            } else if (this.scrollType == 1) {
                g.fillRoundRect(this.scrollBarX, this.y + this.height - 12, this.scrollBarWidth, 8, 5, 5);
            }
        }
        g.setClip(0, 0, this.context.getWidth(), this.context.getHeight());
        buttonItem = null;
        strItem = null;
        imgItem = null;
    }

    public void paint1(Graphics g) {
        Button buttonItem = null;
        StringItem strItem = null;
        ImageItem imgItem = null;
        g.setClip(this.x - 1, this.y - 1, this.width + 2, this.height + 2);
        if (this.paintStartIndex == -1) {
            this.paintStartIndex = 0;
        }
        if (this.paintEndIndex == -1) {
            this.paintStartIndex = this.lastItemIndex;
        }
        for (int i = this.paintStartIndex; i < this.paintEndIndex; ++i) {
            if (this.datas[i] == null) continue;
            if (this.datas[i] instanceof Button) {
                buttonItem = (Button)this.datas[i];
                if (this.x >= buttonItem.x + buttonItem.width || buttonItem.x >= this.x + this.width || this.y >= buttonItem.y + buttonItem.height || buttonItem.y >= this.y + this.height) continue;
                buttonItem.paint(g);
                continue;
            }
            if (this.datas[i] instanceof StringItem) {
                strItem = (StringItem)this.datas[i];
                if (this.x >= strItem.x + strItem.width || strItem.x >= this.x + this.width || this.y >= strItem.y + strItem.height || strItem.y >= this.y + this.height) continue;
                strItem.paint(g);
                if (i != this.clickedItemIndex) continue;
                g.setColor(0xFF0000);
                g.drawRect(strItem.x, strItem.y, strItem.width, strItem.height);
                continue;
            }
            if (!(this.datas[i] instanceof ImageItem)) continue;
            imgItem = (ImageItem)this.datas[i];
            if (this.x >= imgItem.x + imgItem.width || imgItem.x >= this.x + this.width || this.y >= imgItem.y + imgItem.height || imgItem.y >= this.y + this.height) continue;
            if (i == this.clickedItemIndex) {
                g.setColor(0xFF9000);
                if (imgItem.alignMent == (1 | 2)) {
                    if (this.scrollType == 1) {
                        g.fillRect(imgItem.x + (imgItem.width >> 1) - (imgItem.img.getWidth() >> 1) - 4, imgItem.y + (this.height >> 1) - (imgItem.img.getHeight() >> 1) - 4, imgItem.img.getWidth() + 8, imgItem.img.getHeight() + 8);
                    } else {
                        g.fillRect(imgItem.x + (this.width >> 1) - (imgItem.img.getWidth() >> 1) - 4, imgItem.y + (imgItem.height >> 1) - (imgItem.img.getHeight() >> 1) - 4, imgItem.img.getWidth() + 8, imgItem.img.getHeight() + 8);
                    }
                } else {
                    g.fillRect(imgItem.x - 4, imgItem.y - 4, imgItem.width + 4, imgItem.height + 4);
                }
            }
            g.setColor(0xFFFFFF);
            if (imgItem.alignMent == (1 | 2)) {
                if (this.scrollType == 1) {
                    g.fillRect(imgItem.x + (imgItem.width >> 1) - (imgItem.img.getWidth() >> 1) - 2, imgItem.y + (this.height >> 1) - (imgItem.img.getHeight() >> 1) - 2, imgItem.img.getWidth() + 4, imgItem.img.getHeight() + 4);
                } else {
                    g.fillRect(imgItem.x + (this.width >> 1) - (imgItem.img.getWidth() >> 1) - 2, imgItem.y + (imgItem.height >> 1) - (imgItem.img.getHeight() >> 1) - 2, imgItem.img.getWidth() + 4, imgItem.img.getHeight() + 4);
                }
            } else {
                g.fillRect(imgItem.x - 2, imgItem.y - 2, imgItem.width + 4, imgItem.height + 4);
            }
            imgItem.paint(g);
        }
        g.setClip(0, 0, this.context.getWidth(), this.context.getHeight());
        buttonItem = null;
        strItem = null;
        imgItem = null;
    }

    static /* synthetic */ byte access$008(ScrollView x0) {
        byte by = x0.counter;
        x0.counter = (byte)(by + 1);
        return by;
    }
}

