/*
 * Decompiled with CFR 0.152.
 */
package com.rocktasticgames.vetclinic.views;

import com.rocktasticgames.vetclinic.animated.AnimatedElement;
import com.rocktasticgames.vetclinic.c2m.C2MValues;
import com.rocktasticgames.vetclinic.main.MainActivity;
import com.rocktasticgames.vetclinic.utils.ColorMatrixColorFilter;
import com.rocktasticgames.vetclinic.utils.GraphicsContainer;
import com.rocktasticgames.vetclinic.utils.List;
import com.rocktasticgames.vetclinic.utils.MotionEvent;
import javax.microedition.lcdui.Image;

public class MenuView {
    public static final ColorMatrixColorFilter filter_dark = new ColorMatrixColorFilter(1);
    public static final ColorMatrixColorFilter filter_light;
    public static final ColorMatrixColorFilter filter_bright;
    public static final ColorMatrixColorFilter filter_dimmed;
    public static final long EXTRA_DELAY = 400L;
    public static final long FLY_SPACING = 100L;
    public static final int HELP_LINES = 13;
    public static final long INIT_START_TIME = 2500L;
    private Image backsky;
    private Image background;
    private AnimatedElement pizzatime;
    private AnimatedElement play;
    private AnimatedElement options;
    private AnimatedElement help;
    private AnimatedElement moregames;
    private AnimatedElement quit;
    private List aelist;
    private MainActivity activity;
    private boolean loaded = false;
    private long start_time;
    private int select_option = 0;
    private boolean menu_loaded = false;
    private boolean options_loaded = false;
    private AnimatedElement optioncanv;
    private AnimatedElement reset;
    private AnimatedElement sound;
    private AnimatedElement back;
    private long out_time;
    private boolean animate_out = false;
    private boolean reset_confirm = false;
    private AnimatedElement resetcanv;
    private AnimatedElement resetyes;
    private AnimatedElement resetno;
    private boolean help_loaded = false;
    private AnimatedElement helpcanv;
    private AnimatedElement helpnext;
    private AnimatedElement helpprev;
    private AnimatedElement helpback;
    private int target = 0;
    private boolean quit_confirm = false;
    private int dialog_index;
    private String[] dialog_lines;
    private boolean initial;
    private boolean isquit = false;
    private boolean more_confirm = false;

    public MenuView(MainActivity mainActivity, boolean bl) {
        this.activity = mainActivity;
        this.initial = bl;
        try {
            this.backsky = Image.createImage((String)"/opening_bg.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.aelist = new List();
        this.start_time = System.currentTimeMillis();
        if (this.initial) {
            this.start_time += 2500L;
        }
    }

    public void destroy() {
        this.backsky = null;
        this.background = null;
        this.pizzatime.recycle();
        this.quit.recycle();
        if (this.menu_loaded) {
            this.unloadMenu();
        }
        if (this.options_loaded) {
            this.unloadOptions();
        }
        System.gc();
    }

    public AnimatedElement traverse(AnimatedElement animatedElement, int n) {
        if (this.initial) {
            return null;
        }
        if (animatedElement == null) {
            if (this.menu_loaded) {
                return this.play;
            }
            if (this.options_loaded) {
                return this.back;
            }
            if (this.help_loaded) {
                return this.helpback;
            }
            return null;
        }
        if (animatedElement == this.play && this.quit.getElapsed(System.currentTimeMillis() - this.start_time) < 200L) {
            return this.play;
        }
        switch (n) {
            case 1: {
                if (this.reset_confirm || this.quit_confirm || this.more_confirm) {
                    return animatedElement;
                }
                if (this.menu_loaded) {
                    if (animatedElement == this.play) {
                        return this.quit;
                    }
                    if (animatedElement == this.options) {
                        return this.play;
                    }
                    if (animatedElement == this.help) {
                        return this.options;
                    }
                    if (animatedElement == this.moregames) {
                        return this.help;
                    }
                    if (animatedElement == this.quit) {
                        return this.quit;
                    }
                } else {
                    if (this.options_loaded) {
                        if (animatedElement == this.reset) {
                            return this.reset;
                        }
                        if (animatedElement == this.sound) {
                            return this.reset;
                        }
                        if (animatedElement == this.back) {
                            return this.sound;
                        }
                        return this.back;
                    }
                    if (this.help_loaded) {
                        return animatedElement;
                    }
                }
                return animatedElement;
            }
            case 6: {
                if (this.reset_confirm || this.quit_confirm || this.more_confirm) {
                    return animatedElement;
                }
                if (this.menu_loaded) {
                    if (animatedElement == this.quit) {
                        return this.play;
                    }
                    if (animatedElement == this.play) {
                        return this.options;
                    }
                    if (animatedElement == this.options) {
                        return this.help;
                    }
                    if (animatedElement == this.help) {
                        try {
                            if (this.activity.getAppProperty("C2M-BuySetup").equals("menu,exit")) {
                                return this.moregames;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return this.quit;
                    }
                    if (animatedElement == this.moregames) {
                        return this.moregames;
                    }
                } else {
                    if (this.options_loaded) {
                        if (animatedElement == this.reset) {
                            return this.sound;
                        }
                        if (animatedElement == this.sound) {
                            return this.back;
                        }
                        if (animatedElement == this.back) {
                            return this.back;
                        }
                        return this.back;
                    }
                    if (this.help_loaded) {
                        return animatedElement;
                    }
                }
                return animatedElement;
            }
            case 5: {
                if (this.reset_confirm || this.quit_confirm || this.more_confirm) {
                    return this.resetno;
                }
                if (this.menu_loaded) {
                    return animatedElement;
                }
                if (this.options_loaded) {
                    return animatedElement;
                }
                if (this.help_loaded) {
                    if (animatedElement == this.helpprev || this.dialog_index + 13 >= this.dialog_lines.length) {
                        return this.helpback;
                    }
                    return this.helpnext;
                }
                return animatedElement;
            }
            case 2: {
                if (this.reset_confirm || this.quit_confirm || this.more_confirm) {
                    return this.resetyes;
                }
                if (this.menu_loaded) {
                    return animatedElement;
                }
                if (this.options_loaded) {
                    return animatedElement;
                }
                if (this.help_loaded) {
                    if (animatedElement == this.helpnext || this.dialog_index == 0) {
                        return this.helpback;
                    }
                    return this.helpprev;
                }
                return animatedElement;
            }
        }
        return animatedElement;
    }

    public boolean onBack() {
        if (this.isquit) {
            return false;
        }
        if (this.reset_confirm || this.quit_confirm || this.more_confirm) {
            this.activity.invalidate();
            this.unloadConfirm();
            return true;
        }
        if (this.options_loaded && !this.animate_out) {
            this.activity.invalidate();
            this.optionsOut(System.currentTimeMillis() - this.start_time);
            return true;
        }
        if (this.help_loaded && !this.animate_out) {
            this.activity.invalidate();
            this.helpOut(System.currentTimeMillis() - this.start_time);
            return true;
        }
        this.activity.invalidate();
        this.quitConfirm(System.currentTimeMillis() - this.start_time);
        return true;
    }

    private void loadResources(float f, float f2, float f3) {
        this.activity.registerDimensions(f2, f3);
        this.pizzatime = this.activity.getLanguage() == 1 ? new AnimatedElement(this.activity, "gamelogo_french", 0.5f, f * 810.0f / 1536.0f + (1.0f - f * 4.0f / 3.0f) / 2.0f, f2, f3, 0, -2500L) : new AnimatedElement(this.activity, "gamelogo", 0.5f, f * 810.0f / 1536.0f + (1.0f - f * 4.0f / 3.0f) / 2.0f, f2, f3, 0, -2500L);
        this.aelist.add(this.pizzatime);
        if (!this.initial) {
            this.loadMenu(f, f2, f3, 400L);
        }
        this.quit = new AnimatedElement(this.activity, "buttons_quitgame_opening", -0.095052086f, f * 114.0f / 1536.0f + (1.0f - f * 4.0f / 3.0f) / 2.0f, f2, f3, 0, 1100L);
        this.aelist.add(this.quit);
        this.loaded = true;
    }

    private void loadMenu(float f, float f2, float f3, long l) {
        this.play = new AnimatedElement(this.activity, "button_play", 0.5f, f * 1301.0f / 1536.0f + (1.0f - f * 4.0f / 3.0f) / 2.0f, f2, f3, 3, l + 100L);
        this.options = new AnimatedElement(this.activity, "button_options", 0.5f, f * 1542.0f / 1536.0f + (1.0f - f * 4.0f / 3.0f) / 2.0f, f2, f3, 3, l + 200L);
        this.help = new AnimatedElement(this.activity, "button_help", 0.5f, f * 1747.0f / 1536.0f + (1.0f - f * 4.0f / 3.0f) / 2.0f, f2, f3, 3, l + 300L);
        this.moregames = new AnimatedElement(this.activity, "button_moregames", 0.5f, f * 1940.0f / 1536.0f + (1.0f - f * 4.0f / 3.0f) / 2.0f, f2, f3, 3, l + 400L);
        try {
            if (!this.activity.getAppProperty("C2M-BuySetup").equals("menu,exit")) {
                this.moregames.animateOut(-1000L);
            }
        }
        catch (Exception exception) {
            this.moregames.animateOut(-1000L);
        }
        this.aelist.addAll(new AnimatedElement[]{this.play, this.options, this.help, this.moregames});
        this.menu_loaded = true;
        this.activity.getCanvas().setFocus(this.play);
    }

    private void menuOut(long l) {
        AnimatedElement[] animatedElementArray = this.moregames.isAnimatingOut() ? new AnimatedElement[]{this.play, this.options, this.help} : new AnimatedElement[]{this.play, this.options, this.help, this.moregames};
        for (int i = 0; i < animatedElementArray.length; ++i) {
            animatedElementArray[i].animate(4, l);
            animatedElementArray[i].animateOut(l);
        }
        this.out_time = l;
        this.animate_out = true;
    }

    private void unloadMenu() {
        AnimatedElement[] animatedElementArray = new AnimatedElement[]{this.play, this.options, this.help, this.moregames};
        for (int i = 0; i < animatedElementArray.length; ++i) {
            this.aelist.remove(animatedElementArray[i]);
            animatedElementArray[i].recycle();
        }
        this.menu_loaded = false;
        this.animate_out = false;
    }

    private void loadOptions(float f, float f2, float f3, long l) {
        this.optioncanv = new AnimatedElement(this.activity, "options_canvas", 0.5f, f * 1400.0f / 1536.0f + (1.0f - f * 4.0f / 3.0f), f2, f3, 3, l);
        this.reset = new AnimatedElement(this.activity, this.activity.getLanguageCode() + "button_resetprogress", 0.5f, f * 1278.0f / 1536.0f + (1.0f - f * 4.0f / 3.0f), f2, f3, 3, l);
        this.sound = this.activity.getSharedPref().getBoolean("sound_on", true) ? new AnimatedElement(this.activity, "toggleon_sound", 0.5f, f * 1479.0f / 1536.0f + (1.0f - f * 4.0f / 3.0f), f2, f3, 3, l) : new AnimatedElement(this.activity, "toggleoff_sound", 0.5f, f * 1479.0f / 1536.0f + (1.0f - f * 4.0f / 3.0f), f2, f3, 3, l);
        this.back = new AnimatedElement(this.activity, "button_back", 0.2578125f, f * 1698.0f / 1536.0f + (1.0f - f * 4.0f / 3.0f), f2, f3, 3, l);
        this.aelist.addAll(new AnimatedElement[]{this.optioncanv, this.reset, this.sound, this.back});
        this.options_loaded = true;
        this.activity.getCanvas().setFocus(this.sound);
    }

    private void optionsOut(long l) {
        AnimatedElement[] animatedElementArray = new AnimatedElement[]{this.optioncanv, this.reset, this.sound, this.back};
        for (int i = 0; i < animatedElementArray.length; ++i) {
            animatedElementArray[i].animate(4, l);
            animatedElementArray[i].animateOut(l);
        }
        this.out_time = l;
        this.animate_out = true;
    }

    private void unloadOptions() {
        AnimatedElement[] animatedElementArray = new AnimatedElement[]{this.optioncanv, this.reset, this.sound, this.back};
        for (int i = 0; i < animatedElementArray.length; ++i) {
            this.aelist.remove(animatedElementArray[i]);
            animatedElementArray[i].recycle();
        }
        this.options_loaded = false;
        this.animate_out = false;
    }

    private void loadHelp(float f, float f2, float f3, long l) {
        this.helpcanv = new AnimatedElement(this.activity, "help_screen_canvas", 0.5f, f * 940.0f / 1536.0f + (1.0f - f * 4.0f / 3.0f), f2, f3, 3, l);
        this.helpback = new AnimatedElement(this.activity, "button_backtomenu", 0.5f, f * 1541.0f / 1536.0f + (1.0f - f * 4.0f / 3.0f), f2, f3, 3, l);
        this.helpnext = new AnimatedElement(this.activity, "button_next", 0.7916667f, f * 1541.0f / 1536.0f + (1.0f - f * 4.0f / 3.0f), f2, f3, 3, l);
        this.helpprev = new AnimatedElement(this.activity, "button_previous", 0.22265625f, f * 1541.0f / 1536.0f + (1.0f - f * 4.0f / 3.0f), f2, f3, 3, l);
        this.dialog_index = 0;
        int n = 1;
        float f4 = 0.0f;
        String string = C2MValues.HELP_MENU[this.activity.getLanguage()].toUpperCase() + " ";
        string = string.replace('\u00a9', 'c');
        int n2 = 0;
        while (n2 + 1 < string.length()) {
            if (string.charAt(n2 + 1) == '/') {
                if (string.charAt(n2 + 2) == '/') {
                    n2 += 3;
                    f4 = 0.0f;
                    while ((++n - 1) % 13 != 0) {
                    }
                } else {
                    n2 += 2;
                    f4 = 0.0f;
                    ++n;
                }
            }
            if (f4 + (float)this.activity.getBrady().measure(string.substring(n2, string.indexOf(" ", n2 + 1))) < 1160.0f * f2 / 1536.0f) {
                f4 += (float)this.activity.getBrady().measure(string.substring(n2, string.indexOf(" ", n2 + 1)));
            } else {
                f4 = this.activity.getBrady().measure(string.substring(n2, string.indexOf(" ", n2 + 1)));
                ++n;
            }
            n2 = string.indexOf(" ", n2 + 1);
        }
        this.dialog_lines = new String[n];
        this.dialog_lines[0] = " ";
        n = 0;
        f4 = 0.0f;
        n2 = 0;
        while (n2 + 1 < string.length()) {
            if (string.charAt(n2 + 1) == '/') {
                if (string.charAt(n2 + 2) == '/') {
                    n2 += 3;
                    f4 = 0.0f;
                    do {
                        this.dialog_lines[++n] = "";
                    } while (n % 13 != 0);
                } else {
                    n2 += 2;
                    f4 = 0.0f;
                    this.dialog_lines[++n] = "";
                }
            }
            if (f4 + (float)this.activity.getBrady().measure(string.substring(n2, string.indexOf(" ", n2 + 1))) < 1160.0f * f2 / 1536.0f) {
                f4 += (float)this.activity.getBrady().measure(string.substring(n2, string.indexOf(" ", n2 + 1)));
                int n3 = n;
                this.dialog_lines[n3] = this.dialog_lines[n3] + string.substring(n2, string.indexOf(" ", n2 + 1));
            } else {
                f4 = this.activity.getBrady().measure(string.substring(n2, string.indexOf(" ", n2 + 1)));
                this.dialog_lines[++n] = string.substring(n2, string.indexOf(" ", n2 + 1));
            }
            n2 = string.indexOf(" ", n2 + 1);
        }
        this.aelist.addAll(new AnimatedElement[]{this.helpcanv, this.helpback, this.helpnext});
        this.help_loaded = true;
        this.activity.getCanvas().setFocus(this.helpback);
    }

    private void helpOut(long l) {
        AnimatedElement[] animatedElementArray = new AnimatedElement[]{this.helpcanv, this.helpback, this.helpnext, this.helpprev};
        for (int i = 0; i < animatedElementArray.length; ++i) {
            animatedElementArray[i].animate(4, l);
            animatedElementArray[i].animateOut(l);
        }
        this.out_time = l;
        this.animate_out = true;
    }

    private void unloadHelp() {
        AnimatedElement[] animatedElementArray = new AnimatedElement[]{this.helpcanv, this.helpback, this.helpnext, this.helpprev};
        for (int i = 0; i < animatedElementArray.length; ++i) {
            this.aelist.remove(animatedElementArray[i]);
            animatedElementArray[i].recycle();
        }
        this.help_loaded = false;
        this.animate_out = false;
        this.dialog_index = 0;
    }

    private void resetConfirm(long l) {
        float f = (float)this.activity.getCanvas().getRZWidth() / (float)this.backsky.getHeight();
        float f2 = this.backsky.getHeight();
        float f3 = (float)this.activity.getCanvas().getRZHeight() / f;
        float f4 = f2 / f3;
        this.resetcanv = new AnimatedElement(this.activity, "resetgame_confirmation_canvas", 0.5f, f4 * 1236.0f / 1536.0f + (1.0f - f4 * 4.0f / 3.0f), f2, f3, 3, l);
        this.resetyes = new AnimatedElement(this.activity, "button_ok", 0.3580729f, f4 * 1527.0f / 1536.0f + (1.0f - f4 * 4.0f / 3.0f), f2, f3, 3, l);
        this.resetno = new AnimatedElement(this.activity, "button_no", 0.64192706f, f4 * 1527.0f / 1536.0f + (1.0f - f4 * 4.0f / 3.0f), f2, f3, 3, l);
        this.reset_confirm = true;
        this.activity.getCanvas().setFocus(this.resetno);
    }

    public void quitSelect() {
        if (this.quit == null) {
            return;
        }
        if (this.quit.getElapsed(System.currentTimeMillis() - this.start_time) < 200L) {
            return;
        }
        if (!(this.quit_confirm || this.options_loaded || this.help_loaded || this.reset_confirm)) {
            this.quitConfirm(System.currentTimeMillis() - this.start_time);
        }
    }

    private void quitConfirm(long l) {
        float f = (float)this.activity.getCanvas().getRZWidth() / (float)this.backsky.getHeight();
        float f2 = this.backsky.getHeight();
        float f3 = (float)this.activity.getCanvas().getRZHeight() / f;
        float f4 = f2 / f3;
        this.resetcanv = new AnimatedElement(this.activity, "resetgame_confirmation_canvas", 0.5f, f4 * 1236.0f / 1536.0f + (1.0f - f4 * 4.0f / 3.0f), f2, f3, 3, l);
        this.resetyes = new AnimatedElement(this.activity, "button_ok", 0.3580729f, f4 * 1527.0f / 1536.0f + (1.0f - f4 * 4.0f / 3.0f), f2, f3, 3, l);
        this.resetno = new AnimatedElement(this.activity, "button_no", 0.64192706f, f4 * 1527.0f / 1536.0f + (1.0f - f4 * 4.0f / 3.0f), f2, f3, 3, l);
        this.quit_confirm = true;
        this.activity.getCanvas().setFocus(this.resetno);
    }

    private void moreConfirm(long l) {
        float f = (float)this.activity.getCanvas().getRZWidth() / (float)this.backsky.getHeight();
        float f2 = this.backsky.getHeight();
        float f3 = (float)this.activity.getCanvas().getRZHeight() / f;
        float f4 = f2 / f3;
        this.resetcanv = new AnimatedElement(this.activity, "resetgame_confirmation_canvas", 0.5f, f4 * 1236.0f / 1536.0f + (1.0f - f4 * 4.0f / 3.0f), f2, f3, 3, l);
        this.resetyes = new AnimatedElement(this.activity, "button_ok", 0.3580729f, f4 * 1527.0f / 1536.0f + (1.0f - f4 * 4.0f / 3.0f), f2, f3, 3, l);
        this.resetno = new AnimatedElement(this.activity, "button_no", 0.64192706f, f4 * 1527.0f / 1536.0f + (1.0f - f4 * 4.0f / 3.0f), f2, f3, 3, l);
        this.more_confirm = true;
        this.activity.getCanvas().setFocus(this.resetno);
    }

    private void unloadConfirm() {
        this.resetcanv.recycle();
        this.resetyes.recycle();
        this.resetno.recycle();
        if (this.reset_confirm) {
            this.activity.getCanvas().setFocus(this.back);
        } else if (this.quit_confirm) {
            this.activity.getCanvas().setFocus(this.quit);
        } else if (this.more_confirm) {
            this.activity.getCanvas().setFocus(this.moregames);
        }
        this.reset_confirm = false;
        this.quit_confirm = false;
        this.more_confirm = false;
    }

    public void onDraw(GraphicsContainer graphicsContainer) {
        int n;
        float f = (float)this.activity.getCanvas().getRZWidth() / (float)this.backsky.getHeight();
        float f2 = this.backsky.getHeight();
        float f3 = (float)this.activity.getCanvas().getRZHeight() / f;
        if (!this.loaded) {
            this.loadResources(f2 / f3, f2, f3);
        }
        long l = System.currentTimeMillis() - this.start_time;
        if (this.animate_out && l - this.out_time > 200L) {
            if (this.menu_loaded) {
                this.unloadMenu();
                if (this.target == 2) {
                    this.loadOptions(f2 / f3, f2, f3, l);
                } else {
                    this.loadHelp(f2 / f3, f2, f3, l);
                }
            } else if (this.options_loaded) {
                this.unloadOptions();
                this.loadMenu(f2 / f3, f2, f3, l);
            } else if (this.help_loaded) {
                this.unloadHelp();
                this.loadMenu(f2 / f3, f2, f3, l);
            }
        }
        graphicsContainer.drawImage(this.backsky, this.activity.getCanvas().getRZWidth() / 2, this.activity.getCanvas().getRZHeight() / 2, 3);
        boolean bl = false;
        for (n = 0; n < this.aelist.size(); ++n) {
            if (((AnimatedElement)this.aelist.get(n)).render(graphicsContainer, l)) continue;
            bl = true;
        }
        if (this.options_loaded) {
            graphicsContainer.translate((int)(this.optioncanv.getX(l) - (float)(this.activity.getCartoon().measure(C2MValues.TEXT_OPTIONS[this.activity.getLanguage()]) / 2)), (int)(f2 * 1008.0f / 1536.0f + f3 * (1.0f - f2 / f3 * 4.0f / 3.0f)));
            this.activity.getCartoon().renderString(graphicsContainer, -1, C2MValues.TEXT_OPTIONS[this.activity.getLanguage()]);
            graphicsContainer.translate(-((int)(this.optioncanv.getX(l) - (float)(this.activity.getCartoon().measure(C2MValues.TEXT_OPTIONS[this.activity.getLanguage()]) / 2))), -((int)(f2 * 1008.0f / 1536.0f + f3 * (1.0f - f2 / f3 * 4.0f / 3.0f))));
            graphicsContainer.translate((int)(this.reset.getX(l) - (float)(this.activity.getBrady().measure(C2MValues.TEXT_RESET_GAME[this.activity.getLanguage()]) / 2)), (int)(this.reset.getY(l) - (float)(this.activity.getCanvas().getRZHeight() * 7 / 320 / 2)));
            this.activity.getBrady().renderString(graphicsContainer, -1, C2MValues.TEXT_RESET_GAME[this.activity.getLanguage()]);
            graphicsContainer.translate(-((int)(this.reset.getX(l) - (float)(this.activity.getBrady().measure(C2MValues.TEXT_RESET_GAME[this.activity.getLanguage()]) / 2))), -((int)(this.reset.getY(l) - (float)(this.activity.getCanvas().getRZHeight() * 7 / 320 / 2))));
        } else if (this.help_loaded) {
            graphicsContainer.translate((int)(this.helpcanv.getX(l) - (float)(this.activity.getCartoon().measure(C2MValues.TEXT_HELP[this.activity.getLanguage()]) / 2)), (int)(f2 * 250.0f / 1536.0f + f3 * (1.0f - f2 / f3 * 4.0f / 3.0f)));
            this.activity.getCartoon().renderString(graphicsContainer, -1, C2MValues.TEXT_HELP[this.activity.getLanguage()]);
            graphicsContainer.translate(-((int)(this.helpcanv.getX(l) - (float)(this.activity.getCartoon().measure(C2MValues.TEXT_HELP[this.activity.getLanguage()]) / 2))), -((int)(f2 * 250.0f / 1536.0f + f3 * (1.0f - f2 / f3 * 4.0f / 3.0f))));
            for (n = 0; n < 13 && this.dialog_index + n < this.dialog_lines.length; ++n) {
                graphicsContainer.translate((int)(this.helpcanv.getX(l) - f2 * 568.0f / 1536.0f), (int)(this.helpcanv.getY(l) + f2 * (1000.0f * ((float)(n - 6) - 1.0f) / 13.0f) / 1536.0f));
                this.activity.getBrady().renderString(graphicsContainer, -1, this.dialog_lines[this.dialog_index + n]);
                graphicsContainer.translate(-((int)(this.helpcanv.getX(l) - f2 * 568.0f / 1536.0f)), -((int)(this.helpcanv.getY(l) + f2 * (1000.0f * ((float)(n - 6) - 1.0f) / 13.0f) / 1536.0f)));
            }
        } else if (this.menu_loaded) {
            AnimatedElement[] animatedElementArray = new AnimatedElement[]{this.play, this.options, this.help, this.moregames};
            String[][] stringArrayArray = new String[][]{C2MValues.TEXT_PLAY, C2MValues.TEXT_OPTIONS, C2MValues.TEXT_HELP, C2MValues.TEXT_MORE_GAMES};
            for (int i = 0; i < animatedElementArray.length; ++i) {
                graphicsContainer.translate((int)(animatedElementArray[i].getX(l) - (float)(this.activity.getCartoon().measure(stringArrayArray[i][this.activity.getLanguage()]) / 2)), (int)(animatedElementArray[i].getY(l) - (float)(this.activity.getCanvas().getRZHeight() * 17 / 320 / 2)));
                this.activity.getCartoon().renderString(graphicsContainer, -1, stringArrayArray[i][this.activity.getLanguage()]);
                graphicsContainer.translate(-((int)(animatedElementArray[i].getX(l) - (float)(this.activity.getCartoon().measure(stringArrayArray[i][this.activity.getLanguage()]) / 2))), -((int)(animatedElementArray[i].getY(l) - (float)(this.activity.getCanvas().getRZHeight() * 17 / 320 / 2))));
            }
        }
        if (this.reset_confirm || this.quit_confirm || this.more_confirm) {
            if (!this.resetcanv.render(graphicsContainer, l)) {
                bl = true;
            }
            if (!this.resetyes.render(graphicsContainer, l)) {
                bl = true;
            }
            if (!this.resetno.render(graphicsContainer, l)) {
                bl = true;
            }
            if (this.reset_confirm) {
                graphicsContainer.translate((int)(this.resetcanv.getX(l) - (float)(this.activity.getCartoon().measure(C2MValues.TEXT_RESET_GAME[this.activity.getLanguage()]) / 2)), (int)(f2 * 944.0f / 1536.0f + f3 * (1.0f - f2 / f3 * 4.0f / 3.0f)));
                this.activity.getCartoon().renderString(graphicsContainer, -1, C2MValues.TEXT_RESET_GAME[this.activity.getLanguage()]);
                graphicsContainer.translate(-((int)(this.resetcanv.getX(l) - (float)(this.activity.getCartoon().measure(C2MValues.TEXT_RESET_GAME[this.activity.getLanguage()]) / 2))), -((int)(f2 * 944.0f / 1536.0f + f3 * (1.0f - f2 / f3 * 4.0f / 3.0f))));
                graphicsContainer.translate((int)this.resetcanv.getX(l), (int)(f2 * 1103.0f / 1536.0f + f3 * (1.0f - f2 / f3 * 4.0f / 3.0f)));
                for (int i = 0; i < C2MValues.TEXT_RESET_MESSAGE[this.activity.getLanguage()].length; ++i) {
                    graphicsContainer.translate(-(this.activity.getKomika().measure(C2MValues.TEXT_RESET_MESSAGE[this.activity.getLanguage()][i]) / 2), 0);
                    this.activity.getKomika().renderString(graphicsContainer, -1, C2MValues.TEXT_RESET_MESSAGE[this.activity.getLanguage()][i]);
                    graphicsContainer.translate(this.activity.getKomika().measure(C2MValues.TEXT_RESET_MESSAGE[this.activity.getLanguage()][i]) / 2, (int)(f2 * 11.0f / 240.0f));
                }
                graphicsContainer.translate(-((int)this.resetcanv.getX(l)), -((int)(f2 * 1103.0f / 1536.0f + f3 * (1.0f - f2 / f3 * 4.0f / 3.0f))) - C2MValues.TEXT_RESET_MESSAGE[this.activity.getLanguage()].length * (int)(f2 * 11.0f / 240.0f));
            } else if (this.quit_confirm) {
                graphicsContainer.translate((int)(this.resetcanv.getX(l) - (float)(this.activity.getCartoon().measure(C2MValues.TEXT_QUIT_GAME[this.activity.getLanguage()]) / 2)), (int)(f2 * 944.0f / 1536.0f + f3 * (1.0f - f2 / f3 * 4.0f / 3.0f)));
                this.activity.getCartoon().renderString(graphicsContainer, -1, C2MValues.TEXT_QUIT_GAME[this.activity.getLanguage()]);
                graphicsContainer.translate(-((int)(this.resetcanv.getX(l) - (float)(this.activity.getCartoon().measure(C2MValues.TEXT_QUIT_GAME[this.activity.getLanguage()]) / 2))), -((int)(f2 * 944.0f / 1536.0f + f3 * (1.0f - f2 / f3 * 4.0f / 3.0f))));
                graphicsContainer.translate((int)this.resetcanv.getX(l), (int)(f2 * 1103.0f / 1536.0f + f3 * (1.0f - f2 / f3 * 4.0f / 3.0f)));
                for (int i = 0; i < C2MValues.TEXT_QUIT_MESSAGE[this.activity.getLanguage()].length; ++i) {
                    graphicsContainer.translate(-(this.activity.getKomika().measure(C2MValues.TEXT_QUIT_MESSAGE[this.activity.getLanguage()][i]) / 2), 0);
                    this.activity.getKomika().renderString(graphicsContainer, -1, C2MValues.TEXT_QUIT_MESSAGE[this.activity.getLanguage()][i]);
                    graphicsContainer.translate(this.activity.getKomika().measure(C2MValues.TEXT_QUIT_MESSAGE[this.activity.getLanguage()][i]) / 2, (int)(f2 * 11.0f / 240.0f));
                }
                graphicsContainer.translate(-((int)this.resetcanv.getX(l)), -((int)(f2 * 1103.0f / 1536.0f + f3 * (1.0f - f2 / f3 * 4.0f / 3.0f))) - C2MValues.TEXT_QUIT_MESSAGE[this.activity.getLanguage()].length * (int)(f2 * 11.0f / 240.0f));
            } else if (this.more_confirm) {
                graphicsContainer.translate((int)(this.resetcanv.getX(l) - (float)(this.activity.getCartoon().measure(C2MValues.TEXT_MORE_GAMES[this.activity.getLanguage()]) / 2)), (int)(f2 * 944.0f / 1536.0f + f3 * (1.0f - f2 / f3 * 4.0f / 3.0f)));
                this.activity.getCartoon().renderString(graphicsContainer, -1, C2MValues.TEXT_MORE_GAMES[this.activity.getLanguage()]);
                graphicsContainer.translate(-((int)(this.resetcanv.getX(l) - (float)(this.activity.getCartoon().measure(C2MValues.TEXT_MORE_GAMES[this.activity.getLanguage()]) / 2))), -((int)(f2 * 944.0f / 1536.0f + f3 * (1.0f - f2 / f3 * 4.0f / 3.0f))));
                graphicsContainer.translate((int)this.resetcanv.getX(l), (int)(f2 * 1103.0f / 1536.0f + f3 * (1.0f - f2 / f3 * 4.0f / 3.0f)));
                for (int i = 0; i < C2MValues.TEXT_MORE_MESSAGE[this.activity.getLanguage()].length; ++i) {
                    graphicsContainer.translate(-(this.activity.getKomika().measure(C2MValues.TEXT_MORE_MESSAGE[this.activity.getLanguage()][i]) / 2), 0);
                    this.activity.getKomika().renderString(graphicsContainer, -1, C2MValues.TEXT_MORE_MESSAGE[this.activity.getLanguage()][i]);
                    graphicsContainer.translate(this.activity.getKomika().measure(C2MValues.TEXT_MORE_MESSAGE[this.activity.getLanguage()][i]) / 2, (int)(f2 * 11.0f / 240.0f));
                }
                graphicsContainer.translate(-((int)this.resetcanv.getX(l)), -((int)(f2 * 1103.0f / 1536.0f + f3 * (1.0f - f2 / f3 * 4.0f / 3.0f))) - C2MValues.TEXT_MORE_MESSAGE[this.activity.getLanguage()].length * (int)(f2 * 11.0f / 240.0f));
            }
        }
        if (this.initial && l > -400L && l < 2000L) {
            this.loadMenu(f2 / f3, f2, f3, -l);
            bl = true;
            this.initial = false;
        }
        if (bl || this.animate_out) {
            this.activity.invalidate();
        }
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (System.currentTimeMillis() - this.start_time < 900L) {
            return false;
        }
        int n = motionEvent.getAction();
        this.activity.invalidate();
        switch (n) {
            case 1: {
                switch (this.select_option) {
                    case 16: {
                        this.quit.setFilter(null);
                        this.quitConfirm(System.currentTimeMillis() - this.start_time);
                        break;
                    }
                    case 13: {
                        this.helpOut(System.currentTimeMillis() - this.start_time);
                        this.helpback.setFilter(null);
                        break;
                    }
                    case 14: {
                        this.helpprev.setFilter(null);
                        if (this.dialog_index + 13 >= this.dialog_lines.length) {
                            this.aelist.add(this.helpnext);
                        }
                        this.dialog_index -= 13;
                        if (this.dialog_index != 0) break;
                        this.aelist.remove(this.helpprev);
                        this.activity.getCanvas().setFocus(this.helpback);
                        break;
                    }
                    case 15: {
                        this.helpnext.setFilter(null);
                        if (this.dialog_index == 0) {
                            this.aelist.add(this.helpprev);
                        }
                        this.dialog_index += 13;
                        if (this.dialog_index + 13 < this.dialog_lines.length) break;
                        this.aelist.remove(this.helpnext);
                        this.activity.getCanvas().setFocus(this.helpback);
                        break;
                    }
                    case 11: {
                        if (this.reset_confirm) {
                            this.activity.resetAll();
                            this.unloadConfirm();
                            this.optionsOut(System.currentTimeMillis() - this.start_time);
                            break;
                        }
                        if (this.quit_confirm) {
                            this.isquit = true;
                            this.activity.onBackPressed();
                            break;
                        }
                        if (!this.more_confirm) break;
                        try {
                            this.activity.platformRequest(this.activity.getAppProperty("C2M-URL-" + this.activity.getBMGLang()));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.isquit = true;
                        this.activity.onBackPressed();
                        break;
                    }
                    case 12: {
                        this.unloadConfirm();
                        break;
                    }
                    case 7: {
                        this.resetConfirm(System.currentTimeMillis() - this.start_time);
                        this.reset.setFilter(null);
                        break;
                    }
                    case 8: {
                        this.activity.getPrefEditor().putBoolean("sound_on", !this.activity.getSharedPref().getBoolean("sound_on", true));
                        this.activity.getPrefEditor().putBoolean("music_on", !this.activity.getSharedPref().getBoolean("music_on", true));
                        this.activity.getPrefEditor().commit();
                        if (this.activity.getSharedPref().getBoolean("sound_on", true)) {
                            this.sound.setPNG("toggleon_sound");
                            this.activity.getMusic().startMusic();
                        } else {
                            this.sound.setPNG("toggleoff_sound");
                            this.activity.getMusic().stopMusic();
                        }
                        this.sound.setFilter(null);
                        break;
                    }
                    case 10: {
                        this.optionsOut(System.currentTimeMillis() - this.start_time);
                        this.back.setFilter(null);
                        break;
                    }
                    case 1: {
                        this.activity.openKitchen();
                        break;
                    }
                    case 2: {
                        this.menuOut(System.currentTimeMillis() - this.start_time);
                        this.target = 2;
                        this.options.setFilter(null);
                        break;
                    }
                    case 3: {
                        this.menuOut(System.currentTimeMillis() - this.start_time);
                        this.target = 3;
                        this.help.setFilter(null);
                        break;
                    }
                    case 4: {
                        this.moregames.setFilter(null);
                        this.moreConfirm(System.currentTimeMillis() - this.start_time);
                    }
                }
                this.select_option = 0;
                return false;
            }
            case 2: {
                if (this.reset_confirm || this.quit_confirm || this.more_confirm) {
                    if (this.resetyes.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getRZWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getRZHeight())) {
                        this.select_option = 11;
                        this.resetyes.setFilter(filter_dark);
                        this.activity.playSound("standard_click");
                    } else if (this.resetno.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getRZWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getRZHeight())) {
                        this.select_option = 12;
                        this.resetno.setFilter(filter_dark);
                        this.activity.playSound("standard_click");
                    }
                    return true;
                }
                if (this.help_loaded) {
                    if (this.helpback.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getRZWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getRZHeight())) {
                        this.select_option = 13;
                        this.helpback.setFilter(filter_dark);
                        this.activity.playSound("standard_click");
                    } else if (this.helpnext.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getRZWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getRZHeight()) && this.dialog_index + 13 < this.dialog_lines.length) {
                        this.select_option = 15;
                        this.helpnext.setFilter(filter_dark);
                        this.activity.playSound("standard_click");
                    } else if (this.helpprev.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getRZWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getRZHeight()) && this.dialog_index > 0) {
                        this.select_option = 14;
                        this.helpprev.setFilter(filter_dark);
                        this.activity.playSound("standard_click");
                    }
                    return true;
                }
                if (this.animate_out) {
                    return false;
                }
                if (this.quit.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getRZWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getRZHeight())) {
                    this.select_option = 16;
                    this.quit.setFilter(filter_dark);
                    this.activity.playSound("standard_click");
                } else if (this.menu_loaded) {
                    if (this.play.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getRZWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getRZHeight())) {
                        this.select_option = 1;
                        this.play.setFilter(filter_dark);
                        this.activity.playSound("tap_play_button");
                    } else if (this.options.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getRZWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getRZHeight())) {
                        this.select_option = 2;
                        this.options.setFilter(filter_dark);
                        this.activity.playSound("standard_click");
                    } else if (this.help.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getRZWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getRZHeight())) {
                        this.select_option = 3;
                        this.help.setFilter(filter_dark);
                        this.activity.playSound("standard_click");
                    } else if (this.moregames.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getRZWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getRZHeight())) {
                        this.select_option = 4;
                        this.moregames.setFilter(filter_dark);
                        this.activity.playSound("standard_click");
                    }
                } else if (this.options_loaded) {
                    if (this.reset.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getRZWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getRZHeight())) {
                        this.select_option = 7;
                        this.reset.setFilter(filter_dark);
                        this.activity.playSound("standard_click");
                    } else if (this.sound.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getRZWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getRZHeight())) {
                        this.select_option = 8;
                        this.sound.setFilter(filter_dark);
                        this.activity.playSound("standard_click");
                    } else if (this.back.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getRZWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getRZHeight())) {
                        this.select_option = 10;
                        this.back.setFilter(filter_dark);
                        this.activity.playSound("standard_click");
                    }
                }
                return true;
            }
            case 3: {
                switch (this.select_option) {
                    case 16: {
                        if (this.quit.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getRZWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getRZHeight())) break;
                        this.select_option = 0;
                        this.quit.setFilter(null);
                        break;
                    }
                    case 13: {
                        if (this.helpback.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getRZWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getRZHeight())) break;
                        this.select_option = 0;
                        this.helpback.setFilter(null);
                        break;
                    }
                    case 15: {
                        if (this.helpnext.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getRZWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getRZHeight())) break;
                        this.select_option = 0;
                        this.helpnext.setFilter(null);
                        break;
                    }
                    case 14: {
                        if (this.helpprev.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getRZWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getRZHeight())) break;
                        this.select_option = 0;
                        this.helpprev.setFilter(null);
                        break;
                    }
                    case 11: {
                        if (this.resetyes.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getRZWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getRZHeight())) break;
                        this.select_option = 0;
                        this.resetyes.setFilter(null);
                        break;
                    }
                    case 12: {
                        if (this.resetno.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getRZWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getRZHeight())) break;
                        this.select_option = 0;
                        this.resetno.setFilter(null);
                        break;
                    }
                    case 7: {
                        if (this.reset.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getRZWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getRZHeight())) break;
                        this.select_option = 0;
                        this.reset.setFilter(null);
                        break;
                    }
                    case 8: {
                        if (this.sound.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getRZWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getRZHeight())) break;
                        this.select_option = 0;
                        this.sound.setFilter(null);
                        break;
                    }
                    case 10: {
                        if (this.back.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getRZWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getRZHeight())) break;
                        this.select_option = 0;
                        this.back.setFilter(null);
                        break;
                    }
                    case 1: {
                        if (this.play.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getRZWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getRZHeight())) break;
                        this.select_option = 0;
                        this.play.setFilter(null);
                        break;
                    }
                    case 2: {
                        if (this.options.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getRZWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getRZHeight())) break;
                        this.select_option = 0;
                        this.options.setFilter(null);
                        break;
                    }
                    case 3: {
                        if (this.help.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getRZWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getRZHeight())) break;
                        this.select_option = 0;
                        this.help.setFilter(null);
                        break;
                    }
                    case 4: {
                        if (this.moregames.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getRZWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getRZHeight())) break;
                        this.select_option = 0;
                        this.moregames.setFilter(null);
                    }
                }
                return true;
            }
        }
        return true;
    }

    static {
        filter_bright = filter_light = new ColorMatrixColorFilter(3);
        filter_dimmed = filter_dark;
    }

    public static class MenuOption {
        public static final int NONE = 0;
        public static final int PLAY = 1;
        public static final int OPTIONS = 2;
        public static final int HELP = 3;
        public static final int MOREGAMES = 4;
        public static final int FACEBOOK = 5;
        public static final int TWITTER = 6;
        public static final int RESET = 7;
        public static final int SOUND = 8;
        public static final int BACK = 10;
        public static final int RESET_YES = 11;
        public static final int RESET_NO = 12;
        public static final int HELP_BACK = 13;
        public static final int HELP_PREV = 14;
        public static final int HELP_NEXT = 15;
        public static final int QUIT = 16;
    }
}

