/*
 * Decompiled with CFR 0.152.
 */
package com.rocktasticgames.vetclinic.views;

import com.rocktasticgames.vetclinic.animated.AnimatedElement;
import com.rocktasticgames.vetclinic.animated.AnimatedOrder;
import com.rocktasticgames.vetclinic.animated.Appliance;
import com.rocktasticgames.vetclinic.animated.OrderItem;
import com.rocktasticgames.vetclinic.animated.Patient;
import com.rocktasticgames.vetclinic.animated.StatusBar;
import com.rocktasticgames.vetclinic.c2m.C2MValues;
import com.rocktasticgames.vetclinic.main.MainActivity;
import com.rocktasticgames.vetclinic.utils.List;
import com.rocktasticgames.vetclinic.utils.MotionEvent;
import com.rocktasticgames.vetclinic.views.MenuView;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class KitchenView {
    public static final int LINES_PER_DIALOG = 3;
    private Image background;
    private Image note;
    private MainActivity activity;
    private AnimatedElement scene;
    private StatusBar topbar;
    private AnimatedElement pause;
    private AnimatedElement bwood;
    private AnimatedElement map;
    private AnimatedElement kitchen;
    private Appliance oven1;
    private Appliance oven2;
    private Appliance salad;
    private Appliance drink;
    private Appliance dessert;
    private AnimatedElement appboard;
    private AnimatedElement appnext;
    private AnimatedElement appprev;
    private AnimatedElement ordercanv;
    private AnimatedElement orderok;
    private List orderitems;
    private boolean loaded = false;
    private boolean apploaded = true;
    private boolean orderloaded = false;
    private boolean upgradeloaded = false;
    private List aelist;
    private List appliances;
    private List menus;
    private List overmenu;
    private int select_option = 0;
    private AnimatedOrder select_order = null;
    private AnimatedOrder on_order = null;
    private Appliance select_appliance = null;
    private int select_menu = -1;
    private int select_slot = -1;
    private int on_slot = -1;
    private long last_time;
    private int pageoffset = 0;
    private float clickx = -1.0f;
    private List deliveries;
    private boolean deliveryloaded = false;
    private AnimatedElement deliverycanv;
    private AnimatedElement deliveryno;
    private int select_delivery = -1;
    private Image exclamation;
    private Image warning;
    private AnimatedElement upcanv;
    private AnimatedElement upback;
    private boolean dialogloaded = false;
    private String[] dialog_lines;
    private int dialog_index;
    private String dialog_res;
    private AnimatedElement dialog_box;
    private AnimatedElement dialog_img;
    private AnimatedElement dialog_btn;
    private boolean options_loaded = false;
    private AnimatedElement optioncanv;
    private AnimatedElement quit;
    private AnimatedElement music;
    private AnimatedElement sound;
    private AnimatedElement back;
    private boolean leveluploaded = false;
    private AnimatedElement leveluppanel;
    private AnimatedElement levelupowner;
    private AnimatedElement levelupstar;
    private AnimatedElement levelupok;
    private boolean isvictory = false;
    private AnimatedElement post_dialog_target = null;
    private AnimatedElement[] upimg = new AnimatedElement[5];
    private AnimatedElement[] upupgrade;
    private int patient_select = -1;
    private int patient_move = -1;
    private int patient_room = -1;
    private Image[] infos;
    private Image[] dots;
    private long[] finish_times = new long[]{-10000L, -10000L, -10000L, -10000L, -10000L};
    private int upgrade_over = -1;
    private AnimatedElement speedup;
    private AnimatedElement calmdown;
    private int[] isupgrade = new int[]{-1, -1, -1, -1, -1};
    private Image roomtag;
    private Image graytag;
    private int dialog_seq = 0;
    private int last_dialog = 0;
    private long lvl_up_time = 0L;
    private AnimatedElement square;

    public KitchenView(MainActivity mainActivity) {
        this.activity = mainActivity;
        this.aelist = new List();
        this.appliances = new List();
        this.menus = new List();
        this.overmenu = new List();
        this.orderitems = new List();
        this.x3Init();
    }

    private void x3Init() {
        if (this.activity == null) {
            return;
        }
        try {
            this.note = Image.createImage((String)"/patientcard_android.png");
            this.exclamation = Image.createImage((String)"/patient_checkmark.png");
            this.warning = Image.createImage((String)"/big_exclamation.png");
            this.infos = new Image[]{Image.createImage((String)"/roominfo_general.png"), Image.createImage((String)"/roominfo_disease.png"), Image.createImage((String)"/roominfo_shop.png"), Image.createImage((String)"/roominfo_emergency.png"), Image.createImage((String)"/roominfo_salon.png"), Image.createImage((String)"/roominfo_lobby.png")};
            this.dots = new Image[]{Image.createImage((String)"/roomslots_empty.png"), Image.createImage((String)"/roomslots_full.png"), Image.createImage((String)"/roomslots_inprogress.png"), Image.createImage((String)"/roomslots_complete.png"), Image.createImage((String)"/stressbar_empty.png"), Image.createImage((String)"/button_upgrade.png")};
            this.roomtag = Image.createImage((String)"/upgrade_pricetag.png");
            this.graytag = Image.createImage((String)"/upgrade_pricetag_unavailable.png");
            this.background = Image.createImage((String)"/background.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.last_time = this.activity.getTime();
    }

    public void destroy() {
        int n;
        this.background = null;
        this.note = null;
        this.exclamation = null;
        this.warning = null;
        this.appnext = null;
        this.appprev = null;
        this.roomtag = null;
        this.graytag = null;
        this.speedup = null;
        this.calmdown = null;
        if (this.upupgrade != null) {
            for (n = 0; n < this.upupgrade.length; ++n) {
                this.upupgrade[n] = null;
            }
        }
        for (n = 0; n < this.infos.length; ++n) {
            this.infos[n] = null;
        }
        for (n = 0; n < this.dots.length; ++n) {
            this.dots[n] = null;
        }
        if (this.topbar != null) {
            this.pause = null;
            this.kitchen = null;
            this.map = null;
            this.topbar = null;
        }
        if (this.apploaded) {
            this.unloadApp();
        } else if (this.orderloaded) {
            this.unloadOrder();
        } else if (this.upgradeloaded) {
            this.unloadUpgrade();
        }
        if (this.dialogloaded) {
            this.unloadDialog();
        }
        if (this.options_loaded) {
            this.unloadOptions();
        }
        if (this.leveluploaded) {
            this.unloadLevelUp();
        }
        System.gc();
    }

    public AnimatedElement traverse(AnimatedElement animatedElement, int n) {
        boolean bl = false;
        int n2 = -1;
        if (!(!this.activity.isPaused() || this.upgradeloaded || this.dialogloaded || this.options_loaded || this.leveluploaded)) {
            return this.pause;
        }
        if (this.leveluploaded) {
            return this.levelupok;
        }
        if (this.dialogloaded) {
            return this.dialog_btn;
        }
        switch (n) {
            case 1: {
                if (this.options_loaded) {
                    if (animatedElement == this.back) {
                        return this.sound;
                    }
                    return this.quit;
                }
                if (this.upgradeloaded) {
                    if (animatedElement == this.upupgrade[0]) {
                        return this.upupgrade[0];
                    }
                    for (int i = 1; i < 3; ++i) {
                        if (animatedElement != this.upupgrade[i]) continue;
                        return this.upupgrade[i - 1];
                    }
                    return this.upupgrade[2];
                }
                if (animatedElement == this.pause) {
                    return this.pause;
                }
                if (animatedElement == this.map) {
                    if (!this.activity.getPatients(this.getAppCode(this.select_appliance))[0].isEmpty()) {
                        return this.activity.getPatients(this.getAppCode(this.select_appliance))[0];
                    }
                    if (this.orderloaded && this.select_appliance == null) {
                        return this.oven1;
                    }
                    if (this.orderloaded && this.select_appliance != null) {
                        return this.orderok;
                    }
                    return this.square;
                }
                for (int i = 0; i < this.activity.getPatients(this.getAppCode(this.select_appliance)).length; ++i) {
                    if (animatedElement != this.activity.getPatients(this.getAppCode(this.select_appliance))[i]) continue;
                    return this.oven1;
                }
                if (animatedElement == this.speedup || animatedElement == this.calmdown) {
                    return this.drink;
                }
                if (animatedElement == this.square) {
                    if (this.calmdown != null) {
                        return this.calmdown;
                    }
                    if (this.speedup != null) {
                        return this.speedup;
                    }
                    return this.drink;
                }
                if (animatedElement == this.orderok) {
                    return this.drink;
                }
                if (animatedElement == this.oven1 || animatedElement == this.upimg[0]) {
                    if (this.isupgrade[0] == 1 && animatedElement != this.upimg[0]) {
                        return this.upimg[0];
                    }
                    if (this.oven2 != null) {
                        return this.oven2;
                    }
                    if (this.isupgrade[1] == 1) {
                        return this.upimg[1];
                    }
                    return this.drink;
                }
                if (animatedElement == this.dessert || animatedElement == this.upimg[4]) {
                    if (this.isupgrade[4] == 1 && animatedElement != this.upimg[4]) {
                        return this.upimg[4];
                    }
                    if (this.salad != null) {
                        return this.salad;
                    }
                    if (this.isupgrade[3] == 1) {
                        return this.upimg[3];
                    }
                    return this.drink;
                }
                if (animatedElement == this.oven2 || animatedElement == this.upimg[1]) {
                    if (this.isupgrade[1] == 1 && animatedElement != this.upimg[1]) {
                        return this.upimg[1];
                    }
                    return this.pause;
                }
                if (animatedElement == this.drink || animatedElement == this.upimg[2]) {
                    if (this.isupgrade[2] == 1 && animatedElement != this.upimg[2]) {
                        return this.upimg[2];
                    }
                    return this.pause;
                }
                if (animatedElement == this.salad || animatedElement == this.upimg[3]) {
                    if (this.isupgrade[3] == 1 && animatedElement != this.upimg[3]) {
                        return this.upimg[3];
                    }
                    return this.pause;
                }
                if (this.orderloaded) {
                    return this.oven1;
                }
                return this.square;
            }
            case 6: {
                if (this.options_loaded) {
                    if (animatedElement == this.quit) {
                        return this.sound;
                    }
                    return this.back;
                }
                if (this.upgradeloaded) {
                    for (int i = 0; i < 2; ++i) {
                        if (animatedElement != this.upupgrade[i]) continue;
                        return this.upupgrade[i + 1];
                    }
                    return this.upback;
                }
                if (animatedElement == this.pause) {
                    if (this.isupgrade[2] == 1) {
                        return this.upimg[2];
                    }
                    return this.drink;
                }
                if (animatedElement == this.oven2) {
                    if (this.isupgrade[0] == 1) {
                        return this.upimg[0];
                    }
                    return this.oven1;
                }
                if (animatedElement == this.drink) {
                    if (this.orderloaded && this.select_appliance == null) {
                        return this.oven1;
                    }
                    if (this.orderloaded && this.select_appliance != null) {
                        return this.orderok;
                    }
                    return this.square;
                }
                if (animatedElement == this.salad) {
                    if (this.dessert != null) {
                        if (this.isupgrade[4] == 1) {
                            return this.upimg[4];
                        }
                        return this.dessert;
                    }
                    if (this.orderloaded && this.select_appliance == null) {
                        return this.oven1;
                    }
                    if (this.orderloaded && this.select_appliance != null) {
                        return this.orderok;
                    }
                    return this.square;
                }
                for (int i = 0; i < 5; ++i) {
                    if (animatedElement != this.upimg[i]) continue;
                    if (this.activity.getCapacity(i) > 0) {
                        return this.getAppliance(i);
                    }
                    if (i == 1) {
                        if (this.isupgrade[0] == 1) {
                            return this.upimg[1];
                        }
                        return this.oven1;
                    }
                    if (i == 3) {
                        if (this.dessert != null) {
                            if (this.isupgrade[4] == 1) {
                                return this.upimg[4];
                            }
                            return this.dessert;
                        }
                        if (this.orderloaded && this.select_appliance == null) {
                            return this.oven1;
                        }
                        if (this.orderloaded && this.select_appliance != null) {
                            return this.orderok;
                        }
                        return this.square;
                    }
                    if (i != 4) continue;
                    if (!this.activity.getPatients(this.getAppCode(this.select_appliance))[0].isEmpty()) {
                        return this.activity.getPatients(this.getAppCode(this.select_appliance))[0];
                    }
                    return this.map;
                }
                if (animatedElement == this.calmdown || animatedElement == this.speedup) {
                    return this.square;
                }
                if ((animatedElement == this.oven1 || animatedElement == this.dessert || animatedElement == this.square || animatedElement == this.orderok || this.map.isAnimatingOut()) && !this.activity.getPatients(this.getAppCode(this.select_appliance))[0].isEmpty()) {
                    return this.activity.getPatients(this.getAppCode(this.select_appliance))[0];
                }
                if (this.map.isAnimatingOut()) {
                    if (this.orderloaded && this.select_appliance == null) {
                        return this.oven1;
                    }
                    if (this.orderloaded && this.select_appliance != null) {
                        return this.orderok;
                    }
                    return this.square;
                }
                return this.map;
            }
            case 5: {
                if (this.options_loaded) {
                    return animatedElement;
                }
                if (animatedElement == this.pause) {
                    return this.pause;
                }
                if (animatedElement == this.map) {
                    return this.map;
                }
                if (this.upgradeloaded) {
                    for (int i = 0; i < 3; ++i) {
                        if (animatedElement != this.upupgrade[i]) continue;
                        return this.upupgrade[i];
                    }
                    return this.upback;
                }
                if (animatedElement == this.calmdown) {
                    if (this.speedup != null) {
                        return this.speedup;
                    }
                    return this.square;
                }
                if (animatedElement == this.speedup) {
                    if (this.dessert != null) {
                        return this.dessert;
                    }
                    if (this.salad != null) {
                        return this.salad;
                    }
                    return this.square;
                }
                if (animatedElement == this.oven1 || animatedElement == this.upimg[0]) {
                    if (this.orderloaded && this.select_appliance == null) {
                        if (this.dessert != null) {
                            return this.dessert;
                        }
                        if (this.isupgrade[4] == 1) {
                            return this.upimg[4];
                        }
                        return this.oven1;
                    }
                    if (this.orderloaded && this.select_appliance != null) {
                        return this.orderok;
                    }
                    return this.square;
                }
                if (animatedElement == this.oven2 || animatedElement == this.upimg[1]) {
                    return this.drink;
                }
                if (animatedElement == this.drink || animatedElement == this.upimg[2] || animatedElement == this.salad || animatedElement == this.upimg[3]) {
                    if (this.salad != null) {
                        return this.salad;
                    }
                    if (this.isupgrade[3] == 1) {
                        return this.upimg[3];
                    }
                    return animatedElement;
                }
                if (animatedElement == this.square || animatedElement == this.orderok || animatedElement == this.dessert || animatedElement == this.upimg[4]) {
                    if (this.dessert != null) {
                        return this.dessert;
                    }
                    if (this.isupgrade[4] == 1) {
                        return this.upimg[4];
                    }
                    return animatedElement;
                }
                for (int i = 0; i < this.activity.getPatients(this.getAppCode(this.select_appliance)).length; ++i) {
                    if (animatedElement != this.activity.getPatients(this.getAppCode(this.select_appliance))[i]) continue;
                    if (i < this.activity.getPatients(this.getAppCode(this.select_appliance)).length - 1 && this.activity.getPatients(this.getAppCode(this.select_appliance))[i + 1] != null && !this.activity.getPatients(this.getAppCode(this.select_appliance))[i + 1].isEmpty()) {
                        return this.activity.getPatients(this.getAppCode(this.select_appliance))[i + 1];
                    }
                    return this.activity.getPatients(this.getAppCode(this.select_appliance))[i];
                }
                if (this.orderloaded) {
                    return this.oven1;
                }
                return this.square;
            }
            case 2: {
                if (this.options_loaded) {
                    return animatedElement;
                }
                if (animatedElement == this.pause) {
                    return this.pause;
                }
                if (animatedElement == this.map) {
                    return this.map;
                }
                if (this.upgradeloaded) {
                    for (int i = 0; i < 3; ++i) {
                        if (animatedElement != this.upupgrade[i]) continue;
                        return this.upupgrade[i];
                    }
                    return this.upback;
                }
                for (int i = 0; i < this.activity.getPatients(this.getAppCode(this.select_appliance)).length; ++i) {
                    if (animatedElement != this.activity.getPatients(this.getAppCode(this.select_appliance))[i]) continue;
                    if (i > 0) {
                        return this.activity.getPatients(this.getAppCode(this.select_appliance))[i - 1];
                    }
                    return this.activity.getPatients(this.getAppCode(this.select_appliance))[i];
                }
                if (animatedElement == this.speedup) {
                    if (this.calmdown != null) {
                        return this.calmdown;
                    }
                    return this.square;
                }
                if (animatedElement == this.square) {
                    return this.oven1;
                }
                if (animatedElement == this.orderok || animatedElement == this.oven1 || animatedElement == this.upimg[0] || animatedElement == this.calmdown) {
                    return this.oven1;
                }
                if (animatedElement == this.oven2 || animatedElement == this.upimg[1] || animatedElement == this.drink || animatedElement == this.upimg[2]) {
                    if (this.oven2 != null) {
                        return this.oven2;
                    }
                    if (this.isupgrade[1] == 1) {
                        return this.upimg[1];
                    }
                    return this.drink;
                }
                if (animatedElement == this.salad || animatedElement == this.upimg[3]) {
                    return this.drink;
                }
                if (animatedElement == this.dessert || animatedElement == this.upimg[4]) {
                    if (this.orderloaded && this.select_appliance == null) {
                        return this.oven1;
                    }
                    if (this.orderloaded && this.select_appliance != null) {
                        return this.orderok;
                    }
                    return this.square;
                }
                if (this.orderloaded) {
                    return this.oven1;
                }
                return this.square;
            }
        }
        return animatedElement;
    }

    public void loadLevelUp(float f, float f2, float f3) {
        this.activity.pause();
        long l = this.last_time;
        this.leveluppanel = new AnimatedElement(this.activity, "panel_levelup", 0.5f, this.scene.getY(0L) / f3 + 0.2063802f * f, f2, f3, 0, l);
        this.levelupowner = new AnimatedElement(this.activity, "shop_and_owner", 0.5f, this.scene.getY(0L) / f3 + -0.140625f * f, f2, f3, 0, l);
        this.levelupstar = new AnimatedElement(this.activity, "star", 0.5f, this.scene.getY(0L) / f3 + 0.22526042f * f, f2, f3, 0, l);
        this.levelupok = new AnimatedElement(this.activity, "button_dialogueok", 0.5f, this.scene.getY(0L) / f3 + 0.36002603f * f, f2, f3, 0, l);
        this.overmenu.addAll(new AnimatedElement[]{this.levelupowner, this.leveluppanel, this.levelupstar, this.levelupok});
        this.leveluploaded = true;
    }

    public void unloadLevelUp() {
        this.activity.resume();
        this.leveluploaded = false;
        this.overmenu.removeAll(new AnimatedElement[]{this.levelupowner, this.leveluppanel, this.levelupstar, this.levelupok});
        this.levelupowner.recycle();
        this.leveluppanel.recycle();
        this.levelupstar.recycle();
        this.levelupok.recycle();
        this.applianceInit();
        this.activity.checkMessage(14);
    }

    public void applianceInit() {
    }

    public void onUpgrade() {
        float f = (float)this.activity.getCanvas().getWidth() / (float)this.background.getWidth();
        float f2 = this.background.getWidth();
        float f3 = (float)this.activity.getCanvas().getHeight() / f;
        if (this.apploaded) {
            this.unloadApp();
            this.loadApp(f2 / f3, f2, f3);
        }
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < this.activity.getCapacity(i); ++j) {
                if (this.activity.getPatients(i)[j] != null) continue;
                this.activity.getPatients((int)i)[j] = Patient.getEmpty(this.activity, this.map.getY(this.last_time) / f3 - 0.2233073f * f2 / f3, f2, f3, i);
            }
        }
        if (this.activity.getCapacity(1) > 0) {
            this.checkMessage(128);
        }
    }

    public void onLevelUp() {
        float f = (float)this.activity.getCanvas().getWidth() / (float)this.background.getWidth();
        float f2 = this.background.getWidth();
        float f3 = (float)this.activity.getCanvas().getHeight() / f;
        this.lvl_up_time = this.last_time;
        if (this.apploaded) {
            this.unloadApp();
            this.loadApp(f2 / f3, f2, f3);
        }
        for (int i = 0; i < 6; ++i) {
            int n;
            if (i < 5) {
                this.isupgrade[i] = -1;
                for (n = 0; n < 3; ++n) {
                    if (this.activity.upgradeAvailable(i, n) < 0) continue;
                    if (this.getAppliance(i) == null) {
                        switch (i) {
                            case 1: {
                                this.upimg[i] = new AnimatedElement(this.activity, "add_room_canvas", 0.17057292f, this.scene.getY(0L) / f3 - 0.2389323f * f2 / f3, f2, f3, 0, this.last_time);
                                break;
                            }
                            case 3: {
                                this.upimg[i] = new AnimatedElement(this.activity, "add_room_canvas", 0.8470052f, this.scene.getY(0L) / f3 - 0.22460938f * f2 / f3, f2, f3, 0, this.last_time);
                                break;
                            }
                            case 4: {
                                this.upimg[i] = new AnimatedElement(this.activity, "add_room_canvas", 0.83463544f, this.scene.getY(0L) / f3 + 0.14973958f * f2 / f3, f2, f3, 0, this.last_time);
                            }
                        }
                        this.isupgrade[i] = this.activity.upgradeAvailable(i, 0);
                        break;
                    }
                    if (this.activity.upgradeAvailable(i, n) != 1) break;
                    this.upimg[i] = new AnimatedElement(this.dots[5], (this.getAppliance(i).getX(this.last_time) + (float)(this.getAppliance(i).getWidth() / 4)) / f2, (this.getAppliance(i).getY(this.last_time) - (float)(this.getAppliance(i).getHeight() / 4)) / f3, f2, f3, 0, this.last_time);
                    this.isupgrade[i] = 1;
                    break;
                }
            }
            block12: for (n = 0; n < this.activity.getCapacity(i); ++n) {
                if (this.activity.getPatients(i)[n] != null) continue;
                this.activity.getPatients((int)i)[n] = Patient.getEmpty(this.activity, this.map.getY(this.last_time) / f3 - 0.2233073f * f2 / f3, f2, f3, i);
                switch (i) {
                    case 1: {
                        this.loadOven2(f2 / f3, f2, f3, this.last_time);
                        continue block12;
                    }
                    case 3: {
                        this.loadSalad(f2 / f3, f2, f3, this.last_time);
                        continue block12;
                    }
                    case 4: {
                        this.loadDessert(f2 / f3, f2, f3, this.last_time);
                    }
                }
            }
        }
        this.loadLevelUp(f2 / f3, f2, f3);
    }

    public void onVictory() {
        float f = (float)this.activity.getCanvas().getWidth() / (float)this.background.getWidth();
        float f2 = this.background.getWidth();
        float f3 = (float)this.activity.getCanvas().getHeight() / f;
        float f4 = f2 / f3;
        this.activity.pause();
        long l = this.last_time;
        this.leveluppanel = new AnimatedElement(this.activity, "panel_victory", 0.5f, this.scene.getY(0L) / f3 + 0.23828125f * f4, f2, f3, 0, l);
        this.levelupowner = new AnimatedElement(this.activity, "shop_and_owner", 0.5f, this.scene.getY(0L) / f3 + -0.140625f * f4, f2, f3, 0, l);
        this.levelupstar = new AnimatedElement(this.activity, "star", 0.0f, 0.0f, f2, f3, 0, l);
        this.levelupok = new AnimatedElement(this.activity, "button_dialogueok", 0.5f, this.scene.getY(0L) / f3 + 0.421875f * f4, f2, f3, 0, l);
        this.overmenu.addAll(new AnimatedElement[]{this.levelupowner, this.leveluppanel, this.levelupok});
        this.leveluploaded = true;
        this.isvictory = true;
    }

    public Appliance getSelectedAppliance() {
        return this.select_appliance;
    }

    public void registerOrder(AnimatedOrder animatedOrder) {
        animatedOrder.setPNG(this.note);
    }

    private void loadResources(float f, float f2, float f3) {
        this.activity.registerDimensions(f2, f3);
        long l = this.last_time;
        this.scene = new AnimatedElement(this.background, 0.5f, 0.40185547f * (1.0f - (f3 / f2 - 1.3333334f) * 9.0f / 4.0f) + 0.4815086f * (f3 / f2 - 1.3333334f) * 9.0f / 4.0f, f2, f3, 0, l);
        this.topbar = new StatusBar(this.activity, this.activity.topbar, 0.44596353f, 0.046875f * (1.0f - (f3 / f2 - 1.3333334f) * 9.0f / 4.0f) + 0.05346027f * (f3 / f2 - 1.3333334f) * 9.0f / 4.0f, f2, f3, 0, l);
        this.pause = new AnimatedElement(this.activity.pausebutton, 0.9433594f, 0.046875f * (1.0f - (f3 / f2 - 1.3333334f) * 9.0f / 4.0f) + 0.05346027f * (f3 / f2 - 1.3333334f) * 9.0f / 4.0f, f2, f3, 0, l);
        this.kitchen = new AnimatedElement(this.activity.kitchenbutton, 0.24869792f, 0.9238281f * (1.0f - (f3 / f2 - 1.3333334f) * 9.0f / 4.0f) + 0.94287807f * (f3 / f2 - 1.3333334f) * 9.0f / 4.0f, f2, f3, 0, l);
        this.map = new AnimatedElement(this.activity.mapbutton, 0.75130206f, 0.9238281f * (1.0f - (f3 / f2 - 1.3333334f) * 9.0f / 4.0f) + 0.94287807f * (f3 / f2 - 1.3333334f) * 9.0f / 4.0f, f2, f3, 0, l);
        this.bwood = new AnimatedElement(this.background, 0.5f, 0.8847656f * (1.0f - (f3 / f2 - 1.3333334f) * 9.0f / 4.0f) + 0.8293665f * (f3 / f2 - 1.3333334f) * 9.0f / 4.0f, f2, f3, 0, l);
        this.square = new AnimatedElement(this.activity, "hospitalroom_lobby_hilite", 0.50130206f, this.scene.getY(l) / f3 + 0.111816406f * f2 / f3, f2, f3, 0, l);
        this.aelist.addAll(new AnimatedElement[]{this.scene, this.topbar, this.pause, this.kitchen, this.map});
        this.loadOven1(f, f2, f3, l);
        this.loadOven2(f, f2, f3, l);
        this.loadDrink(f, f2, f3, l);
        this.loadSalad(f, f2, f3, l);
        this.loadDessert(f, f2, f3, l);
        this.activity.getCanvas().setFocus(this.map);
        this.loaded = true;
        this.applianceInit();
        block5: for (int i = 0; i < 6; ++i) {
            int n;
            for (n = 0; n < this.activity.getCapacity(i); ++n) {
                if (this.activity.getPatients(i)[n] != null) continue;
                this.activity.getPatients((int)i)[n] = Patient.getEmpty(this.activity, this.map.getY(this.last_time) / f3 - 0.2233073f * f2 / f3, f2, f3, i);
            }
            if (i >= 5) continue;
            for (n = 0; n < 3; ++n) {
                if (this.activity.upgradeAvailable(i, n) < 0) continue;
                if (this.getAppliance(i) == null) {
                    switch (i) {
                        case 1: {
                            this.upimg[i] = new AnimatedElement(this.activity, "add_room_canvas", 0.17057292f, this.scene.getY(0L) / f3 - 0.2389323f * f, f2, f3, 0, l);
                            break;
                        }
                        case 3: {
                            this.upimg[i] = new AnimatedElement(this.activity, "add_room_canvas", 0.8470052f, this.scene.getY(0L) / f3 - 0.22460938f * f, f2, f3, 0, l);
                            break;
                        }
                        case 4: {
                            this.upimg[i] = new AnimatedElement(this.activity, "add_room_canvas", 0.83463544f, this.scene.getY(0L) / f3 + 0.14973958f * f, f2, f3, 0, l);
                        }
                    }
                    this.isupgrade[i] = this.activity.upgradeAvailable(i, 0);
                    continue block5;
                }
                if (this.activity.upgradeAvailable(i, n) != 1) continue block5;
                this.upimg[i] = new AnimatedElement(this.dots[5], (this.getAppliance(i).getX(l) + (float)(this.getAppliance(i).getWidth() / 4)) / f2, (this.getAppliance(i).getY(l) - (float)(this.getAppliance(i).getHeight() / 4)) / f3, f2, f3, 0, l);
                this.isupgrade[i] = 1;
                continue block5;
            }
        }
        if (this.activity.hasSpeedUp(l) && this.speedup == null) {
            this.speedup = new AnimatedElement(this.activity, "buttons_speedup", 0.55598956f, this.scene.getY(0L) / f3 + 0.0f, f2, f3, 0, l);
        }
        if (this.activity.hasCalmDown(l) && this.calmdown == null) {
            this.calmdown = new AnimatedElement(this.activity, "buttons_calmdown", 0.44270834f, this.scene.getY(0L) / f3 + 0.0f, f2, f3, 0, l);
        }
        if (this.activity.getLevel() < 3) {
            this.map.animateOut(0L);
        }
        if (this.activity.getPoints() == 0) {
            this.select_appliance = this.oven1;
            this.loadApp(f2 / f3, f2, f3);
        }
        if (this.select_appliance == null) {
            this.activity.getCanvas().setFocus(this.square);
        } else {
            this.activity.getCanvas().setFocus(this.oven1);
        }
    }

    public boolean goBack() {
        this.activity.invalidate();
        if (this.orderloaded && !this.activity.isPaused()) {
            this.unloadOrder();
            this.on_order = null;
            this.select_order = null;
            return true;
        }
        if (this.upgradeloaded) {
            this.unloadUpgrade();
            return true;
        }
        if (this.leveluploaded) {
            this.unloadLevelUp();
            return true;
        }
        if (this.dialogloaded) {
            this.unloadDialog();
            return true;
        }
        if (!this.activity.isPaused()) {
            this.activity.togglePause();
            float f = (float)this.activity.getCanvas().getWidth() / (float)this.background.getWidth();
            float f2 = this.background.getWidth();
            float f3 = (float)this.activity.getCanvas().getHeight() / f;
            this.loadOptions(f2 / f3, f2, f3, System.currentTimeMillis());
            return true;
        }
        this.activity.togglePause();
        this.unloadOptions();
        return true;
    }

    private void loadDialog(float f, float f2, float f3, String string, String string2) {
        this.post_dialog_target = this.activity.getCanvas().getFocus();
        if (this.dialogloaded) {
            this.unloadDialog();
        }
        this.activity.pause();
        this.dialog_res = string;
        this.dialog_index = 0;
        int n = 1;
        float f4 = 0.0f;
        string2 = string2.toUpperCase();
        string2 = string2 + " ";
        int n2 = 0;
        while (n2 + 1 < string2.length()) {
            if (f4 + (float)this.activity.getKomika().measure(string2.substring(n2, string2.indexOf(" ", n2 + 1))) < 1160.0f * f2 / 1536.0f) {
                f4 += (float)this.activity.getKomika().measure(string2.substring(n2, string2.indexOf(" ", n2 + 1)));
            } else {
                f4 = this.activity.getKomika().measure(string2.substring(n2, string2.indexOf(" ", n2 + 1)));
                ++n;
            }
            n2 = string2.indexOf(" ", n2 + 1);
        }
        this.dialog_lines = new String[n];
        this.dialog_lines[0] = " ";
        n = 0;
        f4 = 0.0f;
        n2 = 0;
        while (n2 + 1 < string2.length()) {
            if (f4 + (float)this.activity.getKomika().measure(string2.substring(n2, string2.indexOf(" ", n2 + 1))) < 1160.0f * f2 / 1536.0f) {
                f4 += (float)this.activity.getKomika().measure(string2.substring(n2, string2.indexOf(" ", n2 + 1)));
                int n3 = n;
                this.dialog_lines[n3] = this.dialog_lines[n3] + string2.substring(n2, string2.indexOf(" ", n2 + 1));
            } else {
                f4 = this.activity.getKomika().measure(string2.substring(n2, string2.indexOf(" ", n2 + 1)));
                this.dialog_lines[++n] = string2.substring(n2, string2.indexOf(" ", n2 + 1));
            }
            n2 = string2.indexOf(" ", n2 + 1);
        }
        long l = this.last_time;
        this.dialog_box = new AnimatedElement(this.activity, "dialoguebox", 0.5f, this.bwood.getY(0L) / f3 + -0.5449219f * f, f2, f3, 0, l);
        this.dialog_img = new AnimatedElement(this.activity, string, 0.69466144f, this.bwood.getY(0L) / f3 + -0.79752606f * f, f2, f3, 0, l);
        this.dialog_btn = this.dialog_lines.length > 3 ? new AnimatedElement(this.activity, "button_dialoguenext", 0.5f, this.bwood.getY(0L) / f3 + -0.31640625f * f, f2, f3, 0, l) : new AnimatedElement(this.activity, "button_dialogueok", 0.5f, this.bwood.getY(0L) / f3 + -0.31640625f * f, f2, f3, 0, l);
        this.overmenu.addAll(new AnimatedElement[]{this.dialog_img, this.dialog_box, this.dialog_btn});
        this.dialogloaded = true;
        this.activity.getCanvas().setFocus(this.dialog_btn);
    }

    private void unloadDialog() {
        this.overmenu.removeAll(new AnimatedElement[]{this.dialog_img, this.dialog_box, this.dialog_btn});
        this.dialog_img = null;
        this.dialog_box = null;
        this.dialog_btn = null;
        this.dialogloaded = false;
        float f = (float)this.activity.getCanvas().getWidth() / (float)this.background.getWidth();
        float f2 = this.background.getWidth();
        float f3 = (float)this.activity.getCanvas().getHeight() / f;
        long l = this.last_time;
        if (this.dialog_seq > 0) {
            String string;
            --this.dialog_seq;
            ++this.last_dialog;
            switch (C2MValues.TUTORIAL_SPEAKER[this.last_dialog - 100]) {
                default: {
                    string = "dialogue_gregory";
                    break;
                }
                case 1: {
                    string = "dialogue_joy";
                    break;
                }
                case 2: {
                    string = "dialogue_harry";
                    break;
                }
                case 3: {
                    string = "dialogue_unhappyjoy";
                }
            }
            this.activity.getCanvas().setFocus(this.post_dialog_target);
            this.loadDialog(f2 / f3, f2, f3, string, C2MValues.TUTORIAL_DIALOG[this.activity.getLanguage()][this.last_dialog - 100]);
        } else {
            this.activity.resume();
            this.activity.getCanvas().setFocus(this.post_dialog_target);
        }
    }

    private void loadUpgrade(float f, float f2, float f3, int n) {
        long l = this.last_time;
        this.upupgrade = new AnimatedElement[3];
        this.upcanv = new AnimatedElement(this.activity, "upgrade_menu", 0.5f, this.scene.getY(0L) / f3 + 0.06640625f * f, f2, f3, 0, l);
        this.upback = new AnimatedElement(this.activity, "button_no", 0.5f, this.scene.getY(0L) / f3 + 0.4609375f * f, f2, f3, 0, l);
        for (int i = 0; i < 3; ++i) {
            if (this.activity.upgradeAvailable(n, i) == 1) {
                this.upupgrade[i] = new AnimatedElement(this.activity, "upgrade_pricetag", 0.71158856f, this.scene.getY(0L) / f3 + (776.0f + 206.0f * (float)i - 823.0f) / 2048.0f * 4.0f / 3.0f * f, f2, f3, 0, l);
                this.activity.getCanvas().setFocus(this.upupgrade[i]);
                continue;
            }
            this.upupgrade[i] = new AnimatedElement(this.activity, "upgrade_pricetag_unavailable", 0.71158856f, this.scene.getY(0L) / f3 + (776.0f + 206.0f * (float)i - 823.0f) / 2048.0f * 4.0f / 3.0f * f, f2, f3, 0, l);
        }
        this.overmenu.addAll(new AnimatedElement[]{this.upcanv, this.upback, this.upupgrade[0], this.upupgrade[1], this.upupgrade[2]});
        this.upgradeloaded = true;
    }

    private void unloadUpgrade() {
        this.overmenu.removeAll(new AnimatedElement[]{this.upcanv, this.upback, this.upupgrade[0], this.upupgrade[1], this.upupgrade[2]});
        this.upupgrade = null;
        this.upgradeloaded = false;
    }

    private void loadOrder(float f, float f2, float f3) {
        this.orderloaded = true;
        this.ordercanv = new AnimatedElement(this.activity, "patientcard_android", 0.5f, this.scene.getY(0L) / f3 + 0.114583336f * f, f2, f3, 0, this.last_time);
        this.menus.add(this.ordercanv);
        for (int i = 0; i < this.activity.getPatients(this.getAppCode(this.select_appliance))[this.patient_select].getAilments().length; ++i) {
            this.orderitems.add(new OrderItem(this.activity, MainActivity.appitems[this.activity.getPatients(this.getAppCode(this.select_appliance))[this.patient_select].getAilments()[i] / MainActivity.appitems.length][this.activity.getPatients(this.getAppCode(this.select_appliance))[this.patient_select].getAilments()[i] % MainActivity.appitems.length], 0.35677084f, this.scene.getY(0L) / f3 + (930.0f + 97.0f * (float)i - 823.0f) / 2048.0f * 4.0f / 3.0f * f, f2, f3, 0, this.last_time, MainActivity.cooknames[this.activity.getPatients(this.getAppCode(this.select_appliance))[this.patient_select].getAilments()[i] / MainActivity.appitems.length][this.activity.getPatients(this.getAppCode(this.select_appliance))[this.patient_select].getAilments()[i] % MainActivity.appitems.length], this.activity.getPatients(this.getAppCode(this.select_appliance))[this.patient_select].isCured(i)));
        }
        this.orderok = new AnimatedElement(this.activity, "button_sendtolobby", 0.5f, this.scene.getY(0L) / f3 + 0.33268228f * f, f2, f3, 0, this.last_time);
        if (this.getAppCode(this.select_appliance) < 5) {
            this.menus.add(this.orderok);
        }
        if (this.activity.getLevel() == 1) {
            if (this.activity.getPatients(this.getAppCode(this.select_appliance))[this.patient_select].getAilments().length == 1) {
                this.checkMessage(153);
            } else {
                this.checkMessage(112);
            }
        }
    }

    private void unloadOrder() {
        this.orderloaded = false;
        this.menus.remove(this.ordercanv);
        this.ordercanv = null;
        this.menus.remove(this.orderok);
        this.orderok = null;
        this.orderitems.clear();
    }

    private void loadOptions(float f, float f2, float f3, long l) {
        this.optioncanv = new AnimatedElement(this.activity, "options_canvas", 0.5f, f * 800.0f / 1536.0f + (1.0f - f * 4.0f / 3.0f), f2, f3, 3, l);
        this.quit = new AnimatedElement(this.activity, this.activity.getLanguageCode() + "button_quitgame", 0.5f, f * 678.0f / 1536.0f + (1.0f - f * 4.0f / 3.0f), f2, f3, 3, l);
        this.sound = this.activity.getSharedPref().getBoolean("sound_on", true) ? new AnimatedElement(this.activity, "toggleon_sound", 0.5f, f * 879.0f / 1536.0f + (1.0f - f * 4.0f / 3.0f), f2, f3, 3, l) : new AnimatedElement(this.activity, "toggleoff_sound", 0.5f, f * 879.0f / 1536.0f + (1.0f - f * 4.0f / 3.0f), f2, f3, 3, l);
        this.back = new AnimatedElement(this.activity, "button_back", 0.2578125f, f * 1098.0f / 1536.0f + (1.0f - f * 4.0f / 3.0f), f2, f3, 3, l);
        this.overmenu.addAll(new AnimatedElement[]{this.optioncanv, this.quit, this.sound, this.back});
        this.options_loaded = true;
        this.activity.getCanvas().setFocus(this.sound);
    }

    private void unloadOptions() {
        AnimatedElement[] animatedElementArray = new AnimatedElement[]{this.optioncanv, this.quit, this.sound, this.back};
        for (int i = 0; i < animatedElementArray.length; ++i) {
            this.overmenu.remove(animatedElementArray[i]);
            animatedElementArray[i].recycle();
        }
        this.options_loaded = false;
    }

    private void loadApp(float f, float f2, float f3) {
        this.apploaded = true;
    }

    private void unloadApp() {
        if (!this.apploaded) {
            return;
        }
        this.apploaded = false;
    }

    public void updateAppImage(int n) {
        switch (n) {
            case 0: {
                this.oven1.setPNG(MainActivity.appimgs[0][this.activity.getAppUpgrade(0)]);
                break;
            }
            case 1: {
                this.oven2.setPNG(MainActivity.appimgs[1][this.activity.getAppUpgrade(1)]);
                break;
            }
            case 2: {
                this.drink.setPNG(MainActivity.appimgs[2][this.activity.getAppUpgrade(2)]);
                break;
            }
            case 3: {
                this.salad.setPNG(MainActivity.appimgs[3][this.activity.getAppUpgrade(3)]);
                break;
            }
            case 4: {
                this.dessert.setPNG(MainActivity.appimgs[4][this.activity.getAppUpgrade(4)]);
            }
        }
    }

    public void removeOrder(AnimatedOrder animatedOrder, long l) {
        boolean bl = false;
        if (this.on_order == animatedOrder && this.orderloaded) {
            if (this.activity.getCanvas().getFocus() == this.orderok) {
                this.activity.getCanvas().setFocus(this.map);
            }
            this.unloadOrder();
        }
        for (int i = 0; i < this.activity.getOrders().size(); ++i) {
            if (bl) {
                ((AnimatedOrder)this.activity.getOrders().get(i)).setIndex(i, l);
                continue;
            }
            if ((AnimatedOrder)this.activity.getOrders().get(i) != animatedOrder) continue;
            this.activity.getOrders().remove(animatedOrder);
            bl = true;
            --i;
        }
    }

    private void loadOven1(float f, float f2, float f3, long l) {
        if (this.activity.getAppSlots(0) == 0) {
            return;
        }
        this.oven1 = new Appliance(this.activity, MainActivity.appimgs[0][this.activity.getAppUpgrade(0)], this.exclamation, this.warning, 0.16145833f, this.scene.getY(0L) / f3 + 0.17773438f * f, f2, f3, 0, l);
        this.appliances.add(this.oven1);
    }

    private void loadOven2(float f, float f2, float f3, long l) {
        if (this.activity.getAppSlots(1) == 0) {
            return;
        }
        this.oven2 = new Appliance(this.activity, MainActivity.appimgs[1][this.activity.getAppUpgrade(1)], this.exclamation, this.warning, 0.1796875f, this.scene.getY(0L) / f3 - 0.21940105f * f, f2, f3, 0, l);
        this.appliances.add(this.oven2);
    }

    private void loadDrink(float f, float f2, float f3, long l) {
        if (this.activity.getAppSlots(2) == 0) {
            return;
        }
        this.drink = new Appliance(this.activity, MainActivity.appimgs[2][this.activity.getAppUpgrade(2)], this.exclamation, this.warning, 0.4986979f, this.scene.getY(0L) / f3 - 0.25716147f * f, f2, f3, 0, l);
        this.appliances.add(this.drink);
    }

    private void loadSalad(float f, float f2, float f3, long l) {
        if (this.activity.getAppSlots(3) == 0) {
            return;
        }
        this.salad = new Appliance(this.activity, MainActivity.appimgs[3][this.activity.getAppUpgrade(3)], this.exclamation, this.warning, 0.8391927f, this.scene.getY(0L) / f3 - 0.21679688f * f, f2, f3, 0, l);
        this.appliances.add(this.salad);
    }

    private void loadDessert(float f, float f2, float f3, long l) {
        if (this.activity.getAppSlots(4) == 0) {
            return;
        }
        this.dessert = new Appliance(this.activity, MainActivity.appimgs[4][this.activity.getAppUpgrade(4)], this.exclamation, this.warning, 0.8411458f, this.scene.getY(0L) / f3 + 0.17773438f * f, f2, f3, 0, l);
        this.appliances.add(this.dessert);
    }

    public void notifyFailed(int n, long l) {
        if (this.getAppCode(this.select_appliance) == n) {
            this.unloadOrder();
            this.patient_move = -1;
            this.patient_select = -1;
            this.patient_room = -1;
            this.select_option = 0;
        }
    }

    public void notifyCured(int n, long l, boolean bl) {
        this.finish_times[n] = l;
        if (this.getAppCode(this.select_appliance) == n && bl) {
            this.unloadOrder();
            this.patient_move = -1;
            this.patient_select = -1;
            this.patient_room = -1;
            this.select_option = 0;
        }
        float f = (float)this.activity.getCanvas().getWidth() / (float)this.background.getWidth();
        float f2 = this.background.getWidth();
        float f3 = (float)this.activity.getCanvas().getHeight() / f;
        block5: for (int i = 0; i < 5; ++i) {
            if (this.activity.getCapacity(i) == 0) {
                if (this.activity.getLevel() < C2MValues.CAPACITY_UPGRADE_LEVEL[i][0]) continue;
                switch (i) {
                    case 1: {
                        this.upimg[i] = new AnimatedElement(this.activity, "add_room_canvas", 0.17057292f, this.scene.getY(0L) / f3 - 0.2389323f * f2 / f3, f2, f3, 0, 0L);
                        break;
                    }
                    case 3: {
                        this.upimg[i] = new AnimatedElement(this.activity, "add_room_canvas", 0.8470052f, this.scene.getY(0L) / f3 - 0.22460938f * f2 / f3, f2, f3, 0, 0L);
                        break;
                    }
                    case 4: {
                        this.upimg[i] = new AnimatedElement(this.activity, "add_room_canvas", 0.83463544f, this.scene.getY(0L) / f3 + 0.14973958f * f2 / f3, f2, f3, 0, 0L);
                    }
                }
                if (this.activity.getMoney() >= C2MValues.CAPACITY_UPGRADE_COST[i][0]) {
                    this.isupgrade[i] = 1;
                    continue;
                }
                this.isupgrade[i] = 0;
                continue;
            }
            for (int j = 0; j < 3; ++j) {
                if (this.activity.upgradeAvailable(i, j) != 1) continue;
                this.upimg[i] = new AnimatedElement(this.dots[5], (this.getAppliance(i).getX(l) + (float)(this.getAppliance(i).getWidth() / 4)) / f2, (this.getAppliance(i).getY(l) - (float)(this.getAppliance(i).getHeight() / 4)) / f3, f2, f3, 0, l);
                this.isupgrade[i] = 1;
                continue block5;
            }
        }
    }

    public boolean checkMessage(int n) {
        String string;
        if (n < 100) {
            return false;
        }
        if (this.activity.getSharedPref().getBoolean("msg_" + (n -= 100), false)) {
            return false;
        }
        this.last_dialog = n + 100;
        this.dialog_seq = 0;
        if (n == 1) {
            this.dialog_seq = 6;
        } else if (n == 15) {
            this.dialog_seq = 1;
        } else if (n == 19) {
            this.dialog_seq = 4;
        } else if (n == 24) {
            this.dialog_seq = 1;
        } else if (n == 26) {
            this.dialog_seq = 1;
        } else if (n == 28) {
            this.dialog_seq = 1;
        } else if (n == 30) {
            this.dialog_seq = 1;
        } else if (n == 33) {
            this.dialog_seq = 1;
        } else if (n == 39) {
            this.dialog_seq = 1;
        } else if (n == 44) {
            this.dialog_seq = 1;
        } else if (n == 47) {
            this.dialog_seq = 1;
        } else if (n == 50) {
            this.dialog_seq = 1;
        } else if (n == 53) {
            this.dialog_seq = 1;
        } else if (n == 57) {
            this.dialog_seq = 1;
        }
        float f = (float)this.activity.getCanvas().getWidth() / (float)this.background.getWidth();
        float f2 = this.background.getWidth();
        float f3 = (float)this.activity.getCanvas().getHeight() / f;
        switch (C2MValues.TUTORIAL_SPEAKER[n]) {
            default: {
                string = "dialogue_gregory";
                break;
            }
            case 1: {
                string = "dialogue_joy";
                break;
            }
            case 2: {
                string = "dialogue_harry";
                break;
            }
            case 3: {
                string = "dialogue_unhappyjoy";
            }
        }
        this.activity.playSound("dialogue_popup");
        this.loadDialog(f2 / f3, f2, f3, string, C2MValues.TUTORIAL_DIALOG[this.activity.getLanguage()][n]);
        this.activity.getPrefEditor().putBoolean("msg_" + n, true);
        this.activity.getPrefEditor().commit();
        return true;
    }

    public void onDraw(Graphics graphics) {
        int n;
        long l = this.activity.getTime();
        float f = (float)this.activity.getCanvas().getWidth() / 240.0f;
        float f2 = 240.0f;
        float f3 = (float)this.activity.getCanvas().getHeight() / f;
        if (this.background == null) {
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.x3Init();
        } else if (this.background.getWidth() < 50) {
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.x3Init();
        }
        if (!this.loaded) {
            this.loadResources(f2 / f3, f2, f3);
        }
        if (this.activity.getOrders().size() > 0 && ((AnimatedOrder)this.activity.getOrders().peek()).isAnimatingOut() && ((AnimatedOrder)this.activity.getOrders().peek()).getElapsed(l) > 200L) {
            this.removeOrder((AnimatedOrder)this.activity.getOrders().peek(), l);
        }
        this.activity.refresh(l);
        if (this.activity.getLevel() == 1) {
            if (this.activity.getPatients(5)[0].isEmpty() && this.activity.getPatients(0)[0].isEmpty() && this.activity.getPatients(2)[0].isEmpty() && l > 500L) {
                this.activity.addPatient(false);
                this.activity.addPatient(false);
                this.checkMessage(101);
            }
        } else if (this.activity.getLevel() == 2) {
            if (!(this.activity.isPaused() || l - this.lvl_up_time <= 1000L || this.checkMessage(124) || this.checkMessage(126))) {
                if (this.activity.getCapacity(1) != 0 && this.activity.getMoney() >= C2MValues.CAPACITY_UPGRADE_COST[0][2]) {
                    this.checkMessage(130);
                }
                if (this.activity.getCapacity(0) > 2 || this.activity.getCapacity(2) > 2) {
                    this.checkMessage(132);
                }
            }
        } else if (this.activity.getLevel() == 3) {
            if (!this.activity.isPaused() && l - this.lvl_up_time > 1000L) {
                this.checkMessage(133);
            }
            if (this.map.isAnimatingOut()) {
                this.map.animate(0, 0L);
            }
        } else if (!this.activity.isPaused() && l - this.lvl_up_time > 1000L) {
            if (this.activity.getCapacity(3) > 0) {
                this.checkMessage(146);
            } else if (this.activity.getLevel() >= C2MValues.CAPACITY_UPGRADE_LEVEL[3][0] && this.activity.getMoney() >= C2MValues.CAPACITY_UPGRADE_COST[3][0]) {
                this.checkMessage(144);
            }
            if (this.activity.getCapacity(4) > 0) {
                this.checkMessage(149);
            } else if (this.activity.getLevel() >= C2MValues.CAPACITY_UPGRADE_LEVEL[4][0] && this.activity.getMoney() >= C2MValues.CAPACITY_UPGRADE_COST[4][0]) {
                this.checkMessage(147);
            }
        }
        if (this.activity.hasSpeedUp(l) && this.speedup == null) {
            this.speedup = new AnimatedElement(this.activity, "buttons_speedup", 0.55598956f, this.scene.getY(0L) / f3 + 0.0f, f2, f3, 1, l);
        }
        if (this.activity.hasCalmDown(l) && this.calmdown == null) {
            this.calmdown = new AnimatedElement(this.activity, "buttons_calmdown", 0.44270834f, this.scene.getY(0L) / f3 + 0.0f, f2, f3, 1, l);
        }
        graphics.setColor(-11711155);
        graphics.fillRect(0, 0, (int)f2, (int)f3);
        boolean bl = false;
        for (n = 0; n < this.aelist.size(); ++n) {
            ((AnimatedElement)this.aelist.get(n)).render(graphics, l);
        }
        for (n = 0; n < this.appliances.size(); ++n) {
            if (((AnimatedElement)this.appliances.get(n)).render(graphics, l)) continue;
            bl = true;
        }
        for (n = 0; n < 5; ++n) {
            if (this.upimg[n] == null || this.isupgrade[n] < 0 || this.isupgrade[n] != 1 && this.activity.getCapacity(n) != 0) continue;
            this.upimg[n].render(graphics, l);
            if (this.isupgrade[n] < 0 || this.activity.getCapacity(n) != 0) continue;
            String[] stringArray = C2MValues.TEXT_ADD_ROOM[this.activity.getLanguage()].indexOf(" ") > 0 ? new String[]{C2MValues.TEXT_ADD_ROOM[this.activity.getLanguage()].substring(0, C2MValues.TEXT_ADD_ROOM[this.activity.getLanguage()].indexOf(" ")), C2MValues.TEXT_ADD_ROOM[this.activity.getLanguage()].substring(C2MValues.TEXT_ADD_ROOM[this.activity.getLanguage()].indexOf(" ") + 1)} : new String[]{C2MValues.TEXT_ADD_ROOM[this.activity.getLanguage()]};
            if (stringArray.length == 1) {
                graphics.translate((int)(this.upimg[n].getX(l) - (float)(this.activity.getKomika().measure(stringArray[0]) / 2)), (int)(this.upimg[n].getY(l) - (float)(this.upimg[n].getHeight() / 10) - (float)(this.activity.getCanvas().getHeight() * 7 / 320 / 2)));
                this.activity.getKomika().renderString(graphics, -16777216, stringArray[0]);
                graphics.translate(-((int)(this.upimg[n].getX(l) - (float)(this.activity.getKomika().measure(stringArray[0]) / 2))), -((int)(this.upimg[n].getY(l) - (float)(this.upimg[n].getHeight() / 10) - (float)(this.activity.getCanvas().getHeight() * 7 / 320 / 2))));
            } else {
                if (stringArray.length == 3) {
                    if (stringArray[0].length() < stringArray[2].length()) {
                        stringArray[0] = stringArray[0] + " " + stringArray[1];
                        stringArray[1] = stringArray[2];
                    } else {
                        stringArray[1] = stringArray[1] + " " + stringArray[2];
                    }
                } else if (stringArray.length > 3) {
                    stringArray[0] = stringArray[0] + " " + stringArray[1];
                    stringArray[1] = stringArray[2] + " " + stringArray[3];
                    for (int i = 4; i < stringArray.length; ++i) {
                        stringArray[1] = stringArray[1] + " " + stringArray[i];
                    }
                }
                graphics.translate((int)(this.upimg[n].getX(l) - (float)(this.activity.getKomika().measure(stringArray[0]) / 2)), (int)(this.upimg[n].getY(l) - (float)(this.upimg[n].getHeight() / 10) - (float)(this.activity.getCanvas().getHeight() * 7 / 320 * 7 / 6)));
                this.activity.getKomika().renderString(graphics, -16777216, stringArray[0]);
                graphics.translate(-((int)(this.upimg[n].getX(l) - (float)(this.activity.getKomika().measure(stringArray[0]) / 2))), -((int)(this.upimg[n].getY(l) - (float)(this.upimg[n].getHeight() / 10) - (float)(this.activity.getCanvas().getHeight() * 7 / 320 * 7 / 6))));
                graphics.translate((int)(this.upimg[n].getX(l) - (float)(this.activity.getKomika().measure(stringArray[1]) / 2)), (int)(this.upimg[n].getY(l) - (float)(this.upimg[n].getHeight() / 10) + (float)(this.activity.getCanvas().getHeight() * 7 / 320 * 1 / 6)));
                this.activity.getKomika().renderString(graphics, -16777216, stringArray[1]);
                graphics.translate(-((int)(this.upimg[n].getX(l) - (float)(this.activity.getKomika().measure(stringArray[1]) / 2))), -((int)(this.upimg[n].getY(l) - (float)(this.upimg[n].getHeight() / 10) + (float)(this.activity.getCanvas().getHeight() * 7 / 320 * 1 / 6))));
            }
            graphics.translate((int)this.upimg[n].getX(l), (int)(this.upimg[n].getY(l) + (float)(this.upimg[n].getHeight() * 3 / 7)));
            if (this.isupgrade[n] == 1) {
                graphics.drawImage(this.roomtag, 0, 0, 3);
            } else {
                graphics.drawImage(this.graytag, 0, 0, 3);
            }
            String string = "$" + C2MValues.CAPACITY_UPGRADE_COST[n][0];
            graphics.translate(-this.activity.getCartoon().measure(string) / 2, -(this.activity.getCanvas().getHeight() * 17 / 320) / 2);
            this.activity.getCartoon().renderString(graphics, -1, string);
            graphics.translate(-(-this.activity.getCartoon().measure(string) / 2), -(-(this.activity.getCanvas().getHeight() * 17 / 320) / 2));
            graphics.translate(-((int)this.upimg[n].getX(l)), -((int)(this.upimg[n].getY(l) + (float)(this.upimg[n].getHeight() * 3 / 7))));
        }
        if (this.getAppCode(this.select_appliance) < 5) {
            switch (this.getAppCode(this.select_appliance)) {
                default: {
                    graphics.setColor(-56897);
                    break;
                }
                case 1: {
                    graphics.setColor(-235);
                    break;
                }
                case 2: {
                    graphics.setColor(-16711887);
                    break;
                }
                case 3: {
                    graphics.setColor(-16721153);
                    break;
                }
                case 4: {
                    graphics.setColor(-26112);
                }
            }
            graphics.setColor(-1);
            graphics.fillRect((int)(this.select_appliance.getX(l) - (float)(this.select_appliance.getWidth() * 6 / 11)), (int)(this.select_appliance.getY(l) - (float)(this.select_appliance.getHeight() * 6 / 11)), this.select_appliance.getWidth() * 12 / 11, this.select_appliance.getHeight() * 12 / 11);
            this.select_appliance.render(graphics, l);
            if (this.isupgrade[this.getAppCode(this.select_appliance)] == 1) {
                this.upimg[this.getAppCode(this.select_appliance)].render(graphics, l);
            }
        } else {
            this.square.render(graphics, l);
        }
        if (this.speedup != null && !this.activity.isPaused() && l - this.lvl_up_time > 3000L) {
            this.speedup.render(graphics, l);
            this.checkMessage(157);
        }
        if (this.calmdown != null && !this.activity.isPaused() && l - this.lvl_up_time > 3000L) {
            this.calmdown.render(graphics, l);
        }
        n = 1;
        while (n != 6) {
            if (this.activity.getCapacity(n) > 0) {
                if (n < 5) {
                    graphics.translate((int)this.getAppliance(n).getX(l), (int)(this.getAppliance(n).getY(l) + (float)(this.getAppliance(n).getHeight() * 9 / 25)));
                    if (l - this.finish_times[n] < 1500L) {
                        for (int i = 0; i < 5; ++i) {
                            graphics.drawImage(this.activity.getHeart(), -this.getAppliance(n).getWidth() * 2 / 3 + this.getAppliance(n).getWidth() * i / 6, (int)((long)(-this.getAppliance(n).getWidth()) * (l - this.finish_times[n] + (long)(i * 2 % 5 * 100)) / 1000L), 3);
                        }
                    }
                } else {
                    graphics.translate((int)(f2 / 2.0f), (int)(this.getAppliance(0).getY(l) + (float)(this.getAppliance(0).getHeight() * 9 / 25)));
                }
                graphics.drawImage(this.infos[n], 0, 0, 3);
                if (n < 5) {
                    graphics.drawImage(this.dots[4], 0, this.infos[n].getHeight() * 8 / 174, 17);
                    float f4 = this.activity.getStress(n);
                    if (f4 < 0.7f) {
                        graphics.setColor(-16733696);
                    } else if (f4 < 1.0f) {
                        graphics.setColor(-3355648);
                    } else {
                        graphics.setColor(-3407872);
                    }
                    if (f4 > 1.0f) {
                        graphics.fillRect(-this.dots[4].getWidth() * 9 / 19, this.infos[n].getHeight() * 8 / 174 + this.dots[4].getHeight() / 5, this.dots[4].getWidth() * 18 / 19, this.dots[4].getHeight() * 4 / 5);
                    } else {
                        graphics.fillRect(-this.dots[4].getWidth() * 9 / 19, this.infos[n].getHeight() * 8 / 174 + this.dots[4].getHeight() / 5, (int)((float)(this.dots[4].getWidth() * 18 / 19) * f4), this.dots[4].getHeight() * 4 / 5);
                    }
                    for (int i = 0; i < this.activity.getCapacity(n); ++i) {
                        if (this.activity.getPatients(n)[i].isEmpty()) {
                            graphics.drawImage(this.dots[0], -this.dots[4].getWidth() / 2 + this.dots[3].getWidth() * (i * 2) / 2, -this.dots[4].getHeight() / 2 - this.dots[3].getHeight() / 2, 20);
                            continue;
                        }
                        if (i == 0 && this.activity.getPatients(n)[i].getProgress(l) != -1.0f) {
                            if (this.activity.getPatients(n)[i].getProgress(l) == -2.0f) {
                                graphics.drawImage(this.dots[3], -this.dots[4].getWidth() / 2 + this.dots[3].getWidth() * (i * 2) / 2, -this.dots[4].getHeight() / 2 - this.dots[3].getHeight() / 2, 20);
                                continue;
                            }
                            graphics.drawImage(this.dots[2], -this.dots[4].getWidth() / 2 + this.dots[3].getWidth() * (i * 2) / 2, -this.dots[4].getHeight() / 2 - this.dots[3].getHeight() / 2, 20);
                            continue;
                        }
                        graphics.drawImage(this.dots[1], -this.dots[4].getWidth() / 2 + this.dots[3].getWidth() * (i * 2) / 2, -this.dots[4].getHeight() / 2 - this.dots[3].getHeight() / 2, 20);
                    }
                } else {
                    for (int i = 0; i < this.activity.getCapacity(n); ++i) {
                        if (this.activity.getPatients(n)[i].isEmpty()) {
                            graphics.drawImage(this.dots[0], -this.dots[4].getWidth() / 2 + this.dots[3].getWidth() * (i * 2) / 2, -this.dots[3].getHeight() / 2, 20);
                            continue;
                        }
                        graphics.drawImage(this.dots[1], -this.dots[4].getWidth() / 2 + this.dots[3].getWidth() * (i * 2) / 2, -this.dots[3].getHeight() / 2, 20);
                    }
                }
                if (n < 5) {
                    graphics.translate(-((int)this.getAppliance(n).getX(l)), -((int)(this.getAppliance(n).getY(l) + (float)(this.getAppliance(n).getHeight() * 9 / 25))));
                } else {
                    graphics.translate(-((int)(f2 / 2.0f)), -((int)(this.getAppliance(0).getY(l) + (float)(this.getAppliance(0).getHeight() * 9 / 25))));
                }
            }
            n = (n + 2) % 7;
        }
        for (n = 0; n < this.menus.size(); ++n) {
            if (((AnimatedElement)this.menus.get(n)).render(graphics, l)) continue;
            bl = true;
        }
        for (n = 0; n < this.activity.getOrders().size(); ++n) {
            if (((AnimatedOrder)this.activity.getOrders().get(n)).isTaken()) continue;
            boolean bl2 = true;
            for (int i = 0; i < this.activity.getDeliverers(); ++i) {
                if (this.activity.getDeliveryState(i) > 2) continue;
                bl2 = false;
            }
            if (bl2) break;
            if (l % 700L > 350L) {
                graphics.drawImage(this.warning, (int)(this.map.getX(l) - (float)(this.warning.getWidth() / 2)), (int)(this.map.getY(l) - (float)(this.warning.getHeight() / 2)), 20);
            }
            bl = true;
            break;
        }
        for (n = 0; n < this.activity.getCapacity(this.getAppCode(this.select_appliance)); ++n) {
            this.activity.getPatients(this.getAppCode(this.select_appliance))[n].renderInPlace(graphics, l, n, this.getAppCode(this.select_appliance));
        }
        if (this.getAppCode(this.select_appliance) < 5 && !this.activity.getPatients(this.getAppCode(this.select_appliance))[0].isEmpty() && (this.activity.getPatients(this.getAppCode(this.select_appliance))[0].getProgress(l) >= 1.0f || this.activity.getPatients(this.getAppCode(this.select_appliance))[0].getProgress(l) == -2.0f)) {
            graphics.drawImage(this.exclamation, (int)(this.activity.getPatients(this.getAppCode(this.select_appliance))[0].getX(l) - (float)(this.exclamation.getWidth() / 2)), (int)(this.activity.getPatients(this.getAppCode(this.select_appliance))[0].getY(l) - (float)(this.exclamation.getHeight() / 2)), 20);
        }
        if (this.orderloaded) {
            if (this.activity.getPatients(this.getAppCode(this.select_appliance))[this.patient_select].isEmpty()) {
                this.unloadOrder();
                this.patient_select = -1;
            } else {
                for (n = 0; n < this.orderitems.size(); ++n) {
                    if (this.activity.getPatients(this.getAppCode(this.select_appliance))[this.patient_select].isCured(n)) {
                        ((OrderItem)this.orderitems.get(n)).addOne();
                    }
                    if (((OrderItem)this.orderitems.get(n)).render(graphics, l)) continue;
                    bl = true;
                }
                graphics.translate((int)(0.32747397f * f2), (int)(this.scene.getY(0L) + -0.087890625f * f2));
                graphics.drawImage(this.activity.getPatients(this.getAppCode(this.select_appliance))[this.patient_select].getBMP(), 0, 0, 20);
                graphics.translate(-((int)(0.32747397f * f2)), -((int)(this.scene.getY(0L) + -0.087890625f * f2)));
                graphics.translate((int)(0.48828125f * f2), (int)(this.scene.getY(0L) + -0.080078125f * f2));
                this.activity.getKomika().renderString(graphics, -16777216, C2MValues.TEXT_STRESS[this.activity.getLanguage()]);
                graphics.translate(0, this.activity.getCanvas().getHeight() * 7 / 320 * 4 / 3);
                graphics.setColor(-16777216);
                graphics.fillRect(0, 0, this.activity.getKomika().measure(C2MValues.TEXT_STRESS[this.activity.getLanguage()]), this.activity.getCanvas().getHeight() * 7 / 320 * 2 / 3);
                graphics.setColor(this.activity.getPatients(this.getAppCode(this.select_appliance))[this.patient_select].getStressColor());
                graphics.fillRect(0, 1, (int)((float)this.activity.getKomika().measure(C2MValues.TEXT_STRESS[this.activity.getLanguage()]) * this.activity.getPatients(this.getAppCode(this.select_appliance))[this.patient_select].getStress()), this.activity.getCanvas().getHeight() * 7 / 320 * 2 / 3 - 1);
                graphics.translate(-((int)(0.48828125f * f2)), -((int)(this.scene.getY(0L) + -0.080078125f * f2)) - this.activity.getCanvas().getHeight() * 7 / 320 * 4 / 3);
                if (this.getAppCode(this.select_appliance) < 5) {
                    graphics.translate((int)(this.orderok.getX(l) - (float)(this.activity.getBrady().measure(C2MValues.TEXT_SEND_TO_LOBBY[this.activity.getLanguage()]) / 2)), (int)(this.orderok.getY(l) - (float)(this.activity.getCanvas().getHeight() * 7 / 320 / 2)));
                    this.activity.getBrady().renderString(graphics, -1, C2MValues.TEXT_SEND_TO_LOBBY[this.activity.getLanguage()]);
                    graphics.translate(-((int)(this.orderok.getX(l) - (float)(this.activity.getBrady().measure(C2MValues.TEXT_SEND_TO_LOBBY[this.activity.getLanguage()]) / 2))), -((int)(this.orderok.getY(l) - (float)(this.activity.getCanvas().getHeight() * 7 / 320 / 2))));
                }
            }
        }
        if (this.leveluploaded) {
            for (n = 0; n < this.overmenu.size(); ++n) {
                if (((AnimatedElement)this.overmenu.get(n)).render(graphics, l)) continue;
                bl = true;
            }
            if (this.isvictory) {
                graphics.translate((int)(f2 / 2.0f - (float)(this.activity.getBrady().measure(C2MValues.TEXT_CONGRATULATIONS[this.activity.getLanguage()]) / 2)), (int)(this.leveluppanel.getY(l) + -0.20507812f * f2));
                this.activity.getBrady().renderString(graphics, -1, C2MValues.TEXT_CONGRATULATIONS[this.activity.getLanguage()]);
                graphics.translate(-((int)(f2 / 2.0f - (float)(this.activity.getBrady().measure(C2MValues.TEXT_CONGRATULATIONS[this.activity.getLanguage()]) / 2))), -((int)(this.leveluppanel.getY(l) + -0.20507812f * f2)));
                for (n = 0; n < C2MValues.TEXT_VICTORY[this.activity.getLanguage()].length; ++n) {
                    graphics.translate((int)(f2 / 2.0f - (float)(this.activity.getKomika().measure(C2MValues.TEXT_VICTORY[this.activity.getLanguage()][n].toUpperCase()) / 2)), (int)(this.leveluppanel.getY(l) + (-181.0f + 70.0f * (float)n) / 2048.0f * 4.0f / 3.0f * f2));
                    this.activity.getKomika().renderString(graphics, -16777216, C2MValues.TEXT_VICTORY[this.activity.getLanguage()][n].toUpperCase());
                    graphics.translate(-((int)(f2 / 2.0f - (float)(this.activity.getKomika().measure(C2MValues.TEXT_VICTORY[this.activity.getLanguage()][n].toUpperCase()) / 2))), -((int)(this.leveluppanel.getY(l) + (-181.0f + 70.0f * (float)n) / 2048.0f * 4.0f / 3.0f * f2)));
                }
            } else {
                graphics.translate((int)(f2 / 2.0f - (float)(this.activity.getBrady().measure(C2MValues.TEXT_CONGRATULATIONS[this.activity.getLanguage()]) / 2)), (int)(this.leveluppanel.getY(l) + -0.17317708f * f2));
                this.activity.getBrady().renderString(graphics, -1, C2MValues.TEXT_CONGRATULATIONS[this.activity.getLanguage()]);
                graphics.translate(-((int)(f2 / 2.0f - (float)(this.activity.getBrady().measure(C2MValues.TEXT_CONGRATULATIONS[this.activity.getLanguage()]) / 2))), -((int)(this.leveluppanel.getY(l) + -0.17317708f * f2)));
                graphics.translate((int)(f2 / 2.0f - (float)(this.activity.getBrady().measure(C2MValues.TEXT_REACHED_LEVEL[this.activity.getLanguage()]) / 2)), (int)(this.leveluppanel.getY(l) + -0.10221354f * f2));
                this.activity.getBrady().renderString(graphics, -1, C2MValues.TEXT_REACHED_LEVEL[this.activity.getLanguage()]);
                graphics.translate(-((int)(f2 / 2.0f - (float)(this.activity.getBrady().measure(C2MValues.TEXT_REACHED_LEVEL[this.activity.getLanguage()]) / 2))), -((int)(this.leveluppanel.getY(l) + -0.10221354f * f2)));
                graphics.translate((int)(f2 / 2.0f - (float)(this.activity.getCartoon().measure(String.valueOf(this.activity.getLevel())) / 2)), (int)(this.leveluppanel.getY(l) + -0.022786459f * f2));
                this.activity.getCartoon().renderString(graphics, -16777216, String.valueOf(this.activity.getLevel()));
                graphics.translate(-((int)(f2 / 2.0f - (float)(this.activity.getCartoon().measure(String.valueOf(this.activity.getLevel())) / 2))), -((int)(this.leveluppanel.getY(l) + -0.022786459f * f2)));
            }
        } else if (this.dialogloaded) {
            if (this.last_dialog == 150) {
                this.activity.getPatients(5)[0].renderInPlace(graphics, l, 0, 5);
            }
            if (this.last_dialog == 150) {
                this.activity.getPatients(5)[1].renderInPlace(graphics, l, 1, 5);
            }
            if (this.last_dialog == 154) {
                this.oven1.render(graphics, l);
            }
            if (this.last_dialog == 112) {
                this.drink.render(graphics, l);
            }
            if (this.last_dialog == 127) {
                this.upimg[1].render(graphics, l);
            }
            if (this.last_dialog == 131) {
                this.upimg[0].render(graphics, l);
                this.upimg[2].render(graphics, l);
            }
            if (this.last_dialog == 134) {
                this.map.render(graphics, l);
            }
            for (n = 0; n < this.overmenu.size(); ++n) {
                if (((AnimatedElement)this.overmenu.get(n)).render(graphics, l)) continue;
                bl = true;
            }
            graphics.translate((int)(f2 * 159.0f / 1536.0f), (int)(this.bwood.getY(0L) + -0.71875f * f2));
            if (this.dialog_res.equals("dialogue_gregory")) {
                this.activity.getCartoon().renderString(graphics, -1, C2MValues.CHARACTER_NAMES[this.activity.getLanguage()][0]);
            } else if (this.dialog_res.equals("dialogue_joy")) {
                this.activity.getCartoon().renderString(graphics, -1, C2MValues.CHARACTER_NAMES[this.activity.getLanguage()][1]);
            } else if (this.dialog_res.equals("dialogue_harry")) {
                this.activity.getCartoon().renderString(graphics, -1, C2MValues.CHARACTER_NAMES[this.activity.getLanguage()][2]);
            } else {
                this.activity.getCartoon().renderString(graphics, -1, C2MValues.CHARACTER_NAMES[this.activity.getLanguage()][3]);
            }
            graphics.translate(-((int)(f2 * 159.0f / 1536.0f)), -((int)(this.bwood.getY(0L) + -0.71875f * f2)));
            graphics.translate((int)(f2 * 195.0f / 1536.0f), (int)(this.bwood.getY(0L) + -0.5807292f * f2));
            this.activity.getKomika().renderString(graphics, -16777216, this.dialog_lines[this.dialog_index]);
            graphics.translate(-((int)(f2 * 195.0f / 1536.0f)), -((int)(this.bwood.getY(0L) + -0.5807292f * f2)));
            if (this.dialog_lines.length > this.dialog_index + 1) {
                graphics.translate((int)(f2 * 195.0f / 1536.0f), (int)(this.bwood.getY(0L) + -0.52213544f * f2));
                this.activity.getKomika().renderString(graphics, -16777216, this.dialog_lines[this.dialog_index + 1]);
                graphics.translate(-((int)(f2 * 195.0f / 1536.0f)), -((int)(this.bwood.getY(0L) + -0.52213544f * f2)));
            }
            if (this.dialog_lines.length > this.dialog_index + 2) {
                graphics.translate((int)(f2 * 195.0f / 1536.0f), (int)(this.bwood.getY(0L) + -0.46354166f * f2));
                this.activity.getKomika().renderString(graphics, -16777216, this.dialog_lines[this.dialog_index + 2]);
                graphics.translate(-((int)(f2 * 195.0f / 1536.0f)), -((int)(this.bwood.getY(0L) + -0.46354166f * f2)));
            }
        } else if (this.upgradeloaded) {
            this.activity.pause();
            for (n = 0; n < this.overmenu.size(); ++n) {
                if (((AnimatedElement)this.overmenu.get(n)).render(graphics, l)) continue;
                bl = true;
            }
            graphics.setColor(-1);
            if (this.activity.getCapacity(this.getAppCode(this.select_appliance)) < 5) {
                String string = this.activity.getLevel() >= C2MValues.CAPACITY_UPGRADE_LEVEL[this.getAppCode(this.select_appliance)][this.activity.getCapacity(this.getAppCode(this.select_appliance))] ? "$" + C2MValues.CAPACITY_UPGRADE_COST[this.getAppCode(this.select_appliance)][this.activity.getCapacity(this.getAppCode(this.select_appliance))] : C2MValues.TEXT_LEVEL[this.activity.getLanguage()] + " " + C2MValues.CAPACITY_UPGRADE_LEVEL[this.getAppCode(this.select_appliance)][this.activity.getCapacity(this.getAppCode(this.select_appliance))];
                graphics.translate((int)(this.upupgrade[0].getX(l) - (float)(this.activity.getCartoon().measure(string) / 2)), (int)(this.upupgrade[0].getY(l) - (float)(this.activity.getCanvas().getHeight() * 17 / 320 / 2)));
                this.activity.getCartoon().renderString(graphics, -1, string);
                graphics.translate(-((int)(this.upupgrade[0].getX(l) - (float)(this.activity.getCartoon().measure(string) / 2))), -((int)(this.upupgrade[0].getY(l) - (float)(this.activity.getCanvas().getHeight() * 17 / 320 / 2))));
            }
            if (this.activity.getProcedureTime(this.getAppCode(this.select_appliance)) > C2MValues.PROCEDURE_TIME_BY_UPGRADE[C2MValues.PROCEDURE_TIME_BY_UPGRADE.length - 1]) {
                int n2 = 0;
                for (int i = 0; i < C2MValues.PROCEDURE_TIME_BY_UPGRADE.length; ++i) {
                    if (this.activity.getProcedureTime(this.getAppCode(this.select_appliance)) != C2MValues.PROCEDURE_TIME_BY_UPGRADE[i]) continue;
                    n2 = i;
                    break;
                }
                String string = this.activity.getLevel() >= C2MValues.PROCEDURE_TIME_UPGRADE_LEVEL[this.getAppCode(this.select_appliance)][n2] ? "$" + C2MValues.PROCEDURE_TIME_UPGRADE_COST[this.getAppCode(this.select_appliance)][n2] : C2MValues.TEXT_LEVEL[this.activity.getLanguage()] + " " + C2MValues.PROCEDURE_TIME_UPGRADE_LEVEL[this.getAppCode(this.select_appliance)][n2];
                graphics.translate((int)(this.upupgrade[1].getX(l) - (float)(this.activity.getCartoon().measure(string) / 2)), (int)(this.upupgrade[1].getY(l) - (float)(this.activity.getCanvas().getHeight() * 17 / 320 / 2)));
                this.activity.getCartoon().renderString(graphics, -1, string);
                graphics.translate(-((int)(this.upupgrade[1].getX(l) - (float)(this.activity.getCartoon().measure(string) / 2))), -((int)(this.upupgrade[1].getY(l) - (float)(this.activity.getCanvas().getHeight() * 17 / 320 / 2))));
            }
            if (this.activity.getStressCap(this.getAppCode(this.select_appliance)) < C2MValues.STRESS_HANDLING_BY_UPGRADE[C2MValues.STRESS_HANDLING_BY_UPGRADE.length - 1]) {
                int n3 = 0;
                for (int i = 0; i < C2MValues.STRESS_HANDLING_BY_UPGRADE.length; ++i) {
                    if (this.activity.getStressCap(this.getAppCode(this.select_appliance)) != C2MValues.STRESS_HANDLING_BY_UPGRADE[i]) continue;
                    n3 = i;
                    break;
                }
                String string = this.activity.getLevel() >= C2MValues.STRESS_HANDLING_UPGRADE_LEVEL[this.getAppCode(this.select_appliance)][n3] ? "$" + C2MValues.STRESS_HANDLING_UPGRADE_COST[this.getAppCode(this.select_appliance)][n3] : C2MValues.TEXT_LEVEL[this.activity.getLanguage()] + " " + C2MValues.STRESS_HANDLING_UPGRADE_LEVEL[this.getAppCode(this.select_appliance)][n3];
                graphics.translate((int)(this.upupgrade[2].getX(l) - (float)(this.activity.getCartoon().measure(string) / 2)), (int)(this.upupgrade[2].getY(l) - (float)(this.activity.getCanvas().getHeight() * 17 / 320 / 2)));
                this.activity.getCartoon().renderString(graphics, -1, string);
                graphics.translate(-((int)(this.upupgrade[2].getX(l) - (float)(this.activity.getCartoon().measure(string) / 2))), -((int)(this.upupgrade[2].getY(l) - (float)(this.activity.getCanvas().getHeight() * 17 / 320 / 2))));
            }
            graphics.setColor(-16777216);
            for (n = 0; n < 3; ++n) {
                String[] stringArray;
                switch (n) {
                    default: {
                        stringArray = new String[]{C2MValues.TEXT_CAPACITY[this.activity.getLanguage()]};
                        break;
                    }
                    case 1: {
                        stringArray = new String[]{C2MValues.TEXT_SPEED[this.activity.getLanguage()]};
                        break;
                    }
                    case 2: {
                        stringArray = new String[]{C2MValues.TEXT_STRESS_HANDLING[this.activity.getLanguage()]};
                    }
                }
                if (stringArray[0].indexOf(" ") > 0) {
                    stringArray = new String[]{stringArray[0].substring(0, stringArray[0].indexOf(" ")), stringArray[0].substring(stringArray[0].indexOf(" ") + 1)};
                }
                if (stringArray.length == 1) {
                    graphics.translate((int)(f2 * 301.0f / 1536.0f), (int)(this.upupgrade[n].getY(l) - (float)(this.activity.getCanvas().getHeight() * 7 / 320 / 2)));
                    this.activity.getKomika().renderString(graphics, -16777216, stringArray[0]);
                    graphics.translate(-((int)(f2 * 301.0f / 1536.0f)), -((int)(this.upupgrade[n].getY(l) - (float)(this.activity.getCanvas().getHeight() * 7 / 320 / 2))));
                    continue;
                }
                for (int i = 2; i < stringArray.length; ++i) {
                    stringArray[1] = stringArray[1] + ' ' + stringArray[i];
                }
                graphics.translate((int)(f2 * 301.0f / 1536.0f), (int)(this.upupgrade[n].getY(l) - (float)(this.activity.getCanvas().getHeight() * 7 / 320 * 9 / 8)));
                this.activity.getKomika().renderString(graphics, -16777216, stringArray[0]);
                graphics.translate(0, this.activity.getCanvas().getHeight() * 7 / 320 * 5 / 4);
                this.activity.getKomika().renderString(graphics, -16777216, stringArray[1]);
                graphics.translate(-((int)(f2 * 301.0f / 1536.0f)), -((int)(this.upupgrade[n].getY(l) - (float)(this.activity.getCanvas().getHeight() * 7 / 320 * 9 / 8))) - this.activity.getCanvas().getHeight() * 7 / 320 * 5 / 4);
            }
            graphics.setColor(-15111481);
            graphics.translate((int)(f2 * 0.5f - (float)(this.activity.getCartoon().measure(C2MValues.TEXT_ROOM_UPGRADES[this.activity.getLanguage()][this.getAppCode(this.select_appliance)]) / 2)), (int)(this.upupgrade[0].getY(l) + -306.0f * f2 / 1536.0f));
            this.activity.getCartoon().renderString(graphics, -15111481, C2MValues.TEXT_ROOM_UPGRADES[this.activity.getLanguage()][this.getAppCode(this.select_appliance)]);
            graphics.translate(-((int)(f2 * 0.5f - (float)(this.activity.getCartoon().measure(C2MValues.TEXT_ROOM_UPGRADES[this.activity.getLanguage()][this.getAppCode(this.select_appliance)]) / 2))), -((int)(this.upupgrade[0].getY(l) + -306.0f * f2 / 1536.0f)));
        }
        for (n = 0; n < this.activity.getDeliverers(); ++n) {
            if (this.activity.getDeliveryState(n) != 1 && this.activity.getDeliveryState(n) != 2) continue;
            graphics.drawImage(this.exclamation, (int)(this.map.getX(l) + (float)(this.map.getWidth() / 2)), (int)(this.map.getY(l) - (float)(this.map.getHeight() / 2)), 10);
            break;
        }
        if (this.activity.isPaused()) {
            bl = false;
        }
        if (this.activity.isPaused() && !this.upgradeloaded && !this.dialogloaded && !this.leveluploaded) {
            long l2 = System.currentTimeMillis();
            if (!this.options_loaded) {
                this.loadOptions(f2 / f3, f2, f3, l2);
            }
            for (int i = 0; i < this.overmenu.size(); ++i) {
                if (((AnimatedElement)this.overmenu.get(i)).render(graphics, l2)) continue;
                bl = true;
            }
            graphics.translate((int)(this.optioncanv.getX(l2) - (float)(this.activity.getCartoon().measure(C2MValues.TEXT_PAUSED[this.activity.getLanguage()]) / 2)), (int)(f2 * 408.0f / 1536.0f + f3 * (1.0f - f2 / f3 * 4.0f / 3.0f)));
            this.activity.getCartoon().renderString(graphics, -1, C2MValues.TEXT_PAUSED[this.activity.getLanguage()]);
            graphics.translate(-((int)(this.optioncanv.getX(l2) - (float)(this.activity.getCartoon().measure(C2MValues.TEXT_PAUSED[this.activity.getLanguage()]) / 2))), -((int)(f2 * 408.0f / 1536.0f + f3 * (1.0f - f2 / f3 * 4.0f / 3.0f))));
            graphics.translate((int)(this.quit.getX(l2) - (float)(this.activity.getBrady().measure(C2MValues.TEXT_QUIT_GAME[this.activity.getLanguage()]) / 2)), (int)(this.quit.getY(l2) - (float)(this.activity.getCanvas().getHeight() * 7 / 320 / 2)));
            this.activity.getBrady().renderString(graphics, -1, C2MValues.TEXT_QUIT_GAME[this.activity.getLanguage()]);
            graphics.translate(-((int)(this.quit.getX(l2) - (float)(this.activity.getBrady().measure(C2MValues.TEXT_QUIT_GAME[this.activity.getLanguage()]) / 2))), -((int)(this.quit.getY(l2) - (float)(this.activity.getCanvas().getHeight() * 7 / 320 / 2))));
        }
        if (bl) {
            this.activity.invalidate();
        } else if (this.apploaded) {
            this.activity.postInvalidateDelayed(100L - (l - this.last_time));
        } else {
            this.activity.postInvalidateDelayed(1000L - (l - this.last_time));
        }
        this.last_time = l;
    }

    public int getAppCode(Appliance appliance) {
        if (appliance == null) {
            return 5;
        }
        if (appliance == this.oven1) {
            return 0;
        }
        if (appliance == this.oven2) {
            return 1;
        }
        if (appliance == this.drink) {
            return 2;
        }
        if (appliance == this.salad) {
            return 3;
        }
        if (appliance == this.dessert) {
            return 4;
        }
        return 5;
    }

    public Appliance getAppliance(int n) {
        switch (n) {
            case 0: {
                return this.oven1;
            }
            case 1: {
                return this.oven2;
            }
            case 2: {
                return this.drink;
            }
            case 3: {
                return this.salad;
            }
            case 4: {
                return this.dessert;
            }
        }
        return null;
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        int n = motionEvent.getAction();
        this.activity.invalidate();
        if (!this.loaded) {
            return false;
        }
        switch (n) {
            case 1: {
                switch (this.select_option) {
                    case 22: {
                        this.unloadLevelUp();
                        break;
                    }
                    case 18: {
                        this.activity.loadAll();
                        this.activity.openMainMenu();
                        break;
                    }
                    case 19: {
                        this.activity.getPrefEditor().putBoolean("sound_on", !this.activity.getSharedPref().getBoolean("sound_on", true));
                        this.activity.getPrefEditor().putBoolean("music_on", !this.activity.getSharedPref().getBoolean("music_on", true));
                        this.activity.getPrefEditor().commit();
                        if (this.activity.getSharedPref().getBoolean("sound_on", true)) {
                            this.sound.setPNG("toggleon_sound");
                            this.activity.getMusic().startMusic();
                        } else {
                            this.sound.setPNG("toggleoff_sound");
                            this.activity.getMusic().stopMusic();
                        }
                        this.sound.setFilter(null);
                        break;
                    }
                    case 20: {
                        this.unloadOptions();
                        this.activity.resume();
                        break;
                    }
                    case 17: {
                        this.dialog_index += 3;
                        if (this.dialog_lines.length > this.dialog_index) {
                            if (this.dialog_lines.length <= this.dialog_index + 3) {
                                this.dialog_btn.setPNG("button_dialogueok");
                            }
                            this.dialog_btn.setFilter(null);
                            break;
                        }
                        this.unloadDialog();
                        break;
                    }
                    case 1: {
                        if (this.leveluploaded || this.upgradeloaded || this.dialogloaded) {
                            this.map.setFilter(null);
                            break;
                        }
                        this.activity.openMap();
                        break;
                    }
                    case 2: {
                        this.pause.setFilter(null);
                        if (this.leveluploaded || this.upgradeloaded || this.dialogloaded) break;
                        this.activity.togglePause();
                        float f = (float)this.activity.getCanvas().getWidth() / (float)this.background.getWidth();
                        float f2 = this.background.getWidth();
                        float f3 = (float)this.activity.getCanvas().getHeight() / f;
                        this.loadOptions(f2 / f3, f2, f3, System.currentTimeMillis());
                        break;
                    }
                    case 16: {
                        this.activity.upgradeAppliance(this.getAppCode(this.select_appliance), this.upgrade_over);
                        this.unloadUpgrade();
                        for (int i = 0; i < 5; ++i) {
                            int n2;
                            if (this.isupgrade[i] != 1) continue;
                            boolean bl = false;
                            for (n2 = 0; n2 < 3; ++n2) {
                                if (this.activity.upgradeAvailable(i, n2) == 1 && (this.activity.getCapacity(i) > 0 || this.activity.upgradeAvailable(i, 0) == 1)) {
                                    bl = false;
                                    break;
                                }
                                if (this.activity.upgradeAvailable(i, n2) != 0) continue;
                                bl = true;
                            }
                            if (n2 != 3) continue;
                            if (!bl && this.activity.getCapacity(i) == 0) {
                                this.upimg[i] = null;
                            }
                            this.isupgrade[i] = bl ? 0 : -1;
                        }
                        this.activity.resume();
                        break;
                    }
                    case 15: {
                        this.unloadUpgrade();
                        this.activity.resume();
                        float f = (float)this.activity.getCanvas().getWidth() / (float)this.background.getWidth();
                        float f4 = this.background.getWidth();
                        float f5 = (float)this.activity.getCanvas().getHeight() / f;
                        this.loadApp(f4 / f5, f4, f5);
                        break;
                    }
                    case 3: {
                        if (this.leveluploaded || this.upgradeloaded || this.dialogloaded) break;
                        this.activity.getPatients(this.getAppCode(this.select_appliance))[this.patient_select].setFilter(null);
                        if (!this.orderloaded && !this.activity.getPatients(this.getAppCode(this.select_appliance))[this.patient_select].isEmpty()) {
                            float f = (float)this.activity.getCanvas().getWidth() / (float)this.background.getWidth();
                            float f6 = this.background.getWidth();
                            float f7 = (float)this.activity.getCanvas().getHeight() / f;
                            this.loadOrder(f6 / f7, f6, f7);
                            break;
                        }
                        this.unloadOrder();
                        break;
                    }
                    case 4: 
                    case 21: {
                        this.activity.getPatients(this.getAppCode(this.select_appliance))[this.patient_move].setFilter(null);
                        if (this.patient_move != this.patient_select) {
                            this.activity.movePatient(this.getAppCode(this.select_appliance), this.patient_move, this.getAppCode(this.select_appliance), this.patient_select);
                        }
                        this.patient_move = -1;
                        this.patient_select = -1;
                        this.patient_room = -1;
                        this.unloadOrder();
                        this.on_order = null;
                        break;
                    }
                    case 11: {
                        this.upimg[this.patient_room].setFilter(null);
                        if (this.leveluploaded || this.upgradeloaded || this.dialogloaded) break;
                        float f = (float)this.activity.getCanvas().getWidth() / (float)this.background.getWidth();
                        float f8 = this.background.getWidth();
                        float f9 = (float)this.activity.getCanvas().getHeight() / f;
                        if (this.activity.getCapacity(this.patient_room) == 0) {
                            this.upimg[this.patient_room] = null;
                            this.isupgrade[this.patient_room] = -1;
                            this.activity.upgradeAppliance(this.patient_room, 0);
                            switch (this.patient_room) {
                                case 1: {
                                    this.loadOven2(f8 / f9, f8, f9, this.last_time);
                                    break;
                                }
                                case 3: {
                                    this.loadSalad(f8 / f9, f8, f9, this.last_time);
                                    break;
                                }
                                case 4: {
                                    this.loadDessert(f8 / f9, f8, f9, this.last_time);
                                }
                            }
                            this.patient_room = -1;
                            for (int i = 0; i < 5; ++i) {
                                int n3;
                                if (this.isupgrade[i] != 1) continue;
                                boolean bl = false;
                                for (n3 = 0; n3 < 3; ++n3) {
                                    if (this.activity.upgradeAvailable(i, n3) == 1 && (this.activity.getCapacity(i) > 0 || this.activity.upgradeAvailable(i, 0) == 1)) {
                                        bl = false;
                                        break;
                                    }
                                    if (this.activity.upgradeAvailable(i, n3) != 0) continue;
                                    bl = true;
                                }
                                if (n3 != 3) continue;
                                if (!bl && this.activity.getCapacity(i) == 0 && this.upimg[i] != null) {
                                    this.upimg[i] = null;
                                }
                                this.isupgrade[i] = bl ? 0 : -1;
                            }
                            break;
                        }
                        this.select_appliance = this.getAppliance(this.patient_room);
                        this.select_appliance.setFilter(null);
                        this.loadApp(f8 / f9, f8, f9);
                        this.loadUpgrade(f8 / f9, f8, f9, this.patient_room);
                        break;
                    }
                    case 5: {
                        if (this.leveluploaded || this.upgradeloaded || this.dialogloaded) break;
                        if (this.patient_select >= 0) {
                            if (this.patient_room == 5) {
                                this.orderok.setFilter(null);
                            } else {
                                this.getAppliance(this.patient_room).setFilter(null);
                            }
                            if (this.patient_room != this.getAppCode(this.select_appliance)) {
                                this.activity.movePatient(this.patient_room, -1, this.getAppCode(this.select_appliance), this.patient_select);
                            }
                            this.unloadOrder();
                            this.patient_select = -1;
                            this.patient_room = -1;
                            break;
                        }
                        if (this.select_appliance == null) {
                            this.checkMessage(150);
                            break;
                        }
                        if (this.activity.getPoints() == 0 && !this.activity.getPatients(5)[1].isEmpty()) {
                            this.checkMessage(152);
                            this.activity.getPrefEditor().putBoolean("msg_52", false);
                            this.activity.getPrefEditor().commit();
                        }
                        this.select_appliance.setFilter(null);
                        this.select_appliance.clearSignal();
                        float f = (float)this.activity.getCanvas().getWidth() / (float)this.background.getWidth();
                        float f10 = this.background.getWidth();
                        float f11 = (float)this.activity.getCanvas().getHeight() / f;
                        int n4 = Math.max(1, this.getAppCode(this.select_appliance));
                        this.loadApp(f10 / f11, f10, f11);
                        break;
                    }
                    case 6: {
                        if (this.patient_room == -1 && this.patient_select != -1) {
                            this.select_appliance.setFilter(null);
                            this.unloadOrder();
                            this.patient_select = -1;
                            this.patient_room = -1;
                            break;
                        }
                        this.select_appliance.setFilter(null);
                        this.patient_room = -1;
                        this.patient_select = -1;
                        this.unloadApp();
                        this.activity.getCanvas().setFocus(this.select_appliance);
                        this.select_appliance = null;
                        break;
                    }
                    case 7: {
                        this.speedup = null;
                        this.activity.speedUp(this.last_time);
                        break;
                    }
                    case 8: {
                        this.calmdown = null;
                        this.activity.calmDown(this.last_time);
                    }
                }
                this.clickx = -1.0f;
                this.select_option = 0;
                return false;
            }
            case 2: {
                int n5;
                if (this.leveluploaded) {
                    if (this.levelupok.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) {
                        this.select_option = 22;
                        this.levelupok.setFilter(MenuView.filter_dark);
                        this.activity.playSound("standard_click");
                    }
                    return true;
                }
                if (this.dialogloaded) {
                    if (this.dialog_btn.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) {
                        this.select_option = 17;
                        this.dialog_btn.setFilter(MenuView.filter_dark);
                        this.activity.playSound("standard_click");
                    }
                    return true;
                }
                if (this.upgradeloaded) {
                    if (this.upback.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) {
                        this.select_option = 15;
                        this.upback.setFilter(MenuView.filter_dark);
                        this.activity.playSound("standard_click");
                    } else {
                        for (int i = 0; i < 3; ++i) {
                            if (this.upupgrade[i] == null || !this.upupgrade[i].inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight()) || this.activity.upgradeAvailable(this.getAppCode(this.select_appliance), i) != 1) continue;
                            this.select_option = 16;
                            this.upupgrade[i].setFilter(MenuView.filter_dark);
                            this.activity.playSound("confirm_upgrade");
                            this.upgrade_over = i;
                        }
                    }
                    return true;
                }
                if (this.pause.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) {
                    this.select_option = 2;
                    this.pause.setFilter(MenuView.filter_dark);
                    this.activity.playSound("standard_click");
                    return true;
                }
                if (this.activity.isPaused()) {
                    if (this.options_loaded) {
                        if (this.quit.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) {
                            this.select_option = 18;
                            this.quit.setFilter(MenuView.filter_dark);
                            this.activity.playSound("standard_click");
                        } else if (this.sound.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) {
                            this.select_option = 19;
                            this.sound.setFilter(MenuView.filter_dark);
                            this.activity.playSound("standard_click");
                        } else if (this.back.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) {
                            this.select_option = 20;
                            this.back.setFilter(MenuView.filter_dark);
                            this.activity.playSound("standard_click");
                        }
                    }
                    return true;
                }
                if (this.map.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight()) && !this.deliveryloaded) {
                    this.select_option = 1;
                    this.map.setFilter(MenuView.filter_dark);
                    this.activity.playSound("standard_click");
                }
                if (this.orderloaded) {
                    if (this.orderok.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight()) && this.getAppCode(this.select_appliance) != 5) {
                        this.select_option = 5;
                        this.patient_room = 5;
                        this.orderok.setFilter(MenuView.filter_dark);
                        this.activity.playSound("assigned_patient");
                        return true;
                    }
                } else {
                    if (this.speedup != null && this.speedup.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) {
                        this.select_option = 7;
                        this.speedup.setFilter(MenuView.filter_dark);
                        this.activity.playSound("speedup_special");
                        return true;
                    }
                    if (this.calmdown != null && this.calmdown.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) {
                        this.select_option = 8;
                        this.calmdown.setFilter(MenuView.filter_dark);
                        this.activity.playSound("stressdown_special");
                        return true;
                    }
                }
                for (n5 = 0; n5 < 5; ++n5) {
                    if (this.isupgrade[n5] != 1 || this.patient_select >= 0 || !this.upimg[n5].inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) continue;
                    this.select_option = 11;
                    this.patient_room = n5;
                    float f = (float)this.activity.getCanvas().getWidth() / (float)this.background.getWidth();
                    float f12 = this.background.getWidth();
                    float f13 = (float)this.activity.getCanvas().getHeight() / f;
                    this.loadApp(f12 / f13, f12, f13);
                    this.upimg[n5].setFilter(MenuView.filter_dark);
                    this.activity.playSound("standard_click");
                    return true;
                }
                for (n5 = 0; n5 < this.appliances.size(); ++n5) {
                    if (!((Appliance)this.appliances.get(n5)).inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) continue;
                    if (this.patient_select >= 0) {
                        this.select_option = 5;
                        this.patient_room = this.getAppCode((Appliance)this.appliances.get(n5));
                        ((Appliance)this.appliances.get(n5)).setFilter(MenuView.filter_dark);
                        this.activity.playSound("assigned_patient");
                    } else {
                        this.select_option = 5;
                        this.select_appliance = (Appliance)this.appliances.get(n5);
                        ((Appliance)this.appliances.get(n5)).setFilter(MenuView.filter_dark);
                        this.activity.playSound("standard_click");
                    }
                    return true;
                }
                if ((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth() > 0.3f && (float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth() < 0.7f && (float)(motionEvent.getY() * this.background.getWidth() / this.activity.getCanvas().getWidth()) < this.oven1.getY(this.last_time) + (float)(this.oven1.getHeight() / 2) && (float)(motionEvent.getY() * this.background.getWidth() / this.activity.getCanvas().getWidth()) > this.oven1.getY(this.last_time) - (float)this.oven1.getHeight() && this.patient_select < 0) {
                    if (this.select_appliance != null) {
                        this.select_option = 5;
                        this.select_appliance = null;
                        this.activity.playSound("standard_click");
                    }
                    return true;
                }
                for (n5 = 0; n5 < this.activity.getCapacity(this.getAppCode(this.select_appliance)); ++n5) {
                    if (!this.activity.getPatients(this.getAppCode(this.select_appliance))[n5].inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight()) && (n5 != 0 || !((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth() < 0.2f) || !((float)motionEvent.getY() < this.kitchen.getY(this.last_time) - (float)(this.kitchen.getHeight() / 2)) || !((float)motionEvent.getY() > this.scene.getY(this.last_time) + (float)(this.scene.getHeight() * 2 / 5)))) continue;
                    if (this.patient_select >= 0) {
                        this.patient_move = n5;
                        this.select_option = 4;
                        this.activity.getPatients(this.getAppCode(this.select_appliance))[this.patient_move].setFilter(MenuView.filter_dark);
                        this.activity.playSound("assigned_patient");
                        continue;
                    }
                    if (this.activity.getPatients(this.getAppCode(this.select_appliance))[n5].isEmpty()) continue;
                    this.patient_select = n5;
                    this.select_option = 3;
                    this.activity.getPatients(this.getAppCode(this.select_appliance))[n5].setFilter(MenuView.filter_dark);
                    this.activity.playSound("standard_click");
                }
                return true;
            }
            case 3: {
                switch (this.select_option) {
                    case 22: {
                        if (this.levelupok.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) break;
                        this.select_option = 0;
                        this.levelupok.setFilter(null);
                        break;
                    }
                    case 18: {
                        if (this.quit.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) break;
                        this.select_option = 0;
                        this.quit.setFilter(null);
                        break;
                    }
                    case 19: {
                        if (this.sound.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) break;
                        this.select_option = 0;
                        this.sound.setFilter(null);
                        break;
                    }
                    case 20: {
                        if (this.back.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) break;
                        this.select_option = 0;
                        this.back.setFilter(null);
                        break;
                    }
                    case 17: {
                        if (this.dialog_btn.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) break;
                        this.select_option = 0;
                        this.dialog_btn.setFilter(null);
                        break;
                    }
                    case 1: {
                        if (this.map.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) break;
                        this.select_option = 0;
                        this.map.setFilter(null);
                        break;
                    }
                    case 2: {
                        if (this.pause.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) break;
                        this.select_option = 0;
                        this.pause.setFilter(null);
                        break;
                    }
                    case 15: {
                        if (this.upback.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) break;
                        this.select_option = 0;
                        this.upback.setFilter(null);
                        break;
                    }
                    case 16: {
                        if (this.upupgrade[this.upgrade_over].inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) break;
                        this.select_option = 0;
                        this.upupgrade[this.upgrade_over].setFilter(null);
                        break;
                    }
                    case 3: {
                        if (this.activity.getPatients(this.getAppCode(this.select_appliance))[this.patient_select].inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight()) || this.patient_select == 0 && (float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth() < 0.2f && (float)motionEvent.getY() < this.kitchen.getY(this.last_time) - (float)(this.kitchen.getHeight() / 2) && (float)motionEvent.getY() > this.scene.getY(this.last_time) + (float)(this.scene.getHeight() * 2 / 5)) break;
                        this.select_option = 0;
                        this.activity.getPatients(this.getAppCode(this.select_appliance))[this.patient_select].setFilter(null);
                        this.patient_select = -1;
                        this.patient_room = -1;
                        break;
                    }
                    case 4: {
                        if (this.activity.getPatients(this.getAppCode(this.select_appliance))[this.patient_move].inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth() - 0.2f * (float)this.patient_move, (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) break;
                        this.select_option = 0;
                        this.activity.getPatients(this.getAppCode(this.select_appliance))[this.patient_move].setFilter(null);
                        this.patient_move = -1;
                        break;
                    }
                    case 5: {
                        if (this.patient_select >= 0) {
                            if (this.patient_room == 5) {
                                if (this.orderok.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) break;
                                this.select_option = 0;
                                this.orderok.setFilter(null);
                                this.patient_room = -1;
                                break;
                            }
                            if (this.getAppliance(this.patient_room).inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) break;
                            this.select_option = 0;
                            this.getAppliance(this.patient_room).setFilter(null);
                            this.patient_room = -1;
                            break;
                        }
                        if (this.select_appliance == null) {
                            if ((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth() > 0.3f && (float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth() < 0.7f && (float)(motionEvent.getY() * this.background.getWidth() / this.activity.getCanvas().getWidth()) < this.oven1.getY(this.last_time) + (float)(this.oven1.getHeight() / 2) && (float)(motionEvent.getY() * this.background.getWidth() / this.activity.getCanvas().getWidth()) > this.oven1.getY(this.last_time) - (float)this.oven1.getHeight()) break;
                            this.select_option = 0;
                            break;
                        }
                        if (this.select_appliance.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) break;
                        this.select_option = 0;
                        this.select_appliance.setFilter(null);
                        this.select_appliance = null;
                        break;
                    }
                    case 6: {
                        if (this.select_appliance.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) break;
                        this.select_option = 0;
                        this.select_appliance.setFilter(null);
                        this.select_appliance = null;
                        break;
                    }
                    case 7: {
                        if (this.speedup.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) break;
                        this.select_option = 0;
                        this.speedup.setFilter(null);
                        break;
                    }
                    case 8: {
                        if (this.calmdown.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) break;
                        this.select_option = 0;
                        this.calmdown.setFilter(null);
                        break;
                    }
                    case 11: {
                        if (this.upimg[this.patient_room].inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) break;
                        this.select_option = 0;
                        this.upimg[this.patient_room].setFilter(null);
                        this.patient_room = -1;
                    }
                }
                return true;
            }
        }
        return true;
    }

    public static class MenuOption {
        public static final int NONE = 0;
        public static final int MAP = 1;
        public static final int PAUSE = 2;
        public static final int ORDER = 3;
        public static final int ORDER_OK = 4;
        public static final int APPLIANCE = 5;
        public static final int APP_OK = 6;
        public static final int APP_NEXT = 7;
        public static final int APP_PREV = 8;
        public static final int APP_MENU = 9;
        public static final int APP_SLOT = 10;
        public static final int APP_PLUS = 11;
        public static final int APP_PLUSSLOT = 12;
        public static final int APP_TRASH = 13;
        public static final int DELIVERY = 14;
        public static final int UP_BACK = 15;
        public static final int UP_UPGRADE = 16;
        public static final int DIALOG = 17;
        public static final int QUIT = 18;
        public static final int SOUND = 19;
        public static final int BACK = 20;
        public static final int DELIVERY_NO = 21;
        public static final int LEVELUP_OK = 22;
    }
}

