/*
 * Decompiled with CFR 0.152.
 */
package com.rocktasticgames.vetclinic.main;

import com.rocktasticgames.vetclinic.animated.AnimatedElement;
import com.rocktasticgames.vetclinic.animated.AnimatedPointer;
import com.rocktasticgames.vetclinic.main.MainActivity;
import com.rocktasticgames.vetclinic.utils.MotionEvent;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class MainCanvas
extends Canvas {
    private MainActivity activity;
    private AnimatedElement focus;
    private AnimatedPointer pointer;

    public MainCanvas(MainActivity mainActivity) {
        this.activity = mainActivity;
    }

    protected void paint(Graphics graphics) {
        graphics.setFont(Font.getFont((int)64, (int)0, (int)0));
        switch (this.activity.getState()) {
            case 3: {
                this.activity.getKitchen().onDraw(graphics);
                break;
            }
            case 4: {
                this.activity.getMap().onDraw(graphics);
                break;
            }
            case 2: {
                this.activity.getMenu().onDraw(graphics);
                break;
            }
            case 6: {
                this.activity.getSplashOne().onDraw(graphics);
                break;
            }
            case 7: {
                this.activity.getSplashTwo().onDraw(graphics);
                break;
            }
            case 8: {
                this.activity.getSoundView().onDraw(graphics);
                break;
            }
            case 9: {
                this.activity.getLanguageView().onDraw(graphics);
            }
        }
    }

    private void sendMotionEvent(int n, int n2, int n3) {
        this.activity.invalidate();
        switch (this.activity.getState()) {
            case 3: {
                this.activity.getKitchen().onTouchEvent(new MotionEvent(n, n2, n3));
                break;
            }
            case 4: {
                this.activity.getMap().onTouchEvent(new MotionEvent(n, n2, n3));
                break;
            }
            case 2: {
                this.activity.getMenu().onTouchEvent(new MotionEvent(n, n2, n3));
                break;
            }
            case 6: {
                this.activity.getSplashOne().onTouchEvent(new MotionEvent(n, n2, n3));
                break;
            }
            case 7: {
                this.activity.getSplashTwo().onTouchEvent(new MotionEvent(n, n2, n3));
                break;
            }
            case 8: {
                this.activity.getSoundView().onTouchEvent(new MotionEvent(n, n2, n3));
                break;
            }
            case 9: {
                this.activity.getLanguageView().onTouchEvent(new MotionEvent(n, n2, n3));
            }
        }
    }

    public AnimatedElement getFocus() {
        return this.focus;
    }

    private AnimatedElement getNeighbor(int n) {
        this.activity.invalidate();
        switch (this.activity.getState()) {
            case 3: {
                return this.activity.getKitchen().traverse(this.focus, n);
            }
            case 4: {
                return this.activity.getMap().traverse(this.focus, n);
            }
            case 2: {
                return this.activity.getMenu().traverse(this.focus, n);
            }
            case 8: {
                return this.activity.getSoundView().traverse(this.focus, n);
            }
            case 9: {
                return this.activity.getLanguageView().traverse(this.focus, n);
            }
        }
        return this.focus;
    }

    public void setFocus(AnimatedElement animatedElement) {
    }

    protected void keyPressed(int n) {
        if (n == -11) {
            this.activity.onBackPressed();
            return;
        }
    }

    protected void keyRepeated(int n) {
    }

    protected void keyReleased(int n) {
    }

    protected void pointerReleased(int n, int n2) {
        this.sendMotionEvent(1, n, n2);
    }

    protected void pointerPressed(int n, int n2) {
        this.sendMotionEvent(2, n, n2);
    }

    protected void pointerDragged(int n, int n2) {
        this.sendMotionEvent(3, n, n2);
    }
}

