/*
 * Decompiled with CFR 0.152.
 */
package com.rocktasticgames.vetclinic.main;

import com.rocktasticgames.vetclinic.animated.AnimatedOrder;
import com.rocktasticgames.vetclinic.animated.Patient;
import com.rocktasticgames.vetclinic.c2m.C2MValues;
import com.rocktasticgames.vetclinic.main.MainCanvas;
import com.rocktasticgames.vetclinic.sounds.MenuMusic;
import com.rocktasticgames.vetclinic.utils.BMPFont;
import com.rocktasticgames.vetclinic.utils.List;
import com.rocktasticgames.vetclinic.utils.Path;
import com.rocktasticgames.vetclinic.utils.SharedPreferences;
import com.rocktasticgames.vetclinic.views.KitchenView;
import com.rocktasticgames.vetclinic.views.LanguageView;
import com.rocktasticgames.vetclinic.views.MapView;
import com.rocktasticgames.vetclinic.views.MenuView;
import com.rocktasticgames.vetclinic.views.SoundView;
import com.rocktasticgames.vetclinic.views.SplashC2MView;
import com.rocktasticgames.vetclinic.views.SplashRocktasticView;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

public class MainActivity
extends MIDlet
implements Runnable {
    public static final int PIZZERIA_ROW = 4;
    public static final int PIZZERIA_COL = 2;
    public static final String[][] appimgs = new String[][]{{"hospitalroom_general_lvl1", "hospitalroom_general_lvl2", "hospitalroom_general_lvl3"}, {"hospitalroom_disease_lvl1", "hospitalroom_disease_lvl2", "hospitalroom_disease_lvl3"}, {"hospitalroom_shop_lvl1", "hospitalroom_shop_lvl2", "hospitalroom_shop_lvl3"}, {"hospitalroom_emergency_lvl1", "hospitalroom_emergency_lvl2", "hospitalroom_emergency_lvl3"}, {"hospitalroom_salon_lvl1", "hospitalroom_salon_lvl2", "hospitalroom_salon_lvl3"}};
    public static final String[] delivery_icons = new String[]{"ambulance_topdown_lvl1", "ambulance_topdown_lvl2", "ambulance_topdown_lvl3"};
    public static final String[] deliveryups = new String[]{"ambulance_lvl2", "ambulance_lvl3"};
    private Image heart;
    public static final String[] ambulance_pics = new String[]{"ambulance_lvl1", "ambulance_lvl2", "ambulance_lvl3"};
    private Patient[][] patients;
    private int[] capacity;
    private int[] proc_time;
    private float[] stress_cap;
    private float[] delivery_lastx;
    private float[] delivery_lasty;
    private long next_speedup = 60000L;
    private long next_calmdown = 60000L;
    private boolean screen_locked = false;
    public static final float DOOR_OFFSET = 0.15f;
    public long ltick_time = 0L;
    public static final int PATH_SCALE = 25;
    public static final int MAX_LEVEL = 45;
    public static String[][] appitems;
    public static String[][] cookitems;
    public static String[][] cooknames;
    public static int[][] cookprices;
    private MenuView menu;
    private KitchenView kitchen;
    private MapView map;
    private SplashC2MView splashone;
    private SplashRocktasticView splashtwo;
    private SoundView soundview;
    private MenuMusic music;
    private int state;
    private List orders;
    private float[] delivery_x;
    private float[] delivery_y;
    private int[] delivery_state;
    private AnimatedOrder[][] delivery_items;
    private int delivery_upgrade;
    private long start_time;
    private long pause_time;
    private SharedPreferences shared_pref;
    private SharedPreferences.Editor pref_editor;
    private boolean paused = false;
    private int[] appupgrades;
    private BMPFont brady;
    private BMPFont cartoon;
    private long refresh_time;
    private Path[] deliver_paths;
    private int level;
    private int money;
    private int points;
    private float width;
    private float height;
    private float[] delivery_hspeed;
    private float[] delivery_vspeed;
    private long last_time = 0L;
    private MainCanvas canvas;
    private Thread thread;
    private long invalidate_time;
    private boolean started = false;
    private boolean isminimized = false;
    private LanguageView languageview;
    private int language = 0;
    public Image topbar;
    public Image pausebutton;
    public Image mapbutton;
    public Image kitchenbutton;
    private int currthread = 0;
    private boolean mlock = false;

    protected void startApp() throws MIDletStateChangeException {
        if (!this.started) {
            this.started = true;
            this.init();
        } else if (this.isminimized) {
            this.setLock(true);
            this.isminimized = false;
            if (this.music != null) {
                this.music.kill();
            }
            this.music = new MenuMusic(this, 50, 50);
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    private void init() {
        this.invalidate_time = System.currentTimeMillis();
        this.thread = new Thread(this);
        Display display = Display.getDisplay((MIDlet)this);
        this.canvas = new MainCanvas(this);
        display.setCurrent((Displayable)this.canvas);
        this.canvas.setFullScreenMode(true);
        this.shared_pref = new SharedPreferences();
        this.pref_editor = this.shared_pref.edit();
        this.splashone = new SplashC2MView(this);
        this.state = 6;
        this.thread.start();
    }

    public void splashTaskOne() {
        this.brady = new BMPFont("brady", "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ:/+-x$'!.?()c@,\u00c1\u00c2\u00c0\u00c4\u00c3\u00aa\u00c7\u00c9\u00ca\u00c8\u00cd\u00ce\u00a1\u00bf\u00d1\u00d3\u00d4\u00d6\u00d5\u00ba\u00da\u00db\u00d9\u00dc");
    }

    public void splashTaskTwo() {
        this.cartoon = new BMPFont("cartoon", "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ,$\u00c1\u00c2\u00c0\u00c4\u00c3\u00aa\u00c7\u00c9\u00ca\u00c8\u00cd\u00bf\u00d1\u00d3\u00d4\u00d6\u00d5\u00ba\u00da\u00db\u00dc");
        this.start_time = System.currentTimeMillis();
    }

    public void onSplashOneComplete() {
        this.splashone.destroy();
        this.splashtwo = new SplashRocktasticView(this);
        this.state = 7;
    }

    public void onSplashTwoComplete() {
        this.splashtwo.destroy();
        this.state = 9;
        this.languageview = new LanguageView(this);
    }

    public void onLanguageComplete() {
        this.languageview.destroy();
        this.soundview = new SoundView(this);
        this.state = 8;
        this.language = this.getSharedPref().getInt("language", 0);
        this.loadAll();
    }

    public void onSoundComplete() {
        this.soundview.destroy();
        this.state = 1;
        this.music = new MenuMusic(this, 50, 50);
        this.music.startMusic();
        this.openMainMenu();
    }

    public SplashC2MView getSplashOne() {
        return this.splashone;
    }

    public SplashRocktasticView getSplashTwo() {
        return this.splashtwo;
    }

    public SoundView getSoundView() {
        return this.soundview;
    }

    public LanguageView getLanguageView() {
        return this.languageview;
    }

    public void resetAll() {
        this.getPrefEditor().clearAll();
        this.start_time = this.pause_time = System.currentTimeMillis();
        this.loadAll();
    }

    public void loadAll() {
        this.level = this.shared_pref.getInt("level", 1);
        this.money = this.shared_pref.getInt("money", 0);
        this.points = this.shared_pref.getInt("points", 0);
        this.orders = new List();
        this.patients = new Patient[6][];
        for (int i = 0; i < this.patients.length; ++i) {
            this.patients[i] = new Patient[5];
        }
        try {
            this.heart = Image.createImage((String)"/floating_heart.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.delivery_hspeed = new float[5];
        this.delivery_vspeed = new float[5];
        appitems = new String[5][];
        cookitems = new String[5][];
        cooknames = new String[5][];
        cookprices = new int[5][];
        this.pref_editor.putLong("order_time", this.getTime() + 3000L);
        this.pause();
        this.appupgrades = new int[]{0, 0, 0, 0, 0};
        this.delivery_upgrade = this.shared_pref.getInt("delivery_upgrade", 0);
        this.delivery_state = new int[]{0, -1};
        this.setAvailableSlots();
        this.delivery_x = new float[]{2.0f, 2.0f};
        this.delivery_y = new float[]{3.85f, 3.85f};
        this.delivery_lastx = new float[]{2.0f, 2.0f};
        this.delivery_lasty = new float[]{3.85f, 3.85f};
        this.delivery_items = new AnimatedOrder[2][2];
        this.deliver_paths = new Path[2];
        for (int i = 0; i < this.deliver_paths.length; ++i) {
            this.deliver_paths[i] = new Path();
        }
        this.ltick_time = this.refresh_time = this.getTime();
    }

    public void run() {
        ++this.currthread;
        int n = this.currthread;
        while (this.state != 5 && n == this.currthread) {
            try {
                while (true) {
                    if (this.isminimized) {
                        return;
                    }
                    long l = this.invalidate_time - System.currentTimeMillis();
                    if (l > 30L) {
                        Thread.sleep(Math.min(50L, l));
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.invalidate_time = System.currentTimeMillis() + 100L;
            if (this.state == 5 || n != this.currthread) break;
            this.canvas.repaint();
            if (n == this.currthread && !this.isminimized) {
                this.setLock(false);
            }
            if (!this.canvas.isShown() && n == this.currthread) {
                this.pause();
                if (this.music == null) continue;
                this.music.stopMusic();
                continue;
            }
            if (n != this.currthread) continue;
            if (this.music != null) {
                this.music.startMusic();
                continue;
            }
            if (this.state != 2 && this.state != 3 && this.state != 4) continue;
            this.music = new MenuMusic(this, 50, 50);
            this.music.startMusic();
        }
        if (n == this.currthread) {
            if (this.music != null) {
                this.music.kill();
                this.music = null;
            }
            this.notifyDestroyed();
        }
    }

    public synchronized void setLock(boolean bl) {
        this.mlock = bl;
    }

    public synchronized boolean isLocked() {
        return this.mlock;
    }

    public void invalidate() {
        this.invalidate_time = System.currentTimeMillis();
    }

    public void postInvalidateDelayed(long l) {
        this.invalidate_time = System.currentTimeMillis() + l;
    }

    public MainCanvas getCanvas() {
        return this.canvas;
    }

    public int getState() {
        return this.state;
    }

    public int getLanguage() {
        return this.language;
    }

    public String getBMGLang() {
        switch (this.getLanguage()) {
            default: {
                return "en-GB";
            }
            case 1: {
                return "fr-FR";
            }
            case 2: {
                return "de-DE";
            }
            case 3: {
                return "pt-PT";
            }
            case 4: 
        }
        return "es-ES";
    }

    public String getLanguageCode() {
        return "";
    }

    private void setAvailableSlots() {
        int n;
        int n2;
        this.capacity = new int[6];
        this.stress_cap = new float[5];
        this.proc_time = new int[5];
        for (n2 = 0; n2 < 6; ++n2) {
            if (n2 == 0 || n2 == 2) {
                this.capacity[n2] = this.shared_pref.getInt("cap" + n2, 2);
            } else if (n2 == 1 || n2 == 3 || n2 == 4) {
                this.capacity[n2] = this.shared_pref.getInt("cap" + n2, 0);
            } else {
                this.capacity[5] = 0;
                for (n = 0; n < C2MValues.CAPACITY_UPGRADE_LEVEL[5].length; ++n) {
                    if (this.level < C2MValues.CAPACITY_UPGRADE_LEVEL[5][n]) continue;
                    this.capacity[5] = n + 1;
                }
            }
            if (n2 >= 5) continue;
            this.stress_cap[n2] = 0.01f * (float)C2MValues.STRESS_HANDLING_BY_UPGRADE[this.shared_pref.getInt("stress" + n2, 0)];
            this.proc_time[n2] = C2MValues.PROCEDURE_TIME_BY_UPGRADE[this.shared_pref.getInt("ptime" + n2, 0)];
            this.appupgrades[n2] = this.shared_pref.getInt("ptime" + n2, 0);
        }
        for (n2 = 0; n2 < 5; ++n2) {
            MainActivity.appitems[n2] = new String[C2MValues.ITEMS_PER_LEVEL[this.level][n2]];
            MainActivity.cookitems[n2] = new String[C2MValues.ITEMS_PER_LEVEL[this.level][n2]];
            MainActivity.cooknames[n2] = new String[C2MValues.ITEMS_PER_LEVEL[this.level][n2]];
            MainActivity.cookprices[n2] = new int[C2MValues.ITEMS_PER_LEVEL[this.level][n2]];
            for (n = 0; n < C2MValues.ITEMS_PER_LEVEL[this.level][n2]; ++n) {
                MainActivity.appitems[n2][n] = "ailment_" + C2MValues.ITEM_NAMES[0][n2][n].replace(' ', '_').replace('/', '_');
                MainActivity.cookitems[n2][n] = "ailment_" + C2MValues.ITEM_NAMES[0][n2][n].replace(' ', '_').replace('/', '_');
                MainActivity.cooknames[n2][n] = C2MValues.ITEM_NAMES[this.getLanguage()][n2][n];
                MainActivity.cookprices[n2][n] = 5;
            }
        }
        if (this.delivery_state[1] == -1 && this.delivery_upgrade >= 5) {
            this.delivery_state[1] = 0;
        }
        for (n2 = 0; n2 < 5; ++n2) {
            this.delivery_hspeed[n2] = 9.737f * (float)C2MValues.DELIVERY_SPEED_PERCENT_BY_LEVEL[this.level] / (float)(C2MValues.AVERAGE_DELIVERY_TIME_BY_UPGRADE[n2] * 100000);
            this.delivery_vspeed[n2] = this.delivery_hspeed[n2] * 0.7f;
        }
    }

    public Image getHeart() {
        return this.heart;
    }

    public int getProcedureTime(int n) {
        return this.proc_time[n];
    }

    public boolean hasSpeedUp(long l) {
        return l >= this.next_speedup && this.level >= 4;
    }

    public boolean hasCalmDown(long l) {
        return l >= this.next_calmdown && this.level >= 4;
    }

    public void speedUp(long l) {
        this.next_speedup = l + 60000L;
        for (int i = 0; i < 6; ++i) {
            if (this.capacity[i] <= 0 || this.patients[i][0] == null || this.patients[i][0].isEmpty()) continue;
            this.patients[i][0].speedUp(true, l);
        }
    }

    public void calmDown(long l) {
        this.next_calmdown = l + 60000L;
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < this.capacity[i]; ++j) {
                if (this.patients[i][j] == null || this.patients[i][j].isEmpty()) continue;
                this.patients[i][j].calmDown();
            }
        }
    }

    public boolean addPatient(boolean bl) {
        float f = 0.9238281f * (1.0f - (this.height / this.width - 1.3333334f) * 9.0f / 4.0f) + 0.94287807f * (this.height / this.width - 1.3333334f) * 9.0f / 4.0f;
        for (int i = 0; i < this.capacity[5]; ++i) {
            if (this.patients[5][i] != Patient.getEmpty(this, f - 0.2233073f * this.width / this.height, this.width, this.height, 5)) continue;
            this.patients[5][i] = Patient.create(this, f - 0.2233073f * this.width / this.height, this.width, this.height, this.heart, bl);
            if (this.getTime() < this.next_speedup - 60000L + 15000L && this.next_speedup != 60000L) {
                this.patients[5][i].speedUp(true, this.next_speedup - 60000L);
            }
            return true;
        }
        return false;
    }

    public boolean movePatient(int n, int n2, int n3, int n4) {
        int n5;
        float f = 0.9238281f * (1.0f - (this.height / this.width - 1.3333334f) * 9.0f / 4.0f) + 0.94287807f * (this.height / this.width - 1.3333334f) * 9.0f / 4.0f;
        Patient patient = this.patients[n3][n4];
        if (this.points < 4 && n3 == 5 && n == 2 && patient.getAilments().length == 1) {
            this.kitchen.checkMessage(110);
            this.getPrefEditor().putBoolean("msg_10", false);
            this.getPrefEditor().commit();
            return false;
        }
        if (n2 == -1) {
            if (n < 5 && this.getStress(n) >= 1.0f) {
                this.kitchen.checkMessage(159);
                this.getPrefEditor().putBoolean("msg_59", false);
                this.getPrefEditor().commit();
                return false;
            }
            for (int i = 0; i < this.capacity[n]; ++i) {
                if (this.patients[n][i] != Patient.getEmpty(this, f - 0.2233073f * this.width / this.height, this.width, this.height, n)) continue;
                this.patients[n3][n4] = Patient.getEmpty(this, f - 0.2233073f * this.width / this.height, this.width, this.height, n3);
                this.patients[n][i] = patient;
                patient.stopProcedure();
                if (i == 0 && n < 5) {
                    patient.startProcedure(n);
                }
                for (int j = n4 + 1; j < this.capacity[n3]; ++j) {
                    this.patients[n3][j - 1] = this.patients[n3][j];
                }
                this.patients[n3][this.capacity[n3] - 1] = Patient.getEmpty(this, f - 0.2233073f * this.width / this.height, this.width, this.height, n3);
                if (n4 == 0 && !this.patients[n3][0].isEmpty() && n3 < 5) {
                    this.patients[n3][0].startProcedure(n3);
                }
                if (this.level == 1) {
                    if (this.points >= 4 && this.patients[5][0].isEmpty()) {
                        this.kitchen.checkMessage(119);
                        return true;
                    }
                    if (n == 0) {
                        this.kitchen.checkMessage(109);
                    } else if (!(n != 0 && n != 2 || patient.getAilments().length != 2 || this.kitchen.checkMessage(113))) {
                        this.kitchen.checkMessage(114);
                    }
                }
                return true;
            }
            this.kitchen.checkMessage(108);
            this.getPrefEditor().putBoolean("msg_8", false);
            this.getPrefEditor().commit();
            return false;
        }
        if (n2 == 0 || n4 == 0) {
            this.patients[n][0].stopProcedure();
        }
        this.patients[n][n4] = Patient.getEmpty(this, f - 0.2233073f * this.width / this.height, this.width, this.height, n);
        if (this.patients[n][n2].isEmpty()) {
            for (n5 = n4 + 1; n5 <= n2; ++n5) {
                if (!this.patients[n][n5].isEmpty()) continue;
                n2 = n5 - 1;
                break;
            }
        }
        if (n2 > n4) {
            for (n5 = n4; n5 < n2; ++n5) {
                this.patients[n][n5] = this.patients[n][n5 + 1];
            }
        } else {
            for (n5 = n4; n5 > n2; --n5) {
                this.patients[n][n5] = this.patients[n][n5 - 1];
            }
        }
        this.patients[n][n2] = patient;
        patient.stopProcedure();
        if (n2 == 0 && n < 5) {
            patient.startProcedure(n);
        } else if (n4 == 0 && n < 5) {
            this.patients[n][n4].startProcedure(n);
        }
        return true;
    }

    public Patient[] getPatients(int n) {
        return this.patients[n];
    }

    public float getStress(int n) {
        float f = 0.0f;
        for (int i = 0; i < this.capacity[n]; ++i) {
            if (this.patients[n][i] == null || this.patients[n][i].isEmpty()) continue;
            f += this.patients[n][i].getStress();
        }
        return f / this.stress_cap[n];
    }

    public int getStressCap(int n) {
        return (int)(this.stress_cap[n] * 100.0f + 0.5f);
    }

    public int getCapacity(int n) {
        return this.capacity[n];
    }

    public int upgradeAvailable(int n, int n2) {
        switch (n2) {
            case 0: {
                if (this.capacity[n] == C2MValues.CAPACITY_UPGRADE_LEVEL[n].length) {
                    return -1;
                }
                if (this.level < C2MValues.CAPACITY_UPGRADE_LEVEL[n][this.capacity[n]]) {
                    return -1;
                }
                if (this.money < C2MValues.CAPACITY_UPGRADE_COST[n][this.capacity[n]]) {
                    return 0;
                }
                return 1;
            }
            case 1: {
                int n3 = this.shared_pref.getInt("ptime" + n, 0);
                if (n3 == C2MValues.PROCEDURE_TIME_UPGRADE_LEVEL[n].length) {
                    return -1;
                }
                if (this.level < C2MValues.PROCEDURE_TIME_UPGRADE_LEVEL[n][n3]) {
                    return -1;
                }
                if (this.money < C2MValues.PROCEDURE_TIME_UPGRADE_COST[n][n3]) {
                    return 0;
                }
                return 1;
            }
            case 2: {
                int n4 = this.shared_pref.getInt("stress" + n, 0);
                if (n4 == C2MValues.STRESS_HANDLING_UPGRADE_LEVEL[n].length) {
                    return -1;
                }
                if (this.level < C2MValues.STRESS_HANDLING_UPGRADE_LEVEL[n][n4]) {
                    return -1;
                }
                if (this.money < C2MValues.STRESS_HANDLING_UPGRADE_COST[n][n4]) {
                    return 0;
                }
                return 1;
            }
        }
        return -1;
    }

    public void upgradeAppliance(int n, int n2) {
        int n3;
        switch (n2) {
            default: {
                n3 = C2MValues.CAPACITY_UPGRADE_COST[n][this.capacity[n]];
                break;
            }
            case 1: {
                n3 = C2MValues.PROCEDURE_TIME_UPGRADE_COST[n][this.shared_pref.getInt("ptime" + n, 0)];
                break;
            }
            case 2: {
                n3 = C2MValues.STRESS_HANDLING_UPGRADE_COST[n][this.shared_pref.getInt("stress" + n, 0)];
            }
        }
        if (this.money >= n3) {
            this.chargeMoney(n3);
            switch (n2) {
                default: {
                    int n4 = n;
                    this.capacity[n4] = this.capacity[n4] + 1;
                    this.pref_editor.putInt("cap" + n, this.capacity[n]);
                    this.pref_editor.commit();
                    this.kitchen.onUpgrade();
                    break;
                }
                case 1: {
                    this.pref_editor.putInt("ptime" + n, this.shared_pref.getInt("ptime" + n, 0) + 1);
                    this.pref_editor.commit();
                    int n5 = n;
                    this.appupgrades[n5] = this.appupgrades[n5] + 1;
                    this.proc_time[n] = C2MValues.PROCEDURE_TIME_BY_UPGRADE[this.shared_pref.getInt("ptime" + n, 0)];
                    this.kitchen.updateAppImage(n);
                    break;
                }
                case 2: {
                    this.pref_editor.putInt("stress" + n, this.shared_pref.getInt("stress" + n, 0) + 1);
                    this.pref_editor.commit();
                    this.stress_cap[n] = 0.01f * (float)C2MValues.STRESS_HANDLING_BY_UPGRADE[this.shared_pref.getInt("stress" + n, 0)];
                }
            }
        }
    }

    public int getDeliverRot(int n) {
        if (this.delivery_x[n] > this.delivery_lastx[n] + 1.0E-6f) {
            return 1;
        }
        if (this.delivery_y[n] > this.delivery_lasty[n] + 1.0E-6f) {
            return 2;
        }
        if (this.delivery_y[n] < this.delivery_lasty[n] - 1.0E-6f) {
            return 0;
        }
        return 3;
    }

    public void upgradeDelivery() {
        int n = C2MValues.DELIVERY_UPGRADES[this.delivery_upgrade * 2 + 1];
        if (this.money > n) {
            this.chargeMoney(n);
            ++this.delivery_upgrade;
            this.pref_editor.putInt("delivery_upgrade", this.delivery_upgrade);
            this.pref_editor.commit();
            this.setAvailableSlots();
        }
    }

    public int getDeliveryUpgrade() {
        return this.delivery_upgrade;
    }

    public int getApplianceUpgrade(int n) {
        return this.appupgrades[n];
    }

    public void registerDimensions(float f, float f2) {
        this.width = f;
        this.height = f2;
    }

    public int getLevel() {
        return this.level;
    }

    public int getMoney() {
        return this.money;
    }

    public int getPoints() {
        return this.points;
    }

    public void addMoney(int n) {
        this.money += n;
        this.pref_editor.putInt("money", this.money);
        this.pref_editor.commit();
    }

    public void chargeMoney(int n) {
        this.money -= n;
        this.pref_editor.putInt("money", this.money);
        this.pref_editor.commit();
    }

    public void addPoints(int n) {
        this.points += n;
        if (this.level < 45) {
            if (this.points >= C2MValues.REPUTATION_TO_REACH_LEVEL[this.level + 1]) {
                ++this.level;
                this.pref_editor.putInt("level", this.level);
                this.setAvailableSlots();
                if (this.state == 3) {
                    this.kitchen.onLevelUp();
                } else if (this.state == 4) {
                    this.map.onLevelUp();
                }
                this.playSound("level_up");
            }
        } else if (this.points >= 5000 && !this.shared_pref.getBoolean("victory_shown", false)) {
            this.pref_editor.putBoolean("victory_shown", true);
            this.pref_editor.commit();
            if (this.state == 3) {
                this.kitchen.onVictory();
            } else if (this.state == 4) {
                this.map.onVictory();
            }
        }
        this.pref_editor.putInt("points", this.points);
        this.pref_editor.commit();
    }

    public void subtractPoints(int n) {
        this.points = Math.max(this.points - n, C2MValues.REPUTATION_TO_REACH_LEVEL[this.level]);
        this.pref_editor.putInt("points", this.points);
        this.pref_editor.commit();
    }

    public void swapDeliveryOrder(int n) {
        AnimatedOrder animatedOrder = this.delivery_items[n][0];
        this.delivery_items[n][0] = this.delivery_items[n][1];
        this.delivery_items[n][1] = animatedOrder;
    }

    public int getDeliveryState(int n) {
        return this.delivery_state[n];
    }

    public AnimatedOrder getDeliveryItem(int n, int n2) {
        return this.delivery_items[n][n2];
    }

    public void addToDelivery(int n, AnimatedOrder animatedOrder, long l) {
        if (this.delivery_items[n][0] == null && this.delivery_state[n] != -1) {
            AnimatedOrder animatedOrder2 = animatedOrder;
            this.delivery_items[n][1] = animatedOrder2;
            this.delivery_items[n][0] = animatedOrder2;
            if (this.delivery_upgrade >= 5) {
                this.delivery_state[n] = 1;
                return;
            }
        } else if (this.delivery_items[n][1] == this.delivery_items[n][0] && this.delivery_upgrade >= 5) {
            this.delivery_items[n][1] = animatedOrder;
        }
        this.delivery_state[n] = 2;
    }

    public int getDeliverers() {
        int n = 0;
        for (int i = 0; i < this.delivery_state.length; ++i) {
            if (this.delivery_state[i] == -1) continue;
            ++n;
        }
        return n;
    }

    public void addOrder(long l) {
        float f = 0.9238281f * (1.0f - (this.height / this.width - 1.3333334f) * 9.0f / 4.0f) + 0.94287807f * (this.height / this.width - 1.3333334f) * 9.0f / 4.0f;
        AnimatedOrder animatedOrder = new AnimatedOrder(this, null, null, (float)this.getOrders().size() * 0.2f + 0.1f, f - 0.2233073f * this.width / this.height, this.width, this.height, l, C2MValues.TIME_FOR_ORDER[this.level] * 1000, this.level);
        this.getOrders().add(animatedOrder);
        this.playSound("new_emergency");
        this.pref_editor.putInt("orders", this.getSharedPref().getInt("orders", 0) + 1);
        this.pref_editor.commit();
        if (this.state == 3) {
            this.kitchen.registerOrder(animatedOrder);
        }
        this.checkMessage(1);
    }

    public void sendOut(int n) {
        if (this.delivery_state[n] == 0) {
            return;
        }
        this.delivery_state[n] = 3;
        if (n == 1) {
            this.playSound("delivery_confirmation_female");
        } else {
            this.playSound("delivery_confirmation_male");
        }
        this.checkMessage(13);
    }

    public float getDeliveryX(int n) {
        return this.delivery_x[n];
    }

    public float getDeliveryY(int n) {
        return this.delivery_y[n];
    }

    public int getDeliverySlots() {
        if (this.delivery_upgrade >= 5) {
            return 2;
        }
        return 1;
    }

    public Path getPath(int n) {
        return this.deliver_paths[n];
    }

    private void setPath(int n, int n2) {
        if (this.state != 4) {
            return;
        }
        this.deliver_paths[n].reset();
        if (n2 == 15) {
            return;
        }
        this.deliver_paths[n].moveTo(25.0f * this.delivery_x[n], 25.0f * this.delivery_y[n]);
        if (n2 < 1) {
            this.deliver_paths[n].lineTo(25.0f * this.delivery_x[n], 100.0f);
        }
        if (this.delivery_x[n] + 0.49999f > (float)this.delivery_items[n][0].getColumn()) {
            if (n2 < 2) {
                this.deliver_paths[n].lineTo(25.0f * ((float)this.delivery_items[n][0].getColumn() + 0.5f), 100.0f);
            }
            if (n2 < 3) {
                this.deliver_paths[n].lineTo(25.0f * ((float)this.delivery_items[n][0].getColumn() + 0.5f), 25 * this.delivery_items[n][0].getRow());
            }
        } else {
            if (n2 < 2) {
                this.deliver_paths[n].lineTo(25.0f * ((float)this.delivery_items[n][0].getColumn() - 0.5f), 100.0f);
            }
            if (n2 < 3) {
                this.deliver_paths[n].lineTo(25.0f * ((float)this.delivery_items[n][0].getColumn() - 0.5f), 25 * this.delivery_items[n][0].getRow());
            }
        }
        if (n2 < 4) {
            this.deliver_paths[n].lineTo(25 * this.delivery_items[n][0].getColumn(), 25 * this.delivery_items[n][0].getRow());
        }
        if (n2 < 5) {
            this.deliver_paths[n].lineTo(25 * this.delivery_items[n][0].getColumn(), 25.0f * ((float)this.delivery_items[n][0].getRow() - 0.15f));
        }
        if (this.delivery_items[n][1] != this.delivery_items[n][0]) {
            if (n2 < 6) {
                this.deliver_paths[n].lineTo(25 * this.delivery_items[n][0].getColumn(), 25 * this.delivery_items[n][0].getRow());
            }
            if ((float)this.delivery_items[n][0].getColumn() + 0.49999f > (float)this.delivery_items[n][1].getColumn()) {
                if (n2 < 7) {
                    this.deliver_paths[n].lineTo(25.0f * ((float)this.delivery_items[n][1].getColumn() + 0.5f), 25 * this.delivery_items[n][0].getRow());
                }
                if (n2 < 8) {
                    this.deliver_paths[n].lineTo(25.0f * ((float)this.delivery_items[n][1].getColumn() + 0.5f), 25 * this.delivery_items[n][1].getRow());
                }
            } else {
                if (n2 < 7) {
                    this.deliver_paths[n].lineTo(25.0f * ((float)this.delivery_items[n][1].getColumn() - 0.5f), 25 * this.delivery_items[n][0].getRow());
                }
                if (n2 < 8) {
                    this.deliver_paths[n].lineTo(25.0f * ((float)this.delivery_items[n][1].getColumn() - 0.5f), 25 * this.delivery_items[n][1].getRow());
                }
            }
            if (n2 < 9) {
                this.deliver_paths[n].lineTo(25 * this.delivery_items[n][1].getColumn(), 25 * this.delivery_items[n][1].getRow());
            }
            if (n2 < 10) {
                this.deliver_paths[n].lineTo(25 * this.delivery_items[n][1].getColumn(), 25.0f * ((float)this.delivery_items[n][1].getRow() - 0.15f));
            }
        }
        if (n2 < 11) {
            this.deliver_paths[n].lineTo(25 * this.delivery_items[n][1].getColumn(), 25 * this.delivery_items[n][1].getRow());
        }
        if ((float)this.delivery_items[n][1].getColumn() + 0.49999f > 2.0f) {
            if (n2 < 12) {
                this.deliver_paths[n].lineTo(62.5f, 25 * this.delivery_items[n][1].getRow());
            }
            if (n2 < 13) {
                this.deliver_paths[n].lineTo(62.5f, 100.0f);
            }
        } else {
            if (n2 < 12) {
                this.deliver_paths[n].lineTo(37.5f, 25 * this.delivery_items[n][1].getRow());
            }
            if (n2 < 13) {
                this.deliver_paths[n].lineTo(37.5f, 100.0f);
            }
        }
        if (n2 < 14) {
            this.deliver_paths[n].lineTo(50.0f, 100.0f);
        }
        if (n2 < 15) {
            this.deliver_paths[n].lineTo(50.0f, 96.25f);
        }
    }

    public boolean checkMessage(int n) {
        if (this.state == 3) {
            return this.kitchen.checkMessage(n);
        }
        if (this.state == 4) {
            return this.map.checkMessage(n);
        }
        return false;
    }

    public void refresh(long l) {
        int n;
        int n2;
        int n3;
        for (n3 = 0; n3 < this.orders.size(); ++n3) {
            if (!((AnimatedOrder)this.orders.get(n3)).checkFailed(l)) continue;
            this.orders.clear();
            if (this.delivery_state[0] <= 2) {
                this.checkMessage(142);
                continue;
            }
            this.checkMessage(143);
        }
        n3 = 0;
        int n4 = 0;
        for (n2 = 0; n2 < this.capacity.length; ++n2) {
            for (n = 0; n < this.capacity[n2]; ++n) {
                if (this.patients[n2][n] != null && !this.patients[n2][n].isEmpty()) {
                    ++n3;
                }
                ++n4;
            }
        }
        if (n4 - (n3 += this.orders.size()) > n3 / 5 && l > this.ltick_time + 4000L) {
            if (((double)((float)(System.currentTimeMillis() % 79L) / 79.0f) < (double)(n4 - n3 - n3 / 5) * (double)C2MValues.PATIENT_GENERATION_PROBABILITY[this.level] / 100.0 / (double)n4 || n3 == 0 || this.level == 3 && this.shared_pref.getInt("orders", 0) == 0) && this.level > 1 && (this.level != 2 || this.getCapacity(0) > 2 || this.getCapacity(2) > 2 || this.getCapacity(1) > 0 && this.money < C2MValues.CAPACITY_UPGRADE_COST[0][2]) && (this.level != 3 || this.orders.size() == 0 && this.delivery_state[0] <= 2)) {
                if ((double)((float)(System.currentTimeMillis() % 57L) / 57.0f) < 0.15 && this.orders.size() == 0 && this.delivery_state[0] <= 2 && this.level >= 3 || this.shared_pref.getInt("orders", 0) == 0 && this.level == 3) {
                    this.addOrder(l);
                } else {
                    this.addPatient(false);
                }
            }
            this.ltick_time = l;
        }
        for (n2 = 0; n2 < 6; ++n2) {
            if (this.patients[n2][0] != null && !this.patients[n2][0].isEmpty() && this.patients[n2][0].getProgress(l) >= 1.0f) {
                if (this.patients[n2][0].cure()) {
                    this.patients[n2][0].recycle();
                    this.patients[n2][0] = Patient.getEmpty(this, 0.9238281f * (1.0f - (this.height / this.width - 1.3333334f) * 9.0f / 4.0f) + 0.94287807f * (this.height / this.width - 1.3333334f) * 9.0f / 4.0f - 0.2233073f * this.width / this.height, this.width, this.height, n2);
                    for (n = 1; n < this.patients[n2].length; ++n) {
                        if (this.patients[n2][n] == null || this.patients[n2][n].isEmpty()) continue;
                        this.movePatient(n2, n - 1, n2, n);
                    }
                    if (this.level == 1) {
                        if (this.state == 3) {
                            if (!this.kitchen.checkMessage(117)) {
                                this.kitchen.checkMessage(118);
                            }
                        } else if (!this.map.checkMessage(117)) {
                            this.map.checkMessage(118);
                        }
                    }
                    if (this.state == 3) {
                        this.kitchen.notifyCured(n2, l, true);
                    }
                } else {
                    this.patients[n2][0].finishProcedure(l);
                    this.patients[n2][0].startProcedure(n2);
                    if (this.level == 1) {
                        if (this.state == 3) {
                            this.kitchen.checkMessage(115);
                        } else {
                            this.map.checkMessage(115);
                        }
                    }
                    if (this.state == 3) {
                        this.kitchen.notifyCured(n2, l, false);
                    }
                }
            }
            for (n = 0; n < this.capacity[n2]; ++n) {
                if (this.patients[n2][n] == null || this.patients[n2][n].isEmpty() || !(this.patients[n2][n].getStress() > 1.0f)) continue;
                this.playSound("patient_failed");
                this.subtractPoints(7);
                this.patients[n2][n].recycle();
                this.patients[n2][n] = Patient.getEmpty(this, 0.9238281f * (1.0f - (this.height / this.width - 1.3333334f) * 9.0f / 4.0f) + 0.94287807f * (this.height / this.width - 1.3333334f) * 9.0f / 4.0f - 0.2233073f * this.width / this.height, this.width, this.height, n2);
                for (int i = 1; i < this.patients[n2].length; ++i) {
                    if (this.patients[n2][i] == null || this.patients[n2][i].isEmpty()) continue;
                    this.movePatient(n2, i - 1, n2, i);
                }
                this.checkMessage(139);
                if (this.state != 3) continue;
                this.kitchen.notifyFailed(n2, l);
            }
            if (n2 >= 5) continue;
            int n5 = n = this.getStress(n2) >= 1.0f ? 1 : 0;
            if (this.patients[n2][0] == null || this.patients[n2][0].isEmpty()) continue;
            this.patients[n2][0].setOverstress(n != 0);
        }
        for (n2 = 0; n2 < this.delivery_state.length; ++n2) {
            this.delivery_lastx[n2] = this.delivery_x[n2];
            this.delivery_lasty[n2] = this.delivery_y[n2];
            if (this.delivery_items[n2][1] == null && this.delivery_items[n2][0] != null) {
                this.delivery_items[n2][1] = this.delivery_items[n2][0];
            }
            block14: for (n = 0; n < 2; ++n) {
                if (this.delivery_items[n2][n] == null || !this.delivery_items[n2][n].checkFailed(l)) continue;
                switch (this.delivery_state[n2]) {
                    case 1: {
                        this.delivery_items[n2][n] = null;
                        this.delivery_state[n2] = 0;
                        continue block14;
                    }
                    case 2: {
                        if (this.delivery_items[n2][0] == this.delivery_items[n2][1]) {
                            this.delivery_items[n2][1] = null;
                            this.delivery_items[n2][0] = null;
                            this.delivery_state[n2] = 0;
                            continue block14;
                        }
                        if (n == 0) {
                            this.delivery_items[n2][0] = this.delivery_items[n2][1];
                        }
                        this.delivery_items[n2][1] = this.delivery_items[n2][0];
                        this.delivery_state[n2] = 1;
                        continue block14;
                    }
                    case 3: {
                        if (this.delivery_items[n2][0] == this.delivery_items[n2][1]) {
                            this.delivery_state[n2] = 5;
                            continue block14;
                        }
                        this.delivery_items[n2][n] = this.delivery_items[n2][1 - n];
                        continue block14;
                    }
                    case 4: {
                        this.delivery_items[n2][1] = this.delivery_items[n2][0];
                        this.delivery_state[n2] = 5;
                    }
                }
            }
            if (this.delivery_state[n2] == 3) {
                if (this.delivery_x[n2] == 2.0f && this.delivery_y[n2] < 4.0f && this.delivery_y[n2] > 3.0f) {
                    this.delivery_y[n2] = this.min(4.0f, this.delivery_y[n2] + this.delivery_vspeed[this.delivery_upgrade] * (float)(l - this.refresh_time));
                    this.setPath(n2, 0);
                    continue;
                }
                if (this.delivery_y[n2] != (float)this.delivery_items[n2][0].getRow() && (this.delivery_y[n2] + 1.000001f) % 1.0f < 1.0E-5f && this.delivery_x[n2] != (float)this.delivery_items[n2][0].getColumn() + 0.5f && this.delivery_x[n2] != (float)this.delivery_items[n2][0].getColumn() - 0.5f) {
                    this.delivery_x[n2] = this.delivery_x[n2] + 0.49999f > (float)this.delivery_items[n2][0].getColumn() ? (this.delivery_x[n2] - 0.5f < (float)this.delivery_items[n2][0].getColumn() ? this.min((float)this.delivery_items[n2][0].getColumn() + 0.5f, this.delivery_x[n2] + this.delivery_hspeed[this.delivery_upgrade] * (float)(l - this.refresh_time)) : this.max((float)this.delivery_items[n2][0].getColumn() + 0.5f, this.delivery_x[n2] - this.delivery_hspeed[this.delivery_upgrade] * (float)(l - this.refresh_time))) : this.min((float)this.delivery_items[n2][0].getColumn() - 0.5f, this.delivery_x[n2] + this.delivery_hspeed[this.delivery_upgrade] * (float)(l - this.refresh_time));
                    this.setPath(n2, 1);
                    continue;
                }
                if (this.delivery_y[n2] != (float)this.delivery_items[n2][0].getRow() && (this.delivery_x[n2] + 0.500001f) % 1.0f < 1.0E-5f) {
                    this.delivery_y[n2] = this.delivery_y[n2] < (float)this.delivery_items[n2][0].getRow() ? this.min(this.delivery_items[n2][0].getRow(), this.delivery_y[n2] + this.delivery_vspeed[this.delivery_upgrade] * (float)(l - this.refresh_time)) : this.max(this.delivery_items[n2][0].getRow(), this.delivery_y[n2] - this.delivery_vspeed[this.delivery_upgrade] * (float)(l - this.refresh_time));
                    this.setPath(n2, 2);
                    continue;
                }
                if ((this.delivery_y[n2] + 1.000001f) % 1.0f < 1.0E-5f && this.delivery_x[n2] != (float)this.delivery_items[n2][0].getColumn()) {
                    this.delivery_x[n2] = this.delivery_x[n2] < (float)this.delivery_items[n2][0].getColumn() ? this.min(this.delivery_items[n2][0].getColumn(), this.delivery_x[n2] + this.delivery_hspeed[this.delivery_upgrade] * (float)(l - this.refresh_time)) : this.max(this.delivery_items[n2][0].getColumn(), this.delivery_x[n2] - this.delivery_hspeed[this.delivery_upgrade] * (float)(l - this.refresh_time));
                    this.setPath(n2, 3);
                    continue;
                }
                if ((this.delivery_y[n2] + 1.000001f + 0.15f) % 1.0f >= 1.0E-5f) {
                    this.delivery_y[n2] = this.max((float)this.delivery_items[n2][0].getRow() - 0.15f, this.delivery_y[n2] - this.delivery_vspeed[this.delivery_upgrade] * (float)(l - this.refresh_time));
                    this.setPath(n2, 4);
                    continue;
                }
                if (this.delivery_items[n2][1] != this.delivery_items[n2][0]) {
                    this.delivery_items[n2][0].deliver();
                    this.getOrders().remove(this.delivery_items[n2][0]);
                    this.delivery_state[n2] = 4;
                    this.setPath(n2, 5);
                    continue;
                }
                this.delivery_items[n2][0].deliver();
                this.getOrders().remove(this.delivery_items[n2][0]);
                this.delivery_state[n2] = 5;
                this.setPath(n2, 10);
                continue;
            }
            if (this.delivery_state[n2] == 4) {
                if (this.delivery_x[n2] == (float)this.delivery_items[n2][0].getColumn() && this.delivery_y[n2] < (float)this.delivery_items[n2][0].getRow() && this.delivery_y[n2] > (float)(this.delivery_items[n2][0].getRow() - 1)) {
                    this.delivery_y[n2] = this.min(this.delivery_items[n2][0].getRow(), this.delivery_y[n2] + this.delivery_vspeed[this.delivery_upgrade] * (float)(l - this.refresh_time));
                    this.setPath(n2, 5);
                    continue;
                }
                if (this.delivery_y[n2] != (float)this.delivery_items[n2][1].getRow() && (this.delivery_y[n2] + 1.000001f) % 1.0f < 1.0E-5f && this.delivery_x[n2] != (float)this.delivery_items[n2][1].getColumn() + 0.5f && this.delivery_x[n2] != (float)this.delivery_items[n2][1].getColumn() - 0.5f) {
                    this.delivery_x[n2] = this.delivery_x[n2] + 0.49999f > (float)this.delivery_items[n2][1].getColumn() ? (this.delivery_x[n2] - 0.5f < (float)this.delivery_items[n2][1].getColumn() ? this.min((float)this.delivery_items[n2][1].getColumn() + 0.5f, this.delivery_x[n2] + this.delivery_hspeed[this.delivery_upgrade] * (float)(l - this.refresh_time)) : this.max((float)this.delivery_items[n2][1].getColumn() + 0.5f, this.delivery_x[n2] - this.delivery_hspeed[this.delivery_upgrade] * (float)(l - this.refresh_time))) : this.min((float)this.delivery_items[n2][1].getColumn() - 0.5f, this.delivery_x[n2] + this.delivery_hspeed[this.delivery_upgrade] * (float)(l - this.refresh_time));
                    this.setPath(n2, 6);
                    continue;
                }
                if (this.delivery_y[n2] != (float)this.delivery_items[n2][1].getRow() && (this.delivery_x[n2] + 0.500001f) % 1.0f < 1.0E-5f) {
                    this.delivery_y[n2] = this.delivery_y[n2] < (float)this.delivery_items[n2][1].getRow() ? this.min(this.delivery_items[n2][1].getRow(), this.delivery_y[n2] + this.delivery_vspeed[this.delivery_upgrade] * (float)(l - this.refresh_time)) : this.max(this.delivery_items[n2][1].getRow(), this.delivery_y[n2] - this.delivery_vspeed[this.delivery_upgrade] * (float)(l - this.refresh_time));
                    this.setPath(n2, 7);
                    continue;
                }
                if ((this.delivery_y[n2] + 1.000001f) % 1.0f < 1.0E-5f && this.delivery_x[n2] != (float)this.delivery_items[n2][1].getColumn()) {
                    this.delivery_x[n2] = this.delivery_x[n2] < (float)this.delivery_items[n2][1].getColumn() ? this.min(this.delivery_items[n2][1].getColumn(), this.delivery_x[n2] + this.delivery_hspeed[this.delivery_upgrade] * (float)(l - this.refresh_time)) : this.max(this.delivery_items[n2][1].getColumn(), this.delivery_x[n2] - this.delivery_hspeed[this.delivery_upgrade] * (float)(l - this.refresh_time));
                    this.setPath(n2, 8);
                    continue;
                }
                if ((this.delivery_y[n2] + 1.000001f + 0.15f) % 1.0f >= 1.0E-5f) {
                    this.delivery_y[n2] = this.max((float)this.delivery_items[n2][1].getRow() - 0.15f, this.delivery_y[n2] - this.delivery_vspeed[this.delivery_upgrade] * (float)(l - this.refresh_time));
                    this.setPath(n2, 9);
                    continue;
                }
                this.delivery_items[n2][1].deliver();
                this.getOrders().remove(this.delivery_items[n2][0]);
                this.delivery_state[n2] = 5;
                this.setPath(n2, 10);
                continue;
            }
            if (this.delivery_state[n2] == 5) {
                if (this.delivery_x[n2] == (float)this.delivery_items[n2][1].getColumn() && this.delivery_y[n2] < (float)this.delivery_items[n2][1].getRow() && this.delivery_y[n2] > (float)(this.delivery_items[n2][1].getRow() - 1)) {
                    this.delivery_y[n2] = this.min(this.delivery_items[n2][1].getRow(), this.delivery_y[n2] + this.delivery_vspeed[this.delivery_upgrade] * (float)(l - this.refresh_time));
                    this.setPath(n2, 10);
                    continue;
                }
                if (this.delivery_y[n2] != 4.0f && (this.delivery_y[n2] + 1.000001f) % 1.0f < 1.0E-5f && this.delivery_x[n2] != 2.5f && this.delivery_x[n2] != 1.5f) {
                    this.delivery_x[n2] = this.delivery_x[n2] + 0.49999f > 2.0f ? (this.delivery_x[n2] - 0.5f < 2.0f ? this.min(2.5f, this.delivery_x[n2] + this.delivery_hspeed[this.delivery_upgrade] * (float)(l - this.refresh_time)) : this.max(2.5f, this.delivery_x[n2] - this.delivery_hspeed[this.delivery_upgrade] * (float)(l - this.refresh_time))) : this.min(1.5f, this.delivery_x[n2] + this.delivery_hspeed[this.delivery_upgrade] * (float)(l - this.refresh_time));
                    this.setPath(n2, 11);
                    continue;
                }
                if (this.delivery_y[n2] != 4.0f && (this.delivery_x[n2] + 0.500001f) % 1.0f < 1.0E-5f) {
                    this.delivery_y[n2] = this.delivery_y[n2] < 4.0f ? this.min(4.0f, this.delivery_y[n2] + this.delivery_vspeed[this.delivery_upgrade] * (float)(l - this.refresh_time)) : this.max(4.0f, this.delivery_y[n2] - this.delivery_vspeed[this.delivery_upgrade] * (float)(l - this.refresh_time));
                    this.setPath(n2, 12);
                    continue;
                }
                if ((this.delivery_y[n2] + 1.000001f) % 1.0f < 1.0E-5f && this.delivery_x[n2] != 2.0f) {
                    this.delivery_x[n2] = this.delivery_x[n2] < 2.0f ? this.min(2.0f, this.delivery_x[n2] + this.delivery_hspeed[this.delivery_upgrade] * (float)(l - this.refresh_time)) : this.max(2.0f, this.delivery_x[n2] - this.delivery_hspeed[this.delivery_upgrade] * (float)(l - this.refresh_time));
                    this.setPath(n2, 13);
                    continue;
                }
                if ((this.delivery_y[n2] + 1.000001f + 0.15f) % 1.0f >= 1.0E-5f) {
                    this.delivery_y[n2] = this.max(3.85f, this.delivery_y[n2] - this.delivery_vspeed[this.delivery_upgrade] * (float)(l - this.refresh_time));
                    this.setPath(n2, 14);
                    continue;
                }
                this.addPatient(true);
                this.checkMessage(141);
                this.delivery_state[n2] = 0;
                this.delivery_items[n2][0] = null;
                this.delivery_items[n2][1] = null;
                this.setPath(n2, 15);
                continue;
            }
            if (this.delivery_state[n2] == -1) continue;
            this.setPath(n2, 15);
        }
        this.refresh_time = l;
    }

    private float min(float f, float f2) {
        if (f > f2) {
            return f2;
        }
        return f;
    }

    private float max(float f, float f2) {
        if (f < f2) {
            return f2;
        }
        return f;
    }

    public KitchenView getKitchen() {
        return this.kitchen;
    }

    public MapView getMap() {
        return this.map;
    }

    public MenuView getMenu() {
        return this.menu;
    }

    public BMPFont getBrady() {
        return this.brady;
    }

    public BMPFont getCartoon() {
        return this.cartoon;
    }

    public BMPFont getKomika() {
        return this.brady;
    }

    public SharedPreferences.Editor getPrefEditor() {
        return this.pref_editor;
    }

    public SharedPreferences getSharedPref() {
        return this.shared_pref;
    }

    public int getAppSlots(int n) {
        return this.getCapacity(n);
    }

    public int getAppUpgrade(int n) {
        return this.appupgrades[n];
    }

    public void togglePause() {
        if (this.paused) {
            this.resume();
        } else {
            this.pause();
        }
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void pause() {
        if (this.paused) {
            return;
        }
        this.pause_time = System.currentTimeMillis();
        this.pref_editor.putLong("elapsed", this.pause_time - this.start_time);
        this.pref_editor.commit();
        this.paused = true;
    }

    public void resume() {
        if (!this.paused) {
            return;
        }
        this.start_time += System.currentTimeMillis() - this.pause_time;
        this.paused = false;
    }

    public MenuMusic getMusic() {
        return this.music;
    }

    public List getOrders() {
        return this.orders;
    }

    public long getTime() {
        if (this.paused) {
            return this.pause_time - this.start_time;
        }
        long l = System.currentTimeMillis() - this.start_time;
        if (l - this.last_time > 500L) {
            this.start_time += l - this.last_time - 500L;
            this.last_time += 500L;
            return this.last_time;
        }
        this.last_time = l;
        return l;
    }

    public void onBackPressed() {
        switch (this.state) {
            case 5: {
                return;
            }
            case 2: {
                if (this.menu == null) {
                    this.music.kill();
                    System.gc();
                    this.state = 5;
                    break;
                }
                if (this.menu.onBack()) break;
                this.menu.destroy();
                this.menu = null;
                this.music.kill();
                System.gc();
                this.state = 5;
                break;
            }
            case 3: {
                if (this.kitchen.goBack()) break;
                this.openMainMenu();
                this.pause();
                break;
            }
            case 4: {
                if (this.map.goBack()) break;
                this.openMainMenu();
                this.pause();
                break;
            }
        }
    }

    public void openMap() {
        if (this.level < 3) {
            return;
        }
        switch (this.state) {
            case 3: {
                if (this.kitchen == null) break;
                this.kitchen.destroy();
                this.kitchen = null;
            }
        }
        this.map = new MapView(this);
        this.state = 4;
    }

    public void openKitchen() {
        switch (this.state) {
            case 2: {
                if (this.menu != null) {
                    this.menu.destroy();
                    this.menu = null;
                }
                this.resume();
                this.music.playMusic("mainloop");
                try {
                    this.topbar = Image.createImage((String)"/topbar.png");
                    this.pausebutton = Image.createImage((String)"/button_pause.png");
                    this.mapbutton = Image.createImage((String)"/button_mapview.png");
                    this.kitchenbutton = Image.createImage((String)"/button_restview.png");
                }
                catch (Exception exception) {}
                break;
            }
            case 4: {
                if (this.map == null) break;
                this.map.destroy();
                this.map = null;
            }
        }
        this.kitchen = new KitchenView(this);
        this.state = 3;
    }

    public void openMainMenu() {
        switch (this.state) {
            case 3: {
                if (this.kitchen != null) {
                    this.kitchen.destroy();
                    this.kitchen = null;
                }
                this.pause();
                this.music.playMusic("pizza_openingscreen_music_j2me");
                break;
            }
            case 4: {
                if (this.map != null) {
                    this.map.destroy();
                    this.map = null;
                }
                this.pause();
                this.music.playMusic("pizza_openingscreen_music_j2me");
            }
        }
        if (this.state == 3 || this.state == 4) {
            this.topbar = null;
            this.pausebutton = null;
            this.mapbutton = null;
            this.kitchenbutton = null;
            System.gc();
        }
        this.menu = new MenuView(this, this.state == 1);
        this.state = 2;
    }

    public void playSound(String string) {
        this.music.playEffect(string);
    }

    protected void destroyApp(boolean bl) throws MIDletStateChangeException {
        switch (this.state) {
            case 4: {
                this.map.destroy();
                break;
            }
            case 3: {
                this.kitchen.destroy();
                break;
            }
            case 2: {
                this.menu.destroy();
            }
        }
        if (this.music != null) {
            this.music.kill();
        }
        System.gc();
        this.state = 5;
    }

    protected void showNotify() {
        try {
            this.startApp();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void hideNotify() {
        this.pauseApp();
    }

    protected void pauseApp() {
        this.isminimized = true;
        this.pause();
        if (this.music != null) {
            this.music.kill();
            this.music = null;
        }
        this.setLock(true);
    }

    public class State {
        public static final int OPENING = 1;
        public static final int MENU = 2;
        public static final int KITCHEN = 3;
        public static final int MAP = 4;
        public static final int EXITING = 5;
        public static final int SPLASH_1 = 6;
        public static final int SPLASH_2 = 7;
        public static final int SOUND = 8;
        public static final int LANGUAGE = 9;
    }
}

