/*
 * Decompiled with CFR 0.152.
 */
package com.rocktasticgames.vetclinic.utils;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GraphicsContainer {
    private Graphics g;
    private int w;
    private int h;
    private float vscale;
    private float hscale;
    private int hoff;

    public GraphicsContainer(int n, int n2) {
        this.setSize(n, n2);
    }

    public void setSize(int n, int n2) {
        this.w = n;
        this.h = n2;
        if (this.h > this.w * 4 / 3) {
            this.vscale = 1.0f;
            this.hscale = 1.0f;
            this.hoff = 0;
        } else if (this.h > this.w) {
            this.vscale = (float)this.h / (float)this.w / 1.3333334f + 1.0E-8f;
            this.hscale = 1.0f;
            this.hoff = 0;
        } else {
            this.vscale = 0.7500001f;
            this.hscale = (float)this.h / (float)this.w;
            this.hoff = (this.w - this.h) / 2;
        }
    }

    public void setGraphics(Graphics graphics) {
        this.g = graphics;
    }

    public void translate(int n, int n2) {
        if (n2 > 0) {
            this.g.translate(n, (int)((float)n2 * this.vscale));
        } else {
            this.g.translate(n, (int)((float)n2 * this.vscale));
        }
    }

    public int getTranslateX() {
        return this.g.getTranslateX();
    }

    public int getTranslateY() {
        return (int)((float)this.g.getTranslateY() / this.vscale);
    }

    public void drawImage(Image image, int n, int n2, int n3) {
        if (n2 > 0) {
            this.g.drawImage(image, n + this.hoff, (int)((float)n2 * this.vscale), n3);
        } else {
            this.g.drawImage(image, n + this.hoff, (int)((float)n2 * this.vscale + 0.999f), n3);
        }
    }

    public void setColor(int n) {
        this.g.setColor(n);
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        if (n2 > 0) {
            this.g.fillRect(n + this.hoff, (int)((float)n2 * this.vscale), n3, (int)((float)n4 * this.vscale));
        } else {
            this.g.fillRect(n + this.hoff, (int)((float)n2 * this.vscale + 0.999f), n3, (int)((float)n4 * this.vscale));
        }
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        if (n2 > 0) {
            if (n4 > 0) {
                this.g.drawLine(n + this.hoff, (int)((float)n2 * this.vscale), n3 + this.hoff, (int)((float)n4 * this.vscale));
            } else {
                this.g.drawLine(n + this.hoff, (int)((float)n2 * this.vscale), n3 + this.hoff, (int)((float)n4 * this.vscale + 0.999f));
            }
        } else if (n4 > 0) {
            this.g.drawLine(n + this.hoff, (int)((float)n2 * this.vscale + 0.999f), n3 + this.hoff, (int)((float)n4 * this.vscale));
        } else {
            this.g.drawLine(n + this.hoff, (int)((float)n2 * this.vscale + 0.999f), n3 + this.hoff, (int)((float)n4 * this.vscale + 0.999f));
        }
    }
}

