/*
 * Decompiled with CFR 0.152.
 */
package com.motionstudio;

import com.motionstudio.ANU;
import com.motionstudio.AnuData;
import com.nokia.mid.ui.DirectGraphics;
import com.nokia.mid.ui.DirectUtils;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class AnuSprite
implements ANU {
    private int[] spriteData = new int[10];
    private short[] clipArr;
    private short[] refArr;
    private short[] frameArr;
    private short[] anuArr;
    private short[] infoArr;
    private Image[] imageArr;

    public AnuSprite() {
    }

    public AnuSprite(AnuData anuData) {
        this.clipArr = anuData.clipArr;
        this.refArr = anuData.refArr;
        this.frameArr = anuData.frameArr;
        this.anuArr = anuData.anuArr;
        this.infoArr = anuData.infoArr;
        this.imageArr = anuData.imageArr;
    }

    public void setPosition(int n, int n2) {
        this.setXPosition(n);
        this.setYPosition(n2);
    }

    public void setAnimation(int n) {
        this.setCurrentAnimation(n);
        short s = this.refArr[2 * n];
        short s2 = this.refArr[2 * n + 1];
        this.setTotalFrame(s2 - s + 1);
        this.setEndOfAnimation(false);
        this.setFrame(0);
    }

    public void setFrame(int n) {
        if (n < 0) {
            this.setEndOfAnimation(true);
            return;
        }
        this.setCurrentFrame(n);
        this.setCurrentDelayCtr(0);
        short s = this.refArr[2 * this.spriteData[0]];
        short s2 = this.frameArr[s + n << 1];
        short s3 = this.frameArr[(s + n << 1) + 1];
        this.setFrameOffset(s2, s3);
        short s4 = this.anuArr[this.getFrameStartOffset() + 2];
        this.setFrameDelay(s4);
    }

    public void updateFrame(int n) {
        try {
            this.setCurrentDelayCtr(this.getCurrentDelayCtr() + 1);
            if (this.getCurrentDelayCtr() < this.getFrameDelay()) {
                return;
            }
            int n2 = this.getCurrentFrame();
            if (++n2 >= this.getTotalFrame()) {
                n2 = n;
            }
            this.setFrame(n2);
        }
        catch (Exception exception) {
            System.out.println("ANU: ERROR IN UPDATE" + exception);
        }
    }

    public void addOffset(boolean bl, boolean bl2) {
        if (this.getCurrentDelayCtr() != 0) {
            return;
        }
        int n = bl ? -this.getXInc() : this.getXInc();
        int n2 = bl2 ? -this.getYInc() : this.getYInc();
        this.setXPosition(this.getXPosition() + n);
        this.setYPosition(this.getYPosition() + n2);
    }

    public void drawFrame(Graphics graphics, int n, int n2, boolean bl) {
        DirectGraphics directGraphics = DirectUtils.getDirectGraphics((Graphics)graphics);
        int n3 = this.getFrameStartOffset() + 7;
        boolean bl2 = this.infoArr[1] == 1;
        try {
            while (true) {
                short s;
                if (n3 >= this.getFrameEndOffset()) {
                    return;
                }
                short s2 = this.anuArr[n3++];
                int n4 = this.anuArr[n3++];
                int n5 = s2 * 4;
                int n6 = this.clipArr[n5++];
                short s3 = this.clipArr[n5++];
                short s4 = this.clipArr[n5++];
                short s5 = this.clipArr[n5++];
                n4 = bl ? 1 - n4 : n4;
                int n7 = this.getXPosition() + (bl ? -(this.anuArr[n3++] + s4) : this.anuArr[n3++]);
                int n8 = this.getYPosition() + this.anuArr[n3++];
                n7 -= n;
                n8 -= n2;
                if (bl2) {
                    s = s2;
                    n6 = 0;
                    s3 = 0;
                } else {
                    graphics.setClip(n7, n8, (int)s4, (int)s5);
                    s = 0;
                    if (n4 == 1) {
                        n6 = this.infoArr[0] - n6 - s4;
                    }
                }
                this.drawClip(directGraphics, this.imageArr[s], n7, n8, n6, s3, n4 == 1);
            }
        }
        catch (Exception exception) {
            System.out.println("ANU: ERROR IN RENDERING" + exception);
            return;
        }
    }

    void drawClip(DirectGraphics directGraphics, Image image, int n, int n2, int n3, int n4, boolean bl) {
        if (bl) {
            directGraphics.drawImage(image, n - n3, n2 - n4, 20, 8192);
        } else {
            directGraphics.drawImage(image, n - n3, n2 - n4, 20, 0);
        }
    }

    public void setXPosition(int n) {
        this.spriteData[5] = n;
    }

    public int getXPosition() {
        return this.spriteData[5];
    }

    public void setYPosition(int n) {
        this.spriteData[6] = n;
    }

    public int getYPosition() {
        return this.spriteData[6];
    }

    private void setCurrentDelayCtr(int n) {
        this.spriteData[3] = n;
    }

    private int getCurrentDelayCtr() {
        return this.spriteData[3];
    }

    private void setFrameDelay(int n) {
        this.spriteData[4] = n;
    }

    private int getFrameDelay() {
        return this.spriteData[4];
    }

    private void setCurrentFrame(int n) {
        this.spriteData[1] = n;
    }

    public int getCurrentFrame() {
        return this.spriteData[1];
    }

    private void setTotalFrame(int n) {
        this.spriteData[2] = n;
    }

    public int getTotalFrame() {
        return this.spriteData[2];
    }

    protected void setEndOfAnimation(boolean bl) {
        this.spriteData[9] = bl ? 1 : 0;
    }

    public boolean isEndOfAnimation() {
        return this.spriteData[9] == 1;
    }

    private void setCurrentAnimation(int n) {
        this.spriteData[0] = n;
    }

    public int getCurrentAnimation() {
        return this.spriteData[0];
    }

    private void setFrameOffset(int n, int n2) {
        this.spriteData[7] = n;
        this.spriteData[8] = n2;
    }

    private int getFrameStartOffset() {
        return this.spriteData[7];
    }

    private int getFrameEndOffset() {
        return this.spriteData[8];
    }

    private int getXInc() {
        return this.anuArr[this.spriteData[7] + 0];
    }

    private int getYInc() {
        return this.anuArr[this.spriteData[7] + 1];
    }
}

