/*
 * Decompiled with CFR 0.152.
 */
package Utility;

import MainMenu.Controller;
import Utility.Debug;
import java.io.InputStream;
import javax.microedition.media.Control;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public final class DeviceSound {
    static boolean ENABLE_VOLUME_CONTROL = false;
    static int m_lastPlayedSound = -1;
    private static Player[] sounds;
    private static VolumeControl vc;
    int vol;
    public static Player currentSound;
    static long m_timeStarted;
    static boolean m_playing;
    static int m_playingId;
    static final int SOUND_PLAY_TIME = 1500;

    static {
        currentSound = null;
        m_timeStarted = 0L;
        m_playing = false;
        m_playingId = -1;
    }

    public static void setVolume(int volumeLevel) {
        if (ENABLE_VOLUME_CONTROL) {
            try {
                if (volumeLevel < 0) {
                    volumeLevel = 0;
                }
                if (volumeLevel > 100) {
                    volumeLevel = 100;
                }
                Control[] cs = currentSound.getControls();
                int i = 0;
                while (i < cs.length) {
                    if (cs[i] instanceof VolumeControl) {
                        vc = (VolumeControl)cs[i];
                        vc.setLevel(volumeLevel);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                Debug.debugWrite(1, "exception setting volume to " + volumeLevel + ": " + e);
            }
        }
    }

    protected static void playPreloadedSound(int midiID) {
        if (Controller.m_soundOn) {
            try {
                sounds[midiID].setLoopCount(1);
                sounds[midiID].start();
            }
            catch (Exception e) {
                Debug.debugWrite(1, "exception playing sound " + midiID + ": " + e);
            }
        }
    }

    public synchronized void playSoundLoadDynamically(int midiID, int priority, int loopCount, int volume) {
        if (Controller.m_soundOn) {
            Debug.debugWrite(1, "trying to play sound " + midiID);
            try {
                if (currentSound != null && midiID == m_lastPlayedSound) {
                    currentSound.realize();
                    currentSound.prefetch();
                    currentSound.start();
                } else {
                    if (currentSound != null) {
                        try {
                            currentSound.stop();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            currentSound.deallocate();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            currentSound.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if ((currentSound = Manager.createPlayer((InputStream)this.getClass().getResourceAsStream(Controller.SOUND_FILES_BASIC_MIDI[midiID]), (String)"audio/midi")) != null) {
                        currentSound.realize();
                        currentSound.prefetch();
                        currentSound.setLoopCount(loopCount);
                        currentSound.start();
                        DeviceSound.setVolume(volume);
                    }
                }
                m_lastPlayedSound = midiID;
            }
            catch (Throwable t) {
                Debug.debugWrite(1, "error playing sound " + midiID + ": " + t);
            }
        }
        Controller.lastSystemCurrentTimeMillis = System.currentTimeMillis();
    }

    public static synchronized void stopSound() {
        if (currentSound != null) {
            try {
                currentSound.stop();
            }
            catch (Exception e) {
                Debug.debugWrite(1, "Error stopping sound");
                currentSound = null;
            }
        }
        if (sounds != null) {
            int i = 0;
            while (i < sounds.length) {
                try {
                    if (sounds[i] != null) {
                        sounds[i].stop();
                    }
                }
                catch (Exception e) {
                    Debug.debugWrite(1, "exception stopping sound " + e);
                }
                ++i;
            }
        }
    }

    public static final void unload(int index) {
    }

    public static final void unloadAllSounds() {
    }
}

