/*
 * Decompiled with CFR 0.152.
 */
package Utility;

import GameLogicMidlet.Game;
import MainMenu.Controller;
import Utility.ImageBank;
import java.io.DataInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class FontRender {
    static int ms_fontSpacing = 1;
    static int m_selectedFontId = 0;
    public static byte[][][] m_KerningPairs = null;
    static final int FONT_LINE_HEIGHT = 1;
    public static ImageBank[] m_fonts;
    public static final int FONT_LARGE = 0;
    public static final int MENU_OPTION_FONT_SELECTED = 1;
    public static final int FONT_MEDIUM = 2;
    public static final int FONT_SCORE = 3;
    public static final int FONT_BODY = 4;
    public static final int MENU_OPTION_FONT_UNSELECTED = 5;
    public static final int MENU_CONTANT_FONT = 6;
    static final String[] FONT_IMAGE_FILENAMES;
    static final String[] FONT_DATA_FILENAMES;
    public static final String[] FONT_KERNING_FILENAMES;
    public static final boolean[] FONT_KERN;
    public static final int[] FONT_WIDTH_OF_SPACE;
    public static final String[] ALPHABET_FILES;
    public String[] m_FontAphabets = new String[ALPHABET_FILES.length];
    static final int[] FONT_EXTRA_SPACE_BETWEEN_CHARACTERS;
    public static final String[] ALPHABET_8BIT;
    int m_fontSpaceBetweenEachLetter = 0;
    public ImageBank m_selectedFont;
    int m_widthOfSpaceCharacter = 0;
    static final String NEW_LINE = "\n";
    public static int ms_fontHeight;
    String ms_fontAlphabet = null;
    static final int JUSTIFY_LEFT = 0;
    static final int JUSTIFY_PARAGRAPH = 1;
    public static final int JUSTIFY_CENTER = 2;
    static final int JUSTIFY_RIGHT = 3;

    static {
        FONT_IMAGE_FILENAMES = new String[]{"/Menu/large.png", "/Menu/largeselected.png", "/Menu/medium.png", "/Menu/score.png", "/Menu/score.png", "/Menu/large.png", "/Menu/contant_font.png"};
        FONT_DATA_FILENAMES = new String[]{"/Menu/large.dat", "/Menu/largeselected.dat", "/Menu/medium.dat", "/Menu/score.dat", "/Menu/score.dat", "/Menu/large.dat", "/Menu/largeselected.dat"};
        FONT_KERNING_FILENAMES = new String[]{"/Menu/large.ker", "/Menu/largeselected.ker", "/Menu/medium.ker", "/Menu/score.ker", "/Menu/score.ker", "/Menu/large.ker", "/Menu/largeselected.ker"};
        FONT_KERN = new boolean[]{true, true, true, true, true, true, true};
        FONT_WIDTH_OF_SPACE = new int[]{5, 5, 5, 5, 5, 5, 5};
        ALPHABET_FILES = new String[]{"alphabet.txt", "alphabet.txt", "alphabet.txt", "alphabet_score.txt", "alphabet.txt", "alphabet.txt", "alphabet.txt"};
        FONT_EXTRA_SPACE_BETWEEN_CHARACTERS = new int[7];
        ALPHABET_8BIT = new String[]{"0123456789',()/?.:!+-#%$@\u00a9\u00baABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz\u00a3_|<>\"\\\u00e7\u00bf\u00fc\u00e1\u00ec\u00ed\u00e9\u00e4\u00c0\u00dc\u00e0\u00f3\u00fa\u00f6;\u00f9\u00f1\u00e8\u00f4\u00ea\u2019\u00a1\u00c7\u00df\u00d6\u00ef\u00c4\u2013\u0153&", "0123456789',()/?.:!+-#%$@\u00a9\u00baABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz\u00a3_|<>\"\\\u00e7\u00bf\u00fc\u00e1\u00ec\u00ed\u00e9\u00e4\u00c0\u00dc\u00e0\u00f3\u00fa\u00f6;\u00f9\u00f1\u00e8\u00f4\u00ea\u2019\u00a1\u00c7\u00df\u00d6\u00ef\u00c4\u2013\u0153&", "0123456789',()/?.:!+-#%$@\u00a9\u00baABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz\u00a3_|<>\"\\\u00e7\u00bf\u00fc\u00e1\u00ec\u00ed\u00e9\u00e4\u00c0\u00dc\u00e0\u00f3\u00fa\u00f6;\u00f9\u00f1\u00e8\u00f4\u00ea\u2019\u00a1\u00c7\u00df\u00d6\u00ef\u00c4\u2013\u0153&", "0123456789$", "0123456789',()/?.:!+-#%$@\u00a9\u00baABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz\u00a3_|<>\"\\\u00e7\u00bf\u00fc\u00e1\u00ec\u00ed\u00e9\u00e4\u00c0\u00dc\u00e0\u00f3\u00fa\u00f6;\u00f9\u00f1\u00e8\u00f4\u00ea\u2019\u00a1\u00c7\u00df\u00d6\u00ef\u00c4\u2013\u0153&", "0123456789',()/?.:!+-#%$@\u00a9\u00baABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz\u00a3_|<>\"\\\u00e7\u00bf\u00fc\u00e1\u00ec\u00ed\u00e9\u00e4\u00c0\u00dc\u00e0\u00f3\u00fa\u00f6;\u00f9\u00f1\u00e8\u00f4\u00ea\u2019\u00a1\u00c7\u00df\u00d6\u00ef\u00c4\u2013\u0153&", "0123456789',()/?.:!+-#%$@\u00a9\u00baABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz\u00a3_|<>\"\\\u00e7\u00bf\u00fc\u00e1\u00ec\u00ed\u00e9\u00e4\u00c0\u00dc\u00e0\u00f3\u00fa\u00f6;\u00f9\u00f1\u00e8\u00f4\u00ea\u2019\u00a1\u00c7\u00df\u00d6\u00ef\u00c4\u2013\u0153&"};
        ms_fontHeight = 0;
    }

    public int drawCenteredString(Graphics g, String text, int y, int screenWidth) {
        int textWidth = this.getStringLength(text);
        int x = (screenWidth - textWidth) / 2 + 72;
        return this.drawString(g, text, x, y);
    }

    /*
     * Unable to fully structure code
     */
    public int drawWrappedString(Graphics g, String text, int startX, int startY, int endX, int endY, int justify) {
        width = endX - startX;
        words = this.stringToWords(text, ' ');
        startPos = 0;
        endPos = 0;
        paintX = startX;
        paintY = startY;
        try {
            finished = false;
            while (!finished) {
                block15: {
                    block16: {
                        block14: {
                            endPos = this.getLineOfText(words, width, startPos);
                            if (startPos == endPos || paintY + FontRender.ms_fontHeight > endY) {
                                finished = true;
                                continue;
                            }
                            if (g != null) {
                                if (justify == 0) {
                                    this.drawLineOfText(g, words, startPos, endPos, paintX, paintY);
                                } else if (justify == 2) {
                                    this.drawLineOfTextCenter(g, words, startPos, endPos, paintX, paintY, width);
                                } else if (justify == 1) {
                                    this.drawLineOfTextParagraph(g, words, startPos, endPos, paintX, paintY, width);
                                } else if (justify == 3) {
                                    this.drawLineOfTextRight(g, words, startPos, endPos, endX, paintY, width);
                                }
                            }
                            if (Controller.m_currentMenuPage != 21 && Controller.m_currentMenuPage != 19 && Controller.m_currentMenuPage != 8 && Controller.m_currentMenuPage != 9 && Controller.m_currentMenuPage != 10) break block14;
                            paintY += FontRender.ms_fontHeight;
                            break block15;
                        }
                        if (!Controller.showShopinfo1) break block16;
                        paintY += FontRender.ms_fontHeight + 2;
                        break block15;
                    }
                    if (Controller.m_state != 0) ** GOTO lbl-1000
                    if (Game.m_gameState != 0) ** GOTO lbl-1000
                    if (!Game.m_paused) {
                        paintY += FontRender.ms_fontHeight;
                    } else lbl-1000:
                    // 3 sources

                    {
                        paintY += FontRender.ms_fontHeight + 10;
                    }
                }
                startPos = endPos;
            }
        }
        catch (Exception e) {
            Game.SOP("exception in drawWrappedString: " + e);
        }
        return paintY;
    }

    int getLineOfText(Vector words, int width, int startPos) {
        int endPos = startPos;
        int endX = 0;
        int i = startPos;
        while (i < words.size()) {
            String word = (String)words.elementAt(i);
            if (word.equals(NEW_LINE)) {
                return ++endPos;
            }
            int wordWidth = this.getStringLength(word);
            int newWidth = endX + wordWidth + this.m_widthOfSpaceCharacter;
            if (newWidth > width) {
                if (endPos == startPos) {
                    ++endPos;
                }
                return endPos;
            }
            endX = newWidth;
            ++endPos;
            ++i;
        }
        return endPos;
    }

    Vector stringToWords(String text, char separator) {
        Vector<String> words = new Vector<String>();
        int numChars = text.length();
        int pos = 0;
        String word = "";
        while (pos < numChars) {
            char c = text.charAt(pos);
            if (pos < numChars - 1 && text.substring(pos, pos + 1).equals(NEW_LINE)) {
                words.addElement(word);
                words.addElement(NEW_LINE);
                word = "";
            } else if (c != separator) {
                word = String.valueOf(word) + c;
            } else if (!word.equals("")) {
                words.addElement(word);
                word = "";
            }
            ++pos;
        }
        if (pos >= numChars) {
            words.addElement(word);
        }
        return words;
    }

    void drawLineOfText(Graphics g, Vector words, int startPos, int endPos, int paintX, int paintY) {
        int i = startPos;
        while (i < endPos) {
            String word = (String)words.elementAt(i);
            if (!word.equals(NEW_LINE)) {
                paintX = this.drawWord(g, word, paintX, paintY);
                if (i < endPos - 1) {
                    paintX += this.m_widthOfSpaceCharacter;
                }
            }
            ++i;
        }
    }

    void drawLineOfTextCenter(Graphics g, Vector words, int startPos, int endPos, int paintX, int paintY, int width) {
        int textWidth = 0;
        int i = startPos;
        while (i < endPos) {
            String word = (String)words.elementAt(i);
            if (!word.equals(NEW_LINE)) {
                String nextWord;
                textWidth += this.getStringLength(word);
                if (i < endPos - 1 && endPos - startPos > 1 && !(nextWord = (String)words.elementAt(i + 1)).equals(NEW_LINE)) {
                    textWidth += this.m_widthOfSpaceCharacter;
                }
            }
            ++i;
        }
        int drawX = paintX + (width - textWidth) / 2;
        int i2 = startPos;
        while (i2 < endPos) {
            String word = (String)words.elementAt(i2);
            if (!word.equals(NEW_LINE)) {
                drawX = this.drawWord(g, word, drawX, paintY);
                if (i2 < endPos - 1 && endPos - startPos > 1) {
                    drawX += this.m_widthOfSpaceCharacter;
                }
            }
            ++i2;
        }
    }

    void drawLineOfTextRight(Graphics g, Vector words, int startPos, int endPos, int endX, int paintY, int width) {
        int textWidth = 0;
        int i = startPos;
        while (i < endPos) {
            String word = (String)words.elementAt(i);
            if (!word.equals(NEW_LINE)) {
                String nextWord;
                textWidth += this.getStringLength(word);
                if (i < endPos - 1 && endPos - startPos > 1 && !(nextWord = (String)words.elementAt(i + 1)).equals(NEW_LINE)) {
                    textWidth += this.m_widthOfSpaceCharacter;
                }
            }
            ++i;
        }
        int drawX = endX - textWidth;
        int i2 = startPos;
        while (i2 < endPos) {
            String word = (String)words.elementAt(i2);
            if (!word.equals(NEW_LINE)) {
                drawX = this.drawWord(g, word, drawX, paintY);
                if (i2 < endPos - 1 && endPos - startPos > 1) {
                    drawX += this.m_widthOfSpaceCharacter;
                }
            }
            ++i2;
        }
    }

    void drawLineOfTextParagraph(Graphics g, Vector words, int startPos, int endPos, int paintX, int paintY, int width) {
        int textWidth = 0;
        int numWords = endPos - startPos;
        int i = startPos;
        while (i < endPos) {
            String word = (String)words.elementAt(i);
            textWidth += this.getStringLength(word);
            if (i < endPos - 1) {
                textWidth += this.m_widthOfSpaceCharacter;
            }
            ++i;
        }
        int FLOAT = 100;
        int widthDiff = width - textWidth;
        int extraSpacePerWord = 0;
        if (widthDiff > 0 && numWords > 1) {
            extraSpacePerWord = widthDiff * 100 / (numWords - 1);
        }
        int drawX = paintX * 100;
        int i2 = startPos;
        while (i2 < endPos) {
            String word = (String)words.elementAt(i2);
            if (i2 == endPos - 1 && numWords > 1) {
                Game.SOP("right justified last word which is: " + word);
                int wordWidth = this.getStringLength(word);
                drawX = paintX + width - wordWidth;
                this.drawWord(g, word, drawX, paintY);
            } else {
                drawX = this.drawWord(g, word, drawX / 100, paintY) * 100;
            }
            if (i2 < endPos - 1) {
                drawX += this.m_widthOfSpaceCharacter * 100 + extraSpacePerWord;
            }
            ++i2;
        }
    }

    public int drawWord(Graphics g, String word, int x, int y) {
        int xPos = x;
        int i = 0;
        while (i < word.length()) {
            if (FONT_KERN[m_selectedFontId] && i > 0) {
                int c1Ind = this.ms_fontAlphabet.indexOf(word.charAt(i - 1));
                int c2Ind = this.ms_fontAlphabet.indexOf(word.charAt(i));
                if (c1Ind >= 0 && c2Ind >= 0) {
                    xPos += m_KerningPairs[m_selectedFontId][c1Ind][c2Ind];
                }
            }
            int charWidth = this.drawChar(g, word.charAt(i), xPos, y);
            xPos += charWidth;
            ++i;
        }
        return xPos;
    }

    int drawChar(Graphics g, char c, int x, int y) {
        int charWidth = 0;
        try {
            if (c != '\n') {
                if (c == ' ') {
                    return this.m_widthOfSpaceCharacter;
                }
                int index = this.ms_fontAlphabet.indexOf(c);
                if (index != -1) {
                    charWidth = this.m_selectedFont.getFrameWidth(index) + this.m_fontSpaceBetweenEachLetter;
                    if (g != null) {
                        this.m_selectedFont.paint(g, index, x, y, false);
                    }
                }
            }
        }
        catch (Exception e) {
            Game.SOP("exception in  drawChar2 for char '" + c + "' :" + e);
        }
        return charWidth;
    }

    public int getStringLength(String s) {
        int xc = 0;
        int n = 0;
        while (n < s.length()) {
            char c = s.charAt(n);
            if (FONT_KERN[m_selectedFontId] && n > 0) {
                int c1Ind = this.ms_fontAlphabet.indexOf(s.charAt(n - 1));
                int c2Ind = this.ms_fontAlphabet.indexOf(s.charAt(n));
                if (c1Ind >= 0 && c2Ind >= 0) {
                    xc += m_KerningPairs[m_selectedFontId][c1Ind][c2Ind];
                }
            }
            xc += this.drawChar(null, c, 0, 0);
            ++n;
        }
        return xc;
    }

    public void setFont(int fontID) {
        int a = 0;
        try {
            a = 1;
            this.ms_fontAlphabet = this.m_FontAphabets[fontID];
            a = 2;
            this.m_selectedFont = this.getFont(fontID);
            a = 3;
            ms_fontHeight = this.m_selectedFont.getImageHeight(0);
            a = 4;
            this.m_widthOfSpaceCharacter = FONT_WIDTH_OF_SPACE[fontID];
            this.m_fontSpaceBetweenEachLetter = FONT_EXTRA_SPACE_BETWEEN_CHARACTERS[fontID];
            m_selectedFontId = fontID;
        }
        catch (Exception e) {
            Game.SOP("exception " + a + " in setfont " + fontID + " : " + e);
        }
    }

    public ImageBank getFont(int id) {
        return m_fonts[id];
    }

    public void loadFonts(int screenWidth, int screenHeight) {
        Game.SOP("loading fonts");
        m_fonts = new ImageBank[FONT_IMAGE_FILENAMES.length];
        m_KerningPairs = new byte[FONT_IMAGE_FILENAMES.length][][];
        int i = 0;
        while (i < m_fonts.length) {
            try {
                this.loadFont(i, screenWidth, screenHeight);
            }
            catch (Exception e) {
                Game.SOP("exception loading font " + i);
                Game.SOP("filename: " + FONT_IMAGE_FILENAMES[i]);
            }
            ++i;
        }
    }

    void loadFont(int fontId, int screenWidth, int screenHeight) {
        block6: {
            try {
                if (m_fonts == null || m_fonts[fontId] != null) break block6;
                this.m_FontAphabets[fontId] = ALPHABET_8BIT[fontId];
                String fontImageFilename = FONT_IMAGE_FILENAMES[fontId];
                String fontDataFilename = FONT_DATA_FILENAMES[fontId];
                Image fontImage = FontRender.loadImage(fontImageFilename);
                DataInputStream fontInputStream = FontRender.getFileAsStream(fontDataFilename);
                ImageBank fontImageBank = new ImageBank();
                fontImageBank.setImage(0, fontImage);
                fontImageBank.loadImageData(fontInputStream);
                FontRender.m_fonts[fontId] = fontImageBank;
                if (!FONT_KERN[fontId]) break block6;
                DataInputStream kerningStream = FontRender.getFileAsStream(FONT_KERNING_FILENAMES[fontId]);
                try {
                    int pairslength = kerningStream.readInt();
                    FontRender.m_KerningPairs[fontId] = new byte[pairslength][pairslength];
                    int j = 0;
                    while (j < pairslength) {
                        int k = 0;
                        while (k < pairslength) {
                            FontRender.m_KerningPairs[fontId][j][k] = kerningStream.readByte();
                            ++k;
                        }
                        ++j;
                    }
                }
                catch (Throwable t) {
                    Game.SOP("failed to load kerning pairs for " + FONT_KERNING_FILENAMES[fontId] + " " + t);
                }
            }
            catch (Exception e) {
                Game.SOP("exception in  loadFont(" + fontId + ", " + screenWidth + ", " + screenHeight);
            }
        }
    }

    public static DataInputStream getFileAsStream(String _filename) {
        return new DataInputStream(_filename.getClass().getResourceAsStream(_filename));
    }

    public static final Image loadImage(String filename) {
        Image image = null;
        try {
            image = Image.createImage((String)filename);
        }
        catch (Throwable t) {
            Game.SOP("exception loading image " + filename + " :" + t);
        }
        return image;
    }

    public int drawString(Graphics g, String s, int x, int y) {
        int xc = x;
        int n = 0;
        while (n < s.length()) {
            char c = s.charAt(n);
            if (FONT_KERN[m_selectedFontId] && n > 0) {
                int c1Ind = this.ms_fontAlphabet.indexOf(s.charAt(n - 1));
                int c2Ind = this.ms_fontAlphabet.indexOf(c);
                if (c1Ind >= 0 && c2Ind >= 0) {
                    xc += m_KerningPairs[m_selectedFontId][c1Ind][c2Ind];
                }
            }
            xc += this.drawChar(g, c, xc, y);
            ++n;
        }
        return xc - x;
    }

    protected int drawStringRightAligned(Graphics g, String s, int startX, int xEnd, int y) {
        int width = this.drawString(null, s, 0, 0);
        int x = xEnd - width;
        if (x > startX) {
            x = startX;
        }
        int xc = x;
        int n = 0;
        while (n < s.length()) {
            char c = s.charAt(n);
            if (FONT_KERN[m_selectedFontId] && n > 0) {
                int c1Ind = this.ms_fontAlphabet.indexOf(s.charAt(n - 1));
                int c2Ind = this.ms_fontAlphabet.indexOf(c);
                if (c1Ind >= 0 && c2Ind >= 0) {
                    xc += m_KerningPairs[m_selectedFontId][c1Ind][c2Ind];
                }
            }
            xc = xc >= startX ? (xc += this.drawChar(g, c, xc, y)) : (xc += this.drawChar(null, c, xc, y));
            ++n;
        }
        return xc - x;
    }

    protected int drawStringLeftAligned(Graphics g, String s, int startX, int xEnd, int y) {
        int xc = startX;
        int n = 0;
        while (n < s.length()) {
            int charWidth;
            char c = s.charAt(n);
            if (FONT_KERN[m_selectedFontId] && n > 0) {
                int c1Ind = this.ms_fontAlphabet.indexOf(s.charAt(n - 1));
                int c2Ind = this.ms_fontAlphabet.indexOf(c);
                if (c1Ind >= 0 && c2Ind >= 0) {
                    xc += m_KerningPairs[m_selectedFontId][c1Ind][c2Ind];
                }
            }
            if (xc + (charWidth = this.drawChar(null, c, 0, 0)) >= xEnd) break;
            xc += this.drawChar(g, c, xc, y);
            ++n;
        }
        return xc - startX;
    }

    protected int drawStringWidth(Graphics g, String s, int x, int y, int endX) {
        int xc = x;
        int n = 0;
        while (n < s.length()) {
            char c = s.charAt(n);
            if (FONT_KERN[m_selectedFontId] && n > 0) {
                int c1Ind = this.ms_fontAlphabet.indexOf(s.charAt(n - 1));
                int c2Ind = this.ms_fontAlphabet.indexOf(c);
                if (c1Ind >= 0 && c2Ind >= 0) {
                    xc += m_KerningPairs[m_selectedFontId][c1Ind][c2Ind];
                }
            }
            if (xc + this.drawChar(null, c, xc, y) > endX) {
                return xc - x;
            }
            xc += this.drawChar(g, c, xc, y);
            ++n;
        }
        return xc - x;
    }

    protected void drawString(Graphics g, String s, int x, int y, int characterToFlash) {
        int xc = x;
        int n = 0;
        while (n < s.length()) {
            char c = s.charAt(n);
            xc = n == characterToFlash && System.currentTimeMillis() % 1000L < 250L ? (xc += this.drawChar(null, c, xc, y)) : (xc += this.drawChar(g, c, xc, y));
            ++n;
        }
    }

    protected int drawStringWithCursor(Graphics g, String textToDraw, int x, int y, int xStart, int xEnd, int cursorPosition, int cutRight) {
        char c;
        int xc = x;
        boolean isFirstCharacter = true;
        String s = textToDraw;
        s = String.valueOf(s) + " ";
        int stringWidth = 0;
        int n = 0;
        while (n < s.length()) {
            c = s.charAt(n);
            stringWidth += this.drawChar(null, c, xc, y);
            ++n;
        }
        int boxWidth = xEnd - xStart - this.getStringLength(" ");
        if (stringWidth > boxWidth) {
            xc -= stringWidth - (boxWidth + cutRight);
        }
        if (xc > xStart) {
            xc = xStart;
        }
        int n2 = 0;
        while (n2 < s.length()) {
            c = s.charAt(n2);
            if (xc >= xStart && xc + this.getStringLength("" + c) <= xEnd) {
                if (isFirstCharacter) {
                    isFirstCharacter = false;
                    if (xc > xStart) {
                        xc = xStart;
                    }
                }
                xc += this.drawChar(g, c, xc, y);
            } else {
                xc += this.drawChar(null, c, xc, y);
            }
            ++n2;
        }
        return xc;
    }

    private String readTextFile(String filename) {
        StringBuffer buffer = null;
        InputStream is = null;
        InputStreamReader isr = null;
        try {
            int ch;
            Class<?> c = this.getClass();
            is = c.getResourceAsStream(filename);
            if (is == null) {
                throw new Exception("File Does Not Exist");
            }
            isr = new InputStreamReader(is, "UTF-8");
            buffer = new StringBuffer();
            while ((ch = isr.read()) > -1) {
                buffer.append((char)ch);
            }
            if (isr != null) {
                isr.close();
            }
        }
        catch (Exception ex) {
            Game.SOP("" + ex);
        }
        return buffer.toString();
    }
}

