/*
 * Decompiled with CFR 0.152.
 */
package Utility;

import GameLogicMidlet.DeviceCanvas;
import java.io.DataInputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class ImageBank {
    static int m_screenWidth = 0;
    static int m_screenHeight = 0;
    public int m_sourceFrameWidth = 0;
    public int m_sourceFrameHeight = 0;
    private Image m_image0 = null;
    private Image m_image1 = null;
    private Image m_image2 = null;
    private int m_numberOfFrames = 0;
    public short[] m_left_offset = null;
    public short[] m_top_offset = null;
    public short[] m_subimage_width = null;
    public short[] m_subimage_height = null;
    private short[] m_image_index = null;
    public short[] m_packed_pos_x = null;
    public short[] m_packed_pos_y = null;
    private boolean m_usesXOffsets = true;
    private boolean m_setClipBack = true;

    public ImageBank() {
        m_screenWidth = DeviceCanvas.screenWidth;
        m_screenHeight = DeviceCanvas.screenHeight;
    }

    public void setImage(int index, Image image) {
        if (index == 0) {
            this.m_image0 = image;
        } else if (index == 1) {
            this.m_image1 = image;
        } else if (index == 2) {
            this.m_image2 = image;
        }
    }

    Image getImage(int frame) {
        short image = this.m_image_index[frame];
        if (image == 0) {
            return this.m_image0;
        }
        if (image == 1) {
            return this.m_image1;
        }
        return this.m_image2;
    }

    public int getImageWidth(int imageNumber) {
        int width = 0;
        int i = 0;
        while (i < this.m_image_index.length) {
            if (this.m_subimage_width[i] == imageNumber) {
                width += this.m_subimage_width[i];
            }
            ++i;
        }
        return width;
    }

    public int getImageHeight(int imageNumber) {
        short height = 0;
        int i = 0;
        while (i < this.m_image_index.length) {
            if (this.m_image_index[i] == imageNumber && this.m_subimage_height[i] > height) {
                height = this.m_subimage_height[i];
            }
            ++i;
        }
        return height;
    }

    public int getFrameWidth(int _frame) {
        return this.m_subimage_width[_frame];
    }

    public int getFrameHeight(int _frame) {
        return this.m_subimage_height[_frame];
    }

    public void setUsesXOffset(boolean state) {
        this.m_usesXOffsets = state;
    }

    public void setClipBack(boolean state) {
        this.m_setClipBack = state;
    }

    public void loadImageData(DataInputStream dis) {
        try {
            this.m_numberOfFrames = dis.readInt();
            this.m_sourceFrameWidth = dis.readInt();
            this.m_sourceFrameHeight = dis.readInt();
            this.m_left_offset = new short[this.m_numberOfFrames];
            this.m_top_offset = new short[this.m_numberOfFrames];
            this.m_subimage_width = new short[this.m_numberOfFrames];
            this.m_subimage_height = new short[this.m_numberOfFrames];
            this.m_image_index = new short[this.m_numberOfFrames];
            this.m_packed_pos_x = new short[this.m_numberOfFrames];
            this.m_packed_pos_y = new short[this.m_numberOfFrames];
            int i = 0;
            while (i < this.m_numberOfFrames) {
                this.m_left_offset[i] = (short)dis.readInt();
                this.m_top_offset[i] = (short)dis.readInt();
                this.m_subimage_width[i] = (short)dis.readInt();
                this.m_subimage_height[i] = (short)dis.readInt();
                this.m_image_index[i] = (short)dis.readInt();
                this.m_packed_pos_x[i] = (short)dis.readInt();
                this.m_packed_pos_y[i] = (short)dis.readInt();
                ++i;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setOrigin(int _originX, int _originY) {
        int i = 0;
        while (i < this.m_left_offset.length) {
            this.m_left_offset[i] = (short)(this.m_left_offset[i] - _originX);
            this.m_top_offset[i] = (short)(this.m_top_offset[i] - _originY);
            ++i;
        }
    }

    public int getDestX(int x, int frame, boolean flipped) {
        if (this.m_usesXOffsets) {
            if (flipped) {
                return x + this.m_sourceFrameWidth - this.m_left_offset[frame] - this.m_subimage_width[frame];
            }
            return x + this.m_left_offset[frame];
        }
        return x;
    }

    public int getDestY(int y, int frame) {
        return y + this.m_top_offset[frame];
    }

    void paintWithoutOffset(Graphics graphics, int frame, int x, int y, boolean flipped) {
        this.paint(graphics, frame, x -= this.m_left_offset[0], y -= this.m_top_offset[0], flipped);
    }

    public void paint(Graphics graphics, int frame, int x, int y, boolean flipped) {
        short srcX = this.m_packed_pos_x[frame];
        short srcY = this.m_packed_pos_y[frame];
        short destWidth = this.m_subimage_width[frame];
        short destHeight = this.m_subimage_height[frame];
        int destX = this.getDestX(x, frame, flipped);
        int destY = this.getDestY(y, frame);
        int paintX = destX - srcX;
        int paintY = destY - srcY;
        Image srcImage = this.getImage(frame);
        graphics.setClip(destX, destY, (int)destWidth, (int)destHeight);
        if (destX < m_screenWidth && destY < m_screenHeight && destX > -destWidth && destY > -destHeight) {
            graphics.drawImage(srcImage, paintX, paintY, 20);
        }
        if (this.m_setClipBack) {
            graphics.setClip(0, 0, m_screenWidth, m_screenHeight);
        }
    }

    public void paintExactly(Graphics graphics, int frame, int x, int y) {
        short srcX = this.m_packed_pos_x[frame];
        short srcY = this.m_packed_pos_y[frame];
        int paintX = x - srcX;
        int paintY = y - srcY;
        short destWidth = this.m_subimage_width[frame];
        short destHeight = this.m_subimage_height[frame];
        Image srcImage = this.getImage(frame);
        graphics.setClip(x, y, (int)destWidth, (int)destHeight);
        graphics.drawImage(srcImage, paintX, paintY, 20);
        graphics.setClip(0, 0, m_screenWidth, m_screenHeight);
    }

    public final int getNumFrames() {
        return this.m_numberOfFrames;
    }

    public int getSourceFrameWidth() {
        return this.m_sourceFrameWidth;
    }

    public int getSourceFrameHeight() {
        return this.m_sourceFrameHeight;
    }
}

