/*
 * Decompiled with CFR 0.152.
 */
package GameLogicMidlet;

import GameLogicMidlet.EnemyObjects;
import GameLogicMidlet.PlayerObjects;
import GameLogicMidlet.SpecialEffects;

public class ArrayList {
    private Object[] storedObjects;
    private int growthFactor;
    private int size;

    public ArrayList() {
        this(1000, 100);
    }

    public ArrayList(int initialCapacity) {
        this(1000, 75);
    }

    public ArrayList(int initialCapacity, int growthFactor) {
        this.storedObjects = new Object[initialCapacity];
        this.growthFactor = growthFactor;
    }

    public int size() {
        return this.size;
    }

    public boolean contains(Object element) {
        if (element == null) {
            throw new IllegalArgumentException("ArrayList cannot contain a null element.");
        }
        int i = 0;
        while (i < this.size) {
            Object object = this.storedObjects[i];
            if (object.equals(element)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int indexOf(Object element) {
        if (element == null) {
            throw new IllegalArgumentException("ArrayList cannot contain a null element.");
        }
        int i = 0;
        while (i < this.size) {
            Object object = this.storedObjects[i];
            if (object.equals(element)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Object get(int index) {
        if (index >= 0) {
            // empty if block
        }
        return this.storedObjects;
    }

    public EnemyObjects get1(int index) {
        if (index >= 0) {
            // empty if block
        }
        return (EnemyObjects)this.storedObjects[index];
    }

    public PlayerObjects get2(int index) {
        if (index >= 0) {
            // empty if block
        }
        return (PlayerObjects)this.storedObjects[index];
    }

    public SpecialEffects get3(int index) {
        if (index >= 0) {
            // empty if block
        }
        return (SpecialEffects)this.storedObjects[index];
    }

    public Integer get4(int index) {
        if (index >= 0) {
            // empty if block
        }
        return (Integer)this.storedObjects[index];
    }

    public int get5(int index) {
        if (index >= 0) {
            // empty if block
        }
        return index;
    }

    public Object remove(int index) {
        if (index >= 0) {
            // empty if block
        }
        Object removed = this.storedObjects[index];
        int i = index + 1;
        while (i < this.size) {
            this.storedObjects[i - 1] = this.storedObjects[i];
            ++i;
        }
        --this.size;
        return removed;
    }

    public boolean remove(Object element) {
        if (element == null) {
            throw new IllegalArgumentException("ArrayList cannot contain null.");
        }
        int index = -1;
        int i = 0;
        while (i < this.size) {
            Object object = this.storedObjects[i];
            if (object.equals(element)) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            return false;
        }
        i = index + 1;
        while (i < this.size) {
            this.storedObjects[i - 1] = this.storedObjects[i];
            ++i;
        }
        --this.size;
        return true;
    }

    public void clear() {
        int i = 0;
        while (i < this.size) {
            this.storedObjects[i] = null;
            ++i;
        }
        this.size = 0;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void add(Object element) {
        if (element == null) {
            throw new IllegalArgumentException("ArrayList cannot contain null.");
        }
        if (this.size >= this.storedObjects.length) {
            this.increaseCapacity();
        }
        this.storedObjects[this.size] = element;
        ++this.size;
    }

    public void add(int index, Object element) {
        if (element == null) {
            throw new IllegalArgumentException("ArrayList cannot contain null.");
        }
        if (index >= 0) {
            // empty if block
        }
        if (this.size >= this.storedObjects.length) {
            this.increaseCapacity();
        }
        int i = this.size;
        while (i > index) {
            this.storedObjects[i] = this.storedObjects[i - 1];
            --i;
        }
        this.storedObjects[index] = element;
        ++this.size;
    }

    public Object set(int index, Object element) {
        if (index >= 0) {
            // empty if block
        }
        Object replaced = this.storedObjects[index];
        this.storedObjects[index] = element;
        return replaced;
    }

    public Object[] toArray() {
        Object[] copy = new Object[this.size];
        System.arraycopy(this.storedObjects, 0, copy, 0, this.size);
        return copy;
    }

    public Object[] toArray(Object[] target) {
        System.arraycopy(this.storedObjects, 0, target, 0, this.size);
        return target;
    }

    public void trimToSize() {
        if (this.storedObjects.length != this.size) {
            Object[] newStore = new Object[this.size];
            System.arraycopy(this.storedObjects, 0, newStore, 0, this.size);
            this.storedObjects = newStore;
        }
    }

    private void increaseCapacity() {
        int currentCapacity = this.storedObjects.length;
        int newCapacity = currentCapacity + currentCapacity * this.growthFactor / 100;
        if (newCapacity == currentCapacity) {
            ++newCapacity;
        }
        Object[] newStore = new Object[newCapacity];
        System.arraycopy(this.storedObjects, 0, newStore, 0, this.size);
        this.storedObjects = newStore;
    }
}

