/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Graphics;
import javax.microedition.midlet.MIDlet;

public class CBall
extends CActor {
    public int[] m_screenLastPosition = new int[2];
    public int[] m_lastPoint = new int[3];
    public int[] m_shadowPosy = new int[3];
    public int m_ballLastX;
    public int m_ballLastY;
    public int m_gravity;
    public int m_xForce;
    public int m_yForce;
    public int m_zForce;
    public int m_xSand;
    public int m_zSand;
    public int m_spikingCounter = 0;
    public int m_settingCounter = 0;
    public int m_passingCounter = 0;
    public int m_diggingCounter = 0;
    public int m_predictedMoveCounter = 0;
    public boolean m_bGoodNetCrossing;
    public int[][] m_hotSpots;
    public boolean m_bDigSuccess;
    public boolean m_bBallFell;

    public CBall(int n, int n2) {
        super(n, n2);
        this.setGravity(206);
        this.m_hotSpots = new int[5][2];
    }

    public void setGravity(int n) {
        this.m_gravity = n;
    }

    public void initActor(int n, int n2, int n3) {
        this.m_xReal = n;
        this.m_yReal = 0;
        this.m_zReal = n2;
        this.m_currentFrame = 0;
        this.m_currentFrameTime = 0;
        this.m_animation = 1;
        this.m_xForce = 0;
        this.m_yForce = 0;
        this.m_zForce = 0;
    }

    public void getForceNeeded(int[] nArray, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        nArray[0] = 0;
        nArray[1] = 640;
        nArray[2] = 0;
        if (n4 > 0 && (n7 = CGame.sqrt((n6 = n - this.m_xReal) * n6 + (n5 = n3 - this.m_zReal) * n5, 15)) > 128) {
            int n8 = n6 / (n7 >> 7);
            int n9 = n5 / (n7 >> 7);
            nArray[0] = n4 * n8 >> 7;
            nArray[2] = n4 * n9 >> 7;
            int n10 = (n7 << 7) / n4 + 1 >> 1;
            if (n10 >= 128) {
                nArray[1] = (this.m_gravity * n10 >> 7) - ((this.m_yReal << 7) / n10 * 206 >> 7 >> 1) + ((n2 << 7) / n10 * 206 >> 7);
            }
        }
    }

    public int getStrengthNeeded(int n, int n2, int n3, int n4) {
        int n5 = this.m_xReal - n;
        int n6 = this.m_zReal - n3;
        int n7 = CGame.sqrt((n5 * n5 >> 7 >> 7) + (n6 * n6 >> 7 >> 7), 15);
        int n8 = (n7 << 7) / n4;
        return n8;
    }

    public void checkGroundCollision() {
        if (this.m_yReal <= 512 && !this.m_bDigSuccess) {
            int[] nArray = new int[3];
            int[] nArray2 = new int[]{this.m_xReal, this.m_yReal, this.m_zReal};
            this.getMiddlePoint(nArray, this.m_lastPoint, nArray2, 512);
            this.m_xReal = nArray[0];
            this.m_yReal = 512;
            this.m_zReal = nArray[2];
            if (CGame.m_bIsBallTailActive) {
                CGame.m_ballTailTimeToDie = CGame.m_frameSequence + 6;
            }
            if (CGame.m_gameState == 11 && CGame.m_gameSubState == 1 && CGame.m_gameMode != 3) {
                this.checkPoint();
            }
            if (!this.m_bBallFell) {
                boolean bl;
                if (CGame.m_lastTouchPlayer > 1 && CGame.m_lastSuperMove != -1 && (CGame.m_lastMove == 3 || CGame.m_lastMove == 4 || CGame.m_lastMove == 13)) {
                    Display.getDisplay((MIDlet)GloftBVB.instance).vibrate(300);
                }
                if (CGame.m_gameState == 11 && !CBall.isInsideCourt(this.m_xReal, this.m_zReal) && CGame.m_gameSubState == 1 && CGame.m_gameMode != 3) {
                    CGame.drawIngameMessage(11);
                }
                if (CGame.m_gameState == 11 && CGame.m_gameMode == 3 && CGame.m_tutorialStep >= 1 && CGame.m_tutorialSuccessState == 0) {
                    CGame.m_tutorialResetStepCounter = CGame.m_frameSequence + 10;
                    switch (CGame.m_tutorialStep) {
                        case 3: 
                        case 7: 
                        case 9: {
                            if (CGame.m_actorBall.m_hotSpots[4][0] > 0 && this.m_bGoodNetCrossing) {
                                if (CBall.isInsideCourt(CGame.m_actorBall.m_xReal, CGame.m_actorBall.m_zReal)) {
                                    CGame.m_tutorialSuccessState = 1;
                                    if (++CGame.m_tutorialCurrentSuccessCount == 2 && CGame.m_tutorialStep >= 3 && CGame.m_tutorialStep % 2 == 1) {
                                        CGame.m_tutorialQuestionAsk = 1;
                                        --CGame.m_tutorialStep;
                                        break;
                                    }
                                    if (CGame.m_tutorialCurrentSuccessCount != 1) break;
                                    CGame.finishTutorialStep(CGame.m_tutorialStep - 3 >> 1);
                                    break;
                                }
                            }
                            CGame.m_tutorialSuccessState = 2;
                            break;
                        }
                        case 5: {
                            CGame.m_tutorialSuccessState = 2;
                        }
                    }
                }
                if (CGame.m_gameSubState != 0) {
                    CGame.SoundPlay(12);
                }
                boolean bl2 = bl = Math.abs(this.m_lastPoint[0] - this.m_xReal) > 450;
                if (this.m_lastPoint[0] > this.m_xReal) {
                    if (bl) {
                        this.createGameEffect(this.m_xReal, 0, this.m_zReal, 4);
                    } else {
                        this.createGameEffect(this.m_xReal, 0, this.m_zReal, 5);
                    }
                } else if (bl) {
                    this.createGameEffect(this.m_xReal, 0, this.m_zReal, 4);
                } else {
                    this.createGameEffect(this.m_xReal, 0, this.m_zReal, 5);
                }
                if (CGame.m_lastMove == 3 && CGame.m_lastTouchPlayer == 0) {
                    if (CBall.isInsideCourt(CGame.m_actorBall.m_xReal, CGame.m_actorBall.m_zReal) && (CGame.m_actorBall.m_xReal > 0 ? 1 : 0) != CGame.m_userSide && CGame.m_gameState == 11 && CGame.m_actorBall.m_bGoodNetCrossing) {
                        CGame.setDisplayMsg(1);
                    }
                }
            }
            if (this.m_animation == 6) {
                this.setAnimation(0, 0);
            }
            if (CGame.m_bMultiBallActivated) {
                CGame.m_multiBallDieCounter = 10;
            }
            this.m_yForce = -this.m_yForce * 35 >> 7;
            this.m_xForce = this.m_xForce * 60 >> 7;
            this.m_zForce = this.m_zForce * 60 >> 7;
            if (this.m_xForce > -60 && this.m_xForce < 60) {
                this.m_xForce = 0;
            }
            if (this.m_yForce > -this.m_gravity && this.m_yForce < this.m_gravity) {
                this.m_yForce = 0;
            }
            if (this.m_zForce > -60 && this.m_zForce < 60) {
                this.m_zForce = 0;
            }
            CGame.m_bIsHotSpotVisible = false;
            this.m_bBallFell = true;
            this.toScreen();
        }
    }

    public void calculateFallSpot(boolean bl) {
        if (!CGame.m_bIsPredictedMove) {
            int n = this.m_diggingCounter;
            int n2 = this.m_spikingCounter;
            int n3 = this.m_settingCounter;
            int n4 = this.m_passingCounter;
            int n5 = CGame.m_actorBall.m_hotSpots[4][0];
            int n6 = CGame.m_actorBall.m_hotSpots[4][1];
            int[] nArray = new int[]{this.m_xReal, this.m_yReal, this.m_zReal};
            int[] nArray2 = new int[3];
            int[] nArray3 = new int[3];
            int n7 = this.m_xForce;
            int n8 = this.m_yForce;
            int n9 = this.m_zForce;
            boolean bl2 = true;
            boolean bl3 = false;
            int n10 = 0;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            boolean bl7 = false;
            boolean bl8 = false;
            boolean bl9 = false;
            boolean bl10 = false;
            boolean bl11 = false;
            if (!bl) {
                this.m_spikingCounter = 0;
                this.m_settingCounter = 0;
                this.m_passingCounter = 0;
                this.m_diggingCounter = 0;
            }
            this.m_bGoodNetCrossing = false;
            int n11 = CGame.m_touchNumber == 0 || CGame.m_gameSubState == 0 || CGame.m_actorBall.m_xReal > 0 != CGame.m_actorBall.m_hotSpots[4][0] > 0 || bl ? CGame.BALL_OFFSETS_Y[2] : CGame.BALL_OFFSETS_Y[3];
            if (!bl) {
                CGame.m_moveRequiredHeight = n11;
            }
            CGame.m_bCanDoSpike = false;
            do {
                nArray2[0] = nArray[0];
                nArray2[1] = nArray[1];
                nArray2[2] = nArray[2];
                nArray[0] = nArray[0] + n7;
                nArray[1] = nArray[1] + n8;
                nArray[2] = nArray[2] + n9;
                n8 -= this.m_gravity;
                if (nArray[2] > 11008) {
                    nArray[2] = 11008;
                }
                int n12 = Math.abs(nArray2[0] - nArray[0]) != 0 ? ((nArray[1] - nArray2[1]) * ((Math.abs(nArray2[0]) << 7) / Math.abs(nArray2[0] - nArray[0])) >> 7) + nArray2[1] : nArray[1] + (nArray[1] - nArray2[1]) / 2;
                if (nArray2[0] < 0 && nArray[0] >= 0) {
                    bl11 = true;
                    if (n12 > 5120) {
                        this.m_bGoodNetCrossing = true;
                    }
                } else if (nArray2[0] >= 0 && nArray[0] < 0) {
                    bl11 = true;
                    if (n12 > 5120) {
                        this.m_bGoodNetCrossing = true;
                    }
                }
                if (nArray[1] >= CGame.BALL_OFFSETS_Y[4] && !bl7) {
                    CGame.m_bCanDoSpike = true;
                }
                if (nArray2[1] > nArray[1]) {
                    if (!bl7 && nArray[1] < CGame.BALL_OFFSETS_Y[4]) {
                        bl7 = true;
                        this.m_spikingCounter = bl ? n10 + n2 : n10;
                        this.getMiddlePoint(nArray3, nArray2, nArray, CGame.BALL_OFFSETS_Y[4]);
                        CGame.m_actorBall.m_hotSpots[0][0] = nArray3[0] + (CGame.m_sideTeamTurn == 0 ? -CGame.BALL_OFFSETS_X[4] : CGame.BALL_OFFSETS_X[4]);
                        CGame.m_actorBall.m_hotSpots[0][1] = nArray3[2];
                        if (this.m_spikingCounter <= 12) {
                            CGame.m_bCanDoSpike = false;
                        }
                    }
                    if (!bl8 && nArray[1] < CGame.BALL_OFFSETS_Y[3]) {
                        bl8 = true;
                        this.m_settingCounter = bl ? n10 + 1 + n2 : n10 + 1;
                        if (n11 == CGame.BALL_OFFSETS_Y[3]) {
                            this.getMiddlePoint(nArray3, nArray2, nArray, CGame.BALL_OFFSETS_Y[2]);
                            CGame.m_actorBall.m_hotSpots[3][0] = nArray3[0];
                            CGame.m_actorBall.m_hotSpots[3][1] = nArray3[2];
                        }
                    }
                    if (!bl9 && nArray[1] < CGame.BALL_OFFSETS_Y[2]) {
                        bl9 = true;
                        this.m_passingCounter = bl ? n10 + n2 + 2 : n10 + 1;
                        this.getMiddlePoint(nArray3, nArray2, nArray, CGame.BALL_OFFSETS_Y[2]);
                        if (n11 == CGame.BALL_OFFSETS_Y[2]) {
                            CGame.m_actorBall.m_hotSpots[3][0] = nArray3[0];
                            CGame.m_actorBall.m_hotSpots[3][1] = nArray3[2];
                        }
                        nArray3[0] = nArray3[0] - CGame.BALL_OFFSETS_X[2];
                        CGame.m_actorBall.m_hotSpots[1][0] = nArray3[0];
                        CGame.m_actorBall.m_hotSpots[1][1] = nArray3[2];
                        nArray3[0] = nArray3[0] + (CGame.BALL_OFFSETS_X[2] << 1);
                        CGame.m_actorBall.m_hotSpots[2][0] = nArray3[0];
                        CGame.m_actorBall.m_hotSpots[2][1] = nArray3[2];
                    }
                    if (!bl10 && nArray[1] < 256) {
                        bl10 = true;
                        this.m_diggingCounter = bl ? n10 + 2 + n2 : n10 + 1;
                    }
                    if (nArray[1] <= 512) {
                        if (!bl10) {
                            this.m_diggingCounter = bl ? n10 + 2 + n2 : n10 + 1;
                        }
                        this.getMiddlePoint(nArray3, nArray2, nArray, 512);
                        CGame.m_actorBall.m_hotSpots[4][0] = nArray3[0];
                        CGame.m_actorBall.m_hotSpots[4][1] = nArray3[2];
                        bl2 = false;
                    }
                }
                ++n10;
            } while (bl2);
            if (!bl11) {
                this.m_bGoodNetCrossing = true;
            }
            CGame.m_bIsHotSpotVisible = true;
            this.m_bBallFell = false;
            CGame.m_spotIndex = CGame.m_lastMove == 3 || CGame.m_lastMove == 4 || bl ? 5 : 1;
            if (!bl) {
                CGame.m_hitBallTime = System.currentTimeMillis();
            }
            if (CGame.m_gameMode != 3) {
                if (384 > Math.abs(CGame.m_actorBall.m_hotSpots[4][0] - n5) && 384 > Math.abs(CGame.m_actorBall.m_hotSpots[4][1] - n6) && !CGame.m_bIsPredictedMove) {
                    this.m_diggingCounter = n;
                    this.m_spikingCounter = n2;
                    this.m_settingCounter = n3;
                    this.m_passingCounter = n4;
                } else {
                    CGame.unlockPlayer();
                    CGame.clearDigSuccess();
                }
            }
            if (CGame.m_actorBall.m_hotSpots[4][0] > 0 != CGame.m_actorBall.m_xReal > 0) {
                CGame.m_sideTeamTurn = CGame.m_actorBall.m_hotSpots[4][0] > 0 ? 1 : 0;
            }
        }
    }

    public void getMiddlePoint(int[] nArray, int[] nArray2, int[] nArray3, int n) {
        int n2 = nArray2[1] - n;
        if (nArray2[1] - nArray3[1] >> 7 == 0) {
            nArray[0] = nArray2[0];
            nArray[1] = nArray2[1];
            nArray[2] = nArray2[2];
        } else {
            int n3 = n2 / (nArray2[1] - nArray3[1] >> 7);
            nArray[0] = nArray2[0] + ((nArray3[0] - nArray2[0]) * n3 >> 7);
            nArray[1] = nArray2[1] + ((nArray3[1] - nArray2[1]) * n3 >> 7);
            nArray[2] = nArray2[2] + ((nArray3[2] - nArray2[2]) * n3 >> 7);
        }
    }

    public void getMiddlePointHeight(int[] nArray, int[] nArray2, int[] nArray3, int n) {
        int n2 = nArray3[0] - nArray2[0];
        int n3 = nArray3[1] - nArray2[1];
        int n4 = nArray3[2] - nArray2[2];
        int n5 = nArray3[0] - n;
        if (n2 >> 7 == 0) {
            nArray[0] = nArray2[0];
            nArray[1] = nArray2[1];
            nArray[2] = nArray2[2];
        } else {
            int n6 = n5 / (n2 >> 7);
            nArray[0] = n;
            nArray[1] = nArray2[1] + (n6 * n3 >> 7);
            nArray[2] = nArray2[2] + (n6 * n4 >> 7);
        }
    }

    public void checkPoint() {
        block4: {
            block7: {
                block5: {
                    block6: {
                        CPlayer cPlayer = CGame.m_actorsGame[CGame.m_lastTouchPlayer];
                        if (CGame.m_bPointGiven) break block4;
                        int n = !CBall.isInsideCourt(this.m_xReal, this.m_zReal) ? (cPlayer.m_xReal < 0 ? 1 : 0) : (this.m_xReal < 0 ? (this.m_bGoodNetCrossing || cPlayer.m_xReal < 0 ? 1 : 0) : (this.m_bGoodNetCrossing || cPlayer.m_xReal > 0 ? 0 : 1));
                        if (CGame.m_serviceSide != n) {
                            CGame.m_playerServicer[n] = (CGame.m_actorsGame[CGame.m_playerServicer[n]].m_team << 1) + (CGame.m_playerServicer[n] + 1) % 2;
                        }
                        CGame.m_serviceSide = n;
                        CGame.m_bPointGiven = true;
                        CGame.m_bUpdateScoreBoard = true;
                        CGame.m_gameNextSubState = 2;
                        CGame.m_gotoNextStateFrames = CGame.m_frameSequence + 8;
                        if (CGame.m_lastMove != 3 && CGame.m_lastMove != 4 || CGame.m_lastTouchPlayer != 0) break block5;
                        if (CGame.m_amazingSpikeProbability >= CGame.random(0, 99)) break block6;
                        if (CBall.isInsideCourt(CGame.m_actorBall.m_xReal, CGame.m_actorBall.m_zReal) && (CGame.m_actorBall.m_xReal > 0 ? 1 : 0) != CGame.m_userSide && CGame.m_actorBall.m_bGoodNetCrossing) break block7;
                    }
                    if (CGame.m_actorsGame[0].m_bSpecialPowerUsed) break block7;
                }
                if ((CGame.m_lastMove != 13 || !CGame.m_actorsGame[0].m_bSpecialPowerUsed) && (CGame.m_lastMove != 5 || !CGame.m_actorsGame[0].m_bSpecialPowerUsed)) break block4;
            }
            CGame.changeSubState(4);
            CGame.m_gotoNextStateFrames = 0;
        }
    }

    public void setForce(int[] nArray) {
        this.setForce(nArray[0], nArray[1], nArray[2]);
    }

    public void setForce(int n, int n2, int n3) {
        this.m_xForce = n;
        this.m_yForce = n2;
        this.m_zForce = n3;
        this.calculateFallSpot(false);
    }

    public void setForcePredicted(int[] nArray) {
        int n = this.m_xForce;
        int n2 = this.m_yForce;
        int n3 = this.m_zForce;
        this.m_xForce = nArray[0];
        this.m_yForce = nArray[1];
        this.m_zForce = nArray[2];
        this.calculateFallSpot(true);
        this.m_xForce = n;
        this.m_yForce = n2;
        this.m_zForce = n3;
    }

    public static boolean isInsideCourt(int n, int n2) {
        if (n2 < 2176 || n2 > 10112) {
            return false;
        }
        return Math.abs(n) <= 17920;
    }

    public void createGameEffect(int n, int n2, int n3, int n4) {
        if (CGame.m_gameState == 11) {
            int n5 = this.m_flip == 0 ? 1 : 0;
            CActor cActor = CGame.s_actors[7];
            cActor.m_xReal = n;
            cActor.m_yReal = n2;
            cActor.m_zReal = n3;
            cActor.m_flip = n5;
            cActor.setAnimation(n4, -1);
            cActor.toScreen();
        }
    }

    public boolean checkNetCollision(int[] nArray) {
        if ((this.m_xReal > 0 ? 1 : (this.m_xReal < 0 ? -1 : 0)) != (this.m_lastPoint[0] > 0 ? 1 : (this.m_lastPoint[0] < 0 ? -1 : 0))) {
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            int[] nArray2 = new int[3];
            int[] nArray3 = new int[]{this.m_xReal, this.m_yReal, this.m_zReal};
            this.getMiddlePointHeight(nArray2, this.m_lastPoint, nArray3, 0);
            int n = nArray2[0] - 0;
            int n2 = nArray2[1] - 5120;
            int n3 = nArray2[2] - 8960;
            int n4 = CGame.sqrt((n * n >> 7 >> 7) + (n2 * n2 >> 7 >> 7), 15);
            int n5 = CGame.sqrt((n3 * n3 >> 7 >> 7) + (n4 * n4 >> 7 >> 7), 15);
            if (896 > Math.abs(n)) {
                bl = true;
            }
            if (1792 > Math.abs(n2)) {
                bl2 = true;
            }
            if (4992 > Math.abs(n3)) {
                bl3 = true;
            }
            if (bl && bl2 && bl3) {
                if (n5 == 0) {
                    n5 = 1;
                }
                if (Math.abs(n) < Math.abs(n2)) {
                    if (Math.abs(n) < Math.abs(n3)) {
                        nArray[0] = -(this.m_xForce * 140 >> 7);
                        nArray[1] = 0;
                        nArray[2] = 0;
                    } else {
                        nArray[0] = 0;
                        nArray[1] = 0;
                        nArray[2] = n3 / n5 * 384 >> 7;
                    }
                } else if (Math.abs(n2) < Math.abs(n3)) {
                    nArray[0] = 0;
                    nArray[1] = n2 / n5 * 768 >> 7;
                    nArray[2] = 0;
                } else {
                    nArray[0] = 0;
                    nArray[1] = 0;
                    nArray[2] = n3 / n5 * 384 >> 7;
                }
                return true;
            }
        }
        return false;
    }

    public void hitBall(int[] nArray, int n, int n2, int n3) {
        int n4 = 128 - (CGame.random(0, 128) * n >> 7);
        int n5 = 128 - (CGame.random(0, 128) * n2 >> 7);
        int n6 = 128 - (CGame.random(0, 128) * n3 >> 7);
        this.m_xForce -= this.m_xForce * n4 >> 7;
        this.m_yForce -= this.m_yForce * n5 >> 7;
        this.m_zForce -= this.m_zForce * n6 >> 7;
        this.applyForce(nArray);
    }

    public void applyForce(int[] nArray) {
        this.m_bBallFell = false;
        this.m_xForce += nArray[0];
        this.m_yForce += nArray[1];
        this.m_zForce += nArray[2];
        this.calculateFallSpot(false);
    }

    public void drawShadow(Graphics graphics) {
        int n = this.m_yReal < 10240 ? 59 : 58;
        CGame.m_sprShadows.PaintFrame(graphics, n, this.m_screenPosition[0], this.m_shadowPosy[0], 0, 0, 0);
        if (CGame.m_bMultiBallActivated) {
            for (int i = 0; i < 2; ++i) {
                CActor cActor = CGame.s_actors[6];
                if (cActor.m_animation < 0) continue;
                CGame.m_sprShadows.PaintFrame(graphics, n, this.m_screenPosition[0], this.m_shadowPosy[i + 1], 0, 0, 0);
            }
        }
    }

    public void toScreen() {
        super.toScreen();
        this.m_shadowPosy[0] = this.m_screenPosition[1] + ((this.m_yReal >> 7) * 122 >> 7);
        if (CGame.m_bMultiBallActivated) {
            for (int i = 0; i < 2; ++i) {
                CActor cActor = CGame.s_actors[6];
                if (cActor.m_animation < 0) continue;
                this.m_shadowPosy[1 + i] = cActor.m_screenPosition[1] + ((cActor.m_yReal >> 7) * 122 >> 7);
            }
        }
    }

    public void update() {
        if (!this.m_bIsFreeze) {
            this.updateBall();
            if (CGame.m_bMultiBallActivated) {
                this.updateFakeBalls();
            }
        }
        this.toScreen();
    }

    public void updateFakeBalls() {
        CActor cActor = CGame.s_actors[5];
        CActor cActor2 = CGame.s_actors[6];
        if (CGame.m_multiBallRealPosition == 0) {
            if (CGame.m_multiBallDieCounter == 0 || (CGame.m_multiBallDieCounter & 1) != 0) {
                cActor.setAnimation(this.m_animation);
                cActor.set3DPosition(this.m_xReal, this.m_yReal, this.m_zReal - (CGame.m_multiBallCurrentDistance << 1 << 7));
                cActor.m_flip = this.m_flip;
                cActor2.setAnimation(this.m_animation);
                cActor2.set3DPosition(this.m_xReal, this.m_yReal, this.m_zReal - (CGame.m_multiBallCurrentDistance << 7));
                cActor2.m_flip = this.m_flip;
            } else {
                cActor.setAnimation(-1);
                cActor2.setAnimation(-1);
            }
        } else if (CGame.m_multiBallRealPosition == 1) {
            if (CGame.m_multiBallDieCounter == 0 || (CGame.m_multiBallDieCounter & 1) != 0) {
                cActor.setAnimation(this.m_animation);
                cActor.set3DPosition(this.m_xReal, this.m_yReal, this.m_zReal - (CGame.m_multiBallCurrentDistance << 7));
                cActor.m_flip = this.m_flip;
                cActor2.setAnimation(this.m_animation);
                cActor2.set3DPosition(this.m_xReal, this.m_yReal, this.m_zReal + (CGame.m_multiBallCurrentDistance << 7));
                cActor2.m_flip = this.m_flip;
            } else {
                cActor.setAnimation(-1);
                cActor2.setAnimation(-1);
            }
        } else if (CGame.m_multiBallDieCounter == 0 || (CGame.m_multiBallDieCounter & 1) != 0) {
            cActor.setAnimation(this.m_animation);
            cActor.set3DPosition(this.m_xReal, this.m_yReal, this.m_zReal + (CGame.m_multiBallCurrentDistance << 1 << 7));
            cActor.m_flip = this.m_flip;
            cActor2.setAnimation(this.m_animation);
            cActor2.set3DPosition(this.m_xReal, this.m_yReal, this.m_zReal + (CGame.m_multiBallCurrentDistance << 7));
            cActor2.m_flip = this.m_flip;
        } else {
            cActor.setAnimation(-1);
            cActor2.setAnimation(-1);
        }
        cActor.toScreen();
        cActor2.toScreen();
        if (CGame.m_multiBallDieCounter > 0 && --CGame.m_multiBallDieCounter == 0) {
            CGame.m_bMultiBallActivated = false;
            cActor.setAnimation(-1);
            cActor2.setAnimation(-1);
        }
        if (CGame.m_multiBallCurrentDistance < 8) {
            CGame.m_multiBallCurrentDistance += 10;
        }
    }

    public void updateBall() {
        this.m_lastPoint[0] = this.m_xReal;
        this.m_lastPoint[1] = this.m_yReal;
        this.m_lastPoint[2] = this.m_zReal;
        this.toScreen();
        this.m_screenLastPosition[0] = this.m_screenPosition[0];
        this.m_screenLastPosition[1] = this.m_screenPosition[1];
        if (!CGame.m_b300EffectActive) {
            this.m_xReal += this.m_xForce;
            this.m_yReal += this.m_yForce;
            this.m_zReal += this.m_zForce;
        } else {
            this.m_xReal += this.m_xForce / 10;
            this.m_yReal += this.m_yForce / 10;
            this.m_zReal += this.m_zForce / 10;
        }
        if (this.m_zReal > 11008) {
            this.m_zReal = 11008;
        }
        if (this.m_lastPoint[0] != this.m_xReal || this.m_lastPoint[1] != this.m_yReal || this.m_lastPoint[2] != this.m_zReal) {
            if (this.m_animation == 1) {
                this.setAnimation(0, 0);
            }
        } else {
            this.setAnimation(1, 0);
        }
        this.m_flip = this.m_lastPoint[0] > this.m_xReal ? 1 : 0;
        if (!CGame.m_b300EffectActive) {
            this.m_yForce -= this.m_gravity;
        } else {
            this.setAnimation(0, 0);
        }
        if (this.m_yReal < CGame.BALL_OFFSETS_Y[2] && this.m_yReal < this.m_lastPoint[1]) {
            CGame.m_bIsHotSpotVisible = false;
        }
        this.updateNetCollision();
    }

    public void updateNetCollision() {
        if (this.m_yReal < CGame.BALL_OFFSETS_Y[2] && this.m_passingCounter == 0) {
            CGame.unlockPlayer();
        }
        CGame.s_actors[7].toScreen();
        int[] nArray = new int[3];
        if (this.checkNetCollision(nArray) && !CGame.m_bBallAlreadyCollided && !CGame.m_bMultiBallActivated && this.m_animation != 6) {
            if (this.m_index == 0) {
                Display.getDisplay((MIDlet)GloftBVB.instance).vibrate(300);
            }
            CGame.SoundPlay(12);
            int[] nArray2 = new int[3];
            int[] nArray3 = new int[]{this.m_xReal, this.m_yReal, this.m_zReal};
            CGame.m_actorBall.getMiddlePointHeight(nArray2, this.m_lastPoint, nArray3, 0 + (this.m_lastPoint[0] > 0 ? 1 : (this.m_lastPoint[0] < 0 ? -1 : 0)) * 896);
            CGame.m_actorBall.set3DPosition(nArray2[0], nArray2[1], nArray2[2]);
            CGame.m_actorBall.setAnimation(0, 0);
            this.m_xForce += nArray[0];
            this.m_yForce += nArray[1];
            this.m_zForce += nArray[2];
            CGame.m_bBallCollidedLastFrame = true;
            CGame.m_bBallAlreadyCollided = true;
        } else {
            if (CGame.m_bBallCollidedLastFrame) {
                this.calculateFallSpot(false);
            }
            if (CGame.m_gameMode != 3 && (this.m_xReal > 0 && this.m_ballLastX <= 0 || this.m_xReal < 0 && this.m_ballLastX >= 0) && this.m_yReal > 0) {
                if (CGame.m_lastMove == 13) {
                    CGame.setDisplayMsg(15);
                }
                CGame.m_touchNumber = 0;
            }
            CGame.m_bBallCollidedLastFrame = false;
            this.m_ballLastX = this.m_xReal;
            this.m_ballLastY = this.m_yReal;
        }
    }

    public void updateCounters() {
        if (this.m_predictedMoveCounter != 0 && !CGame.m_b300EffectActive) {
            --this.m_predictedMoveCounter;
            if (this.m_predictedMoveCounter == 0) {
                CGame.m_actorsGame[1].counterTrigger(10);
                CGame.m_actorsGame[CGame.m_predictionCharacter].counterTrigger(7);
            } else if (this.m_predictedMoveCounter == 5) {
                CGame.m_actorsGame[1].counterTrigger(9);
            } else if (this.m_predictedMoveCounter == 1) {
                CGame.m_actorsGame[1].counterTrigger(8);
            } else if (!(this.m_predictedMoveCounter != 4 || CGame.m_actorsGame[CGame.m_predictionCharacter].m_state != 8 || CGame.m_actorsGame[CGame.m_predictionCharacter].m_powerMeter < 100 || CGame.m_actorsGame[CGame.m_predictionCharacter].m_powerTypeSpike != 3 && CGame.m_actorsGame[CGame.m_predictionCharacter].m_powerTypeSpike != 0 && CGame.m_gameMode != 3 || CGame.m_actorsGame[CGame.m_predictionCharacter].m_bSpikeMiss)) {
                CGame.m_b300EffectActive = true;
                CGame.m_bSpecialPowerEffectEnable = true;
                CGame.m_specialPowerActivated = CGame.m_gameMode == 3 ? 3 : CGame.m_actorsGame[CGame.m_predictionCharacter].m_powerTypeSpike;
                CGame.m_300EffectFrameCount = 0;
                CGame.SoundPlay(6);
            }
        }
        if (this.m_spikingCounter != 0) {
            if (!CGame.m_b300EffectActive) {
                --this.m_spikingCounter;
                if (CGame.m_lockedPlayer != -1) {
                    if (!(this.m_spikingCounter > 6 || CGame.m_actorsGame[CGame.m_lockedPlayer].m_bMoveSelected || CGame.m_lockedPlayer != 0 || CGame.m_actorsGame[CGame.m_lockedPlayer].m_moveToMake != 3 && CGame.m_actorsGame[CGame.m_lockedPlayer].m_moveToMake != 4)) {
                        if (CGame.m_touchNumber == 1) {
                            CGame.m_actorsGame[CGame.m_lockedPlayer].changeMoveToMake(7);
                        } else if (CGame.m_touchNumber == 2) {
                            CGame.m_actorsGame[CGame.m_lockedPlayer].changeMoveToMake(6);
                        }
                    }
                    if (this.m_spikingCounter == 6) {
                        CGame.m_actorsGame[CGame.m_lockedPlayer].counterTrigger(3);
                    } else if (this.m_spikingCounter == 7) {
                        if (CGame.m_lockedPlayer < 2) {
                            CGame.m_actorsGame[2].counterTrigger(9);
                            CGame.m_actorsGame[3].counterTrigger(9);
                        }
                    } else if (this.m_spikingCounter == 3) {
                        if (CGame.m_lockedPlayer < 2) {
                            CGame.m_actorsGame[2].counterTrigger(8);
                            CGame.m_actorsGame[3].counterTrigger(8);
                        }
                    } else if (this.m_spikingCounter == 4) {
                        if (!(CGame.m_lockedPlayer == -1 || CGame.m_actorsGame[CGame.m_lockedPlayer].m_state != 8 || CGame.m_actorsGame[CGame.m_lockedPlayer].m_powerMeter < 100 || CGame.m_actorsGame[CGame.m_lockedPlayer].m_powerTypeSpike != 3 && CGame.m_actorsGame[CGame.m_lockedPlayer].m_powerTypeSpike != 0 && CGame.m_gameMode != 3 || CGame.m_actorsGame[CGame.m_lockedPlayer].m_bSpikeMiss)) {
                            if (CGame.m_actorsGame[CGame.m_lockedPlayer].m_index == 0) {
                                CGame.setDisplayMsg(11);
                            }
                            CGame.m_b300EffectActive = true;
                            CGame.m_bSpecialPowerEffectEnable = true;
                            CGame.m_specialPowerActivated = CGame.m_gameMode == 3 ? 3 : CGame.m_actorsGame[CGame.m_lockedPlayer].m_powerTypeSpike;
                            CGame.m_300EffectFrameCount = 0;
                            CGame.SoundPlay(6);
                        }
                    } else if (this.m_spikingCounter == 0) {
                        if (CGame.m_lockedPlayer < 2) {
                            CGame.m_actorsGame[2].counterTrigger(8);
                            CGame.m_actorsGame[3].counterTrigger(8);
                        }
                        CGame.m_actorsGame[CGame.m_lockedPlayer].counterTrigger(7);
                    }
                }
            } else if (++CGame.m_300EffectFrameCount == 10) {
                CGame.m_b300EffectActive = false;
            }
        }
        if (this.m_settingCounter != 0 && !CGame.m_b300EffectActive) {
            --this.m_settingCounter;
            if (CGame.m_lockedPlayer != -1) {
                if (this.m_settingCounter == 3) {
                    CGame.m_actorsGame[CGame.m_lockedPlayer].counterTrigger(2);
                }
                if (this.m_settingCounter == 0) {
                    CGame.m_actorsGame[CGame.m_lockedPlayer].counterTrigger(6);
                }
            }
        }
        if (this.m_passingCounter != 0 && !CGame.m_b300EffectActive) {
            --this.m_passingCounter;
            if (CGame.m_lockedPlayer != -1) {
                if (this.m_passingCounter == 5) {
                    CGame.m_actorsGame[CGame.m_lockedPlayer].counterTrigger(0);
                }
                if (this.m_passingCounter == 0) {
                    CGame.m_actorsGame[CGame.m_lockedPlayer].counterTrigger(4);
                }
            }
        }
        if (this.m_diggingCounter != 0 && !CGame.m_b300EffectActive) {
            --this.m_diggingCounter;
            if (this.m_diggingCounter <= 2 && this.m_diggingCounter >= -2) {
                if (CGame.m_gameState == 11) {
                    CGame.m_actorsGame[0].counterTrigger(1);
                    CGame.m_actorsGame[1].counterTrigger(1);
                    if (CGame.m_gameMode != 3) {
                        CGame.m_actorsGame[2].counterTrigger(1);
                        CGame.m_actorsGame[3].counterTrigger(1);
                    }
                } else {
                    CGame.m_actorsGame[0].counterTrigger(1, this);
                }
            }
            if (this.m_diggingCounter == 0) {
                if (CGame.m_gameState == 11) {
                    CGame.m_actorsGame[0].counterTrigger(5);
                    CGame.m_actorsGame[1].counterTrigger(5);
                    if (CGame.m_gameMode != 3) {
                        CGame.m_actorsGame[2].counterTrigger(5);
                        CGame.m_actorsGame[3].counterTrigger(5);
                    }
                } else {
                    CGame.m_actorsGame[0].counterTrigger(5, this);
                }
            }
        }
    }
}

