/*
 * Decompiled with CFR 0.152.
 */
package iec.alchemistStone;

import java.util.Vector;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;
import javax.microedition.rms.RecordStoreNotOpenException;

public class IECRecordStore {
    private RecordStore rs;
    private String lastRMS_name = "";
    int BYTE_MAX = 128;
    int bytes_int = 5;
    int bytes_long = 9;

    IECRecordStore() {
    }

    private RecordStore OpenRMS(String RMS_NAME) {
        if (RMS_NAME.equalsIgnoreCase(this.lastRMS_name)) {
            return this.rs;
        }
        this.closeRMS();
        RecordStore rs = null;
        try {
            rs = RecordStore.openRecordStore((String)RMS_NAME, (boolean)true);
            this.lastRMS_name = RMS_NAME;
        }
        catch (RecordStoreFullException e) {
            e.printStackTrace();
        }
        catch (RecordStoreNotFoundException e) {
            e.printStackTrace();
        }
        catch (RecordStoreException e) {
            e.printStackTrace();
        }
        return rs;
    }

    public void closeRMS() {
        if (this.rs != null) {
            try {
                this.rs.closeRecordStore();
            }
            catch (RecordStoreNotOpenException e1) {
                e1.printStackTrace();
            }
            catch (RecordStoreException e1) {
                e1.printStackTrace();
            }
        }
    }

    public boolean hasRecord(String file) {
        String data = "";
        this.rs = this.OpenRMS(file);
        try {
            if (this.rs.getNumRecords() > 0) {
                return true;
            }
        }
        catch (RecordStoreNotOpenException e) {
            e.printStackTrace();
        }
        return false;
    }

    public int hasRecordNum(String file) {
        this.rs = this.OpenRMS(file);
        try {
            if (this.rs.getSize() > 0) {
                return this.rs.getNumRecords();
            }
        }
        catch (RecordStoreNotOpenException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public String read(String file) throws RecordException {
        String data = "";
        this.rs = this.OpenRMS(file);
        if (this.rs != null) {
            try {
                byte[] b = this.rs.getRecord(0);
                data = new String(b);
            }
            catch (RecordStoreNotOpenException e) {
                throw new RecordException("RecordStoreNotOpenException");
            }
            catch (InvalidRecordIDException e) {
                throw new RecordException("InvalidRecordIDException");
            }
            catch (RecordStoreException e) {
                throw new RecordException("RecordStoreException");
            }
        } else {
            throw new RecordException("RMS is not exist!");
        }
        return data;
    }

    public void write(String file, String msg) throws RecordException {
        this.write(file, msg.getBytes());
    }

    public void write(String file, byte[] msg) throws RecordException {
        this.rs = this.OpenRMS(file);
        if (this.rs != null) {
            try {
                if (this.rs.getSize() > 0) {
                    this.rs.setRecord(1, msg, 0, msg.length);
                }
                this.rs.addRecord(msg, 0, msg.length);
            }
            catch (RecordStoreNotOpenException e) {
                throw new RecordException("RecordStoreNotOpenException");
            }
            catch (InvalidRecordIDException e) {
                throw new RecordException("InvalidRecordIDException");
            }
            catch (RecordStoreException e) {
                throw new RecordException("RecordStoreException");
            }
        } else {
            throw new RecordException("RMS is not exist!");
        }
    }

    public void writeBoolean(String file, boolean msg) throws RecordException {
        this.rs = this.OpenRMS(file);
        if (this.rs != null) {
            try {
                if (this.rs.getSize() > 0) {
                    if (msg) {
                        this.rs.setRecord(1, new byte[]{1}, 0, 1);
                    }
                    this.rs.setRecord(1, new byte[1], 0, 1);
                }
                if (msg) {
                    this.rs.addRecord(new byte[]{1}, 0, 1);
                }
                this.rs.addRecord(new byte[1], 0, 1);
            }
            catch (RecordStoreNotOpenException e) {
                throw new RecordException("RecordStoreNotOpenException");
            }
            catch (InvalidRecordIDException e) {
                throw new RecordException("InvalidRecordIDException");
            }
            catch (RecordStoreException e) {
                throw new RecordException("RecordStoreException");
            }
        } else {
            throw new RecordException("RMS is not exist!");
        }
    }

    public void addBoolean(String file, boolean msg) throws RecordException {
        this.rs = this.OpenRMS(file);
        if (this.rs != null) {
            try {
                if (this.rs.getSize() == 0) {
                    this.writeBoolean(file, msg);
                }
                byte[] b = this.rs.getRecord(1);
                byte[] temp = new byte[b.length + 1];
                int i = 0;
                while (i < b.length) {
                    temp[i] = b[i];
                    ++i;
                }
                temp[b.length] = msg ? (byte)1 : 0;
                this.rs.setRecord(1, temp, 0, temp.length);
            }
            catch (RecordStoreNotOpenException e) {
                throw new RecordException("RecordStoreNotOpenException");
            }
            catch (InvalidRecordIDException e) {
                throw new RecordException("InvalidRecordIDException");
            }
            catch (RecordStoreException e) {
                throw new RecordException("RecordStoreException");
            }
        } else {
            throw new RecordException("RMS is not exist!");
        }
    }

    public boolean readBoolean(String file, int id) throws RecordException {
        block6: {
            this.rs = this.OpenRMS(file);
            if (this.rs != null) {
                try {
                    byte[] b;
                    if (this.rs.getSize() > 0 && id < (b = this.rs.getRecord(1)).length) {
                        return b[id] == 1;
                    }
                    break block6;
                }
                catch (RecordStoreNotOpenException e) {
                    throw new RecordException("RecordStoreNotOpenException");
                }
                catch (InvalidRecordIDException e) {
                    throw new RecordException("InvalidRecordIDException");
                }
                catch (RecordStoreException e) {
                    throw new RecordException("RecordStoreException");
                }
            }
            throw new RecordException("RMS is not exist!");
        }
        throw new RecordException("Record not found");
    }

    public void writeInt(String file, int i) throws RecordException {
        this.rs = this.OpenRMS(file);
        if (this.rs != null) {
            try {
                byte[] b = this.toByteArray(i, this.bytes_int);
                if (this.rs.getSize() > 0) {
                    this.rs.setRecord(1, b, 0, this.bytes_int);
                }
                this.rs.addRecord(b, 0, this.bytes_int);
            }
            catch (RecordStoreNotOpenException e) {
                throw new RecordException("RecordStoreNotOpenException");
            }
            catch (InvalidRecordIDException e) {
                throw new RecordException("InvalidRecordIDException");
            }
            catch (RecordStoreException e) {
                throw new RecordException("RecordStoreException");
            }
        } else {
            throw new RecordException("RMS is not exist!");
        }
    }

    public void addInt(String file, int i) throws RecordException {
        this.rs = this.OpenRMS(file);
        if (this.rs != null) {
            try {
                if (this.rs.getSize() == 0) {
                    this.writeInt(file, i);
                }
                byte[] b = this.rs.getRecord(1);
                byte[] temp = new byte[((this.rs.getRecordSize(1) - 1) / this.bytes_int + 2) * this.bytes_int];
                int m = 0;
                while (m < b.length) {
                    temp[m] = b[m];
                    ++m;
                }
                m = 0;
                while (m < this.bytes_int) {
                    temp[temp.length - this.bytes_int + m] = (byte)(i % this.BYTE_MAX);
                    i /= this.BYTE_MAX;
                    ++m;
                }
                this.rs.setRecord(1, temp, 0, temp.length);
            }
            catch (RecordStoreNotOpenException e) {
                throw new RecordException("RecordStoreNotOpenException");
            }
            catch (InvalidRecordIDException e) {
                throw new RecordException("InvalidRecordIDException");
            }
            catch (RecordStoreException e) {
                throw new RecordException("RecordStoreException");
            }
        } else {
            throw new RecordException("RMS is not exist!");
        }
    }

    public int readInt(String file, int id) throws RecordException {
        block6: {
            this.rs = this.OpenRMS(file);
            if (this.rs != null) {
                try {
                    byte[] b;
                    if (this.rs.getSize() > 0 && id < (b = this.rs.getRecord(1)).length / this.bytes_int) {
                        int start = id * this.bytes_int;
                        return this.bytesToInt(b, start);
                    }
                    break block6;
                }
                catch (RecordStoreNotOpenException e) {
                    throw new RecordException("RecordStoreNotOpenException");
                }
                catch (InvalidRecordIDException e) {
                    throw new RecordException("InvalidRecordIDException");
                }
                catch (RecordStoreException e) {
                    throw new RecordException("RecordStoreException");
                }
            }
            throw new RecordException("RMS is not exist!");
        }
        throw new RecordException("Record not found");
    }

    public void writeLong(String file, long i) throws RecordException {
        this.rs = this.OpenRMS(file);
        if (this.rs != null) {
            try {
                byte[] b = this.toByteArray(i, this.bytes_long);
                if (this.rs.getSize() > 0) {
                    this.rs.setRecord(1, b, 0, this.bytes_long);
                }
                this.rs.addRecord(b, 0, this.bytes_long);
            }
            catch (RecordStoreNotOpenException e) {
                throw new RecordException("RecordStoreNotOpenException");
            }
            catch (InvalidRecordIDException e) {
                throw new RecordException("InvalidRecordIDException");
            }
            catch (RecordStoreException e) {
                throw new RecordException("RecordStoreException");
            }
        } else {
            throw new RecordException("RMS is not exist!");
        }
    }

    public void addLong(String file, long i) throws RecordException {
        this.rs = this.OpenRMS(file);
        if (this.rs != null) {
            try {
                if (this.rs.getSize() == 0) {
                    this.writeLong(file, i);
                }
                byte[] b = this.rs.getRecord(1);
                byte[] temp = new byte[((this.rs.getRecordSize(1) - 1) / this.bytes_long + 2) * this.bytes_long];
                int m = 0;
                while (m < b.length) {
                    temp[m] = b[m];
                    ++m;
                }
                m = 0;
                while (m < this.bytes_long) {
                    temp[temp.length - this.bytes_long + m] = (byte)(i % (long)this.BYTE_MAX);
                    i /= (long)this.BYTE_MAX;
                    ++m;
                }
                this.rs.setRecord(1, temp, 0, temp.length);
            }
            catch (RecordStoreNotOpenException e) {
                throw new RecordException("RecordStoreNotOpenException");
            }
            catch (InvalidRecordIDException e) {
                throw new RecordException("InvalidRecordIDException");
            }
            catch (RecordStoreException e) {
                throw new RecordException("RecordStoreException");
            }
        } else {
            throw new RecordException("RMS is not exist!");
        }
    }

    public long readLong(String file, int id) throws RecordException {
        block6: {
            this.rs = this.OpenRMS(file);
            if (this.rs != null) {
                try {
                    byte[] b;
                    if (this.rs.getSize() > 0 && id < (b = this.rs.getRecord(1)).length / this.bytes_long) {
                        int start = id * this.bytes_long;
                        return this.bytesToLong(b, start);
                    }
                    break block6;
                }
                catch (RecordStoreNotOpenException e) {
                    throw new RecordException("RecordStoreNotOpenException");
                }
                catch (InvalidRecordIDException e) {
                    throw new RecordException("InvalidRecordIDException");
                }
                catch (RecordStoreException e) {
                    throw new RecordException("RecordStoreException");
                }
            }
            throw new RecordException("RMS is not exist!");
        }
        throw new RecordException("Record not found");
    }

    public void writeIntArray(String file, int[] intArray) throws RecordException {
        this.rs = this.OpenRMS(file);
        if (this.rs != null) {
            try {
                byte[] b_length = this.toByteArray(intArray.length, this.bytes_int);
                byte[] b = new byte[intArray.length * this.bytes_int];
                int m = 0;
                while (m < intArray.length) {
                    byte[] temp = this.toByteArray(intArray[m], this.bytes_int);
                    int n = 0;
                    while (n < temp.length) {
                        b[m * this.bytes_int + n] = temp[n];
                        ++n;
                    }
                    ++m;
                }
                if (this.rs.getSize() > 0) {
                    this.rs.setRecord(1, b_length, 0, this.bytes_int);
                    this.rs.setRecord(2, b, 0, b.length);
                }
                this.rs.addRecord(b_length, 0, this.bytes_int);
                this.rs.addRecord(b, 0, b.length);
            }
            catch (RecordStoreNotOpenException e) {
                throw new RecordException("RecordStoreNotOpenException");
            }
            catch (InvalidRecordIDException e) {
                throw new RecordException("InvalidRecordIDException");
            }
            catch (RecordStoreException e) {
                throw new RecordException("RecordStoreException");
            }
        } else {
            throw new RecordException("RMS is not exist!");
        }
    }

    private byte[] toByteArray(long i, int bytes_to_split) {
        byte[] b = new byte[bytes_to_split];
        int m = 0;
        while (m < bytes_to_split) {
            b[m] = (byte)(i % (long)this.BYTE_MAX);
            i /= (long)this.BYTE_MAX;
            ++m;
        }
        return b;
    }

    private byte[] toByteArray(int i, int bytes_to_split) {
        byte[] b = new byte[bytes_to_split];
        int m = 0;
        while (m < bytes_to_split) {
            b[m] = (byte)(i % this.BYTE_MAX);
            i /= this.BYTE_MAX;
            ++m;
        }
        return b;
    }

    private int bytesToInt(byte[] b, int start) {
        int IntResult = 0;
        int IntTime = 1;
        int m = 0;
        while (m < this.bytes_int) {
            IntResult += b[start + m] * IntTime;
            IntTime *= this.BYTE_MAX;
            ++m;
        }
        return IntResult;
    }

    private long bytesToLong(byte[] b, int start) {
        long IntResult = 0L;
        long IntTime = 1L;
        int m = 0;
        while (m < this.bytes_long) {
            IntResult += (long)b[start + m] * IntTime;
            IntTime *= (long)this.BYTE_MAX;
            ++m;
        }
        return IntResult;
    }

    public int[] readIntArray(String file) throws RecordException {
        this.rs = this.OpenRMS(file);
        int[] array = null;
        if (this.rs != null) {
            try {
                if (this.rs.getSize() > 1) {
                    array = new int[this.bytesToInt(this.rs.getRecord(1), 0)];
                    int m = 0;
                    while (m < array.length) {
                        array[m] = this.bytesToInt(this.rs.getRecord(2), this.bytes_int * m);
                        ++m;
                    }
                    return array;
                }
            }
            catch (RecordStoreNotOpenException e) {
                throw new RecordException("RecordStoreNotOpenException");
            }
            catch (InvalidRecordIDException e) {
                throw new RecordException("InvalidRecordIDException");
            }
            catch (RecordStoreException e) {
                throw new RecordException("RecordStoreException");
            }
        }
        throw new RecordException("Record not found");
    }

    public void saveIntArry(String file, int id, int[] data) {
        this.rs = this.OpenRMS(file);
        if (this.rs != null) {
            try {
                byte[] b = new byte[data.length * this.bytes_int];
                int m = 0;
                while (m < data.length) {
                    byte[] temp = this.toByteArray(data[m], this.bytes_int);
                    int n = 0;
                    while (n < temp.length) {
                        b[m * this.bytes_int + n] = temp[n];
                        ++n;
                    }
                    ++m;
                }
                if (this.rs.getNumRecords() >= id) {
                    this.rs.setRecord(id, b, 0, b.length);
                } else {
                    this.rs.addRecord(b, 0, b.length);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void saveIntArrys(String file, Vector data) {
        this.rs = this.OpenRMS(file);
        if (this.rs != null) {
            int i = 0;
            while (i < data.size()) {
                this.saveIntArry(file, i + 1, (int[])data.elementAt(i));
                ++i;
            }
        }
    }

    public int[] readIntArray(String file, int id, int n) {
        this.rs = this.OpenRMS(file);
        int[] array = new int[n];
        try {
            if (this.rs != null) {
                int j = 0;
                while (j < array.length) {
                    array[j] = this.bytesToInt(this.rs.getRecord(id), this.bytes_int * j);
                    ++j;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return array;
    }

    public int[][] readIntArrays(String file, int n) {
        this.rs = this.OpenRMS(file);
        int[][] array = null;
        if (this.rs != null) {
            try {
                int length = this.rs.getNumRecords();
                System.out.println("rs\u7684\u5927\u5c0f\u662f:" + length);
                array = new int[length][n];
                int i = 0;
                while (i < array.length) {
                    int j = 0;
                    while (j < array[i].length) {
                        array[i][j] = this.bytesToInt(this.rs.getRecord(i + 1), this.bytes_int * j);
                        ++j;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return array;
    }

    class RecordException
    extends Exception {
        public RecordException(String string) {
            super(string);
        }
    }
}

