/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.tt;

import simple.input.Key;
import simple.input.Keys;
import simple.video.Graphics;
import simple.video.Image;
import sk.inlogic.tt.CMenuItem;
import sk.inlogic.tt.Common;
import sk.inlogic.tt.IMenuAnimationListener;
import sk.inlogic.tt.IMenuItemActivator;
import sk.inlogic.tt.IMenuItemRenderer;
import sk.inlogic.tt.IScreen;
import sk.inlogic.tt.MenuAnimation;
import sk.inlogic.tt.MenuSystem;
import sk.inlogic.tt.MyApplication;
import sk.inlogic.tt.Profile;
import sk.inlogic.tt.Resources;
import sk.inlogic.tt.ScreenMenu;
import sk.inlogic.tt.Texts;

public class ScreenSplash
implements IScreen,
IMenuItemActivator,
IMenuItemRenderer,
IMenuAnimationListener {
    final int MODE_VOID;
    final int MODE_LOADINGRES;
    public static final int MODE_LANGUAGES = 2;
    final int MODE_SOUNDS;
    final int MODE_SPLASH;
    final int MODE_TITLE;
    final int TIME_DELAY;
    public static int iMode;
    int iModeDelay;
    public static int iPosXBoard;
    public static int iPosYBoardShift;
    MyApplication pMyApplication = MyApplication.getInstance();
    MenuSystem pMenuSystem;
    private String soundText;
    private int iPosYSounds;
    private int iPosXSounds;
    int iStrechMenu = 4;
    boolean bFinishMove = false;

    public ScreenSplash() {
        this.MODE_VOID = 0;
        this.MODE_LOADINGRES = 1;
        this.MODE_SOUNDS = 3;
        this.MODE_SPLASH = 4;
        this.MODE_TITLE = 5;
        this.TIME_DELAY = 3000;
        iMode = 1;
    }

    private void prepareEnableSounds() {
        this.soundText = Texts.getString(1);
        this.iPosYSounds = Resources.iRightButtonY - Texts.getFontHeight() >> 1;
        this.iPosXSounds = Resources.iScreenW - Texts.getTextWidth(this.soundText) >> 1;
        Resources.prepareRightAndLeftButtons();
        this.pMenuSystem.reset();
        this.pMenuSystem.addMenuItem(new CMenuItem(this.soundText, this.iPosXSounds, this.iPosYSounds, Texts.getTextWidth(this.soundText), Texts.getFontHeight()));
        this.soundText = Texts.getString(7);
        this.iPosXSounds = Resources.iScreenW - Texts.getTextWidth(this.soundText) >> 1;
        this.pMenuSystem.addMenuItem(new CMenuItem(this.soundText, this.iPosXSounds, this.iPosYSounds + Texts.getFontHeight(), Texts.getTextWidth(this.soundText), Texts.getFontHeight()));
        Resources.iPosYList = (Resources.iScreenH >> 1) - Resources.pSprTable.getHeight() - (Texts.getFontHeight() >> 1);
        MenuAnimation.openMenu(this);
    }

    public void update(long lTick) {
        if (iMode == 4 && this.iModeDelay > 0) {
            this.iModeDelay = (int)((long)this.iModeDelay - lTick);
            if (this.iModeDelay <= 0) {
                this.nextMode();
                return;
            }
        }
        if (iMode == 1) {
            this.updateModeLoadingRes();
            return;
        }
        if (iMode == 2 || iMode == 3) {
            Resources.update();
        }
        MenuAnimation.update();
        this.pMyApplication.repaintScreen();
    }

    private void updateModeLoadingRes() {
        this.pMenuSystem = MenuSystem.getInstance();
        this.pMenuSystem.setMenuItemActivator(this);
        this.pMenuSystem.setMenuItemRenderer(this);
        Resources.loadInitialResources();
        this.prepareLanguageMenu();
        iMode = 2;
    }

    public void prepareLanguageMenu() {
        this.pMenuSystem.reset();
        Resources.loadMenuResources();
        Resources.prepareRightAndLeftButtons();
        iPosXBoard = Resources.iScreenW - Resources.pImgBoard.getWidth() >> 1;
        System.out.println("tu som :D");
        if (Resources.pImgBoard == null) {
            System.out.println("tu suasdasdadam :D");
            Resources.pImgBoard = new Image("/napis_bg.png");
        }
        if (Texts.pBitmapFont == null) {
            System.out.println("tu suasdasdadam :D");
        }
        iPosYBoardShift = Resources.pImgBoard.getHeight() - Texts.getFontHeight() >> 1;
        System.out.println("tu som :D 2");
        Resources.iPosYShiftBoardIcon = Texts.getFontHeight() - Resources.pSprCheck.getHeight() >> 1;
        int iHeight = Texts.getFontHeight();
        Resources.iPosYList = Resources.iRightButtonY - Resources.iHTable * 3 >> 1;
        int iGap = iHeight >> 2;
        int iPosY = Resources.iPosYList + (Resources.iHTable * 3 >> 1) - (iHeight << 1) - iHeight;
        Resources.iPosXList = Resources.iScreenW - Resources.pSprTable.getWidth() >> 1;
        this.pMenuSystem.addMenuItem(new CMenuItem(Texts.getLang(12), Resources.iScreenW - Texts.getTextWidth(Texts.getLang(12)) >> 1, iPosY, Texts.getTextWidth(Texts.getLang(12)), iHeight));
        this.pMenuSystem.addMenuItem(new CMenuItem(Texts.getLang(13), Resources.iScreenW - Texts.getTextWidth(Texts.getLang(13)) >> 1, iPosY += iHeight + iGap, Texts.getTextWidth(Texts.getLang(13)), iHeight));
        this.pMenuSystem.addMenuItem(new CMenuItem(Texts.getLang(14), Resources.iScreenW - Texts.getTextWidth(Texts.getLang(14)) >> 1, iPosY += iHeight + iGap, Texts.getTextWidth(Texts.getLang(14)), iHeight));
        this.pMenuSystem.addMenuItem(new CMenuItem(Texts.getLang(15), Resources.iScreenW - Texts.getTextWidth(Texts.getLang(15)) >> 1, iPosY += iHeight + iGap, Texts.getTextWidth(Texts.getLang(15)), iHeight));
        this.pMenuSystem.addMenuItem(new CMenuItem(Texts.getLang(16), Resources.iScreenW - Texts.getTextWidth(Texts.getLang(16)) >> 1, iPosY += iHeight + iGap, Texts.getTextWidth(Texts.getLang(16)), iHeight));
        MenuAnimation.openMenu(this);
    }

    public void paintScreen(Graphics g) {
        switch (iMode) {
            case 2: {
                this.paintModeLanguage(g);
                break;
            }
            case 3: {
                this.paintModeSounds(g);
                break;
            }
            case 4: {
                this.paintModeSplash(g);
                break;
            }
            case 5: {
                this.paintModeTitle(g);
            }
        }
    }

    private void paintModeLanguage(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, Resources.iScreenW, Resources.iScreenH);
        Resources.paintBackground(g);
        if (MenuAnimation.iState == 0) {
            Resources.paintList(g, Resources.iPosYList, 2);
        } else {
            Resources.paintList(g, Resources.iPosYList + Resources.iDspYIn, 2);
        }
        this.pMenuSystem.paintMenu(g);
        if (!Resources.bTouchActivated) {
            Resources.paintLeftMenuButton(g, 11);
        }
    }

    private void paintModeSounds(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, Resources.iScreenW, Resources.iScreenH);
        Resources.paintBackground(g);
        if (MenuAnimation.iState == 0) {
            Resources.paintList(g, Resources.iPosYList, 1);
        } else {
            Resources.paintList(g, Resources.iPosYList + Resources.iDspYIn, 1);
        }
        this.pMenuSystem.paintMenu(g);
        Resources.paintLeftMenuButton(g, 3);
        Resources.paintRightMenuButton(g, 4);
    }

    private void paintModeSplash(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, Resources.iScreenW, Resources.iScreenH);
        if (Resources.pImgSplash != null) {
            Resources.pImgSplash.drawAtPoint(g, 0, 0);
        }
    }

    private void paintModeTitle(Graphics g) {
        g.setColor(4913658);
        g.fillRect(0, 0, Resources.iScreenW, Resources.iScreenH);
        Texts.drawTextAtPos(g, 0, 0, "TITLE");
    }

    public void keyPressed(Key pKey) {
        if (MenuAnimation.iState != 0) {
            return;
        }
        switch (iMode) {
            case 2: {
                this.keyPressedModeLanguages(pKey);
                break;
            }
            case 3: {
                this.keyPressedModeSounds(pKey);
                break;
            }
            case 4: 
            case 5: {
                this.keyPressedModeSplash(pKey);
            }
        }
    }

    private void keyPressedModeLanguages(Key pKey) {
        if (MenuAnimation.iState != 0) {
            return;
        }
        if (pKey.iValue == Keys.KEY_FNLEFT || pKey.iGameAction == 8 || pKey.iValue == 53 || pKey.iValue == 100 || pKey.iValue == 68) {
            Resources.bButtonOut = true;
            this.pMenuSystem.activateSelectedMenuItem();
            return;
        }
        this.pMenuSystem.keyPressed(pKey);
    }

    void keyPressedModeSounds(Key pKey) {
        if (pKey.iValue == Keys.KEY_FNLEFT) {
            Profile.bMusic = true;
            Resources.bButtonOut = true;
            MenuAnimation.closeMenu(this);
            return;
        }
        if (pKey.iValue == Keys.KEY_FNRIGHT) {
            Resources.bButtonOut = true;
            Profile.bMusic = false;
            MenuAnimation.closeMenu(this);
        }
    }

    void keyPressedModeSplash(Key pKey) {
        if (pKey.iGameAction == 8 || pKey.iValue == 53 || pKey.iValue == 100) {
            this.nextMode();
        }
    }

    void nextMode() {
        this.iModeDelay = 3000;
        switch (iMode) {
            case 2: {
                Resources.loadSplashResources();
                iMode = 4;
                this.iModeDelay = 3000;
                break;
            }
            case 3: {
                Resources.releaseSplashResources();
                Profile.save();
                MyApplication.pScrMenu = new ScreenMenu();
                MyApplication.pActiveScreen = MyApplication.pScrMenu;
                MyApplication.pScrSplash = null;
                iMode = 0;
                System.gc();
                break;
            }
            case 4: {
                Resources.releaseSplashResources();
                this.prepareEnableSounds();
                iMode = 3;
            }
        }
    }

    public void keyReleased(Key pKey) {
    }

    public void pointerPressed(int x, int y) {
        Resources.bTouchActivated = true;
        if (iMode == 2) {
            this.pMenuSystem.pointerPressed(x, y);
            return;
        }
        if (iMode == 3) {
            Key pKey = new Key();
            if (Resources.pressedLeftButton(x, y, 80)) {
                pKey.iValue = Keys.KEY_FNLEFT;
                this.keyPressed(pKey);
                this.nextMode();
                return;
            }
            if (Resources.pressedRightButton(x, y)) {
                Profile.bMusic = false;
                this.nextMode();
                return;
            }
        }
        if (iMode == 4) {
            this.nextMode();
            return;
        }
    }

    public void pointerReleased(int x, int y) {
    }

    public void pointerDragged(int x, int y) {
    }

    public void onMenuItemActivated(int iIdx) {
        if (iMode == 2) {
            Texts.iLanguage = iIdx;
        }
        MenuAnimation.closeMenu(this);
    }

    public void renderMenuItem(Graphics g, CMenuItem pMenuItem, boolean bSelected) {
        int iDspY = 0;
        pMenuItem.iDspY = 0;
        if (MenuAnimation.iState != 0) {
            pMenuItem.iDspY = -pMenuItem.getTop() + Common.barValue(MenuAnimation.iStateOffsetActual, MenuAnimation.iStateOffsetDest, pMenuItem.getTop());
        }
        int iHCount = 0;
        int iStretch = 0;
        if (iMode != 3) {
            iHCount = 2;
            iDspY = Resources.renderBackPlace(g, pMenuItem, iHCount, Resources.iPosYList);
            if (bSelected) {
                iStretch = this.bFinishMove ? this.iStrechMenu - Common.barValue(this.pMenuSystem.iMenuChangingSelectedItemOffset, 10, this.iStrechMenu) : Common.barValue(this.pMenuSystem.iMenuChangingSelectedItemOffset, 10, this.iStrechMenu);
                if (iStretch == this.iStrechMenu && !this.bFinishMove) {
                    this.bFinishMove = true;
                    this.pMenuSystem.iMenuChangingSelectedItemOffset = 0;
                } else if (iStretch == 0 && this.bFinishMove) {
                    this.bFinishMove = false;
                    this.pMenuSystem.iMenuChangingSelectedItemOffset = 0;
                }
            }
        } else {
            iHCount = 1;
            iDspY = Resources.renderBackPlace(g, pMenuItem, iHCount, Resources.iPosYList);
        }
        g.setClipRegion(0, Resources.iPosYList, Resources.iScreenW, Resources.iHTable * (iHCount + 1));
        if (Resources.bTouchActivated) {
            Texts.drawTextAtPos(g, pMenuItem.getLeft(), pMenuItem.getTop() + iDspY, pMenuItem.getCaption());
        } else {
            Texts.drawTextAtPos(g, pMenuItem.getLeft(), pMenuItem.getTop() + iDspY, pMenuItem.getCaption());
            if (iMode == 2 && bSelected) {
                Resources.paintSprite(g, Resources.pSprCheck, 0, pMenuItem.getLeft() + (pMenuItem.getWidth() >> 1) - (Resources.pSprCheck.getWidth() >> 1), pMenuItem.getTop() + pMenuItem.getHeight());
            }
        }
        g.setClipRegion(0, 0, Resources.iScreenW, Resources.iScreenH);
    }

    public void onMenuClosed() {
        this.nextMode();
    }

    public void onMenuOpened() {
    }

    public void onMenuShiftedUp() {
    }

    public void onPause() {
    }

    public void onResume() {
    }

    public void onStart() {
    }
}

